/* -------------------------------------------------------------------------- *\
   pwirq.h -- ioctl API for userspace irq handling driver

   Copyright (c) 2007,2008 Pixelworks Inc.

   --------------------------------------------------------------------------
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   \* -------------------------------------------------------------------------- */
#ifndef __PWIRQ_H__
#define __PWIRQ_H__

#include <linux/types.h>
#include <linux/ioctl.h>

#define PWIRQ_NAME_LEN 20

/* Usage notes:
 * - The irq device can be opened multiple times,
 *   from multiple threads or processes. This is useful for
 *   assigning priorities by giving each process/thread an
 *   appropriate real-time priority level. The number of
 *   irq handling threads determines the number of supported
 *   irq priority levels.
 * - Each irq can only be handled by one thread/process, the
 *   others will get an EBUSY error when trying to grab the irq.
 */

struct pwirq_configuration {
       __u32 irq;                      // irq number
       char name[PWIRQ_NAME_LEN];      // for /proc/interrupts
};

// allocate and enable irq
#define PWIRQ_SET      _IOW('v', 1, struct pwirq_configuration)

// disable and free irq
#define PWIRQ_UNSET    _IOW('v', 2, __u32)

// temporarily disable irq
#define PWIRQ_DISABLE  _IOW('v', 3, __u32)

// reenable temporarily disabled irq
#define PWIRQ_ENABLE   _IOW('v', 4, __u32)

// wait for irq
#define PWIRQ_WAIT     _IOR('v', 5, __u32)

// must be called after PWIRQ_WAIT to re-enable irq after processing
#define PWIRQ_END      _IOW('v', 6, __u32)

#endif // __PWIRQ_H__
