/*
 * linux/include/asm-arm/arch-ruby/platform.h
 *
 * Copyright (C) 2007,2008 Pixelworks, Inc.
 * Copyright (c) ARM Limited 2003.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ASM_ARCH_PLATFORM_H
#define __ASM_ARCH_PLATFORM_H

#include <mach/sysmap.h>

#if defined(CONFIG_ARCH_PIXELWORKS_TOPAZ) || defined(CONFIG_ARCH_PIXELWORKS_TOPAZEH)

#define STATIC_REGS_BASE	PXLW_STATIC_REGS_V1_BASE
#define DMA8CH0_BASE		DMA_8CH_V1_BASE
#define GPIO0_BASE		GPIO0_V2_BASE
#define GPIO1_BASE		GPIO1_V2_BASE
#define GPIO2_BASE		GPIO2_V2_BASE
#define GPIO3_BASE		GPIO3_V2_BASE
#define GPIO4_BASE		GPIO4_V2_BASE
#define GPIO5_BASE		GPIO5_V2_BASE
#define GPIO6_BASE		GPIO6_V2_BASE
#define GPIO7_BASE		GPIO7_V2_BASE
#define GPIO8_BASE		GPIO8_V2_BASE
#define GPIO9_BASE		GPIO9_V2_BASE

#endif

#if defined(CONFIG_ARCH_PIXELWORKS_TOPAZ)

#define UART0_BASE		UART0_V2_BASE
#define UART1_BASE		UART1_V2_BASE
#define UART_BASE		UART0_BASE
#define WATCHDOG_BASE		WDOG_V1_BASE
#define SYS_BASE		SYS_V15_BASE
#define SPI0_BASE		SPI_V3_BASE
#define ETH0_BASE		ETH_MAC_V3_BASE

#elif defined(CONFIG_ARCH_PIXELWORKS_TOPAZEH)

#define GPIO10_BASE		GPIO10_V2_BASE
#define GPIO11_BASE		GPIO11_V2_BASE
#define GPIO12_BASE		GPIO12_V2_BASE
#define GPIO13_BASE		GPIO13_V2_BASE
#define GPIO14_BASE		GPIO14_V2_BASE
#define GPIO15_BASE		GPIO15_V2_BASE

#define UART0_BASE		UART0_V3_BASE
#define UART1_BASE		UART1_V3_BASE
#define UART2_BASE		UART2_V3_BASE
#define UART3_BASE		UART3_V3_BASE
#define UART4_BASE		UART4_V3_BASE
#define UART5_BASE		UART5_V3_BASE
#define UART_BASE		UART0_BASE
#define WATCHDOG_BASE		WDOG_V2_BASE
#define SYS_BASE		SYS_V20_BASE
#define SPI0_BASE		SPI0_V3_BASE
#define SPI1_BASE		SPI1_V3_BASE
#define ETH0_BASE		ETH_MAC_V4_BASE

#else
#error Unknown platform
#endif

#endif // __ASM_ARCH_PLATFORM_H
