/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef _IPC_WDOG
#define _IPC_WDOG

/* SoC Solutions IPC AMBA Watchdog Timer
 */

#define IPC_WDOG_LOAD		0x0000
#define IPC_WDOG_VALUE		0x0004
#define IPC_WDOG_CONTROL	0x0008
#define IPC_WDOG_KICK		0x000c
#define IPC_WDOG_STATUS		0x0010
#define IPC_WDOG_CLEAR		0x0014
#define IPC_WDOG_IRQVALUE	0x0018
#define IPC_WDOG_LOCK    	0x001c

#define IPC_WDOG_CONTROL_PRESCALE_NONE	(0 << 2)
#define IPC_WDOG_CONTROL_PRESCALE_16	(1 << 2)
#define IPC_WDOG_CONTROL_PRESCALE_32	(3 << 2)
#define IPC_WDOG_CONTROL_PRESCALE_128	(4 << 2)
#define IPC_WDOG_CONTROL_PRESCALE_256	(2 << 2)
#define IPC_WDOG_CONTROL_PRESCALE_1024	(5 << 2)
#define IPC_WDOG_CONTROL_PRESCALE_4096	(6 << 2)

#define IPC_WDOG_CONTROL_ENABLE		(1 << 7)
#define IPC_WDOG_CONTROL_RESEN 		(1 << 5)

#define IPC_WDOG_KICK_VALUE	0xa5a5
#define IPC_WDOG_UNLOCK         0x1ACCE551

#define IPC_WDOG_STATUS_RESET_OCCURED	(1 << 0)

#endif
