/*
 *  linux/include/asm-arm/arch-ruby/hardware.h
 *
 *  This file contains the hardware definitions of the Versatile boards.
 *
 *  Copyright (C) 2007 Pixelworks, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __ASM_ARCH_HARDWARE_H
#define __ASM_ARCH_HARDWARE_H

#include <mach/platform.h>

#ifdef CONFIG_ARCH_PIXELWORKS_TOPAZ
/* map system peripherals from 0xff000000...0xffffffff to 0xfe000000 */
/* (must leave space for high vectors) */
#define IO_ADDRESS(x) (x - 0x01000000)
#else
/* map system peripherals from 0xfe000000...0xffffffff 1:1 */
#define IO_ADDRESS(x) (x)
#endif

/* convert physical to virtual (mapped) IO address (for system periherals only) */
#define __io_address(n) IOMEM(IO_ADDRESS(n))

#endif
