/*
 *  Copyright (C) 2007-2012 Pixelworks, Inc.
 *  Copyright (C) 1999 - 2003 ARM Limited
 *  Copyright (C) 2000 Deep Blue Solutions Ltd
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <linux/init.h>
#include <linux/device.h>
#include <linux/dma-mapping.h>
#include <linux/interrupt.h>
#include <linux/of.h>
#include <linux/of_address.h>
#include <linux/of_irq.h>
#include <linux/of_platform.h>
#include <linux/stmmac.h>
#include <linux/amba/pl08x.h>
#include <linux/amba/serial.h>
#include <linux/aug0603.h>

#include <asm/system.h>
#include <asm/sizes.h>
#include <asm/io.h>
#include <asm/irq.h>
#include <asm/hardware/timer-sp.h>
#include <asm/hardware/vic.h>
#include <asm/hardware/pl080.h>
#include <asm/mach-types.h>
#include <asm/mach/arch.h>
#include <asm/mach/irq.h>
#include <asm/mach/time.h>
#include <asm/mach/map.h>

#include <mach/hardware.h>

#include "core.h"


/* DMA8CH peripheral connections */
#define DMA8CH_SEL_SPI_TX	0
#define DMA8CH_SEL_SPI_RX	1
#define DMA8CH_SEL_UART0_TX	2
#define DMA8CH_SEL_UART0_RX	3
#define DMA8CH_SEL_UART1_TX	4
#define DMA8CH_SEL_UART1_RX	5


static bool topaz_dma_filter(struct dma_chan *chan, void *filter_param)
{
	struct pl08x_dma_chan *plchan = container_of(chan, struct pl08x_dma_chan, chan);
	if (plchan->cd->min_signal == (int)filter_param)
		return true;
	return false;
}

struct amba_pl011_data topaz_uart0_plat_data = {
	.dma_filter = topaz_dma_filter,
	.dma_rx_param = (void *)DMA8CH_SEL_UART0_RX,
	.dma_tx_param = (void *)DMA8CH_SEL_UART0_TX,
};

struct amba_pl011_data topaz_uart1_plat_data = {
	.dma_filter = topaz_dma_filter,
	.dma_rx_param = (void *)DMA8CH_SEL_UART1_RX,
	.dma_tx_param = (void *)DMA8CH_SEL_UART1_TX,
};

struct aug0603_platform_data topaz_aug0603_pdata = {
	.dma_filter = topaz_dma_filter,
	.dma_rx_filter_param = (void *)DMA8CH_SEL_SPI_RX,
	.dma_tx_filter_param = (void *)DMA8CH_SEL_SPI_TX,
};

static int topaz_pl080_get_signal(struct pl08x_dma_chan *ch)
{
	return ch->cd->min_signal;
}

static const struct pl08x_channel_data topaz_dma8ch_channels[] = {
	{
		.bus_id = "spi_rx",
		.min_signal = DMA8CH_SEL_SPI_RX,
		.periph_buses = PL08X_AHB1 | PL08X_AHB2,
	},
	{
		.bus_id = "spi_tx",
		.min_signal = DMA8CH_SEL_SPI_TX,
		.periph_buses = PL08X_AHB1 | PL08X_AHB2,
	},
	{
		.bus_id = "uart0_rx",
		.min_signal = DMA8CH_SEL_UART0_RX,
		.periph_buses = PL08X_AHB1 | PL08X_AHB2,
	},
	{
		.bus_id = "uart0_tx",
		.min_signal = DMA8CH_SEL_UART0_TX,
		.periph_buses = PL08X_AHB1 | PL08X_AHB2,
	},
	{
		.bus_id = "uart1_rx",
		.min_signal = DMA8CH_SEL_UART1_RX,
		.periph_buses = PL08X_AHB1 | PL08X_AHB2,
	},
	{
		.bus_id = "uart1_tx",
		.min_signal = DMA8CH_SEL_UART1_TX,
		.periph_buses = PL08X_AHB1 | PL08X_AHB2,
	},
};

struct pl08x_platform_data topaz_dma8ch_pdata = {
	.slave_channels = topaz_dma8ch_channels,
	.num_slave_channels = ARRAY_SIZE(topaz_dma8ch_channels),
	.memcpy_channel = {
		.bus_id = "memcpy",
		.cctl = (PL080_BSIZE_16 << PL080_CONTROL_SB_SIZE_SHIFT | \
			 PL080_BSIZE_16 << PL080_CONTROL_DB_SIZE_SHIFT | \
			 PL080_WIDTH_32BIT << PL080_CONTROL_SWIDTH_SHIFT | \
			 PL080_WIDTH_32BIT << PL080_CONTROL_DWIDTH_SHIFT | \
			 PL080_CONTROL_PROT_BUFF | PL080_CONTROL_PROT_CACHE | \
			 PL080_CONTROL_PROT_SYS),
		.periph_buses = PL08X_AHB1 | PL08X_AHB2,
	},
	.lli_buses = PL08X_AHB1 | PL08X_AHB2,
	.mem_buses = PL08X_AHB1 | PL08X_AHB2,
	.get_signal = topaz_pl080_get_signal,
};
