/*
 * pwgpio.h -- Pixelworks gpio API
 *
 * Copyright (C) 2007-2012 Pixelworks Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __PWGPIO_H__
#define __PWGPIO_H__

#include <linux/ioctl.h>
#include <linux/types.h>

enum PWGPIO_IRQ_MODE {
	PWGPIO_IRQ_MODE_NONE,
	PWGPIO_IRQ_MODE_LEVEL_LOW,
	PWGPIO_IRQ_MODE_LEVEL_HIGH,
	PWGPIO_IRQ_MODE_EDGE_FALLING,
	PWGPIO_IRQ_MODE_EDGE_RISING,
	PWGPIO_IRQ_MODE_EDGE_BOTH
};

struct pwgpio_capabilitites {
	__u8 num_pins;		// number of pins (1..32)
};

struct pwgpio_config {
	__u32 pin_mask;		// bitmask of configured/allocated pins;
				// PWGPIO_CONFIGURE return EBUSY if one of the
				// pins is already in use
	__u32 is_output;	// gpio pin direction
	__u8 irq_mode[32];	// irq trigger mode;
				// if irqs are enabled poll/select and
				// PWGPIO_GETEVENT can be used
};

struct pwgpio_pin_value {
	__u32 pin_mask;
	__u32 pin_value;
};

//PWKK HZhou Add support for event processing
struct pwgpio_events_record {
        __u32   events;
        __u32   tickcount;
};
#define PWGPIO_EVENT_RECORD_MAX   128
struct pwgpio_events_history {
        __u32 events_num;
        struct pwgpio_events_record record[PWGPIO_EVENT_RECORD_MAX];
};

#define PWGPIO_CAPABILITIES _IOR('g', 0, struct pwgpio_capabilitites)
#define PWGPIO_CONFIGURE    _IOW('g', 1, struct pwgpio_config)
#define PWGPIO_SET          _IOW('g', 2, struct pwgpio_pin_value)
#define PWGPIO_GET          _IOWR('g', 3, struct pwgpio_pin_value)
#define PWGPIO_GETEVENT     _IOWR('g', 4, struct pwgpio_pin_value)

//PWKK HZhou Add support for event processing
#define PWGPIO_STARTMEASURING  _IOWR('g', 5, struct pwgpio_pin_value)
#define PWGPIO_GETFREQUENCY    _IOWR('g', 6, struct pwgpio_pin_value)
#define PWGPIO_GETEVENTHISTORY _IOWR('g', 7, struct pwgpio_events_history)

#endif // __PWGPIO_H__
