/* -------------------------------------------------------------------------- *\
   pw2wireslave.h -- ioctl API for pw2wireslave

   Copyright 2007-2013 Pixelworks Inc.

   Dual licensed: Either GPL or Pixelworks Proprietary (see below):
\* -------------------------------------------------------------------------- */

/* --------------------------------------------------------------------------
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\* -------------------------------------------------------------------------- */

// ---------------------------------------------------------------------------
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// ---------------------------------------------------------------------------
// Copyright 2006-2010 (c) Pixelworks Inc.
//
// Pixelworks owns the sole copyright to this software. Under international
// copyright laws you (1) may not make a copy of this software except for
// the purposes of maintaining a single archive copy, (2) may not derive
// works herefrom, (3) may not distribute this work to others. These rights
// are provided for information clarification, other restrictions of rights
// may apply as well.
//
// This is an unpublished work.
// ---------------------------------------------------------------------------
// >>>>>>>>>>>>>>>>>>>>>>>>>>>> WARRANTEE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// ---------------------------------------------------------------------------
// Pixelworks Inc. MAKES NO WARRANTY OF ANY KIND WITH REGARD TO THE USE OF
// THIS SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,
// THE IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
// PURPOSE.
// ---------------------------------------------------------------------------


#ifndef __PW2WIRESLAVE_H__
#define __PW2WIRESLAVE_H__

#include <linux/ioctl.h>
#include <linux/types.h>
#include "2wire_v1_ral.h"

#define DEFAULT_AUTOACK 1
#define DEFAULT_GENCALL 0
#define DEFAULT_ALLADDREN 0

struct pw2wireslave_config {
	__u8 autoack;		// AUTOACK Mode
	__u8 alladdren;		// All Slave Address Enable
	__u8 gencall;		// Slave General Call Enable
};

struct pw2wireslave_addressinfo {
	__u8 addrmode ;		// 0: 7 bit mode, 1: 10 bit mode;
	__u16 slavaddr;		// Slave Address
};

struct pw2wireslave_rdwr_data {
	__u16 addr;
	__u16 nLen;		// length;
	__u8 *buf;
};

struct pw2wireslave_allslaveaddr {
	__u16 *addr;		// store the address in all slave mode
	int nslave;		// number of slave to be supported
};

struct pw2wireslave_Getdatainfo{
	__u8   cFlag;		// Finished transfer
	__u16  cAddr;		// The addr Master is operating
	__u16  uReceivedCount;
};

#define PW2WIRESLAVE_ADDRSETTING  _IOW('g', 0, struct pw2wireslave_addressinfo)
#define PW2WIRESLAVE_CONFIGURE    _IOW('g', 1, struct pw2wireslave_config)
#define PW2WIRESLAVE_XDATASET     _IOW('g', 2, struct pw2wireslave_rdwr_data)
#define PW2WIRESLAVE_DATAGET      _IOR('g', 3, __u8*)
#define PW2WIRESLAVE_ALLSLAVEADDR _IOW('g', 4, struct pw2wireslave_allslaveaddr)
#define PW2WIRESLAVE_MASTEWRITE_DATAREADY     _IOR('g', 5, __u32)
#define PW2WIRESLAVE_XDATAINFO    _IOR('g', 6, struct pw2wireslave_Getdatainfo)


#endif // __PW2WIRESLAVE_H__
