/* ------------------------------------------------------------------------- */
/* pw2wire.h Two Wire driver algorithms for Pixelworks Ruby Two Wire adapters                 */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1995-97 Simon G. Vogl
                   1998-99 Hans Berglund

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.                */
/* ------------------------------------------------------------------------- */


/* Modifications by Pixelworks Inc, 2008
   Changes made to support the Pixelworks Ruby Two Wire peripheral */


#ifndef __PW_2WIRE_H__
#define __PW_2WIRE_H__

#include <linux/i2c.h>
#include <linux/i2c-dev.h>

#include "types.h"

#define PW2WIRE_WAITTIME    0x580
#define PW2WIRE_CONFIGURE   0x480    /* CONFIGURE ioctl command */
#define PW2WIRE_SPEED       0x380    /* SPEED ioctl command */
#define PW2WIRE_RESET       0x280    /* RESET ioctl command */
#define PW2WIRE_STATUS      0x180    /* STATUS ioctl command */
struct pw2wire_fifoinfo {
 __u32 rfifodepth;
 __u32 rfifocnt;
 __u32 wfifodepth;
 __u32 wfifocnt;
 __u32 bussts;
 __u32 errflag;
 __u32 ipid;
__u8   rev;
 };

struct pw2wire_confinfo {
 __u16 u2wire_speed;
 __u8 rthreshold;
 __u8 wthreshold;
 __u8 c2wire_autohold;
 };

struct pw2wire_timeoutconfinfo {
    __u32     ici_dwRetry;              //!< Retry number for access device
    __u32     ici_dwTimeWaitData;       //!< Timeout setting for Data Receive
    __u32     ici_dwTimeWaitTransfer;   //!< Delay setting for between transcations
    __u32     ici_dwTimeWaitSlaveAddr;  //!< Wait Time setting for Slave Address
    __u32     ici_dwTimeWaitFifoFull;   //!< Wait Time setting for FIFO FULL, Only for Hardware 2Wire
    __u32     ici_dwTimeWaitFifoEmpty;  //!< Wait Time setting for FIFO EMPTY for Hardware 2Wire
 };


enum {
    ERR_NO_ERR              = 0x00000000,
    ERR_NO_PLATFORM_DEVICE  = 0x00000001,
    ERR_REQUEST_RESOURCE    = 0x00000002,
    ERR_READ                = 0x00000004,
    ERR_WRITE               = 0x00000008,
    ERR_INVALID_DEVICE      = 0x00000010,
    ERR_BUS                 = 0x00000020,
};

enum {
    STATUS_OK               = 0x00,
    STATUS_ERR              = 0x01,
    STATUS_BUS_BUSY         = 0x02,
    STATUS_HALT_LOST_ARBI   = 0x04,
    STATUS_HALT_GOT_NACK    = 0x08,
};


enum {
    FREQ_100KHZ = 100,
    FREQ_400KHZ = 400,
    //Ruby C0
    FREQ_125KHZ = 125,
    FREQ_150KHZ = 150,
    FREQ_175KHZ = 175,
    FREQ_200KHZ = 200,
    FREQ_225KHZ = 225,
    FREQ_250KHZ = 250,
    FREQ_275KHZ = 275,
    FREQ_300KHZ = 300,
    FREQ_325KHZ = 325,
    FREQ_350KHZ = 350,
    FREQ_375KHZ = 375,
    FREQ_600KHZ = 600,
    FREQ_800KHZ = 800,
    FREQ_1000KHZ = 1000,
    //Topaz
    FREQ_25KHZ  = 25,
    FREQ_50KHZ  = 50,
    FREQ_75KHZ  = 75,

    FREQ_DEFAULT = 0
};

enum {
    R_FIFO_THRESHOLD_16,
    R_FIFO_THRESHOLD_15,
    R_FIFO_THRESHOLD_12,
    R_FIFO_THRESHOLD_8,
    R_FIFO_THRESHOLD_INVALID,
    W_FIFO_THRESHOLD_0 = R_FIFO_THRESHOLD_16,
    W_FIFO_THRESHOLD_1 = R_FIFO_THRESHOLD_15,
    W_FIFO_THRESHOLD_4 = R_FIFO_THRESHOLD_12,
    W_FIFO_THRESHOLD_8 = R_FIFO_THRESHOLD_8,
    W_FIFO_THRESHOLD_INVALID = R_FIFO_THRESHOLD_INVALID
};

#define DEFAULT_TIMEOUT 50 
#define DEFAULT_RETRY   8

#define PW_HW_2WIRE_COMMUNICATION_ERROR 0x1000  /* Communication error */

#define I2C_M_400K      0x02
#define I2C_M_NO_STOP   0x100   /* Force no stop */
#define I2C_M_FORCE_ACK 0x200   /* Force to send ACK when READ */


#endif /* __PW_2WIRE_H__ */
