INSTALL_DESTDIR := ${SW_STAGING_DIR}
CC 	:= ${.CROSS}gcc

# define a default including paths for SDL_image and PW_image
CC_INC_SDL_IMG_PATHS := -I${SW_LIBRARIES_LGPL_PATH}/sdl/v2/sdllib/include/SDL \
			-I${SW_LIBRARIES_OSS_PW_PATH}/UNJ_Library_API/include \
			-I${SW_LIBRARIES_LGPL_PATH}/sdl_image/v1 \
			-I${SW_LIBRARIES_OSS_PW_PATH}/pw_image_API/include
				
ifeq ($(TARGET_TOOL_CHAIN),thumb-uclibc)
CC_INC_SDL_IMG_PATHS += -mthumb
endif

ifeq ($(TOPAZ_PCS),1)
PNG_LIBS := ${SW_STAGING_DIR}/lib
else
PNG_LIBS := ${SW_LIBRARIES_OTHER_PATH}/libpng/v1/libpng-1.2.35/lib
endif

ifeq ($(PROJECT),topazeh)
PNG_LIBS := ${SW_STAGING_DIR}/lib
endif

CC_INC_PW_IMG_PATHS := 

ifeq (${TARGET_CHIP},ruby_c0)
#   
#  Ruby C0
#
CC_DEF_PW_IMG_LIBS := -DLOAD_PHJ -DLOAD_JPG -DLOAD_PNG -DLOAD_TIF -DLOAD_BMP -DLOAD_GIF
else

ifeq (${TARGET_CHIP},Topaz)			
#
# Topaz
#
CC_DEF_PW_IMG_LIBS := -DTOPAZ -DLOAD_PHJ -DLOAD_JPG -DLOAD_PNG -DLOAD_TIF -DLOAD_BMP -DLOAD_GIF
else
#
# Ruby
#
CC_DEF_PW_IMG_LIBS := -DPW_FB_UYV444B -DLOAD_PHJ -DLOAD_JPG -DLOAD_PNG -DLOAD_TIF -DLOAD_BMP -DLOAD_GIF
endif

endif

ifeq (${TARGET_CHIP},topazeh)
#
# topazeh
#
CC_DEF_PW_IMG_LIBS := -DTOPAZ_ENHANCE -DLOAD_PHJ -DLOAD_JPG -DLOAD_PNG -DLOAD_TIF -DLOAD_BMP -DLOAD_GIF
endif

# the dynamic seems bug on our system. Disable it temporary until we fix it. 
# -DLOAD_JPG_DYNAMIC=\"libjpeg.so\" -DLOAD_PNG_DYNAMIC=\"libpng.so\" -DLOAD_TIF_DYNAMIC=\"libtiff.so\"

sw_all: image install

image : .image.timestamp

.image.timestamp:
	
	${CC} ${CC_DEF_PW_IMG_LIBS} ${CC_INC_SDL_IMG_PATHS} -fPIC -g -c IMG.c

	# load dummy wrap software decoders
	${CC} ${CC_DEF_PW_IMG_LIBS} ${CC_INC_PW_IMG_PATHS} ${CC_INC_SDL_IMG_PATHS} -fPIC  -c IMG_gif.c
	${CC} ${CC_DEF_PW_IMG_LIBS} ${CC_INC_PW_IMG_PATHS} ${CC_INC_SDL_IMG_PATHS} -fPIC  -c IMG_bmp.c
	${CC} ${CC_DEF_PW_IMG_LIBS} ${CC_INC_PW_IMG_PATHS} ${CC_INC_SDL_IMG_PATHS} -fPIC  -c IMG_lbm.c
	${CC} ${CC_DEF_PW_IMG_LIBS} ${CC_INC_PW_IMG_PATHS} ${CC_INC_SDL_IMG_PATHS} -fPIC  -c IMG_pcx.c
	${CC} ${CC_DEF_PW_IMG_LIBS} ${CC_INC_PW_IMG_PATHS} ${CC_INC_SDL_IMG_PATHS} -fPIC  -c IMG_pnm.c
	${CC} ${CC_DEF_PW_IMG_LIBS} ${CC_INC_PW_IMG_PATHS} ${CC_INC_SDL_IMG_PATHS} -fPIC  -c IMG_tga.c
	${CC} ${CC_DEF_PW_IMG_LIBS} ${CC_INC_PW_IMG_PATHS} ${CC_INC_SDL_IMG_PATHS} -fPIC  -c IMG_xcf.c
	${CC} ${CC_DEF_PW_IMG_LIBS} ${CC_INC_PW_IMG_PATHS} ${CC_INC_SDL_IMG_PATHS} -fPIC  -c IMG_xpm.c
	${CC} ${CC_DEF_PW_IMG_LIBS} ${CC_INC_PW_IMG_PATHS} ${CC_INC_SDL_IMG_PATHS} -fPIC  -c IMG_xv.c
	${CC} ${CC_DEF_PW_IMG_LIBS} ${CC_INC_PW_IMG_PATHS} ${CC_INC_SDL_IMG_PATHS} -fPIC  -c IMG_xxx.c

	# Allen K, supported software decoders
	${CC} ${CC_DEF_PW_IMG_LIBS} ${CC_INC_SDL_IMG_PATHS} \
		-I${JPEG_INC} -fPIC -c IMG_jpg.c
	${CC} ${CC_DEF_PW_IMG_LIBS} ${CC_INC_SDL_IMG_PATHS} \
		-I${PNG_INC} \
		-I${ZLIB_INC} -fPIC  -c IMG_png.c
	${CC} ${CC_DEF_PW_IMG_LIBS} ${CC_INC_SDL_IMG_PATHS} \
		-I${TIFF_INC} -fPIC  -c IMG_tif.c

	${CC} -shared -Wl,-soname,libSDLImage.so.1 -o libSDLImage.so.1.0.1 \
		IMG.o IMG_jpg.o IMG_png.o IMG_gif.o IMG_bmp.o \
		IMG_lbm.o IMG_pcx.o IMG_pnm.o IMG_tga.o IMG_tif.o IMG_xcf.o IMG_xpm.o IMG_xv.o IMG_xxx.o \
		-lc -L${PNG_LIBS} -lpng -L${SW_LIBRARIES_LGPL_PATH}/sdl/v2/sdllib/lib -lSDL \
		-lpthread 

	${MKDIR} sdlimagelib
	${CP} ./libSDLImage.so.1.0.1 sdlimagelib
	ln -sf ./libSDLImage.so.1.0.1 sdlimagelib/libSDLImage.so.1
	ln -sf ./libSDLImage.so.1.0.1 sdlimagelib/libSDLImage.so
#	${MKDIR} ${INSTALL_DESTDIR}/lib/sdl/lib/ -p
	${CP} sdlimagelib/* ${INSTALL_DESTDIR}/lib -a -P
	@touch $@

install: .install.timestamp
.install.timestamp:
#	$(call sw_package_install)
	@touch $@

sw_clean:
	${RM} .*.timestamp
	${RM} *.o

sw_veryclean: sw_clean
	$(RM) -rf sdlimagelib
	$(RM) libSDLImage.so.1.0.1
