/*
    SDL_image:  An example image loading library for use with SDL
    Copyright (C) 1997-2009 Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    Sam Lantinga
    slouken@libsdl.org
*/

/* A simple library to load images of various formats as SDL surfaces */

#ifndef _SDL_IMAGE_H
#define _SDL_IMAGE_H

#include "SDL.h"
#include "SDL_version.h"
#include "begin_code.h"

/* Set up for C function definitions, even when using C++ */
#ifdef __cplusplus
extern "C" {
#endif

// Enable for debug message
#define DEBUG

#if defined(_DEBUG) || defined(DEBUG)
#define IMG_TRACE(...)	\
				printf("(%s, %d) ", __PRETTY_FUNCTION__, __LINE__);\
				printf(__VA_ARGS__)
#else
#define IMG_TRACE(...)
#endif

//
// Max Supported Resolution
//
// Topaz Enahnce platform to have better resolution since higher CPU clock.  Please ensure system mmeory has at least free 1920x1200x4 bytes memory for it.
// 
#if defined(TOPAZ_ENHANCE)

#define IMG_TIF_MAX_WIDTH					1920
#define IMG_TIF_MAX_HEIGHT					1200

#define IMG_TIF_MIN_WIDTH					1
#define IMG_TIF_MIN_HEIGHT					1

#define IMG_JPG_MAX_WIDTH					10000
#define IMG_JPG_MAX_HEIGHT					10000

#define IMG_JPG_MIN_WIDTH					8
#define IMG_JPG_MIN_HEIGHT					8

#define IMG_JPG_PROGRESSIVE_MAX_WIDTH		1920
#define IMG_JPG_PROGRESSIVE_MAX_HEIGHT		1200

#define IMG_JPG_PROGRESSIVE_MIN_WIDTH		8
#define IMG_JPG_PROGRESSIVE_MIN_HEIGHT		8

#define IMG_BMP_MAX_WIDTH					1920
#define IMG_BMP_MAX_HEIGHT					1200

#define IMG_BMP_MIN_WIDTH					1
#define IMG_BMP_MIN_HEIGHT					1

#define IMG_GIF_MAX_WIDTH					1920
#define IMG_GIF_MAX_HEIGHT					1200

#define IMG_GIF_MIN_WIDTH					1
#define IMG_GIF_MIN_HEIGHT					1

#define IMG_PNG_MAX_WIDTH					1920
#define IMG_PNG_MAX_HEIGHT					1200

#define IMG_PNG_MIN_WIDTH					1
#define IMG_PNG_MIN_HEIGHT					1

#else  // Other platform

#define IMG_TIF_MAX_WIDTH					800
#define IMG_TIF_MAX_HEIGHT					600

#define IMG_TIF_MIN_WIDTH					1
#define IMG_TIF_MIN_HEIGHT					1

#define IMG_JPG_MAX_WIDTH					10000
#define IMG_JPG_MAX_HEIGHT					10000

#define IMG_JPG_MIN_WIDTH					8
#define IMG_JPG_MIN_HEIGHT					8

#define IMG_JPG_PROGRESSIVE_MAX_WIDTH		1280    // was utilSystemMetricsGet(smScreenWidth)
#define IMG_JPG_PROGRESSIVE_MAX_HEIGHT		768     // was utilSystemMetricsGet(smScreenHeight)

#define IMG_JPG_PROGRESSIVE_MIN_WIDTH		8
#define IMG_JPG_PROGRESSIVE_MIN_HEIGHT		8

#define IMG_BMP_MAX_WIDTH					1280    // was utilSystemMetricsGet(smScreenWidth)
#define IMG_BMP_MAX_HEIGHT					768     // was utilSystemMetricsGet(smScreenHeight)

#define IMG_BMP_MIN_WIDTH					1
#define IMG_BMP_MIN_HEIGHT					1

#define IMG_GIF_MAX_WIDTH					1024	// was utilSystemMetricsGet(smScreenWidth)
#define IMG_GIF_MAX_HEIGHT					768		// was utilSystemMetricsGet(smScreenHeight)

#define IMG_GIF_MIN_WIDTH					1
#define IMG_GIF_MIN_HEIGHT					1

#define IMG_PNG_MAX_WIDTH					1280    // was utilSystemMetricsGet(smScreenWidth)
#define IMG_PNG_MAX_HEIGHT					768     // was utilSystemMetricsGet(smScreenHeight)

#define IMG_PNG_MIN_WIDTH					1
#define IMG_PNG_MIN_HEIGHT					1

#endif

// Support partial deocde 
//#define IMG_PARTIAL_DECODE                1


/* Printable format: "%d.%d.%d", MAJOR, MINOR, PATCHLEVEL
*/
#define SDL_IMAGE_MAJOR_VERSION		1
#define SDL_IMAGE_MINOR_VERSION		2
#define SDL_IMAGE_PATCHLEVEL		7

#define SDL_IMAGE_LOAD_NEW_SURFACE	0
#define SDL_IMAGE_LOAD_PWSURFACE	1
#define SDL_IMAGE_LOAD_SCREEN		2


/* This macro can be used to fill a version structure with the compile-time
 * version of the SDL_image library.
 */
#define SDL_IMAGE_VERSION(X)						\
{									\
	(X)->major = SDL_IMAGE_MAJOR_VERSION;				\
	(X)->minor = SDL_IMAGE_MINOR_VERSION;				\
	(X)->patch = SDL_IMAGE_PATCHLEVEL;				\
}

/* This function gets the version of the dynamically linked SDL_image library.
   it should NOT be used to fill a version structure, instead you should
   use the SDL_IMAGE_VERSION() macro.
 */
extern DECLSPEC const SDL_version * SDLCALL IMG_Linked_Version(void);

/* Load an image from an SDL data source.
   The 'type' may be one of: "BMP", "GIF", "PNG", etc.

   If the image format supports a transparent pixel, SDL will set the
   colorkey for the surface.  You can enable RLE acceleration on the
   surface afterwards by calling:
	SDL_SetColorKey(image, SDL_RLEACCEL, image->format->colorkey);
 */
extern DECLSPEC SDL_Surface * SDLCALL IMG_LoadTyped_RW(SDL_RWops *src, int freesrc, char *type,int load_mode);
/* Convenience functions */
extern DECLSPEC SDL_Surface * SDLCALL IMG_Load(const char *file);
extern DECLSPEC SDL_Surface * SDLCALL IMG_Load_RW(SDL_RWops *src, int freesrc);
extern DECLSPEC SDL_Surface * SDLCALL IMG_Load_Type(const char *file,int load_type);

/* Invert the alpha of a surface for use with OpenGL
   This function is now a no-op, and only provided for backwards compatibility.
*/
extern DECLSPEC int SDLCALL IMG_InvertAlpha(int on);

/* Functions to detect a file type, given a seekable source */
extern DECLSPEC int SDLCALL IMG_isBMP(SDL_RWops *src);
extern DECLSPEC int SDLCALL IMG_isGIF(SDL_RWops *src);
extern DECLSPEC int SDLCALL IMG_isJPG(SDL_RWops *src);
extern DECLSPEC int SDLCALL IMG_isLBM(SDL_RWops *src);
extern DECLSPEC int SDLCALL IMG_isPCX(SDL_RWops *src);
extern DECLSPEC int SDLCALL IMG_isPNG(SDL_RWops *src);
extern DECLSPEC int SDLCALL IMG_isPNM(SDL_RWops *src);
extern DECLSPEC int SDLCALL IMG_isTIF(SDL_RWops *src);
extern DECLSPEC int SDLCALL IMG_isXCF(SDL_RWops *src);
extern DECLSPEC int SDLCALL IMG_isXPM(SDL_RWops *src);
extern DECLSPEC int SDLCALL IMG_isXV(SDL_RWops *src);
extern DECLSPEC int SDLCALL IMG_isPHJ(SDL_RWops *src);

/* Individual loading functions */
extern DECLSPEC SDL_Surface * SDLCALL IMG_LoadBMP_RW(SDL_RWops *src,int type);
extern DECLSPEC SDL_Surface * SDLCALL IMG_LoadGIF_RW(SDL_RWops *src,int type);
extern DECLSPEC SDL_Surface * SDLCALL IMG_LoadJPG_RW(SDL_RWops *src,int type);
extern DECLSPEC SDL_Surface * SDLCALL IMG_LoadLBM_RW(SDL_RWops *src,int type);
extern DECLSPEC SDL_Surface * SDLCALL IMG_LoadPCX_RW(SDL_RWops *src,int type);
extern DECLSPEC SDL_Surface * SDLCALL IMG_LoadPNG_RW(SDL_RWops *src,int type);
extern DECLSPEC SDL_Surface * SDLCALL IMG_LoadPNM_RW(SDL_RWops *src,int type);
extern DECLSPEC SDL_Surface * SDLCALL IMG_LoadTGA_RW(SDL_RWops *src,int type);
extern DECLSPEC SDL_Surface * SDLCALL IMG_LoadTIF_RW(SDL_RWops *src,int type);
extern DECLSPEC SDL_Surface * SDLCALL IMG_LoadXCF_RW(SDL_RWops *src,int type);
extern DECLSPEC SDL_Surface * SDLCALL IMG_LoadXPM_RW(SDL_RWops *src,int type);
extern DECLSPEC SDL_Surface * SDLCALL IMG_LoadXV_RW(SDL_RWops *src,int type);
extern DECLSPEC SDL_Surface * SDLCALL IMG_LoadPHJ_RW(SDL_RWops *src,int type);

extern DECLSPEC SDL_Surface * SDLCALL IMG_ReadXPMFromArray(char **xpm);

/* We'll use SDL for reporting errors */
#define IMG_SetError	SDL_SetError
#define IMG_GetError	SDL_GetError

/* Ends C function definitions when using C++ */
#ifdef __cplusplus
}
#endif
#include "close_code.h"

#endif /* _SDL_IMAGE_H */
