#barebox v3  
APP_ARCH    := arm
APP_CROSS   := ${.CROSS} 


sw_all                : image sw_install
sw_clean sw_cleanhere : clean
sw_veryclean          : veryclean

PACKAGE_BASE := ${APP_NAME}
PACKAGE_OPTS := ARCH=${APP_ARCH} CROSS_COMPILE=${APP_CROSS} \
	SW_COMMON_INSTALL_DEST=$(SW_COMMON_INSTALL_DEST)

DEFCONFIG := pixelworks_topazeh_eval_defconfig


.PHONY: unpack apply unapply menuconfig image clean realclean veryclean

ifeq ($(wildcard ${APP_NAME}/.git),)
unpack: .unpack
.unpack: ${APP_TAR} ${APP_PATCHES}
	@echo "Preparing BareBox ${APP_VERSION} sources"
	$(call sw_package_unpack,${APP_TAR}, \
	  ${APP_PATCHES}, \
	  ${APP_NAME} \
	 )
	@$(call sw-say-and-do,APPLY,$(SHELL) apply-patch-series.sh ${APP_NAME} patches)
	$(call sw_package_build,${DEFCONFIG})
	@touch $@

apply:
	@$(call sw-say-and-do,APPLY,$(SHELL) apply-patch-series.sh ${APP_NAME} patches)
unapply:
	@$(call sw-say-and-do,UNAPPLY,$(SHELL) unapply-patch-series.sh ${APP_NAME} patches)
else
$(info Using git tree)
unpack: .unpack
.unpack:
	$(call sw_package_build,${DEFCONFIG})
	touch $@
endif

menuconfig: .unpack
	$(call sw_package_build,menuconfig)

# this allows calling arbitrary kernel make targets,
# e.g. "make L T=savedefconfig"
L:
	$(call sw_package_build,$(T))

image: .image
.image: .unpack
	$(call sw_package_build)
ifeq ($(wildcard ${APP_NAME}/.git),)
	touch $@
endif

${APP_NAME}/barebox.bin: image
$(call sw_install,${APP_NAME}/barebox.bin,${SW_INSTALL_IMG_DEST})

clean:
	$(call sw_package_build,clean)
	rm -f .image pax_global_header

realclean veryclean:
	rm -f .image .unpack pax_global_header
ifeq ($(wildcard ${APP_NAME}/.git),)
	rm -rf ${APP_NAME}
endif
