#ifndef __TW_V1_REGS_H__
#define __TW_V1_REGS_H__



// --------------------------------------------------------------------------
//
// tw_v1_ral.h
//
// Copyright 2010 Pixelworks Inc.
// This file is licensed under version 2 of GPL only when included in
// Linux kernel and Linux kernel driver files.
//
// In all other cases it is licensed under the terms of a separate,
// written license from Pixelworks, Inc..
// See below for more details.
//
//
// --------------------------------------------------------------------------
//
// --------------------------------------------------------------------------
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
//
// ---------------------------------------------------------------------------
//
// ---------------------------------------------------------------------------
// >>>>>>>>>>>>>>>>>>>>>>>>> COPYRIGHT NOTICE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// ---------------------------------------------------------------------------
// Copyright 2006-2010 (c) Pixelworks Inc.
//
// Pixelworks owns the sole copyright to this software. Under international
// copyright laws you (1) may not make a copy of this software except for
// the purposes of maintaining a single archive copy, (2) may not derive
// works herefrom, (3) may not distribute this work to others. These rights
// are provided for information clarification, other restrictions of rights
// may apply as well.
//
// This is an unpublished work.
// ---------------------------------------------------------------------------
// >>>>>>>>>>>>>>>>>>>>>>>>>>>> WARRANTEE <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
// ---------------------------------------------------------------------------
// Pixelworks Inc. MAKES NO WARRANTY OF ANY KIND WITH REGARD TO THE USE OF
// THIS SOFTWARE, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO,
// THE IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
// PURPOSE.
// ---------------------------------------------------------------------------


/*************************************************************************
 WARNING: This is a script-generated file and should not be hand-modified
 Date/Time: Tue, 13 Jun 2017 12:48:11 +0000
*************************************************************************/

#ifndef __RALTYPEDEFINITIONS_REGS_H__
#define __RALTYPEDEFINITIONS_REGS_H__
#ifdef NATIVE
typedef unsigned char RALuint8;
typedef unsigned short RALuint16;
typedef unsigned long RALuint24;
typedef unsigned long RALuint32;
#else
typedef unsigned char RALuint8;
typedef unsigned short RALuint16;
typedef unsigned int RALuint24;
typedef unsigned int RALuint32;
#endif
#endif

/* Expected function prototypes
eRESULT RegRead8(void *BlkInfo, uint32 Addr, *uint8 Value);
eRESULT RegRead16(void *BlkInfo, uint32 Addr, *uint16 Value);
eRESULT RegRead24(void *BlkInfo, uint32 Addr, *uint32 Value);
eRESULT RegRead32(void *BlkInfo, uint32 Addr, *uint32 Value);
eRESULT RegWrite8(void *BlkInfo, uint32 Addr, uint8 Mask, uint8 Value);
eRESULT RegWrite16(void *BlkInfo, uint32 Addr, uint16 Mask, uint16 Value);
eRESULT RegWrite24(void *BlkInfo, uint32 Addr, uint32 Mask, uint32 Value);
eRESULT RegWrite32(void *BlkInfo, uint32 Addr, uint32 Mask, uint32 Value);
eRESULT RegWriteArray(void *BlkInfo, pREGENTRY psEntryArray, RALuint16 wElemCount);
eRESULT RegWriteBlock(void *BlkInfo, RALuint32 dwOffset, void *pArray, RALuint16 wCount, BOOL sIncDest, BOOL sIncSource, RALuint8 cArraySize, BYTE cRegSize);
eRESULT RegReadBlock(void *BlkInfo, RALuint32 dwOffset, void *pArray, RALuint16 wCount, BOOL sIncSource, RALuint8 cArraySize, RALuint8 cRegSize);
*/


#ifndef __RALARRAYBLOCK_REGS_H__
#define __RALARRAYBLOCK_REGS_H__
#define ARRAYSET(BlkInfo, pRegEntry, wCount) \
{ \
(BlkInfo)->errorState = (BlkInfo)->RegWriteArray(BlkInfo, pRegEntry, wCount);\
}

#define BLOCKSET(BlkInfo, fld1, pData, wCount, bIncDest, bIncSource, destSz) \
{ \
(BlkInfo)->errorState = (BlkInfo)->RegWriteBlock(BlkInfo, fld1, pData, wCount,\
bIncDest, bIncSource, (eDATASZ)(sizeof(*pData)*8), destSz);\
}

#define BLOCKGET(BlkInfo, fld1, pData, wCount, bIncSource, destSz) \
{ \
(BlkInfo)->errorState = (BlkInfo)->RegReadBlock(BlkInfo, fld1, pData, wCount,\
bIncSource,(eDATASZ)(sizeof(*pData)*8), destSz);\
}
#endif

//Following lines are needed for proceesing comma eliminated SET macros (using VAR_ARG)
//-------------------------------------------------------------------------------------
#define PP_NARG(...) \
PP_NARG_(__VA_ARGS__,PP_RSEQ_N())
#define PP_NARG_(...) \
PP_ARG_N(__VA_ARGS__)
#define PP_ARG_N( \
_1, _2, _3, _4, _5, _6, _7, _8, _9,_10, \
_11,_12,_13,_14,_15,_16,_17,_18,_19,_20, \
_21,_22,_23,_24,_25,_26,_27,_28,_29,_30, \
_31,_32,_33,_34,_35,_36,_37,_38,_39,_40, \
_41,_42,_43,_44,_45,_46,_47,_48,_49,_50, \
_51,_52,_53,_54,_55,_56,_57,_58,_59,_60, \
_61,_62,_63,N,...) N
#define PP_RSEQ_N() \
63,62,61,60, \
59,58,57,56,55,54,53,52,51,50, \
49,48,47,46,45,44,43,42,41,40, \
39,38,37,36,35,34,33,32,31,30, \
29,28,27,26,25,24,23,22,21,20, \
19,18,17,16,15,14,13,12,11,10, \
9,8,7,6,5,4,3,2,1,0
//-------------------------------------------------------------------------------------
/*==========================================================================*/

/*Two-wire Master Read FIFO Register*/
#define TW_V1_MRFIFO_m_ 0x0
#define TW_V1_MRFIFO_s_ 0x0
#define TW_V1_MRFIFO_v_ 0x0
#define TW_V1_MRFIFO_m_ALL(val) 0xffffffffUL
#define TW_V1_MRFIFO_s_ALL(val) 0x0
#define TW_V1_MRFIFO_v_ALL(val) ((RALuint32)(val))
#define TW_V1_MRFIFO_var_
#define TW_V1_MRFIFO_var_ALL(var) var=Reserved_for_RAL_8;
#define TW_V1_MRFIFO_s_RDATA(val) 0x0
#define TW_V1_MRFIFO_m_RDATA(val) 0xff
#define TW_V1_MRFIFO_v_RDATA(val) (((val)<<TW_V1_MRFIFO_s_RDATA(val))&TW_V1_MRFIFO_m_RDATA(val))
#define TW_V1_MRFIFO_var_RDATA(var) var=(Reserved_for_RAL_8 & TW_V1_MRFIFO_m_RDATA(var)) >> TW_V1_MRFIFO_s_RDATA(var);
#define TW_V1_MRFIFO_m_Unused8 0xffffff00UL

#define TW_V1_MRFIFO_OFF 0x00000000
#define TW_V1_MRFIFO_SIZE 8

#define TW_V1_MRFIFO_GET(BlkInfo, ...) _TW_V1_MRFIFO_GET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_MRFIFO_GET(BlkInfo, count, ...) __TW_V1_MRFIFO_GET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_MRFIFO_GET(BlkInfo, count, ...) _TW_V1_MRFIFO_GET ## count(BlkInfo, __VA_ARGS__)

#define _TW_V1_MRFIFO_GET1(BlkInfo, fld0) \
do {\
RALuint8 Reserved_for_RAL_8;\
(BlkInfo)->errorState = (BlkInfo)->RegRead8(BlkInfo, (BlkInfo)->BaseAddress+0x00000000, &Reserved_for_RAL_8); \
TW_V1_MRFIFO_var_##fld0  \
} while(0)


#define _TW_V1_MRFIFO_GET2(BlkInfo, fld0, fld1) \
do {\
RALuint8 Reserved_for_RAL_8;\
(BlkInfo)->errorState = (BlkInfo)->RegRead8(BlkInfo, (BlkInfo)->BaseAddress+0x00000000, &Reserved_for_RAL_8); \
TW_V1_MRFIFO_var_##fld0  \
TW_V1_MRFIFO_var_##fld1  \
} while(0)


#define TW_V1_MRFIFO_GET1(BlkInfo, fld1)  \
{\
RALuint8 Reserved_for_RAL_8;\
(BlkInfo)->errorState = (BlkInfo)->RegRead8(BlkInfo, (BlkInfo)->BaseAddress+0x00000000, &Reserved_for_RAL_8); \
TW_V1_MRFIFO_var_##fld1 \
}
/*==========================================================================*/

/*Two-wire Master Write FIFO Register:*/
#define TW_V1_MWFIFO_m_ 0x0
#define TW_V1_MWFIFO_s_ 0x0
#define TW_V1_MWFIFO_v_ 0x0
#define TW_V1_MWFIFO_m_ALL(val) 0xffffffffUL
#define TW_V1_MWFIFO_s_ALL(val) 0x0
#define TW_V1_MWFIFO_v_ALL(val) ((RALuint32)(val))
#define TW_V1_MWFIFO_var_
#define TW_V1_MWFIFO_var_ALL(var) var=Reserved_for_RAL_16;
#define TW_V1_MWFIFO_s_WDATA(val) 0x0
#define TW_V1_MWFIFO_m_WDATA(val) 0xff
#define TW_V1_MWFIFO_v_WDATA(val) (((val)<<TW_V1_MWFIFO_s_WDATA(val))&TW_V1_MWFIFO_m_WDATA(val))
#define TW_V1_MWFIFO_var_WDATA(var) var=(Reserved_for_RAL_16 & TW_V1_MWFIFO_m_WDATA(var)) >> TW_V1_MWFIFO_s_WDATA(var);
#define TW_V1_MWFIFO_s_CMD(val) 0x8
#define TW_V1_MWFIFO_m_CMD(val) 0x700
#define TW_V1_MWFIFO_v_CMD(val) (((RALuint16)(val)<<TW_V1_MWFIFO_s_CMD(val))&TW_V1_MWFIFO_m_CMD(val))
#define TW_V1_MWFIFO_var_CMD(var) var=(Reserved_for_RAL_16 & TW_V1_MWFIFO_m_CMD(var)) >> TW_V1_MWFIFO_s_CMD(var);
#define TW_V1_MWFIFO_m_Unused11 0xfffff800UL

#define TW_V1_MWFIFO_OFF 0x00000004
#define TW_V1_MWFIFO_SIZE 16

#define TW_V1_MWFIFO_SET(BlkInfo, ...) _TW_V1_MWFIFO_SET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_MWFIFO_SET(BlkInfo, count, ...) __TW_V1_MWFIFO_SET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_MWFIFO_SET(BlkInfo, count, ...) _TW_V1_MWFIFO_SET ## count(BlkInfo, __VA_ARGS__)

#define ___TW_V1_MWFIFO_SET(BlkInfo, mask, value) \
do {\
(BlkInfo)->errorState = (BlkInfo)->RegWrite16(BlkInfo, (BlkInfo)->BaseAddress+0x00000004,\
(RALuint16)~(0 | mask  | TW_V1_MWFIFO_m_Unused11), 0 | value);\
} while(0)


#define _TW_V1_MWFIFO_SET1(BlkInfo, fld1) \
___TW_V1_MWFIFO_SET(BlkInfo, TW_V1_MWFIFO_m_##fld1, \
TW_V1_MWFIFO_v_##fld1)

#define _TW_V1_MWFIFO_SET2(BlkInfo, fld1, fld2) \
___TW_V1_MWFIFO_SET(BlkInfo, TW_V1_MWFIFO_m_##fld1 | TW_V1_MWFIFO_m_##fld2, \
TW_V1_MWFIFO_v_##fld1 | TW_V1_MWFIFO_v_##fld2)

#define TW_V1_MWFIFO_SET1(BlkInfo, fld1) \
{\
(BlkInfo)->errorState = (BlkInfo)->RegWrite16(BlkInfo, (BlkInfo)->BaseAddress+0x00000004,\
(RALuint16)~(0 | TW_V1_MWFIFO_m_##fld1),\
0 | TW_V1_MWFIFO_v_##fld1);\
}


#define TW_V1_MWFIFO_DEF(fld1, fld2) \
{\
0 | TW_V1_MWFIFO_v_##fld1 | TW_V1_MWFIFO_v_##fld2, \
(RALuint16)~(0L | TW_V1_MWFIFO_m_##fld1 | TW_V1_MWFIFO_m_##fld2 | TW_V1_MWFIFO_m_Unused11), \
16, \
0x00000004 \
}

#define TW_V1_MWFIFO_MEM(RegEntry, fld1, fld2) \
RegEntry.dwValue = (RegEntry.dwValue & ~(0L | TW_V1_MWFIFO_m_##fld1 | TW_V1_MWFIFO_m_##fld2 | TW_V1_MWFIFO_m_Unused11))| \
(0 | TW_V1_MWFIFO_v_##fld1 | TW_V1_MWFIFO_v_##fld2);\
RegEntry.dwMask &= ~(0L | TW_V1_MWFIFO_m_##fld1 | TW_V1_MWFIFO_m_##fld2 | TW_V1_MWFIFO_m_Unused11)
/*==========================================================================*/

/*Two-wire Master Read and Write FIFO Status/Configuration Register:*/
#define TW_V1_MFIFOSTAT_m_ 0x0
#define TW_V1_MFIFOSTAT_s_ 0x0
#define TW_V1_MFIFOSTAT_v_ 0x0
#define TW_V1_MFIFOSTAT_m_ALL(val) 0xffffffffUL
#define TW_V1_MFIFOSTAT_s_ALL(val) 0x0
#define TW_V1_MFIFOSTAT_v_ALL(val) ((RALuint32)(val))
#define TW_V1_MFIFOSTAT_var_
#define TW_V1_MFIFOSTAT_var_ALL(var) var=Reserved_for_RAL_32;
#define TW_V1_MFIFOSTAT_s_WFNE(val) 0x0
#define TW_V1_MFIFOSTAT_m_WFNE(val) 0xff
#define TW_V1_MFIFOSTAT_v_WFNE(val) (((val)<<TW_V1_MFIFOSTAT_s_WFNE(val))&TW_V1_MFIFOSTAT_m_WFNE(val))
#define TW_V1_MFIFOSTAT_var_WFNE(var) var=(Reserved_for_RAL_32 & TW_V1_MFIFOSTAT_m_WFNE(var)) >> TW_V1_MFIFOSTAT_s_WFNE(var);
#define TW_V1_MFIFOSTAT_s_RFNE(val) 0x8
#define TW_V1_MFIFOSTAT_m_RFNE(val) 0xff00
#define TW_V1_MFIFOSTAT_v_RFNE(val) (((RALuint16)(val)<<TW_V1_MFIFOSTAT_s_RFNE(val))&TW_V1_MFIFOSTAT_m_RFNE(val))
#define TW_V1_MFIFOSTAT_var_RFNE(var) var=(Reserved_for_RAL_32 & TW_V1_MFIFOSTAT_m_RFNE(var)) >> TW_V1_MFIFOSTAT_s_RFNE(var);
#define TW_V1_MFIFOSTAT_s_WFSZ(val) 0x10
#define TW_V1_MFIFOSTAT_m_WFSZ(val) 0xff0000UL
#define TW_V1_MFIFOSTAT_v_WFSZ(val) (((RALuint32)(val)<<TW_V1_MFIFOSTAT_s_WFSZ(val))&TW_V1_MFIFOSTAT_m_WFSZ(val))
#define TW_V1_MFIFOSTAT_var_WFSZ(var) var=(Reserved_for_RAL_32 & TW_V1_MFIFOSTAT_m_WFSZ(var)) >> TW_V1_MFIFOSTAT_s_WFSZ(var);
#define TW_V1_MFIFOSTAT_s_RFSZ(val) 0x18
#define TW_V1_MFIFOSTAT_m_RFSZ(val) 0xff000000UL
#define TW_V1_MFIFOSTAT_v_RFSZ(val) (((RALuint32)(val)<<TW_V1_MFIFOSTAT_s_RFSZ(val))&TW_V1_MFIFOSTAT_m_RFSZ(val))
#define TW_V1_MFIFOSTAT_var_RFSZ(var) var=(Reserved_for_RAL_32 & TW_V1_MFIFOSTAT_m_RFSZ(var)) >> TW_V1_MFIFOSTAT_s_RFSZ(var);

#define TW_V1_MFIFOSTAT_OFF 0x00000008
#define TW_V1_MFIFOSTAT_SIZE 32

#define TW_V1_MFIFOSTAT_GET(BlkInfo, ...) _TW_V1_MFIFOSTAT_GET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_MFIFOSTAT_GET(BlkInfo, count, ...) __TW_V1_MFIFOSTAT_GET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_MFIFOSTAT_GET(BlkInfo, count, ...) _TW_V1_MFIFOSTAT_GET ## count(BlkInfo, __VA_ARGS__)

#define _TW_V1_MFIFOSTAT_GET1(BlkInfo, fld0) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000008, &Reserved_for_RAL_32); \
TW_V1_MFIFOSTAT_var_##fld0  \
} while(0)


#define _TW_V1_MFIFOSTAT_GET2(BlkInfo, fld0, fld1) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000008, &Reserved_for_RAL_32); \
TW_V1_MFIFOSTAT_var_##fld0  \
TW_V1_MFIFOSTAT_var_##fld1  \
} while(0)


#define _TW_V1_MFIFOSTAT_GET3(BlkInfo, fld0, fld1, fld2) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000008, &Reserved_for_RAL_32); \
TW_V1_MFIFOSTAT_var_##fld0  \
TW_V1_MFIFOSTAT_var_##fld1  \
TW_V1_MFIFOSTAT_var_##fld2  \
} while(0)


#define _TW_V1_MFIFOSTAT_GET4(BlkInfo, fld0, fld1, fld2, fld3) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000008, &Reserved_for_RAL_32); \
TW_V1_MFIFOSTAT_var_##fld0  \
TW_V1_MFIFOSTAT_var_##fld1  \
TW_V1_MFIFOSTAT_var_##fld2  \
TW_V1_MFIFOSTAT_var_##fld3  \
} while(0)


#define _TW_V1_MFIFOSTAT_GET5(BlkInfo, fld0, fld1, fld2, fld3, fld4) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000008, &Reserved_for_RAL_32); \
TW_V1_MFIFOSTAT_var_##fld0  \
TW_V1_MFIFOSTAT_var_##fld1  \
TW_V1_MFIFOSTAT_var_##fld2  \
TW_V1_MFIFOSTAT_var_##fld3  \
TW_V1_MFIFOSTAT_var_##fld4  \
} while(0)


#define TW_V1_MFIFOSTAT_GET1(BlkInfo, fld1)  \
{\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000008, &Reserved_for_RAL_32); \
TW_V1_MFIFOSTAT_var_##fld1 \
}
/*==========================================================================*/

/*Two-wire Master Control and Status Register*/
#define TW_V1_MCTL_m_ 0x0
#define TW_V1_MCTL_s_ 0x0
#define TW_V1_MCTL_v_ 0x0
#define TW_V1_MCTL_m_ALL(val) 0xffffffffUL
#define TW_V1_MCTL_s_ALL(val) 0x0
#define TW_V1_MCTL_v_ALL(val) ((RALuint32)(val))
#define TW_V1_MCTL_var_
#define TW_V1_MCTL_var_ALL(var) var=Reserved_for_RAL_32;
#define TW_V1_MCTL_s_BUSSTATE(val) 0x0
#define TW_V1_MCTL_m_BUSSTATE(val) 0x3
#define TW_V1_MCTL_v_BUSSTATE(val) (((val)<<TW_V1_MCTL_s_BUSSTATE(val))&TW_V1_MCTL_m_BUSSTATE(val))
#define TW_V1_MCTL_var_BUSSTATE(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_BUSSTATE(var)) >> TW_V1_MCTL_s_BUSSTATE(var);
#define TW_V1_MCTL_s_RUNSTATE(val) 0x2
#define TW_V1_MCTL_m_RUNSTATE(val) 0xc
#define TW_V1_MCTL_v_RUNSTATE(val) (((val)<<TW_V1_MCTL_s_RUNSTATE(val))&TW_V1_MCTL_m_RUNSTATE(val))
#define TW_V1_MCTL_var_RUNSTATE(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_RUNSTATE(var)) >> TW_V1_MCTL_s_RUNSTATE(var);
#define TW_V1_MCTL_s_RTACKPND(val) 0x4
#define TW_V1_MCTL_m_RTACKPND(val) 0x10
#define TW_V1_MCTL_v_RTACKPND(val) (((val)<<TW_V1_MCTL_s_RTACKPND(val))&TW_V1_MCTL_m_RTACKPND(val))
#define TW_V1_MCTL_var_RTACKPND(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_RTACKPND(var)) >> TW_V1_MCTL_s_RTACKPND(var);
#define TW_V1_MCTL_s_SCLSTATE(val) 0x5
#define TW_V1_MCTL_m_SCLSTATE(val) 0x20
#define TW_V1_MCTL_v_SCLSTATE(val) (((val)<<TW_V1_MCTL_s_SCLSTATE(val))&TW_V1_MCTL_m_SCLSTATE(val))
#define TW_V1_MCTL_var_SCLSTATE(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_SCLSTATE(var)) >> TW_V1_MCTL_s_SCLSTATE(var);
#define TW_V1_MCTL_s_SDASTATE(val) 0x6
#define TW_V1_MCTL_m_SDASTATE(val) 0x40
#define TW_V1_MCTL_v_SDASTATE(val) (((val)<<TW_V1_MCTL_s_SDASTATE(val))&TW_V1_MCTL_m_SDASTATE(val))
#define TW_V1_MCTL_var_SDASTATE(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_SDASTATE(var)) >> TW_V1_MCTL_s_SDASTATE(var);
#define TW_V1_MCTL_m_Unused7 0x7f80
#define TW_V1_MCTL_s_SCLSPEED(val) 0xf
#define TW_V1_MCTL_m_SCLSPEED(val) 0x78000UL
#define TW_V1_MCTL_v_SCLSPEED(val) (((RALuint32)(val)<<TW_V1_MCTL_s_SCLSPEED(val))&TW_V1_MCTL_m_SCLSPEED(val))
#define TW_V1_MCTL_var_SCLSPEED(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_SCLSPEED(var)) >> TW_V1_MCTL_s_SCLSPEED(var);
#define TW_V1_MCTL_s_LCLSTST(val) 0x13
#define TW_V1_MCTL_m_LCLSTST(val) 0x80000UL
#define TW_V1_MCTL_v_LCLSTST(val) (((RALuint32)(val)<<TW_V1_MCTL_s_LCLSTST(val))&TW_V1_MCTL_m_LCLSTST(val))
#define TW_V1_MCTL_var_LCLSTST(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_LCLSTST(var)) >> TW_V1_MCTL_s_LCLSTST(var);
#define TW_V1_MCTL_s_MWFTHR(val) 0x14
#define TW_V1_MCTL_m_MWFTHR(val) 0x300000UL
#define TW_V1_MCTL_v_MWFTHR(val) (((RALuint32)(val)<<TW_V1_MCTL_s_MWFTHR(val))&TW_V1_MCTL_m_MWFTHR(val))
#define TW_V1_MCTL_var_MWFTHR(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_MWFTHR(var)) >> TW_V1_MCTL_s_MWFTHR(var);
#define TW_V1_MCTL_s_MRFTHR(val) 0x16
#define TW_V1_MCTL_m_MRFTHR(val) 0xc00000UL
#define TW_V1_MCTL_v_MRFTHR(val) (((RALuint32)(val)<<TW_V1_MCTL_s_MRFTHR(val))&TW_V1_MCTL_m_MRFTHR(val))
#define TW_V1_MCTL_var_MRFTHR(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_MRFTHR(var)) >> TW_V1_MCTL_s_MRFTHR(var);
#define TW_V1_MCTL_s_FASTMODE(val) 0x18
#define TW_V1_MCTL_m_FASTMODE(val) 0x1000000UL
#define TW_V1_MCTL_v_FASTMODE(val) (((RALuint32)(val)<<TW_V1_MCTL_s_FASTMODE(val))&TW_V1_MCTL_m_FASTMODE(val))
#define TW_V1_MCTL_var_FASTMODE(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_FASTMODE(var)) >> TW_V1_MCTL_s_FASTMODE(var);
#define TW_V1_MCTL_s_CLRHLT(val) 0x19
#define TW_V1_MCTL_m_CLRHLT(val) 0x2000000UL
#define TW_V1_MCTL_v_CLRHLT(val) (((RALuint32)(val)<<TW_V1_MCTL_s_CLRHLT(val))&TW_V1_MCTL_m_CLRHLT(val))
#define TW_V1_MCTL_var_CLRHLT(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_CLRHLT(var)) >> TW_V1_MCTL_s_CLRHLT(var);
#define TW_V1_MCTL_m_Unused26 0x4000000UL
#define TW_V1_MCTL_s_AUTOHOLD(val) 0x1b
#define TW_V1_MCTL_m_AUTOHOLD(val) 0x8000000UL
#define TW_V1_MCTL_v_AUTOHOLD(val) (((RALuint32)(val)<<TW_V1_MCTL_s_AUTOHOLD(val))&TW_V1_MCTL_m_AUTOHOLD(val))
#define TW_V1_MCTL_var_AUTOHOLD(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_AUTOHOLD(var)) >> TW_V1_MCTL_s_AUTOHOLD(var);
#define TW_V1_MCTL_s_MRFRST(val) 0x1c
#define TW_V1_MCTL_m_MRFRST(val) 0x10000000UL
#define TW_V1_MCTL_v_MRFRST(val) (((RALuint32)(val)<<TW_V1_MCTL_s_MRFRST(val))&TW_V1_MCTL_m_MRFRST(val))
#define TW_V1_MCTL_var_MRFRST(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_MRFRST(var)) >> TW_V1_MCTL_s_MRFRST(var);
#define TW_V1_MCTL_s_MWFRST(val) 0x1d
#define TW_V1_MCTL_m_MWFRST(val) 0x20000000UL
#define TW_V1_MCTL_v_MWFRST(val) (((RALuint32)(val)<<TW_V1_MCTL_s_MWFRST(val))&TW_V1_MCTL_m_MWFRST(val))
#define TW_V1_MCTL_var_MWFRST(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_MWFRST(var)) >> TW_V1_MCTL_s_MWFRST(var);
#define TW_V1_MCTL_s_MASTER_RST(val) 0x1e
#define TW_V1_MCTL_m_MASTER_RST(val) 0x40000000UL
#define TW_V1_MCTL_v_MASTER_RST(val) (((RALuint32)(val)<<TW_V1_MCTL_s_MASTER_RST(val))&TW_V1_MCTL_m_MASTER_RST(val))
#define TW_V1_MCTL_var_MASTER_RST(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_MASTER_RST(var)) >> TW_V1_MCTL_s_MASTER_RST(var);
#define TW_V1_MCTL_s_MASTER_EN(val) 0x1f
#define TW_V1_MCTL_m_MASTER_EN(val) 0x80000000UL
#define TW_V1_MCTL_v_MASTER_EN(val) (((RALuint32)(val)<<TW_V1_MCTL_s_MASTER_EN(val))&TW_V1_MCTL_m_MASTER_EN(val))
#define TW_V1_MCTL_var_MASTER_EN(var) var=(Reserved_for_RAL_32 & TW_V1_MCTL_m_MASTER_EN(var)) >> TW_V1_MCTL_s_MASTER_EN(var);

#define TW_V1_MCTL_OFF 0x0000000c
#define TW_V1_MCTL_SIZE 32

#define TW_V1_MCTL_SET(BlkInfo, ...) _TW_V1_MCTL_SET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_MCTL_SET(BlkInfo, count, ...) __TW_V1_MCTL_SET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_MCTL_SET(BlkInfo, count, ...) _TW_V1_MCTL_SET ## count(BlkInfo, __VA_ARGS__)

#define ___TW_V1_MCTL_SET(BlkInfo, mask, value) \
do {\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c,\
~(0L | mask  | TW_V1_MCTL_m_Unused7 | TW_V1_MCTL_m_Unused26), 0L | value);\
} while(0)


#define _TW_V1_MCTL_SET1(BlkInfo, fld1) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1, \
TW_V1_MCTL_v_##fld1)

#define _TW_V1_MCTL_SET2(BlkInfo, fld1, fld2) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2)

#define _TW_V1_MCTL_SET3(BlkInfo, fld1, fld2, fld3) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3)

#define _TW_V1_MCTL_SET4(BlkInfo, fld1, fld2, fld3, fld4) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4)

#define _TW_V1_MCTL_SET5(BlkInfo, fld1, fld2, fld3, fld4, fld5) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4 | TW_V1_MCTL_v_##fld5)

#define _TW_V1_MCTL_SET6(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld7) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5 | TW_V1_MCTL_m_##fld7, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4 | TW_V1_MCTL_v_##fld5 | TW_V1_MCTL_v_##fld7)

#define _TW_V1_MCTL_SET7(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld7, fld8) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5 | TW_V1_MCTL_m_##fld7 | TW_V1_MCTL_m_##fld8, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4 | TW_V1_MCTL_v_##fld5 | TW_V1_MCTL_v_##fld7 | TW_V1_MCTL_v_##fld8)

#define _TW_V1_MCTL_SET8(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5 | TW_V1_MCTL_m_##fld7 | TW_V1_MCTL_m_##fld8 | TW_V1_MCTL_m_##fld9, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4 | TW_V1_MCTL_v_##fld5 | TW_V1_MCTL_v_##fld7 | TW_V1_MCTL_v_##fld8 | TW_V1_MCTL_v_##fld9)

#define _TW_V1_MCTL_SET9(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5 | TW_V1_MCTL_m_##fld7 | TW_V1_MCTL_m_##fld8 | TW_V1_MCTL_m_##fld9 | TW_V1_MCTL_m_##fld10, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4 | TW_V1_MCTL_v_##fld5 | TW_V1_MCTL_v_##fld7 | TW_V1_MCTL_v_##fld8 | TW_V1_MCTL_v_##fld9 | TW_V1_MCTL_v_##fld10)

#define _TW_V1_MCTL_SET10(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5 | TW_V1_MCTL_m_##fld7 | TW_V1_MCTL_m_##fld8 | TW_V1_MCTL_m_##fld9 | TW_V1_MCTL_m_##fld10 | TW_V1_MCTL_m_##fld11, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4 | TW_V1_MCTL_v_##fld5 | TW_V1_MCTL_v_##fld7 | TW_V1_MCTL_v_##fld8 | TW_V1_MCTL_v_##fld9 | TW_V1_MCTL_v_##fld10 | TW_V1_MCTL_v_##fld11)

#define _TW_V1_MCTL_SET11(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11, fld12) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5 | TW_V1_MCTL_m_##fld7 | TW_V1_MCTL_m_##fld8 | TW_V1_MCTL_m_##fld9 | TW_V1_MCTL_m_##fld10 | TW_V1_MCTL_m_##fld11 | TW_V1_MCTL_m_##fld12, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4 | TW_V1_MCTL_v_##fld5 | TW_V1_MCTL_v_##fld7 | TW_V1_MCTL_v_##fld8 | TW_V1_MCTL_v_##fld9 | TW_V1_MCTL_v_##fld10 | TW_V1_MCTL_v_##fld11 | TW_V1_MCTL_v_##fld12)

#define _TW_V1_MCTL_SET12(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11, fld12, fld14) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5 | TW_V1_MCTL_m_##fld7 | TW_V1_MCTL_m_##fld8 | TW_V1_MCTL_m_##fld9 | TW_V1_MCTL_m_##fld10 | TW_V1_MCTL_m_##fld11 | TW_V1_MCTL_m_##fld12 | TW_V1_MCTL_m_##fld14, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4 | TW_V1_MCTL_v_##fld5 | TW_V1_MCTL_v_##fld7 | TW_V1_MCTL_v_##fld8 | TW_V1_MCTL_v_##fld9 | TW_V1_MCTL_v_##fld10 | TW_V1_MCTL_v_##fld11 | TW_V1_MCTL_v_##fld12 | TW_V1_MCTL_v_##fld14)

#define _TW_V1_MCTL_SET13(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11, fld12, fld14, fld15) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5 | TW_V1_MCTL_m_##fld7 | TW_V1_MCTL_m_##fld8 | TW_V1_MCTL_m_##fld9 | TW_V1_MCTL_m_##fld10 | TW_V1_MCTL_m_##fld11 | TW_V1_MCTL_m_##fld12 | TW_V1_MCTL_m_##fld14 | TW_V1_MCTL_m_##fld15, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4 | TW_V1_MCTL_v_##fld5 | TW_V1_MCTL_v_##fld7 | TW_V1_MCTL_v_##fld8 | TW_V1_MCTL_v_##fld9 | TW_V1_MCTL_v_##fld10 | TW_V1_MCTL_v_##fld11 | TW_V1_MCTL_v_##fld12 | TW_V1_MCTL_v_##fld14 | TW_V1_MCTL_v_##fld15)

#define _TW_V1_MCTL_SET14(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11, fld12, fld14, fld15, fld16) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5 | TW_V1_MCTL_m_##fld7 | TW_V1_MCTL_m_##fld8 | TW_V1_MCTL_m_##fld9 | TW_V1_MCTL_m_##fld10 | TW_V1_MCTL_m_##fld11 | TW_V1_MCTL_m_##fld12 | TW_V1_MCTL_m_##fld14 | TW_V1_MCTL_m_##fld15 | TW_V1_MCTL_m_##fld16, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4 | TW_V1_MCTL_v_##fld5 | TW_V1_MCTL_v_##fld7 | TW_V1_MCTL_v_##fld8 | TW_V1_MCTL_v_##fld9 | TW_V1_MCTL_v_##fld10 | TW_V1_MCTL_v_##fld11 | TW_V1_MCTL_v_##fld12 | TW_V1_MCTL_v_##fld14 | TW_V1_MCTL_v_##fld15 | TW_V1_MCTL_v_##fld16)

#define _TW_V1_MCTL_SET15(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11, fld12, fld14, fld15, fld16, fld17) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5 | TW_V1_MCTL_m_##fld7 | TW_V1_MCTL_m_##fld8 | TW_V1_MCTL_m_##fld9 | TW_V1_MCTL_m_##fld10 | TW_V1_MCTL_m_##fld11 | TW_V1_MCTL_m_##fld12 | TW_V1_MCTL_m_##fld14 | TW_V1_MCTL_m_##fld15 | TW_V1_MCTL_m_##fld16 | TW_V1_MCTL_m_##fld17, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4 | TW_V1_MCTL_v_##fld5 | TW_V1_MCTL_v_##fld7 | TW_V1_MCTL_v_##fld8 | TW_V1_MCTL_v_##fld9 | TW_V1_MCTL_v_##fld10 | TW_V1_MCTL_v_##fld11 | TW_V1_MCTL_v_##fld12 | TW_V1_MCTL_v_##fld14 | TW_V1_MCTL_v_##fld15 | TW_V1_MCTL_v_##fld16 | TW_V1_MCTL_v_##fld17)

#define _TW_V1_MCTL_SET16(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11, fld12, fld14, fld15, fld16, fld17, fld18) \
___TW_V1_MCTL_SET(BlkInfo, TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5 | TW_V1_MCTL_m_##fld7 | TW_V1_MCTL_m_##fld8 | TW_V1_MCTL_m_##fld9 | TW_V1_MCTL_m_##fld10 | TW_V1_MCTL_m_##fld11 | TW_V1_MCTL_m_##fld12 | TW_V1_MCTL_m_##fld14 | TW_V1_MCTL_m_##fld15 | TW_V1_MCTL_m_##fld16 | TW_V1_MCTL_m_##fld17 | TW_V1_MCTL_m_##fld18, \
TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4 | TW_V1_MCTL_v_##fld5 | TW_V1_MCTL_v_##fld7 | TW_V1_MCTL_v_##fld8 | TW_V1_MCTL_v_##fld9 | TW_V1_MCTL_v_##fld10 | TW_V1_MCTL_v_##fld11 | TW_V1_MCTL_v_##fld12 | TW_V1_MCTL_v_##fld14 | TW_V1_MCTL_v_##fld15 | TW_V1_MCTL_v_##fld16 | TW_V1_MCTL_v_##fld17 | TW_V1_MCTL_v_##fld18)

#define TW_V1_MCTL_SET1(BlkInfo, fld1) \
{\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c,\
~(0L | TW_V1_MCTL_m_##fld1),\
0L | TW_V1_MCTL_v_##fld1);\
}


#define TW_V1_MCTL_DEF(fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11, fld12, fld14, fld15, fld16, fld17, fld18) \
{\
0 | TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4 | TW_V1_MCTL_v_##fld5 | TW_V1_MCTL_v_##fld7 | TW_V1_MCTL_v_##fld8 | TW_V1_MCTL_v_##fld9 | TW_V1_MCTL_v_##fld10 | TW_V1_MCTL_v_##fld11 | TW_V1_MCTL_v_##fld12 | TW_V1_MCTL_v_##fld14 | TW_V1_MCTL_v_##fld15 | TW_V1_MCTL_v_##fld16 | TW_V1_MCTL_v_##fld17 | TW_V1_MCTL_v_##fld18, \
~(0L | TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5 | TW_V1_MCTL_m_Unused7 | TW_V1_MCTL_m_##fld7 | TW_V1_MCTL_m_##fld8 | TW_V1_MCTL_m_##fld9 | TW_V1_MCTL_m_##fld10 | TW_V1_MCTL_m_##fld11 | TW_V1_MCTL_m_##fld12 | TW_V1_MCTL_m_Unused26 | TW_V1_MCTL_m_##fld14 | TW_V1_MCTL_m_##fld15 | TW_V1_MCTL_m_##fld16 | TW_V1_MCTL_m_##fld17 | TW_V1_MCTL_m_##fld18), \
32, \
0x0000000c \
}

#define TW_V1_MCTL_MEM(RegEntry, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11, fld12, fld14, fld15, fld16, fld17, fld18) \
RegEntry.dwValue = (RegEntry.dwValue & ~(0L | TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5 | TW_V1_MCTL_m_Unused7 | TW_V1_MCTL_m_##fld7 | TW_V1_MCTL_m_##fld8 | TW_V1_MCTL_m_##fld9 | TW_V1_MCTL_m_##fld10 | TW_V1_MCTL_m_##fld11 | TW_V1_MCTL_m_##fld12 | TW_V1_MCTL_m_Unused26 | TW_V1_MCTL_m_##fld14 | TW_V1_MCTL_m_##fld15 | TW_V1_MCTL_m_##fld16 | TW_V1_MCTL_m_##fld17 | TW_V1_MCTL_m_##fld18))| \
(0 | TW_V1_MCTL_v_##fld1 | TW_V1_MCTL_v_##fld2 | TW_V1_MCTL_v_##fld3 | TW_V1_MCTL_v_##fld4 | TW_V1_MCTL_v_##fld5 | TW_V1_MCTL_v_##fld7 | TW_V1_MCTL_v_##fld8 | TW_V1_MCTL_v_##fld9 | TW_V1_MCTL_v_##fld10 | TW_V1_MCTL_v_##fld11 | TW_V1_MCTL_v_##fld12 | TW_V1_MCTL_v_##fld14 | TW_V1_MCTL_v_##fld15 | TW_V1_MCTL_v_##fld16 | TW_V1_MCTL_v_##fld17 | TW_V1_MCTL_v_##fld18);\
RegEntry.dwMask &= ~(0L | TW_V1_MCTL_m_##fld1 | TW_V1_MCTL_m_##fld2 | TW_V1_MCTL_m_##fld3 | TW_V1_MCTL_m_##fld4 | TW_V1_MCTL_m_##fld5 | TW_V1_MCTL_m_Unused7 | TW_V1_MCTL_m_##fld7 | TW_V1_MCTL_m_##fld8 | TW_V1_MCTL_m_##fld9 | TW_V1_MCTL_m_##fld10 | TW_V1_MCTL_m_##fld11 | TW_V1_MCTL_m_##fld12 | TW_V1_MCTL_m_Unused26 | TW_V1_MCTL_m_##fld14 | TW_V1_MCTL_m_##fld15 | TW_V1_MCTL_m_##fld16 | TW_V1_MCTL_m_##fld17 | TW_V1_MCTL_m_##fld18)

#define TW_V1_MCTL_GET(BlkInfo, ...) _TW_V1_MCTL_GET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_MCTL_GET(BlkInfo, count, ...) __TW_V1_MCTL_GET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_MCTL_GET(BlkInfo, count, ...) _TW_V1_MCTL_GET ## count(BlkInfo, __VA_ARGS__)

#define _TW_V1_MCTL_GET1(BlkInfo, fld0) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
} while(0)


#define _TW_V1_MCTL_GET2(BlkInfo, fld0, fld1) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
} while(0)


#define _TW_V1_MCTL_GET3(BlkInfo, fld0, fld1, fld2) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
} while(0)


#define _TW_V1_MCTL_GET4(BlkInfo, fld0, fld1, fld2, fld3) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
TW_V1_MCTL_var_##fld3  \
} while(0)


#define _TW_V1_MCTL_GET5(BlkInfo, fld0, fld1, fld2, fld3, fld4) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
TW_V1_MCTL_var_##fld3  \
TW_V1_MCTL_var_##fld4  \
} while(0)


#define _TW_V1_MCTL_GET6(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
TW_V1_MCTL_var_##fld3  \
TW_V1_MCTL_var_##fld4  \
TW_V1_MCTL_var_##fld5  \
} while(0)


#define _TW_V1_MCTL_GET7(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld7) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
TW_V1_MCTL_var_##fld3  \
TW_V1_MCTL_var_##fld4  \
TW_V1_MCTL_var_##fld5  \
TW_V1_MCTL_var_##fld7  \
} while(0)


#define _TW_V1_MCTL_GET8(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld7, fld8) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
TW_V1_MCTL_var_##fld3  \
TW_V1_MCTL_var_##fld4  \
TW_V1_MCTL_var_##fld5  \
TW_V1_MCTL_var_##fld7  \
TW_V1_MCTL_var_##fld8  \
} while(0)


#define _TW_V1_MCTL_GET9(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
TW_V1_MCTL_var_##fld3  \
TW_V1_MCTL_var_##fld4  \
TW_V1_MCTL_var_##fld5  \
TW_V1_MCTL_var_##fld7  \
TW_V1_MCTL_var_##fld8  \
TW_V1_MCTL_var_##fld9  \
} while(0)


#define _TW_V1_MCTL_GET10(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
TW_V1_MCTL_var_##fld3  \
TW_V1_MCTL_var_##fld4  \
TW_V1_MCTL_var_##fld5  \
TW_V1_MCTL_var_##fld7  \
TW_V1_MCTL_var_##fld8  \
TW_V1_MCTL_var_##fld9  \
TW_V1_MCTL_var_##fld10  \
} while(0)


#define _TW_V1_MCTL_GET11(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
TW_V1_MCTL_var_##fld3  \
TW_V1_MCTL_var_##fld4  \
TW_V1_MCTL_var_##fld5  \
TW_V1_MCTL_var_##fld7  \
TW_V1_MCTL_var_##fld8  \
TW_V1_MCTL_var_##fld9  \
TW_V1_MCTL_var_##fld10  \
TW_V1_MCTL_var_##fld11  \
} while(0)


#define _TW_V1_MCTL_GET12(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11, fld12) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
TW_V1_MCTL_var_##fld3  \
TW_V1_MCTL_var_##fld4  \
TW_V1_MCTL_var_##fld5  \
TW_V1_MCTL_var_##fld7  \
TW_V1_MCTL_var_##fld8  \
TW_V1_MCTL_var_##fld9  \
TW_V1_MCTL_var_##fld10  \
TW_V1_MCTL_var_##fld11  \
TW_V1_MCTL_var_##fld12  \
} while(0)


#define _TW_V1_MCTL_GET13(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11, fld12, fld14) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
TW_V1_MCTL_var_##fld3  \
TW_V1_MCTL_var_##fld4  \
TW_V1_MCTL_var_##fld5  \
TW_V1_MCTL_var_##fld7  \
TW_V1_MCTL_var_##fld8  \
TW_V1_MCTL_var_##fld9  \
TW_V1_MCTL_var_##fld10  \
TW_V1_MCTL_var_##fld11  \
TW_V1_MCTL_var_##fld12  \
TW_V1_MCTL_var_##fld14  \
} while(0)


#define _TW_V1_MCTL_GET14(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11, fld12, fld14, fld15) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
TW_V1_MCTL_var_##fld3  \
TW_V1_MCTL_var_##fld4  \
TW_V1_MCTL_var_##fld5  \
TW_V1_MCTL_var_##fld7  \
TW_V1_MCTL_var_##fld8  \
TW_V1_MCTL_var_##fld9  \
TW_V1_MCTL_var_##fld10  \
TW_V1_MCTL_var_##fld11  \
TW_V1_MCTL_var_##fld12  \
TW_V1_MCTL_var_##fld14  \
TW_V1_MCTL_var_##fld15  \
} while(0)


#define _TW_V1_MCTL_GET15(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11, fld12, fld14, fld15, fld16) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
TW_V1_MCTL_var_##fld3  \
TW_V1_MCTL_var_##fld4  \
TW_V1_MCTL_var_##fld5  \
TW_V1_MCTL_var_##fld7  \
TW_V1_MCTL_var_##fld8  \
TW_V1_MCTL_var_##fld9  \
TW_V1_MCTL_var_##fld10  \
TW_V1_MCTL_var_##fld11  \
TW_V1_MCTL_var_##fld12  \
TW_V1_MCTL_var_##fld14  \
TW_V1_MCTL_var_##fld15  \
TW_V1_MCTL_var_##fld16  \
} while(0)


#define _TW_V1_MCTL_GET16(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11, fld12, fld14, fld15, fld16, fld17) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
TW_V1_MCTL_var_##fld3  \
TW_V1_MCTL_var_##fld4  \
TW_V1_MCTL_var_##fld5  \
TW_V1_MCTL_var_##fld7  \
TW_V1_MCTL_var_##fld8  \
TW_V1_MCTL_var_##fld9  \
TW_V1_MCTL_var_##fld10  \
TW_V1_MCTL_var_##fld11  \
TW_V1_MCTL_var_##fld12  \
TW_V1_MCTL_var_##fld14  \
TW_V1_MCTL_var_##fld15  \
TW_V1_MCTL_var_##fld16  \
TW_V1_MCTL_var_##fld17  \
} while(0)


#define _TW_V1_MCTL_GET17(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld7, fld8, fld9, fld10, fld11, fld12, fld14, fld15, fld16, fld17, fld18) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld0  \
TW_V1_MCTL_var_##fld1  \
TW_V1_MCTL_var_##fld2  \
TW_V1_MCTL_var_##fld3  \
TW_V1_MCTL_var_##fld4  \
TW_V1_MCTL_var_##fld5  \
TW_V1_MCTL_var_##fld7  \
TW_V1_MCTL_var_##fld8  \
TW_V1_MCTL_var_##fld9  \
TW_V1_MCTL_var_##fld10  \
TW_V1_MCTL_var_##fld11  \
TW_V1_MCTL_var_##fld12  \
TW_V1_MCTL_var_##fld14  \
TW_V1_MCTL_var_##fld15  \
TW_V1_MCTL_var_##fld16  \
TW_V1_MCTL_var_##fld17  \
TW_V1_MCTL_var_##fld18  \
} while(0)


#define TW_V1_MCTL_GET1(BlkInfo, fld1)  \
{\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000000c, &Reserved_for_RAL_32); \
TW_V1_MCTL_var_##fld1 \
}
/*==========================================================================*/

/*Two-wire Master SCL0 and SCL1 Counter*/
#define TW_V1_T_SCL0_SCL1_m_ 0x0
#define TW_V1_T_SCL0_SCL1_s_ 0x0
#define TW_V1_T_SCL0_SCL1_v_ 0x0
#define TW_V1_T_SCL0_SCL1_m_ALL(val) 0xffffffffUL
#define TW_V1_T_SCL0_SCL1_s_ALL(val) 0x0
#define TW_V1_T_SCL0_SCL1_v_ALL(val) ((RALuint32)(val))
#define TW_V1_T_SCL0_SCL1_var_
#define TW_V1_T_SCL0_SCL1_var_ALL(var) var=Reserved_for_RAL_32;
#define TW_V1_T_SCL0_SCL1_s_T_SCL0(val) 0x0
#define TW_V1_T_SCL0_SCL1_m_T_SCL0(val) 0x7ff
#define TW_V1_T_SCL0_SCL1_v_T_SCL0(val) (((RALuint16)(val)<<TW_V1_T_SCL0_SCL1_s_T_SCL0(val))&TW_V1_T_SCL0_SCL1_m_T_SCL0(val))
#define TW_V1_T_SCL0_SCL1_var_T_SCL0(var) var=(Reserved_for_RAL_32 & TW_V1_T_SCL0_SCL1_m_T_SCL0(var)) >> TW_V1_T_SCL0_SCL1_s_T_SCL0(var);
#define TW_V1_T_SCL0_SCL1_m_Unused11 0xf800
#define TW_V1_T_SCL0_SCL1_s_T_SCL1(val) 0x10
#define TW_V1_T_SCL0_SCL1_m_T_SCL1(val) 0x7ff0000UL
#define TW_V1_T_SCL0_SCL1_v_T_SCL1(val) (((RALuint32)(val)<<TW_V1_T_SCL0_SCL1_s_T_SCL1(val))&TW_V1_T_SCL0_SCL1_m_T_SCL1(val))
#define TW_V1_T_SCL0_SCL1_var_T_SCL1(var) var=(Reserved_for_RAL_32 & TW_V1_T_SCL0_SCL1_m_T_SCL1(var)) >> TW_V1_T_SCL0_SCL1_s_T_SCL1(var);
#define TW_V1_T_SCL0_SCL1_m_Unused27 0xf8000000UL

#define TW_V1_T_SCL0_SCL1_OFF 0x00000010
#define TW_V1_T_SCL0_SCL1_SIZE 32

#define TW_V1_T_SCL0_SCL1_SET(BlkInfo, ...) _TW_V1_T_SCL0_SCL1_SET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_T_SCL0_SCL1_SET(BlkInfo, count, ...) __TW_V1_T_SCL0_SCL1_SET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_T_SCL0_SCL1_SET(BlkInfo, count, ...) _TW_V1_T_SCL0_SCL1_SET ## count(BlkInfo, __VA_ARGS__)

#define ___TW_V1_T_SCL0_SCL1_SET(BlkInfo, mask, value) \
do {\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x00000010,\
~(0L | mask  | TW_V1_T_SCL0_SCL1_m_Unused11 | TW_V1_T_SCL0_SCL1_m_Unused27), 0L | value);\
} while(0)


#define _TW_V1_T_SCL0_SCL1_SET1(BlkInfo, fld1) \
___TW_V1_T_SCL0_SCL1_SET(BlkInfo, TW_V1_T_SCL0_SCL1_m_##fld1, \
TW_V1_T_SCL0_SCL1_v_##fld1)

#define _TW_V1_T_SCL0_SCL1_SET2(BlkInfo, fld1, fld3) \
___TW_V1_T_SCL0_SCL1_SET(BlkInfo, TW_V1_T_SCL0_SCL1_m_##fld1 | TW_V1_T_SCL0_SCL1_m_##fld3, \
TW_V1_T_SCL0_SCL1_v_##fld1 | TW_V1_T_SCL0_SCL1_v_##fld3)

#define TW_V1_T_SCL0_SCL1_SET1(BlkInfo, fld1) \
{\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x00000010,\
~(0L | TW_V1_T_SCL0_SCL1_m_##fld1),\
0L | TW_V1_T_SCL0_SCL1_v_##fld1);\
}


#define TW_V1_T_SCL0_SCL1_DEF(fld1, fld3) \
{\
0 | TW_V1_T_SCL0_SCL1_v_##fld1 | TW_V1_T_SCL0_SCL1_v_##fld3, \
~(0L | TW_V1_T_SCL0_SCL1_m_##fld1 | TW_V1_T_SCL0_SCL1_m_Unused11 | TW_V1_T_SCL0_SCL1_m_##fld3 | TW_V1_T_SCL0_SCL1_m_Unused27), \
32, \
0x00000010 \
}

#define TW_V1_T_SCL0_SCL1_MEM(RegEntry, fld1, fld3) \
RegEntry.dwValue = (RegEntry.dwValue & ~(0L | TW_V1_T_SCL0_SCL1_m_##fld1 | TW_V1_T_SCL0_SCL1_m_Unused11 | TW_V1_T_SCL0_SCL1_m_##fld3 | TW_V1_T_SCL0_SCL1_m_Unused27))| \
(0 | TW_V1_T_SCL0_SCL1_v_##fld1 | TW_V1_T_SCL0_SCL1_v_##fld3);\
RegEntry.dwMask &= ~(0L | TW_V1_T_SCL0_SCL1_m_##fld1 | TW_V1_T_SCL0_SCL1_m_Unused11 | TW_V1_T_SCL0_SCL1_m_##fld3 | TW_V1_T_SCL0_SCL1_m_Unused27)

#define TW_V1_T_SCL0_SCL1_GET(BlkInfo, ...) _TW_V1_T_SCL0_SCL1_GET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_T_SCL0_SCL1_GET(BlkInfo, count, ...) __TW_V1_T_SCL0_SCL1_GET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_T_SCL0_SCL1_GET(BlkInfo, count, ...) _TW_V1_T_SCL0_SCL1_GET ## count(BlkInfo, __VA_ARGS__)

#define _TW_V1_T_SCL0_SCL1_GET1(BlkInfo, fld0) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000010, &Reserved_for_RAL_32); \
TW_V1_T_SCL0_SCL1_var_##fld0  \
} while(0)


#define _TW_V1_T_SCL0_SCL1_GET2(BlkInfo, fld0, fld1) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000010, &Reserved_for_RAL_32); \
TW_V1_T_SCL0_SCL1_var_##fld0  \
TW_V1_T_SCL0_SCL1_var_##fld1  \
} while(0)


#define _TW_V1_T_SCL0_SCL1_GET3(BlkInfo, fld0, fld1, fld3) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000010, &Reserved_for_RAL_32); \
TW_V1_T_SCL0_SCL1_var_##fld0  \
TW_V1_T_SCL0_SCL1_var_##fld1  \
TW_V1_T_SCL0_SCL1_var_##fld3  \
} while(0)


#define TW_V1_T_SCL0_SCL1_GET1(BlkInfo, fld1)  \
{\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000010, &Reserved_for_RAL_32); \
TW_V1_T_SCL0_SCL1_var_##fld1 \
}
/*==========================================================================*/

/*Two-wire Master BUF and SUSTO Counter*/
#define TW_V1_T_BUF_SUSTO_m_ 0x0
#define TW_V1_T_BUF_SUSTO_s_ 0x0
#define TW_V1_T_BUF_SUSTO_v_ 0x0
#define TW_V1_T_BUF_SUSTO_m_ALL(val) 0xffffffffUL
#define TW_V1_T_BUF_SUSTO_s_ALL(val) 0x0
#define TW_V1_T_BUF_SUSTO_v_ALL(val) ((RALuint32)(val))
#define TW_V1_T_BUF_SUSTO_var_
#define TW_V1_T_BUF_SUSTO_var_ALL(var) var=Reserved_for_RAL_32;
#define TW_V1_T_BUF_SUSTO_s_T_BUF(val) 0x0
#define TW_V1_T_BUF_SUSTO_m_T_BUF(val) 0x1ff
#define TW_V1_T_BUF_SUSTO_v_T_BUF(val) (((RALuint16)(val)<<TW_V1_T_BUF_SUSTO_s_T_BUF(val))&TW_V1_T_BUF_SUSTO_m_T_BUF(val))
#define TW_V1_T_BUF_SUSTO_var_T_BUF(var) var=(Reserved_for_RAL_32 & TW_V1_T_BUF_SUSTO_m_T_BUF(var)) >> TW_V1_T_BUF_SUSTO_s_T_BUF(var);
#define TW_V1_T_BUF_SUSTO_m_Unused9 0xfe00
#define TW_V1_T_BUF_SUSTO_s_T_SUSTO(val) 0x10
#define TW_V1_T_BUF_SUSTO_m_T_SUSTO(val) 0x1ff0000UL
#define TW_V1_T_BUF_SUSTO_v_T_SUSTO(val) (((RALuint32)(val)<<TW_V1_T_BUF_SUSTO_s_T_SUSTO(val))&TW_V1_T_BUF_SUSTO_m_T_SUSTO(val))
#define TW_V1_T_BUF_SUSTO_var_T_SUSTO(var) var=(Reserved_for_RAL_32 & TW_V1_T_BUF_SUSTO_m_T_SUSTO(var)) >> TW_V1_T_BUF_SUSTO_s_T_SUSTO(var);
#define TW_V1_T_BUF_SUSTO_m_Unused25 0xfe000000UL

#define TW_V1_T_BUF_SUSTO_OFF 0x00000014
#define TW_V1_T_BUF_SUSTO_SIZE 32

#define TW_V1_T_BUF_SUSTO_SET(BlkInfo, ...) _TW_V1_T_BUF_SUSTO_SET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_T_BUF_SUSTO_SET(BlkInfo, count, ...) __TW_V1_T_BUF_SUSTO_SET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_T_BUF_SUSTO_SET(BlkInfo, count, ...) _TW_V1_T_BUF_SUSTO_SET ## count(BlkInfo, __VA_ARGS__)

#define ___TW_V1_T_BUF_SUSTO_SET(BlkInfo, mask, value) \
do {\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x00000014,\
~(0L | mask  | TW_V1_T_BUF_SUSTO_m_Unused9 | TW_V1_T_BUF_SUSTO_m_Unused25), 0L | value);\
} while(0)


#define _TW_V1_T_BUF_SUSTO_SET1(BlkInfo, fld1) \
___TW_V1_T_BUF_SUSTO_SET(BlkInfo, TW_V1_T_BUF_SUSTO_m_##fld1, \
TW_V1_T_BUF_SUSTO_v_##fld1)

#define _TW_V1_T_BUF_SUSTO_SET2(BlkInfo, fld1, fld3) \
___TW_V1_T_BUF_SUSTO_SET(BlkInfo, TW_V1_T_BUF_SUSTO_m_##fld1 | TW_V1_T_BUF_SUSTO_m_##fld3, \
TW_V1_T_BUF_SUSTO_v_##fld1 | TW_V1_T_BUF_SUSTO_v_##fld3)

#define TW_V1_T_BUF_SUSTO_SET1(BlkInfo, fld1) \
{\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x00000014,\
~(0L | TW_V1_T_BUF_SUSTO_m_##fld1),\
0L | TW_V1_T_BUF_SUSTO_v_##fld1);\
}


#define TW_V1_T_BUF_SUSTO_DEF(fld1, fld3) \
{\
0 | TW_V1_T_BUF_SUSTO_v_##fld1 | TW_V1_T_BUF_SUSTO_v_##fld3, \
~(0L | TW_V1_T_BUF_SUSTO_m_##fld1 | TW_V1_T_BUF_SUSTO_m_Unused9 | TW_V1_T_BUF_SUSTO_m_##fld3 | TW_V1_T_BUF_SUSTO_m_Unused25), \
32, \
0x00000014 \
}

#define TW_V1_T_BUF_SUSTO_MEM(RegEntry, fld1, fld3) \
RegEntry.dwValue = (RegEntry.dwValue & ~(0L | TW_V1_T_BUF_SUSTO_m_##fld1 | TW_V1_T_BUF_SUSTO_m_Unused9 | TW_V1_T_BUF_SUSTO_m_##fld3 | TW_V1_T_BUF_SUSTO_m_Unused25))| \
(0 | TW_V1_T_BUF_SUSTO_v_##fld1 | TW_V1_T_BUF_SUSTO_v_##fld3);\
RegEntry.dwMask &= ~(0L | TW_V1_T_BUF_SUSTO_m_##fld1 | TW_V1_T_BUF_SUSTO_m_Unused9 | TW_V1_T_BUF_SUSTO_m_##fld3 | TW_V1_T_BUF_SUSTO_m_Unused25)

#define TW_V1_T_BUF_SUSTO_GET(BlkInfo, ...) _TW_V1_T_BUF_SUSTO_GET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_T_BUF_SUSTO_GET(BlkInfo, count, ...) __TW_V1_T_BUF_SUSTO_GET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_T_BUF_SUSTO_GET(BlkInfo, count, ...) _TW_V1_T_BUF_SUSTO_GET ## count(BlkInfo, __VA_ARGS__)

#define _TW_V1_T_BUF_SUSTO_GET1(BlkInfo, fld0) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000014, &Reserved_for_RAL_32); \
TW_V1_T_BUF_SUSTO_var_##fld0  \
} while(0)


#define _TW_V1_T_BUF_SUSTO_GET2(BlkInfo, fld0, fld1) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000014, &Reserved_for_RAL_32); \
TW_V1_T_BUF_SUSTO_var_##fld0  \
TW_V1_T_BUF_SUSTO_var_##fld1  \
} while(0)


#define _TW_V1_T_BUF_SUSTO_GET3(BlkInfo, fld0, fld1, fld3) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000014, &Reserved_for_RAL_32); \
TW_V1_T_BUF_SUSTO_var_##fld0  \
TW_V1_T_BUF_SUSTO_var_##fld1  \
TW_V1_T_BUF_SUSTO_var_##fld3  \
} while(0)


#define TW_V1_T_BUF_SUSTO_GET1(BlkInfo, fld1)  \
{\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000014, &Reserved_for_RAL_32); \
TW_V1_T_BUF_SUSTO_var_##fld1 \
}
/*==========================================================================*/

/*Two-wire Master HDSTA and SUSTA Counter*/
#define TW_V1_T_HDSTA_SUSTA_m_ 0x0
#define TW_V1_T_HDSTA_SUSTA_s_ 0x0
#define TW_V1_T_HDSTA_SUSTA_v_ 0x0
#define TW_V1_T_HDSTA_SUSTA_m_ALL(val) 0xffffffffUL
#define TW_V1_T_HDSTA_SUSTA_s_ALL(val) 0x0
#define TW_V1_T_HDSTA_SUSTA_v_ALL(val) ((RALuint32)(val))
#define TW_V1_T_HDSTA_SUSTA_var_
#define TW_V1_T_HDSTA_SUSTA_var_ALL(var) var=Reserved_for_RAL_32;
#define TW_V1_T_HDSTA_SUSTA_s_T_HDSTA(val) 0x0
#define TW_V1_T_HDSTA_SUSTA_m_T_HDSTA(val) 0x1ff
#define TW_V1_T_HDSTA_SUSTA_v_T_HDSTA(val) (((RALuint16)(val)<<TW_V1_T_HDSTA_SUSTA_s_T_HDSTA(val))&TW_V1_T_HDSTA_SUSTA_m_T_HDSTA(val))
#define TW_V1_T_HDSTA_SUSTA_var_T_HDSTA(var) var=(Reserved_for_RAL_32 & TW_V1_T_HDSTA_SUSTA_m_T_HDSTA(var)) >> TW_V1_T_HDSTA_SUSTA_s_T_HDSTA(var);
#define TW_V1_T_HDSTA_SUSTA_m_Unused9 0xfe00
#define TW_V1_T_HDSTA_SUSTA_s_T_SUSTA(val) 0x10
#define TW_V1_T_HDSTA_SUSTA_m_T_SUSTA(val) 0x1ff0000UL
#define TW_V1_T_HDSTA_SUSTA_v_T_SUSTA(val) (((RALuint32)(val)<<TW_V1_T_HDSTA_SUSTA_s_T_SUSTA(val))&TW_V1_T_HDSTA_SUSTA_m_T_SUSTA(val))
#define TW_V1_T_HDSTA_SUSTA_var_T_SUSTA(var) var=(Reserved_for_RAL_32 & TW_V1_T_HDSTA_SUSTA_m_T_SUSTA(var)) >> TW_V1_T_HDSTA_SUSTA_s_T_SUSTA(var);
#define TW_V1_T_HDSTA_SUSTA_m_Unused25 0xfe000000UL

#define TW_V1_T_HDSTA_SUSTA_OFF 0x00000018
#define TW_V1_T_HDSTA_SUSTA_SIZE 32

#define TW_V1_T_HDSTA_SUSTA_SET(BlkInfo, ...) _TW_V1_T_HDSTA_SUSTA_SET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_T_HDSTA_SUSTA_SET(BlkInfo, count, ...) __TW_V1_T_HDSTA_SUSTA_SET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_T_HDSTA_SUSTA_SET(BlkInfo, count, ...) _TW_V1_T_HDSTA_SUSTA_SET ## count(BlkInfo, __VA_ARGS__)

#define ___TW_V1_T_HDSTA_SUSTA_SET(BlkInfo, mask, value) \
do {\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x00000018,\
~(0L | mask  | TW_V1_T_HDSTA_SUSTA_m_Unused9 | TW_V1_T_HDSTA_SUSTA_m_Unused25), 0L | value);\
} while(0)


#define _TW_V1_T_HDSTA_SUSTA_SET1(BlkInfo, fld1) \
___TW_V1_T_HDSTA_SUSTA_SET(BlkInfo, TW_V1_T_HDSTA_SUSTA_m_##fld1, \
TW_V1_T_HDSTA_SUSTA_v_##fld1)

#define _TW_V1_T_HDSTA_SUSTA_SET2(BlkInfo, fld1, fld3) \
___TW_V1_T_HDSTA_SUSTA_SET(BlkInfo, TW_V1_T_HDSTA_SUSTA_m_##fld1 | TW_V1_T_HDSTA_SUSTA_m_##fld3, \
TW_V1_T_HDSTA_SUSTA_v_##fld1 | TW_V1_T_HDSTA_SUSTA_v_##fld3)

#define TW_V1_T_HDSTA_SUSTA_SET1(BlkInfo, fld1) \
{\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x00000018,\
~(0L | TW_V1_T_HDSTA_SUSTA_m_##fld1),\
0L | TW_V1_T_HDSTA_SUSTA_v_##fld1);\
}


#define TW_V1_T_HDSTA_SUSTA_DEF(fld1, fld3) \
{\
0 | TW_V1_T_HDSTA_SUSTA_v_##fld1 | TW_V1_T_HDSTA_SUSTA_v_##fld3, \
~(0L | TW_V1_T_HDSTA_SUSTA_m_##fld1 | TW_V1_T_HDSTA_SUSTA_m_Unused9 | TW_V1_T_HDSTA_SUSTA_m_##fld3 | TW_V1_T_HDSTA_SUSTA_m_Unused25), \
32, \
0x00000018 \
}

#define TW_V1_T_HDSTA_SUSTA_MEM(RegEntry, fld1, fld3) \
RegEntry.dwValue = (RegEntry.dwValue & ~(0L | TW_V1_T_HDSTA_SUSTA_m_##fld1 | TW_V1_T_HDSTA_SUSTA_m_Unused9 | TW_V1_T_HDSTA_SUSTA_m_##fld3 | TW_V1_T_HDSTA_SUSTA_m_Unused25))| \
(0 | TW_V1_T_HDSTA_SUSTA_v_##fld1 | TW_V1_T_HDSTA_SUSTA_v_##fld3);\
RegEntry.dwMask &= ~(0L | TW_V1_T_HDSTA_SUSTA_m_##fld1 | TW_V1_T_HDSTA_SUSTA_m_Unused9 | TW_V1_T_HDSTA_SUSTA_m_##fld3 | TW_V1_T_HDSTA_SUSTA_m_Unused25)

#define TW_V1_T_HDSTA_SUSTA_GET(BlkInfo, ...) _TW_V1_T_HDSTA_SUSTA_GET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_T_HDSTA_SUSTA_GET(BlkInfo, count, ...) __TW_V1_T_HDSTA_SUSTA_GET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_T_HDSTA_SUSTA_GET(BlkInfo, count, ...) _TW_V1_T_HDSTA_SUSTA_GET ## count(BlkInfo, __VA_ARGS__)

#define _TW_V1_T_HDSTA_SUSTA_GET1(BlkInfo, fld0) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000018, &Reserved_for_RAL_32); \
TW_V1_T_HDSTA_SUSTA_var_##fld0  \
} while(0)


#define _TW_V1_T_HDSTA_SUSTA_GET2(BlkInfo, fld0, fld1) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000018, &Reserved_for_RAL_32); \
TW_V1_T_HDSTA_SUSTA_var_##fld0  \
TW_V1_T_HDSTA_SUSTA_var_##fld1  \
} while(0)


#define _TW_V1_T_HDSTA_SUSTA_GET3(BlkInfo, fld0, fld1, fld3) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000018, &Reserved_for_RAL_32); \
TW_V1_T_HDSTA_SUSTA_var_##fld0  \
TW_V1_T_HDSTA_SUSTA_var_##fld1  \
TW_V1_T_HDSTA_SUSTA_var_##fld3  \
} while(0)


#define TW_V1_T_HDSTA_SUSTA_GET1(BlkInfo, fld1)  \
{\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000018, &Reserved_for_RAL_32); \
TW_V1_T_HDSTA_SUSTA_var_##fld1 \
}
/*==========================================================================*/

/*Two-wire Master DRVEN and SMPEN Counter*/
#define TW_V1_T_DRVEN_SMPEN_m_ 0x0
#define TW_V1_T_DRVEN_SMPEN_s_ 0x0
#define TW_V1_T_DRVEN_SMPEN_v_ 0x0
#define TW_V1_T_DRVEN_SMPEN_m_ALL(val) 0xffffffffUL
#define TW_V1_T_DRVEN_SMPEN_s_ALL(val) 0x0
#define TW_V1_T_DRVEN_SMPEN_v_ALL(val) ((RALuint32)(val))
#define TW_V1_T_DRVEN_SMPEN_var_
#define TW_V1_T_DRVEN_SMPEN_var_ALL(var) var=Reserved_for_RAL_24;
#define TW_V1_T_DRVEN_SMPEN_s_T_DRVEN(val) 0x0
#define TW_V1_T_DRVEN_SMPEN_m_T_DRVEN(val) 0x1ff
#define TW_V1_T_DRVEN_SMPEN_v_T_DRVEN(val) (((RALuint16)(val)<<TW_V1_T_DRVEN_SMPEN_s_T_DRVEN(val))&TW_V1_T_DRVEN_SMPEN_m_T_DRVEN(val))
#define TW_V1_T_DRVEN_SMPEN_var_T_DRVEN(var) var=(Reserved_for_RAL_24 & TW_V1_T_DRVEN_SMPEN_m_T_DRVEN(var)) >> TW_V1_T_DRVEN_SMPEN_s_T_DRVEN(var);
#define TW_V1_T_DRVEN_SMPEN_m_Unused9 0xfe00
#define TW_V1_T_DRVEN_SMPEN_s_T_SMPEN(val) 0x10
#define TW_V1_T_DRVEN_SMPEN_m_T_SMPEN(val) 0x7f0000UL
#define TW_V1_T_DRVEN_SMPEN_v_T_SMPEN(val) (((RALuint32)(val)<<TW_V1_T_DRVEN_SMPEN_s_T_SMPEN(val))&TW_V1_T_DRVEN_SMPEN_m_T_SMPEN(val))
#define TW_V1_T_DRVEN_SMPEN_var_T_SMPEN(var) var=(Reserved_for_RAL_24 & TW_V1_T_DRVEN_SMPEN_m_T_SMPEN(var)) >> TW_V1_T_DRVEN_SMPEN_s_T_SMPEN(var);
#define TW_V1_T_DRVEN_SMPEN_m_Unused23 0xff800000UL

#define TW_V1_T_DRVEN_SMPEN_OFF 0x0000001c
#define TW_V1_T_DRVEN_SMPEN_SIZE 24

#define TW_V1_T_DRVEN_SMPEN_SET(BlkInfo, ...) _TW_V1_T_DRVEN_SMPEN_SET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_T_DRVEN_SMPEN_SET(BlkInfo, count, ...) __TW_V1_T_DRVEN_SMPEN_SET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_T_DRVEN_SMPEN_SET(BlkInfo, count, ...) _TW_V1_T_DRVEN_SMPEN_SET ## count(BlkInfo, __VA_ARGS__)

#define ___TW_V1_T_DRVEN_SMPEN_SET(BlkInfo, mask, value) \
do {\
(BlkInfo)->errorState = (BlkInfo)->RegWrite24(BlkInfo, (BlkInfo)->BaseAddress+0x0000001c,\
~(0L | mask  | TW_V1_T_DRVEN_SMPEN_m_Unused9 | TW_V1_T_DRVEN_SMPEN_m_Unused23), 0L | value);\
} while(0)


#define _TW_V1_T_DRVEN_SMPEN_SET1(BlkInfo, fld1) \
___TW_V1_T_DRVEN_SMPEN_SET(BlkInfo, TW_V1_T_DRVEN_SMPEN_m_##fld1, \
TW_V1_T_DRVEN_SMPEN_v_##fld1)

#define _TW_V1_T_DRVEN_SMPEN_SET2(BlkInfo, fld1, fld3) \
___TW_V1_T_DRVEN_SMPEN_SET(BlkInfo, TW_V1_T_DRVEN_SMPEN_m_##fld1 | TW_V1_T_DRVEN_SMPEN_m_##fld3, \
TW_V1_T_DRVEN_SMPEN_v_##fld1 | TW_V1_T_DRVEN_SMPEN_v_##fld3)

#define TW_V1_T_DRVEN_SMPEN_SET1(BlkInfo, fld1) \
{\
(BlkInfo)->errorState = (BlkInfo)->RegWrite24(BlkInfo, (BlkInfo)->BaseAddress+0x0000001c,\
~(0L | TW_V1_T_DRVEN_SMPEN_m_##fld1),\
0L | TW_V1_T_DRVEN_SMPEN_v_##fld1);\
}


#define TW_V1_T_DRVEN_SMPEN_DEF(fld1, fld3) \
{\
0 | TW_V1_T_DRVEN_SMPEN_v_##fld1 | TW_V1_T_DRVEN_SMPEN_v_##fld3, \
~(0L | TW_V1_T_DRVEN_SMPEN_m_##fld1 | TW_V1_T_DRVEN_SMPEN_m_Unused9 | TW_V1_T_DRVEN_SMPEN_m_##fld3 | TW_V1_T_DRVEN_SMPEN_m_Unused23), \
24, \
0x0000001c \
}

#define TW_V1_T_DRVEN_SMPEN_MEM(RegEntry, fld1, fld3) \
RegEntry.dwValue = (RegEntry.dwValue & ~(0L | TW_V1_T_DRVEN_SMPEN_m_##fld1 | TW_V1_T_DRVEN_SMPEN_m_Unused9 | TW_V1_T_DRVEN_SMPEN_m_##fld3 | TW_V1_T_DRVEN_SMPEN_m_Unused23))| \
(0 | TW_V1_T_DRVEN_SMPEN_v_##fld1 | TW_V1_T_DRVEN_SMPEN_v_##fld3);\
RegEntry.dwMask &= ~(0L | TW_V1_T_DRVEN_SMPEN_m_##fld1 | TW_V1_T_DRVEN_SMPEN_m_Unused9 | TW_V1_T_DRVEN_SMPEN_m_##fld3 | TW_V1_T_DRVEN_SMPEN_m_Unused23)

#define TW_V1_T_DRVEN_SMPEN_GET(BlkInfo, ...) _TW_V1_T_DRVEN_SMPEN_GET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_T_DRVEN_SMPEN_GET(BlkInfo, count, ...) __TW_V1_T_DRVEN_SMPEN_GET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_T_DRVEN_SMPEN_GET(BlkInfo, count, ...) _TW_V1_T_DRVEN_SMPEN_GET ## count(BlkInfo, __VA_ARGS__)

#define _TW_V1_T_DRVEN_SMPEN_GET1(BlkInfo, fld0) \
do {\
RALuint24 Reserved_for_RAL_24;\
(BlkInfo)->errorState = (BlkInfo)->RegRead24(BlkInfo, (BlkInfo)->BaseAddress+0x0000001c, &Reserved_for_RAL_24); \
TW_V1_T_DRVEN_SMPEN_var_##fld0  \
} while(0)


#define _TW_V1_T_DRVEN_SMPEN_GET2(BlkInfo, fld0, fld1) \
do {\
RALuint24 Reserved_for_RAL_24;\
(BlkInfo)->errorState = (BlkInfo)->RegRead24(BlkInfo, (BlkInfo)->BaseAddress+0x0000001c, &Reserved_for_RAL_24); \
TW_V1_T_DRVEN_SMPEN_var_##fld0  \
TW_V1_T_DRVEN_SMPEN_var_##fld1  \
} while(0)


#define _TW_V1_T_DRVEN_SMPEN_GET3(BlkInfo, fld0, fld1, fld3) \
do {\
RALuint24 Reserved_for_RAL_24;\
(BlkInfo)->errorState = (BlkInfo)->RegRead24(BlkInfo, (BlkInfo)->BaseAddress+0x0000001c, &Reserved_for_RAL_24); \
TW_V1_T_DRVEN_SMPEN_var_##fld0  \
TW_V1_T_DRVEN_SMPEN_var_##fld1  \
TW_V1_T_DRVEN_SMPEN_var_##fld3  \
} while(0)


#define TW_V1_T_DRVEN_SMPEN_GET1(BlkInfo, fld1)  \
{\
RALuint24 Reserved_for_RAL_24;\
(BlkInfo)->errorState = (BlkInfo)->RegRead24(BlkInfo, (BlkInfo)->BaseAddress+0x0000001c, &Reserved_for_RAL_24); \
TW_V1_T_DRVEN_SMPEN_var_##fld1 \
}
/*==========================================================================*/

/*Two-wire Slave Read FIFO Register:*/
#define TW_V1_SRFIFO_m_ 0x0
#define TW_V1_SRFIFO_s_ 0x0
#define TW_V1_SRFIFO_v_ 0x0
#define TW_V1_SRFIFO_m_ALL(val) 0xffffffffUL
#define TW_V1_SRFIFO_s_ALL(val) 0x0
#define TW_V1_SRFIFO_v_ALL(val) ((RALuint32)(val))
#define TW_V1_SRFIFO_var_
#define TW_V1_SRFIFO_var_ALL(var) var=Reserved_for_RAL_8;
#define TW_V1_SRFIFO_s_RDATA(val) 0x0
#define TW_V1_SRFIFO_m_RDATA(val) 0xff
#define TW_V1_SRFIFO_v_RDATA(val) (((val)<<TW_V1_SRFIFO_s_RDATA(val))&TW_V1_SRFIFO_m_RDATA(val))
#define TW_V1_SRFIFO_var_RDATA(var) var=(Reserved_for_RAL_8 & TW_V1_SRFIFO_m_RDATA(var)) >> TW_V1_SRFIFO_s_RDATA(var);
#define TW_V1_SRFIFO_m_Unused8 0xffffff00UL

#define TW_V1_SRFIFO_OFF 0x00000020
#define TW_V1_SRFIFO_SIZE 8

#define TW_V1_SRFIFO_GET(BlkInfo, ...) _TW_V1_SRFIFO_GET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_SRFIFO_GET(BlkInfo, count, ...) __TW_V1_SRFIFO_GET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_SRFIFO_GET(BlkInfo, count, ...) _TW_V1_SRFIFO_GET ## count(BlkInfo, __VA_ARGS__)

#define _TW_V1_SRFIFO_GET1(BlkInfo, fld0) \
do {\
RALuint8 Reserved_for_RAL_8;\
(BlkInfo)->errorState = (BlkInfo)->RegRead8(BlkInfo, (BlkInfo)->BaseAddress+0x00000020, &Reserved_for_RAL_8); \
TW_V1_SRFIFO_var_##fld0  \
} while(0)


#define _TW_V1_SRFIFO_GET2(BlkInfo, fld0, fld1) \
do {\
RALuint8 Reserved_for_RAL_8;\
(BlkInfo)->errorState = (BlkInfo)->RegRead8(BlkInfo, (BlkInfo)->BaseAddress+0x00000020, &Reserved_for_RAL_8); \
TW_V1_SRFIFO_var_##fld0  \
TW_V1_SRFIFO_var_##fld1  \
} while(0)


#define TW_V1_SRFIFO_GET1(BlkInfo, fld1)  \
{\
RALuint8 Reserved_for_RAL_8;\
(BlkInfo)->errorState = (BlkInfo)->RegRead8(BlkInfo, (BlkInfo)->BaseAddress+0x00000020, &Reserved_for_RAL_8); \
TW_V1_SRFIFO_var_##fld1 \
}
/*==========================================================================*/

/*Two-wire Slave Write FIFO Register:*/
#define TW_V1_SWFIFO_m_ 0x0
#define TW_V1_SWFIFO_s_ 0x0
#define TW_V1_SWFIFO_v_ 0x0
#define TW_V1_SWFIFO_m_ALL(val) 0xffffffffUL
#define TW_V1_SWFIFO_s_ALL(val) 0x0
#define TW_V1_SWFIFO_v_ALL(val) ((RALuint32)(val))
#define TW_V1_SWFIFO_var_
#define TW_V1_SWFIFO_var_ALL(var) var=Reserved_for_RAL_8;
#define TW_V1_SWFIFO_s_WDATA(val) 0x0
#define TW_V1_SWFIFO_m_WDATA(val) 0xff
#define TW_V1_SWFIFO_v_WDATA(val) (((val)<<TW_V1_SWFIFO_s_WDATA(val))&TW_V1_SWFIFO_m_WDATA(val))
#define TW_V1_SWFIFO_var_WDATA(var) var=(Reserved_for_RAL_8 & TW_V1_SWFIFO_m_WDATA(var)) >> TW_V1_SWFIFO_s_WDATA(var);
#define TW_V1_SWFIFO_m_Unused8 0xffffff00UL

#define TW_V1_SWFIFO_OFF 0x00000024
#define TW_V1_SWFIFO_SIZE 8

#define TW_V1_SWFIFO_SET(BlkInfo, ...) _TW_V1_SWFIFO_SET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_SWFIFO_SET(BlkInfo, count, ...) __TW_V1_SWFIFO_SET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_SWFIFO_SET(BlkInfo, count, ...) _TW_V1_SWFIFO_SET ## count(BlkInfo, __VA_ARGS__)

#define ___TW_V1_SWFIFO_SET(BlkInfo, mask, value) \
do {\
(BlkInfo)->errorState = (BlkInfo)->RegWrite8(BlkInfo, (BlkInfo)->BaseAddress+0x00000024,\
(RALuint8)~(0 | mask ), 0 | value);\
} while(0)


#define _TW_V1_SWFIFO_SET1(BlkInfo, fld1) \
___TW_V1_SWFIFO_SET(BlkInfo, TW_V1_SWFIFO_m_##fld1, \
TW_V1_SWFIFO_v_##fld1)

#define TW_V1_SWFIFO_SET1(BlkInfo, fld1) \
{\
(BlkInfo)->errorState = (BlkInfo)->RegWrite8(BlkInfo, (BlkInfo)->BaseAddress+0x00000024,\
(RALuint8)~(0 | TW_V1_SWFIFO_m_##fld1),\
0 | TW_V1_SWFIFO_v_##fld1);\
}


#define TW_V1_SWFIFO_DEF(fld1) \
{\
0 | TW_V1_SWFIFO_v_##fld1, \
(RALuint8)~(0L | TW_V1_SWFIFO_m_##fld1), \
8, \
0x00000024 \
}

#define TW_V1_SWFIFO_MEM(RegEntry, fld1) \
RegEntry.dwValue = (RegEntry.dwValue & ~(0L | TW_V1_SWFIFO_m_##fld1))| \
(0 | TW_V1_SWFIFO_v_##fld1);\
RegEntry.dwMask &= ~(0L | TW_V1_SWFIFO_m_##fld1)
/*==========================================================================*/

/*Two-wire Slave Read and Write FIFO Status and Configuration Register:*/
#define TW_V1_SFIFOSTAT_m_ 0x0
#define TW_V1_SFIFOSTAT_s_ 0x0
#define TW_V1_SFIFOSTAT_v_ 0x0
#define TW_V1_SFIFOSTAT_m_ALL(val) 0xffffffffUL
#define TW_V1_SFIFOSTAT_s_ALL(val) 0x0
#define TW_V1_SFIFOSTAT_v_ALL(val) ((RALuint32)(val))
#define TW_V1_SFIFOSTAT_var_
#define TW_V1_SFIFOSTAT_var_ALL(var) var=Reserved_for_RAL_32;
#define TW_V1_SFIFOSTAT_s_WFNE(val) 0x0
#define TW_V1_SFIFOSTAT_m_WFNE(val) 0xff
#define TW_V1_SFIFOSTAT_v_WFNE(val) (((val)<<TW_V1_SFIFOSTAT_s_WFNE(val))&TW_V1_SFIFOSTAT_m_WFNE(val))
#define TW_V1_SFIFOSTAT_var_WFNE(var) var=(Reserved_for_RAL_32 & TW_V1_SFIFOSTAT_m_WFNE(var)) >> TW_V1_SFIFOSTAT_s_WFNE(var);
#define TW_V1_SFIFOSTAT_s_RFNE(val) 0x8
#define TW_V1_SFIFOSTAT_m_RFNE(val) 0xff00
#define TW_V1_SFIFOSTAT_v_RFNE(val) (((RALuint16)(val)<<TW_V1_SFIFOSTAT_s_RFNE(val))&TW_V1_SFIFOSTAT_m_RFNE(val))
#define TW_V1_SFIFOSTAT_var_RFNE(var) var=(Reserved_for_RAL_32 & TW_V1_SFIFOSTAT_m_RFNE(var)) >> TW_V1_SFIFOSTAT_s_RFNE(var);
#define TW_V1_SFIFOSTAT_s_WFSZ(val) 0x10
#define TW_V1_SFIFOSTAT_m_WFSZ(val) 0xff0000UL
#define TW_V1_SFIFOSTAT_v_WFSZ(val) (((RALuint32)(val)<<TW_V1_SFIFOSTAT_s_WFSZ(val))&TW_V1_SFIFOSTAT_m_WFSZ(val))
#define TW_V1_SFIFOSTAT_var_WFSZ(var) var=(Reserved_for_RAL_32 & TW_V1_SFIFOSTAT_m_WFSZ(var)) >> TW_V1_SFIFOSTAT_s_WFSZ(var);
#define TW_V1_SFIFOSTAT_s_RFSZ(val) 0x18
#define TW_V1_SFIFOSTAT_m_RFSZ(val) 0xff000000UL
#define TW_V1_SFIFOSTAT_v_RFSZ(val) (((RALuint32)(val)<<TW_V1_SFIFOSTAT_s_RFSZ(val))&TW_V1_SFIFOSTAT_m_RFSZ(val))
#define TW_V1_SFIFOSTAT_var_RFSZ(var) var=(Reserved_for_RAL_32 & TW_V1_SFIFOSTAT_m_RFSZ(var)) >> TW_V1_SFIFOSTAT_s_RFSZ(var);

#define TW_V1_SFIFOSTAT_OFF 0x00000028
#define TW_V1_SFIFOSTAT_SIZE 32

#define TW_V1_SFIFOSTAT_GET(BlkInfo, ...) _TW_V1_SFIFOSTAT_GET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_SFIFOSTAT_GET(BlkInfo, count, ...) __TW_V1_SFIFOSTAT_GET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_SFIFOSTAT_GET(BlkInfo, count, ...) _TW_V1_SFIFOSTAT_GET ## count(BlkInfo, __VA_ARGS__)

#define _TW_V1_SFIFOSTAT_GET1(BlkInfo, fld0) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000028, &Reserved_for_RAL_32); \
TW_V1_SFIFOSTAT_var_##fld0  \
} while(0)


#define _TW_V1_SFIFOSTAT_GET2(BlkInfo, fld0, fld1) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000028, &Reserved_for_RAL_32); \
TW_V1_SFIFOSTAT_var_##fld0  \
TW_V1_SFIFOSTAT_var_##fld1  \
} while(0)


#define _TW_V1_SFIFOSTAT_GET3(BlkInfo, fld0, fld1, fld2) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000028, &Reserved_for_RAL_32); \
TW_V1_SFIFOSTAT_var_##fld0  \
TW_V1_SFIFOSTAT_var_##fld1  \
TW_V1_SFIFOSTAT_var_##fld2  \
} while(0)


#define _TW_V1_SFIFOSTAT_GET4(BlkInfo, fld0, fld1, fld2, fld3) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000028, &Reserved_for_RAL_32); \
TW_V1_SFIFOSTAT_var_##fld0  \
TW_V1_SFIFOSTAT_var_##fld1  \
TW_V1_SFIFOSTAT_var_##fld2  \
TW_V1_SFIFOSTAT_var_##fld3  \
} while(0)


#define _TW_V1_SFIFOSTAT_GET5(BlkInfo, fld0, fld1, fld2, fld3, fld4) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000028, &Reserved_for_RAL_32); \
TW_V1_SFIFOSTAT_var_##fld0  \
TW_V1_SFIFOSTAT_var_##fld1  \
TW_V1_SFIFOSTAT_var_##fld2  \
TW_V1_SFIFOSTAT_var_##fld3  \
TW_V1_SFIFOSTAT_var_##fld4  \
} while(0)


#define TW_V1_SFIFOSTAT_GET1(BlkInfo, fld1)  \
{\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000028, &Reserved_for_RAL_32); \
TW_V1_SFIFOSTAT_var_##fld1 \
}
/*==========================================================================*/

/*Two-wire Slave Control and Status Register:*/
#define TW_V1_SCTL_m_ 0x0
#define TW_V1_SCTL_s_ 0x0
#define TW_V1_SCTL_v_ 0x0
#define TW_V1_SCTL_m_ALL(val) 0xffffffffUL
#define TW_V1_SCTL_s_ALL(val) 0x0
#define TW_V1_SCTL_v_ALL(val) ((RALuint32)(val))
#define TW_V1_SCTL_var_
#define TW_V1_SCTL_var_ALL(var) var=Reserved_for_RAL_32;
#define TW_V1_SCTL_s_BUSSTATE(val) 0x0
#define TW_V1_SCTL_m_BUSSTATE(val) 0x3
#define TW_V1_SCTL_v_BUSSTATE(val) (((val)<<TW_V1_SCTL_s_BUSSTATE(val))&TW_V1_SCTL_m_BUSSTATE(val))
#define TW_V1_SCTL_var_BUSSTATE(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_BUSSTATE(var)) >> TW_V1_SCTL_s_BUSSTATE(var);
#define TW_V1_SCTL_s_SWFLOCK(val) 0x2
#define TW_V1_SCTL_m_SWFLOCK(val) 0x4
#define TW_V1_SCTL_v_SWFLOCK(val) (((val)<<TW_V1_SCTL_s_SWFLOCK(val))&TW_V1_SCTL_m_SWFLOCK(val))
#define TW_V1_SCTL_var_SWFLOCK(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_SWFLOCK(var)) >> TW_V1_SCTL_s_SWFLOCK(var);
#define TW_V1_SCTL_m_Unused3 0x8
#define TW_V1_SCTL_s_RTACKPND(val) 0x4
#define TW_V1_SCTL_m_RTACKPND(val) 0x10
#define TW_V1_SCTL_v_RTACKPND(val) (((val)<<TW_V1_SCTL_s_RTACKPND(val))&TW_V1_SCTL_m_RTACKPND(val))
#define TW_V1_SCTL_var_RTACKPND(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_RTACKPND(var)) >> TW_V1_SCTL_s_RTACKPND(var);
#define TW_V1_SCTL_s_ALLADDREN(val) 0x5
#define TW_V1_SCTL_m_ALLADDREN(val) 0x20
#define TW_V1_SCTL_v_ALLADDREN(val) (((val)<<TW_V1_SCTL_s_ALLADDREN(val))&TW_V1_SCTL_m_ALLADDREN(val))
#define TW_V1_SCTL_var_ALLADDREN(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_ALLADDREN(var)) >> TW_V1_SCTL_s_ALLADDREN(var);
#define TW_V1_SCTL_s_GENCALL_EN(val) 0x6
#define TW_V1_SCTL_m_GENCALL_EN(val) 0x40
#define TW_V1_SCTL_v_GENCALL_EN(val) (((val)<<TW_V1_SCTL_s_GENCALL_EN(val))&TW_V1_SCTL_m_GENCALL_EN(val))
#define TW_V1_SCTL_var_GENCALL_EN(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_GENCALL_EN(var)) >> TW_V1_SCTL_s_GENCALL_EN(var);
#define TW_V1_SCTL_s_ADDRMODE(val) 0x7
#define TW_V1_SCTL_m_ADDRMODE(val) 0x80
#define TW_V1_SCTL_v_ADDRMODE(val) (((val)<<TW_V1_SCTL_s_ADDRMODE(val))&TW_V1_SCTL_m_ADDRMODE(val))
#define TW_V1_SCTL_var_ADDRMODE(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_ADDRMODE(var)) >> TW_V1_SCTL_s_ADDRMODE(var);
#define TW_V1_SCTL_s_SLVADDR(val) 0x8
#define TW_V1_SCTL_m_SLVADDR(val) 0x3ff00UL
#define TW_V1_SCTL_v_SLVADDR(val) (((RALuint32)(val)<<TW_V1_SCTL_s_SLVADDR(val))&TW_V1_SCTL_m_SLVADDR(val))
#define TW_V1_SCTL_var_SLVADDR(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_SLVADDR(var)) >> TW_V1_SCTL_s_SLVADDR(var);
#define TW_V1_SCTL_s_SCLSTATE(val) 0x12
#define TW_V1_SCTL_m_SCLSTATE(val) 0x40000UL
#define TW_V1_SCTL_v_SCLSTATE(val) (((RALuint32)(val)<<TW_V1_SCTL_s_SCLSTATE(val))&TW_V1_SCTL_m_SCLSTATE(val))
#define TW_V1_SCTL_var_SCLSTATE(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_SCLSTATE(var)) >> TW_V1_SCTL_s_SCLSTATE(var);
#define TW_V1_SCTL_s_SDASTATE(val) 0x13
#define TW_V1_SCTL_m_SDASTATE(val) 0x80000UL
#define TW_V1_SCTL_v_SDASTATE(val) (((RALuint32)(val)<<TW_V1_SCTL_s_SDASTATE(val))&TW_V1_SCTL_m_SDASTATE(val))
#define TW_V1_SCTL_var_SDASTATE(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_SDASTATE(var)) >> TW_V1_SCTL_s_SDASTATE(var);
#define TW_V1_SCTL_s_SWFTHR(val) 0x14
#define TW_V1_SCTL_m_SWFTHR(val) 0x300000UL
#define TW_V1_SCTL_v_SWFTHR(val) (((RALuint32)(val)<<TW_V1_SCTL_s_SWFTHR(val))&TW_V1_SCTL_m_SWFTHR(val))
#define TW_V1_SCTL_var_SWFTHR(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_SWFTHR(var)) >> TW_V1_SCTL_s_SWFTHR(var);
#define TW_V1_SCTL_s_SRFTHR(val) 0x16
#define TW_V1_SCTL_m_SRFTHR(val) 0xc00000UL
#define TW_V1_SCTL_v_SRFTHR(val) (((RALuint32)(val)<<TW_V1_SCTL_s_SRFTHR(val))&TW_V1_SCTL_m_SRFTHR(val))
#define TW_V1_SCTL_var_SRFTHR(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_SRFTHR(var)) >> TW_V1_SCTL_s_SRFTHR(var);
#define TW_V1_SCTL_s_AUTOACK(val) 0x18
#define TW_V1_SCTL_m_AUTOACK(val) 0x1000000UL
#define TW_V1_SCTL_v_AUTOACK(val) (((RALuint32)(val)<<TW_V1_SCTL_s_AUTOACK(val))&TW_V1_SCTL_m_AUTOACK(val))
#define TW_V1_SCTL_var_AUTOACK(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_AUTOACK(var)) >> TW_V1_SCTL_s_AUTOACK(var);
#define TW_V1_SCTL_s_ACKCMD(val) 0x19
#define TW_V1_SCTL_m_ACKCMD(val) 0x6000000UL
#define TW_V1_SCTL_v_ACKCMD(val) (((RALuint32)(val)<<TW_V1_SCTL_s_ACKCMD(val))&TW_V1_SCTL_m_ACKCMD(val))
#define TW_V1_SCTL_var_ACKCMD(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_ACKCMD(var)) >> TW_V1_SCTL_s_ACKCMD(var);
#define TW_V1_SCTL_s_UNLOCK(val) 0x1b
#define TW_V1_SCTL_m_UNLOCK(val) 0x8000000UL
#define TW_V1_SCTL_v_UNLOCK(val) (((RALuint32)(val)<<TW_V1_SCTL_s_UNLOCK(val))&TW_V1_SCTL_m_UNLOCK(val))
#define TW_V1_SCTL_var_UNLOCK(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_UNLOCK(var)) >> TW_V1_SCTL_s_UNLOCK(var);
#define TW_V1_SCTL_s_SRFRST(val) 0x1c
#define TW_V1_SCTL_m_SRFRST(val) 0x10000000UL
#define TW_V1_SCTL_v_SRFRST(val) (((RALuint32)(val)<<TW_V1_SCTL_s_SRFRST(val))&TW_V1_SCTL_m_SRFRST(val))
#define TW_V1_SCTL_var_SRFRST(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_SRFRST(var)) >> TW_V1_SCTL_s_SRFRST(var);
#define TW_V1_SCTL_s_SWFRST(val) 0x1d
#define TW_V1_SCTL_m_SWFRST(val) 0x20000000UL
#define TW_V1_SCTL_v_SWFRST(val) (((RALuint32)(val)<<TW_V1_SCTL_s_SWFRST(val))&TW_V1_SCTL_m_SWFRST(val))
#define TW_V1_SCTL_var_SWFRST(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_SWFRST(var)) >> TW_V1_SCTL_s_SWFRST(var);
#define TW_V1_SCTL_s_SLAVERST(val) 0x1e
#define TW_V1_SCTL_m_SLAVERST(val) 0x40000000UL
#define TW_V1_SCTL_v_SLAVERST(val) (((RALuint32)(val)<<TW_V1_SCTL_s_SLAVERST(val))&TW_V1_SCTL_m_SLAVERST(val))
#define TW_V1_SCTL_var_SLAVERST(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_SLAVERST(var)) >> TW_V1_SCTL_s_SLAVERST(var);
#define TW_V1_SCTL_s_SLAVEEN(val) 0x1f
#define TW_V1_SCTL_m_SLAVEEN(val) 0x80000000UL
#define TW_V1_SCTL_v_SLAVEEN(val) (((RALuint32)(val)<<TW_V1_SCTL_s_SLAVEEN(val))&TW_V1_SCTL_m_SLAVEEN(val))
#define TW_V1_SCTL_var_SLAVEEN(var) var=(Reserved_for_RAL_32 & TW_V1_SCTL_m_SLAVEEN(var)) >> TW_V1_SCTL_s_SLAVEEN(var);

#define TW_V1_SCTL_OFF 0x0000002c
#define TW_V1_SCTL_SIZE 32

#define TW_V1_SCTL_SET(BlkInfo, ...) _TW_V1_SCTL_SET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_SCTL_SET(BlkInfo, count, ...) __TW_V1_SCTL_SET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_SCTL_SET(BlkInfo, count, ...) _TW_V1_SCTL_SET ## count(BlkInfo, __VA_ARGS__)

#define ___TW_V1_SCTL_SET(BlkInfo, mask, value) \
do {\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c,\
~(0L | mask  | TW_V1_SCTL_m_Unused3), 0L | value);\
} while(0)


#define _TW_V1_SCTL_SET1(BlkInfo, fld1) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1, \
TW_V1_SCTL_v_##fld1)

#define _TW_V1_SCTL_SET2(BlkInfo, fld1, fld2) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2)

#define _TW_V1_SCTL_SET3(BlkInfo, fld1, fld2, fld4) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4)

#define _TW_V1_SCTL_SET4(BlkInfo, fld1, fld2, fld4, fld5) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5)

#define _TW_V1_SCTL_SET5(BlkInfo, fld1, fld2, fld4, fld5, fld6) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6)

#define _TW_V1_SCTL_SET6(BlkInfo, fld1, fld2, fld4, fld5, fld6, fld7) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7)

#define _TW_V1_SCTL_SET7(BlkInfo, fld1, fld2, fld4, fld5, fld6, fld7, fld8) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7 | TW_V1_SCTL_v_##fld8)

#define _TW_V1_SCTL_SET8(BlkInfo, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8 | TW_V1_SCTL_m_##fld9, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7 | TW_V1_SCTL_v_##fld8 | TW_V1_SCTL_v_##fld9)

#define _TW_V1_SCTL_SET9(BlkInfo, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8 | TW_V1_SCTL_m_##fld9 | TW_V1_SCTL_m_##fld10, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7 | TW_V1_SCTL_v_##fld8 | TW_V1_SCTL_v_##fld9 | TW_V1_SCTL_v_##fld10)

#define _TW_V1_SCTL_SET10(BlkInfo, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8 | TW_V1_SCTL_m_##fld9 | TW_V1_SCTL_m_##fld10 | TW_V1_SCTL_m_##fld11, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7 | TW_V1_SCTL_v_##fld8 | TW_V1_SCTL_v_##fld9 | TW_V1_SCTL_v_##fld10 | TW_V1_SCTL_v_##fld11)

#define _TW_V1_SCTL_SET11(BlkInfo, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8 | TW_V1_SCTL_m_##fld9 | TW_V1_SCTL_m_##fld10 | TW_V1_SCTL_m_##fld11 | TW_V1_SCTL_m_##fld12, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7 | TW_V1_SCTL_v_##fld8 | TW_V1_SCTL_v_##fld9 | TW_V1_SCTL_v_##fld10 | TW_V1_SCTL_v_##fld11 | TW_V1_SCTL_v_##fld12)

#define _TW_V1_SCTL_SET12(BlkInfo, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8 | TW_V1_SCTL_m_##fld9 | TW_V1_SCTL_m_##fld10 | TW_V1_SCTL_m_##fld11 | TW_V1_SCTL_m_##fld12 | TW_V1_SCTL_m_##fld13, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7 | TW_V1_SCTL_v_##fld8 | TW_V1_SCTL_v_##fld9 | TW_V1_SCTL_v_##fld10 | TW_V1_SCTL_v_##fld11 | TW_V1_SCTL_v_##fld12 | TW_V1_SCTL_v_##fld13)

#define _TW_V1_SCTL_SET13(BlkInfo, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13, fld14) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8 | TW_V1_SCTL_m_##fld9 | TW_V1_SCTL_m_##fld10 | TW_V1_SCTL_m_##fld11 | TW_V1_SCTL_m_##fld12 | TW_V1_SCTL_m_##fld13 | TW_V1_SCTL_m_##fld14, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7 | TW_V1_SCTL_v_##fld8 | TW_V1_SCTL_v_##fld9 | TW_V1_SCTL_v_##fld10 | TW_V1_SCTL_v_##fld11 | TW_V1_SCTL_v_##fld12 | TW_V1_SCTL_v_##fld13 | TW_V1_SCTL_v_##fld14)

#define _TW_V1_SCTL_SET14(BlkInfo, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13, fld14, fld15) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8 | TW_V1_SCTL_m_##fld9 | TW_V1_SCTL_m_##fld10 | TW_V1_SCTL_m_##fld11 | TW_V1_SCTL_m_##fld12 | TW_V1_SCTL_m_##fld13 | TW_V1_SCTL_m_##fld14 | TW_V1_SCTL_m_##fld15, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7 | TW_V1_SCTL_v_##fld8 | TW_V1_SCTL_v_##fld9 | TW_V1_SCTL_v_##fld10 | TW_V1_SCTL_v_##fld11 | TW_V1_SCTL_v_##fld12 | TW_V1_SCTL_v_##fld13 | TW_V1_SCTL_v_##fld14 | TW_V1_SCTL_v_##fld15)

#define _TW_V1_SCTL_SET15(BlkInfo, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13, fld14, fld15, fld16) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8 | TW_V1_SCTL_m_##fld9 | TW_V1_SCTL_m_##fld10 | TW_V1_SCTL_m_##fld11 | TW_V1_SCTL_m_##fld12 | TW_V1_SCTL_m_##fld13 | TW_V1_SCTL_m_##fld14 | TW_V1_SCTL_m_##fld15 | TW_V1_SCTL_m_##fld16, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7 | TW_V1_SCTL_v_##fld8 | TW_V1_SCTL_v_##fld9 | TW_V1_SCTL_v_##fld10 | TW_V1_SCTL_v_##fld11 | TW_V1_SCTL_v_##fld12 | TW_V1_SCTL_v_##fld13 | TW_V1_SCTL_v_##fld14 | TW_V1_SCTL_v_##fld15 | TW_V1_SCTL_v_##fld16)

#define _TW_V1_SCTL_SET16(BlkInfo, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13, fld14, fld15, fld16, fld17) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8 | TW_V1_SCTL_m_##fld9 | TW_V1_SCTL_m_##fld10 | TW_V1_SCTL_m_##fld11 | TW_V1_SCTL_m_##fld12 | TW_V1_SCTL_m_##fld13 | TW_V1_SCTL_m_##fld14 | TW_V1_SCTL_m_##fld15 | TW_V1_SCTL_m_##fld16 | TW_V1_SCTL_m_##fld17, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7 | TW_V1_SCTL_v_##fld8 | TW_V1_SCTL_v_##fld9 | TW_V1_SCTL_v_##fld10 | TW_V1_SCTL_v_##fld11 | TW_V1_SCTL_v_##fld12 | TW_V1_SCTL_v_##fld13 | TW_V1_SCTL_v_##fld14 | TW_V1_SCTL_v_##fld15 | TW_V1_SCTL_v_##fld16 | TW_V1_SCTL_v_##fld17)

#define _TW_V1_SCTL_SET17(BlkInfo, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8 | TW_V1_SCTL_m_##fld9 | TW_V1_SCTL_m_##fld10 | TW_V1_SCTL_m_##fld11 | TW_V1_SCTL_m_##fld12 | TW_V1_SCTL_m_##fld13 | TW_V1_SCTL_m_##fld14 | TW_V1_SCTL_m_##fld15 | TW_V1_SCTL_m_##fld16 | TW_V1_SCTL_m_##fld17 | TW_V1_SCTL_m_##fld18, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7 | TW_V1_SCTL_v_##fld8 | TW_V1_SCTL_v_##fld9 | TW_V1_SCTL_v_##fld10 | TW_V1_SCTL_v_##fld11 | TW_V1_SCTL_v_##fld12 | TW_V1_SCTL_v_##fld13 | TW_V1_SCTL_v_##fld14 | TW_V1_SCTL_v_##fld15 | TW_V1_SCTL_v_##fld16 | TW_V1_SCTL_v_##fld17 | TW_V1_SCTL_v_##fld18)

#define _TW_V1_SCTL_SET18(BlkInfo, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19) \
___TW_V1_SCTL_SET(BlkInfo, TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8 | TW_V1_SCTL_m_##fld9 | TW_V1_SCTL_m_##fld10 | TW_V1_SCTL_m_##fld11 | TW_V1_SCTL_m_##fld12 | TW_V1_SCTL_m_##fld13 | TW_V1_SCTL_m_##fld14 | TW_V1_SCTL_m_##fld15 | TW_V1_SCTL_m_##fld16 | TW_V1_SCTL_m_##fld17 | TW_V1_SCTL_m_##fld18 | TW_V1_SCTL_m_##fld19, \
TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7 | TW_V1_SCTL_v_##fld8 | TW_V1_SCTL_v_##fld9 | TW_V1_SCTL_v_##fld10 | TW_V1_SCTL_v_##fld11 | TW_V1_SCTL_v_##fld12 | TW_V1_SCTL_v_##fld13 | TW_V1_SCTL_v_##fld14 | TW_V1_SCTL_v_##fld15 | TW_V1_SCTL_v_##fld16 | TW_V1_SCTL_v_##fld17 | TW_V1_SCTL_v_##fld18 | TW_V1_SCTL_v_##fld19)

#define TW_V1_SCTL_SET1(BlkInfo, fld1) \
{\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c,\
~(0L | TW_V1_SCTL_m_##fld1),\
0L | TW_V1_SCTL_v_##fld1);\
}


#define TW_V1_SCTL_DEF(fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19) \
{\
0 | TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7 | TW_V1_SCTL_v_##fld8 | TW_V1_SCTL_v_##fld9 | TW_V1_SCTL_v_##fld10 | TW_V1_SCTL_v_##fld11 | TW_V1_SCTL_v_##fld12 | TW_V1_SCTL_v_##fld13 | TW_V1_SCTL_v_##fld14 | TW_V1_SCTL_v_##fld15 | TW_V1_SCTL_v_##fld16 | TW_V1_SCTL_v_##fld17 | TW_V1_SCTL_v_##fld18 | TW_V1_SCTL_v_##fld19, \
~(0L | TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_Unused3 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8 | TW_V1_SCTL_m_##fld9 | TW_V1_SCTL_m_##fld10 | TW_V1_SCTL_m_##fld11 | TW_V1_SCTL_m_##fld12 | TW_V1_SCTL_m_##fld13 | TW_V1_SCTL_m_##fld14 | TW_V1_SCTL_m_##fld15 | TW_V1_SCTL_m_##fld16 | TW_V1_SCTL_m_##fld17 | TW_V1_SCTL_m_##fld18 | TW_V1_SCTL_m_##fld19), \
32, \
0x0000002c \
}

#define TW_V1_SCTL_MEM(RegEntry, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19) \
RegEntry.dwValue = (RegEntry.dwValue & ~(0L | TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_Unused3 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8 | TW_V1_SCTL_m_##fld9 | TW_V1_SCTL_m_##fld10 | TW_V1_SCTL_m_##fld11 | TW_V1_SCTL_m_##fld12 | TW_V1_SCTL_m_##fld13 | TW_V1_SCTL_m_##fld14 | TW_V1_SCTL_m_##fld15 | TW_V1_SCTL_m_##fld16 | TW_V1_SCTL_m_##fld17 | TW_V1_SCTL_m_##fld18 | TW_V1_SCTL_m_##fld19))| \
(0 | TW_V1_SCTL_v_##fld1 | TW_V1_SCTL_v_##fld2 | TW_V1_SCTL_v_##fld4 | TW_V1_SCTL_v_##fld5 | TW_V1_SCTL_v_##fld6 | TW_V1_SCTL_v_##fld7 | TW_V1_SCTL_v_##fld8 | TW_V1_SCTL_v_##fld9 | TW_V1_SCTL_v_##fld10 | TW_V1_SCTL_v_##fld11 | TW_V1_SCTL_v_##fld12 | TW_V1_SCTL_v_##fld13 | TW_V1_SCTL_v_##fld14 | TW_V1_SCTL_v_##fld15 | TW_V1_SCTL_v_##fld16 | TW_V1_SCTL_v_##fld17 | TW_V1_SCTL_v_##fld18 | TW_V1_SCTL_v_##fld19);\
RegEntry.dwMask &= ~(0L | TW_V1_SCTL_m_##fld1 | TW_V1_SCTL_m_##fld2 | TW_V1_SCTL_m_Unused3 | TW_V1_SCTL_m_##fld4 | TW_V1_SCTL_m_##fld5 | TW_V1_SCTL_m_##fld6 | TW_V1_SCTL_m_##fld7 | TW_V1_SCTL_m_##fld8 | TW_V1_SCTL_m_##fld9 | TW_V1_SCTL_m_##fld10 | TW_V1_SCTL_m_##fld11 | TW_V1_SCTL_m_##fld12 | TW_V1_SCTL_m_##fld13 | TW_V1_SCTL_m_##fld14 | TW_V1_SCTL_m_##fld15 | TW_V1_SCTL_m_##fld16 | TW_V1_SCTL_m_##fld17 | TW_V1_SCTL_m_##fld18 | TW_V1_SCTL_m_##fld19)

#define TW_V1_SCTL_GET(BlkInfo, ...) _TW_V1_SCTL_GET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_SCTL_GET(BlkInfo, count, ...) __TW_V1_SCTL_GET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_SCTL_GET(BlkInfo, count, ...) _TW_V1_SCTL_GET ## count(BlkInfo, __VA_ARGS__)

#define _TW_V1_SCTL_GET1(BlkInfo, fld0) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
} while(0)


#define _TW_V1_SCTL_GET2(BlkInfo, fld0, fld1) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
} while(0)


#define _TW_V1_SCTL_GET3(BlkInfo, fld0, fld1, fld2) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
} while(0)


#define _TW_V1_SCTL_GET4(BlkInfo, fld0, fld1, fld2, fld4) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
} while(0)


#define _TW_V1_SCTL_GET5(BlkInfo, fld0, fld1, fld2, fld4, fld5) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
} while(0)


#define _TW_V1_SCTL_GET6(BlkInfo, fld0, fld1, fld2, fld4, fld5, fld6) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
TW_V1_SCTL_var_##fld6  \
} while(0)


#define _TW_V1_SCTL_GET7(BlkInfo, fld0, fld1, fld2, fld4, fld5, fld6, fld7) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
TW_V1_SCTL_var_##fld6  \
TW_V1_SCTL_var_##fld7  \
} while(0)


#define _TW_V1_SCTL_GET8(BlkInfo, fld0, fld1, fld2, fld4, fld5, fld6, fld7, fld8) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
TW_V1_SCTL_var_##fld6  \
TW_V1_SCTL_var_##fld7  \
TW_V1_SCTL_var_##fld8  \
} while(0)


#define _TW_V1_SCTL_GET9(BlkInfo, fld0, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
TW_V1_SCTL_var_##fld6  \
TW_V1_SCTL_var_##fld7  \
TW_V1_SCTL_var_##fld8  \
TW_V1_SCTL_var_##fld9  \
} while(0)


#define _TW_V1_SCTL_GET10(BlkInfo, fld0, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
TW_V1_SCTL_var_##fld6  \
TW_V1_SCTL_var_##fld7  \
TW_V1_SCTL_var_##fld8  \
TW_V1_SCTL_var_##fld9  \
TW_V1_SCTL_var_##fld10  \
} while(0)


#define _TW_V1_SCTL_GET11(BlkInfo, fld0, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
TW_V1_SCTL_var_##fld6  \
TW_V1_SCTL_var_##fld7  \
TW_V1_SCTL_var_##fld8  \
TW_V1_SCTL_var_##fld9  \
TW_V1_SCTL_var_##fld10  \
TW_V1_SCTL_var_##fld11  \
} while(0)


#define _TW_V1_SCTL_GET12(BlkInfo, fld0, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
TW_V1_SCTL_var_##fld6  \
TW_V1_SCTL_var_##fld7  \
TW_V1_SCTL_var_##fld8  \
TW_V1_SCTL_var_##fld9  \
TW_V1_SCTL_var_##fld10  \
TW_V1_SCTL_var_##fld11  \
TW_V1_SCTL_var_##fld12  \
} while(0)


#define _TW_V1_SCTL_GET13(BlkInfo, fld0, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
TW_V1_SCTL_var_##fld6  \
TW_V1_SCTL_var_##fld7  \
TW_V1_SCTL_var_##fld8  \
TW_V1_SCTL_var_##fld9  \
TW_V1_SCTL_var_##fld10  \
TW_V1_SCTL_var_##fld11  \
TW_V1_SCTL_var_##fld12  \
TW_V1_SCTL_var_##fld13  \
} while(0)


#define _TW_V1_SCTL_GET14(BlkInfo, fld0, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13, fld14) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
TW_V1_SCTL_var_##fld6  \
TW_V1_SCTL_var_##fld7  \
TW_V1_SCTL_var_##fld8  \
TW_V1_SCTL_var_##fld9  \
TW_V1_SCTL_var_##fld10  \
TW_V1_SCTL_var_##fld11  \
TW_V1_SCTL_var_##fld12  \
TW_V1_SCTL_var_##fld13  \
TW_V1_SCTL_var_##fld14  \
} while(0)


#define _TW_V1_SCTL_GET15(BlkInfo, fld0, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13, fld14, fld15) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
TW_V1_SCTL_var_##fld6  \
TW_V1_SCTL_var_##fld7  \
TW_V1_SCTL_var_##fld8  \
TW_V1_SCTL_var_##fld9  \
TW_V1_SCTL_var_##fld10  \
TW_V1_SCTL_var_##fld11  \
TW_V1_SCTL_var_##fld12  \
TW_V1_SCTL_var_##fld13  \
TW_V1_SCTL_var_##fld14  \
TW_V1_SCTL_var_##fld15  \
} while(0)


#define _TW_V1_SCTL_GET16(BlkInfo, fld0, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13, fld14, fld15, fld16) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
TW_V1_SCTL_var_##fld6  \
TW_V1_SCTL_var_##fld7  \
TW_V1_SCTL_var_##fld8  \
TW_V1_SCTL_var_##fld9  \
TW_V1_SCTL_var_##fld10  \
TW_V1_SCTL_var_##fld11  \
TW_V1_SCTL_var_##fld12  \
TW_V1_SCTL_var_##fld13  \
TW_V1_SCTL_var_##fld14  \
TW_V1_SCTL_var_##fld15  \
TW_V1_SCTL_var_##fld16  \
} while(0)


#define _TW_V1_SCTL_GET17(BlkInfo, fld0, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13, fld14, fld15, fld16, fld17) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
TW_V1_SCTL_var_##fld6  \
TW_V1_SCTL_var_##fld7  \
TW_V1_SCTL_var_##fld8  \
TW_V1_SCTL_var_##fld9  \
TW_V1_SCTL_var_##fld10  \
TW_V1_SCTL_var_##fld11  \
TW_V1_SCTL_var_##fld12  \
TW_V1_SCTL_var_##fld13  \
TW_V1_SCTL_var_##fld14  \
TW_V1_SCTL_var_##fld15  \
TW_V1_SCTL_var_##fld16  \
TW_V1_SCTL_var_##fld17  \
} while(0)


#define _TW_V1_SCTL_GET18(BlkInfo, fld0, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
TW_V1_SCTL_var_##fld6  \
TW_V1_SCTL_var_##fld7  \
TW_V1_SCTL_var_##fld8  \
TW_V1_SCTL_var_##fld9  \
TW_V1_SCTL_var_##fld10  \
TW_V1_SCTL_var_##fld11  \
TW_V1_SCTL_var_##fld12  \
TW_V1_SCTL_var_##fld13  \
TW_V1_SCTL_var_##fld14  \
TW_V1_SCTL_var_##fld15  \
TW_V1_SCTL_var_##fld16  \
TW_V1_SCTL_var_##fld17  \
TW_V1_SCTL_var_##fld18  \
} while(0)


#define _TW_V1_SCTL_GET19(BlkInfo, fld0, fld1, fld2, fld4, fld5, fld6, fld7, fld8, fld9, fld10, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld0  \
TW_V1_SCTL_var_##fld1  \
TW_V1_SCTL_var_##fld2  \
TW_V1_SCTL_var_##fld4  \
TW_V1_SCTL_var_##fld5  \
TW_V1_SCTL_var_##fld6  \
TW_V1_SCTL_var_##fld7  \
TW_V1_SCTL_var_##fld8  \
TW_V1_SCTL_var_##fld9  \
TW_V1_SCTL_var_##fld10  \
TW_V1_SCTL_var_##fld11  \
TW_V1_SCTL_var_##fld12  \
TW_V1_SCTL_var_##fld13  \
TW_V1_SCTL_var_##fld14  \
TW_V1_SCTL_var_##fld15  \
TW_V1_SCTL_var_##fld16  \
TW_V1_SCTL_var_##fld17  \
TW_V1_SCTL_var_##fld18  \
TW_V1_SCTL_var_##fld19  \
} while(0)


#define TW_V1_SCTL_GET1(BlkInfo, fld1)  \
{\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x0000002c, &Reserved_for_RAL_32); \
TW_V1_SCTL_var_##fld1 \
}
/*==========================================================================*/

/*XTAL Clock Type*/
#define TW_V1_CRYSTAL_FREQ_m_ 0x0
#define TW_V1_CRYSTAL_FREQ_s_ 0x0
#define TW_V1_CRYSTAL_FREQ_v_ 0x0
#define TW_V1_CRYSTAL_FREQ_m_ALL(val) 0xffffffffUL
#define TW_V1_CRYSTAL_FREQ_s_ALL(val) 0x0
#define TW_V1_CRYSTAL_FREQ_v_ALL(val) ((RALuint32)(val))
#define TW_V1_CRYSTAL_FREQ_var_
#define TW_V1_CRYSTAL_FREQ_var_ALL(var) var=Reserved_for_RAL_16;
#define TW_V1_CRYSTAL_FREQ_s_XTAL_TYPE(val) 0x0
#define TW_V1_CRYSTAL_FREQ_m_XTAL_TYPE(val) 0x1
#define TW_V1_CRYSTAL_FREQ_v_XTAL_TYPE(val) (((val)<<TW_V1_CRYSTAL_FREQ_s_XTAL_TYPE(val))&TW_V1_CRYSTAL_FREQ_m_XTAL_TYPE(val))
#define TW_V1_CRYSTAL_FREQ_var_XTAL_TYPE(var) var=(Reserved_for_RAL_16 & TW_V1_CRYSTAL_FREQ_m_XTAL_TYPE(var)) >> TW_V1_CRYSTAL_FREQ_s_XTAL_TYPE(var);
#define TW_V1_CRYSTAL_FREQ_m_Unused1 0xfe
#define TW_V1_CRYSTAL_FREQ_s_TIMEOUT_EN(val) 0x8
#define TW_V1_CRYSTAL_FREQ_m_TIMEOUT_EN(val) 0x100
#define TW_V1_CRYSTAL_FREQ_v_TIMEOUT_EN(val) (((RALuint16)(val)<<TW_V1_CRYSTAL_FREQ_s_TIMEOUT_EN(val))&TW_V1_CRYSTAL_FREQ_m_TIMEOUT_EN(val))
#define TW_V1_CRYSTAL_FREQ_var_TIMEOUT_EN(var) var=(Reserved_for_RAL_16 & TW_V1_CRYSTAL_FREQ_m_TIMEOUT_EN(var)) >> TW_V1_CRYSTAL_FREQ_s_TIMEOUT_EN(var);
#define TW_V1_CRYSTAL_FREQ_m_Unused9 0xfffffe00UL

#define TW_V1_CRYSTAL_FREQ_OFF 0x00000030
#define TW_V1_CRYSTAL_FREQ_SIZE 16

#define TW_V1_CRYSTAL_FREQ_SET(BlkInfo, ...) _TW_V1_CRYSTAL_FREQ_SET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_CRYSTAL_FREQ_SET(BlkInfo, count, ...) __TW_V1_CRYSTAL_FREQ_SET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_CRYSTAL_FREQ_SET(BlkInfo, count, ...) _TW_V1_CRYSTAL_FREQ_SET ## count(BlkInfo, __VA_ARGS__)

#define ___TW_V1_CRYSTAL_FREQ_SET(BlkInfo, mask, value) \
do {\
(BlkInfo)->errorState = (BlkInfo)->RegWrite16(BlkInfo, (BlkInfo)->BaseAddress+0x00000030,\
(RALuint16)~(0 | mask  | TW_V1_CRYSTAL_FREQ_m_Unused1 | TW_V1_CRYSTAL_FREQ_m_Unused9), 0 | value);\
} while(0)


#define _TW_V1_CRYSTAL_FREQ_SET1(BlkInfo, fld1) \
___TW_V1_CRYSTAL_FREQ_SET(BlkInfo, TW_V1_CRYSTAL_FREQ_m_##fld1, \
TW_V1_CRYSTAL_FREQ_v_##fld1)

#define _TW_V1_CRYSTAL_FREQ_SET2(BlkInfo, fld1, fld3) \
___TW_V1_CRYSTAL_FREQ_SET(BlkInfo, TW_V1_CRYSTAL_FREQ_m_##fld1 | TW_V1_CRYSTAL_FREQ_m_##fld3, \
TW_V1_CRYSTAL_FREQ_v_##fld1 | TW_V1_CRYSTAL_FREQ_v_##fld3)

#define TW_V1_CRYSTAL_FREQ_SET1(BlkInfo, fld1) \
{\
(BlkInfo)->errorState = (BlkInfo)->RegWrite16(BlkInfo, (BlkInfo)->BaseAddress+0x00000030,\
(RALuint16)~(0 | TW_V1_CRYSTAL_FREQ_m_##fld1),\
0 | TW_V1_CRYSTAL_FREQ_v_##fld1);\
}


#define TW_V1_CRYSTAL_FREQ_DEF(fld1, fld3) \
{\
0 | TW_V1_CRYSTAL_FREQ_v_##fld1 | TW_V1_CRYSTAL_FREQ_v_##fld3, \
(RALuint16)~(0L | TW_V1_CRYSTAL_FREQ_m_##fld1 | TW_V1_CRYSTAL_FREQ_m_Unused1 | TW_V1_CRYSTAL_FREQ_m_##fld3 | TW_V1_CRYSTAL_FREQ_m_Unused9), \
16, \
0x00000030 \
}

#define TW_V1_CRYSTAL_FREQ_MEM(RegEntry, fld1, fld3) \
RegEntry.dwValue = (RegEntry.dwValue & ~(0L | TW_V1_CRYSTAL_FREQ_m_##fld1 | TW_V1_CRYSTAL_FREQ_m_Unused1 | TW_V1_CRYSTAL_FREQ_m_##fld3 | TW_V1_CRYSTAL_FREQ_m_Unused9))| \
(0 | TW_V1_CRYSTAL_FREQ_v_##fld1 | TW_V1_CRYSTAL_FREQ_v_##fld3);\
RegEntry.dwMask &= ~(0L | TW_V1_CRYSTAL_FREQ_m_##fld1 | TW_V1_CRYSTAL_FREQ_m_Unused1 | TW_V1_CRYSTAL_FREQ_m_##fld3 | TW_V1_CRYSTAL_FREQ_m_Unused9)

#define TW_V1_CRYSTAL_FREQ_GET(BlkInfo, ...) _TW_V1_CRYSTAL_FREQ_GET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_CRYSTAL_FREQ_GET(BlkInfo, count, ...) __TW_V1_CRYSTAL_FREQ_GET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_CRYSTAL_FREQ_GET(BlkInfo, count, ...) _TW_V1_CRYSTAL_FREQ_GET ## count(BlkInfo, __VA_ARGS__)

#define _TW_V1_CRYSTAL_FREQ_GET1(BlkInfo, fld0) \
do {\
RALuint16 Reserved_for_RAL_16;\
(BlkInfo)->errorState = (BlkInfo)->RegRead16(BlkInfo, (BlkInfo)->BaseAddress+0x00000030, &Reserved_for_RAL_16); \
TW_V1_CRYSTAL_FREQ_var_##fld0  \
} while(0)


#define _TW_V1_CRYSTAL_FREQ_GET2(BlkInfo, fld0, fld1) \
do {\
RALuint16 Reserved_for_RAL_16;\
(BlkInfo)->errorState = (BlkInfo)->RegRead16(BlkInfo, (BlkInfo)->BaseAddress+0x00000030, &Reserved_for_RAL_16); \
TW_V1_CRYSTAL_FREQ_var_##fld0  \
TW_V1_CRYSTAL_FREQ_var_##fld1  \
} while(0)


#define _TW_V1_CRYSTAL_FREQ_GET3(BlkInfo, fld0, fld1, fld3) \
do {\
RALuint16 Reserved_for_RAL_16;\
(BlkInfo)->errorState = (BlkInfo)->RegRead16(BlkInfo, (BlkInfo)->BaseAddress+0x00000030, &Reserved_for_RAL_16); \
TW_V1_CRYSTAL_FREQ_var_##fld0  \
TW_V1_CRYSTAL_FREQ_var_##fld1  \
TW_V1_CRYSTAL_FREQ_var_##fld3  \
} while(0)


#define TW_V1_CRYSTAL_FREQ_GET1(BlkInfo, fld1)  \
{\
RALuint16 Reserved_for_RAL_16;\
(BlkInfo)->errorState = (BlkInfo)->RegRead16(BlkInfo, (BlkInfo)->BaseAddress+0x00000030, &Reserved_for_RAL_16); \
TW_V1_CRYSTAL_FREQ_var_##fld1 \
}
/*==========================================================================*/

/*Time Out for NAK*/
#define TW_V1_TIMEOUT_m_ 0x0
#define TW_V1_TIMEOUT_s_ 0x0
#define TW_V1_TIMEOUT_v_ 0x0
#define TW_V1_TIMEOUT_m_ALL(val) 0xffffffffUL
#define TW_V1_TIMEOUT_s_ALL(val) 0x0
#define TW_V1_TIMEOUT_v_ALL(val) ((RALuint32)(val))
#define TW_V1_TIMEOUT_var_
#define TW_V1_TIMEOUT_var_ALL(var) var=Reserved_for_RAL_32;
#define TW_V1_TIMEOUT_s_TIMEOUT_VAL(val) 0x0
#define TW_V1_TIMEOUT_m_TIMEOUT_VAL(val) 0xffffffffUL
#define TW_V1_TIMEOUT_v_TIMEOUT_VAL(val) (((RALuint32)(val)<<TW_V1_TIMEOUT_s_TIMEOUT_VAL(val))&TW_V1_TIMEOUT_m_TIMEOUT_VAL(val))
#define TW_V1_TIMEOUT_var_TIMEOUT_VAL(var) var=(Reserved_for_RAL_32 & TW_V1_TIMEOUT_m_TIMEOUT_VAL(var)) >> TW_V1_TIMEOUT_s_TIMEOUT_VAL(var);

#define TW_V1_TIMEOUT_OFF 0x00000034
#define TW_V1_TIMEOUT_SIZE 32

#define TW_V1_TIMEOUT_SET(BlkInfo, ...) _TW_V1_TIMEOUT_SET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_TIMEOUT_SET(BlkInfo, count, ...) __TW_V1_TIMEOUT_SET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_TIMEOUT_SET(BlkInfo, count, ...) _TW_V1_TIMEOUT_SET ## count(BlkInfo, __VA_ARGS__)

#define ___TW_V1_TIMEOUT_SET(BlkInfo, mask, value) \
do {\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x00000034,\
~(0L | mask ), 0L | value);\
} while(0)


#define _TW_V1_TIMEOUT_SET1(BlkInfo, fld1) \
___TW_V1_TIMEOUT_SET(BlkInfo, TW_V1_TIMEOUT_m_##fld1, \
TW_V1_TIMEOUT_v_##fld1)

#define TW_V1_TIMEOUT_SET1(BlkInfo, fld1) \
{\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x00000034,\
~(0L | TW_V1_TIMEOUT_m_##fld1),\
0L | TW_V1_TIMEOUT_v_##fld1);\
}


#define TW_V1_TIMEOUT_DEF(fld1) \
{\
0 | TW_V1_TIMEOUT_v_##fld1, \
~(0L | TW_V1_TIMEOUT_m_##fld1), \
32, \
0x00000034 \
}

#define TW_V1_TIMEOUT_MEM(RegEntry, fld1) \
RegEntry.dwValue = (RegEntry.dwValue & ~(0L | TW_V1_TIMEOUT_m_##fld1))| \
(0 | TW_V1_TIMEOUT_v_##fld1);\
RegEntry.dwMask &= ~(0L | TW_V1_TIMEOUT_m_##fld1)

#define TW_V1_TIMEOUT_GET(BlkInfo, ...) _TW_V1_TIMEOUT_GET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_TIMEOUT_GET(BlkInfo, count, ...) __TW_V1_TIMEOUT_GET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_TIMEOUT_GET(BlkInfo, count, ...) _TW_V1_TIMEOUT_GET ## count(BlkInfo, __VA_ARGS__)

#define _TW_V1_TIMEOUT_GET1(BlkInfo, fld0) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000034, &Reserved_for_RAL_32); \
TW_V1_TIMEOUT_var_##fld0  \
} while(0)


#define _TW_V1_TIMEOUT_GET2(BlkInfo, fld0, fld1) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000034, &Reserved_for_RAL_32); \
TW_V1_TIMEOUT_var_##fld0  \
TW_V1_TIMEOUT_var_##fld1  \
} while(0)


#define TW_V1_TIMEOUT_GET1(BlkInfo, fld1)  \
{\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000034, &Reserved_for_RAL_32); \
TW_V1_TIMEOUT_var_##fld1 \
}
/*==========================================================================*/

/*Two-wire Interrupt Enable(Mask) Register:*/
#define TW_V1_INTEN_m_ 0x0
#define TW_V1_INTEN_s_ 0x0
#define TW_V1_INTEN_v_ 0x0
#define TW_V1_INTEN_m_ALL(val) 0xffffffffUL
#define TW_V1_INTEN_s_ALL(val) 0x0
#define TW_V1_INTEN_v_ALL(val) ((RALuint32)(val))
#define TW_V1_INTEN_var_
#define TW_V1_INTEN_var_ALL(var) var=Reserved_for_RAL_32;
#define TW_V1_INTEN_s_MNACK(val) 0x0
#define TW_V1_INTEN_m_MNACK(val) 0x1
#define TW_V1_INTEN_v_MNACK(val) (((val)<<TW_V1_INTEN_s_MNACK(val))&TW_V1_INTEN_m_MNACK(val))
#define TW_V1_INTEN_var_MNACK(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_MNACK(var)) >> TW_V1_INTEN_s_MNACK(var);
#define TW_V1_INTEN_s_MBYRCVD(val) 0x1
#define TW_V1_INTEN_m_MBYRCVD(val) 0x2
#define TW_V1_INTEN_v_MBYRCVD(val) (((val)<<TW_V1_INTEN_s_MBYRCVD(val))&TW_V1_INTEN_m_MBYRCVD(val))
#define TW_V1_INTEN_var_MBYRCVD(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_MBYRCVD(var)) >> TW_V1_INTEN_s_MBYRCVD(var);
#define TW_V1_INTEN_s_MARBLOST(val) 0x2
#define TW_V1_INTEN_m_MARBLOST(val) 0x4
#define TW_V1_INTEN_v_MARBLOST(val) (((val)<<TW_V1_INTEN_s_MARBLOST(val))&TW_V1_INTEN_m_MARBLOST(val))
#define TW_V1_INTEN_var_MARBLOST(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_MARBLOST(var)) >> TW_V1_INTEN_s_MARBLOST(var);
#define TW_V1_INTEN_s_MBYCDONE(val) 0x3
#define TW_V1_INTEN_m_MBYCDONE(val) 0x8
#define TW_V1_INTEN_v_MBYCDONE(val) (((val)<<TW_V1_INTEN_s_MBYCDONE(val))&TW_V1_INTEN_m_MBYCDONE(val))
#define TW_V1_INTEN_var_MBYCDONE(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_MBYCDONE(var)) >> TW_V1_INTEN_s_MBYCDONE(var);
#define TW_V1_INTEN_s_MRFLIM(val) 0x4
#define TW_V1_INTEN_m_MRFLIM(val) 0x10
#define TW_V1_INTEN_v_MRFLIM(val) (((val)<<TW_V1_INTEN_s_MRFLIM(val))&TW_V1_INTEN_m_MRFLIM(val))
#define TW_V1_INTEN_var_MRFLIM(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_MRFLIM(var)) >> TW_V1_INTEN_s_MRFLIM(var);
#define TW_V1_INTEN_s_MWFLIM(val) 0x5
#define TW_V1_INTEN_m_MWFLIM(val) 0x20
#define TW_V1_INTEN_v_MWFLIM(val) (((val)<<TW_V1_INTEN_s_MWFLIM(val))&TW_V1_INTEN_m_MWFLIM(val))
#define TW_V1_INTEN_var_MWFLIM(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_MWFLIM(var)) >> TW_V1_INTEN_s_MWFLIM(var);
#define TW_V1_INTEN_s_MILLCMD(val) 0x6
#define TW_V1_INTEN_m_MILLCMD(val) 0x40
#define TW_V1_INTEN_v_MILLCMD(val) (((val)<<TW_V1_INTEN_s_MILLCMD(val))&TW_V1_INTEN_m_MILLCMD(val))
#define TW_V1_INTEN_var_MILLCMD(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_MILLCMD(var)) >> TW_V1_INTEN_s_MILLCMD(var);
#define TW_V1_INTEN_m_Unused7 0x80
#define TW_V1_INTEN_s_MHOLD(val) 0x8
#define TW_V1_INTEN_m_MHOLD(val) 0x100
#define TW_V1_INTEN_v_MHOLD(val) (((RALuint16)(val)<<TW_V1_INTEN_s_MHOLD(val))&TW_V1_INTEN_m_MHOLD(val))
#define TW_V1_INTEN_var_MHOLD(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_MHOLD(var)) >> TW_V1_INTEN_s_MHOLD(var);
#define TW_V1_INTEN_m_Unused9 0xfe00
#define TW_V1_INTEN_s_SNACK(val) 0x10
#define TW_V1_INTEN_m_SNACK(val) 0x10000UL
#define TW_V1_INTEN_v_SNACK(val) (((RALuint32)(val)<<TW_V1_INTEN_s_SNACK(val))&TW_V1_INTEN_m_SNACK(val))
#define TW_V1_INTEN_var_SNACK(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_SNACK(var)) >> TW_V1_INTEN_s_SNACK(var);
#define TW_V1_INTEN_s_SBYRCVD(val) 0x11
#define TW_V1_INTEN_m_SBYRCVD(val) 0x20000UL
#define TW_V1_INTEN_v_SBYRCVD(val) (((RALuint32)(val)<<TW_V1_INTEN_s_SBYRCVD(val))&TW_V1_INTEN_m_SBYRCVD(val))
#define TW_V1_INTEN_var_SBYRCVD(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_SBYRCVD(var)) >> TW_V1_INTEN_s_SBYRCVD(var);
#define TW_V1_INTEN_s_SWRREQ(val) 0x12
#define TW_V1_INTEN_m_SWRREQ(val) 0x40000UL
#define TW_V1_INTEN_v_SWRREQ(val) (((RALuint32)(val)<<TW_V1_INTEN_s_SWRREQ(val))&TW_V1_INTEN_m_SWRREQ(val))
#define TW_V1_INTEN_var_SWRREQ(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_SWRREQ(var)) >> TW_V1_INTEN_s_SWRREQ(var);
#define TW_V1_INTEN_s_SRDREQ(val) 0x13
#define TW_V1_INTEN_m_SRDREQ(val) 0x80000UL
#define TW_V1_INTEN_v_SRDREQ(val) (((RALuint32)(val)<<TW_V1_INTEN_s_SRDREQ(val))&TW_V1_INTEN_m_SRDREQ(val))
#define TW_V1_INTEN_var_SRDREQ(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_SRDREQ(var)) >> TW_V1_INTEN_s_SRDREQ(var);
#define TW_V1_INTEN_s_SRFLIM(val) 0x14
#define TW_V1_INTEN_m_SRFLIM(val) 0x100000UL
#define TW_V1_INTEN_v_SRFLIM(val) (((RALuint32)(val)<<TW_V1_INTEN_s_SRFLIM(val))&TW_V1_INTEN_m_SRFLIM(val))
#define TW_V1_INTEN_var_SRFLIM(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_SRFLIM(var)) >> TW_V1_INTEN_s_SRFLIM(var);
#define TW_V1_INTEN_s_SWFLIM(val) 0x15
#define TW_V1_INTEN_m_SWFLIM(val) 0x200000UL
#define TW_V1_INTEN_v_SWFLIM(val) (((RALuint32)(val)<<TW_V1_INTEN_s_SWFLIM(val))&TW_V1_INTEN_m_SWFLIM(val))
#define TW_V1_INTEN_var_SWFLIM(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_SWFLIM(var)) >> TW_V1_INTEN_s_SWFLIM(var);
#define TW_V1_INTEN_s_SWFLOCKED(val) 0x16
#define TW_V1_INTEN_m_SWFLOCKED(val) 0x400000UL
#define TW_V1_INTEN_v_SWFLOCKED(val) (((RALuint32)(val)<<TW_V1_INTEN_s_SWFLOCKED(val))&TW_V1_INTEN_m_SWFLOCKED(val))
#define TW_V1_INTEN_var_SWFLOCKED(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_SWFLOCKED(var)) >> TW_V1_INTEN_s_SWFLOCKED(var);
#define TW_V1_INTEN_s_SGENCALL(val) 0x17
#define TW_V1_INTEN_m_SGENCALL(val) 0x800000UL
#define TW_V1_INTEN_v_SGENCALL(val) (((RALuint32)(val)<<TW_V1_INTEN_s_SGENCALL(val))&TW_V1_INTEN_m_SGENCALL(val))
#define TW_V1_INTEN_var_SGENCALL(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_SGENCALL(var)) >> TW_V1_INTEN_s_SGENCALL(var);
#define TW_V1_INTEN_s_SHOLD(val) 0x18
#define TW_V1_INTEN_m_SHOLD(val) 0x1000000UL
#define TW_V1_INTEN_v_SHOLD(val) (((RALuint32)(val)<<TW_V1_INTEN_s_SHOLD(val))&TW_V1_INTEN_m_SHOLD(val))
#define TW_V1_INTEN_var_SHOLD(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_SHOLD(var)) >> TW_V1_INTEN_s_SHOLD(var);
#define TW_V1_INTEN_m_Unused25 0x3e000000UL
#define TW_V1_INTEN_s_START(val) 0x1e
#define TW_V1_INTEN_m_START(val) 0x40000000UL
#define TW_V1_INTEN_v_START(val) (((RALuint32)(val)<<TW_V1_INTEN_s_START(val))&TW_V1_INTEN_m_START(val))
#define TW_V1_INTEN_var_START(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_START(var)) >> TW_V1_INTEN_s_START(var);
#define TW_V1_INTEN_s_STOP(val) 0x1f
#define TW_V1_INTEN_m_STOP(val) 0x80000000UL
#define TW_V1_INTEN_v_STOP(val) (((RALuint32)(val)<<TW_V1_INTEN_s_STOP(val))&TW_V1_INTEN_m_STOP(val))
#define TW_V1_INTEN_var_STOP(var) var=(Reserved_for_RAL_32 & TW_V1_INTEN_m_STOP(var)) >> TW_V1_INTEN_s_STOP(var);

#define TW_V1_INTEN_OFF 0x00000040
#define TW_V1_INTEN_SIZE 32

#define TW_V1_INTEN_SET(BlkInfo, ...) _TW_V1_INTEN_SET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_INTEN_SET(BlkInfo, count, ...) __TW_V1_INTEN_SET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_INTEN_SET(BlkInfo, count, ...) _TW_V1_INTEN_SET ## count(BlkInfo, __VA_ARGS__)

#define ___TW_V1_INTEN_SET(BlkInfo, mask, value) \
do {\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040,\
~(0L | mask  | TW_V1_INTEN_m_Unused7 | TW_V1_INTEN_m_Unused9 | TW_V1_INTEN_m_Unused25), 0L | value);\
} while(0)


#define _TW_V1_INTEN_SET1(BlkInfo, fld1) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1, \
TW_V1_INTEN_v_##fld1)

#define _TW_V1_INTEN_SET2(BlkInfo, fld1, fld2) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2)

#define _TW_V1_INTEN_SET3(BlkInfo, fld1, fld2, fld3) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3)

#define _TW_V1_INTEN_SET4(BlkInfo, fld1, fld2, fld3, fld4) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4)

#define _TW_V1_INTEN_SET5(BlkInfo, fld1, fld2, fld3, fld4, fld5) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5)

#define _TW_V1_INTEN_SET6(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6)

#define _TW_V1_INTEN_SET7(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7)

#define _TW_V1_INTEN_SET8(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_##fld9, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7 | TW_V1_INTEN_v_##fld9)

#define _TW_V1_INTEN_SET9(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_##fld9 | TW_V1_INTEN_m_##fld11, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7 | TW_V1_INTEN_v_##fld9 | TW_V1_INTEN_v_##fld11)

#define _TW_V1_INTEN_SET10(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_##fld9 | TW_V1_INTEN_m_##fld11 | TW_V1_INTEN_m_##fld12, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7 | TW_V1_INTEN_v_##fld9 | TW_V1_INTEN_v_##fld11 | TW_V1_INTEN_v_##fld12)

#define _TW_V1_INTEN_SET11(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_##fld9 | TW_V1_INTEN_m_##fld11 | TW_V1_INTEN_m_##fld12 | TW_V1_INTEN_m_##fld13, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7 | TW_V1_INTEN_v_##fld9 | TW_V1_INTEN_v_##fld11 | TW_V1_INTEN_v_##fld12 | TW_V1_INTEN_v_##fld13)

#define _TW_V1_INTEN_SET12(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_##fld9 | TW_V1_INTEN_m_##fld11 | TW_V1_INTEN_m_##fld12 | TW_V1_INTEN_m_##fld13 | TW_V1_INTEN_m_##fld14, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7 | TW_V1_INTEN_v_##fld9 | TW_V1_INTEN_v_##fld11 | TW_V1_INTEN_v_##fld12 | TW_V1_INTEN_v_##fld13 | TW_V1_INTEN_v_##fld14)

#define _TW_V1_INTEN_SET13(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_##fld9 | TW_V1_INTEN_m_##fld11 | TW_V1_INTEN_m_##fld12 | TW_V1_INTEN_m_##fld13 | TW_V1_INTEN_m_##fld14 | TW_V1_INTEN_m_##fld15, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7 | TW_V1_INTEN_v_##fld9 | TW_V1_INTEN_v_##fld11 | TW_V1_INTEN_v_##fld12 | TW_V1_INTEN_v_##fld13 | TW_V1_INTEN_v_##fld14 | TW_V1_INTEN_v_##fld15)

#define _TW_V1_INTEN_SET14(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_##fld9 | TW_V1_INTEN_m_##fld11 | TW_V1_INTEN_m_##fld12 | TW_V1_INTEN_m_##fld13 | TW_V1_INTEN_m_##fld14 | TW_V1_INTEN_m_##fld15 | TW_V1_INTEN_m_##fld16, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7 | TW_V1_INTEN_v_##fld9 | TW_V1_INTEN_v_##fld11 | TW_V1_INTEN_v_##fld12 | TW_V1_INTEN_v_##fld13 | TW_V1_INTEN_v_##fld14 | TW_V1_INTEN_v_##fld15 | TW_V1_INTEN_v_##fld16)

#define _TW_V1_INTEN_SET15(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_##fld9 | TW_V1_INTEN_m_##fld11 | TW_V1_INTEN_m_##fld12 | TW_V1_INTEN_m_##fld13 | TW_V1_INTEN_m_##fld14 | TW_V1_INTEN_m_##fld15 | TW_V1_INTEN_m_##fld16 | TW_V1_INTEN_m_##fld17, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7 | TW_V1_INTEN_v_##fld9 | TW_V1_INTEN_v_##fld11 | TW_V1_INTEN_v_##fld12 | TW_V1_INTEN_v_##fld13 | TW_V1_INTEN_v_##fld14 | TW_V1_INTEN_v_##fld15 | TW_V1_INTEN_v_##fld16 | TW_V1_INTEN_v_##fld17)

#define _TW_V1_INTEN_SET16(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_##fld9 | TW_V1_INTEN_m_##fld11 | TW_V1_INTEN_m_##fld12 | TW_V1_INTEN_m_##fld13 | TW_V1_INTEN_m_##fld14 | TW_V1_INTEN_m_##fld15 | TW_V1_INTEN_m_##fld16 | TW_V1_INTEN_m_##fld17 | TW_V1_INTEN_m_##fld18, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7 | TW_V1_INTEN_v_##fld9 | TW_V1_INTEN_v_##fld11 | TW_V1_INTEN_v_##fld12 | TW_V1_INTEN_v_##fld13 | TW_V1_INTEN_v_##fld14 | TW_V1_INTEN_v_##fld15 | TW_V1_INTEN_v_##fld16 | TW_V1_INTEN_v_##fld17 | TW_V1_INTEN_v_##fld18)

#define _TW_V1_INTEN_SET17(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_##fld9 | TW_V1_INTEN_m_##fld11 | TW_V1_INTEN_m_##fld12 | TW_V1_INTEN_m_##fld13 | TW_V1_INTEN_m_##fld14 | TW_V1_INTEN_m_##fld15 | TW_V1_INTEN_m_##fld16 | TW_V1_INTEN_m_##fld17 | TW_V1_INTEN_m_##fld18 | TW_V1_INTEN_m_##fld19, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7 | TW_V1_INTEN_v_##fld9 | TW_V1_INTEN_v_##fld11 | TW_V1_INTEN_v_##fld12 | TW_V1_INTEN_v_##fld13 | TW_V1_INTEN_v_##fld14 | TW_V1_INTEN_v_##fld15 | TW_V1_INTEN_v_##fld16 | TW_V1_INTEN_v_##fld17 | TW_V1_INTEN_v_##fld18 | TW_V1_INTEN_v_##fld19)

#define _TW_V1_INTEN_SET18(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_##fld9 | TW_V1_INTEN_m_##fld11 | TW_V1_INTEN_m_##fld12 | TW_V1_INTEN_m_##fld13 | TW_V1_INTEN_m_##fld14 | TW_V1_INTEN_m_##fld15 | TW_V1_INTEN_m_##fld16 | TW_V1_INTEN_m_##fld17 | TW_V1_INTEN_m_##fld18 | TW_V1_INTEN_m_##fld19 | TW_V1_INTEN_m_##fld21, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7 | TW_V1_INTEN_v_##fld9 | TW_V1_INTEN_v_##fld11 | TW_V1_INTEN_v_##fld12 | TW_V1_INTEN_v_##fld13 | TW_V1_INTEN_v_##fld14 | TW_V1_INTEN_v_##fld15 | TW_V1_INTEN_v_##fld16 | TW_V1_INTEN_v_##fld17 | TW_V1_INTEN_v_##fld18 | TW_V1_INTEN_v_##fld19 | TW_V1_INTEN_v_##fld21)

#define _TW_V1_INTEN_SET19(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21, fld22) \
___TW_V1_INTEN_SET(BlkInfo, TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_##fld9 | TW_V1_INTEN_m_##fld11 | TW_V1_INTEN_m_##fld12 | TW_V1_INTEN_m_##fld13 | TW_V1_INTEN_m_##fld14 | TW_V1_INTEN_m_##fld15 | TW_V1_INTEN_m_##fld16 | TW_V1_INTEN_m_##fld17 | TW_V1_INTEN_m_##fld18 | TW_V1_INTEN_m_##fld19 | TW_V1_INTEN_m_##fld21 | TW_V1_INTEN_m_##fld22, \
TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7 | TW_V1_INTEN_v_##fld9 | TW_V1_INTEN_v_##fld11 | TW_V1_INTEN_v_##fld12 | TW_V1_INTEN_v_##fld13 | TW_V1_INTEN_v_##fld14 | TW_V1_INTEN_v_##fld15 | TW_V1_INTEN_v_##fld16 | TW_V1_INTEN_v_##fld17 | TW_V1_INTEN_v_##fld18 | TW_V1_INTEN_v_##fld19 | TW_V1_INTEN_v_##fld21 | TW_V1_INTEN_v_##fld22)

#define TW_V1_INTEN_SET1(BlkInfo, fld1) \
{\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040,\
~(0L | TW_V1_INTEN_m_##fld1),\
0L | TW_V1_INTEN_v_##fld1);\
}


#define TW_V1_INTEN_DEF(fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21, fld22) \
{\
0 | TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7 | TW_V1_INTEN_v_##fld9 | TW_V1_INTEN_v_##fld11 | TW_V1_INTEN_v_##fld12 | TW_V1_INTEN_v_##fld13 | TW_V1_INTEN_v_##fld14 | TW_V1_INTEN_v_##fld15 | TW_V1_INTEN_v_##fld16 | TW_V1_INTEN_v_##fld17 | TW_V1_INTEN_v_##fld18 | TW_V1_INTEN_v_##fld19 | TW_V1_INTEN_v_##fld21 | TW_V1_INTEN_v_##fld22, \
~(0L | TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_Unused7 | TW_V1_INTEN_m_##fld9 | TW_V1_INTEN_m_Unused9 | TW_V1_INTEN_m_##fld11 | TW_V1_INTEN_m_##fld12 | TW_V1_INTEN_m_##fld13 | TW_V1_INTEN_m_##fld14 | TW_V1_INTEN_m_##fld15 | TW_V1_INTEN_m_##fld16 | TW_V1_INTEN_m_##fld17 | TW_V1_INTEN_m_##fld18 | TW_V1_INTEN_m_##fld19 | TW_V1_INTEN_m_Unused25 | TW_V1_INTEN_m_##fld21 | TW_V1_INTEN_m_##fld22), \
32, \
0x00000040 \
}

#define TW_V1_INTEN_MEM(RegEntry, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21, fld22) \
RegEntry.dwValue = (RegEntry.dwValue & ~(0L | TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_Unused7 | TW_V1_INTEN_m_##fld9 | TW_V1_INTEN_m_Unused9 | TW_V1_INTEN_m_##fld11 | TW_V1_INTEN_m_##fld12 | TW_V1_INTEN_m_##fld13 | TW_V1_INTEN_m_##fld14 | TW_V1_INTEN_m_##fld15 | TW_V1_INTEN_m_##fld16 | TW_V1_INTEN_m_##fld17 | TW_V1_INTEN_m_##fld18 | TW_V1_INTEN_m_##fld19 | TW_V1_INTEN_m_Unused25 | TW_V1_INTEN_m_##fld21 | TW_V1_INTEN_m_##fld22))| \
(0 | TW_V1_INTEN_v_##fld1 | TW_V1_INTEN_v_##fld2 | TW_V1_INTEN_v_##fld3 | TW_V1_INTEN_v_##fld4 | TW_V1_INTEN_v_##fld5 | TW_V1_INTEN_v_##fld6 | TW_V1_INTEN_v_##fld7 | TW_V1_INTEN_v_##fld9 | TW_V1_INTEN_v_##fld11 | TW_V1_INTEN_v_##fld12 | TW_V1_INTEN_v_##fld13 | TW_V1_INTEN_v_##fld14 | TW_V1_INTEN_v_##fld15 | TW_V1_INTEN_v_##fld16 | TW_V1_INTEN_v_##fld17 | TW_V1_INTEN_v_##fld18 | TW_V1_INTEN_v_##fld19 | TW_V1_INTEN_v_##fld21 | TW_V1_INTEN_v_##fld22);\
RegEntry.dwMask &= ~(0L | TW_V1_INTEN_m_##fld1 | TW_V1_INTEN_m_##fld2 | TW_V1_INTEN_m_##fld3 | TW_V1_INTEN_m_##fld4 | TW_V1_INTEN_m_##fld5 | TW_V1_INTEN_m_##fld6 | TW_V1_INTEN_m_##fld7 | TW_V1_INTEN_m_Unused7 | TW_V1_INTEN_m_##fld9 | TW_V1_INTEN_m_Unused9 | TW_V1_INTEN_m_##fld11 | TW_V1_INTEN_m_##fld12 | TW_V1_INTEN_m_##fld13 | TW_V1_INTEN_m_##fld14 | TW_V1_INTEN_m_##fld15 | TW_V1_INTEN_m_##fld16 | TW_V1_INTEN_m_##fld17 | TW_V1_INTEN_m_##fld18 | TW_V1_INTEN_m_##fld19 | TW_V1_INTEN_m_Unused25 | TW_V1_INTEN_m_##fld21 | TW_V1_INTEN_m_##fld22)

#define TW_V1_INTEN_GET(BlkInfo, ...) _TW_V1_INTEN_GET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_INTEN_GET(BlkInfo, count, ...) __TW_V1_INTEN_GET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_INTEN_GET(BlkInfo, count, ...) _TW_V1_INTEN_GET ## count(BlkInfo, __VA_ARGS__)

#define _TW_V1_INTEN_GET1(BlkInfo, fld0) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
} while(0)


#define _TW_V1_INTEN_GET2(BlkInfo, fld0, fld1) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
} while(0)


#define _TW_V1_INTEN_GET3(BlkInfo, fld0, fld1, fld2) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
} while(0)


#define _TW_V1_INTEN_GET4(BlkInfo, fld0, fld1, fld2, fld3) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
} while(0)


#define _TW_V1_INTEN_GET5(BlkInfo, fld0, fld1, fld2, fld3, fld4) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
} while(0)


#define _TW_V1_INTEN_GET6(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
} while(0)


#define _TW_V1_INTEN_GET7(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
TW_V1_INTEN_var_##fld6  \
} while(0)


#define _TW_V1_INTEN_GET8(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
TW_V1_INTEN_var_##fld6  \
TW_V1_INTEN_var_##fld7  \
} while(0)


#define _TW_V1_INTEN_GET9(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
TW_V1_INTEN_var_##fld6  \
TW_V1_INTEN_var_##fld7  \
TW_V1_INTEN_var_##fld9  \
} while(0)


#define _TW_V1_INTEN_GET10(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
TW_V1_INTEN_var_##fld6  \
TW_V1_INTEN_var_##fld7  \
TW_V1_INTEN_var_##fld9  \
TW_V1_INTEN_var_##fld11  \
} while(0)


#define _TW_V1_INTEN_GET11(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
TW_V1_INTEN_var_##fld6  \
TW_V1_INTEN_var_##fld7  \
TW_V1_INTEN_var_##fld9  \
TW_V1_INTEN_var_##fld11  \
TW_V1_INTEN_var_##fld12  \
} while(0)


#define _TW_V1_INTEN_GET12(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
TW_V1_INTEN_var_##fld6  \
TW_V1_INTEN_var_##fld7  \
TW_V1_INTEN_var_##fld9  \
TW_V1_INTEN_var_##fld11  \
TW_V1_INTEN_var_##fld12  \
TW_V1_INTEN_var_##fld13  \
} while(0)


#define _TW_V1_INTEN_GET13(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
TW_V1_INTEN_var_##fld6  \
TW_V1_INTEN_var_##fld7  \
TW_V1_INTEN_var_##fld9  \
TW_V1_INTEN_var_##fld11  \
TW_V1_INTEN_var_##fld12  \
TW_V1_INTEN_var_##fld13  \
TW_V1_INTEN_var_##fld14  \
} while(0)


#define _TW_V1_INTEN_GET14(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
TW_V1_INTEN_var_##fld6  \
TW_V1_INTEN_var_##fld7  \
TW_V1_INTEN_var_##fld9  \
TW_V1_INTEN_var_##fld11  \
TW_V1_INTEN_var_##fld12  \
TW_V1_INTEN_var_##fld13  \
TW_V1_INTEN_var_##fld14  \
TW_V1_INTEN_var_##fld15  \
} while(0)


#define _TW_V1_INTEN_GET15(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
TW_V1_INTEN_var_##fld6  \
TW_V1_INTEN_var_##fld7  \
TW_V1_INTEN_var_##fld9  \
TW_V1_INTEN_var_##fld11  \
TW_V1_INTEN_var_##fld12  \
TW_V1_INTEN_var_##fld13  \
TW_V1_INTEN_var_##fld14  \
TW_V1_INTEN_var_##fld15  \
TW_V1_INTEN_var_##fld16  \
} while(0)


#define _TW_V1_INTEN_GET16(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
TW_V1_INTEN_var_##fld6  \
TW_V1_INTEN_var_##fld7  \
TW_V1_INTEN_var_##fld9  \
TW_V1_INTEN_var_##fld11  \
TW_V1_INTEN_var_##fld12  \
TW_V1_INTEN_var_##fld13  \
TW_V1_INTEN_var_##fld14  \
TW_V1_INTEN_var_##fld15  \
TW_V1_INTEN_var_##fld16  \
TW_V1_INTEN_var_##fld17  \
} while(0)


#define _TW_V1_INTEN_GET17(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
TW_V1_INTEN_var_##fld6  \
TW_V1_INTEN_var_##fld7  \
TW_V1_INTEN_var_##fld9  \
TW_V1_INTEN_var_##fld11  \
TW_V1_INTEN_var_##fld12  \
TW_V1_INTEN_var_##fld13  \
TW_V1_INTEN_var_##fld14  \
TW_V1_INTEN_var_##fld15  \
TW_V1_INTEN_var_##fld16  \
TW_V1_INTEN_var_##fld17  \
TW_V1_INTEN_var_##fld18  \
} while(0)


#define _TW_V1_INTEN_GET18(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
TW_V1_INTEN_var_##fld6  \
TW_V1_INTEN_var_##fld7  \
TW_V1_INTEN_var_##fld9  \
TW_V1_INTEN_var_##fld11  \
TW_V1_INTEN_var_##fld12  \
TW_V1_INTEN_var_##fld13  \
TW_V1_INTEN_var_##fld14  \
TW_V1_INTEN_var_##fld15  \
TW_V1_INTEN_var_##fld16  \
TW_V1_INTEN_var_##fld17  \
TW_V1_INTEN_var_##fld18  \
TW_V1_INTEN_var_##fld19  \
} while(0)


#define _TW_V1_INTEN_GET19(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
TW_V1_INTEN_var_##fld6  \
TW_V1_INTEN_var_##fld7  \
TW_V1_INTEN_var_##fld9  \
TW_V1_INTEN_var_##fld11  \
TW_V1_INTEN_var_##fld12  \
TW_V1_INTEN_var_##fld13  \
TW_V1_INTEN_var_##fld14  \
TW_V1_INTEN_var_##fld15  \
TW_V1_INTEN_var_##fld16  \
TW_V1_INTEN_var_##fld17  \
TW_V1_INTEN_var_##fld18  \
TW_V1_INTEN_var_##fld19  \
TW_V1_INTEN_var_##fld21  \
} while(0)


#define _TW_V1_INTEN_GET20(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21, fld22) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld0  \
TW_V1_INTEN_var_##fld1  \
TW_V1_INTEN_var_##fld2  \
TW_V1_INTEN_var_##fld3  \
TW_V1_INTEN_var_##fld4  \
TW_V1_INTEN_var_##fld5  \
TW_V1_INTEN_var_##fld6  \
TW_V1_INTEN_var_##fld7  \
TW_V1_INTEN_var_##fld9  \
TW_V1_INTEN_var_##fld11  \
TW_V1_INTEN_var_##fld12  \
TW_V1_INTEN_var_##fld13  \
TW_V1_INTEN_var_##fld14  \
TW_V1_INTEN_var_##fld15  \
TW_V1_INTEN_var_##fld16  \
TW_V1_INTEN_var_##fld17  \
TW_V1_INTEN_var_##fld18  \
TW_V1_INTEN_var_##fld19  \
TW_V1_INTEN_var_##fld21  \
TW_V1_INTEN_var_##fld22  \
} while(0)


#define TW_V1_INTEN_GET1(BlkInfo, fld1)  \
{\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000040, &Reserved_for_RAL_32); \
TW_V1_INTEN_var_##fld1 \
}
/*==========================================================================*/

/*Two-wire Interrupt Status Register:*/
#define TW_V1_INTSTAT_m_ 0x0
#define TW_V1_INTSTAT_s_ 0x0
#define TW_V1_INTSTAT_v_ 0x0
#define TW_V1_INTSTAT_m_ALL(val) 0xffffffffUL
#define TW_V1_INTSTAT_s_ALL(val) 0x0
#define TW_V1_INTSTAT_v_ALL(val) ((RALuint32)(val))
#define TW_V1_INTSTAT_var_
#define TW_V1_INTSTAT_var_ALL(var) var=Reserved_for_RAL_32;
#define TW_V1_INTSTAT_s_MNACK(val) 0x0
#define TW_V1_INTSTAT_m_MNACK(val) 0x1
#define TW_V1_INTSTAT_v_MNACK(val) (((val)<<TW_V1_INTSTAT_s_MNACK(val))&TW_V1_INTSTAT_m_MNACK(val))
#define TW_V1_INTSTAT_var_MNACK(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_MNACK(var)) >> TW_V1_INTSTAT_s_MNACK(var);
#define TW_V1_INTSTAT_s_MBYRCVD(val) 0x1
#define TW_V1_INTSTAT_m_MBYRCVD(val) 0x2
#define TW_V1_INTSTAT_v_MBYRCVD(val) (((val)<<TW_V1_INTSTAT_s_MBYRCVD(val))&TW_V1_INTSTAT_m_MBYRCVD(val))
#define TW_V1_INTSTAT_var_MBYRCVD(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_MBYRCVD(var)) >> TW_V1_INTSTAT_s_MBYRCVD(var);
#define TW_V1_INTSTAT_s_MARBLOST(val) 0x2
#define TW_V1_INTSTAT_m_MARBLOST(val) 0x4
#define TW_V1_INTSTAT_v_MARBLOST(val) (((val)<<TW_V1_INTSTAT_s_MARBLOST(val))&TW_V1_INTSTAT_m_MARBLOST(val))
#define TW_V1_INTSTAT_var_MARBLOST(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_MARBLOST(var)) >> TW_V1_INTSTAT_s_MARBLOST(var);
#define TW_V1_INTSTAT_s_MBYCDONE(val) 0x3
#define TW_V1_INTSTAT_m_MBYCDONE(val) 0x8
#define TW_V1_INTSTAT_v_MBYCDONE(val) (((val)<<TW_V1_INTSTAT_s_MBYCDONE(val))&TW_V1_INTSTAT_m_MBYCDONE(val))
#define TW_V1_INTSTAT_var_MBYCDONE(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_MBYCDONE(var)) >> TW_V1_INTSTAT_s_MBYCDONE(var);
#define TW_V1_INTSTAT_s_MRFLIM(val) 0x4
#define TW_V1_INTSTAT_m_MRFLIM(val) 0x10
#define TW_V1_INTSTAT_v_MRFLIM(val) (((val)<<TW_V1_INTSTAT_s_MRFLIM(val))&TW_V1_INTSTAT_m_MRFLIM(val))
#define TW_V1_INTSTAT_var_MRFLIM(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_MRFLIM(var)) >> TW_V1_INTSTAT_s_MRFLIM(var);
#define TW_V1_INTSTAT_s_MWFLIM(val) 0x5
#define TW_V1_INTSTAT_m_MWFLIM(val) 0x20
#define TW_V1_INTSTAT_v_MWFLIM(val) (((val)<<TW_V1_INTSTAT_s_MWFLIM(val))&TW_V1_INTSTAT_m_MWFLIM(val))
#define TW_V1_INTSTAT_var_MWFLIM(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_MWFLIM(var)) >> TW_V1_INTSTAT_s_MWFLIM(var);
#define TW_V1_INTSTAT_s_MILLCMD(val) 0x6
#define TW_V1_INTSTAT_m_MILLCMD(val) 0x40
#define TW_V1_INTSTAT_v_MILLCMD(val) (((val)<<TW_V1_INTSTAT_s_MILLCMD(val))&TW_V1_INTSTAT_m_MILLCMD(val))
#define TW_V1_INTSTAT_var_MILLCMD(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_MILLCMD(var)) >> TW_V1_INTSTAT_s_MILLCMD(var);
#define TW_V1_INTSTAT_m_Unused7 0x80
#define TW_V1_INTSTAT_s_MHOLD(val) 0x8
#define TW_V1_INTSTAT_m_MHOLD(val) 0x100
#define TW_V1_INTSTAT_v_MHOLD(val) (((RALuint16)(val)<<TW_V1_INTSTAT_s_MHOLD(val))&TW_V1_INTSTAT_m_MHOLD(val))
#define TW_V1_INTSTAT_var_MHOLD(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_MHOLD(var)) >> TW_V1_INTSTAT_s_MHOLD(var);
#define TW_V1_INTSTAT_m_Unused9 0xfe00
#define TW_V1_INTSTAT_s_SNACK(val) 0x10
#define TW_V1_INTSTAT_m_SNACK(val) 0x10000UL
#define TW_V1_INTSTAT_v_SNACK(val) (((RALuint32)(val)<<TW_V1_INTSTAT_s_SNACK(val))&TW_V1_INTSTAT_m_SNACK(val))
#define TW_V1_INTSTAT_var_SNACK(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_SNACK(var)) >> TW_V1_INTSTAT_s_SNACK(var);
#define TW_V1_INTSTAT_s_SBYRCVD(val) 0x11
#define TW_V1_INTSTAT_m_SBYRCVD(val) 0x20000UL
#define TW_V1_INTSTAT_v_SBYRCVD(val) (((RALuint32)(val)<<TW_V1_INTSTAT_s_SBYRCVD(val))&TW_V1_INTSTAT_m_SBYRCVD(val))
#define TW_V1_INTSTAT_var_SBYRCVD(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_SBYRCVD(var)) >> TW_V1_INTSTAT_s_SBYRCVD(var);
#define TW_V1_INTSTAT_s_SWRREQ(val) 0x12
#define TW_V1_INTSTAT_m_SWRREQ(val) 0x40000UL
#define TW_V1_INTSTAT_v_SWRREQ(val) (((RALuint32)(val)<<TW_V1_INTSTAT_s_SWRREQ(val))&TW_V1_INTSTAT_m_SWRREQ(val))
#define TW_V1_INTSTAT_var_SWRREQ(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_SWRREQ(var)) >> TW_V1_INTSTAT_s_SWRREQ(var);
#define TW_V1_INTSTAT_s_SRDREQ(val) 0x13
#define TW_V1_INTSTAT_m_SRDREQ(val) 0x80000UL
#define TW_V1_INTSTAT_v_SRDREQ(val) (((RALuint32)(val)<<TW_V1_INTSTAT_s_SRDREQ(val))&TW_V1_INTSTAT_m_SRDREQ(val))
#define TW_V1_INTSTAT_var_SRDREQ(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_SRDREQ(var)) >> TW_V1_INTSTAT_s_SRDREQ(var);
#define TW_V1_INTSTAT_s_SRFLIM(val) 0x14
#define TW_V1_INTSTAT_m_SRFLIM(val) 0x100000UL
#define TW_V1_INTSTAT_v_SRFLIM(val) (((RALuint32)(val)<<TW_V1_INTSTAT_s_SRFLIM(val))&TW_V1_INTSTAT_m_SRFLIM(val))
#define TW_V1_INTSTAT_var_SRFLIM(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_SRFLIM(var)) >> TW_V1_INTSTAT_s_SRFLIM(var);
#define TW_V1_INTSTAT_s_SWFLIM(val) 0x15
#define TW_V1_INTSTAT_m_SWFLIM(val) 0x200000UL
#define TW_V1_INTSTAT_v_SWFLIM(val) (((RALuint32)(val)<<TW_V1_INTSTAT_s_SWFLIM(val))&TW_V1_INTSTAT_m_SWFLIM(val))
#define TW_V1_INTSTAT_var_SWFLIM(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_SWFLIM(var)) >> TW_V1_INTSTAT_s_SWFLIM(var);
#define TW_V1_INTSTAT_s_SWFLOCKED(val) 0x16
#define TW_V1_INTSTAT_m_SWFLOCKED(val) 0x400000UL
#define TW_V1_INTSTAT_v_SWFLOCKED(val) (((RALuint32)(val)<<TW_V1_INTSTAT_s_SWFLOCKED(val))&TW_V1_INTSTAT_m_SWFLOCKED(val))
#define TW_V1_INTSTAT_var_SWFLOCKED(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_SWFLOCKED(var)) >> TW_V1_INTSTAT_s_SWFLOCKED(var);
#define TW_V1_INTSTAT_s_SGENCALL(val) 0x17
#define TW_V1_INTSTAT_m_SGENCALL(val) 0x800000UL
#define TW_V1_INTSTAT_v_SGENCALL(val) (((RALuint32)(val)<<TW_V1_INTSTAT_s_SGENCALL(val))&TW_V1_INTSTAT_m_SGENCALL(val))
#define TW_V1_INTSTAT_var_SGENCALL(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_SGENCALL(var)) >> TW_V1_INTSTAT_s_SGENCALL(var);
#define TW_V1_INTSTAT_s_SHOLD(val) 0x18
#define TW_V1_INTSTAT_m_SHOLD(val) 0x1000000UL
#define TW_V1_INTSTAT_v_SHOLD(val) (((RALuint32)(val)<<TW_V1_INTSTAT_s_SHOLD(val))&TW_V1_INTSTAT_m_SHOLD(val))
#define TW_V1_INTSTAT_var_SHOLD(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_SHOLD(var)) >> TW_V1_INTSTAT_s_SHOLD(var);
#define TW_V1_INTSTAT_m_Unused25 0x3e000000UL
#define TW_V1_INTSTAT_s_START(val) 0x1e
#define TW_V1_INTSTAT_m_START(val) 0x40000000UL
#define TW_V1_INTSTAT_v_START(val) (((RALuint32)(val)<<TW_V1_INTSTAT_s_START(val))&TW_V1_INTSTAT_m_START(val))
#define TW_V1_INTSTAT_var_START(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_START(var)) >> TW_V1_INTSTAT_s_START(var);
#define TW_V1_INTSTAT_s_STOP(val) 0x1f
#define TW_V1_INTSTAT_m_STOP(val) 0x80000000UL
#define TW_V1_INTSTAT_v_STOP(val) (((RALuint32)(val)<<TW_V1_INTSTAT_s_STOP(val))&TW_V1_INTSTAT_m_STOP(val))
#define TW_V1_INTSTAT_var_STOP(var) var=(Reserved_for_RAL_32 & TW_V1_INTSTAT_m_STOP(var)) >> TW_V1_INTSTAT_s_STOP(var);

#define TW_V1_INTSTAT_OFF 0x00000044
#define TW_V1_INTSTAT_SIZE 32

#define TW_V1_INTSTAT_SET(BlkInfo, ...) _TW_V1_INTSTAT_SET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_INTSTAT_SET(BlkInfo, count, ...) __TW_V1_INTSTAT_SET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_INTSTAT_SET(BlkInfo, count, ...) _TW_V1_INTSTAT_SET ## count(BlkInfo, __VA_ARGS__)

#define ___TW_V1_INTSTAT_SET(BlkInfo, mask, value) \
do {\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044,\
~(0L | mask  | TW_V1_INTSTAT_m_Unused7 | TW_V1_INTSTAT_m_Unused9 | TW_V1_INTSTAT_m_Unused25), 0L | value);\
} while(0)


#define _TW_V1_INTSTAT_SET1(BlkInfo, fld1) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1, \
TW_V1_INTSTAT_v_##fld1)

#define _TW_V1_INTSTAT_SET2(BlkInfo, fld1, fld2) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2)

#define _TW_V1_INTSTAT_SET3(BlkInfo, fld1, fld2, fld3) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3)

#define _TW_V1_INTSTAT_SET4(BlkInfo, fld1, fld2, fld3, fld4) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4)

#define _TW_V1_INTSTAT_SET5(BlkInfo, fld1, fld2, fld3, fld4, fld5) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5)

#define _TW_V1_INTSTAT_SET6(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6)

#define _TW_V1_INTSTAT_SET7(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7)

#define _TW_V1_INTSTAT_SET8(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_##fld9, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7 | TW_V1_INTSTAT_v_##fld9)

#define _TW_V1_INTSTAT_SET9(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_##fld9 | TW_V1_INTSTAT_m_##fld11, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7 | TW_V1_INTSTAT_v_##fld9 | TW_V1_INTSTAT_v_##fld11)

#define _TW_V1_INTSTAT_SET10(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_##fld9 | TW_V1_INTSTAT_m_##fld11 | TW_V1_INTSTAT_m_##fld12, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7 | TW_V1_INTSTAT_v_##fld9 | TW_V1_INTSTAT_v_##fld11 | TW_V1_INTSTAT_v_##fld12)

#define _TW_V1_INTSTAT_SET11(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_##fld9 | TW_V1_INTSTAT_m_##fld11 | TW_V1_INTSTAT_m_##fld12 | TW_V1_INTSTAT_m_##fld13, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7 | TW_V1_INTSTAT_v_##fld9 | TW_V1_INTSTAT_v_##fld11 | TW_V1_INTSTAT_v_##fld12 | TW_V1_INTSTAT_v_##fld13)

#define _TW_V1_INTSTAT_SET12(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_##fld9 | TW_V1_INTSTAT_m_##fld11 | TW_V1_INTSTAT_m_##fld12 | TW_V1_INTSTAT_m_##fld13 | TW_V1_INTSTAT_m_##fld14, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7 | TW_V1_INTSTAT_v_##fld9 | TW_V1_INTSTAT_v_##fld11 | TW_V1_INTSTAT_v_##fld12 | TW_V1_INTSTAT_v_##fld13 | TW_V1_INTSTAT_v_##fld14)

#define _TW_V1_INTSTAT_SET13(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_##fld9 | TW_V1_INTSTAT_m_##fld11 | TW_V1_INTSTAT_m_##fld12 | TW_V1_INTSTAT_m_##fld13 | TW_V1_INTSTAT_m_##fld14 | TW_V1_INTSTAT_m_##fld15, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7 | TW_V1_INTSTAT_v_##fld9 | TW_V1_INTSTAT_v_##fld11 | TW_V1_INTSTAT_v_##fld12 | TW_V1_INTSTAT_v_##fld13 | TW_V1_INTSTAT_v_##fld14 | TW_V1_INTSTAT_v_##fld15)

#define _TW_V1_INTSTAT_SET14(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_##fld9 | TW_V1_INTSTAT_m_##fld11 | TW_V1_INTSTAT_m_##fld12 | TW_V1_INTSTAT_m_##fld13 | TW_V1_INTSTAT_m_##fld14 | TW_V1_INTSTAT_m_##fld15 | TW_V1_INTSTAT_m_##fld16, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7 | TW_V1_INTSTAT_v_##fld9 | TW_V1_INTSTAT_v_##fld11 | TW_V1_INTSTAT_v_##fld12 | TW_V1_INTSTAT_v_##fld13 | TW_V1_INTSTAT_v_##fld14 | TW_V1_INTSTAT_v_##fld15 | TW_V1_INTSTAT_v_##fld16)

#define _TW_V1_INTSTAT_SET15(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_##fld9 | TW_V1_INTSTAT_m_##fld11 | TW_V1_INTSTAT_m_##fld12 | TW_V1_INTSTAT_m_##fld13 | TW_V1_INTSTAT_m_##fld14 | TW_V1_INTSTAT_m_##fld15 | TW_V1_INTSTAT_m_##fld16 | TW_V1_INTSTAT_m_##fld17, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7 | TW_V1_INTSTAT_v_##fld9 | TW_V1_INTSTAT_v_##fld11 | TW_V1_INTSTAT_v_##fld12 | TW_V1_INTSTAT_v_##fld13 | TW_V1_INTSTAT_v_##fld14 | TW_V1_INTSTAT_v_##fld15 | TW_V1_INTSTAT_v_##fld16 | TW_V1_INTSTAT_v_##fld17)

#define _TW_V1_INTSTAT_SET16(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_##fld9 | TW_V1_INTSTAT_m_##fld11 | TW_V1_INTSTAT_m_##fld12 | TW_V1_INTSTAT_m_##fld13 | TW_V1_INTSTAT_m_##fld14 | TW_V1_INTSTAT_m_##fld15 | TW_V1_INTSTAT_m_##fld16 | TW_V1_INTSTAT_m_##fld17 | TW_V1_INTSTAT_m_##fld18, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7 | TW_V1_INTSTAT_v_##fld9 | TW_V1_INTSTAT_v_##fld11 | TW_V1_INTSTAT_v_##fld12 | TW_V1_INTSTAT_v_##fld13 | TW_V1_INTSTAT_v_##fld14 | TW_V1_INTSTAT_v_##fld15 | TW_V1_INTSTAT_v_##fld16 | TW_V1_INTSTAT_v_##fld17 | TW_V1_INTSTAT_v_##fld18)

#define _TW_V1_INTSTAT_SET17(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_##fld9 | TW_V1_INTSTAT_m_##fld11 | TW_V1_INTSTAT_m_##fld12 | TW_V1_INTSTAT_m_##fld13 | TW_V1_INTSTAT_m_##fld14 | TW_V1_INTSTAT_m_##fld15 | TW_V1_INTSTAT_m_##fld16 | TW_V1_INTSTAT_m_##fld17 | TW_V1_INTSTAT_m_##fld18 | TW_V1_INTSTAT_m_##fld19, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7 | TW_V1_INTSTAT_v_##fld9 | TW_V1_INTSTAT_v_##fld11 | TW_V1_INTSTAT_v_##fld12 | TW_V1_INTSTAT_v_##fld13 | TW_V1_INTSTAT_v_##fld14 | TW_V1_INTSTAT_v_##fld15 | TW_V1_INTSTAT_v_##fld16 | TW_V1_INTSTAT_v_##fld17 | TW_V1_INTSTAT_v_##fld18 | TW_V1_INTSTAT_v_##fld19)

#define _TW_V1_INTSTAT_SET18(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_##fld9 | TW_V1_INTSTAT_m_##fld11 | TW_V1_INTSTAT_m_##fld12 | TW_V1_INTSTAT_m_##fld13 | TW_V1_INTSTAT_m_##fld14 | TW_V1_INTSTAT_m_##fld15 | TW_V1_INTSTAT_m_##fld16 | TW_V1_INTSTAT_m_##fld17 | TW_V1_INTSTAT_m_##fld18 | TW_V1_INTSTAT_m_##fld19 | TW_V1_INTSTAT_m_##fld21, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7 | TW_V1_INTSTAT_v_##fld9 | TW_V1_INTSTAT_v_##fld11 | TW_V1_INTSTAT_v_##fld12 | TW_V1_INTSTAT_v_##fld13 | TW_V1_INTSTAT_v_##fld14 | TW_V1_INTSTAT_v_##fld15 | TW_V1_INTSTAT_v_##fld16 | TW_V1_INTSTAT_v_##fld17 | TW_V1_INTSTAT_v_##fld18 | TW_V1_INTSTAT_v_##fld19 | TW_V1_INTSTAT_v_##fld21)

#define _TW_V1_INTSTAT_SET19(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21, fld22) \
___TW_V1_INTSTAT_SET(BlkInfo, TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_##fld9 | TW_V1_INTSTAT_m_##fld11 | TW_V1_INTSTAT_m_##fld12 | TW_V1_INTSTAT_m_##fld13 | TW_V1_INTSTAT_m_##fld14 | TW_V1_INTSTAT_m_##fld15 | TW_V1_INTSTAT_m_##fld16 | TW_V1_INTSTAT_m_##fld17 | TW_V1_INTSTAT_m_##fld18 | TW_V1_INTSTAT_m_##fld19 | TW_V1_INTSTAT_m_##fld21 | TW_V1_INTSTAT_m_##fld22, \
TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7 | TW_V1_INTSTAT_v_##fld9 | TW_V1_INTSTAT_v_##fld11 | TW_V1_INTSTAT_v_##fld12 | TW_V1_INTSTAT_v_##fld13 | TW_V1_INTSTAT_v_##fld14 | TW_V1_INTSTAT_v_##fld15 | TW_V1_INTSTAT_v_##fld16 | TW_V1_INTSTAT_v_##fld17 | TW_V1_INTSTAT_v_##fld18 | TW_V1_INTSTAT_v_##fld19 | TW_V1_INTSTAT_v_##fld21 | TW_V1_INTSTAT_v_##fld22)

#define TW_V1_INTSTAT_SET1(BlkInfo, fld1) \
{\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044,\
~(0L | TW_V1_INTSTAT_m_##fld1),\
0L | TW_V1_INTSTAT_v_##fld1);\
}


#define TW_V1_INTSTAT_DEF(fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21, fld22) \
{\
0 | TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7 | TW_V1_INTSTAT_v_##fld9 | TW_V1_INTSTAT_v_##fld11 | TW_V1_INTSTAT_v_##fld12 | TW_V1_INTSTAT_v_##fld13 | TW_V1_INTSTAT_v_##fld14 | TW_V1_INTSTAT_v_##fld15 | TW_V1_INTSTAT_v_##fld16 | TW_V1_INTSTAT_v_##fld17 | TW_V1_INTSTAT_v_##fld18 | TW_V1_INTSTAT_v_##fld19 | TW_V1_INTSTAT_v_##fld21 | TW_V1_INTSTAT_v_##fld22, \
~(0L | TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_Unused7 | TW_V1_INTSTAT_m_##fld9 | TW_V1_INTSTAT_m_Unused9 | TW_V1_INTSTAT_m_##fld11 | TW_V1_INTSTAT_m_##fld12 | TW_V1_INTSTAT_m_##fld13 | TW_V1_INTSTAT_m_##fld14 | TW_V1_INTSTAT_m_##fld15 | TW_V1_INTSTAT_m_##fld16 | TW_V1_INTSTAT_m_##fld17 | TW_V1_INTSTAT_m_##fld18 | TW_V1_INTSTAT_m_##fld19 | TW_V1_INTSTAT_m_Unused25 | TW_V1_INTSTAT_m_##fld21 | TW_V1_INTSTAT_m_##fld22), \
32, \
0x00000044 \
}

#define TW_V1_INTSTAT_MEM(RegEntry, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21, fld22) \
RegEntry.dwValue = (RegEntry.dwValue & ~(0L | TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_Unused7 | TW_V1_INTSTAT_m_##fld9 | TW_V1_INTSTAT_m_Unused9 | TW_V1_INTSTAT_m_##fld11 | TW_V1_INTSTAT_m_##fld12 | TW_V1_INTSTAT_m_##fld13 | TW_V1_INTSTAT_m_##fld14 | TW_V1_INTSTAT_m_##fld15 | TW_V1_INTSTAT_m_##fld16 | TW_V1_INTSTAT_m_##fld17 | TW_V1_INTSTAT_m_##fld18 | TW_V1_INTSTAT_m_##fld19 | TW_V1_INTSTAT_m_Unused25 | TW_V1_INTSTAT_m_##fld21 | TW_V1_INTSTAT_m_##fld22))| \
(0 | TW_V1_INTSTAT_v_##fld1 | TW_V1_INTSTAT_v_##fld2 | TW_V1_INTSTAT_v_##fld3 | TW_V1_INTSTAT_v_##fld4 | TW_V1_INTSTAT_v_##fld5 | TW_V1_INTSTAT_v_##fld6 | TW_V1_INTSTAT_v_##fld7 | TW_V1_INTSTAT_v_##fld9 | TW_V1_INTSTAT_v_##fld11 | TW_V1_INTSTAT_v_##fld12 | TW_V1_INTSTAT_v_##fld13 | TW_V1_INTSTAT_v_##fld14 | TW_V1_INTSTAT_v_##fld15 | TW_V1_INTSTAT_v_##fld16 | TW_V1_INTSTAT_v_##fld17 | TW_V1_INTSTAT_v_##fld18 | TW_V1_INTSTAT_v_##fld19 | TW_V1_INTSTAT_v_##fld21 | TW_V1_INTSTAT_v_##fld22);\
RegEntry.dwMask &= ~(0L | TW_V1_INTSTAT_m_##fld1 | TW_V1_INTSTAT_m_##fld2 | TW_V1_INTSTAT_m_##fld3 | TW_V1_INTSTAT_m_##fld4 | TW_V1_INTSTAT_m_##fld5 | TW_V1_INTSTAT_m_##fld6 | TW_V1_INTSTAT_m_##fld7 | TW_V1_INTSTAT_m_Unused7 | TW_V1_INTSTAT_m_##fld9 | TW_V1_INTSTAT_m_Unused9 | TW_V1_INTSTAT_m_##fld11 | TW_V1_INTSTAT_m_##fld12 | TW_V1_INTSTAT_m_##fld13 | TW_V1_INTSTAT_m_##fld14 | TW_V1_INTSTAT_m_##fld15 | TW_V1_INTSTAT_m_##fld16 | TW_V1_INTSTAT_m_##fld17 | TW_V1_INTSTAT_m_##fld18 | TW_V1_INTSTAT_m_##fld19 | TW_V1_INTSTAT_m_Unused25 | TW_V1_INTSTAT_m_##fld21 | TW_V1_INTSTAT_m_##fld22)

#define TW_V1_INTSTAT_GET(BlkInfo, ...) _TW_V1_INTSTAT_GET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_INTSTAT_GET(BlkInfo, count, ...) __TW_V1_INTSTAT_GET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_INTSTAT_GET(BlkInfo, count, ...) _TW_V1_INTSTAT_GET ## count(BlkInfo, __VA_ARGS__)

#define _TW_V1_INTSTAT_GET1(BlkInfo, fld0) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
} while(0)


#define _TW_V1_INTSTAT_GET2(BlkInfo, fld0, fld1) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
} while(0)


#define _TW_V1_INTSTAT_GET3(BlkInfo, fld0, fld1, fld2) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
} while(0)


#define _TW_V1_INTSTAT_GET4(BlkInfo, fld0, fld1, fld2, fld3) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
} while(0)


#define _TW_V1_INTSTAT_GET5(BlkInfo, fld0, fld1, fld2, fld3, fld4) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
} while(0)


#define _TW_V1_INTSTAT_GET6(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
} while(0)


#define _TW_V1_INTSTAT_GET7(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
TW_V1_INTSTAT_var_##fld6  \
} while(0)


#define _TW_V1_INTSTAT_GET8(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
TW_V1_INTSTAT_var_##fld6  \
TW_V1_INTSTAT_var_##fld7  \
} while(0)


#define _TW_V1_INTSTAT_GET9(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
TW_V1_INTSTAT_var_##fld6  \
TW_V1_INTSTAT_var_##fld7  \
TW_V1_INTSTAT_var_##fld9  \
} while(0)


#define _TW_V1_INTSTAT_GET10(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
TW_V1_INTSTAT_var_##fld6  \
TW_V1_INTSTAT_var_##fld7  \
TW_V1_INTSTAT_var_##fld9  \
TW_V1_INTSTAT_var_##fld11  \
} while(0)


#define _TW_V1_INTSTAT_GET11(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
TW_V1_INTSTAT_var_##fld6  \
TW_V1_INTSTAT_var_##fld7  \
TW_V1_INTSTAT_var_##fld9  \
TW_V1_INTSTAT_var_##fld11  \
TW_V1_INTSTAT_var_##fld12  \
} while(0)


#define _TW_V1_INTSTAT_GET12(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
TW_V1_INTSTAT_var_##fld6  \
TW_V1_INTSTAT_var_##fld7  \
TW_V1_INTSTAT_var_##fld9  \
TW_V1_INTSTAT_var_##fld11  \
TW_V1_INTSTAT_var_##fld12  \
TW_V1_INTSTAT_var_##fld13  \
} while(0)


#define _TW_V1_INTSTAT_GET13(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
TW_V1_INTSTAT_var_##fld6  \
TW_V1_INTSTAT_var_##fld7  \
TW_V1_INTSTAT_var_##fld9  \
TW_V1_INTSTAT_var_##fld11  \
TW_V1_INTSTAT_var_##fld12  \
TW_V1_INTSTAT_var_##fld13  \
TW_V1_INTSTAT_var_##fld14  \
} while(0)


#define _TW_V1_INTSTAT_GET14(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
TW_V1_INTSTAT_var_##fld6  \
TW_V1_INTSTAT_var_##fld7  \
TW_V1_INTSTAT_var_##fld9  \
TW_V1_INTSTAT_var_##fld11  \
TW_V1_INTSTAT_var_##fld12  \
TW_V1_INTSTAT_var_##fld13  \
TW_V1_INTSTAT_var_##fld14  \
TW_V1_INTSTAT_var_##fld15  \
} while(0)


#define _TW_V1_INTSTAT_GET15(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
TW_V1_INTSTAT_var_##fld6  \
TW_V1_INTSTAT_var_##fld7  \
TW_V1_INTSTAT_var_##fld9  \
TW_V1_INTSTAT_var_##fld11  \
TW_V1_INTSTAT_var_##fld12  \
TW_V1_INTSTAT_var_##fld13  \
TW_V1_INTSTAT_var_##fld14  \
TW_V1_INTSTAT_var_##fld15  \
TW_V1_INTSTAT_var_##fld16  \
} while(0)


#define _TW_V1_INTSTAT_GET16(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
TW_V1_INTSTAT_var_##fld6  \
TW_V1_INTSTAT_var_##fld7  \
TW_V1_INTSTAT_var_##fld9  \
TW_V1_INTSTAT_var_##fld11  \
TW_V1_INTSTAT_var_##fld12  \
TW_V1_INTSTAT_var_##fld13  \
TW_V1_INTSTAT_var_##fld14  \
TW_V1_INTSTAT_var_##fld15  \
TW_V1_INTSTAT_var_##fld16  \
TW_V1_INTSTAT_var_##fld17  \
} while(0)


#define _TW_V1_INTSTAT_GET17(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
TW_V1_INTSTAT_var_##fld6  \
TW_V1_INTSTAT_var_##fld7  \
TW_V1_INTSTAT_var_##fld9  \
TW_V1_INTSTAT_var_##fld11  \
TW_V1_INTSTAT_var_##fld12  \
TW_V1_INTSTAT_var_##fld13  \
TW_V1_INTSTAT_var_##fld14  \
TW_V1_INTSTAT_var_##fld15  \
TW_V1_INTSTAT_var_##fld16  \
TW_V1_INTSTAT_var_##fld17  \
TW_V1_INTSTAT_var_##fld18  \
} while(0)


#define _TW_V1_INTSTAT_GET18(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
TW_V1_INTSTAT_var_##fld6  \
TW_V1_INTSTAT_var_##fld7  \
TW_V1_INTSTAT_var_##fld9  \
TW_V1_INTSTAT_var_##fld11  \
TW_V1_INTSTAT_var_##fld12  \
TW_V1_INTSTAT_var_##fld13  \
TW_V1_INTSTAT_var_##fld14  \
TW_V1_INTSTAT_var_##fld15  \
TW_V1_INTSTAT_var_##fld16  \
TW_V1_INTSTAT_var_##fld17  \
TW_V1_INTSTAT_var_##fld18  \
TW_V1_INTSTAT_var_##fld19  \
} while(0)


#define _TW_V1_INTSTAT_GET19(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
TW_V1_INTSTAT_var_##fld6  \
TW_V1_INTSTAT_var_##fld7  \
TW_V1_INTSTAT_var_##fld9  \
TW_V1_INTSTAT_var_##fld11  \
TW_V1_INTSTAT_var_##fld12  \
TW_V1_INTSTAT_var_##fld13  \
TW_V1_INTSTAT_var_##fld14  \
TW_V1_INTSTAT_var_##fld15  \
TW_V1_INTSTAT_var_##fld16  \
TW_V1_INTSTAT_var_##fld17  \
TW_V1_INTSTAT_var_##fld18  \
TW_V1_INTSTAT_var_##fld19  \
TW_V1_INTSTAT_var_##fld21  \
} while(0)


#define _TW_V1_INTSTAT_GET20(BlkInfo, fld0, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21, fld22) \
do {\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld0  \
TW_V1_INTSTAT_var_##fld1  \
TW_V1_INTSTAT_var_##fld2  \
TW_V1_INTSTAT_var_##fld3  \
TW_V1_INTSTAT_var_##fld4  \
TW_V1_INTSTAT_var_##fld5  \
TW_V1_INTSTAT_var_##fld6  \
TW_V1_INTSTAT_var_##fld7  \
TW_V1_INTSTAT_var_##fld9  \
TW_V1_INTSTAT_var_##fld11  \
TW_V1_INTSTAT_var_##fld12  \
TW_V1_INTSTAT_var_##fld13  \
TW_V1_INTSTAT_var_##fld14  \
TW_V1_INTSTAT_var_##fld15  \
TW_V1_INTSTAT_var_##fld16  \
TW_V1_INTSTAT_var_##fld17  \
TW_V1_INTSTAT_var_##fld18  \
TW_V1_INTSTAT_var_##fld19  \
TW_V1_INTSTAT_var_##fld21  \
TW_V1_INTSTAT_var_##fld22  \
} while(0)


#define TW_V1_INTSTAT_GET1(BlkInfo, fld1)  \
{\
RALuint32 Reserved_for_RAL_32;\
(BlkInfo)->errorState = (BlkInfo)->RegRead32(BlkInfo, (BlkInfo)->BaseAddress+0x00000044, &Reserved_for_RAL_32); \
TW_V1_INTSTAT_var_##fld1 \
}
/*==========================================================================*/

/*Two-wire Interrupt Clear Register:*/
#define TW_V1_INTCLR_m_ 0x0
#define TW_V1_INTCLR_s_ 0x0
#define TW_V1_INTCLR_v_ 0x0
#define TW_V1_INTCLR_m_ALL(val) 0xffffffffUL
#define TW_V1_INTCLR_s_ALL(val) 0x0
#define TW_V1_INTCLR_v_ALL(val) ((RALuint32)(val))
#define TW_V1_INTCLR_var_
#define TW_V1_INTCLR_var_ALL(var) var=Reserved_for_RAL_32;
#define TW_V1_INTCLR_s_MNACK(val) 0x0
#define TW_V1_INTCLR_m_MNACK(val) 0x1
#define TW_V1_INTCLR_v_MNACK(val) (((val)<<TW_V1_INTCLR_s_MNACK(val))&TW_V1_INTCLR_m_MNACK(val))
#define TW_V1_INTCLR_var_MNACK(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_MNACK(var)) >> TW_V1_INTCLR_s_MNACK(var);
#define TW_V1_INTCLR_s_MBYRCVD(val) 0x1
#define TW_V1_INTCLR_m_MBYRCVD(val) 0x2
#define TW_V1_INTCLR_v_MBYRCVD(val) (((val)<<TW_V1_INTCLR_s_MBYRCVD(val))&TW_V1_INTCLR_m_MBYRCVD(val))
#define TW_V1_INTCLR_var_MBYRCVD(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_MBYRCVD(var)) >> TW_V1_INTCLR_s_MBYRCVD(var);
#define TW_V1_INTCLR_s_MARBLOST(val) 0x2
#define TW_V1_INTCLR_m_MARBLOST(val) 0x4
#define TW_V1_INTCLR_v_MARBLOST(val) (((val)<<TW_V1_INTCLR_s_MARBLOST(val))&TW_V1_INTCLR_m_MARBLOST(val))
#define TW_V1_INTCLR_var_MARBLOST(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_MARBLOST(var)) >> TW_V1_INTCLR_s_MARBLOST(var);
#define TW_V1_INTCLR_s_MBYCDONE(val) 0x3
#define TW_V1_INTCLR_m_MBYCDONE(val) 0x8
#define TW_V1_INTCLR_v_MBYCDONE(val) (((val)<<TW_V1_INTCLR_s_MBYCDONE(val))&TW_V1_INTCLR_m_MBYCDONE(val))
#define TW_V1_INTCLR_var_MBYCDONE(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_MBYCDONE(var)) >> TW_V1_INTCLR_s_MBYCDONE(var);
#define TW_V1_INTCLR_s_MRFLIM(val) 0x4
#define TW_V1_INTCLR_m_MRFLIM(val) 0x10
#define TW_V1_INTCLR_v_MRFLIM(val) (((val)<<TW_V1_INTCLR_s_MRFLIM(val))&TW_V1_INTCLR_m_MRFLIM(val))
#define TW_V1_INTCLR_var_MRFLIM(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_MRFLIM(var)) >> TW_V1_INTCLR_s_MRFLIM(var);
#define TW_V1_INTCLR_s_MWFLIM(val) 0x5
#define TW_V1_INTCLR_m_MWFLIM(val) 0x20
#define TW_V1_INTCLR_v_MWFLIM(val) (((val)<<TW_V1_INTCLR_s_MWFLIM(val))&TW_V1_INTCLR_m_MWFLIM(val))
#define TW_V1_INTCLR_var_MWFLIM(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_MWFLIM(var)) >> TW_V1_INTCLR_s_MWFLIM(var);
#define TW_V1_INTCLR_s_MILLCMD(val) 0x6
#define TW_V1_INTCLR_m_MILLCMD(val) 0x40
#define TW_V1_INTCLR_v_MILLCMD(val) (((val)<<TW_V1_INTCLR_s_MILLCMD(val))&TW_V1_INTCLR_m_MILLCMD(val))
#define TW_V1_INTCLR_var_MILLCMD(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_MILLCMD(var)) >> TW_V1_INTCLR_s_MILLCMD(var);
#define TW_V1_INTCLR_m_Unused7 0x80
#define TW_V1_INTCLR_s_MHOLD(val) 0x8
#define TW_V1_INTCLR_m_MHOLD(val) 0x100
#define TW_V1_INTCLR_v_MHOLD(val) (((RALuint16)(val)<<TW_V1_INTCLR_s_MHOLD(val))&TW_V1_INTCLR_m_MHOLD(val))
#define TW_V1_INTCLR_var_MHOLD(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_MHOLD(var)) >> TW_V1_INTCLR_s_MHOLD(var);
#define TW_V1_INTCLR_m_Unused9 0xfe00
#define TW_V1_INTCLR_s_SNACK(val) 0x10
#define TW_V1_INTCLR_m_SNACK(val) 0x10000UL
#define TW_V1_INTCLR_v_SNACK(val) (((RALuint32)(val)<<TW_V1_INTCLR_s_SNACK(val))&TW_V1_INTCLR_m_SNACK(val))
#define TW_V1_INTCLR_var_SNACK(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_SNACK(var)) >> TW_V1_INTCLR_s_SNACK(var);
#define TW_V1_INTCLR_s_SBYRCVD(val) 0x11
#define TW_V1_INTCLR_m_SBYRCVD(val) 0x20000UL
#define TW_V1_INTCLR_v_SBYRCVD(val) (((RALuint32)(val)<<TW_V1_INTCLR_s_SBYRCVD(val))&TW_V1_INTCLR_m_SBYRCVD(val))
#define TW_V1_INTCLR_var_SBYRCVD(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_SBYRCVD(var)) >> TW_V1_INTCLR_s_SBYRCVD(var);
#define TW_V1_INTCLR_s_SWRREQ(val) 0x12
#define TW_V1_INTCLR_m_SWRREQ(val) 0x40000UL
#define TW_V1_INTCLR_v_SWRREQ(val) (((RALuint32)(val)<<TW_V1_INTCLR_s_SWRREQ(val))&TW_V1_INTCLR_m_SWRREQ(val))
#define TW_V1_INTCLR_var_SWRREQ(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_SWRREQ(var)) >> TW_V1_INTCLR_s_SWRREQ(var);
#define TW_V1_INTCLR_s_SRDREQ(val) 0x13
#define TW_V1_INTCLR_m_SRDREQ(val) 0x80000UL
#define TW_V1_INTCLR_v_SRDREQ(val) (((RALuint32)(val)<<TW_V1_INTCLR_s_SRDREQ(val))&TW_V1_INTCLR_m_SRDREQ(val))
#define TW_V1_INTCLR_var_SRDREQ(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_SRDREQ(var)) >> TW_V1_INTCLR_s_SRDREQ(var);
#define TW_V1_INTCLR_s_SRFLIM(val) 0x14
#define TW_V1_INTCLR_m_SRFLIM(val) 0x100000UL
#define TW_V1_INTCLR_v_SRFLIM(val) (((RALuint32)(val)<<TW_V1_INTCLR_s_SRFLIM(val))&TW_V1_INTCLR_m_SRFLIM(val))
#define TW_V1_INTCLR_var_SRFLIM(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_SRFLIM(var)) >> TW_V1_INTCLR_s_SRFLIM(var);
#define TW_V1_INTCLR_s_SWFLIM(val) 0x15
#define TW_V1_INTCLR_m_SWFLIM(val) 0x200000UL
#define TW_V1_INTCLR_v_SWFLIM(val) (((RALuint32)(val)<<TW_V1_INTCLR_s_SWFLIM(val))&TW_V1_INTCLR_m_SWFLIM(val))
#define TW_V1_INTCLR_var_SWFLIM(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_SWFLIM(var)) >> TW_V1_INTCLR_s_SWFLIM(var);
#define TW_V1_INTCLR_s_SWFLOCKED(val) 0x16
#define TW_V1_INTCLR_m_SWFLOCKED(val) 0x400000UL
#define TW_V1_INTCLR_v_SWFLOCKED(val) (((RALuint32)(val)<<TW_V1_INTCLR_s_SWFLOCKED(val))&TW_V1_INTCLR_m_SWFLOCKED(val))
#define TW_V1_INTCLR_var_SWFLOCKED(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_SWFLOCKED(var)) >> TW_V1_INTCLR_s_SWFLOCKED(var);
#define TW_V1_INTCLR_s_SGENCALL(val) 0x17
#define TW_V1_INTCLR_m_SGENCALL(val) 0x800000UL
#define TW_V1_INTCLR_v_SGENCALL(val) (((RALuint32)(val)<<TW_V1_INTCLR_s_SGENCALL(val))&TW_V1_INTCLR_m_SGENCALL(val))
#define TW_V1_INTCLR_var_SGENCALL(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_SGENCALL(var)) >> TW_V1_INTCLR_s_SGENCALL(var);
#define TW_V1_INTCLR_s_SHOLD(val) 0x18
#define TW_V1_INTCLR_m_SHOLD(val) 0x1000000UL
#define TW_V1_INTCLR_v_SHOLD(val) (((RALuint32)(val)<<TW_V1_INTCLR_s_SHOLD(val))&TW_V1_INTCLR_m_SHOLD(val))
#define TW_V1_INTCLR_var_SHOLD(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_SHOLD(var)) >> TW_V1_INTCLR_s_SHOLD(var);
#define TW_V1_INTCLR_m_Unused25 0x3e000000UL
#define TW_V1_INTCLR_s_START(val) 0x1e
#define TW_V1_INTCLR_m_START(val) 0x40000000UL
#define TW_V1_INTCLR_v_START(val) (((RALuint32)(val)<<TW_V1_INTCLR_s_START(val))&TW_V1_INTCLR_m_START(val))
#define TW_V1_INTCLR_var_START(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_START(var)) >> TW_V1_INTCLR_s_START(var);
#define TW_V1_INTCLR_s_STOP(val) 0x1f
#define TW_V1_INTCLR_m_STOP(val) 0x80000000UL
#define TW_V1_INTCLR_v_STOP(val) (((RALuint32)(val)<<TW_V1_INTCLR_s_STOP(val))&TW_V1_INTCLR_m_STOP(val))
#define TW_V1_INTCLR_var_STOP(var) var=(Reserved_for_RAL_32 & TW_V1_INTCLR_m_STOP(var)) >> TW_V1_INTCLR_s_STOP(var);

#define TW_V1_INTCLR_OFF 0x00000048
#define TW_V1_INTCLR_SIZE 32

#define TW_V1_INTCLR_SET(BlkInfo, ...) _TW_V1_INTCLR_SET(BlkInfo, PP_NARG(__VA_ARGS__), __VA_ARGS__)

#define _TW_V1_INTCLR_SET(BlkInfo, count, ...) __TW_V1_INTCLR_SET(BlkInfo, count, __VA_ARGS__)

#define __TW_V1_INTCLR_SET(BlkInfo, count, ...) _TW_V1_INTCLR_SET ## count(BlkInfo, __VA_ARGS__)

#define ___TW_V1_INTCLR_SET(BlkInfo, mask, value) \
do {\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x00000048,\
~(0L | mask  | TW_V1_INTCLR_m_Unused7 | TW_V1_INTCLR_m_Unused9 | TW_V1_INTCLR_m_Unused25), 0L | value);\
} while(0)


#define _TW_V1_INTCLR_SET1(BlkInfo, fld1) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1, \
TW_V1_INTCLR_v_##fld1)

#define _TW_V1_INTCLR_SET2(BlkInfo, fld1, fld2) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2)

#define _TW_V1_INTCLR_SET3(BlkInfo, fld1, fld2, fld3) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3)

#define _TW_V1_INTCLR_SET4(BlkInfo, fld1, fld2, fld3, fld4) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4)

#define _TW_V1_INTCLR_SET5(BlkInfo, fld1, fld2, fld3, fld4, fld5) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5)

#define _TW_V1_INTCLR_SET6(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6)

#define _TW_V1_INTCLR_SET7(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7)

#define _TW_V1_INTCLR_SET8(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_##fld9, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7 | TW_V1_INTCLR_v_##fld9)

#define _TW_V1_INTCLR_SET9(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_##fld9 | TW_V1_INTCLR_m_##fld11, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7 | TW_V1_INTCLR_v_##fld9 | TW_V1_INTCLR_v_##fld11)

#define _TW_V1_INTCLR_SET10(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_##fld9 | TW_V1_INTCLR_m_##fld11 | TW_V1_INTCLR_m_##fld12, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7 | TW_V1_INTCLR_v_##fld9 | TW_V1_INTCLR_v_##fld11 | TW_V1_INTCLR_v_##fld12)

#define _TW_V1_INTCLR_SET11(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_##fld9 | TW_V1_INTCLR_m_##fld11 | TW_V1_INTCLR_m_##fld12 | TW_V1_INTCLR_m_##fld13, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7 | TW_V1_INTCLR_v_##fld9 | TW_V1_INTCLR_v_##fld11 | TW_V1_INTCLR_v_##fld12 | TW_V1_INTCLR_v_##fld13)

#define _TW_V1_INTCLR_SET12(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_##fld9 | TW_V1_INTCLR_m_##fld11 | TW_V1_INTCLR_m_##fld12 | TW_V1_INTCLR_m_##fld13 | TW_V1_INTCLR_m_##fld14, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7 | TW_V1_INTCLR_v_##fld9 | TW_V1_INTCLR_v_##fld11 | TW_V1_INTCLR_v_##fld12 | TW_V1_INTCLR_v_##fld13 | TW_V1_INTCLR_v_##fld14)

#define _TW_V1_INTCLR_SET13(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_##fld9 | TW_V1_INTCLR_m_##fld11 | TW_V1_INTCLR_m_##fld12 | TW_V1_INTCLR_m_##fld13 | TW_V1_INTCLR_m_##fld14 | TW_V1_INTCLR_m_##fld15, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7 | TW_V1_INTCLR_v_##fld9 | TW_V1_INTCLR_v_##fld11 | TW_V1_INTCLR_v_##fld12 | TW_V1_INTCLR_v_##fld13 | TW_V1_INTCLR_v_##fld14 | TW_V1_INTCLR_v_##fld15)

#define _TW_V1_INTCLR_SET14(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_##fld9 | TW_V1_INTCLR_m_##fld11 | TW_V1_INTCLR_m_##fld12 | TW_V1_INTCLR_m_##fld13 | TW_V1_INTCLR_m_##fld14 | TW_V1_INTCLR_m_##fld15 | TW_V1_INTCLR_m_##fld16, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7 | TW_V1_INTCLR_v_##fld9 | TW_V1_INTCLR_v_##fld11 | TW_V1_INTCLR_v_##fld12 | TW_V1_INTCLR_v_##fld13 | TW_V1_INTCLR_v_##fld14 | TW_V1_INTCLR_v_##fld15 | TW_V1_INTCLR_v_##fld16)

#define _TW_V1_INTCLR_SET15(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_##fld9 | TW_V1_INTCLR_m_##fld11 | TW_V1_INTCLR_m_##fld12 | TW_V1_INTCLR_m_##fld13 | TW_V1_INTCLR_m_##fld14 | TW_V1_INTCLR_m_##fld15 | TW_V1_INTCLR_m_##fld16 | TW_V1_INTCLR_m_##fld17, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7 | TW_V1_INTCLR_v_##fld9 | TW_V1_INTCLR_v_##fld11 | TW_V1_INTCLR_v_##fld12 | TW_V1_INTCLR_v_##fld13 | TW_V1_INTCLR_v_##fld14 | TW_V1_INTCLR_v_##fld15 | TW_V1_INTCLR_v_##fld16 | TW_V1_INTCLR_v_##fld17)

#define _TW_V1_INTCLR_SET16(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_##fld9 | TW_V1_INTCLR_m_##fld11 | TW_V1_INTCLR_m_##fld12 | TW_V1_INTCLR_m_##fld13 | TW_V1_INTCLR_m_##fld14 | TW_V1_INTCLR_m_##fld15 | TW_V1_INTCLR_m_##fld16 | TW_V1_INTCLR_m_##fld17 | TW_V1_INTCLR_m_##fld18, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7 | TW_V1_INTCLR_v_##fld9 | TW_V1_INTCLR_v_##fld11 | TW_V1_INTCLR_v_##fld12 | TW_V1_INTCLR_v_##fld13 | TW_V1_INTCLR_v_##fld14 | TW_V1_INTCLR_v_##fld15 | TW_V1_INTCLR_v_##fld16 | TW_V1_INTCLR_v_##fld17 | TW_V1_INTCLR_v_##fld18)

#define _TW_V1_INTCLR_SET17(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_##fld9 | TW_V1_INTCLR_m_##fld11 | TW_V1_INTCLR_m_##fld12 | TW_V1_INTCLR_m_##fld13 | TW_V1_INTCLR_m_##fld14 | TW_V1_INTCLR_m_##fld15 | TW_V1_INTCLR_m_##fld16 | TW_V1_INTCLR_m_##fld17 | TW_V1_INTCLR_m_##fld18 | TW_V1_INTCLR_m_##fld19, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7 | TW_V1_INTCLR_v_##fld9 | TW_V1_INTCLR_v_##fld11 | TW_V1_INTCLR_v_##fld12 | TW_V1_INTCLR_v_##fld13 | TW_V1_INTCLR_v_##fld14 | TW_V1_INTCLR_v_##fld15 | TW_V1_INTCLR_v_##fld16 | TW_V1_INTCLR_v_##fld17 | TW_V1_INTCLR_v_##fld18 | TW_V1_INTCLR_v_##fld19)

#define _TW_V1_INTCLR_SET18(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_##fld9 | TW_V1_INTCLR_m_##fld11 | TW_V1_INTCLR_m_##fld12 | TW_V1_INTCLR_m_##fld13 | TW_V1_INTCLR_m_##fld14 | TW_V1_INTCLR_m_##fld15 | TW_V1_INTCLR_m_##fld16 | TW_V1_INTCLR_m_##fld17 | TW_V1_INTCLR_m_##fld18 | TW_V1_INTCLR_m_##fld19 | TW_V1_INTCLR_m_##fld21, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7 | TW_V1_INTCLR_v_##fld9 | TW_V1_INTCLR_v_##fld11 | TW_V1_INTCLR_v_##fld12 | TW_V1_INTCLR_v_##fld13 | TW_V1_INTCLR_v_##fld14 | TW_V1_INTCLR_v_##fld15 | TW_V1_INTCLR_v_##fld16 | TW_V1_INTCLR_v_##fld17 | TW_V1_INTCLR_v_##fld18 | TW_V1_INTCLR_v_##fld19 | TW_V1_INTCLR_v_##fld21)

#define _TW_V1_INTCLR_SET19(BlkInfo, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21, fld22) \
___TW_V1_INTCLR_SET(BlkInfo, TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_##fld9 | TW_V1_INTCLR_m_##fld11 | TW_V1_INTCLR_m_##fld12 | TW_V1_INTCLR_m_##fld13 | TW_V1_INTCLR_m_##fld14 | TW_V1_INTCLR_m_##fld15 | TW_V1_INTCLR_m_##fld16 | TW_V1_INTCLR_m_##fld17 | TW_V1_INTCLR_m_##fld18 | TW_V1_INTCLR_m_##fld19 | TW_V1_INTCLR_m_##fld21 | TW_V1_INTCLR_m_##fld22, \
TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7 | TW_V1_INTCLR_v_##fld9 | TW_V1_INTCLR_v_##fld11 | TW_V1_INTCLR_v_##fld12 | TW_V1_INTCLR_v_##fld13 | TW_V1_INTCLR_v_##fld14 | TW_V1_INTCLR_v_##fld15 | TW_V1_INTCLR_v_##fld16 | TW_V1_INTCLR_v_##fld17 | TW_V1_INTCLR_v_##fld18 | TW_V1_INTCLR_v_##fld19 | TW_V1_INTCLR_v_##fld21 | TW_V1_INTCLR_v_##fld22)

#define TW_V1_INTCLR_SET1(BlkInfo, fld1) \
{\
(BlkInfo)->errorState = (BlkInfo)->RegWrite32(BlkInfo, (BlkInfo)->BaseAddress+0x00000048,\
~(0L | TW_V1_INTCLR_m_##fld1),\
0L | TW_V1_INTCLR_v_##fld1);\
}


#define TW_V1_INTCLR_DEF(fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21, fld22) \
{\
0 | TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7 | TW_V1_INTCLR_v_##fld9 | TW_V1_INTCLR_v_##fld11 | TW_V1_INTCLR_v_##fld12 | TW_V1_INTCLR_v_##fld13 | TW_V1_INTCLR_v_##fld14 | TW_V1_INTCLR_v_##fld15 | TW_V1_INTCLR_v_##fld16 | TW_V1_INTCLR_v_##fld17 | TW_V1_INTCLR_v_##fld18 | TW_V1_INTCLR_v_##fld19 | TW_V1_INTCLR_v_##fld21 | TW_V1_INTCLR_v_##fld22, \
~(0L | TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_Unused7 | TW_V1_INTCLR_m_##fld9 | TW_V1_INTCLR_m_Unused9 | TW_V1_INTCLR_m_##fld11 | TW_V1_INTCLR_m_##fld12 | TW_V1_INTCLR_m_##fld13 | TW_V1_INTCLR_m_##fld14 | TW_V1_INTCLR_m_##fld15 | TW_V1_INTCLR_m_##fld16 | TW_V1_INTCLR_m_##fld17 | TW_V1_INTCLR_m_##fld18 | TW_V1_INTCLR_m_##fld19 | TW_V1_INTCLR_m_Unused25 | TW_V1_INTCLR_m_##fld21 | TW_V1_INTCLR_m_##fld22), \
32, \
0x00000048 \
}

#define TW_V1_INTCLR_MEM(RegEntry, fld1, fld2, fld3, fld4, fld5, fld6, fld7, fld9, fld11, fld12, fld13, fld14, fld15, fld16, fld17, fld18, fld19, fld21, fld22) \
RegEntry.dwValue = (RegEntry.dwValue & ~(0L | TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_Unused7 | TW_V1_INTCLR_m_##fld9 | TW_V1_INTCLR_m_Unused9 | TW_V1_INTCLR_m_##fld11 | TW_V1_INTCLR_m_##fld12 | TW_V1_INTCLR_m_##fld13 | TW_V1_INTCLR_m_##fld14 | TW_V1_INTCLR_m_##fld15 | TW_V1_INTCLR_m_##fld16 | TW_V1_INTCLR_m_##fld17 | TW_V1_INTCLR_m_##fld18 | TW_V1_INTCLR_m_##fld19 | TW_V1_INTCLR_m_Unused25 | TW_V1_INTCLR_m_##fld21 | TW_V1_INTCLR_m_##fld22))| \
(0 | TW_V1_INTCLR_v_##fld1 | TW_V1_INTCLR_v_##fld2 | TW_V1_INTCLR_v_##fld3 | TW_V1_INTCLR_v_##fld4 | TW_V1_INTCLR_v_##fld5 | TW_V1_INTCLR_v_##fld6 | TW_V1_INTCLR_v_##fld7 | TW_V1_INTCLR_v_##fld9 | TW_V1_INTCLR_v_##fld11 | TW_V1_INTCLR_v_##fld12 | TW_V1_INTCLR_v_##fld13 | TW_V1_INTCLR_v_##fld14 | TW_V1_INTCLR_v_##fld15 | TW_V1_INTCLR_v_##fld16 | TW_V1_INTCLR_v_##fld17 | TW_V1_INTCLR_v_##fld18 | TW_V1_INTCLR_v_##fld19 | TW_V1_INTCLR_v_##fld21 | TW_V1_INTCLR_v_##fld22);\
RegEntry.dwMask &= ~(0L | TW_V1_INTCLR_m_##fld1 | TW_V1_INTCLR_m_##fld2 | TW_V1_INTCLR_m_##fld3 | TW_V1_INTCLR_m_##fld4 | TW_V1_INTCLR_m_##fld5 | TW_V1_INTCLR_m_##fld6 | TW_V1_INTCLR_m_##fld7 | TW_V1_INTCLR_m_Unused7 | TW_V1_INTCLR_m_##fld9 | TW_V1_INTCLR_m_Unused9 | TW_V1_INTCLR_m_##fld11 | TW_V1_INTCLR_m_##fld12 | TW_V1_INTCLR_m_##fld13 | TW_V1_INTCLR_m_##fld14 | TW_V1_INTCLR_m_##fld15 | TW_V1_INTCLR_m_##fld16 | TW_V1_INTCLR_m_##fld17 | TW_V1_INTCLR_m_##fld18 | TW_V1_INTCLR_m_##fld19 | TW_V1_INTCLR_m_Unused25 | TW_V1_INTCLR_m_##fld21 | TW_V1_INTCLR_m_##fld22)
#endif /*__TW_V1_REGS_H__*/
/*==========================================================================*/
/*==========================================================================*/
/*EXAMPLES OF USAGE*/


/*==========================================================================*/
/* BLOCK/ARRAY READ/WRITE */

/*
ARRAYSET(BlkInfo, pRegEntry, wCount);
*/

/*
BLOCKSET(BlkInfo, REGNAME, pData, wCount, bIncDest, bIncSource);
*/

/*
BLOCKGET(BlkInfo, REGNAME, pData, wCount, bIncSource);
*/


/*==========================================================================*/
/*Two-wire Master Read FIFO Register*/
/*
TW_V1_MRFIFO_GET(BlkInfo, ALL(var0), RDATA(var1));
*/
/*
TW_V1_MRFIFO_GET1(BlkInfo, fld1(var0));
*/

/*==========================================================================*/
/*Two-wire Master Write FIFO Register:*/
/*
TW_V1_MWFIFO_SET(BlkInfo, ALL(0x0), WDATA(0x0), CMD(0x0));
*/
/*
TW_V1_MWFIFO_SET1(BlkInfo, fld1(0x0));
*/
/*
TW_V1_MWFIFO_DEF(ALL(0x0), WDATA(0x0), CMD(0x0));
*/
/*
TW_V1_MWFIFO_MEM(RegEntry, ALL(0x0), WDATA(0x0), CMD(0x0));
*/

/*==========================================================================*/
/*Two-wire Master Read and Write FIFO Status/Configuration Register:*/
/*
TW_V1_MFIFOSTAT_GET(BlkInfo, ALL(var0), WFNE(var1), RFNE(var2), WFSZ(var3),
                    RFSZ(var4));
*/
/*
TW_V1_MFIFOSTAT_GET1(BlkInfo, fld1(var0));
*/

/*==========================================================================*/
/*Two-wire Master Control and Status Register*/
/*
TW_V1_MCTL_SET(BlkInfo, ALL(0x0), BUSSTATE(0x0), RUNSTATE(0x0), RTACKPND(0x0),
               SCLSTATE(0x0), SDASTATE(0x0), SCLSPEED(0x0), LCLSTST(0x0),
               MWFTHR(0x0), MRFTHR(0x0), FASTMODE(0x0), CLRHLT(0x0),
               AUTOHOLD(0x0), MRFRST(0x0), MWFRST(0x0), MASTER_RST(0x0),
               MASTER_EN(0x0));
*/
/*
TW_V1_MCTL_SET1(BlkInfo, fld1(0x0));
*/
/*
TW_V1_MCTL_DEF(ALL(0x0), BUSSTATE(0x0), RUNSTATE(0x0), RTACKPND(0x0),
               SCLSTATE(0x0), SDASTATE(0x0), SCLSPEED(0x0), LCLSTST(0x0),
               MWFTHR(0x0), MRFTHR(0x0), FASTMODE(0x0), CLRHLT(0x0),
               AUTOHOLD(0x0), MRFRST(0x0), MWFRST(0x0), MASTER_RST(0x0),
               MASTER_EN(0x0));
*/
/*
TW_V1_MCTL_MEM(RegEntry, ALL(0x0), BUSSTATE(0x0), RUNSTATE(0x0), RTACKPND(0x0),
               SCLSTATE(0x0), SDASTATE(0x0), SCLSPEED(0x0), LCLSTST(0x0),
               MWFTHR(0x0), MRFTHR(0x0), FASTMODE(0x0), CLRHLT(0x0),
               AUTOHOLD(0x0), MRFRST(0x0), MWFRST(0x0), MASTER_RST(0x0),
               MASTER_EN(0x0));
*/
/*
TW_V1_MCTL_GET(BlkInfo, ALL(var0), BUSSTATE(var1), RUNSTATE(var2),
               RTACKPND(var3), SCLSTATE(var4), SDASTATE(var5),
               SCLSPEED(var7), LCLSTST(var8), MWFTHR(var9), MRFTHR(var10),
               FASTMODE(var11), CLRHLT(var12), AUTOHOLD(var14),
               MRFRST(var15), MWFRST(var16), MASTER_RST(var17),
               MASTER_EN(var18));
*/
/*
TW_V1_MCTL_GET1(BlkInfo, fld1(var0));
*/

/*==========================================================================*/
/*Two-wire Master SCL0 and SCL1 Counter*/
/*
TW_V1_T_SCL0_SCL1_SET(BlkInfo, ALL(0x0), T_SCL0(0x0), T_SCL1(0x0));
*/
/*
TW_V1_T_SCL0_SCL1_SET1(BlkInfo, fld1(0x0));
*/
/*
TW_V1_T_SCL0_SCL1_DEF(ALL(0x0), T_SCL0(0x0), T_SCL1(0x0));
*/
/*
TW_V1_T_SCL0_SCL1_MEM(RegEntry, ALL(0x0), T_SCL0(0x0), T_SCL1(0x0));
*/
/*
TW_V1_T_SCL0_SCL1_GET(BlkInfo, ALL(var0), T_SCL0(var1), T_SCL1(var3));
*/
/*
TW_V1_T_SCL0_SCL1_GET1(BlkInfo, fld1(var0));
*/

/*==========================================================================*/
/*Two-wire Master BUF and SUSTO Counter*/
/*
TW_V1_T_BUF_SUSTO_SET(BlkInfo, ALL(0x0), T_BUF(0x0), T_SUSTO(0x0));
*/
/*
TW_V1_T_BUF_SUSTO_SET1(BlkInfo, fld1(0x0));
*/
/*
TW_V1_T_BUF_SUSTO_DEF(ALL(0x0), T_BUF(0x0), T_SUSTO(0x0));
*/
/*
TW_V1_T_BUF_SUSTO_MEM(RegEntry, ALL(0x0), T_BUF(0x0), T_SUSTO(0x0));
*/
/*
TW_V1_T_BUF_SUSTO_GET(BlkInfo, ALL(var0), T_BUF(var1), T_SUSTO(var3));
*/
/*
TW_V1_T_BUF_SUSTO_GET1(BlkInfo, fld1(var0));
*/

/*==========================================================================*/
/*Two-wire Master HDSTA and SUSTA Counter*/
/*
TW_V1_T_HDSTA_SUSTA_SET(BlkInfo, ALL(0x0), T_HDSTA(0x0), T_SUSTA(0x0));
*/
/*
TW_V1_T_HDSTA_SUSTA_SET1(BlkInfo, fld1(0x0));
*/
/*
TW_V1_T_HDSTA_SUSTA_DEF(ALL(0x0), T_HDSTA(0x0), T_SUSTA(0x0));
*/
/*
TW_V1_T_HDSTA_SUSTA_MEM(RegEntry, ALL(0x0), T_HDSTA(0x0), T_SUSTA(0x0));
*/
/*
TW_V1_T_HDSTA_SUSTA_GET(BlkInfo, ALL(var0), T_HDSTA(var1), T_SUSTA(var3));
*/
/*
TW_V1_T_HDSTA_SUSTA_GET1(BlkInfo, fld1(var0));
*/

/*==========================================================================*/
/*Two-wire Master DRVEN and SMPEN Counter*/
/*
TW_V1_T_DRVEN_SMPEN_SET(BlkInfo, ALL(0x0), T_DRVEN(0x0), T_SMPEN(0x0));
*/
/*
TW_V1_T_DRVEN_SMPEN_SET1(BlkInfo, fld1(0x0));
*/
/*
TW_V1_T_DRVEN_SMPEN_DEF(ALL(0x0), T_DRVEN(0x0), T_SMPEN(0x0));
*/
/*
TW_V1_T_DRVEN_SMPEN_MEM(RegEntry, ALL(0x0), T_DRVEN(0x0), T_SMPEN(0x0));
*/
/*
TW_V1_T_DRVEN_SMPEN_GET(BlkInfo, ALL(var0), T_DRVEN(var1), T_SMPEN(var3));
*/
/*
TW_V1_T_DRVEN_SMPEN_GET1(BlkInfo, fld1(var0));
*/

/*==========================================================================*/
/*Two-wire Slave Read FIFO Register:*/
/*
TW_V1_SRFIFO_GET(BlkInfo, ALL(var0), RDATA(var1));
*/
/*
TW_V1_SRFIFO_GET1(BlkInfo, fld1(var0));
*/

/*==========================================================================*/
/*Two-wire Slave Write FIFO Register:*/
/*
TW_V1_SWFIFO_SET(BlkInfo, ALL(0x0), WDATA(0x0));
*/
/*
TW_V1_SWFIFO_SET1(BlkInfo, fld1(0x0));
*/
/*
TW_V1_SWFIFO_DEF(ALL(0x0), WDATA(0x0));
*/
/*
TW_V1_SWFIFO_MEM(RegEntry, ALL(0x0), WDATA(0x0));
*/

/*==========================================================================*/
/*Two-wire Slave Read and Write FIFO Status and Configuration Register:*/
/*
TW_V1_SFIFOSTAT_GET(BlkInfo, ALL(var0), WFNE(var1), RFNE(var2), WFSZ(var3),
                    RFSZ(var4));
*/
/*
TW_V1_SFIFOSTAT_GET1(BlkInfo, fld1(var0));
*/

/*==========================================================================*/
/*Two-wire Slave Control and Status Register:*/
/*
TW_V1_SCTL_SET(BlkInfo, ALL(0x0), BUSSTATE(0x0), SWFLOCK(0x0), RTACKPND(0x0),
               ALLADDREN(0x0), GENCALL_EN(0x0), ADDRMODE(0x0), SLVADDR(0x0),
               SCLSTATE(0x0), SDASTATE(0x0), SWFTHR(0x0), SRFTHR(0x0),
               AUTOACK(0x0), ACKCMD(0x0), UNLOCK(0x0), SRFRST(0x0),
               SWFRST(0x0), SLAVERST(0x0), SLAVEEN(0x0));
*/
/*
TW_V1_SCTL_SET1(BlkInfo, fld1(0x0));
*/
/*
TW_V1_SCTL_DEF(ALL(0x0), BUSSTATE(0x0), SWFLOCK(0x0), RTACKPND(0x0),
               ALLADDREN(0x0), GENCALL_EN(0x0), ADDRMODE(0x0), SLVADDR(0x0),
               SCLSTATE(0x0), SDASTATE(0x0), SWFTHR(0x0), SRFTHR(0x0),
               AUTOACK(0x0), ACKCMD(0x0), UNLOCK(0x0), SRFRST(0x0),
               SWFRST(0x0), SLAVERST(0x0), SLAVEEN(0x0));
*/
/*
TW_V1_SCTL_MEM(RegEntry, ALL(0x0), BUSSTATE(0x0), SWFLOCK(0x0), RTACKPND(0x0),
               ALLADDREN(0x0), GENCALL_EN(0x0), ADDRMODE(0x0), SLVADDR(0x0),
               SCLSTATE(0x0), SDASTATE(0x0), SWFTHR(0x0), SRFTHR(0x0),
               AUTOACK(0x0), ACKCMD(0x0), UNLOCK(0x0), SRFRST(0x0),
               SWFRST(0x0), SLAVERST(0x0), SLAVEEN(0x0));
*/
/*
TW_V1_SCTL_GET(BlkInfo, ALL(var0), BUSSTATE(var1), SWFLOCK(var2), RTACKPND(var4),
               ALLADDREN(var5), GENCALL_EN(var6), ADDRMODE(var7),
               SLVADDR(var8), SCLSTATE(var9), SDASTATE(var10), SWFTHR(var11),
               SRFTHR(var12), AUTOACK(var13), ACKCMD(var14), UNLOCK(var15),
               SRFRST(var16), SWFRST(var17), SLAVERST(var18), SLAVEEN(var19));
*/
/*
TW_V1_SCTL_GET1(BlkInfo, fld1(var0));
*/

/*==========================================================================*/
/*XTAL Clock Type*/
/*
TW_V1_CRYSTAL_FREQ_SET(BlkInfo, ALL(0x0), XTAL_TYPE(0x0), TIMEOUT_EN(0x0));
*/
/*
TW_V1_CRYSTAL_FREQ_SET1(BlkInfo, fld1(0x0));
*/
/*
TW_V1_CRYSTAL_FREQ_DEF(ALL(0x0), XTAL_TYPE(0x0), TIMEOUT_EN(0x0));
*/
/*
TW_V1_CRYSTAL_FREQ_MEM(RegEntry, ALL(0x0), XTAL_TYPE(0x0), TIMEOUT_EN(0x0));
*/
/*
TW_V1_CRYSTAL_FREQ_GET(BlkInfo, ALL(var0), XTAL_TYPE(var1), TIMEOUT_EN(var3));
*/
/*
TW_V1_CRYSTAL_FREQ_GET1(BlkInfo, fld1(var0));
*/

/*==========================================================================*/
/*Time Out for NAK*/
/*
TW_V1_TIMEOUT_SET(BlkInfo, ALL(0x0), TIMEOUT_VAL(0x0));
*/
/*
TW_V1_TIMEOUT_SET1(BlkInfo, fld1(0x0));
*/
/*
TW_V1_TIMEOUT_DEF(ALL(0x0), TIMEOUT_VAL(0x0));
*/
/*
TW_V1_TIMEOUT_MEM(RegEntry, ALL(0x0), TIMEOUT_VAL(0x0));
*/
/*
TW_V1_TIMEOUT_GET(BlkInfo, ALL(var0), TIMEOUT_VAL(var1));
*/
/*
TW_V1_TIMEOUT_GET1(BlkInfo, fld1(var0));
*/

/*==========================================================================*/
/*Two-wire Interrupt Enable(Mask) Register:*/
/*
TW_V1_INTEN_SET(BlkInfo, ALL(0x0), MNACK(0x0), MBYRCVD(0x0), MARBLOST(0x0), MBYCDONE(0x0),
                MRFLIM(0x0), MWFLIM(0x0), MILLCMD(0x0), MHOLD(0x0),
                SNACK(0x0), SBYRCVD(0x0), SWRREQ(0x0), SRDREQ(0x0),
                SRFLIM(0x0), SWFLIM(0x0), SWFLOCKED(0x0), SGENCALL(0x0),
                SHOLD(0x0), START(0x0), STOP(0x0));
*/
/*
TW_V1_INTEN_SET1(BlkInfo, fld1(0x0));
*/
/*
TW_V1_INTEN_DEF(ALL(0x0), MNACK(0x0), MBYRCVD(0x0), MARBLOST(0x0), MBYCDONE(0x0),
                MRFLIM(0x0), MWFLIM(0x0), MILLCMD(0x0), MHOLD(0x0),
                SNACK(0x0), SBYRCVD(0x0), SWRREQ(0x0), SRDREQ(0x0),
                SRFLIM(0x0), SWFLIM(0x0), SWFLOCKED(0x0), SGENCALL(0x0),
                SHOLD(0x0), START(0x0), STOP(0x0));
*/
/*
TW_V1_INTEN_MEM(RegEntry, ALL(0x0), MNACK(0x0), MBYRCVD(0x0), MARBLOST(0x0), MBYCDONE(0x0),
                MRFLIM(0x0), MWFLIM(0x0), MILLCMD(0x0), MHOLD(0x0),
                SNACK(0x0), SBYRCVD(0x0), SWRREQ(0x0), SRDREQ(0x0),
                SRFLIM(0x0), SWFLIM(0x0), SWFLOCKED(0x0), SGENCALL(0x0),
                SHOLD(0x0), START(0x0), STOP(0x0));
*/
/*
TW_V1_INTEN_GET(BlkInfo, ALL(var0), MNACK(var1), MBYRCVD(var2), MARBLOST(var3),
                MBYCDONE(var4), MRFLIM(var5), MWFLIM(var6), MILLCMD(var7),
                MHOLD(var9), SNACK(var11), SBYRCVD(var12), SWRREQ(var13),
                SRDREQ(var14), SRFLIM(var15), SWFLIM(var16),
                SWFLOCKED(var17), SGENCALL(var18), SHOLD(var19),
                START(var21), STOP(var22));
*/
/*
TW_V1_INTEN_GET1(BlkInfo, fld1(var0));
*/

/*==========================================================================*/
/*Two-wire Interrupt Status Register:*/
/*
TW_V1_INTSTAT_SET(BlkInfo, ALL(0x0), MNACK(0x0), MBYRCVD(0x0), MARBLOST(0x0),
                  MBYCDONE(0x0), MRFLIM(0x0), MWFLIM(0x0), MILLCMD(0x0),
                  MHOLD(0x0), SNACK(0x0), SBYRCVD(0x0), SWRREQ(0x0),
                  SRDREQ(0x0), SRFLIM(0x0), SWFLIM(0x0), SWFLOCKED(0x0),
                  SGENCALL(0x0), SHOLD(0x0), START(0x0), STOP(0x0));
*/
/*
TW_V1_INTSTAT_SET1(BlkInfo, fld1(0x0));
*/
/*
TW_V1_INTSTAT_DEF(ALL(0x0), MNACK(0x0), MBYRCVD(0x0), MARBLOST(0x0),
                  MBYCDONE(0x0), MRFLIM(0x0), MWFLIM(0x0), MILLCMD(0x0),
                  MHOLD(0x0), SNACK(0x0), SBYRCVD(0x0), SWRREQ(0x0),
                  SRDREQ(0x0), SRFLIM(0x0), SWFLIM(0x0), SWFLOCKED(0x0),
                  SGENCALL(0x0), SHOLD(0x0), START(0x0), STOP(0x0));
*/
/*
TW_V1_INTSTAT_MEM(RegEntry, ALL(0x0), MNACK(0x0), MBYRCVD(0x0), MARBLOST(0x0),
                  MBYCDONE(0x0), MRFLIM(0x0), MWFLIM(0x0), MILLCMD(0x0),
                  MHOLD(0x0), SNACK(0x0), SBYRCVD(0x0), SWRREQ(0x0),
                  SRDREQ(0x0), SRFLIM(0x0), SWFLIM(0x0), SWFLOCKED(0x0),
                  SGENCALL(0x0), SHOLD(0x0), START(0x0), STOP(0x0));
*/
/*
TW_V1_INTSTAT_GET(BlkInfo, ALL(var0), MNACK(var1), MBYRCVD(var2), MARBLOST(var3),
                  MBYCDONE(var4), MRFLIM(var5), MWFLIM(var6), MILLCMD(var7),
                  MHOLD(var9), SNACK(var11), SBYRCVD(var12), SWRREQ(var13),
                  SRDREQ(var14), SRFLIM(var15), SWFLIM(var16),
                  SWFLOCKED(var17), SGENCALL(var18), SHOLD(var19),
                  START(var21), STOP(var22));
*/
/*
TW_V1_INTSTAT_GET1(BlkInfo, fld1(var0));
*/

/*==========================================================================*/
/*Two-wire Interrupt Clear Register:*/
/*
TW_V1_INTCLR_SET(BlkInfo, ALL(0x0), MNACK(0x0), MBYRCVD(0x0), MARBLOST(0x0), MBYCDONE(0x0),
                 MRFLIM(0x0), MWFLIM(0x0), MILLCMD(0x0), MHOLD(0x0),
                 SNACK(0x0), SBYRCVD(0x0), SWRREQ(0x0), SRDREQ(0x0),
                 SRFLIM(0x0), SWFLIM(0x0), SWFLOCKED(0x0), SGENCALL(0x0),
                 SHOLD(0x0), START(0x0), STOP(0x0));
*/
/*
TW_V1_INTCLR_SET1(BlkInfo, fld1(0x0));
*/
/*
TW_V1_INTCLR_DEF(ALL(0x0), MNACK(0x0), MBYRCVD(0x0), MARBLOST(0x0), MBYCDONE(0x0),
                 MRFLIM(0x0), MWFLIM(0x0), MILLCMD(0x0), MHOLD(0x0),
                 SNACK(0x0), SBYRCVD(0x0), SWRREQ(0x0), SRDREQ(0x0),
                 SRFLIM(0x0), SWFLIM(0x0), SWFLOCKED(0x0), SGENCALL(0x0),
                 SHOLD(0x0), START(0x0), STOP(0x0));
*/
/*
TW_V1_INTCLR_MEM(RegEntry, ALL(0x0), MNACK(0x0), MBYRCVD(0x0), MARBLOST(0x0), MBYCDONE(0x0),
                 MRFLIM(0x0), MWFLIM(0x0), MILLCMD(0x0), MHOLD(0x0),
                 SNACK(0x0), SBYRCVD(0x0), SWRREQ(0x0), SRDREQ(0x0),
                 SRFLIM(0x0), SWFLIM(0x0), SWFLOCKED(0x0), SGENCALL(0x0),
                 SHOLD(0x0), START(0x0), STOP(0x0));
*/

