/*
 * pwfu.c - Pixelworks USB Flash Upgrade
 *
 * Copyright (c) 2016 Pixelworks, Inc.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <common.h>
#include <command.h>
#include <errno.h>
#include <malloc.h>
#include <getopt.h>
#include <fs.h>
#include <xfuncs.h>

int usb_pwfu_register(void);

static int do_pwfu(int argc, char *argv[])
{
	return usb_pwfu_register();
}

BAREBOX_CMD_HELP_START(pwfu)
BAREBOX_CMD_HELP_TEXT("Start Pixelworks USB Flash Upgrader")
BAREBOX_CMD_HELP_END

BAREBOX_CMD_START(pwfu)
	.cmd		= do_pwfu,
	BAREBOX_CMD_DESC("flash upgrade")
	BAREBOX_CMD_GROUP(CMD_GRP_MISC)
	BAREBOX_CMD_HELP(cmd_pwfu_help)
BAREBOX_CMD_END
