/*
 * Sys init code for topazeh
 *
 * Copyright (c) 2012 Pixelworks
 */

#include <config.h>
#include <linux/linkage.h>
#include <mach/sysv20.h>

.section .pre_boot.1

/*
 * write/read a SYS controller register
 * requires:
 *   r6 : SYS_V15_BASE
 * uses r0, returns result in r0
 */
.macro	sys_write reg, val
	ldr	r0, =\val
	str	r0, [r6, #\reg]
.endm
.macro	sys_read reg
	ldr	r0, [r6, #\reg]
.endm
.macro write_r0 reg
	str	r0, [r6,#\reg]
.endm

#define SYS_WRITE(reg, val) sys_write reg, val
#define SYS_READ(reg) sys_read reg


ENTRY(init_sys)
#ifdef CONFIG_MACH_TOPAZEH_EVAL
	ldr	r6, =_SYS_V20_BASE
	/**************************/
	/* ***  PLL setting  *** */
	/**************************/
#ifdef CONFIG_DDR_SSC
	SYS_WRITE(MPLLCTRL1, 0x0001aa60)	//MPLLOUT1 300M
	SYS_WRITE(MPLLCTRL2, 0x40d61000)
	SYS_WRITE(MPLLCTRL3, 0x0000001d)
#else
	SYS_WRITE(MPLLCTRL1, 0x01a1ab8c)	//MPLLOUT1 300M
	SYS_WRITE(MPLLCTRL2, 0x00d61000)
#endif
	SYS_WRITE(PLLSTATES, MPLL_PROG_MASK);	//MPLL Program Enable
1:
	SYS_READ(PLLSTATES)
	ands 	r0, #MPLL_DONE_MASK
	beq	1b
	SYS_WRITE(PLLSTATES, 0);
1:
	SYS_READ(PLLSTATES)	//wait for PPLL finished
	ands 	r0, #MPLL_LKDT1
	beq	1b

        /**************************/
        /* ***  PPLL setting  *** */
        /**************************/
        SYS_WRITE(PPLLCTRL1, 0x00411f8c)
        SYS_WRITE(PPLLCTRL2, 0x07ce1004)
        
	SYS_WRITE(PLLSTATES, PPLL_PROG_MASK);   //PPLL Program Enable
1:
        SYS_READ(PLLSTATES)
        ands    r0, #PPLL_DONE_MASK
        beq     1b
        SYS_WRITE(PLLSTATES, 0);
1:
        SYS_READ(PLLSTATES)     //wait for PPLL finished
        ands    r0, #PPLL_LKDT1
        beq     1b


        /**************************/
        /* ***  ARMPLL setting  *** */
        /**************************/
        SYS_WRITE(ARMPLLCTRL1, 0x00001314)
        SYS_WRITE(ARMPLLCTRL2, 0x07ae100e)
        
	SYS_WRITE(PLLSTATES, ARMPLL_PROG_MASK);   //ARMPLL Program Enable
1:
        SYS_READ(PLLSTATES)
        ands    r0, #ARMPLL_DONE_MASK
        beq     1b
        SYS_WRITE(PLLSTATES, 0);
1:
        SYS_READ(PLLSTATES)     //wait for ARMPLL finished
        ands    r0, #ARMPLL_LKDT1
        beq     1b

        SYS_WRITE(CLKDIVIDER2, 0x00010101)
	/*************************/
	/* ***  PAD setting  *** */
	/*************************/
	SYS_WRITE(PAD_DIRCTRL1, 0)
	SYS_WRITE(PAD_DIRCTRL2, 0)

	/*NAND is not used, set bit[0] to 0*/
	SYS_WRITE(PADALTFUNCCTRL4, 0x00000000)
	SYS_WRITE(PADPULLCTRL1, 0x0003e000);
#endif
	mov	pc,lr
ENDPROC(init_sys)
