/*
 * DDR RAM controller init for Topazeh
 *
 * Copyright (c) 2012 Pixelworks
 */

#include <common.h>
#include <io.h>
#include <linux/compiler.h>
#include <mach/sysmap.h>

__section(".pre_boot.c")
void ddr_init(void)
{
	int retry = 0;
	unsigned int wait = 0x3fff;
    int initflag = 0;

	writel(0x184912CF, MI_V14_BASE + 0x0c);	//Set DDRTIMING
#ifdef CONFIG_DDR_16BIT
	writel(0x3, MI_V14_BASE + 0x08);

	writel(0x04000000, DDR2_DDR3_V4_BASE + 0x054);
#endif
	//Loop Training of PHY
	writel(retry, 0xfd040008); // set initial retry count number in Proxy->MB1, may be deleted if no need.
	do {
		retry++;
		writel(readl(SYS_V20_BASE + 0x114) | 0x2, SYS_V20_BASE + 0x114); //Set the Registers to Reset

		//the reading is just to add operations to delay 5ms
		wait = 0x3fff;
		while (readl(SYS_V20_BASE + 0x114) && wait--)
			;
		writel(readl(SYS_V20_BASE + 0x114) & (~0x2), SYS_V20_BASE + 0x114); //Clear the Registers Reset
      phy_reset:
		writel(readl(SYS_V20_BASE + 0x104) | 0x2, SYS_V20_BASE + 0x104); //Reset the Controller and PHY logic
		writel(0x00081003, DDR2_DDR3_V4_BASE + 0x104);
		writel(0x00008063, DDR2_DDR3_V4_BASE + 0x10c);
		writel(0x20000000, DDR2_DDR3_V4_BASE + 0x110);
		writel(0x00000820, DDR2_DDR3_V4_BASE + 0x114);
		writel(0x86000000, DDR2_DDR3_V4_BASE + 0x140);
		writel(0x00008600, DDR2_DDR3_V4_BASE + 0x144);
		writel(0x80000000, DDR2_DDR3_V4_BASE + 0x148);
		writel(0x80808080, DDR2_DDR3_V4_BASE + 0x14c);
		writel(0x80808080, DDR2_DDR3_V4_BASE + 0x150);

		// settings for controller
		writel(0x249f0000, DDR2_DDR3_V4_BASE + 0x004); //0x249f0000
		writel(0x08080924, DDR2_DDR3_V4_BASE + 0x008);
		writel(0x000c8123, DDR2_DDR3_V4_BASE + 0x00c);
		writel(0x02030304, DDR2_DDR3_V4_BASE + 0x010);
	#if defined CONFIG_DDR_1G
		writel(0x0305210e, DDR2_DDR3_V4_BASE + 0x014);
	#else
		writel(0x0305300e, DDR2_DDR3_V4_BASE + 0x014);
	#endif
		writel(0x05050b05, DDR2_DDR3_V4_BASE + 0x018);
		writel(0x00040005, DDR2_DDR3_V4_BASE + 0x01c);
	#if defined CONFIG_DDR_1G
		writel(0x01000024, DDR2_DDR3_V4_BASE + 0x020);
	#else
		writel(0x01000033, DDR2_DDR3_V4_BASE + 0x020);// 0x01000033, tXPR .
	#endif
		writel(0x00030602, DDR2_DDR3_V4_BASE + 0x024);// 0x00030602, tMRD ,
		writel(0x00000010, DDR2_DDR3_V4_BASE + 0x028);
		writel(0x1b500006, DDR2_DDR3_V4_BASE + 0x02c);
		writel(0x01000303, DDR2_DDR3_V4_BASE + 0x030);
	#if defined CONFIG_DDR_1G
		writel(0x02080224, DDR2_DDR3_V4_BASE + 0x034);
	#else
		writel(0x02080233, DDR2_DDR3_V4_BASE + 0x034);
	#endif
		writel(0x00060a07, DDR2_DDR3_V4_BASE + 0x038);

		writel(0x00000001, DDR2_DDR3_V4_BASE + 0x04c);
		writel(0x8000E000, DDR2_DDR3_V4_BASE + 0x080);
		writel(0x55555555, DDR2_DDR3_V4_BASE + 0x098);
		writel(0xaaaaaaaa, DDR2_DDR3_V4_BASE + 0x09c);
		writel(readl(SYS_V20_BASE + 0x104) & (~0x2), SYS_V20_BASE + 0x104); //Clear the Controller and PHY Reset
        if( initflag == 1 )
        {
            goto done;
        }
		// start initialization
		writel(readl(DDR2_DDR3_V4_BASE + 0x000) | 1, DDR2_DDR3_V4_BASE + 0x000);

		// Polling initial done status
		while ((readl(DDR2_DDR3_V4_BASE + 0x06c) & 0x40000000) != 0x40000000)
			;

        if( initflag == 0 )
        {
            initflag++;
            goto phy_reset;
        }
      done:
        
		//DR2_DDR3 start training
		writel(readl(DDR2_DDR3_V4_BASE + 0x03c) | 1, DDR2_DDR3_V4_BASE + 0x03c);
		writel(0x00001000, DDR2_DDR3_V4_BASE + 0x08c);
		writel(readl(DDR2_DDR3_V4_BASE + 0x080)|0x1, DDR2_DDR3_V4_BASE + 0x080);
		writel(readl(DDR2_DDR3_V4_BASE + 0x080)&(~0x1), DDR2_DDR3_V4_BASE + 0x080);

		// Polling training finish status with max 5ms waiting
		wait = 0x3fff;
		while ((readl(DDR2_DDR3_V4_BASE + 0x300) & 0x1) != 0x1 && wait--)
			;

		// clean up register values
		writel(0x0, DDR2_DDR3_V4_BASE + 0x08c);
		writel(readl(DDR2_DDR3_V4_BASE + 0x03c) & ~0x1, DDR2_DDR3_V4_BASE + 0x03c);

		// Polling GATE_TRAIN_STATUS with max 20us
		wait = 0x3ff;
		while ((readl(DDR2_DDR3_V4_BASE + 0x304) & 0xf) != 0xf && wait--)
			;
		if (((readl(DDR2_DDR3_V4_BASE + 0x304) >> 16) & 0xf) != 0xf)
        {
            initflag = 0;
			continue;
        }
        
		// Polling DEYE_TRAIN_STATUS with max 20us
		wait = 0x3ff;
		while ((readl(DDR2_DDR3_V4_BASE + 0x308) & 0xf) != 0xf && wait--)
			;
		if (((readl(DDR2_DDR3_V4_BASE + 0x308) >> 16) & 0xf) != 0xf)
        {
            initflag = 0;
			continue;
        }

		//Data eye window checking failed
		if (((readl(DDR2_DDR3_V4_BASE + 0x380) & 0xff) < 0x80)
			|| (((readl(DDR2_DDR3_V4_BASE + 0x380) >> 8) & 0xff) < 0x80)
			|| (((readl(DDR2_DDR3_V4_BASE + 0x380) >> 16) & 0xff) < 0x80)
			|| (((readl(DDR2_DDR3_V4_BASE + 0x380) >> 24) & 0xff) < 0x80)
			)
        {
            initflag = 0;
			continue;
        }

		//Below is just to record the training count for reference at Proxy->MB1, may be deleted if no need.
		if (retry > readl(0xfd040008))
			writel(retry, 0xfd040008);

		//when training is Passed within 20 times, break the training loop to to continue the boot up.
		break;
	} while (retry <= 20);
}
