/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <init.h>
#include <io.h>
#include <clock.h>
#include <mach/sysmap.h>
#include <mach/ipc_timer.h>


/* 24MHz xClk */
#define CONFIG_XCLK_HZ 24000000
/* 24MHz / 256 */
#define PXLW_TIMER_FREQ (CONFIG_XCLK_HZ / 256)

static uint64_t pxlw_clocksource_read(void)
{
	// note: timer counts down
	return ~readl(TIMER0_BASE + IPC_TMR_VALUE);
}

static struct clocksource pxlw_cs = {
	.read = pxlw_clocksource_read,
	.mask = CLOCKSOURCE_MASK(32),
};

static void pxlw_timer_init (void)
{
	writel(IPC_TMR_CONTROL_ENABLE | IPC_TMR_CONTROL_MODE_FREERUNNING |
	       IPC_TMR_CONTROL_PRESCALE_256,
	       TIMER0_BASE + IPC_TMR_CONTROL);
}

static int pxlw_clocksource_init(void)
{
	pxlw_timer_init();
	clocks_calc_mult_shift(&pxlw_cs.mult, &pxlw_cs.shift,
			       PXLW_TIMER_FREQ, NSEC_PER_SEC, 600);
	return init_clock(&pxlw_cs);
}
core_initcall(pxlw_clocksource_init);
