/*
 * Sys init code for topazeh prime
 *
 * Copyright (c) 2018 Pixelworks
 */

#include <config.h>
#include <linux/linkage.h>
#include <mach/sysv20.h>

.section .pre_boot.1

/*
 * write/read a SYS controller register
 * requires:
 *   r6 : SYS_V15_BASE
 * uses r0, returns result in r0
 */
.macro	sys_write reg, val
	ldr	r0, =\val
	str	r0, [r6, #\reg]
.endm
.macro	sys_read reg
	ldr	r0, [r6, #\reg]
.endm
.macro write_r0 reg
	str	r0, [r6,#\reg]
.endm

#define SYS_WRITE(reg, val) sys_write reg, val
#define SYS_READ(reg) sys_read reg


ENTRY(init_sys)
#ifdef CONFIG_MACH_TOPAZ_PRIME_EVAL
	ldr	r6, =_SYS_V20_BASE
	/**************************/
	/* ***  PLL setting  *** */
	/**************************/
#ifdef CONFIG_DDR_SSC
#ifdef CONFIG_DDR_SS_025
#ifdef CONFIG_DDR_1200
	SYS_WRITE(MPLLCTRL1, 0x0061aa60)             //MPLLOUT0 300M, MPLLOUT1 300M, 
	SYS_WRITE(MPLLCTRL2, 0x47d61003)
//	SYS_WRITE(MPLLCTRL3, 0x00000099)
	SYS_WRITE(MPLLCTRL3, 0x00000019)
#elif CONFIG_DDR_1600
	SYS_WRITE(CLKSRCCTL2, 0x00000020)            //Select MI to MPLLOUT4, 2400/7 = 343MHz, can remove this line if no need speed up MI frequency.
	SYS_WRITE(MPLLCTRL1, 0x0041aa60)             //MPLLOUT0 300M, MPLLOUT1 400M, 
	SYS_WRITE(MPLLCTRL2, 0x47d61003)
//	SYS_WRITE(MPLLCTRL3, 0x00000099)
	SYS_WRITE(MPLLCTRL3, 0x00000019)
#endif
#elif CONFIG_DDR_SS_050
#ifdef CONFIG_DDR_1200
	SYS_WRITE(MPLLCTRL1, 0x0061aa60)             //MPLLOUT0 300M, MPLLOUT1 300M, 
	SYS_WRITE(MPLLCTRL2, 0x47d61003)
//	SYS_WRITE(MPLLCTRL3, 0x0000009b)
	SYS_WRITE(MPLLCTRL3, 0x0000001b)
#elif CONFIG_DDR_1600
	SYS_WRITE(CLKSRCCTL2, 0x00000020)            //Select MI to MPLLOUT4, 2400/7 = 343MHz, can remove this line if no need speed up MI frequency.
	SYS_WRITE(MPLLCTRL1, 0x0041aa60)             //MPLLOUT0 300M, MPLLOUT1 400M, 
	SYS_WRITE(MPLLCTRL2, 0x47d61003)
//	SYS_WRITE(MPLLCTRL3, 0x0000009b)
	SYS_WRITE(MPLLCTRL3, 0x0000001b)
#endif

#elif CONFIG_DDR_SS_100
#ifdef CONFIG_DDR_1200
	SYS_WRITE(MPLLCTRL1, 0x0061aa60)             //MPLLOUT0 300M, MPLLOUT1 300M, 
	SYS_WRITE(MPLLCTRL2, 0x47d61003)
//	SYS_WRITE(MPLLCTRL3, 0x0000009d)
	SYS_WRITE(MPLLCTRL3, 0x0000001d)
#elif CONFIG_DDR_1600
	SYS_WRITE(CLKSRCCTL2, 0x00000020)            //Select MI to MPLLOUT4, 2400/7 = 343MHz, can remove this line if no need speed up MI frequency.
	SYS_WRITE(MPLLCTRL1, 0x0041aa60)             //MPLLOUT0 300M, MPLLOUT1 400M, 
	SYS_WRITE(MPLLCTRL2, 0x47d61003)
//	SYS_WRITE(MPLLCTRL3, 0x0000009d)
	SYS_WRITE(MPLLCTRL3, 0x0000001d)
#endif

#elif CONFIG_DDR_SS_150
#ifdef CONFIG_DDR_1200
	SYS_WRITE(MPLLCTRL1, 0x0061aa60)             //MPLLOUT0 300M, MPLLOUT1 300M, 
	SYS_WRITE(MPLLCTRL2, 0x47d61003)
//	SYS_WRITE(MPLLCTRL3, 0x0000009e)
	SYS_WRITE(MPLLCTRL3, 0x0000001e)
#elif CONFIG_DDR_1600
	SYS_WRITE(CLKSRCCTL2, 0x00000020)            //Select MI to MPLLOUT4, 2400/7 = 343MHz, can remove this line if no need speed up MI frequency.
	SYS_WRITE(MPLLCTRL1, 0x0041aa60)             //MPLLOUT0 300M, MPLLOUT1 400M, 
	SYS_WRITE(MPLLCTRL2, 0x47d61003)
//	SYS_WRITE(MPLLCTRL3, 0x0000009e)
	SYS_WRITE(MPLLCTRL3, 0x0000001e)
#endif

#endif
	SYS_WRITE(PLLSTATES, MPLL_PROG_MASK);	//MPLL Program Enable
1:
	SYS_READ(PLLSTATES)
	ands 	r0, #MPLL_DONE_MASK
	beq	1b
	SYS_WRITE(PLLSTATES, 0);
1:
	SYS_READ(PLLSTATES)	//wait for PPLL finished
	ands 	r0, #MPLL_LKDT1
	beq	1b
#else

	SYS_WRITE(PPLLCTRL1, 0x00411f8c)
	SYS_WRITE(PPLLCTRL2, 0x07ce1009)
	SYS_WRITE(PPLLCTRL3, 0x00000000)
	
	SYS_WRITE(PLLSTATES, PPLL_PROG_MASK);
	
1:
	SYS_READ(PLLSTATES)
	ands 	r0, #PPLL_DONE_MASK
	beq	1b
	SYS_WRITE(PLLSTATES, 0);
1:
    SYS_READ(PLLSTATES) //wait for PPLL finished
	ands    r0, #PPLL_LKDT1
	beq 1b

1:
    SYS_READ(PLLSTATES) //wait for PPLL finished
	ands    r0, #PPLL_LKDT2
	beq 1b

#ifdef CONFIG_DDR_1200
	SYS_WRITE(MPLLCTRL1, 0x0061ab8c)	//MPLLOUT1 300M
	SYS_WRITE(MPLLCTRL2, 0x07d61003)
	SYS_WRITE(MPLLCTRL3, 0x00000000)
#elif CONFIG_DDR_1600
	SYS_WRITE(CLKSRCCTL2, 0x00000020)      //Select MI to MPLLOUT4, MI CLK = 2400/7
	SYS_WRITE(MPLLCTRL1, 0x0041AB8C)	//MPLLOUT1 300M
	SYS_WRITE(MPLLCTRL2, 0x07D61003)
	SYS_WRITE(MPLLCTRL3, 0x00000000)
#endif	
	SYS_WRITE(PLLSTATES, MPLL_PROG_MASK);	//MPLL Program Enable
1:
	SYS_READ(PLLSTATES)
	ands 	r0, #MPLL_DONE_MASK
	beq	1b
	SYS_WRITE(PLLSTATES, 0);
1:
    SYS_READ(PLLSTATES) //wait for MPLL finished
	ands    r0, #MPLL_LKDT1
	beq 1b

1:
    SYS_READ(PLLSTATES) //wait for MPLL finished
	ands    r0, #MPLL_LKDT2
	beq 1b
#endif
	
	SYS_WRITE(ANALOG_CTRL, 0x00000000)
	
	/*************************/
	/* ***  PAD setting  *** */
	/*************************/
	SYS_WRITE(PAD_DIRCTRL1, 0)
	SYS_WRITE(PAD_DIRCTRL2, 0)

	SYS_WRITE(PADALTFUNCCTRL4, 0x00000001)
		
	SYS_READ(LVDSPADCTRL1)
	orr r0, r0, #LVDSPAD_REF_IPD_MASK
	write_r0 LVDSPADCTRL1
#endif
	mov	pc,lr
ENDPROC(init_sys)
