/*
 * DDR RAM controller init for Topazeh Prime
 *
 * Copyright (c) 2018 Pixelworks
 */

#include <common.h>
#include <io.h>
#include <linux/compiler.h>
#include <mach/sysmap.h>
//#include <mach/sysv20.h> //LB added
__section(".pre_boot.c")
void ddr_init(void)
{
	//return;
	int retry = 0;
	unsigned int wait = 0x3fff;
	//unsigned int val = 0;
	unsigned int data = 0;

	data = readl(GPIO2_V2_BASE + 0x00000400);
	data = data |0x20; 
	writel(data, GPIO2_V2_BASE + 0x00000400);
	
	data = readl(GPIO2_V2_BASE + 0x000003fc);
	data = data |0x20; 
	writel(data, GPIO2_V2_BASE + 0x000003fc);

#if defined CONFIG_MACH_TOPAZ_PRIME_EVAL
	writel(0x1849160f, MI_V14_BASE + 0x0c);	//Set DDRTIMING
	writel(0x00000000, MI_V14_BASE + 0x08);	//Set DDRTIMING
#ifdef CONFIG_DDR_16BIT
//	writel(0x3, MI_V14_BASE + 0x08);

	writel(0x04000000, DDR2_DDR3_V4_BASE + 0x054);
#endif
	writel(retry, 0xfd040008); // set initial retry count number in Proxy->MB1, may be deleted if no need.
	//Loop Training of PHY
	do {
		retry++;

		writel(readl(SYS_V20_BASE + 0x104) | (0x3<<29), SYS_V20_BASE + 0x104); //Reset the Controller and PHY logic
		writel(readl(SYS_V20_BASE + 0x104) & ~(0x3<<29), SYS_V20_BASE + 0x104); //Release the Controller Reset and PHY logic
		writel(readl(SYS_V20_BASE + 0x104) | 0x2, SYS_V20_BASE + 0x104); //Reset the MI logic
		writel(readl(SYS_V20_BASE + 0x114) | 0x2, SYS_V20_BASE + 0x114); //Reset the Controller and PHY register
		wait = 0x3ff;
		while (readl(SYS_V20_BASE + 0x114) && wait--)
			;
		writel(readl(SYS_V20_BASE + 0x114) & 0xfffffffd, SYS_V20_BASE + 0x114); //Clear Reset the Controller and PHY register
		while (readl(DDR2_DDR3_V4_BASE + 0x000) & (0x1<<0))
			;
		while (readl(DDR2_DDR3_V4_BASE + 0x06c) & (0x1<<31))
			;

		writel(0x00000002, DDR2_DDR3_V4_BASE + 0x050);
#ifdef CONFIG_DDR_16BIT
		writel(readl(DDR2_DDR3_V4_BASE + 0x054) | 0x04000000, DDR2_DDR3_V4_BASE + 0x054);
#endif

#ifdef CONFIG_DDR_1600
		//PHY IP Register
		writel(0x12402000, DDR2_DDR3_V4_BASE + 0x0100);
		writel(0x02000241, DDR2_DDR3_V4_BASE + 0x0104); 
		writel(0x00000100, DDR2_DDR3_V4_BASE + 0x0130); 
		writel(0x00001400, DDR2_DDR3_V4_BASE + 0x0140); 
		writel(0x00000418, DDR2_DDR3_V4_BASE + 0x0154); 
		writel(0x1d700042, DDR2_DDR3_V4_BASE + 0x0158); 
		writel(0x000c0004, DDR2_DDR3_V4_BASE + 0x0168); 
		writel(0x00a20200, DDR2_DDR3_V4_BASE + 0x016c); 
		writel(0x000c020b, DDR2_DDR3_V4_BASE + 0x0170); 
		writel(0x1387f100, DDR2_DDR3_V4_BASE + 0x0174); 
		writel(0x30d40106, DDR2_DDR3_V4_BASE + 0x0178); 
		writel(0x08090406, DDR2_DDR3_V4_BASE + 0x017c); 
		writel(0x40000900, DDR2_DDR3_V4_BASE + 0x0180); 
		writel(0x0b600c30, DDR2_DDR3_V4_BASE + 0x0184); 
		writel(0xff215a60, DDR2_DDR3_V4_BASE + 0x0194); 
#ifdef CONFIG_DDR_WINBOND_SAMSUNG		
		// Below is for Winbond and Samsung Device
#ifdef CONFIG_DDR_32BIT
		writel(readl(DDR2_DDR3_V4_BASE + 0x01C8) | (0xFF<<8), DDR2_DDR3_V4_BASE + 0x01C8);
#endif
#ifdef CONFIG_DDR_16BIT
		writel(readl(DDR2_DDR3_V4_BASE + 0x01C8) | (0xFF<<8) | 0x04000000, DDR2_DDR3_V4_BASE + 0x01C8);
#endif
#endif
#ifdef CONFIG_DDR_MICRON
		// Below is for Micron Device
#ifdef CONFIG_DDR_32BIT
		writel(readl(DDR2_DDR3_V4_BASE + 0x01C8) | (0x1<<8), DDR2_DDR3_V4_BASE + 0x01C8);
#endif	
#ifdef CONFIG_DDR_16BIT
		writel(readl(DDR2_DDR3_V4_BASE + 0x01C8) | (0x1<<8) | 0x04000000, DDR2_DDR3_V4_BASE + 0x01C8);
#endif
#endif	
		writel(0x06001c06, DDR2_DDR3_V4_BASE + 0x0918); 
		
		//CONTROLLER Register
		writel(0x30d40000, DDR2_DDR3_V4_BASE + 0x0004);
		writel(0x08080c30, DDR2_DDR3_V4_BASE + 0x0008);
		writel(0x13880034, DDR2_DDR3_V4_BASE + 0x000c);
		writel(0x02030405, DDR2_DDR3_V4_BASE + 0x0010);
		writel(0x03064010, DDR2_DDR3_V4_BASE + 0x0014);
		writel(0x06060e06, DDR2_DDR3_V4_BASE + 0x0018);
		writel(0xa0040006, DDR2_DDR3_V4_BASE + 0x001c);
		writel(0x01000051, DDR2_DDR3_V4_BASE + 0x0020);
		writel(0x00030602, DDR2_DDR3_V4_BASE + 0x0024);
		writel(0x00000418, DDR2_DDR3_V4_BASE + 0x0028);
		writel(0x1d700042, DDR2_DDR3_V4_BASE + 0x002c);
		writel(0x01000404, DDR2_DDR3_V4_BASE + 0x0030);
		writel(0x020a0251, DDR2_DDR3_V4_BASE + 0x0034);
		writel(0x00060c08, DDR2_DDR3_V4_BASE + 0x0038);
		writel(0x00000000, DDR2_DDR3_V4_BASE + 0x003c);
#elif CONFIG_DDR_1200	
		//PHY IP registers  
		writel(0x12402000, DDR2_DDR3_V4_BASE + 0x0100);
		// REG_104[10:8] = 2, improve read performance
		writel(0x02000241, DDR2_DDR3_V4_BASE + 0x0104);
		writel(0x00000100, DDR2_DDR3_V4_BASE + 0x0130);
		writel(0x00001400, DDR2_DDR3_V4_BASE + 0x0140);
		writel(0x00000410, DDR2_DDR3_V4_BASE + 0x0154);
		writel(0x1b500042, DDR2_DDR3_V4_BASE + 0x0158);
		//writel(0x00080008, DDR2_DDR3_V4_BASE + 0x0168);
		//writel(0x00BB0400, DDR2_DDR3_V4_BASE + 0x016c);
		writel(0x000a0005, DDR2_DDR3_V4_BASE + 0x0170);
		writel(0x1046f000, DDR2_DDR3_V4_BASE + 0x0174);
		writel(0x28b0f105, DDR2_DDR3_V4_BASE + 0x0178);
		writel(0x08060404, DDR2_DDR3_V4_BASE + 0x017c);
		//writel(0x5C000800, DDR2_DDR3_V4_BASE + 0x0180);
		writel(0x05400A28, DDR2_DDR3_V4_BASE + 0x0184);
#ifdef CONFIG_DDR_WINBOND_SAMSUNG		
		// Below is for Winbond and Samsung Device
#ifdef CONFIG_DDR_32BIT
		writel(readl(DDR2_DDR3_V4_BASE + 0x01C8) | (0xFF<<8), DDR2_DDR3_V4_BASE + 0x01C8);
#endif
#ifdef CONFIG_DDR_16BIT
		writel(readl(DDR2_DDR3_V4_BASE + 0x01C8) | (0xFF<<8) | 0x04000000, DDR2_DDR3_V4_BASE + 0x01C8);
#endif
#endif
#ifdef CONFIG_DDR_MICRON
		// Below is for Micron Device
#ifdef CONFIG_DDR_32BIT
		writel(readl(DDR2_DDR3_V4_BASE + 0x01C8) | (0x1<<8), DDR2_DDR3_V4_BASE + 0x01C8);
#endif		
#ifdef CONFIG_DDR_16BIT
		writel(readl(DDR2_DDR3_V4_BASE + 0x01C8) | (0x1<<8) | 0x04000000, DDR2_DDR3_V4_BASE + 0x01C8);
#endif
#endif		
		writel(readl(DDR2_DDR3_V4_BASE + 0x0170) | (0x1<<9), DDR2_DDR3_V4_BASE + 0x0170);
		writel((readl(DDR2_DDR3_V4_BASE + 0x0174) & 0xfffff000) | (0x1<<8), DDR2_DDR3_V4_BASE + 0x0174);
		writel(0xff215a60, DDR2_DDR3_V4_BASE + 0x0194);

		// settings for controller
		writel(0x00258000, DDR2_DDR3_V4_BASE + 0x004);
		writel(0x08080924, DDR2_DDR3_V4_BASE + 0x008);
		writel(0x000C8124, DDR2_DDR3_V4_BASE + 0x00C);
		writel(0x02030305, DDR2_DDR3_V4_BASE + 0x010);
		writel(0x0305310f, DDR2_DDR3_V4_BASE + 0x014);
		writel(0x05050c05, DDR2_DDR3_V4_BASE + 0x018);
		writel(0x40040005, DDR2_DDR3_V4_BASE + 0x01C);
		writel(0x01000034, DDR2_DDR3_V4_BASE + 0x020);
		writel(0x00030602, DDR2_DDR3_V4_BASE + 0x024);
		writel(0x00000410, DDR2_DDR3_V4_BASE + 0x028);
		writel(0x1b500042, DDR2_DDR3_V4_BASE + 0x02C);
		writel(0x01000404, DDR2_DDR3_V4_BASE + 0x030);
		writel(0x02080334, DDR2_DDR3_V4_BASE + 0x034);
		writel(0x00060b08, DDR2_DDR3_V4_BASE + 0x038);
		//writel(0x00000000, DDR2_DDR3_V4_BASE + 0x03C);
		//writel(0x00000000, DDR2_DDR3_V4_BASE + 0x04C);
		//writel(0x00000000, DDR2_DDR3_V4_BASE + 0x058);
#endif		
		// start initialization
		writel(readl(DDR2_DDR3_V4_BASE + 0x000) | 0x81, DDR2_DDR3_V4_BASE + 0x000);
		writel(readl(SYS_V20_BASE + 0x104) & (~0x2), SYS_V20_BASE + 0x104); //Clear the MI Reset

		// Polling initial done status
		while ((readl(DDR2_DDR3_V4_BASE + 0x06c) & 0xC0000000) != 0xC0000000)
			;
		
		//Calibration result, gate training, read/write eys result check 
		while((readl(DDR2_DDR3_V4_BASE + 0x400) & (0x1<<27)) != (0x1<<27))
			;
		//Below is just to record the training count for reference at Proxy->MB1, may be deleted if no need.
		if (retry > readl(0xfd040008))
			writel(retry, 0xfd040008);

		//Write leveling result checking failed
		if (readl(DDR2_DDR3_V4_BASE + 0x438) == 0xffffffff)
			continue;
			
		//Gate train window checking failed
		if ((((readl(DDR2_DDR3_V4_BASE + 0x450) >> 0) & 0xffff) <= 0x100)
			|| (((readl(DDR2_DDR3_V4_BASE + 0x450) >> 16) & 0xffff) <= 0x100)
			|| (((readl(DDR2_DDR3_V4_BASE + 0x454) >> 0) & 0xffff) <= 0x100)
			|| (((readl(DDR2_DDR3_V4_BASE + 0x454) >> 16) & 0xffff) <= 0x100)
			)
			continue;

		//Read eye window checking failed
		if (((readl(DDR2_DDR3_V4_BASE + 0x468) & 0xff) < 0x80)
			|| (((readl(DDR2_DDR3_V4_BASE + 0x468) >> 8) & 0xff) < 0x80)
			|| (((readl(DDR2_DDR3_V4_BASE + 0x468) >> 16) & 0xff) < 0x80)
			|| (((readl(DDR2_DDR3_V4_BASE + 0x468) >> 24) & 0xff) < 0x80)
			)
			continue;

		//Write eye window checking failed
		if (((readl(DDR2_DDR3_V4_BASE + 0x47c) & 0xff) < 0x80)
			|| (((readl(DDR2_DDR3_V4_BASE + 0x47c) >> 8) & 0xff) < 0x80)
			|| (((readl(DDR2_DDR3_V4_BASE + 0x47c) >> 16) & 0xff) < 0x80)
			|| (((readl(DDR2_DDR3_V4_BASE + 0x47c) >> 24) & 0xff) < 0x80)
			)
			continue;

		//when training is Passed within 20 times, break the training loop to to continue the boot up.
		break;
	} while (retry <= 20);
#else
#if defined CONFIG_DDR3_ENABLE

	// PHY config
	writel(0x00000803, DDR2_DDR3_V4_BASE + 0x104);  // DENALI_CTL_00_DATA 32'b00000000_00000000_00000000_00000000
	writel(0x00080404, DDR2_DDR3_V4_BASE + 0x10c);  // DENALI_CTL_01_DATA 32'b00000000_00000000_00000001_00000001
	writel(0x20000000, DDR2_DDR3_V4_BASE + 0x110);  // DENALI_CTL_02_DATA 32'b00000000_00000000_00000000_00000001
	writel(0x00000020, DDR2_DDR3_V4_BASE + 0x114);  // DENALI_CTL_03_DATA 32'b00000001_00000000_00000001_00000001
	writel(0x86000000, DDR2_DDR3_V4_BASE + 0x140);  // DENALI_CTL_04_DATA 32'b00000000_00000000_00000000_00000000
	writel(0x00008600, DDR2_DDR3_V4_BASE + 0x144);  // DENALI_CTL_04_DATA 32'b00000000_00000000_00000000_00000000
	writel(0x80000000, DDR2_DDR3_V4_BASE + 0x148);  // DENALI_CTL_05_DATA 32'b00000000_00000000_00000000_00000001
	writel(0x80808080, DDR2_DDR3_V4_BASE + 0x14c);  // DENALI_CTL_06_DATA 32'b00000000_00000000_00000000_00000000
	writel(0x80808080, DDR2_DDR3_V4_BASE + 0x150);  // DENALI_CTL_07_DATA 32'b00000000_00000000_00000000_00000000

	// controller config
	writel(0x00258000, DDR2_DDR3_V4_BASE + 0x004);  // DENALI_CTL_08_DATA 32'b00000000_00000000_00000000_00000000
	writel(0x08080a28, DDR2_DDR3_V4_BASE + 0x008);  // DENALI_CTL_09_DATA 32'b00000000_00000000_00000000_00000000
	writel(0x000c8100, DDR2_DDR3_V4_BASE + 0x00c);  // DENALI_CTL_11_DATA 32'b00000001_00000000_00000000_00000000
	writel(0x02030305, DDR2_DDR3_V4_BASE + 0x010);  // DENALI_CTL_12_DATA 32'b00000000_00000000_00000000_00000001
	writel(0x0303360f, DDR2_DDR3_V4_BASE + 0x014);  // DENALI_CTL_13_DATA 32'b00000001_00000000_00000000_00000000
	writel(0x05050c05, DDR2_DDR3_V4_BASE + 0x018);  // DENALI_CTL_14_DATA 32'b00000011_00000000_00000000_00000000
	writel(0x00030003, DDR2_DDR3_V4_BASE + 0x01c);  // DENALI_CTL_15_DATA 32'b00000001_00000010_00000000_00000000
	writel(0x01000039, DDR2_DDR3_V4_BASE + 0x020);  // DENALI_CTL_16_DATA 32'b00000010_00000000_00000010_00000001
	writel(0x00030602, DDR2_DDR3_V4_BASE + 0x024);  // DENALI_CTL_17_DATA 32'b00000000_00000010_00000010_00000000
	writel(0x00000008, DDR2_DDR3_V4_BASE + 0x028);  // DENALI_CTL_18_DATA 32'b00000010_00000000_00000000_00000011
	writel(0x04200007, DDR2_DDR3_V4_BASE + 0x02c);  // DENALI_CTL_19_DATA 32'b00000010_00000010_00000010_00000000

	writel(0x01000404, DDR2_DDR3_V4_BASE + 0x030);  // DENALI_CTL_17_DATA 32'b00000000_00000010_00000010_00000000
	writel(0x02080239, DDR2_DDR3_V4_BASE + 0x034);  // DENALI_CTL_18_DATA 32'b00000010_00000000_00000000_00000011
	writel(0x00060b08, DDR2_DDR3_V4_BASE + 0x038);  // DENALI_CTL_19_DATA 32'b00000010_00000010_00000010_00000000

	// start initialization
	writel(readl(DDR2_DDR3_V4_BASE + 0x000) | 1, DDR2_DDR3_V4_BASE + 0x000);


	// wait for init complete
	while ((readl(DDR2_DDR3_V4_BASE + 0x06c) & 0xc0000000) != 0xc0000000)
		;

#elif defined CONFIG_DDR2_ENABLE
	/*clear start refresh bit*/
	writel(0x00000001, 0xfe540028);  /*DENALI_CTL_10_DATA 32'b00000000_00000000_00000000_00000001 */

	/*config ddr2 register*/
	writel(0x00000101, 0xfe540004);  /*DENALI_CTL_01_DATA 32'b00000000_00000000_00000001_00000001*/
	writel(0x00010001, 0xfe540008);  /*DENALI_CTL_02_DATA 32'b00000000_00000000_00000000_00000001*/
	writel(0x01010101, 0xfe54000c);  /*DENALI_CTL_03_DATA 32'b00000001_00000000_00000001_00000001*/
	writel(0x00000001, 0xfe540014);  /*DENALI_CTL_05_DATA 32'b00000000_00000000_00000000_00000001*/
	writel(0x00000001, 0xfe540028);  /*DENALI_CTL_10_DATA 32'b00000000_00000000_00000000_00000001*/
	writel(0x01000000, 0xfe54002c);  /*DENALI_CTL_11_DATA 32'b00000001_00000000_00000000_00000000*/
	writel(0x00000001, 0xfe540030);  /*DENALI_CTL_12_DATA 32'b00000000_00000000_00000000_00000001*/
	writel(0x01000000, 0xfe540034);  /*DENALI_CTL_13_DATA 32'b00000001_00000000_00000000_00000000*/
	writel(0x03000000, 0xfe540038);  /*DENALI_CTL_14_DATA 32'b00000011_00000000_00000000_00000000*/
	writel(0x01020200, 0xfe54003c);  /*DENALI_CTL_15_DATA 32'b00000001_00000010_00000000_00000000*/
	writel(0x02000201, 0xfe540040);  /*DENALI_CTL_16_DATA 32'b00000010_00000000_00000010_00000001*/
	writel(0x00020200, 0xfe540044);  /*DENALI_CTL_17_DATA 32'b00000000_00000010_00000010_00000000*/
	writel(0x02000003, 0xfe540048);  /*DENALI_CTL_18_DATA 32'b00000010_00000000_00000000_00000011*/
	writel(0x02040400, 0xfe54004c);  /*DENALI_CTL_19_DATA 32'b00000010_00000010_00000010_00000000*/
	writel(0x01020103, 0xfe540050);  /*DENALI_CTL_20_DATA 32'b00000001_00000010_00000001_00000011*/
	writel(0x00000100, 0xfe540054);  /*DENALI_CTL_21_DATA 32'b00000000_00000000_00000001_00000000*/
	writel(0x030c0a02, 0xfe540058);  /*DENALI_CTL_22_DATA 32'b00000100_00001100_00001010_00000010*/
	writel(0x0f0d0204, 0xfe54005c);  /*DENALI_CTL_23_DATA 32'b00000000_00000000_00000010_00000100*/
	writel(0x01040204, 0xfe540060);  /*DENALI_CTL_24_DATA 32'b00000000_00000000_00000010_00000100*/
	writel(0x02020202, 0xfe540064);  /*DENALI_CTL_25_DATA 32'b00000010_00000010_00000010_00000010*/
	writel(0x08000203, 0xfe540068);  /*DENALI_CTL_26_DATA 32'b00001000_00000000_00000010_00000011*/
	writel(0x04000007, 0xfe54006c);  /*DENALI_CTL_27_DATA 32'b00000100_00000000_00000000_00000111*/
	writel(0x06040302, 0xfe540070);  /*DENALI_CTL_28_DATA 32'b00000110_00000100_00000011_00000010*/
	writel(0x06020203, 0xfe540074);  /*DENALI_CTL_29_DATA 32'b00000110_00000010_00000010_00000000*/
	writel(0x07000000, 0xfe540078);  /*DENALI_CTL_30_DATA 32'b00000111_00000000_00000000_00000000*/
	writel(0x00002819, 0xfe54007c);  /*DENALI_CTL_31_DATA 32'b00000000_00000000_00101000_00011001*/
	writel(0x00000001, 0xfe540080);  /*DENALI_CTL_32_DATA 32'b00000000_00000000_00000000_00000000*/
	writel(0x00000001, 0xfe540084);  /*DENALI_CTL_33_DATA 32'b00000000_00000000_00000000_01000000*/
	writel(0x07030300, 0xfe540088);  /*DENALI_CTL_34_DATA 32'b00000111_00000011_00000011_00000000*/
	writel(0x0703030c, 0xfe54008c);  /*DENALI_CTL_35_DATA 32'b00000111_00000011_00000011_00001100*/
	writel(0x02050204, 0xfe540090);  /*DENALI_CTL_36_DATA 32'b00000010_00000101_00000010_00000100*/
	writel(0x0000000e, 0xfe540094);  /*DENALI_CTL_37_DATA 32'b00000000_00000000_00000000_00001110*/
	writel(0x000a000f, 0xfe540098);  /*DENALI_CTL_38_DATA 32'b00000000_00001010_00000000_00001111*/
	writel(0x00400100, 0xfe54009c);  /*DENALI_CTL_39_DATA 32'b00000000_01000000_00000001_00000000*/
	writel(0x00000200, 0xfe5400a0);  /*DENALI_CTL_40_DATA 32'b00000000_00000000_00000010_00000000*/
	writel(0x24040000, 0xfe5400a4);  /*DENALI_CTL_41_DATA 32'b00000000_00000000_00000000_00000000*/
	writel(0x03c803c8, 0xfe5400a8);  /*DENALI_CTL_42_DATA 32'b00000011_11001000_00000011_11001000*/
	writel(0x03c803c8, 0xfe5400ac);  /*DENALI_CTL_43_DATA 32'b00000011_11001000_00000011_11001000*/
	writel(0x03c803c8, 0xfe5400b0);  /*DENALI_CTL_44_DATA 32'b00000011_11001000_00000011_11001000*/
	writel(0x023203c8, 0xfe5400b4);  /*DENALI_CTL_45_DATA 32'b00000010_01000010_00000011_11001000*/
	writel(0x00000242, 0xfe5400b8);  /*DENALI_CTL_46_DATA 32'b00000000_00000001_00000010_01000010*/
	writel(0x00000004, 0xfe5400bc);  /*DENALI_CTL_47_DATA 32'b00000000_00000000_00000000_00000100*/
	writel(0x80000000, 0xfe5400c4);  /*DENALI_CTL_49_DATA 32'b10000000_00000000_00000000_00000000*/
	writel(0x1e1e0000, 0xfe5400d0);  /*DENALI_CTL_52_DATA 32'b00011110_00011110_00000000_00000000*/
	writel(0x1e1e1e1e, 0xfe5400d4);  /*DENALI_CTL_53_DATA 32'b00011110_00011110_00011110_00011110*/
	writel(0x00001e1e, 0xfe5400d8);  /*DENALI_CTL_54_DATA 32'b00000000_00000000_00011110_00011110*/
	writel(0x00100000, 0xfe5400e8);  /*DENALI_CTL_58_DATA 32'b00000000_00010000_00000000_00000000*/
	writel(0xffff0000, 0xfe5400ec);  /*DENALI_CTL_59_DATA 32'b11111111_11111111_00000000_00000000*/
	writel(0x1e1e1e1e, 0xfe5400f0);  /*DENALI_CTL_60_DATA 32'b00000000_00000000_00000000_00000000*/
	writel(0x1e1e1e1e, 0xfe5400f4);  /*DENALI_CTL_61_DATA 32'b00000000_00000000_00000000_00000000*/
	writel(0x00320000, 0xfe540100);  /*DENALI_CTL_64_DATA 32'b00000000_00110010_00000000_00000000*/
	writel(0x000200c8, 0xfe540104);  /*DENALI_CTL_65_DATA 32'b00000000_00000010_00000000_11001000*/
	writel(0x000a2224, 0xfe540108);  /*DENALI_CTL_66_DATA 32'b00000000_00001010_00100010_00100100*/
	writel(0x00c8000f, 0xfe54010c);  /*DENALI_CTL_67_DATA 32'b00000000_11001000_00000000_00001111*/
	writel(0x000061a8, 0xfe540120);  /*DENALI_CTL_72_DATA 32'b00000000_00000000_01100001_10101000*/
	writel(0x0000003f, 0xfe540124);  /*DENALI_CTL_73_DATA 32'b00000000_00000000_00000000_00111111*/
	writel(0x00048f36, 0xfe54012c);  /*DENALI_CTL_75_DATA 32'b00000000_00000100_10001111_00110110*/
	writel(0x00048f36, 0xfe540130);  /*DENALI_CTL_76_DATA 32'b00000000_00000100_10001111_00110110*/
	writel(0x00048f36, 0xfe540134);  /*DENALI_CTL_77_DATA 32'b00000000_00000100_10001111_00110110*/
	writel(0x00048f36, 0xfe540138);  /*DENALI_CTL_78_DATA 32'b00000000_00000100_10001111_00110110*/
	writel(0x00048f8e, 0xfe54013c);  /*DENALI_CTL_79_DATA 32'b00000000_00000100_10001111_10001110*/
	writel(0x00048f8e, 0xfe540140);  /*DENALI_CTL_80_DATA 32'b00000000_00000100_10001111_10001110*/
	writel(0x00048f8e, 0xfe540144);  /*DENALI_CTL_81_DATA 32'b00000000_00000100_10001111_10001110*/
	writel(0x00048f8e, 0xfe540148);  /*DENALI_CTL_82_DATA 32'b00000000_00000100_10001111_10001110*/
	writel(0x000f1133, 0xfe54015c);  /*DENALI_CTL_87_DATA 32'b00000000_00001111_00010001_00110011*/
	writel(0xf3003926, 0xfe540160);  /*DENALI_CTL_88_DATA 32'b11110011_00000000_00111001_00100110*/
	writel(0xf3003926, 0xfe540164);  /*DENALI_CTL_89_DATA 32'b11110011_00000000_00111001_00100110*/
	writel(0xf3003926, 0xfe540168);  /*DENALI_CTL_90_DATA 32'b11110011_00000000_00111001_00100110*/
	writel(0xf3003926, 0xfe54016c);  /*DENALI_CTL_91_DATA 32'b11110011_00000000_00111001_00100110*/
	writel(0x26c00300, 0xfe540170);  /*DENALI_CTL_92_DATA 32'b00100110_11000000_00000011_00000000*/
	writel(0x26c00300, 0xfe540174);  /*DENALI_CTL_93_DATA 32'b00100110_11000000_00000011_00000000*/
	writel(0x26c00300, 0xfe540178);  /*DENALI_CTL_94_DATA 32'b00100110_11000000_00000011_00000000*/
	writel(0x26c00300, 0xfe54017c);  /*DENALI_CTL_95_DATA 32'b00100110_11000000_00000011_00000000*/
	writel(0x00000004, 0xfe540180);  /*DENALI_CTL_96_DATA 32'b00000000_00000000_00000000_00000100*/
	writel(0x000003c8, 0xfe54019c);  /*DENALI_CTL_103_DATA 32'b00000000_00000000_00000011_11001000*/
	writel(0x000003c8, 0xfe5401a0);  /*DENALI_CTL_104_DATA 32'b00000000_00000000_00000011_11001000*/
	writel(0x000003c8, 0xfe5401a8);  /*DENALI_CTL_106_DATA 32'b00000000_00000000_00000011_11001000*/
	writel(0x00000019, 0xfe5401ac);  /*DENALI_CTL_107_DATA 32'b00000000_00000000_00000000_00011001*/

	/*start refresh*/
	writel(0x00010001, 0xfe540028); /*DENALI_CTL_10_DATA 32'b00000000_00000001_00000000_00000001 */

	/*wait for init complete*/
	while ((readl(0xfe5400a4)&0x40000) != 0)
		;

#endif
#endif
}
