/*
 * pre-boot code
 *
 * Copyright (C) 2009-2012 Pixelworks
 */

#include <config.h>
#include <linux/linkage.h>
#include <mach/itcm_config.h>

#define LOW_POWER_MODE

#define ITCM_REMAP_ADDR 0x20010000
#define ITCM_REMAP_STARTCODE_ADDR   (ITCM_REMAP_ADDR+0x800)

#if defined(CONFIG_ARCH_PIXELWORKS_TOPAZEH) || defined(CONFIG_ARCH_PIXELWORKS_TOPAZ_PRIME)
#include <mach/sysv20.h>
#define PXLW_STATIC_REGS_V1_BASE	0xfd020000
#else
#error unknow platform
#endif

/*magic number for low power*/
#define REBT    0x52454254
#define LOWP    0x4c4f5750

.section .pre_boot.0

ENTRY(_start)
	b	1f	// reset
	// avoid putting code at JTAG debugger vector breakpoints:
	nop		// undefined instruction
	nop		// svc
	nop		// prefetch abort
	nop		// data abort
#ifdef LOW_POWER_MODE
	.word		PBL_IMG_SIZE	// reserved vector, used for LP image offset
#else
	nop
#endif
	nop		// irq
	nop		// fiq

	// initialize stack and frame pointer early to avoid
	// JTAG debugger Register view causing invalid memory access
1:	mov	sp, #0
	mov	fp, #0

#if 0
	// FIXME: reset break workaround: delay ~10sec
	mov	r0, #0x1000000
2:	subs	r0, #1
	bne	2b
#endif

	// make SYS registers accessible (via ARM1176 peripheral port)
	// (remap 32MB at 0xfd000000)
	ldr	r0, =0xfd000010
	mcr	p15, 0, r0, c15, c2, 4

	// check if remap already done (i.e. not power-on)
	ldr	r0, =MISC_CTRL
	ldr	r0, [r0]
	ands	r0, #(1 << 0)
	bne	1f

#ifdef LOW_POWER_MODE
	// clear CR XP bit (extended page tables, used by Linux
	mrc	p15, 0, r0, c1, c0, 0
	bic	r0, #(1 << 23)
	mcr	p15, 0, r0, c1, c0, 0

	// check if code is running in ITCM, then we're called
	// from Linux for mode 1 -> mode 6 low power transition
	ldr	r0, =_pre_boot_itcm_addr
	cmp	pc, r0
	// setup stack in DTCM
	ldrge	sp, =_pre_boot_stack_init
	bge	10f
#endif

	// we're running from RAM loaded by JTAG
	bl	init_sys
	// skip low level init
	ldr	r0, =start
	mov	pc, r0

1:
	// enable ITCM bank0
	ldr	r0, =_pre_boot_itcm_addr
	orr	r0, #1
	mcr	p15, 0, r0, c9, c1, 1

	// enable ITCM bank1, place it right after bank0
	add	r0, #0x2000
	mov	r1, #1
	mcr	p15, 0, r1, c9, c2, 0
	mcr	p15, 0, r0, c9, c1, 1
	mov	r1, #0
	mcr	p15, 0, r1, c9, c2, 0

	// enable DTCM bank0
	ldr	r0, =_pre_boot_dtcm_addr
	orr	r0, #1
	mcr	p15, 0, r0, c9, c1, 0

	// enable DTCM bank1, place it right after bank0
	add	r0, #0x2000
	mov	r1, #1
	mcr	p15, 0, r1, c9, c2, 0
	mcr	p15, 0, r0, c9, c1, 0
	mov	r1, #0
	mcr	p15, 0, r1, c9, c2, 0

	// setup stack in DTCM
	ldr	sp, =_pre_boot_stack_init

	// copy code to ITCM for remap
	ldr	r0, =0
	ldr	r1, =_pre_boot_len
	ldr	r2, =_pre_boot_itcm_addr
1:
	ldr	r3, [r0], #4
	str	r3, [r2], #4
	cmp	r0, r1
	bne	1b

	// jump to ITCM
	ldr	r0, =_itcm_init_sys
	blx	r0

	ldr	r0, =_itcm_remap_start
	mov	pc, r0
ENDPROC(_start)

ENTRY(remap_start)
	ldr	r1, =MISC_CTRL
	ldr	r2, [r1]
	and	r2, r2,#~(3 << 0)	//remap, and clear INTSYNCEN to enables the synchronizer
	str	r2, [r1]
	nop
	nop
	nop
	nop
	nop

#ifdef LOW_POWER_MODE
	ldr	r1, =PXLW_STATIC_REGS_V1_BASE
	ldr	r0, [r1]
	ldr	r1, =LOWP
	cmp	r0, r1
	bne	normal_bootup
	nop
	nop
#endif

enter_low_power_mode:
#ifdef LOW_POWER_MODE
	// test if booting from SPI or eMMC
	ldr	r0, =BOOTSTRAP
	ldr	r1, [r0]
	ands	r1, #BOOTSTRAP_SPI
	bne	1f

	ldr	r0, =_itcm_spi_cp_itcm
	b	2f
1:
//	ldr	r0, =_itcm_emmc_cp_itcm
2:
	blx	r0

10:
	ldr	r0, =itcm_start
	blx	r0
#endif

normal_bootup:
	ldr	r0, =_itcm_ddr_init
	blx	r0

	// FIXME: test if booting from SPI or eMMC
	ldr	r0, =BOOTSTRAP
	ldr	r1, [r0]
	ands	r1, #BOOTSTRAP_SPI
	bne	1f

	ldr	r0, =_itcm_spi_cp
	b	2f
1:
//	ldr	r0, =_itcm_emmc_cp
2:
	blx	r0
	ldr	r0, =start	// bootloader start in RAM after copy
	mov	pc, r0
	.ltorg
ENDPROC(remap_start)
