/* -------------------------------------------------------------------------- *\
   itcm_serial_pl011.h - UART console control functions.
   Copyright (c) 2007,2008 Pixelworks Inc.
   Pixelworks owns the sole copyright to this software. Under international
   copyright laws you (1) may not make a copy of this software except for
   the purposes of maintaining a single archive copy, (2) may not derive
   works herefrom, (3) may not distribute this work to others. These rights
   are provided for information clarification, other restrictions of rights
   may apply as well.
   --------------------------------------------------------------------------
   This file is using to control UART function.
   Simple U-Boot driver for the PrimeCell PL011 UARTs on the IntegratorCP
   Should be fairly simple to make it work with the PL010 as well
\* -------------------------------------------------------------------------- */


#ifndef __ITCM_SERIAL_PL011_H__
#define __ITCM_SERIAL_PL011_H__

#define UART_PL01x_DR                   0x00	 /*  Data read or written from the interface. */
#define UART_PL01x_RSR                  0x04	 /*  Receive status register (Read). */
#define UART_PL01x_ECR                  0x04	 /*  Error clear register (Write). */
#define UART_PL01x_FR                   0x18	 /*  Flag register (Read only). */
#define UART_PL01x_IFLS                 0x34	 /*  Interrupt FIFO level select register. */

#define UART_PL01x_RSR_OE               0x08
#define UART_PL01x_RSR_BE               0x04
#define UART_PL01x_RSR_PE               0x02
#define UART_PL01x_RSR_FE               0x01

#define UART_PL01x_FR_TXFE              0x80
#define UART_PL01x_FR_RXFF              0x40
#define UART_PL01x_FR_TXFF              0x20
#define UART_PL01x_FR_RXFE              0x10
#define UART_PL01x_FR_BUSY              0x08
#define UART_PL01x_FR_TMSK              \
	(UART_PL01x_FR_TXFF + UART_PL01x_FR_BUSY)

/*
 *  PL010 definitions
 *
 */
#define UART_PL010_LCRH                 0x08	 /*  Line control register, high byte. */
#define UART_PL010_LCRM                 0x0C	 /*  Line control register, middle byte. */
#define UART_PL010_LCRL                 0x10	 /*  Line control register, low byte. */
#define UART_PL010_CR                   0x14	 /*  Control register. */
#define UART_PL010_IIR                  0x1C	 /*  Interrupt indentification register (Read). */
#define UART_PL010_ICR                  0x1C	 /*  Interrupt clear register (Write). */
#define UART_PL010_ILPR                 0x20	 /*  IrDA low power counter register. */

#define UART_PL010_CR_LPE               (1 << 7)
#define UART_PL010_CR_RTIE              (1 << 6)
#define UART_PL010_CR_TIE               (1 << 5)
#define UART_PL010_CR_RIE               (1 << 4)
#define UART_PL010_CR_MSIE              (1 << 3)
#define UART_PL010_CR_IIRLP             (1 << 2)
#define UART_PL010_CR_SIREN             (1 << 1)
#define UART_PL010_CR_UARTEN            (1 << 0)

#define UART_PL010_LCRH_WLEN_8          (3 << 5)
#define UART_PL010_LCRH_WLEN_7          (2 << 5)
#define UART_PL010_LCRH_WLEN_6          (1 << 5)
#define UART_PL010_LCRH_WLEN_5          (0 << 5)
#define UART_PL010_LCRH_FEN             (1 << 4)
#define UART_PL010_LCRH_STP2            (1 << 3)
#define UART_PL010_LCRH_EPS             (1 << 2)
#define UART_PL010_LCRH_PEN             (1 << 1)
#define UART_PL010_LCRH_BRK             (1 << 0)


#define UART_PL010_BAUD_460800            1
#define UART_PL010_BAUD_230400            3
#define UART_PL010_BAUD_115200            7
#define UART_PL010_BAUD_57600             15
#define UART_PL010_BAUD_38400             23
#define UART_PL010_BAUD_19200             47
#define UART_PL010_BAUD_14400             63
#define UART_PL010_BAUD_9600              95
#define UART_PL010_BAUD_4800              191
#define UART_PL010_BAUD_2400              383
#define UART_PL010_BAUD_1200              767
/*
 *  PL011 definitions
 *
 */
#define UART_PL011_IBRD                 0x24
#define UART_PL011_FBRD                 0x28
#define UART_PL011_LCRH                 0x2C
#define UART_PL011_CR                   0x30
#define UART_PL011_IMSC                 0x38
#define UART_PL011_PERIPH_ID0           0xFE0

#define UART_PL011_LCRH_SPS             (1 << 7)
#define UART_PL011_LCRH_WLEN_8          (3 << 5)
#define UART_PL011_LCRH_WLEN_7          (2 << 5)
#define UART_PL011_LCRH_WLEN_6          (1 << 5)
#define UART_PL011_LCRH_WLEN_5          (0 << 5)
#define UART_PL011_LCRH_FEN             (1 << 4)
#define UART_PL011_LCRH_STP2            (1 << 3)
#define UART_PL011_LCRH_EPS             (1 << 2)
#define UART_PL011_LCRH_PEN             (1 << 1)
#define UART_PL011_LCRH_BRK             (1 << 0)

#define UART_PL011_CR_CTSEN             (1 << 15)
#define UART_PL011_CR_RTSEN             (1 << 14)
#define UART_PL011_CR_OUT2              (1 << 13)
#define UART_PL011_CR_OUT1              (1 << 12)
#define UART_PL011_CR_RTS               (1 << 11)
#define UART_PL011_CR_DTR               (1 << 10)
#define UART_PL011_CR_RXE               (1 << 9)
#define UART_PL011_CR_TXE               (1 << 8)
#define UART_PL011_CR_LPE               (1 << 7)
#define UART_PL011_CR_IIRLP             (1 << 2)
#define UART_PL011_CR_SIREN             (1 << 1)
#define UART_PL011_CR_UARTEN            (1 << 0)

#define UART_PL011_IMSC_OEIM            (1 << 10)
#define UART_PL011_IMSC_BEIM            (1 << 9)
#define UART_PL011_IMSC_PEIM            (1 << 8)
#define UART_PL011_IMSC_FEIM            (1 << 7)
#define UART_PL011_IMSC_RTIM            (1 << 6)
#define UART_PL011_IMSC_TXIM            (1 << 5)
#define UART_PL011_IMSC_RXIM            (1 << 4)
#define UART_PL011_IMSC_DSRMIM          (1 << 3)
#define UART_PL011_IMSC_DCDMIM          (1 << 2)
#define UART_PL011_IMSC_CTSMIM          (1 << 1)
#define UART_PL011_IMSC_RIMIM           (1 << 0)


/* -------------------------------------------------------------------------- *\
Function Name : itcm_serial_init
Parameter : slowclk
Return : None
Description : This function is used to initial console UART port. The setting is
	      115200-N-8-1 & FIFO Disable, receive Interrupt enable
\* -------------------------------------------------------------------------- */
int itcm_serial_init(int slowclk);

/* -------------------------------------------------------------------------- *\
Function Name : itcm_serial_getc
Parameter : None
Return : Received Console port's Data
Description : This function is used to get console port's data.
\* -------------------------------------------------------------------------- */
int itcm_serial_getc(void);

/* -------------------------------------------------------------------------- *\
Function Name : itcm_serial_puts
Parameter : const char *s -- char strings that will be output by console UART.
Return : None
Description : This function is used to put data string to console UART port.
\* -------------------------------------------------------------------------- */
void itcm_serial_puts(char *s);

/* -------------------------------------------------------------------------- *\
Function Name : itcm_serial_putc
Parameter : const char c -- the data that will be output by console UART.
Return : None
Description : This function is used to put a data to console UART port.
\* -------------------------------------------------------------------------- */
void itcm_serial_putc(char c);

/* print 32bit value in hex */
void itcm_serial_puthex(unsigned int i);

/* get 32bit value in hex */
unsigned int itcm_serial_gethex(void);

/* -------------------------------------------------------------------------- *\
Function Name : itcm_pl011_serial_Reenable
Parameter : None
Return : 0 -- No Interrupt happen, 1-- Interrupt happen
Description : This function is used for re-enable UART's interrupt.
\* -------------------------------------------------------------------------- */
void itcm_pl011_serial_Reenable(int portnum);


#endif
