#ifndef __ITCM_POWER_H__
#define __ITCM_POWER_H__
/*#include "itcm_config.h"*/
#include <mach/sysv20.h>

#define PMUCTRL (_SYS_V20_BASE+0x00000400)
#define PMUCTRL2 (_SYS_V20_BASE+0x00000404)
#define MISCCTRL (_SYS_V20_BASE+0x00000300)
#define CLKSRCCTRL2 (_SYS_V20_BASE+0x000000018)
#define LVDSPADCTL1 (_SYS_V20_BASE+0x000000434)
#define SYS_PAD_DIRCTRL1 (_SYS_V20_BASE+0x00000056c)
#define SYS_PAD_DIRCTRL2 (_SYS_V20_BASE+0x000000570)

#define NORMAL      0
#define MI_READY    0x1
#define CLK_GATED   0x3
#define RESETED     0x2
#define PRE_ISOEN   0x6
#define POWERGATED  0x7

#define MASK_PMU_MIIDLEREQ  (1<<24)
#define MASK_PMU_CLKGATE    (1<<21)
#define MASK_PMU_IPRST      (1<<20)
#define MASK_PMU_ISOEN      (1<<22)
#define MASK_PMU_POWERGATE_EN   (1<<23)

/*
 * ENABLE_UART_LOWPOWER -- control uart setting in low power mode
 * 1 -- enable, the uart clock = XTAL/16, and baudrate is 9600
 * 0 -- disable, the uart clock = XTAL, and baudrate is 115200
 */
#define ENABLE_UART_LOWPOWER 0

/* -------------------------------------------------------------------------- *\
Function Name : itcm_power_onseq
Parameter : None
Return : None
Description : The function is used for control power on sequence.
\* -------------------------------------------------------------------------- */
void itcm_power_down_seq(void);

/* -------------------------------------------------------------------------- *\
Function Name : itcm_power_offseq
Parameter : None
Return : None
Description : The function is used for control power off sequence.
\* -------------------------------------------------------------------------- */
void itcm_power_on_seq(void);

#endif /*__ITCM_POWER_H__*/

