#ifndef __ITCM_IR_H__
#define __ITCM_IR_H__

#include <mach/sysmap.h>

#define CONFIG_RUBY_IRS    {(void *)IMAGE_PROC_V1_BASE}

#define RUBY_IR_PIR0IR_0_L	0x0
#define RUBY_IR_MASK_PIR0IR_0_L	0x0000ffff
#define RUBY_IR_SHIFT_PIR0IR_0_L	0x00000000

#define RUBY_IR_pir0ir_0_MODE	0x0
#define RUBY_IR_MASK_pir0ir_0_MODE	0x00070000
#define RUBY_IR_SHIFT_pir0ir_0_MODE	(16)

#define RUBY_IR_pir0ir_0_TIMEOUTWR	0x0
#define RUBY_IR_MASK_pir0ir_0_TIMEOUTWR	0x00080000
#define RUBY_IR_SHIFT_pir0ir_0_TIMEOUTWR	(19)

#define RUBY_IR_pir0ir_0_FILTERTIME	0x0
#define RUBY_IR_MASK_pir0ir_0_FILTERTIME	0xff000000
#define RUBY_IR_SHIFT_pir0ir_0_FILTERTIME	(24)

#define RUBY_IR_pir0ir_0_ROUND	0x0
#define RUBY_IR_MASK_pir0ir_0_ROUND	0x00f00000
#define RUBY_IR_SHIFT_pir0ir_0_ROUND	(20)

#define RUBY_IR_PIR0IR_1_L	0x4
#define RUBY_IR_MASK_PIR0IR_1_L	0x0000ffff
#define RUBY_IR_SHIFT_PIR0IR_1_L	(0)

#define RUBY_IR_PIR0IR_1_H	0x4
#define RUBY_IR_MASK_PIR0IR_1_H	0xffff0000
#define RUBY_IR_SHIFT_PIR0IR_1_H	(16)

#define RUBY_IR_pir0ir_2_PULSEINTEN	0x8
#define RUBY_IR_MASK_pir0ir_2_PULSEINTEN	0x00000200
#define RUBY_IR_SHIFT_pir0ir_2_PULSEINTEN	0x00000009

#define RUBY_IR_pir0ir_2_TIMEOUTINTEN	0x8
#define RUBY_IR_MASK_pir0ir_2_TIMEOUTINTEN	0x00000100
#define RUBY_IR_SHIFT_pir0ir_2_TIMEOUTINTEN	0x00000008

#define RUBY_IR_pir0ir_2_PULSEINTCNT	0x8
#define RUBY_IR_MASK_pir0ir_2_PULSEINTCNT	0x000000ff
#define RUBY_IR_SHIFT_pir0ir_2_PULSEINTCNT	0x00000000

#define RUBY_IR_pir0ir_2_SOFTRESET	0x8
#define RUBY_IR_MASK_pir0ir_2_SOFTRESET	0x00008000
#define RUBY_IR_SHIFT_pir0ir_2_SOFTRESET	0x0000000f

#define RUBY_IR_pir0ir_2_TIMEOUT	0x8
#define RUBY_IR_MASK_pir0ir_2_TIMEOUT	0x00200000
#define RUBY_IR_SHIFT_pir0ir_2_TIMEOUT	(21)

#define RUBY_IR_pir0ir_2_OVERFLOW	0x8
#define RUBY_IR_MASK_pir0ir_2_OVERFLOW	0x00400000
#define RUBY_IR_SHIFT_pir0ir_2_OVERFLOW	(22)

#define RUBY_IR_pir0ir_2_FIFODEPTH	0x8
#define RUBY_IR_MASK_pir0ir_2_FIFODEPTH	0x3f000000
#define RUBY_IR_SHIFT_pir0ir_2_FIFODEPTH	(24)

#define RUBY_IR_pir0ir_2_CLEARFIFO	0x8
#define RUBY_IR_MASK_pir0ir_2_CLEARFIFO	0x80000000
#define RUBY_IR_SHIFT_pir0ir_2_CLEARFIFO	(31)

#define RUBY_IR_pir0ir_2_IRFILTERBYPASS	0x2c
#define RUBY_IR_MASK_pir0ir_2_IRFILTERBYPASS	0xffff0000
#define RUBY_IR_SHIFT_pir0ir_2_IRFILTERBYPASS	(16)

#define RUBY_IR_pir0ir_2_FILTERDEPTH	0x2c
#define RUBY_IR_MASK_pir0ir_2_FILTERDEPTH	0x00007f00
#define RUBY_IR_SHIFT_pir0ir_2_FILTERDEPTH	(8)

#define RUBY_IR_pir0ir_2_FILTERNUM	0x2c
#define RUBY_IR_MASK_pir0ir_2_FILTERNUM	0x0000007c
#define RUBY_IR_SHIFT_pir0ir_2_FILTERNUM	(2)

#define RUBY_IR_pir0ir_2_LOWPOWER_IRFILTEEN	0x2c
#define RUBY_IR_MASK_pir0ir_2_LOWPOWER_IRFILTEEN	0x00000003
#define RUBY_IR_SHIFT_pir0ir_2_LOWPOWER_IRFILTEEN	(0)

#define RUBY_IR_pir0ir_2_IRFILTER	0xc


#define IR_MODE    2  /* EDGE TO EDGE TIME (Default for Eval remote)*/

#define IR_ROUND_MODE   0
#define IR_FILTER_TIME  0
/*IR receiver time base in microseconds*/
#define TIMEBASE_uS 50
/* IR pulse timeout. 3 mS of no data (during or after valid data) will
generate an interrupt.
*/
#define IR_PULSE_TIMEOUT        (15000L / TIMEBASE_uS)  /*15 mS*/
/*Number of pulses before an interrupt.*/
#define IR_INTERRUPT_THRESHOLD	12

/* Remote Customer identifier code (SRC-T2 Interlike Electronics)*/
#define FACTORY_ID	0x6a               /*PW TV PRD Remote*/
#define KEY_POWER	0x7D
#define KEY_MENU	0x7E
#define KEY_SOURCE	0x3F
#define KEY_UP	0x77
#define KEY_DOWN	0x7B
#define KEY_LEFT	0x5F
#define KEY_RIGHT	0x6F
#define KEY_PANEL_INC	0x67
#define KEY_PANEL_DEC	0x6B
#define LEADER_MAX   (5500 / TIMEBASE_uS)
#define LEADER_MIN   (4900 / TIMEBASE_uS)    /*Expecting 5200*/
#define BIT_0_MAX    (2700 / TIMEBASE_uS)
#define IR_HEADER_SIZE          2      /*Start pulse 2.6mS Low 2.6 mS High*/
#define IR_DATA_SIZE            32     /*Total bits not counting header*/
#define IR_BYTE_SIZE            16     /*Total bits per data byte*/


/*data bit time limits in microseconds*/
#define BIT_1_MIN     (3700 / TIMEBASE_uS)    /*Expecting 4000*/
#define BIT_1_MAX     (4300 / TIMEBASE_uS)

#if defined(__FPGA_BOARD__)
#define BIT_0_MIN    (1700 / TIMEBASE_uS)    /*Expecting 2400*/
#else
#define BIT_0_MIN    (2100 / TIMEBASE_uS)    /*Expecting 2400*/
#endif

#if defined(CONFIG_MACH_TOPAZEH_FPGA) || defined(CONFIG_MACH_VICTORIA_FPGA)
#define CLOCK_UCLK_HZ        30000000L
#else
#define CLOCK_UCLK_HZ        24000000L//43200000L   //MCLK is changed to 172.8MHz
#endif

#define IR_BUTTON_POWER   0xA3
#define MFG_CODE_CHECK 0x55
#define KEY_CODE_CHECK 0x33

/*MACRO to devide two numbers x/y and round up when the remainder is >= 0.5 */
#define ROUND(x, y)   (((x)+((y)>>1))/(y))

int itcm_ruby_ir_init(int portnum);

void itcm_IRIntReenable(int portnum);
void itcm_IRIntDisable(int portnum);

unsigned char itcm_IRCode(int portnum);

#endif

