
#include <linux/compiler.h>
#include <io.h>

#include "itcm_ir.h"
#include "itcm_serial_pl011.h"


static unsigned int itcm_ruby_ir[3];
#define NUM_PORTS (sizeof(itcm_ruby_ir)/sizeof(itcm_ruby_ir[0]))
#define ENABLE_IR_DBG_PRINT 0

int itcm_ruby_ir_init(int portnum)
{
	unsigned long data = 0;

	itcm_ruby_ir[0] = (unsigned int)(IR0_V3_BASE);
	itcm_ruby_ir[1] = (unsigned int)(IR1_V3_BASE);
	itcm_ruby_ir[2] = (unsigned int)(IR2_V3_BASE);

	/*update IR receiver timebase based on new UCLK value*/
	data = readl(itcm_ruby_ir[portnum] + RUBY_IR_PIR0IR_1_L);

	data &= ~RUBY_IR_MASK_PIR0IR_1_L;
	data |= (((unsigned short)ROUND(CLOCK_UCLK_HZ,
		ROUND(1000000L, TIMEBASE_uS))) << RUBY_IR_SHIFT_PIR0IR_1_L)
		& RUBY_IR_MASK_PIR0IR_1_L;
	writel(data, itcm_ruby_ir[portnum] + RUBY_IR_PIR0IR_1_L);

	data = readl(itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_2_PULSEINTEN);
	data &= ~RUBY_IR_MASK_pir0ir_2_PULSEINTEN;
	data |= ((0) << RUBY_IR_SHIFT_pir0ir_2_PULSEINTEN);
	writel(data, itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_2_PULSEINTEN);


	data = readl(itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_2_TIMEOUTINTEN);
	data &= ~RUBY_IR_MASK_pir0ir_2_TIMEOUTINTEN;
	data |= ((0) << RUBY_IR_SHIFT_pir0ir_2_TIMEOUTINTEN);
	writel(data, itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_2_TIMEOUTINTEN);

	data = readl(itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_0_MODE);
	data &= ~RUBY_IR_MASK_pir0ir_0_MODE;
	data |= ((IR_MODE) << RUBY_IR_SHIFT_pir0ir_0_MODE);
	writel(data, itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_0_MODE);

	data = readl(itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_0_FILTERTIME);
	data &= ~RUBY_IR_MASK_pir0ir_0_FILTERTIME;
	data |= ((IR_FILTER_TIME) << RUBY_IR_SHIFT_pir0ir_0_FILTERTIME);
	writel(data, itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_0_FILTERTIME);

	data = readl(itcm_ruby_ir[portnum] + RUBY_IR_PIR0IR_1_H);
	data &= ~RUBY_IR_MASK_PIR0IR_1_H;
	data |= ((IR_PULSE_TIMEOUT) << RUBY_IR_SHIFT_PIR0IR_1_H)
		& RUBY_IR_MASK_PIR0IR_1_H;
	writel(data, itcm_ruby_ir[portnum] + RUBY_IR_PIR0IR_1_H);

	data = readl(itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_2_PULSEINTCNT);
	data &= ~RUBY_IR_MASK_pir0ir_2_PULSEINTCNT;
	data |= ((IR_INTERRUPT_THRESHOLD) << RUBY_IR_SHIFT_pir0ir_2_PULSEINTCNT)
		& RUBY_IR_MASK_pir0ir_2_PULSEINTCNT;
	writel(data, itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_2_PULSEINTCNT);

	data = readl(itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_0_ROUND);
	data &= ~RUBY_IR_MASK_pir0ir_0_ROUND;
	data |= ((IR_ROUND_MODE) << RUBY_IR_SHIFT_pir0ir_0_ROUND)
		& RUBY_IR_MASK_pir0ir_0_ROUND;
	writel(data, itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_0_ROUND);

	data = readl(itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_2_SOFTRESET);
	data &= ~RUBY_IR_MASK_pir0ir_2_SOFTRESET;
	data |= ((1) << RUBY_IR_SHIFT_pir0ir_2_SOFTRESET)
		& RUBY_IR_MASK_pir0ir_2_SOFTRESET;
	writel(data, itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_2_SOFTRESET);

	data = readl(itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_2_PULSEINTEN);
	data &= ~RUBY_IR_MASK_pir0ir_2_PULSEINTEN;
	data |= ((1) << RUBY_IR_SHIFT_pir0ir_2_PULSEINTEN)
		& RUBY_IR_MASK_pir0ir_2_PULSEINTEN;
	writel(data, itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_2_PULSEINTEN);

	return 0;
}

void itcm_IRIntReenable(int portnum)
{
	unsigned long data = 0;

	data = readl(itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_2_PULSEINTEN);
	data &= ~RUBY_IR_MASK_pir0ir_2_PULSEINTEN;
	data |= ((1) << RUBY_IR_SHIFT_pir0ir_2_PULSEINTEN)
		& RUBY_IR_MASK_pir0ir_2_PULSEINTEN;
	writel(data, itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_2_PULSEINTEN);

}

void itcm_IRIntDisable(int portnum)
{
	unsigned long data = 0;

	data = readl(itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_2_PULSEINTEN);
	data &= ~RUBY_IR_MASK_pir0ir_2_PULSEINTEN;
    writel(data, itcm_ruby_ir[portnum] + RUBY_IR_pir0ir_2_PULSEINTEN);

}

/*
The following funcion gets to  the same purpose with above one.
Actually, this one is based above one, and it's just using another
way (not using 'goto') to get the IR key.
*/
unsigned char itcm_IRCode(int portnum)
{
	unsigned long data = 0;
	unsigned long cNumPulses;
	unsigned long wCount = 0;
	unsigned long wPulsesValue = 0;
	unsigned char bLeaderFound = 0;
	unsigned char bKeyByte = 0;
	unsigned char cBit;
	unsigned long iIndex, iIndex1;
	unsigned long cIndex = 0;
	unsigned char bValidData = 1;
	unsigned char cGetpulses = 0;

	cNumPulses = readl(itcm_ruby_ir[0] + RUBY_IR_pir0ir_2_FIFODEPTH);
	cNumPulses = (cNumPulses & (RUBY_IR_MASK_pir0ir_2_FIFODEPTH))
		>> RUBY_IR_SHIFT_pir0ir_2_FIFODEPTH;
	if (cNumPulses < 3)
		bLeaderFound = 0;
	else {
		wCount = cNumPulses;
		data = readl(itcm_ruby_ir[0] + RUBY_IR_PIR0IR_0_L);
#if ENABLE_IR_DBG_PRINT
		itcm_serial_puthex(data);
		itcm_serial_putc('\n');
#endif
		data = (data & (RUBY_IR_MASK_PIR0IR_0_L)) >> RUBY_IR_SHIFT_PIR0IR_0_L;
		wCount--;
		if ((data & 0xFFFF) != 0xFFFF)
			wPulsesValue = data;

		for (iIndex = 0; iIndex < wCount; iIndex++) {
			data = readl(itcm_ruby_ir[0] + RUBY_IR_PIR0IR_0_L);
#if ENABLE_IR_DBG_PRINT
			itcm_serial_puthex(data);
			itcm_serial_putc('\n');
#endif
			data = (data & (RUBY_IR_MASK_PIR0IR_0_L))
				>> RUBY_IR_SHIFT_PIR0IR_0_L;
			wPulsesValue += data;
			if (wPulsesValue <= LEADER_MAX && wPulsesValue >= LEADER_MIN) {
				bLeaderFound = 1;
				break;
			} else
				bLeaderFound = 0;

			wPulsesValue = data;
		}
	}

	if (bLeaderFound) {
		for (iIndex1 = 0; iIndex1 < 2; iIndex1++) {
			wCount = 0xffff;
			while (wCount--) {
				cNumPulses = readl(itcm_ruby_ir[0]
					+ RUBY_IR_pir0ir_2_FIFODEPTH);
				cNumPulses = (cNumPulses & (RUBY_IR_MASK_pir0ir_2_FIFODEPTH))
					>> RUBY_IR_SHIFT_pir0ir_2_FIFODEPTH;
				if (cNumPulses >= 16) {
					cGetpulses = 1;
					break;
				} else
					cGetpulses = 0;
			}

			if (cGetpulses) {
				cBit = 1;
				wCount = 16;
				bKeyByte = 0;
				for (cIndex = 0; cIndex < wCount; cIndex += 2) {
					data = readl(itcm_ruby_ir[0] + RUBY_IR_PIR0IR_0_L);
#if ENABLE_IR_DBG_PRINT
					itcm_serial_puthex(data);
					itcm_serial_putc('\n');
#endif
					data = (data & (RUBY_IR_MASK_PIR0IR_0_L))
						>> RUBY_IR_SHIFT_PIR0IR_0_L;
					wPulsesValue = data;
					data = readl(itcm_ruby_ir[0] + RUBY_IR_PIR0IR_0_L);
#if ENABLE_IR_DBG_PRINT
					itcm_serial_puthex(data);
					itcm_serial_putc('\n');
#endif
					data = (data & (RUBY_IR_MASK_PIR0IR_0_L))
						>> RUBY_IR_SHIFT_PIR0IR_0_L;
					wPulsesValue  += data;

					if ((wPulsesValue <= BIT_0_MAX)
						&& (wPulsesValue >= BIT_0_MIN))
						cBit = 0;
					else if ((wPulsesValue <= BIT_1_MAX)
						&& (wPulsesValue >= BIT_1_MIN))
						cBit = 1;
					else {
						bValidData = 0;
						break;
					}
					bKeyByte += (cBit << (cIndex >> 1));
				}

			} else
				bKeyByte = 0;

			if ((0 == iIndex1) && (bKeyByte != FACTORY_ID))
				break;
		}

	}

	if ((!bValidData) || (!bLeaderFound))
		bKeyByte = 0;


	return bKeyByte;
}

