/* -------------------------------------------------------------------------- *\
   itcm_interrupt.h - interrupt setting control functions.
   Copyright (c) 2007,2008 Pixelworks Inc.
   Pixelworks owns the sole copyright to this software. Under international
   copyright laws you (1) may not make a copy of this software except for
   the purposes of maintaining a single archive copy, (2) may not derive
   works herefrom, (3) may not distribute this work to others. These rights
   are provided for information clarification, other restrictions of rights
   may apply as well.
   --------------------------------------------------------------------------
   This file is using to control VIC function.
\* -------------------------------------------------------------------------- */
#ifndef __ITCM_INTERRUPT_H__
#define __ITCM_INTERRUPT_H__

#include <mach/sysmap.h>


#define CONFIG_PL192_PORTS	{ (void *) VIC0_V2_BASE, (void *) VIC1_V2_BASE}

#define VIC_PL192_IRQSTATUS		0x000
#define VIC_PL192_FIQSTATUS		0x004
#define VIC_PL192_RAWINTR		0x008
#define VIC_PL192_INTSELECT		0x00C
#define VIC_PL192_INTENABLE		0x010
#define VIC_PL192_INTENCLEAR	0x014
#define VIC_PL192_SOFTINT		0x018
#define VIC_PL192_SOFTINTCLEAR	0x01C
#define VIC_PL192_PROTECTION	0x020
#define VIC_PL192_SWPRIORITY_MASK	0x024
#define VIC_PL192_PRIORITYDAISY	0x028
#define VIC_PL192_VECTADDR0		0x100
#define VIC_PL192_VECTADDR1		0x104
#define VIC_PL192_VECTADDR2		0x108
#define VIC_PL192_VECTADDR3		0x10C
#define VIC_PL192_VECTADDR4		0x110
#define VIC_PL192_VECTADDR5		0x114
#define VIC_PL192_VECTADDR6		0x118
#define VIC_PL192_VECTADDR7		0x11C
#define VIC_PL192_VECTADDR8		0x120
#define VIC_PL192_VECTADDR9		0x124
#define VIC_PL192_VECTADDR10	0x128
#define VIC_PL192_VECTADDR11	0x12C
#define VIC_PL192_VECTADDR12	0x130
#define VIC_PL192_VECTADDR13	0x134
#define VIC_PL192_VECTADDR14	0x138
#define VIC_PL192_VECTADDR15	0x13C
#define VIC_PL192_VECTADDR16	0x140
#define VIC_PL192_VECTADDR17	0x144
#define VIC_PL192_VECTADDR18	0x148
#define VIC_PL192_VECTADDR19	0x14C
#define VIC_PL192_VECTADDR20	0x150
#define VIC_PL192_VECTADDR21	0x154
#define VIC_PL192_VECTADDR22	0x158
#define VIC_PL192_VECTADDR23	0x15C
#define VIC_PL192_VECTADDR24	0x160
#define VIC_PL192_VECTADDR25	0x164
#define VIC_PL192_VECTADDR26	0x168
#define VIC_PL192_VECTADDR27	0x16C
#define VIC_PL192_VECTADDR28	0x170
#define VIC_PL192_VECTADDR29	0x174
#define VIC_PL192_VECTADDR30	0x178
#define VIC_PL192_VECTADDR31	0x17C
#define VIC_PL192_VECTPRIORITY0         0x200
#define VIC_PL192_VECTPRIORITY1         0x204
#define VIC_PL192_VECTPRIORITY2         0x208
#define VIC_PL192_VECTPRIORITY3         0x20C
#define VIC_PL192_VECTPRIORITY4         0x210
#define VIC_PL192_VECTPRIORITY5         0x214
#define VIC_PL192_VECTPRIORITY6         0x218
#define VIC_PL192_VECTPRIORITY7         0x21C
#define VIC_PL192_VECTPRIORITY8         0x220
#define VIC_PL192_VECTPRIORITY9         0x224
#define VIC_PL192_VECTPRIORITY10        0x228
#define VIC_PL192_VECTPRIORITY11        0x22C
#define VIC_PL192_VECTPRIORITY12        0x230
#define VIC_PL192_VECTPRIORITY13        0x234
#define VIC_PL192_VECTPRIORITY14        0x238
#define VIC_PL192_VECTPRIORITY15        0x23C
#define VIC_PL192_VECTPRIORITY16        0x240
#define VIC_PL192_VECTPRIORITY17        0x244
#define VIC_PL192_VECTPRIORITY18        0x248
#define VIC_PL192_VECTPRIORITY19        0x24C
#define VIC_PL192_VECTPRIORITY20        0x250
#define VIC_PL192_VECTPRIORITY21        0x254
#define VIC_PL192_VECTPRIORITY22        0x258
#define VIC_PL192_VECTPRIORITY23        0x25C
#define VIC_PL192_VECTPRIORITY24        0x260
#define VIC_PL192_VECTPRIORITY25        0x264
#define VIC_PL192_VECTPRIORITY26        0x268
#define VIC_PL192_VECTPRIORITY27        0x26C
#define VIC_PL192_VECTPRIORITY28        0x270
#define VIC_PL192_VECTPRIORITY29        0x274
#define VIC_PL192_VECTPRIORITY30        0x278
#define VIC_PL192_VECTPRIORITY31        0x27C
#define VIC_PL192_ADDRESS	        0xF00
#define VIC_PL192_PERIPHID0	        0xFE0
#define VIC_PL192_PERIPHID1	        0xFE4
#define VIC_PL192_PERIPHID2	        0xFE8
#define VIC_PL192_PERIPHID3	        0xFEC
#define VIC_PL192_PCELLID0	        0xFF0
#define VIC_PL192_PCELLID1	        0xFF4
#define VIC_PL192_PCELLID2	        0xFF8
#define VIC_PL192_PCELLID3	        0xFFC

#define VICINTSOURCE_TIM_0_INTC		(1<<0)
#define VICINTSOURCE_TIM_1_INTC		(1<<1)
#define VICINTSOURCE_GPIO_0_1		(1<<2)
#define VICINTSOURCE_WDOGINT		(1<<3)
#define VICINTSOURCE_UARTINTR_0		(1<<4)
#define VICINTSOURCE_IR0			(1<<10)
#define VICINTSOURCE_ETH_WAKEUP		(1<<15)

#define VIC1_INTSOURCE_UARTINTR_4		(1<<18)

/* return pending irqs */
void itcm_interrupt_pending(unsigned int *irqs0, unsigned int *irqs1);

/* ack pending irqs */
void itcm_interrupt_ack(unsigned int irqs0, unsigned int irqs1);

/* execute power-saving wait-for-interrupt instruction */
void itcm_wait_for_interrupt(void);

/* -------------------------------------------------------------------------- *\
Function Name : itcm_interrupt_init
Parameter : None
Return : None
Description :
Initialise each vectored interrupt handler address &
priority with the appropriate interrupt & enable bits,
e.g.

"<vic_base_address>.<VectAddrs>[X] = &interrupt;"
"<vic_base_address>.<VectCntl>[X]  = INT_VALUE;"

Where;
X          - Interrupt Priority (0-15)
&interrupt - Address of matching "interrupt" handler
INT_VALUE  - Interrupt & enable bits for "interrupt"

See vic.h for enable & interrupt value definitions.
\* -------------------------------------------------------------------------- */
void itcm_interrupt_init(void);
#endif
