#ifndef __ITCM_ETH_H__
#define __ITCM_ETH_H__

#include <mach/sysmap.h>


#define GMAC_CFG          0x00000000
#define GMAC_CFG_RE    (1<<2)
#define GMAC_CFG_TE    (1<<3)
#define GMAC_CFG_DM    (1<<11)    //DUPLEC_MODE
#define GMAC_CFG_FES   (1<<14)   //SPEED,  0: 10Mbps; 1: 100Mbps
#define GMAC_CFG_100M  (1<<15)   //Port Select: 0: GMII, 1:MII

#define RMOT_WU_FF        0x00000028

#define PMT_CTRL_STAT   0x0000002c
#define PMT_CTRL_STAT_UC      (1<<9)   //Wake up by any Unicast packet
#define PMT_CTRL_STAT_WUFR    (1<<6)   //Wake up Frame Received
#define PMT_CTRL_STAT_MPR     (1<<5)   //Magic Packet Received
#define PMT_CTRL_STAT_WUFE    (1<<2)   //Wake up frame enable
#define PMT_CTRL_STAT_MPE     (1<<1)   //Magic Power Enabled
#define PMT_CTRL_STAT_PD      (1<<0)   //Power Down


#define ETHERNET_INT_STATUS          0x00000038
#define INT_STATUS_PMT_IS   (1<<3)   //set whenever a Magic Packet or Wake-on-Lan frame is received in Power Down mode

#define ETHERNET_INT_MASK                0x0000003c
#define INT_MASK_PMT_IM  (1<<3)   //PMT Interrupt Mask 1: disable the assertion of the interrupt signal

#define GMAC_ADDR0_HIGH          0x00000040
#define GMAC_ADDR0_LOW          0x00000044

/* MII ADDR  defines */
#define GMAC_MII_ADDR      0x00000010
#define GMAC_MII_DATA      0x00000014
#define GMAC_MII_ADDR_WRITE        0x00000002  /* MII Write */
#define GMAC_MII_ADDR_BUSY         0x00000001  /* MII Busy */
#define GMAC_MII_ADDR_PHY_MASK     0x0000001f  /* MII PHY address mask */
#define GMAC_MII_ADDR_PHY_SHIFT    11          /* MII PHY address shift */
#define GMAC_MII_ADDR_REG_MASK     0x0000001f  /* MII register mask */
#define GMAC_MII_ADDR_REG_SHIFT    6           /* MII register shift */

#define ITCM_CONFIG_UNIMAC_MII_POLL_BUSY_DELAY  1000
void itcm_eth_init (void);
unsigned char itcm_EthernetEventGet(void);
void irq_ethernet_wakeup_vic(void);
void itcm_EthernetReenable(void);

/* phy register offsets */
#define PHY_BMCR		0x00
#define PHY_BMSR		0x01
#define PHY_PHYIDR1		0x02
#define PHY_PHYIDR2		0x03
#define PHY_ANAR		0x04
#define PHY_ANLPAR		0x05
#define PHY_ANER		0x06
#define PHY_ANNPTR		0x07
#define PHY_ANLPNP		0x08
#define PHY_1000BTCR		0x09
#define PHY_1000BTSR		0x0A
#define PHY_EXSR		0x0F
#define PHY_PHYSTS		0x10
#define PHY_MIPSCR		0x11
#define PHY_MIPGSR		0x12
#define PHY_DCR			0x13
#define PHY_FCSCR		0x14
#define PHY_RECR		0x15
#define PHY_PCSR		0x16
#define PHY_LBR			0x17
#define PHY_10BTSCR		0x18
#define PHY_PHYCTRL		0x19

/* PHY BMCR */
#define PHY_BMCR_RESET		0x8000
#define PHY_BMCR_LOOP		0x4000
#define PHY_BMCR_100MB		0x2000
#define PHY_BMCR_AUTON		0x1000
#define PHY_BMCR_POWD		0x0800
#define PHY_BMCR_ISO		0x0400
#define PHY_BMCR_RST_NEG	0x0200
#define PHY_BMCR_DPLX		0x0100
#define PHY_BMCR_COL_TST	0x0080

#define PHY_BMCR_SPEED_MASK	0x2040
#define PHY_BMCR_1000_MBPS	0x0040
#define PHY_BMCR_100_MBPS	0x2000
#define PHY_BMCR_10_MBPS	0x0000

/* phy BMSR */
#define PHY_BMSR_100T4		0x8000
#define PHY_BMSR_100TXF		0x4000
#define PHY_BMSR_100TXH		0x2000
#define PHY_BMSR_10TF		0x1000
#define PHY_BMSR_10TH		0x0800
#define PHY_BMSR_EXT_STAT	0x0100
#define PHY_BMSR_PRE_SUP	0x0040
#define PHY_BMSR_AUTN_COMP	0x0020
#define PHY_BMSR_RF		0x0010
#define PHY_BMSR_AUTN_ABLE	0x0008
#define PHY_BMSR_LS		0x0004
#define PHY_BMSR_JD		0x0002
#define PHY_BMSR_EXT		0x0001

unsigned int itcm_miiphy_link(void);
void itcm_miiphy_init(void);
void itcm_miiphy_reset(void);
void itcm_miiphy_RESETPin(void);
int itcm_setMacAdd (void);

unsigned char itcm_RemoteWakeReceived(void);
#endif
