/* -------------------------------------------------------------------------- *\
   itcm_gpio.c - Main system flow control.
   Copyright (c) 2007,2008 Pixelworks Inc.
   Pixelworks owns the sole copyright to this software. Under international
   copyright laws you (1) may not make a copy of this software except for
   the purposes of maintaining a single archive copy, (2) may not derive
   works herefrom, (3) may not distribute this work to others. These rights
   are provided for information clarification, other restrictions of rights
   may apply as well.
   --------------------------------------------------------------------------
   This file is using to control Ethernet function.
\* -------------------------------------------------------------------------- */
#include <common.h>

#include <config.h>
#include "itcm_ctype.h"
#include "itcm_eth.h"
#include "itcm_gpio.h"
#include "itcm_interrupts.h"
#include "itcm_serial_pl011.h"
#define IO_WRITE(addr, val) (*(volatile unsigned int *)(addr) = (val))
#define IO_READ(addr) (*(volatile unsigned int *)(addr))

static unsigned char *itcm_Ethernet[1] = { (void *)ETH_MAC_V4_BASE };
#define NUM_ETHERNET_PORTS (sizeof(itcm_Ethernet)/sizeof(itcm_Ethernet[0]))

// change PHY to 10M mode to save power
#define ETH_10M

// define spi address
#define CFG_FLASH_BASE 			0x80000000
#define CFG_ENV_OFFSET 			0x01fe0000
#define CFG_ENV_SIZE			0x00020000

// FIXME: clock dividser 4 and 5 work, but why?
#define GCONFIG_MAC_MII_CLK (4 << 2)

#if defined(CONFIG_RGMII_ENABLE)
#define PHY_ADDR 0x10
#else
#define PHY_ADDR 0x01
#endif

#define MII_READ(x) ((PHY_ADDR << GMAC_MII_ADDR_PHY_SHIFT) | (x << GMAC_MII_ADDR_REG_SHIFT) \
                    | GCONFIG_MAC_MII_CLK | GMAC_MII_ADDR_BUSY)
#define MII_WRITE(x) (MII_READ(x) | GMAC_MII_ADDR_WRITE)

static unsigned char EthernetEvent = 0;
static unsigned char ReceivedWakeup=0;

static unsigned long MAC_ADDRESS[6]={0x00, 0x08,0x18,0x00,0x37,0x04};


#define SYS_V20_CLKOFF          0x2c
#define SYS_V20_CLKDIVIDER      0x38
#define SYS_V20_CLKDIVIDER1     0x50
#define SYS_V20_CLKDIVIDER_EN   0x3c
#define SYS_V20_RGMIIMUXCTRL    0x5c
#define SYS_V20_RGMIIPLLCTRL    0x24


static unsigned short itcm_eth_phy_read(unsigned int reg)
{
    unsigned int data;
    int i;

    IO_WRITE(itcm_Ethernet[0] + GMAC_MII_ADDR, MII_READ(reg));
    for (i = 0; i < 100; i++) {
        if ((IO_READ(itcm_Ethernet[0] + GMAC_MII_ADDR) & 1) == 0) {
            data = IO_READ(itcm_Ethernet[0] + GMAC_MII_DATA);
            return data;
        }
    }
    itcm_serial_puts("itcm_eth_phy_read: timeout\n");
    return 0;
}

static void itcm_eth_phy_write(unsigned int reg, unsigned short val)
{
    int i;

    IO_WRITE(itcm_Ethernet[0] + GMAC_MII_DATA, val);
    IO_WRITE(itcm_Ethernet[0] + GMAC_MII_ADDR, MII_WRITE(reg));
    for (i = 0; i < 100; i++) {
        if ((IO_READ(itcm_Ethernet[0] + GMAC_MII_ADDR) & 1) == 0)
            return;
    }
    itcm_serial_puts("itcm_eth_phy_write: timeout\n");
}

static void itcm_eth_set_rgmii_clk(void)
{
    unsigned int data;

    // gate ETHMACCLK before changing RGMIIMUX
    data = IO_READ(SYS_V20_BASE + SYS_V20_CLKOFF);
    data |= 0x10000; // ETHMACCLKOFF
    IO_WRITE(SYS_V20_BASE + SYS_V20_CLKOFF, data);
    
#if defined(CONFIG_RGMII_ENABLE)
    data = IO_READ(SYS_V20_BASE + SYS_V20_CLKDIVIDER);
    data &= ~(0xff << 23);
    data |= 19 << 23;   // RGMII_CLKDIV_10M = 19
    IO_WRITE(SYS_V20_BASE + SYS_V20_CLKDIVIDER, data);
    
    data = IO_READ(SYS_V20_BASE + SYS_V20_CLKDIVIDER);
    data &= 0xff83ffff;
    data |= 1 << 18;   // RGMII_CLKDIV_100M = 1
    IO_WRITE(SYS_V20_BASE + SYS_V20_CLKDIVIDER, data);
    
    data = IO_READ(SYS_V20_BASE + SYS_V20_CLKDIVIDER_EN);
    data |= (3 << 3);   // RGMII_CLKDIV_10M_EN, 100M, 1G
    IO_WRITE(SYS_V20_BASE + SYS_V20_CLKDIVIDER_EN, data);
    

    //data = 0x73; // ETHCLKSRCSEL = 1, RGMIICLKTXMUXSEL, RGMIICLKRXMUXSEL,
                 // RGMIIPREDIVMUXSEL, RGMII_SWCONFIG_EN
    data = 0x7b;                 
#else
    data = 0x40; // ETHCLKSRCSEL = 1
#endif
    IO_WRITE(SYS_V20_BASE + SYS_V20_RGMIIMUXCTRL, data);

    /* power down RGMII PLL */
    data = IO_READ(SYS_V20_BASE + SYS_V20_RGMIIPLLCTRL);
    data |= (1 << 26) | (1 << 23) | 1;  // RGMIIPLL_RESET, RGMIIPLL_PROG, RGMIIPLL_BYPASS
    IO_WRITE(SYS_V20_BASE + SYS_V20_RGMIIPLLCTRL, data);

    data = IO_READ(SYS_V20_BASE + SYS_V20_CLKOFF);
    data &= ~0x10000; // ETHMACCLKOFF
#if defined(CONFIG_RGMII_ENABLE)
    data |= 0x1552; // CLKRMIIOFF, CLKRXON, CLKRX180ON, CLKTXON, CLKTX180ON, CLKTX_OUTON
#else
    data |= 0x1444; // CLKRMIION, CLKRXON, CLKTXON, CLKTX_OUTON
#endif
    IO_WRITE(SYS_V20_BASE + SYS_V20_CLKOFF, data);
}

/* -------------------------------------------------------------------------- *\
Function Name : itcm_eth_init
Parameter : None
Return : None
Description : The function is used for control power on sequence.
\* -------------------------------------------------------------------------- */
void itcm_eth_init (void)
{
    unsigned int data;

    itcm_serial_puts("itcm_eth_init\n");
    if (itcm_setMacAdd() < 0)
        return;

    itcm_eth_set_rgmii_clk();

    // check PHY addcess by reading its id
    itcm_serial_puts("PHY id: ");
    data = itcm_eth_phy_read(2);
    itcm_serial_puthex(data);
    itcm_serial_putc(':');
    data = itcm_eth_phy_read(3);
    itcm_serial_puthex(data);
    itcm_serial_putc('\n');
    // set PHY autonegotiation to desired speed
#ifdef ETH_10M
    // change auto negotiation to 10M FDX
    itcm_eth_phy_write(4, 0x0061);
#else
    // change auto negotiation to 100M FDX
    itcm_eth_phy_write(4, 0x01e1);
#endif
#if defined(CONFIG_RGMII_ENABLE)
    // disable 1G modes
    itcm_eth_phy_write(9, 0x0000);
#endif
    // soft reset + restart auto negotiation
    data = itcm_eth_phy_read(0);
    itcm_serial_puthex(data);
    itcm_serial_putc('\n');
    //itcm_eth_phy_write(0, data | 0x8200);
    itcm_eth_phy_write(0, data | 0x1200);
    itcm_serial_puts("itcm_eth_init PHY configured\n");

    // configure GMAC core
    data = IO_READ(itcm_Ethernet[0] + GMAC_CFG);
    data &= ~GMAC_CFG_TE; // disable tx
    data |= GMAC_CFG_DM | GMAC_CFG_FES | GMAC_CFG_100M | GMAC_CFG_RE; // 100m fdx
#ifdef ETH_10M
    data &= ~GMAC_CFG_FES; // 10M
#endif
    IO_WRITE(itcm_Ethernet[0] + GMAC_CFG, data);

    // enable wake-up by magic packet and power-down
    data = PMT_CTRL_STAT_PD | PMT_CTRL_STAT_MPE;
//    data |= PMT_CTRL_STAT_UC;  // wake-up by unicast, only for testing
    IO_WRITE(itcm_Ethernet[0] + PMT_CTRL_STAT, data);

    // disable all irq except PMT
    data = ~INT_MASK_PMT_IM;
    IO_WRITE(itcm_Ethernet[0] + ETHERNET_INT_MASK, data);

    itcm_serial_puts("itcm_eth_init complete\n");
}

//-----------------------------------------------------------------------------
//   wakeup interrupt function
//-----------------------------------------------------------------------------
void irq_ethernet_wakeup_vic(void)
{
    static volatile unsigned char *const itcm_pl192_int[] = CONFIG_PL192_PORTS;
    unsigned long data;

    EthernetEvent = 1;
    data = IO_READ(itcm_Ethernet[0]+ETHERNET_INT_STATUS);
    IO_READ(itcm_Ethernet[0]+PMT_CTRL_STAT);
    if((data&INT_STATUS_PMT_IS) !=0)
    {
        IO_WRITE(itcm_Ethernet[0]+PMT_CTRL_STAT, 0);
        data= IO_READ(itcm_Ethernet[0]+PMT_CTRL_STAT);  //read PMT control and Status register will clear PMT_IS
        ReceivedWakeup = 1;
    }
    IO_WRITE (itcm_pl192_int[0] + VIC_PL192_VECTADDR20, 0xff);
}

unsigned char itcm_EthernetEventGet(void)
{
    return EthernetEvent;
}

unsigned char itcm_RemoteWakeReceived(void)
{
#if 1
    unsigned long data;
    data = IO_READ(itcm_Ethernet[0] + PMT_CTRL_STAT);
    if (!(data & PMT_CTRL_STAT_PD))
    {
        itcm_serial_puts("wake up reason: ");
        if (data & PMT_CTRL_STAT_WUFR)
            itcm_serial_puts("wake-up frame received\n");
        if (data & PMT_CTRL_STAT_MPR)
            itcm_serial_puts("magic packet received\n");
        return 1;
    }
    else
        return 0;
#else
    return ReceivedWakeup;
#endif
}

void itcm_EthernetReenable(void)
{
    unsigned long data=0;
    EthernetEvent = 0;
    ReceivedWakeup = 0;
    data = PMT_CTRL_STAT_PD |PMT_CTRL_STAT_MPE | PMT_CTRL_STAT_WUFE;
    IO_WRITE(itcm_Ethernet[0]+PMT_CTRL_STAT, data);
}

void itcm_miiphy_RESETPin(void)
{
    //volatile unsigned int i = 0;
    itcm_gpio_init(GPIO_PORTB);
    //	while (i < 300000)
    //		i++;
    itcm_gpio_set_outpindir(GPIO_PORTB, 0xff);
    itcm_gpio_putc(GPIO_PORTB, 0x49);
}

unsigned char itcm_env_get_char(int index)
{
    return (*((unsigned char *)((CFG_FLASH_BASE + CFG_ENV_OFFSET)+index)));
}

int itcm_getenv_r(char *name, char *buf, unsigned len)
{
    unsigned long i, nxt;
    unsigned long val=0, n;
    //unsigned char env[]={'e', 't', 'h', 'a', 'd', 'd', 'r'};
    unsigned long data;
    unsigned char bGet = 0;
    nxt =0;
    n=0;
    data =0;

    for(i=0; i<CFG_ENV_SIZE; i++)
    {
        bGet = 0;
        if(itcm_env_get_char(i) == 'e')
        {
            nxt =i;
            nxt=nxt+1;
            if(itcm_env_get_char(nxt) == 't')
            {
                bGet = 1;
                nxt=nxt+1;
            }
            else
                bGet = 0;
            if(bGet)
            {

                if(itcm_env_get_char(nxt) == 'h')
                {
                    bGet =1;
                    nxt=nxt+1;
                }
                else
                    bGet =0;
            }

            if(bGet)
            {

                if(itcm_env_get_char(nxt) == 'a')
                {
                    bGet =1;
                    nxt=nxt+1;
                }
                else
                    bGet =0;
            }

            if(bGet)
            {
                if(itcm_env_get_char(nxt) == 'd')
                {
                    bGet =1;
                    nxt=nxt+1;
                }
                else
                    bGet =0;
            }
            if(bGet)
            {

                if(itcm_env_get_char(nxt) == 'd')
                {
                    bGet =1;
                    nxt=nxt+1;
                }
                else
                    bGet =0;
            }
            if(bGet)
            {
                if(itcm_env_get_char(nxt) == 'r')
                {
                    bGet =1;
                    nxt=nxt+1;
                }
                else
                    bGet =0;
            }

            if(bGet)
            {
                if(itcm_env_get_char(nxt) =='=')
                {
                    // val = 0x231;
                    nxt = nxt+1;
                    val =nxt;
                    {
                        n=0;
                        while((len >n++) &&(*buf++ = itcm_env_get_char(val++)) !='\0')
                            ;

                        if(len ==n)
                            *buf = '\0';
                        return(n);
                    }
                }
                else
                {
                    bGet = 1;
                }
            }
        }


    }


    return(-1);
}

unsigned long itcm_simple_strtoul(const char *cp,char **endp,unsigned int base)
{
    unsigned long result = 0,value;

    if (*cp == '0') {
        cp++;
        if ((*cp == 'x') && isxdigit(cp[1])) {
            base = 16;
            cp++;
        }
        if (!base) {
            base = 8;
        }
    }
    if (!base) {
        base = 10;
    }
    while (isxdigit(*cp) && (value = isdigit(*cp) ? *cp-'0' : (islower(*cp)
                                                               ? toupper(*cp) : *cp)-'A'+10) < base) {
        result = result*base + value;
        cp++;
    }
    if (endp)
        *endp = (char *)cp;
    return result;
}

int itcm_setMacAdd (void)
{
    unsigned long data;
#if 0
    int env_size, env_present = 0, reg;
    char *s = NULL, *e, es[] = "11:22:33:44:55:66";
    char s_env_mac[64];
    unsigned char  v_env_mac[6];
    env_size = itcm_getenv_r ("ethaddr", s_env_mac, sizeof (s_env_mac));
    if ((env_size > 0) && (env_size < sizeof (es))) {	/* exit if env is bad */
        //printf ("\n*** ERROR: ethaddr is not set properly!!\n");
        return (-1);
    }
    //	if (env_size > 0) {
    //		env_present = 1;
    //		s = s_env_mac;
    //	}

    //	for (reg = 0; reg < 6; ++reg) {	/* turn string into mac value */
    //		v_env_mac[reg] = s ? itcm_simple_strtoul (s, &e, 16) : 0;
    //		if (s)
    //			s = (*e) ? e + 1 : e;
    //	}
#endif

    data = MAC_ADDRESS[0] | MAC_ADDRESS[1] << 8 | MAC_ADDRESS[2] << 16 | MAC_ADDRESS[3] << 24;
    IO_WRITE(itcm_Ethernet[0] + GMAC_ADDR0_LOW, data);

    data = MAC_ADDRESS[4] | MAC_ADDRESS[5] << 8;
    IO_WRITE(itcm_Ethernet[0] + GMAC_ADDR0_HIGH, data);
    return 0;
}
