/* some defines related to SYS/v2
 * Note: used by assembly code, thus cannot include sysmap.h
 */
#ifndef __SYS_V20_H__
#define __SYS_V20_H__

#define _SYS_V20_BASE 0xfd000000

#define MISC_CTRL	(_SYS_V20_BASE + 0x300)
#define BOOTSTRAP	(_SYS_V20_BASE + 0x53c)

#define BOOTSTRAP_SPI 0x02

#define CLKENCTL1		0x00000000
#define CLKENCTL2		0x00000004
#define CLKENCTL3		0x00000008
#define CLKENCTL4		0x0000000c
#define CLKENCTL5		0x00000010

#define CLKSRCCTL1		0x00000014
#define CLKSRCCTL2		0x00000018

#define CLKDIVEN		0x0000001c
#define CLKDIVEN2		0x00000020

#define CLKDIVIDER1		0x00000024
#define CLKDIVIDER2		0x00000028
#define CLKDIVIDER3		0x0000002c
#define CLKDIVIDER4		0x00000030
#define CLKDIVIDER5		0x00000034
#define CLKDIVIDER6		0x00000038

#define PLLCTL			0x00000040
#define PLLSTATES		0x00000044

#define MPLLCTRL1		0x00000050
#define MPLLCTRL2		0x00000054
#define MPLLCTRL3		0x00000058

#define PPLLCTRL1		0x0000005c
#define PPLLCTRL2		0x00000060
#define PPLLCTRL3		0x00000064

#define ARMPLLCTRL1	0x00000080
#define ARMPLLCTRL2	0x00000084
#define ARMPLLCTRL3	0x00000088

#define RGMIIPLLCTRL1	0x00000098
#define RGMIIPLLCTRL2	0x0000009c
#define RGMIIPLLCTRL3	0x00000100

#define ANALOG_CTRL		0x00000430
#define LVDSPADCTRL1	0x00000434
#define PADALTFUNCCTRL1	0x00000500
#define PADALTFUNCCTRL2	0x00000504
#define PADALTFUNCCTRL3	0x00000508
#define PADALTFUNCCTRL4	0x0000050c
#define PADALTFUNCCTRL5	0x00000510

#define PADPULLCTRL1	0x00000514

#define WIRE_EXPCTRL	0x00000550
#define WIRE_NAT_VALUE	0x00000554

#define SDIOCTL1		0x00000560
#define SDIOCTL2		0x00000564
#define SDIOCTL3		0x00000568

#define PAD_DIRCTRL1	0x0000056c
#define PAD_DIRCTRL2	0x00000570

//PLLSTATES_OFF
#define RGMIIPLL_PROG_MASK	(0x1<<23)
#define ARMPLL_PROG_MASK	(0x1<<22)
#define DPLLB_PROG_MASK	(0x1<<21)
#define DPLLA_PROG_MASK	(0x1<<20)
#define PPLL_PROG_MASK		(0x1<<19)
#define MPLL_PROG_MASK	(0x1<<18)

#define RGMIIPLL_DONE_MASK	(0x1<<17)
#define ARMPLL_DONE_MASK	(0x1<<16)
#define DPLLB_DONE_MASK	(0x1<<15)
#define DPLLA_DONE_MASK	(0x1<<14)
#define PPLL_DONE_MASK		(0x1<<13)
#define MPLL_DONE_MASK	(0x1<<12)

#define RGMIIPLL_LKDT2		(0x1<<11)
#define RGMIIPLL_LKDT1		(0x1<<10)
#define ARMPLL_LKDT2		(0x1<<9)
#define ARMPLL_LKDT1		(0x1<<8)
#define DPLLB_LKDT2		(0x1<<7)
#define DPLLB_LKDT1		(0x1<<6)
#define DPLLA_LKDT2		(0x1<<5)
#define DPLLA_LKDT1		(0x1<<4)
#define PPLL_LKDT2		(0x1<<3)
#define PPLL_LKDT1		(0x1<<2)
#define MPLL_LKDT2		(0x1<<1)
#define MPLL_LKDT1		(0x1<<0)

#define LVDSPAD_REF_IPD_MASK	(0x1<<18)
#endif /* __SYS_V20_H__ */
