#ifdef CONFIG_PIXELWORKS_PRE_BOOT

#if defined(CONFIG_PIXELWORKS_PRE_BOOT_EMMC)
#define EMMC_SYMS \
	_itcm_emmc_cp = _pre_boot_itcm_addr + emmc_cp_boot - _pre_boot_start;	\
	_itcm_emmc_cp_itcm = _pre_boot_itcm_addr + emmc_cp_itcm_boot - _pre_boot_start;
#else
#define EMMC_SYMS
#endif

#include <mach/itcm_config.h>

MEMORY
{
	RAM (rwxa) : ORIGIN = TEXT_BASE, LENGTH = BAREBOX_SIZE
	PREIMG : ORIGIN = TEXT_BASE - PBL_IMG_SIZE - LP_IMG_SIZE, LENGTH = PBL_IMG_SIZE
	TCMIMG : ORIGIN = TEXT_BASE - LP_IMG_SIZE, LENGTH = LP_IMG_SIZE
	PBL  : ORIGIN = 0, LENGTH = PBL_IMG_SIZE
	DTCM : ORIGIN = DTCMBOOTADDR, LENGTH = DTCM_SIZE
	ITCM : ORIGIN = ITCMBOOTADDR + PBL_IMG_SIZE, LENGTH = LP_IMG_SIZE
}

#define PRE_IMAGE \
	_pre_boot_dtcm_addr = DTCMBOOTADDR;		\
	_pre_boot_itcm_addr = ITCMBOOTADDR;		\
	/* the 64 margin for the stack start is to avoid trace32 */ \
	/* register+stack window accessing memory outside DTCM (causes FPGA hang-up) */ \
	_pre_boot_stack_init = _pre_boot_dtcm_addr + DTCM_SIZE - 64;	\
	_pre_boot_size = PBL_IMG_SIZE ;				\
	_itcm_boot_size = LP_IMG_SIZE ;				\
	\
	. = TEXT_BASE - (_pre_boot_size + _itcm_boot_size);		\
	.pre_image : {					\
		_pre_boot_start = .;			\
		KEEP(*(.pre_boot.0))			\
		KEEP(*(.pre_boot.1))			\
		KEEP(*(.pre_boot.c))			\
	} >PBL AT>PREIMG				\
	_pre_boot_len = SIZEOF(.pre_image);		\
	_itcm_remap_start = _pre_boot_itcm_addr + remap_start - _pre_boot_start;\
	_itcm_init_sys = _pre_boot_itcm_addr + init_sys - _pre_boot_start;\
	_itcm_ddr_init = _pre_boot_itcm_addr + ddr_init - _pre_boot_start;\
	_itcm_spi_cp = _pre_boot_itcm_addr + spi_cp_boot - _pre_boot_start;\
	_itcm_spi_cp_itcm = _pre_boot_itcm_addr + spi_cp_itcm_boot - _pre_boot_start;\
	EMMC_SYMS \
	\
	. = TEXT_BASE - _itcm_boot_size; \
	.itcm_lp_image : {			\
		KEEP(arch/arm/mach-pixelworks/itcm/built-in.o	(.text*))	\
	} >ITCM AT>TCMIMG					\
	_itcm_boot_len = SIZEOF(.itcm_lp_image); \
	\
	.itcm_data : {	\
		KEEP(arch/arm/mach-pixelworks/itcm/built-in.o	(.rodata*))	\
		KEEP(arch/arm/mach-pixelworks/itcm/built-in.o	(.data*))	\
		KEEP(arch/arm/mach-pixelworks/itcm/built-in.o	(.bss*))	\
	} >DTCM	AT>TCMIMG \
	_itcm_data_len = SIZEOF(.itcm_data); \
	\
	. = TEXT_BASE;
#endif
