/*
 *  arch/arm/mach-pixelworks/gpio.c
 *  Copyright (c) 2016 Pixelworks, Inc.
 *
 *  based on arch/arm/mach-imx/gpio.c
 *
 *  author: Sascha Hauer
 *  Created: april 20th, 2004
 *  Copyright: Synertronixx GmbH
 *
 *  Common code for i.MX machines
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <common.h>
#include <errno.h>
#include <io.h>
#include <mach/sysmap.h>
#include <mach/gpio.h>

#define GPIO_PL061_DATA         0x3fc
#define GPIO_PL061_DIR          0x400

static void __iomem *topazeh_gpio_base[] = {
	(void __iomem *) GPIO0_V2_BASE,
	(void __iomem *) GPIO1_V2_BASE,
	(void __iomem *) GPIO2_V2_BASE,
	(void __iomem *) GPIO3_V2_BASE,
	(void __iomem *) GPIO4_V2_BASE,
	(void __iomem *) GPIO5_V2_BASE,
	(void __iomem *) GPIO6_V2_BASE,
	(void __iomem *) GPIO7_V2_BASE,
	(void __iomem *) GPIO8_V2_BASE,
	(void __iomem *) GPIO9_V2_BASE,
	(void __iomem *) GPIO10_V2_BASE,
	(void __iomem *) GPIO11_V2_BASE,
	(void __iomem *) GPIO12_V2_BASE,
	(void __iomem *) GPIO13_V2_BASE,
	(void __iomem *) GPIO14_V2_BASE,
	(void __iomem *) GPIO15_V2_BASE,
};
static int topazeh_gpio_count = ARRAY_SIZE(topazeh_gpio_base) * 8;


static void __iomem *gpio_get_base(unsigned gpio)
{
	if (gpio >= topazeh_gpio_count)
		return NULL;

	return topazeh_gpio_base[gpio / 8];
}

void gpio_set_value(unsigned gpio, int value)
{
	void __iomem *base = gpio_get_base(gpio);
	int shift = gpio % 8;
	u32 val;

	if (!base)
		return;

	val = readl(base + GPIO_PL061_DATA);

	if (value)
		val |= 1 << shift;
	else
		val &= ~(1 << shift);

	writel(val, base + GPIO_PL061_DATA);
}

int gpio_direction_input(unsigned gpio)
{
	void __iomem *base = gpio_get_base(gpio);
	int shift = gpio % 8;
	u32 val;

	if (!base)
		return -EINVAL;

	val = readl(base + GPIO_PL061_DIR);
	val &= ~(1 << shift);
	writel(val, base + GPIO_PL061_DIR);

	return 0;
}


int gpio_direction_output(unsigned gpio, int value)
{
	void __iomem *base = gpio_get_base(gpio);
	int shift = gpio % 8;
	u32 val;

	if (!base)
		return -EINVAL;

	val = readl(base + GPIO_PL061_DIR);
	val |= 1 << shift;
	writel(val, base + GPIO_PL061_DIR);

	gpio_set_value(gpio, value);

	return 0;
}

int gpio_get_value(unsigned gpio)
{
	void __iomem *base = gpio_get_base(gpio);
	int shift = gpio % 8;
	u32 val;
	int nDataADC;

	if (!base)
		return -EINVAL;

	val = readl(base + GPIO_PL061_DATA);

	if(gpio==1)
	{
		nDataADC=gpio_ADC_get_value(gpio);
		if((val & (1 << shift) ? 1 : 0)&&((nDataADC>676)&&(nDataADC<873)))
		{
			return 1;
		}
		else
			return 0;
	}
	else
	return val & (1 << shift) ? 1 : 0;
}


int gpio_ADC_get_value(unsigned gpio)
{
	volatile ulong adcbackup= readl(0xfdf40000);//ADC8CH_V3_BASE
	u32 data;
	
	/*set adc reset*/
	data = readl(0xfdf40000);	
	data = data |0x00000020; 
	writel(data, 0xfdf40000);
	udelay(2000);

	
	/*clear pd */
	data = readl(0xfdf40000);
	data = data & 0xffffffBF;
	writel(data, 0xfdf40000);
	udelay(2000);
	

	/*clear start */
	data = readl(0xfdf40000);	
	data = data &0xffffffF7;	
	writel(data, 0xfdf40000);
	udelay(2000);	
	
	/*set adcend clr and select chanel 1=up key*/	
	data = readl(0xfdf40000);
	data = data & 0xFFFFFFE0;
	data = data |0x00000011;
	writel(data, 0xfdf40000);
	udelay(2000);	
	
	/*clear adcend clr */
	data = readl(0xfdf40000);
	data = data &0xffffffEF;
	writel(data, 0xfdf40000);
	udelay(2000);		
	
	/*set adc start */
	data = readl(0xfdf40000);
	data  = data |0x00000008;
	writel(data, 0xfdf40000);	
	udelay(10000);

	/*read adc data */	
	data = readl(0xfdf40000+0x00000004);
	data = (data & 0x000007fe)>>1;
	writel(adcbackup, 0xfdf40000);	

	printf("ADC 1 data = %d\n",data);

	return data;
}

