/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <init.h>
#include <io.h>
#include <clock.h>
#include <linux/clk.h>
#include <linux/clkdev.h>

/* this clock is used by drivers/serial/amba-pl011.c */

/* 24MHz xClk */
#define CONFIG_XCLK_HZ 	24000000
#define CONFIG_NAND_CLK 80000000

struct clk {
	unsigned long rate;
};

static struct clk pxlw_xclk = {
	.rate = CONFIG_XCLK_HZ,
};

static struct clk dummy_apb_pclk = {
	.rate = 0,
};

#if defined(CONFIG_ARCH_PIXELWORKS_TOPAZ_PRIME)
static struct clk pxlw_nand_clk = {
	.rate = CONFIG_NAND_CLK,
};
#endif

unsigned long clk_get_rate(struct clk *clk)
{
	return clk->rate;
}

int clk_enable(struct clk *clk)
{
	return 0;
}

void clk_disable(struct clk *clk)
{
}


static struct clk_lookup pxlw_clocks[] = {
	CLKDEV_DEV_ID("uart-pl0110", &pxlw_xclk),
	CLKDEV_CON_ID("apb_pclk", &dummy_apb_pclk),
};

static int pxlw_clkdev_init(void)
{
	clkdev_add_table(pxlw_clocks, ARRAY_SIZE(pxlw_clocks));
	return 0;
}
postcore_initcall(pxlw_clkdev_init);
