/*
 * Copyright (C) 2010 B Labs Ltd,
 * http://l4dev.org
 * Author: Alexey Zaytsev <alexey.zaytsev@gmail.com>
 *
 * Based on mach-nomadik
 * Copyright (C) 2009-2010 Jean-Christophe PLAGNIOL-VILLARD <plagnio@jcrosoft.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of
 * the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 *
 */

#include <common.h>
#include <init.h>
#include <io.h>
#include <asm/armlinux.h>
#include <linux/sizes.h>
#include <mach/sysmap.h>
#include <generated/mach-types.h>
#include <spi/spi.h>
#include <spi/flash.h>
#include <i2c/i2c.h>


extern void (*topazeh_reset_hook)(void);


static void topaz_eval_reset(void)
{
#ifdef CONFIG_SPI
	struct device_d *spi_flash;
	struct spi_device *spi;
	u8 code = 0xe9; // OPCODE_EX4B;

	spi_flash = get_device_by_name("m25p800");
	if (spi_flash) {
		spi = (struct spi_device *)spi_flash->type_data;
		spi_write_then_read(spi, &code, 1, NULL, 0);
	}
#endif
}

static int topazeh_mem_init(void)
{
	arm_add_mem_device("ram0", 0x00000000, SZ_512M);
	return 0;
}
mem_initcall(topazeh_mem_init);

static struct spi_board_info topaz_spi_devices[] = {
	{
		.name = "m25p80",
		.max_speed_hz = 50 * 1000 * 1000,
		.bus_num = 0,
		.chip_select = 0,
		.mode = SPI_MODE_3,
		.bits_per_word = 8,
	},
};

static struct i2c_board_info i2c_devices[] = {
        {
                I2C_BOARD_INFO("24c64", 0x50)
        },
};

static int topazeh_devices_init(void)
{
	topazeh_reset_hook = topaz_eval_reset;

	armlinux_set_architecture(MACH_TYPE_TOPAZEH_EVAL);
	armlinux_set_bootparams((void *)0x00000100);
	spi_register_board_info(topaz_spi_devices, ARRAY_SIZE(topaz_spi_devices));
	add_generic_device("aug0603_spi", 0, NULL, SPI0_V3_BASE,
			   SZ_4K, IORESOURCE_MEM, NULL);
	devfs_add_partition("m25p0", 0x3fe0000, 0x20000, DEVFS_PARTITION_FIXED, "env0");

	i2c_register_board_info(0, i2c_devices, ARRAY_SIZE(i2c_devices));
	add_generic_device("pw2wire", 0, NULL, TWO_WIRE0_V1_BASE,
			   SZ_4K, IORESOURCE_MEM,
			   /* speed_hz */ (void *)400000);
	return 0;
}
device_initcall(topazeh_devices_init);
