/*
 * printer.c -- Printer gadget driver
 *
 * Copyright (C) 2003-2005 David Brownell
 * Copyright (C) 2006 Craig W. Nadler
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

/*******************************************************
 * Copyright (c) 2015-2017 Ricoh Company, Ltd. 
********************************************************/

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <linux/sched.h>
#include <linux/slab.h>
#include <linux/mutex.h>
#include <linux/errno.h>
#include <linux/init.h>
#include <linux/timer.h>
#include <linux/list.h>
#include <linux/interrupt.h>
#include <linux/device.h>
#include <linux/moduleparam.h>
#include <linux/fs.h>
#include <linux/poll.h>
#include <linux/types.h>
#include <linux/ctype.h>
#include <linux/cdev.h>
#include <asm/current.h>

#include <asm/byteorder.h>
#include <linux/io.h>
#include <linux/irq.h>
#include <linux/uaccess.h>
#include <asm/unaligned.h>

#include <linux/usb/ch9.h>
#include <linux/usb/composite.h>
#include <linux/usb/gadget.h>
#include <linux/usb/g_printer.h>

/*ǉ*/
#include <linux/vmalloc.h>
#include <asm/mman.h>
#include <linux/delay.h>
//#include <asm/semaphore.h>
#include "ucom.h"

//#include "gadget_chips.h"

//#define FORCE_USBDEV_DUSBDEV_DPRINTK(fmt, ...) { USBDEV_DPRINTK( fmt,  ##__VA_ARGS__ ); }
//#define USBDEV_DUSBDEV_DPRINTK(fmt, ...) { USBDEV_DPRINTK( fmt,  ##__VA_ARGS__ ); }
/*usb ipp̗L؂ւ*/
#define USBDEV_IPP_SWITHC
/*fobOIvV*/
//#define USBDEV_DEBUG
#ifdef USBDEV_DEBUG
#define USBDEV_DPRINTK(fmt, ...) { printk( fmt,  ##__VA_ARGS__ ); }
#define USBDEV_DPRINTK_ALERT(fmt, ...) { printk( fmt,  ##__VA_ARGS__ ); }
#else
#define USBDEV_DPRINTK(...)
#define USBDEV_DPRINTK_ALERT(fmt, ...) { printk( fmt,  ##__VA_ARGS__ ); }
#endif /*USBDEV_DEBUG*/

/*ISHIHARA_TEST*/
#define MINOR_COUNT 15 // ڑ}Ci[ԍ
/*ISHIHARA_TEST*/
#define USB_DIR_NUM 6 //oN]̈̐(foCXˑ)
#define USB_SIZE_DEVINOFO_DESC 10
#define SIMVA_EP_IN_START 0x81
#define SIMVA_EP_OUT_START 0x08
USB_GADGET_COMPOSITE_OPTIONS();

#define DRIVER_DESC		"RICOH USB CLASS DRIVER"
#define DRIVER_VERSION		"Ver1.01.00"

/* holds our biggest descriptor */
#define USB_DESC_BUFSIZE		256
#define USB_BUFSIZE			4096
#define NUM_USBREQ			16
#define USB_STRINGS_SIZE	1024
#define USB_WORK_BUFF 768


static DECLARE_WAIT_QUEUE_HEAD(rx_wait_queue);
static DEFINE_SPINLOCK(printer_mutex);
static DEFINE_MUTEX(simva_usb_lock);
static DECLARE_WAIT_QUEUE_HEAD(ctl_poll_queue);
static DECLARE_WAIT_QUEUE_HEAD(ctl_poll_queue_state);

static const char shortname [] = "printer";
static const char driver_desc [] = DRIVER_DESC;

static dev_t usb_gadget_devno;

static struct class *usb_gadget_class;

/*******************************************************/
/**********foCXIDXg̍\********************
FGETDEVICEIDp̕tB[hŊǗ邽߂̍\
deviid_data:f[^̃|C^
devid_lenFXg̒
nextFXg̎̃|C^
*******************************************************/
struct devid_list
{
	u8 *devid_data;
	u16 devid_len;
	struct devid_list* next;
};

struct transfer_index {
	unsigned int index;
};

struct recive_index {
	unsigned int index;
};
#if 0
typedef struct vender_stop_status {
	int flags;
}usb_stop_status_t;
#endif

struct compsoite_desc_st {
	struct usb_interface_descriptor inter_desc;
	struct usb_endpoint_descriptor end_desc_out;
	struct usb_endpoint_descriptor end_desc_in;
};

static usb_stop_status_t Usb_stop_status;

/*-------------------------------------------------------------------------*/

struct printer_dev {
	spinlock_t		lock;		/* lock this structure */
	/* lock buffer lists during read/write calls */
	struct mutex		lock_printer_io;
	struct usb_gadget	*gadget;
	s8			interface;
	struct usb_ep		*in_ep[USB_DIR_NUM], *out_ep[USB_DIR_NUM];

	struct list_head	rx_reqs[USB_DIR_NUM];	/* List of free RX structs */
	struct list_head	rx_reqs_active[USB_DIR_NUM];	/* List of Active RX xfers */
	struct list_head	rx_buffers[USB_DIR_NUM];	/* List of completed xfers */
	/* wait until there is data to be read. */
	wait_queue_head_t	rx_wait[USB_DIR_NUM];
	struct list_head	tx_reqs[USB_DIR_NUM];	/* List of free TX structs */
	struct list_head	tx_reqs_active[USB_DIR_NUM]; /* List of Active TX xfers */
	/* Wait until there are write buffers available to use. */
	wait_queue_head_t	tx_wait[USB_DIR_NUM];
	/* Wait until all write buffers have been sent. */
	wait_queue_head_t	tx_flush_wait[USB_DIR_NUM];
	struct usb_request	*current_rx_req[USB_DIR_NUM];
	struct usb_request	*req0;
	size_t			current_rx_bytes[USB_DIR_NUM];
	u8			*current_rx_buf[USB_DIR_NUM];
	u8			printer_status;
	u8			reset_printer;
	struct cdev		printer_cdev;
	struct device		*pdev;
	u8			printer_cdev_open;
	u8			bout_cdev_open[USB_DIR_NUM];
	u8			bin_cdev_open[USB_DIR_NUM];
	wait_queue_head_t	wait;
	struct usb_function	function;
	struct devid_list *dev_listp;
	u8 *out_buf[USB_DIR_NUM],*in_buf[USB_DIR_NUM];
	u_long bulkout_state[USB_DIR_NUM];
	u_long bulkin_state[USB_DIR_NUM];
	struct usb_request	*current_tx_req[NUM_USBREQ][USB_DIR_NUM];
	struct transfer_index tx_index[USB_DIR_NUM];
	struct recive_index rx_index[USB_DIR_NUM];
	u8			gadget_status; /*KWFbghCooChĂ邩*/
	u8 current_state;
	u8 call_attached;
	u8 dev_info_desc[USB_SIZE_DEVINOFO_DESC];
	struct compsoite_desc_st hs_comdesc[UCNEC2_MAX_IF_NUM];
	struct compsoite_desc_st fs_comdesc[UCNEC2_MAX_IF_NUM];
	u8 setif_ctl;
	u8 init_fail;
	u8 num_inter_hs;
	u8 num_inter_fs;
	u8 cnt_func_desc_hs;
	u8 cnt_func_desc_fs;
	u8 cnt_notify_usbd;
	u8 current_alt;
	u8 isSetIF_dev[UCNEC2_MAX_IF_NUM];
	u8 reboot;
};

int usbdev_isSetIF[UCNEC2_MAX_IF_NUM] = {0};
int USB_STATE_FLAG; /* foCX̏Ԃωǂ*/
int usb_recived_data = 0;

/*-------------------------------------------------------------------------*/

/* DO NOT REUSE THESE IDs with a protocol-incompatible driver!!  Ever!!
 * Instead:  allocate your own, using normal USB-IF procedures.
 */

/* Thanks to NetChip Technologies for donating this product ID.
 */
#define PRINTER_VENDOR_NUM	0x0525		/* NetChip */
#define PRINTER_PRODUCT_NUM	0xa4a8		/* Linux-USB Printer Gadget */

/* Some systems will want different product identifiers published in the
 * device descriptor, either numbers or strings or both.  These string
 * parameters are in UTF-8 (superset of ASCII's 7 bit characters).
 */

module_param_named(iSerialNum, coverwrite.serial_number, charp, S_IRUGO);
MODULE_PARM_DESC(iSerialNum, "1");

static char *iPNPstring;
module_param(iPNPstring, charp, S_IRUGO);
MODULE_PARM_DESC(iPNPstring, "MFG:linux;MDL:g_printer;CLS:PRINTER;SN:1;");

/* Number of requests to allocate per endpoint, not used for ep0. */
static unsigned qlen = 10;
module_param(qlen, uint, S_IRUGO|S_IWUSR);

#define QLEN	qlen

#define USB_GADGET_ON	(1)		/* USB gadget L */
#define USB_GADGET_OFF	(0)		/* USB gadget  */
/**/


/*-------------------------------------------------------------------------*/
#define SET_BULKSTATE(a,b) a |= b
#define UNSET_BULKSTATE(a,b) a &= ~b

/*
 * DESCRIPTORS ... most are static, but strings and (full) configuration
 * descriptors are built on demand.
 */

static struct usb_device_descriptor device_desc_hs = {
	.bLength =		sizeof device_desc_hs,
	.bDescriptorType =	USB_DT_DEVICE,
	.bcdUSB =		cpu_to_le16(0x0200),
	.bDeviceClass =		USB_CLASS_PER_INTERFACE,
	.bDeviceSubClass =	0,
	.bDeviceProtocol =	0,
	.idVendor =		cpu_to_le16(PRINTER_VENDOR_NUM),
	.idProduct =		cpu_to_le16(PRINTER_PRODUCT_NUM),
	.bNumConfigurations =	1
};

static struct usb_device_descriptor device_desc_fs = {
	.bLength =		sizeof device_desc_fs,
	.bDescriptorType =	USB_DT_DEVICE,
	.bcdUSB =		cpu_to_le16(0x0100),
	.bDeviceClass =		USB_CLASS_PER_INTERFACE,
	.bDeviceSubClass =	0,
	.bDeviceProtocol =	0,
	.idVendor =		cpu_to_le16(PRINTER_VENDOR_NUM),
	.idProduct =		cpu_to_le16(PRINTER_PRODUCT_NUM),
	.bNumConfigurations =	1
};

static struct usb_qualifier_descriptor dev_qualifier = {
	.bLength =		sizeof dev_qualifier,
	.bDescriptorType =	USB_DT_DEVICE_QUALIFIER,
	.bcdUSB =		cpu_to_le16(0x0200),
	.bDeviceClass =		USB_CLASS_PRINTER,
	.bNumConfigurations =	1
};

static struct usb_otg_descriptor otg_descriptor = {
	.bLength =              sizeof otg_descriptor,
	.bDescriptorType =      USB_DT_OTG,
	.bmAttributes =         USB_OTG_SRP,
};

static const struct usb_descriptor_header *otg_desc[] = {
	(struct usb_descriptor_header *) &otg_descriptor,
	NULL,
};


/************************************************************************/

/************************************************************************/

static struct usb_config_descriptor usb_config_desc = {
	.bLength =		sizeof usb_config_desc,
	.bDescriptorType =	USB_DT_CONFIG,
};

/*C^tF[XƃGh|Cg̍\쐬B*/
//static struct usb_descriptor_header *fs_usb_function[25] = { NULL };
//static struct usb_descriptor_header *hs_usb_function[25] = { NULL };

static struct usb_descriptor_header *fs_usb_function_ipp[64] = { NULL };
static struct usb_descriptor_header *hs_usb_function_ipp[64] = { NULL };



//static u8 array_alt_set[UCNEC2_MAX_IF_NUM] = {0xFF};
static u8 usb_interface_num;
/*C^tF[XƃGh|Cg̕Rt{邽߂̍\̏*/
static dev_comp_t usb_dev_comp;

/* maxpacket and other transfer characteristics vary by speed. */
static inline struct usb_endpoint_descriptor *ep_desc(struct usb_gadget *gadget,
													struct usb_endpoint_descriptor *hs,
													struct usb_endpoint_descriptor *fs)
{
		switch (gadget->speed) {
			case USB_SPEED_HIGH:
				USBDEV_DPRINTK( KERN_INFO "USB_SPEED_HIGH\n" );
			 return hs;
			default:
			return fs;
		}
}

#define USB_EP_MAXPACKET(g) (((g)->speed == USB_SPEED_HIGH)?(512):(64))

#define USB_STRDESC_PRN 3
#define USB_STRDESC_SCN 4
#define USB_STRDESC_NUMee 5

static char	*p_manufacture_string;
static char	*p_product_string;
static char	*p_serial_string;
static char	*p_print_string;
static char	*p_scan_string;
static char	*p_NUMee_string;
//static char str_manufacture[128]={'\0'};
//static char str_product[128]={'\0'};
//static char str_serial[128]={'\0'};

/*-------------------------------------------------------------------------*/

/* descriptors that are built on-demand */

//static char				product_desc [40] = DRIVER_DESC;
//static char				serial_num [40] = "1";
static char				pnp_string [USB_STRINGS_SIZE] =
	"XXMFG:linux;MDL:g_printer;CLS:PRINTER;SN:1;";

/* static strings, in UTF-8 */
static struct usb_string		strings [] = {
	[USB_GADGET_MANUFACTURER_IDX].s = "",
	[USB_GADGET_PRODUCT_IDX].s = "",
	[USB_GADGET_SERIAL_IDX].s =	"",
	[USB_STRDESC_PRN].s =	"",
	[USB_STRDESC_SCN].s =	"",
	[USB_STRDESC_NUMee].s =	"",
	{  }		/* end of list */
};

static struct usb_gadget_strings	stringtab_dev = {
	.language	= 0x0409,	
	.strings	= strings,
};

static struct usb_gadget_strings *dev_strings[] = {
	&stringtab_dev,
	NULL,
};

/***USB_DEVICE***/
#define NUM_CHAR_MAJOR 245
#define USB_UCONTROL 0
#define USB_UBULKOUT 1
#define USB_UBULKIN 2
#define USB_DUMMY 3

typedef struct usb_transfer_type {
	int num_minor;		/*foCXt@C}Ci[ԍ*/
	int type_trans; 	/*]*/
	int	index; 			/*obt@index*/
	int	state; 			/*Gh|Cgp*/
	u8	endpoint; 		/*Gh|Cgԍ*/
}usb_transtype_t;

static usb_transtype_t index_type[MINOR_COUNT] = {
								{1,USB_UCONTROL,0,1,0x00}, /*Rg[]͗Lɐݒ肵Ă*/
								{2,USB_UBULKOUT,0xff,0,0x08},
								{3,USB_UBULKOUT,0xff,0,0x09},
								{4,USB_UBULKOUT,0xff,0,0x0a},
								{5,USB_UBULKOUT,0xff,0,0x0b},
								{6,USB_UBULKOUT,0xff,0,0x0c},
								{7,USB_UBULKOUT,0xff,0,0x0d},
								{8,USB_UBULKOUT,0xff,0,0x0f},
								{9,USB_UBULKIN ,0xff,0,0x81},
								{10,USB_UBULKIN,0xff,0,0x82},
								{11,USB_UBULKIN,0xff,0,0x83},
								{12,USB_UBULKIN,0xff,0,0x84},
								{13,USB_UBULKIN,0xff,0,0x85},
								{14,USB_UBULKIN,0xff,0,0x86},
								{15,USB_UBULKIN,0xff,0,0x87},
							};
							
typedef enum USB_TRANSTYPE_EN {
	USB_TRANSTYPE_CONTROL =0,
	USB_TRANSTYPE_ISO,
	USB_TRANSTYPE_BULK,
	USB_TRANSTYPE_INT,
}USB_TRANSTYPE_ENNUM;

/*foCXt@C̍쐬*/
static char *device_file[MINOR_COUNT] = 
{
	"ucontrol2",
	"ubulkout2",
	"ubulkout3",
	//"ubulkout6",
	"ubulkout4",
	"ubulkout5",
	"ubulkout6",
	//"ubulkout3",
	"ubulkout7",
	"ubulkout8",
	"ubulkin2",
	"ubulkin3",
	//"ubulkin6",
	"ubulkin4",
	"ubulkin5",
	"ubulkin6",
	//"ubulkin3",
	"ubulkin7",
	"ubulkin8",
};

/*KWFbgNOioctl(IOCGBULKINFO)Ă΂ꂽƂ̑Ή*/
/*oNAEgp*/
u8 dummy_out_addr[USB_DIR_NUM] = 
{
	0x08,
	0x09,
	0x0a,
	0x0b,
	0x0c,
	0x0d,
};

/*oNCp*/
u8 dummy_in_addr[USB_DIR_NUM] = 
{
	0x81,
	0x82,
	0x83,
	0x84,
	0x85,
	0x86,
};

/*}Ci[ԍ]擾*/
static unsigned int get_TransferType(unsigned int argminor)
{
	int ret = USB_DUMMY;
	int i=0;
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]get_TransferType:%d\n",argminor);
	for(i=0;i<MINOR_COUNT;i++)
	{
		if(argminor == index_type[i].num_minor)
		{
			ret = index_type[i].type_trans;
			break;
		}
	} 
	
	return ret;
}

static unsigned int get_TransferIndex(unsigned int argminor)
{

	return (argminor > 8)?(argminor-7-2):(argminor-2);
}

static unsigned int get_TransferIndex_buf(unsigned int argminor)
{
	int i = 0;
	int ret = 0xff;
	for(i=0;i<MINOR_COUNT;i++)
	{
		if(index_type[i].num_minor == argminor)
		{
			ret = index_type[i].index;
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:%d\n",__func__,ret);
			return ret;
		}
	}
	
	return ret;
	//return (argminor > 8)?(argminor-7-2):(argminor-2);
}

static unsigned int get_TransferIndex_ep(u8 argbEndpointAddress)
{
	int i = 0;
	int ret = 0xff;
	for(i=0;i<MINOR_COUNT;i++)
	{
		if(index_type[i].endpoint == argbEndpointAddress)
		{
			ret = index_type[i].index;
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:%d\n",__func__,ret);
			return ret;
		}
	}
	
	return ret;
	//return (argminor > 8)?(argminor-7-2):(argminor-2);
}

static unsigned int set_TransferIndex(u8 argbEndpointAddress, int argindex)
{
	int i = 0;
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s[%x]\n",__func__,argbEndpointAddress);

	for(i=0;i<MINOR_COUNT;i++)
	{
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]index_type[%d].endpoint=%x\n",i,index_type[i].endpoint);

		if(index_type[i].endpoint == argbEndpointAddress)
		{
			index_type[i].index = argindex;
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s index[%d]:%d\n",__func__,i,index_type[i].index);
			return index_type[i].index;
		}
	}	
	return -1;
}
/********************************************************************************/
/**set_endpoint_sate*************************************************************/
/**octl(IOCSEPINFO)ɐݒ肳ꂽGh|CgLɂ************************/
/**VXeR[Ӑ}ȂGh|Cg̃obt@ŃANZXȂ悤ɂ****/
/********************************************************************************/
static unsigned int set_endpoint_state(u8 argep)
{
	int i = 0;
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s[%x]\n",__func__,argep);

	for(i=0;i<MINOR_COUNT;i++)
	{
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]index_type[%d].endpoint=%x\n",i,index_type[i].endpoint);

		if(index_type[i].endpoint == argep)
		{
			index_type[i].state = 1;
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s index[%d]:%d\n",__func__,i,index_type[i].state);
			return index_type[i].state;
		}
	}
	return -1;
}
static unsigned int get_endpoint_state(unsigned int argminor)
{
	int i = 0;
	int ret = 0xff;
	for(i=0;i<MINOR_COUNT;i++)
	{
		if(index_type[i].num_minor == argminor)
		{
			ret = index_type[i].state;
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:%d\n",__func__,ret);
			return ret;
		}
	}
	
	return ret;
	//return (argminor > 8)?(argminor-7-2):(argminor-2);
}


typedef union u8_to_u16 {
u8 string[2];
u16 tmp;
} dat_u;

static void _isDevicestate(struct printer_dev *dev);
static void exe_bulkout_thread(struct printer_dev *dev);
	
static void set_alt_val(u8 argval){
	
	int i = 0;
	if_comp_s_t *if_comp;
	
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s[%x]\n",__func__,argval);
	
	for(i=0;i<UCNEC2_MAX_IF_NUM;i++){
		if_comp = &(usb_dev_comp.if_comp[i]);
		if_comp->alt_set = argval;
	}
	
}
static int printer_func_bind(struct usb_configuration *c,struct usb_function *f);
static void printer_func_unbind(struct usb_configuration *c,struct usb_function *f);
static int printer_bind_config(struct usb_configuration *c);
static int printer_bind(struct usb_composite_dev *cdev);
static int printer_unbind(struct usb_composite_dev *cdev);

static int __set_interface(struct printer_dev *dev, struct usb_composite_dev *cdev,
struct usb_configuration *c, struct usb_function *f);
static int __set_endpoint(struct printer_dev *dev, struct usb_composite_dev *cdev,
struct usb_configuration *c, struct usb_function *f);

static struct usb_composite_driver printer_driver = {
	.name           = shortname,
	.dev            = &device_desc_hs,
	.strings        = dev_strings,
	.max_speed      = USB_SPEED_HIGH,
	.bind		= printer_bind,
	.unbind		= printer_unbind,
};

/*-------------------------------------------------------------------------
MIBΉŒǉ`/\̂Ȃ
-------------------------------------------------------------------------*/
static	uc_ctl_data_t	Ctl_data;
static	char			Ctl_pkt[1024];
				/**
 * @brief SETUPpPbg\
 */
typedef struct usb_setup_s {
/* bmRequestType͗p}N */
#define REQ_TYPE(x)		(((x)>>5) & 0x03)	/**< Type擾}N */
#define REQ_DIR(x)			((x) & 0x80 )		/**< ]擾}N */
#define REQ_TARGET(x)		((x) & 0xf )		/**< Ώێ擾}N */
 #define TGT_DEVICE		(0x00)				/**< Ώ: Device */
 #define TGT_INTERFACE		(0x01)				/**< Ώ: Interface */
 #define TGT_ENDPOINT		(0x02)				/**< Ώ: Endpoint */
	u_int8_t	bmRequestType;			/**< bmRequestType */
	u_int8_t	bRequest;				/**< bRequest */
	u_short		wValue;					/**< wValue */
	u_short		wIndex;					/**< wIndex */
	u_short		wLength;				/**< wLength */
} usb_setup_t;

static usb_setup_t Usb_setup_pkt;
static usb_setup_t Tmp_Usb_setup_pkt;
/**
 * @brief ʒmNGXgǗ\
 */
typedef struct notify_list_s {
	uc_notify_req_t	Notify_req[UC_MAX_NOTIFY_REQ];	/**< AvʒmXg */
	u_int8_t		Notify_cnt;						/**< AvʒmXgo^ */
#define NOTIFY_REQ_OFF		0					/**< AvʒmNGXg񏈗 */
#define NOTIFY_REQ_ON		1					/**< AvʒmNGXg */
	u_int8_t		ntf_stat;						/**< AvʒmNGXg */
	u_int8_t		ntf_cnt;						/**< AvʒmNGXgʔ */
	//struct callout	ntf_co;							/**< AvԊĎ^C}[ */
} notify_list_t;
static notify_list_t Notify_list;
/**********************************************************************
KWFbgJnFusb_request\̗̂̈m
***********************************************************************/
static struct usb_request *
printer_req_alloc(struct usb_ep *ep, void *buf , int index, unsigned len, gfp_t gfp_flags)
{
	struct usb_request	*req;

	if(ep == NULL)
	{
		USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]ep=NULL\n");
	}
	if(buf == NULL)
	{
		USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]buf=NULL\n");
	}
	
	req = usb_ep_alloc_request(ep, gfp_flags);

	if (req != NULL) {
		req->length = len;
		req->buf = buf+(index*len);
		if (req->buf == NULL) {
			usb_ep_free_request(ep, req);
			return NULL;
		}
		req->length = 0;
	}

	return req;
}

/**********************************************************************
KWFbgJnFusb_request\̗̂̈
***********************************************************************/
static void
printer_req_free(struct usb_ep *ep, struct usb_request *req)
{
	if (ep != NULL && req != NULL) {
		USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:usb_ep_free_request\n", __func__);
		//kfree(req->buf);
		usb_ep_free_request(ep, req);
	}
}
/*-------------------------------------------------------------------------*/
/**********************************************************************
oNAEgFf[^MudcĂ΂R[obN֐
***********************************************************************/
static void rx_complete(struct usb_ep *ep, struct usb_request *req)
{
	struct printer_dev	*dev = ep->driver_data;
	int			status = req->status;
	unsigned long		flags;
	struct recive_index *rx_index = (struct recive_index *)req->context;
	unsigned int index=1000;
	index = rx_index->index;

	
	spin_lock_irqsave(&dev->lock, flags);

	list_del_init(&req->list);	/* Remode from Active List */
	
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]rx_complete:ep->name:%s status:%d index:%d\n",ep->name,status,rx_index->index);

	switch (status) {

	/* normal completion */
	case 0:
		if (req->actual > 0) {
			//USBDEV_DPRINTK(KERN_INFO "[USB_DEV](req->actual %d\n", req->actual);
			//USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]rx_index->index=%d\n",rx_index->index);
			list_add_tail(&req->list, &dev->rx_buffers[rx_index->index]);
			DBG(dev, "G_Printer : rx length %d\n", req->actual);
			udelay(1000);
		}
		else {
			//USBDEV_DPRINTK(KERN_INFO "[USB_DEV]else (req->actual > 0)\n");
			list_add(&req->list, &dev->rx_reqs[rx_index->index]);
			UNSET_BULKSTATE(dev->bulkout_state[rx_index->index],UBS_IN_TRANS);
			SET_BULKSTATE(dev->bulkout_state[rx_index->index],UBS_IRP_END);
		}

		break;

	/* software-driven interface shutdown */
	case -ECONNRESET:		/* unlink */
	case -ESHUTDOWN:		/* disconnect etc */
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]ESHUTDOWN\n");
		VDBG(dev, "rx shutdown, code %d\n", status);
		list_add(&req->list, &dev->rx_reqs[rx_index->index]);
		break;

	/* for hardware automagic (such as pxa) */
	case -ECONNABORTED:		/* endpoint reset */
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]ECONNABORTED\n");
		DBG(dev, "rx %s reset\n", ep->name);
		list_add(&req->list, &dev->rx_reqs[rx_index->index]);
		break;

	/* data overrun */
	case -EOVERFLOW:
		/* FALLTHROUGH */

	default:
		DBG(dev, "rx status %d\n", status);
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]default\n");
		list_add(&req->list, &dev->rx_reqs[rx_index->index]);
		break;
	}

	wake_up_interruptible(&dev->rx_wait[rx_index->index]);
	spin_unlock_irqrestore(&dev->lock, flags);
}
/**********************************************************************
oNAEgFf[^MJn̏usb_ep_queueĂяo
***********************************************************************/
/* This function must be called with interrupts turned off. */
static void
setup_rx_reqs(struct printer_dev *dev, unsigned int index)
{
	struct usb_request              *req;
	struct recive_index *rx_index;
	
	while (likely(!list_empty(&dev->rx_reqs[index]))) {
		int error;

		req = container_of(dev->rx_reqs[index].next,
				struct usb_request, list);
		
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]setup_rx_reqs_index [%d]\n",index);
		
		//if(&req->list == NULL) USBDEV_DPRINTK(KERN_WARNING "[USB_DEV]setup_rx_reqs req=NULL\n");
		
		list_del_init(&req->list);

		/* The USB Host sends us whatever amount of data it wants to
		 * so we always set the length field to the full USB_BUFSIZE.
		 * If the amount of data is more than the read() caller asked
		 * for it will be stored in the request buffer until it is
		 * asked for by read().
		 */
		rx_index = &dev->rx_index[index];
		rx_index->index = index;
		req->length = USB_EP_MAXPACKET(dev->gadget);
		//req->length = USB_BUFSIZE;
		req->complete = rx_complete;
		req->actual = 0;
		req->context = rx_index;
		if(rx_index == NULL)
		{
			USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]rx_index id NULL\n");
		}
		/* here, we unlock, and only unlock, to avoid deadlock. */
		spin_unlock(&dev->lock);
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]rx_index->index=%d\n",rx_index->index);
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]usb_ep_queue ep->name=%s\n",dev->out_ep[index]->name);
		error = usb_ep_queue(dev->out_ep[index], req, GFP_ATOMIC);
			if (error < 0) {
				//ERROR(dev, "%s:%d Error!\n", __func__, __LINE__);
			}		
		if (dev->out_ep[index] != NULL)
		{
			USBDEV_DPRINTK(KERN_ALERT "[USB_DEV](dev->out_ep[%d] != NULL)\n",index);
		}
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]after usb_ep_queue = %d \n",error);
		spin_lock(&dev->lock);
		if (error) {
			USBDEV_DPRINTK(KERN_INFO "[USB_DEV]usb_ep_queue is error\n");
			DBG(dev, "rx submit --> %d\n", error);
			list_add(&req->list, &dev->rx_reqs[index]);
			break;
		}
		/* if the req is empty, then add it into dev->rx_reqs_active. ZbgɗpĂ*/
		else if (list_empty(&req->list)) {
			USBDEV_DPRINTK(KERN_INFO "[USB_DEV]setup_rx_reqs (list_empty(&req->list))\n");
			list_add(&req->list, &dev->rx_reqs_active[index]);
		}
	}
	/*DMAItO𗎂Ƃ*/
	if((dev->bulkout_state[index] & UBS_IRP_END) & UBS_IRP_END)
	{
		UNSET_BULKSTATE(dev->bulkout_state[index],UBS_IRP_END);
		SET_BULKSTATE(dev->bulkout_state[index],UBS_IRP_START);
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]UBS_IRP_END -> UBS_IRP_START\n");
	}
	/*DMA̓]JnȂJn/ItO𗎂ƂDMA]ɂ*/
	else if((dev->bulkout_state[index] & UBS_IRP_START) & UBS_IRP_START)
	{
		UNSET_BULKSTATE(dev->bulkout_state[index],UBS_IRP_START);
		SET_BULKSTATE(dev->bulkout_state[index],UBS_IN_TRANS);
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]UBS_IRP_START -> UBS_IN_TRANS\n");
	}
	else
	{
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]else\n");
	}
}
/**********************************************************************
oNCFf[^MudcĂ΂R[obN֐
***********************************************************************/
static void tx_complete(struct usb_ep *ep, struct usb_request *req)
{
	struct printer_dev	*dev = ep->driver_data;
	struct transfer_index *tx_index = (struct transfer_index *)req->context;
	unsigned long flags;

	USBDEV_DPRINTK(KERN_INFO "[USB_DEV]%s:req->buf=%x\n",__func__,req->buf);
	switch (req->status) {
	default:
		VDBG(dev, "tx err %d\n", req->status);
		/* FALLTHROUGH */
	case -ECONNRESET:		/* unlink */
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]req->status=-ECONNRESET\n");
		break;
	case -ESHUTDOWN:		/* disconnect etc */
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]req->status=-ESHUTDOWN\n");
		break;
	case 0:
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]%s:req->status[%d]=%d\n",__func__,tx_index->index,0);
		//req->length = 0;
		break;
	}

	spin_lock_irqsave(&dev->lock, flags);
	/* Take the request struct off the active list and put it on the
	 * free list.
	 */

	list_del_init(&req->list);
	list_add(&req->list, &dev->tx_reqs[tx_index->index]);
	wake_up_interruptible(&dev->tx_wait[tx_index->index]);
	if (likely(list_empty(&dev->tx_reqs_active[tx_index->index])))
	{
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]likely(list_empty(&dev->tx_reqs_active))\n");
		wake_up_interruptible(&dev->tx_flush_wait[tx_index->index]);
	}

	spin_unlock_irqrestore(&dev->lock, flags);
}
	
/*-------------------------------------------------------------------------*/

typedef struct usb_ep_name {
	u8 ep_addr;
	char* ep_name;
}usb_epname_t;

/*******************************************************************
֐:usb_ep_setconfig
Fusb_ep\̂̃oƃGh|CgfBXNv^̕Rt{B
KWFbgt[[NŒ񋟂Ă@\łepautoconf.c/usb_ep_autoconfigŐݒ肵Ă邪A
CӂŃGh|Cg𗘗pł悤ɂ邽߂ɒǉ
********************************************************************/
static struct usb_ep* usb_ep_setconfig(struct usb_gadget *gadget,struct usb_endpoint_descriptor *desc)
{
	u8 num;
	char ep_name[16] = "ep";
	char tmp_name[4] = {'\0'};
	struct usb_ep	*ep;
	u8		type;
	
	if(gadget == NULL || desc == NULL)
	{
		USBDEV_DPRINTK(KERN_WARNING "[USB_DEV]usb_ep_setconfig:Invalid argument\n");
		return NULL;
	}
	
	type = usb_endpoint_type(desc);
	
	/*镶̎擾*/
	num = desc->bEndpointAddress & 0xf;
	sprintf(tmp_name, "%d", num);
	strcat(ep_name,tmp_name);
	if (USB_DIR_IN & desc->bEndpointAddress)
	{
		strcat(ep_name,"in");
	}
	else
	{
		strcat(ep_name,"out");
	}
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]usb_ep_setconfig:ep_name=%s\n",ep_name);
	
	/*usb_gadget\̂ŕێĂusb_ep\̂Ώۂ̕񂪂邩*/
	/*usb_ep\̃o̒lݒ*/
	list_for_each_entry (ep, &gadget->ep_list, ep_list)
	{
		if (0 == strcmp (ep->name, ep_name))
		{
			ep->address = desc->bEndpointAddress;
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]after_ep->addresss :%x\n",ep->address);
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]after_ep->name :%s\n",ep->name);
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]wMaxPacketSize :%d\n",desc->wMaxPacketSize);
			return ep;
		}
	}
	return NULL;
}
/****************************************************************************************/
/**C^tF[XfBXNv^ƃGh|CgfBXNv^KWFbghCoɓn**/
/****************************************************************************************/
static int __set_interface(struct printer_dev *dev, struct usb_composite_dev *cdev,
struct usb_configuration *c, struct usb_function *f)
{
	int ret = 0;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s\n",__func__);

	ret = usb_assign_descriptors(f, fs_usb_function_ipp,hs_usb_function_ipp, NULL);
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:ret=%d\n",__func__,ret);
	return ret;

}

/****************************************************************************************/
/**Gh|CgfBXNv^KWFbghCoɓn**/
/****************************************************************************************/
static int __set_endpoint(struct printer_dev *dev, struct usb_composite_dev *cdev,
struct usb_configuration *c, struct usb_function *f)
{
	struct usb_ep *in_ep;
	struct usb_ep *out_ep =NULL;
	int id;
	int ret;
	int i,j;
	if_comp_s_t *if_comp;
	struct usb_endpoint_descriptor *in_desc;
	struct usb_endpoint_descriptor *out_desc;

	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s\n",__func__);

	
	for(i=0;i<usb_interface_num;i++) 
	{
		if_comp = &(usb_dev_comp.if_comp[i]);
		if(dev->gadget_status != USB_GADGET_ON){
			USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s[%d]\n",__func__, __LINE__);
			id = usb_interface_id(c, f);
		}
		for(j=0;j<UCNEC2_MAX_IF_NUM;j++)
		{
			//printk(KERN_ALERT "[USB_DEV]%s:i=%d:j=%d\n",__func__, i, j);
			USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]j:%d\n",j );
			/*C^[tF[Xԍaltݒ肪Ƃusb_descriptor_headerɒǉ*/
			if(((dev->hs_comdesc[j].inter_desc.bInterfaceNumber) == i) && 
			((dev->hs_comdesc[j].inter_desc.bAlternateSetting) == 0))
			{
				/*Gh|CgfBXNv^̃Xs[hݒ*/
				if( printer_driver.max_speed == USB_SPEED_HIGH){
					in_desc = &(dev->hs_comdesc[j].end_desc_in);
					out_desc = &(dev->hs_comdesc[j].end_desc_out);
				}
				else{
					in_desc = &(dev->fs_comdesc[j].end_desc_in);
					out_desc = &(dev->fs_comdesc[j].end_desc_out);
				}
				in_ep = usb_ep_setconfig(cdev->gadget, in_desc);
				if (!in_ep) {
autoconf_fail:
					dev_err(&cdev->gadget->dev, "can't autoconfigure on %s\n",
						cdev->gadget->name);
					return -ENODEV;
				}
				in_ep->driver_data = in_ep;	/* claim */
				
				out_ep = usb_ep_setconfig(cdev->gadget, out_desc);
				if (!out_ep->desc)
				{
					USBDEV_DPRINTK( KERN_DEBUG "out_ep->desc is NULL\n");
				}
				else
				{
					USBDEV_DPRINTK( KERN_DEBUG "out_ep->desc not NULL\n");
				}
				if (!out_ep)
					goto autoconf_fail;
				out_ep->driver_data = out_ep;	/* claim */

				ret = set_TransferIndex(dev->hs_comdesc[j].end_desc_in.bEndpointAddress, i);
				USBDEV_DPRINTK( KERN_DEBUG "in_desc->bEndpointAddress[%x]:ret[%d]\n",in_desc->bEndpointAddress,ret);
				ret = set_TransferIndex(dev->hs_comdesc[j].end_desc_out.bEndpointAddress, i);
				USBDEV_DPRINTK( KERN_DEBUG "out_desc->bEndpointAddress[%x]:ret[%d]\n",out_desc->bEndpointAddress,ret);
				dev->in_ep[i] = in_ep;
				dev->out_ep[i] = out_ep;
				break;
			}
		}
	}
	return 0;
}
	
static int
set_printer_interface(struct printer_dev *dev,unsigned number, unsigned alt)
{
	int ret = 0;
	int j = 0;
	
	struct usb_composite_dev *cdev;
	cdev = dev->function.config->cdev;

	//printk(KERN_ALERT "[USB_DEV]%s[%d][%d]\n",__func__,number,alt);
	
	if(( 0x00 == number ) && ( 0 == alt ))
	{
		dev->current_alt = 0x00;
	}
	else if (( 0x00 == number ) && ( 0 != alt ))
	{
		dev->current_alt = 0x01;
	}
	else{
		
	}
	/* ݂̑փC^tF[XXV */
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s dev->current_alt:%x\n",__func__,dev->current_alt);	
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s dev->num_inter_hs:%d\n",__func__,dev->num_inter_hs );
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s usb_interface_nums:%d\n",__func__,usb_interface_num );
	/*Gh|CgLɂ*/
	for(j=0;j<dev->num_inter_hs;j++)
	{
		//USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]j:%d\n",j );
		/*C^[tF[Xԍaltݒ肪Ƃusb_descriptor_headerɒǉ*/
		//if(((dev->hs_comdesc[j].inter_desc.bInterfaceNumber) == i) && 
		//((dev->hs_comdesc[j].inter_desc.bAlternateSetting) == alt))
		if((dev->hs_comdesc[j].inter_desc.bInterfaceNumber) == number)
		{
			USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]j:%d,alt:%d\n",j,alt );
			//dev->num_inter_hs;
			dev->in_ep[number]->desc = ep_desc(dev->gadget, &(dev->hs_comdesc[j].end_desc_in), &(dev->fs_comdesc[j].end_desc_in));
			dev->in_ep[number]->driver_data = dev;
			if (dev->in_ep[number]->desc != NULL)
			{
				USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]dev->in_ep[%d]->name:%s\n",number,dev->in_ep[number]->name);
			}

			dev->out_ep[number]->desc = ep_desc(dev->gadget,&(dev->hs_comdesc[j].end_desc_out), &(dev->fs_comdesc[j].end_desc_out));
			dev->out_ep[number]->driver_data = dev;
			if (dev->in_ep[number]->desc != NULL)
			{
				USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]dev->out_ep[%d]->name:%s\n",number,dev->out_ep[number]->name);
			}
			ret = usb_ep_enable(dev->in_ep[number]);
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:usb_ep_enable(dev->in_ep[%d])=%d\n",__func__,number,ret);
			if (ret != 0) {
			DBG(dev, "enable %s --> %d\n", dev->in_ep[number]->name, ret);
			goto done;
			}
			SET_BULKSTATE(dev->bulkin_state[number],UBS_DMA_ENABLE);

			ret = usb_ep_enable(dev->out_ep[number]);
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:usb_ep_enable(dev->in_ep[%d])=%d\n",__func__,number,ret);
			if (ret != 0) {
				DBG(dev, "enable %s --> %d\n", dev->in_ep[number]->name, ret);
				goto done;
			}
			SET_BULKSTATE(dev->bulkout_state[number],UBS_DMA_ENABLE);

done:
				/* on error, disable any endpoints  */
			if (ret != 0) {
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]set_printer_interface call disable\n");
			(void) usb_ep_disable(dev->in_ep[number]);
			(void) usb_ep_disable(dev->out_ep[number]);
			dev->in_ep[number]->desc = NULL;
			dev->out_ep[number]->desc = NULL;
			UNSET_BULKSTATE(dev->bulkin_state[number],UBS_DMA_ENABLE);
			UNSET_BULKSTATE(dev->bulkout_state[number],UBS_DMA_ENABLE);
			}
			break;
		}
	}
#if 0 /*IPPΉƂȂƂ肽̂͂Ȃ*/
	/*USB̏ԂmF*/
	//_isDevicestate(dev);
#endif
	/* caller is responsible for cleanup on error */
	return ret;
}

static void printer_reset_interface(struct printer_dev *dev, unsigned number)
{
	int ret = 0;
	if (dev->interface < 0)
		return;

	DBG(dev, "%s\n", __func__);

	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]printer_reset_interfacee\n");
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:number=%d\n",__func__,number);
	if (dev->in_ep[number]->desc){
		ret = usb_ep_disable(dev->in_ep[number]);
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:usb_ep_disable(dev->in_ep[%d])=%d\n",__func__,number,ret);
		dev->in_ep[number]->desc = NULL;
		dev->bulkin_state[number] = UBS_DMA_OFF;
	}
	if (dev->out_ep[number]->desc){
		ret = usb_ep_disable(dev->out_ep[number]);
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:usb_ep_disable(dev->out_ep[%d])=%d\n",__func__,number,ret);
		dev->out_ep[number]->desc = NULL;
		dev->bulkout_state[number] = UBS_DMA_OFF;
	}
}
	
/**************************************************************/
/*USBP[uƂɃfoCX̍\̂̃ȍ{*/
/**************************************************************/
static void reset_usb_simva(struct printer_dev *dev)
{
	int i;
	if_comp_s_t *if_comp;

	USBDEV_DPRINTK(KERN_INFO "%s\n", __func__);

	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]reset_usb_simva\n");
	for(i=0;i<usb_interface_num;i++)
	{
		usbdev_isSetIF[i] = 0;
		if_comp = &(usb_dev_comp.if_comp[i]);
		if_comp->is_set = 0;
		if_comp->alt_set = 0;
		if_comp->alt_num = 0;
	}
		
	dev->current_alt = 0x00;
	//Notify_list.Notify_cnt = 0;
	dev->cnt_notify_usbd = 0;
	dev->call_attached = 0;
	/*altݒ̏*/
	set_alt_val(0xFF);
	for(i=0;i<USB_DIR_NUM;i++)
	{
		/*DMA~ɂĂ*/
		dev->bulkout_state[i] = UBS_DMA_OFF;
		dev->bulkin_state[i] = UBS_DMA_OFF;
		dev->bout_cdev_open[i] = 0;
		dev->bin_cdev_open[i] = 0;
	}
}

/* Change our operational Interface. */
static int set_interface(struct printer_dev *dev, unsigned number, unsigned alt)
{
	int			result = 0;
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s[%d][%d]\n",__func__,number,alt);
	printer_reset_interface(dev, number);
	result = set_printer_interface(dev, number, alt);

	USBDEV_DPRINTK( KERN_DEBUG "%s: set_printer_interface=%d\n",__func__,result);
	if (result)
		printer_reset_interface(dev, number);
	else
		dev->interface = number;

	if (!result)
		INFO(dev, "Using interface %x\n", number);

	return result;
}

static void printer_soft_reset(struct printer_dev *dev)
{
	struct usb_request	*req;
	int i = 0;
	
	//printk(KERN_ALERT "[USB_DEV]printer_soft_reset call disable\n");
	
	for(i=0;i<usb_interface_num;i++)
	{
		//USBDEV_DPRINTK( KERN_INFO "printer_soft_rest\n" );
		INFO(dev, "Received Printer Reset Request\n");

		if (usb_ep_disable(dev->in_ep[i]))
			DBG(dev, "Failed to disable USB in_ep[0]\n");
		if (usb_ep_disable(dev->out_ep[i]))
			DBG(dev, "Failed to disable USB out_ep[0]\n");

		if (dev->current_rx_req[i] != NULL) {
			list_add(&dev->current_rx_req[i]->list, &dev->rx_reqs[i]);
			dev->current_rx_req[i] = NULL;
		}
		dev->current_rx_bytes[i] = 0;
		dev->current_rx_buf[i] = NULL;
		dev->reset_printer = 1;

		while (likely(!(list_empty(&dev->rx_buffers[i])))) {
			req = container_of(dev->rx_buffers[i].next, struct usb_request,
					list);
			list_del_init(&req->list);
			list_add(&req->list, &dev->rx_reqs[i]);
		}

		while (likely(!(list_empty(&dev->rx_reqs_active[i])))) {
			req = container_of(dev->rx_buffers[i].next, struct usb_request,
					list);
			list_del_init(&req->list);
			list_add(&req->list, &dev->rx_reqs[i]);
		}

		while (likely(!(list_empty(&dev->tx_reqs_active[i])))) {
			req = container_of(dev->tx_reqs_active[i].next,
					struct usb_request, list);
			list_del_init(&req->list);
			list_add(&req->list, &dev->tx_reqs[i]);
		}

		if (usb_ep_enable(dev->in_ep[i]))
		{
			//printk(KERN_ALERT "[USB_DEV]fail usb_ep_enable(dev->in_ep[i])\n");		
			DBG(dev, "Failed to enable USB in_ep\n");
		}
		if (usb_ep_enable(dev->out_ep[i]))
		{
			//printk(KERN_ALERT "[USB_DEV]fail usb_ep_enable(dev->out_ep[i])\n");		
			DBG(dev, "Failed to enable USB out_ep\n");
		}

		wake_up_interruptible(&dev->rx_wait[i]);
		wake_up_interruptible(&dev->tx_wait[i]);
		wake_up_interruptible(&dev->tx_flush_wait[i]);
	}
}



//wait_queue_head_t	rx_wait_queue;
static struct printer_dev usb_printer_gadget;

typedef struct workqueue_struct workqueue_struct_t;
typedef struct work_struct work_struct_t;
//static void  cache_flush_range(unsigned char  *addr, int  size);
//static void  cache_invalidate_range(unsigned char  *addr, int  size);

typedef struct usb_simva_work {
	work_struct_t usb_simva_work;
	struct printer_dev *priv;
	usb_setup_t usb_setup;
} usb_simva_work_t;

static workqueue_struct_t *ptr_usb_simva_wqueue = NULL;
static usb_simva_work_t usb_work_struct_out;
static usb_simva_work_t usb_work_struct_in;
	
#define USB_WQUEUE_NAME "USB_SIMVA_WQUEUE"

/**********************************************************************
NGXgo^Ă邩mF
***********************************************************************/
static int search_ioctl_notifyreq(struct printer_dev *dev, u_char *setup_pkt, int *idx )
{
	int search = 0;
	int low = 0;
	int high = 0;
	int ret = 0;
	
	
	high = Notify_list.Notify_cnt;
	/* Xgo^mF */
	if( 0 == Notify_list.Notify_cnt ) {
		USBDEV_DPRINTK( KERN_INFO "0 == Notify_list.Notify_cnt\n");
		/* o^0̎_ňvȂƂ͊mȂ̂ŏI */
		*idx = 0;
		return 0;
	}
	
	/* 2TJn */
	while( low < high ) {
		search = (u_int32_t)( low + high ) / 2;
		/* setuppPbg6byte(wLengthȊO)rΏۂɂ */
		ret = memcmp( Notify_list.Notify_req[search].setup_pkt,
					  setup_pkt, UC_SETUP_PTK_SIZE - 2 );
		if( 0 == ret ) {
			/* XgɈvID𔭌 */
			*idx = search;
			return 1;
		}
		else if( 0 > ret ) {
			/* ݂̌Ώۂ̉ɂ */
			high = search;
			USBDEV_DPRINTK( KERN_INFO "high=%d\n",high);
		}
		else {
			/* ݂̌Ώۂ̏㔼ɂ */
			low = search + 1;
			USBDEV_DPRINTK( KERN_INFO "low=%d\n",low);
		}
	}
	*idx = low;
	
	return 0;
}
/**********************************************************************
x_[NGXg
***********************************************************************/
static int
analyze_request_vendor(struct printer_dev *dev, usb_setup_t setup)
{
	u_int32_t sub_state = 0;
	u_char state = 0;
	u_char sub_info = 0;
	int ret = 0;
	
	
	/* MNGXg̓AvʒmΏۂ`FbN */
	if( NOTIFY_REQ_OFF == Notify_list.ntf_stat ) {
		/* AvʒmΏۂłȂꍇ͔T|[gƂȂ */
		ret = -1;
	}
	else {
		/* AvʒmΏۃNGXgMread()Œʒm
		 *	{Control IN/OUTňȉ̃^C~OŎ{
		 *	Control IN : DataXe[WIN TokenNAKԂ
		 *	Control OUT: DataXe[WOUT DataSĎM
		 */
		/* NGXgʔԍXV */
		if( 255 <= Notify_list.ntf_cnt ) {
			/* ʔ0͎gpȂdl */
			Notify_list.ntf_cnt = 1;
		}
		else {
			Notify_list.ntf_cnt++;
		}
		/* read̃p[^ݒ(ʔԁAf[^A]) */
		state = Notify_list.ntf_cnt;
		sub_state = setup.wLength;
		sub_info = REQ_DIR( setup.bmRequestType );
		
		USBDEV_DPRINTK( KERN_DEBUG
						"%s: Notify Req[No.%d][%s][Len=%d]\n",
						__FUNCTION__,
						state,
						(sub_info == 0x80) ? "I":"O",
						sub_state );

		Ctl_data.data_no = Notify_list.ntf_cnt;
		wake_up_interruptible(&ctl_poll_queue);
		//Ctl_data.data_len
	}
	
	/* G[mF */
	if( 0 > ret ) {
		USBDEV_DPRINTK( KERN_DEBUG
						"%s: Recv inv VendorReq[0x%02x] [ret=%d]\n",
						__FUNCTION__,
						setup.bRequest,
						ret );
	}
	
	return ret;
}

/*workL[̏֐*/
	
static void usb_work_wqueue_handler(work_struct_t *work)
{
	int ret=0;
	usb_simva_work_t *ptr_work=NULL;
	struct printer_dev *dev = ptr_work->priv;
	ptr_work = (usb_simva_work_t*)work;
	
	USBDEV_DPRINTK( KERN_DEBUG "[USBD]%s\n", __func__);
	/*ÕNGXgI܂ő҂s*/
	wait_event(rx_wait_queue, (Notify_list.ntf_stat == NOTIFY_REQ_OFF));
	USBDEV_DPRINTK( KERN_DEBUG "[USBD]restart %s\n", __func__);
	Notify_list.ntf_stat = NOTIFY_REQ_ON;

	/*setuppPbg̒lRs[*/
	memcpy(Ctl_data.setup_pkt, &(ptr_work->usb_setup), UC_SETUP_PTK_SIZE);
	Usb_setup_pkt.bmRequestType =  ptr_work->usb_setup.bmRequestType;
	Usb_setup_pkt.bRequest =  ptr_work->usb_setup.bRequest;
	Usb_setup_pkt.wValue =  ptr_work->usb_setup.wValue;
	Usb_setup_pkt.wIndex =  ptr_work->usb_setup.wIndex;
	Usb_setup_pkt.wLength =  ptr_work->usb_setup.wLength;
	/*usbdւ̒ʒms߂̏{*/
	ret = analyze_request_vendor(dev,ptr_work->usb_setup);
	if (ret < 0) {
			ERROR(dev, "%s:%d Error!\n", __func__, __LINE__);
	}
	USBDEV_DPRINTK( KERN_DEBUG "[USBD]end %s\n", __func__);

}
static void req0_rx_complete(struct usb_ep *ep, struct usb_request *req)
{
	struct printer_dev	*dev = ep->driver_data;
	int			status = req->status;
	unsigned int corrent_length=0;

	switch (status) {
	/* normal completion */
	case 0:
		if (req->actual > 0) {
			if(!req->buf)
			{
				USBDEV_DPRINTK(KERN_INFO "[USB_DEV](req->=NULL) \n");
			}
			if(corrent_length==0) {
				memcpy(&Ctl_pkt[0], req->buf, req->actual);
				USBDEV_DPRINTK(KERN_INFO "[USB_DEV](corrent_length==0) \n");
			}
			else{
				memcpy(&Ctl_pkt[corrent_length], req->buf, req->actual);
				USBDEV_DPRINTK(KERN_INFO "[USB_DEV]not (corrent_length==0) \n");
			}
			corrent_length = req->actual;
			
			//0x7fffffff;
			/*Mf[^TCYsetup̃TCYƈvƂ[NL[ւ̓o^sB*/
			if(req->length == corrent_length)
			{
				queue_work(ptr_usb_simva_wqueue, (work_struct_t*)&usb_work_struct_out);
				/*Mf[^TCYۑĂ*/
				Ctl_data.data_len = corrent_length;
				
				/*StatusXe[Wڍs̗}~*/
				Usb_stop_status.flags = USB_STOP_ENABLE;
				req->context = &Usb_stop_status;
								
				/*̃Rg[]ŌĂ΂Ȃ悤ɂ邽߂ɃR[obN͍폜*/
				req->complete = NULL;

			}
		}
		else {
			USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]Invalid value:req->actual:%d\n",req->actual);
		}

		break;

	/* software-driven interface shutdown */
	case -ECONNRESET:		/* unlink */
	case -ESHUTDOWN:		/* disconnect etc */
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]ESHUTDOWN\n");
		VDBG(dev, "rx shutdown, code %d\n", status);
		break;

	/* for hardware automagic (such as pxa) */
	case -ECONNABORTED:		/* endpoint reset */
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]ECONNABORTED\n");
		DBG(dev, "rx %s reset\n", ep->name);
		break;

	/* data overrun */
	case -EOVERFLOW:
		/* FALLTHROUGH */

	default:
		DBG(dev, "rx status %d\n", status);
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]default\n");
		break;
	}
}
/* check call setinterface command*/
static int chk_num_setif(void)
{
	int i = 0;
	int ret = 0;
	for (i=0; i< usb_interface_num; i++)
	{
		ret += usbdev_isSetIF[i];
	}
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s=%d\n",__func__,ret);
	return ret;
}
/* check call setinterface command*/
static void rest_num_setif(void)
{
	int i = 0;
	for (i=0; i< usb_interface_num; i++)
	{
		usbdev_isSetIF[i] = 0;
	}
}
/*
 * The setup() callback implements all the ep0 functionality that's not
 * handled lower down.
 */
static int printer_func_setup(struct usb_function *f,
		const struct usb_ctrlrequest *ctrl)
{
	struct printer_dev *dev = container_of(f, struct printer_dev, function);
	struct usb_composite_dev *cdev = f->config->cdev;
	struct usb_request	*req = cdev->req;
	int ret = 0;
	int idx = 0;
	int			value = -EOPNOTSUPP;
	u16			wIndex = le16_to_cpu(ctrl->wIndex);
	u16			wValue = le16_to_cpu(ctrl->wValue);
	u16			wLength = le16_to_cpu(ctrl->wLength);
	u_int16_t chk_len = 0;
	u_int16_t len_check_type = UC_LENCHK_TYPE_NONE;
	u_int8_t dir = 0;

	USBDEV_DPRINTK( KERN_DEBUG "[USB]printer_func_setup%02x.%02x v%04x i%04x l%d\n",
		ctrl->bRequestType, ctrl->bRequest, wValue, wIndex, wLength);
	DBG(dev, "ctrl req%02x.%02x v%04x i%04x l%d\n",
		ctrl->bRequestType, ctrl->bRequest, wValue, wIndex, wLength);

	/*NXNGXg̊mF*/
	switch (ctrl->bRequestType & USB_TYPE_MASK) {
	case USB_TYPE_CLASS:
		switch (ctrl->bRequest) {
		case 0: /* Get the IEEE-1284 PNP String */
#if 0 /*̃C^[tF[X̐ݒ͖̂̏*/
			/* Only one printer interface is supported. */
			if ((wIndex>>8) != dev->interface)
			{
				USBDEV_DPRINTK(KERN_ALERT "[USB_DEV](wIndex>>8) != dev->interface\n");
				break;

			}
#endif
			value = (pnp_string[0]<<8)|pnp_string[1];
			memcpy(req->buf, pnp_string, value);
			DBG(dev, "1284 PNP String: %x %s\n", value,
					&pnp_string[2]);
			break; /*case 0*/

		case 1: /* Get Port Status */
#if 0 /*̃C^[tF[X̐ݒ͖̂̏*/
			/* Only one printer interface is supported. */
			if (wIndex != dev->interface)
				break;
#endif
			*(u8 *)req->buf = dev->printer_status;
			value = min(wLength, (u16) 1);
			break;/*case 1*/

		case 2: /* Soft Reset */
			/* Only one printer interface is supported. */
#if 0 /*̃C^[tF[X̐ݒ͖̂̏*/

			if (wIndex != dev->interface)
				break;
#endif
			printer_soft_reset(dev);

			value = 0;
			break; /*case 2*/

		default:
			goto unknown;
		}
		break; /*case USB_TYPE_CLASS*/
	case USB_TYPE_VENDOR:
		/*pPbg̕ۑ*/
		Tmp_Usb_setup_pkt.bmRequestType = ctrl->bRequestType;
		dir = REQ_DIR( Tmp_Usb_setup_pkt.bmRequestType );
		//USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]func setup dir=%x\n",dir);
		Tmp_Usb_setup_pkt.bRequest = ctrl->bRequest;
		Tmp_Usb_setup_pkt.wValue = wValue;
		Tmp_Usb_setup_pkt.wIndex = wIndex;
		Tmp_Usb_setup_pkt.wLength = wLength;
		USBDEV_DPRINTK( KERN_DEBUG "[USB]vender printer_func_setup%02x.%02x v%04x i%04x l%d\n",
		ctrl->bRequestType, ctrl->bRequest, wValue, wIndex, wLength);
		/* ʒmΏۃNGXgXgo^mF */
		ret = search_ioctl_notifyreq(dev, (u_char *)ctrl, &idx);
		USBDEV_DPRINTK( KERN_DEBUG "search_ioctl_notifyreq = %d\n",ret);
		if( 0 != ret ) { /* TRUE */
			/* AvʒmXgɓo^ĂsetuppPbg̏ꍇ */
			/* wLength̃`FbN@ɊmFs */
			chk_len = Notify_list.Notify_req[idx].setup_pkt[6] + 
					( Notify_list.Notify_req[idx].setup_pkt[7] << 8 );
			len_check_type = Notify_list.Notify_req[idx].len_check_type;
			
			/* wLength̔e
			 *	TYPE_NONE  : f[^͍̔sȂ
			 *	TYPE_EQUAL : Avݒ肵f[^ƈv
			 *	TYPE_ABOVE : Avݒ肵f[^傫(CR[͋Ȃdl)
			 *	TYPE_BELOW : Avݒ肵f[^菬(CR[͋Ȃdl)
			 *	LɊYꍇ͔OKƂAvʒmΏۂƌȂ
			 */
			if( ( UC_LENCHK_TYPE_NONE  == len_check_type ) ||
			   (( UC_LENCHK_TYPE_EQUAL == len_check_type ) && ( Tmp_Usb_setup_pkt.wLength == chk_len )) ||
			   (( UC_LENCHK_TYPE_ABOVE == len_check_type ) && ( Tmp_Usb_setup_pkt.wLength > chk_len ))  ||
			   (( UC_LENCHK_TYPE_BELOW == len_check_type ) && ( Tmp_Usb_setup_pkt.wLength < chk_len ))) {
				ret = 1;
			}
			else {
				ret = 0;
				USBDEV_DPRINTK_ALERT(KERN_DEBUG
						"%s: unmatch type(%d) wLen(%d) chkLen(%d)\n",
						__FUNCTION__,
						len_check_type, Tmp_Usb_setup_pkt.wLength, chk_len );
			}
		}
		/*f[ɒʒmΏۂ̃NGXĝƂ*/
		if( 0 != ret )
		{
			/* AvʒmNGXgM */
			USBDEV_DPRINTK(KERN_DEBUG
						"%s: recv API notify Request\n",
						__FUNCTION__ );
			
			USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]analyze_request_vendor ret = %d\n",ret);
			value = wLength;
			switch (ctrl->bRequest) {
			case 0x02:	/* MIBf[^M(SET_MIB_OID) */
				USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]SET_MIB\n");

				req->length = Tmp_Usb_setup_pkt.wLength;
				req->complete = req0_rx_complete;
				dev->req0 = req;
				Ctl_data.data_pkt = (u_char *)Ctl_pkt;
				
				ret = usb_ep_queue(cdev->gadget->ep0, req, GFP_ATOMIC);
				usb_work_struct_out.usb_setup.bmRequestType = Tmp_Usb_setup_pkt.bmRequestType;
				usb_work_struct_out.usb_setup.bRequest = Tmp_Usb_setup_pkt.bRequest;
				usb_work_struct_out.usb_setup.wValue = Tmp_Usb_setup_pkt.wValue;
				usb_work_struct_out.usb_setup.wIndex = Tmp_Usb_setup_pkt.wIndex;
				usb_work_struct_out.usb_setup.wLength = Tmp_Usb_setup_pkt.wLength;				
				/*statusiKɈȍ~Ȃ悤ɂ邽USB_GADGET_DELAYED_STATUSԂ*/
				return USB_GADGET_DELAYED_STATUS;
				
			break;
				
			case 0x04:	/* MIBe[^M(GET_MIB_VAL) */
				USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]GET_MIB\n");
				usb_work_struct_in.usb_setup.bmRequestType = Tmp_Usb_setup_pkt.bmRequestType;
				usb_work_struct_in.usb_setup.bRequest = Tmp_Usb_setup_pkt.bRequest;
				usb_work_struct_in.usb_setup.wValue = Tmp_Usb_setup_pkt.wValue;
				usb_work_struct_in.usb_setup.wIndex = Tmp_Usb_setup_pkt.wIndex;
				usb_work_struct_in.usb_setup.wLength = Tmp_Usb_setup_pkt.wLength;	
				queue_work(ptr_usb_simva_wqueue, (work_struct_t*)&usb_work_struct_in);
				/*statusiKɈȍ~Ȃ悤ɂ邽USB_GADGET_DELAYED_STATUSԂ*/
				return USB_GADGET_DELAYED_STATUS;
				
				break;
			case 0x01: /*CompatibleID̑Ή*/
				usb_work_struct_in.usb_setup.bmRequestType = Tmp_Usb_setup_pkt.bmRequestType;
				usb_work_struct_in.usb_setup.bRequest = Tmp_Usb_setup_pkt.bRequest;
				usb_work_struct_in.usb_setup.wValue = Tmp_Usb_setup_pkt.wValue;
				usb_work_struct_in.usb_setup.wIndex = Tmp_Usb_setup_pkt.wIndex;
				usb_work_struct_in.usb_setup.wLength = Tmp_Usb_setup_pkt.wLength;	
				queue_work(ptr_usb_simva_wqueue, (work_struct_t*)&usb_work_struct_in);
				return USB_GADGET_DELAYED_STATUS;
				break;
			default:
				value = wLength;
				break;
			}
		}
		else {
		/* AvʒmԂ */
			Notify_list.ntf_stat = NOTIFY_REQ_OFF;
		}

		break; /*case USB_TYPE_VENDOR*/

		/*Air PrintΉp(Device Info descriptorʒm)*/
		case USB_TYPE_STANDARD:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s\n",__func__);
			switch (ctrl->bRequest) {
				case USB_REQ_GET_DESCRIPTOR:
					switch (wValue >> 8) {
						case 0x21:
							USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:type HID_DESCRIPTIR\n",__func__);
							value = USB_SIZE_DEVINOFO_DESC;
							USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:data=%s\n",__func__,dev->dev_info_desc);
							memcpy(req->buf, dev->dev_info_desc, USB_SIZE_DEVINOFO_DESC);
						break;/*0x21*/
					default:
						/*Ȃ*/
						break; /*default*/
					}
				break; /*case USB_REQ_GET_DESCRIPTOR*/
			
				default:
				/*Ȃ*/
				break;/*default*/
			}
		break; /*case USB_TYPE_STANDARD*/
	default:
unknown:
		VDBG(dev,
			"unknown ctrl req%02x.%02x v%04x i%04x l%d\n",
			ctrl->bRequestType, ctrl->bRequest,
			wValue, wIndex, wLength);
		break;
	}
	/* host either stalls (value < 0) or reports success */
	if (value >= 0) {
		req->length = value;
		req->zero = value < wLength;
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:req->zero=%d\n",__func__,req->zero);
		ret = usb_ep_queue(cdev->gadget->ep0, req, GFP_ATOMIC);
		if (ret < 0) {
			ERROR(dev, "%s:%d Error!\n", __func__, __LINE__);
			req->status = 0;
		}
		Notify_list.ntf_stat = NOTIFY_REQ_OFF;
	}

	return ret;
}

static void _set_usbstate_off(struct printer_dev *dev, unsigned intf)
{
	int j = 0;
	int index;
	
	for(j=0;j<UCNEC2_MAX_IF_NUM;j++)
	{
		USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]intf:%d\n",intf );
		/*C^[tF[Xԍaltݒ肪Ƃusb_descriptor_headerɒǉ*/
		if((dev->hs_comdesc[j].inter_desc.bInterfaceNumber) == intf) 
		{
			index = get_TransferIndex_ep(dev->hs_comdesc[j].end_desc_out.bEndpointAddress);
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:index=%d\n",__func__,index);
			UNSET_BULKSTATE(dev->bulkout_state[index],UBS_DMA_ON);
			SET_BULKSTATE(dev->bulkout_state[index],UBS_IF_CHANGE);
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:dev->bulkout_state[%d]=%x\n",__func__,index,dev->bulkout_state[index]);
			break;
		}
	}
}

/*֐ݒmF*/
static int printer_func_set_alt(struct usb_function *f,
		unsigned intf, unsigned alt)
{
	struct printer_dev *dev = container_of(f, struct printer_dev, function);
	int ret = 0;
	if_comp_s_t *if_comp;
	struct usb_gadget *gadget;
	gadget = dev->gadget;

	/**Mac PCX[v쎞̑Ή**/
	/**set_interfaceŎ蓾configured̂Ƃ̂**/
	if(gadget->state != USB_STATE_CONFIGURED){
		usb_gadget_set_state(gadget, USB_STATE_CONFIGURED);
	}
	
	/* C^tF[XmF */
	if( UCNEC2_MAX_IF_NUM <= intf )
	{
		return -1;
	}
	
	if_comp = &(usb_dev_comp.if_comp[intf]);

	/* DebiannLinuxOS̖Ή
	 *	UbuntuȂDebianñfBXgr[Vł͈SET_INTERFACE
	 *	Ă邪YIFAltIFɂ͕ωȂB
	 *	̍ہAAltIFɕύXToggleNAsȂƃzXgToggle
	 *	svɂȂĂ܂ApPbgjĂ܂B
	 *	邽߂ɐݒύXo悤Ɉȉ̔s
	 */
	/*C^[tF[XԍƑ֐ݒl擾altݒ{B*/
	USBDEV_DPRINTK_ALERT(KERN_INFO "[USB_DEV]%s:inter[%x]alt[%x]\n",__func__,intf,alt);
	USBDEV_DPRINTK_ALERT(KERN_INFO "[USB_DEV]%s:if_comp->alt_set[%x]alt[%x]\n",__func__,if_comp->alt_set,alt);
	if(( if_comp->alt_set != (u8)alt ) || ( UCS_SETIF_RST == dev->setif_ctl )) {
		if (usbdev_isSetIF[intf] == 0) usbdev_isSetIF[intf] = 1;
		else
		usbdev_isSetIF[intf] = 0;
		if_comp->alt_set = alt;
		ret = set_interface(dev, intf, alt);
		_set_usbstate_off(dev, intf);
	}
	/*SIFSET_INTERFACEĂ΂ꂽDataXe[WɈڍsȂ*/
	if(chk_num_setif() == usb_interface_num)
	{
		USB_STATE_FLAG = 1;
		USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]%s:state[%d]=%x\n",__func__,0,dev->bulkout_state[0]);
		wake_up_interruptible(&ctl_poll_queue_state);
		ret = USB_GADGET_DELAYED_STATUS;
	}
	return ret;
}
/*֐ݒ擾*/
static int printer_func_get_alt(struct usb_function *f,unsigned intf)
{
	if_comp_s_t *if_comp;

	USBDEV_DPRINTK( KERN_INFO "%s:intf=%d\n",__func__,intf);
	/* C^tF[XmF */
	if( UCNEC2_MAX_IF_NUM <= intf )
	{
		return -1;
	}
	
	if_comp = &(usb_dev_comp.if_comp[intf]);
	USBDEV_DPRINTK( KERN_INFO "%s:alt_set=%d\n",__func__,if_comp->alt_set);
	return if_comp->alt_set;
}
	
static void printer_cfg_unbind(struct usb_configuration *c)
{
	struct printer_dev	*dev;
	struct usb_request	*req;
	int i = 0;

	USBDEV_DPRINTK( KERN_INFO "printer_cfg_unbind\n" );
	
	dev = &usb_printer_gadget;

	DBG(dev, "%s\n", __func__);

	/*ĐڑłȂȂ̂ňȉ2֐̌Ăяo̓RgAEg*/
	/* Remove sysfs files */
	//device_destroy(usb_gadget_class, usb_gadget_devno);
	/* Remove Character Device */
	//cdev_del(&dev->printer_cdev);
	for(i=0;i<usb_interface_num;i++)
	{
		#if 0
		/* we must already have been disconnected ... no i/o may be active */
		WARN_ON(!list_empty(&dev->tx_reqs_active[i]));
		WARN_ON(!list_empty(&dev->rx_reqs_active[i]));
		#endif

		/* Free all memory for this driver. */
		while (!list_empty(&dev->tx_reqs[i])) {
			req = container_of(dev->tx_reqs[i].next, struct usb_request,
					list);
			list_del(&req->list);
			printer_req_free(dev->in_ep[i], req);
		}
		#if 0
		if (dev->current_rx_req[i] != NULL)
			printer_req_free(dev->out_ep[i], dev->current_rx_req[i]);
		#endif
		while (!list_empty(&dev->rx_reqs[i])) {
			req = container_of(dev->rx_reqs[i].next,
					struct usb_request, list);
			list_del(&req->list);
			printer_req_free(dev->out_ep[i], req);
		}
		#if 0
		while (!list_empty(&dev->rx_buffers[i])) {
			req = container_of(dev->rx_buffers[i].next,
					struct usb_request, list);
			list_del(&req->list);
			printer_req_free(dev->out_ep[i], req);
		}
		#endif
	}
}

static struct usb_configuration printer_cfg_driver = {
	.label			= "printer",
	.unbind			= printer_cfg_unbind,
	.bConfigurationValue	= 1,
	.bmAttributes		= USB_CONFIG_ATT_ONE | USB_CONFIG_ATT_SELFPOWER,
};
	
/* C^tF[XfBXNv^̏AGh|Cg̏ݒ肷 */
static int printer_func_bind(struct usb_configuration *c,
		struct usb_function *f)
{
	struct printer_dev *dev = container_of(f, struct printer_dev, function);
	struct usb_composite_dev *cdev = c->cdev;
	int ret = 0;
	
	ret = __set_endpoint(dev,cdev, cdev->os_desc_config, &(dev->function));
	ret = __set_interface(dev,cdev, cdev->os_desc_config, &(dev->function));

	return ret;

}

static void printer_func_unbind(struct usb_configuration *c,
		struct usb_function *f)
{
	USBDEV_DPRINTK( KERN_INFO "printer_func_unbind\n" );
	usb_free_all_descriptors(f);
}

/*usb_function̖*/
static void printer_func_disable(struct usb_function *f)
{
	int i = 0;
	struct printer_dev *dev = container_of(f, struct printer_dev, function);
	//unsigned long		flags;
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s\n",__func__);
	USBDEV_DPRINTK( KERN_INFO "printer_func_disable\n" );
	DBG(dev, "%s\n", __func__);
	//spin_lock_irqsave(&dev->lock, flags);
	/*Gh|Cg֘ÃZbg*/
	for(i=0;i<usb_interface_num;i++)
	{
		printer_reset_interface(dev, i);
	}
	//spin_unlock_irqrestore(&dev->lock, flags);
	/*NX̍\̂̃Zbg*/
	reset_usb_simva(dev);
	//usb_composite_unregister(&printer_driver);
	/*Ԃ̊mF*/
	_isDevicestate(dev);
	//USB_STATE_FLAG = 1;
	//wake_up_interruptible(&ctl_poll_queue_state);
	
}

/* Comppsite driverusb_add_confiǧĂяo */
/* oN]p̎Mobt@Ɋ֘A郁o*/
static int printer_bind_config(struct usb_configuration *c)
{
	struct usb_gadget	*gadget = c->cdev->gadget;
	struct printer_dev	*dev;
	int			status = -ENOMEM;
	u32			i;
	u32	j;
	struct usb_request	*req;
	size_t size;

	USBDEV_DPRINTK( KERN_INFO "printer_bind_config\n" );
	
	usb_ep_autoconfig_reset(gadget);
	dev = &usb_printer_gadget;

	dev->function.name = shortname;
	dev->function.bind = printer_func_bind;
	dev->function.setup = printer_func_setup;
	dev->function.unbind = printer_func_unbind;
	dev->function.set_alt = printer_func_set_alt;
	dev->function.get_alt = printer_func_get_alt;
	dev->function.disable = printer_func_disable;

	status = usb_add_function(c, &dev->function);
	if (status)
		return status;

	usb_gadget_set_selfpowered(gadget);

	if (gadget_is_otg(gadget)) {
		otg_descriptor.bmAttributes |= USB_OTG_HNP;
		printer_cfg_driver.descriptors = otg_desc;
		printer_cfg_driver.bmAttributes |= USB_CONFIG_ATT_WAKEUP;
	}
	dev->interface = -1;
	dev->printer_status = PRINTER_NOT_ERROR;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]usb_interface_num:%d\n",usb_interface_num );
	for(j=0;j<usb_interface_num;j++)
	{
		dev->current_rx_req[j] = NULL;
		dev->current_rx_bytes[j] = 0;
		dev->current_rx_buf[j] = NULL;

		size = USB_BUFSIZE*NUM_USBREQ;
			dev->in_buf[j] = kmalloc(USB_BUFSIZE*NUM_USBREQ, GFP_ATOMIC|GFP_DMA);
			for (i = 0; i < NUM_USBREQ; i++) {
				req = printer_req_alloc(dev->in_ep[j], dev->in_buf[j], i ,USB_BUFSIZE, GFP_ATOMIC);
				if (!req) {
					USBDEV_DPRINTK( KERN_DEBUG "printer_req_alloc in req is NULL\n");
					while (!list_empty(&dev->tx_reqs[j])) {
						req = container_of(dev->tx_reqs[j].next,
								struct usb_request, list);
						list_del(&req->list);
						printer_req_free(dev->in_ep[j], req);
					}
					status = -ENOMEM;
					goto fail;
				}
				list_add(&req->list, &dev->tx_reqs[j]);
			}
			dev->out_buf[j] = kmalloc(USB_BUFSIZE*NUM_USBREQ, GFP_ATOMIC|GFP_DMA);
			for (i = 0; i < NUM_USBREQ; i++) {
				req = printer_req_alloc(dev->out_ep[j],dev->out_buf[j], i ,USB_BUFSIZE, GFP_ATOMIC);
				if (!req) {
					USBDEV_DPRINTK( KERN_DEBUG "printer_req_alloc out req is NULL\n");
					while (!list_empty(&dev->rx_reqs[j])) {
						req = container_of(dev->rx_reqs[j].next,
								struct usb_request, list);
						list_del(&req->list);
						printer_req_free(dev->out_ep[j], req);
					}
					status = -ENOMEM;
					goto fail;
				}
				list_add(&req->list, &dev->rx_reqs[j]);
			}
	}
	/* finish hookup to lower layer ... */
	dev->gadget = gadget;

	INFO(dev, "%s, version: " DRIVER_VERSION "\n", driver_desc);
	return 0;

fail:
	printer_cfg_unbind(c);
	return status;
}

static int printer_unbind(struct usb_composite_dev *cdev)
{
	USBDEV_DPRINTK( KERN_INFO "printer_unbind\n" );

	return 0;
}
/*Composite DriveřĂяo*/
static int printer_bind(struct usb_composite_dev *cdev)
{
	int ret;
	USBDEV_DPRINTK( KERN_INFO "__init printer_bind\n" );	
	/**SFPΉ**/
	if(!strcmp(strings[USB_STRDESC_SCN].s,""))
	{
		strings[USB_STRDESC_SCN].s = strings[USB_STRDESC_NUMee].s;
		strings[USB_STRDESC_SCN].id = strings[USB_STRDESC_NUMee].id;
		cdev->next_string_id = USB_STRDESC_SCN+1;
	}
	else{
		cdev->next_string_id = USB_STRDESC_NUMee+1;
	}
	/*Compatible IDΉ*/
	cdev->os_desc_config = &printer_cfg_driver;
	cdev->use_os_string = 1;
	cdev->b_vendor_code = 0x01;
	cdev->qw_sign[0] = 0x4D;
	cdev->qw_sign[1] = 0x00;
	cdev->qw_sign[2] = 0x53;
	cdev->qw_sign[3] = 0x00;
	cdev->qw_sign[4] = 0x46;
	cdev->qw_sign[5] = 0x00;
	cdev->qw_sign[6] = 0x54;
	cdev->qw_sign[7] = 0x00;
	cdev->qw_sign[8] = 0x31;
	cdev->qw_sign[9] = 0x00;
	cdev->qw_sign[10] = 0x30;
	cdev->qw_sign[11] = 0x00;
	cdev->qw_sign[12] = 0x30;
	cdev->qw_sign[13] = 0x00;

	ret = usb_add_config(cdev, &printer_cfg_driver, printer_bind_config);
	USBDEV_DPRINTK("[USB_DEV]usb_add_config ret = %d\n",ret);
	if (ret)
		return ret;
	usb_composite_overwrite_options(cdev, &coverwrite);
	return ret;
}

/*܂ŃKWFbg֘Ȁ*/
/*******************************************************/

/*VXeR[/zXg̏*/
/************************************************************
֐Fcmd_ucs_noncmd
FwriteUCS_NONCMDɑΉ֐BD+CONɂ 
***************************************************************/
static int cmd_ucs_noncmd(struct printer_dev *dev)
{
	int ret=0;
	int status;
	int i = 0;
	//char test[10] = {0x0a,0x21,0x01,0x01,0x00,0x04,0x11,0x00,0x00,0x00};
	//strlcpy(printer_driver.dev_info_desc, test, USB_SIZE_DEVINOFO_DESC);
	/*KWFbgt[̃oCh*/
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s,name:%s pid:%i\n",__func__,current->comm, current->pid);
	
#if 0
	if(dev->gadget_status == USB_GADGET_ON)
	{
		ret = usb_gadget_disconnect(dev->gadget);
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:usb_gadget_disconnect is ret=%d\n",__func__,ret);
		//ret = usb_gadget_unregister_driver(dev->gadget);
		printer_func_unbind(&printer_cfg_driver,&(dev->function));
		printer_cfg_unbind(&printer_cfg_driver);
		dev->reboot = 1;
		dev->gadget_status = USB_GADGET_OFF;
	}
#endif
	//if ((dev->gadget_status == USB_GADGET_OFF) && (dev->reboot == 0))
	if (dev->gadget_status == USB_GADGET_OFF)
	{
		
		/*pfoCXfBXNv^I*/
		if(printer_driver.max_speed == USB_SPEED_HIGH )
		{
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:hi-speed\n",__func__);
			printer_driver.dev = &device_desc_hs;
		}
		else
		{
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:full-speed\n",__func__);
			printer_driver.dev = &device_desc_fs;
		}
		
		status = usb_composite_probe(&printer_driver);
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:status=%d\n",__func__,status);
		if (status) {
			class_destroy(usb_gadget_class);
			unregister_chrdev_region(usb_gadget_devno, 1);
			pr_err("usb_gadget_probe_driver %x\n", status);
			/*DMAN𖳌ɂ*/
			for(i=0;i<usb_interface_num;i++)
			{
				UNSET_BULKSTATE(dev->bulkout_state[i],UBS_DMA_ENABLE);
			}
			return status;
		}
		//usb_gadget_connect(dev->gadget);
		
		for(i=0;i<usb_interface_num;i++)
		{
			/*DMAN\ɂ*/
			SET_BULKSTATE(dev->bulkout_state[i],UBS_DMA_ENABLE);
			SET_BULKSTATE(dev->bulkin_state[i],UBS_DMA_ENABLE);
		}
		dev->gadget_status = USB_GADGET_ON;
	}
#if 0
	else if ((dev->gadget_status == USB_GADGET_OFF) && (dev->reboot == 1))
	{
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:printer_bind_config\n",__func__);
		ret = printer_bind_config(&printer_cfg_driver);
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:printer_bind_config is ret=%d\n",__func__,ret);
		for(i=0;i<usb_interface_num;i++)
		{
			/*DMAN\ɂ*/
			SET_BULKSTATE(dev->bulkout_state[i],UBS_DMA_ENABLE);
			SET_BULKSTATE(dev->bulkin_state[i],UBS_DMA_ENABLE);
		}
		dev->gadget_status = USB_GADGET_ON;
		dev->reboot = 0;
		ret = usb_gadget_connect(dev->gadget);
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:usb_gadget_connect is ret=%d\n",__func__,ret);
	}
#endif
	else
	{
		USBDEV_DPRINTK( KERN_INFO "[USB_DEV]usb gadget already\n" );
	}

	//mutex_lock(&simva_usb_lock);
	Notify_list.ntf_stat = NOTIFY_REQ_OFF;
	return ret;
}
/************************************************************
֐Fset_device_desc
FWfoCXfBXNv^ݒ
T.B.D(ȉ̂݃T|[g)@̑̒l^CɍXVKvʓrmFB
        __le16 idVendor@y_ID
        __le16 idProduct@v_NgID
        __le16 bcdDevice
        __u8  iManufacturer
        __u8  iProduct
        __u8  iSerialNumber
***************************************************************/
static int set_device_desc(struct printer_dev *dev, struct usb_device_descriptor *device_desc, uc_write_t* buf)
{

	u8 *pbuf = buf->cont;
	dat_u dat;

	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]call set_device_desc\n");
	/*fBXNv^̃oɒlRs[Ă*/
	USBDEV_DPRINTK( KERN_DEBUG "=============SET DEVICE DESC=================\n");
	device_desc->bLength =	*pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]device_desc->bLengthd %x\n", device_desc->bLength);
	pbuf++;
	device_desc->bDescriptorType =	*pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]device_desc->bDescriptorType %x\n", device_desc->bDescriptorType);
	pbuf++;
	dat.string[0] = *pbuf;
	pbuf++;
	dat.string[1] = *pbuf;
	pbuf++;
	device_desc->bcdUSB =		cpu_to_le16(dat.tmp);
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]device_desc->bcdUSB %x\n", device_desc->bcdUSB);

	device_desc->bDeviceClass =		*pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]device_desc->bDeviceClass %x\n", device_desc->bDeviceClass);
	pbuf++;
	device_desc->bDeviceSubClass =	*pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]device_desc->bDeviceSubClass %x\n", device_desc->bDeviceSubClass);
	pbuf++;
	device_desc->bDeviceProtocol =	*pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]device_desc->bDeviceProtocol %x\n", device_desc->bDeviceProtocol);
	pbuf++;
	device_desc->bMaxPacketSize0 =	*pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]device_desc->bMaxPacketSize0 %x\n", device_desc->bMaxPacketSize0);
	pbuf++;
	dat.string[0] = *pbuf;
	pbuf++;
	dat.string[1] = *pbuf;
	pbuf++;
	device_desc->idVendor =		cpu_to_le16(dat.tmp);
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]device_desc->idVendor %x\n", device_desc->idVendor);
	dat.string[0] = *pbuf;
	pbuf++;
	dat.string[1] = *pbuf;
	pbuf++;
	device_desc->idProduct =	cpu_to_le16(dat.tmp);
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]device_desc->idProduct %x\n", device_desc->idProduct);
	//device_desc->idProduct = 0x0414;
	dat.string[0] = *pbuf;
	pbuf++;
	dat.string[1] = *pbuf;
	pbuf++;
	device_desc->bcdDevice = cpu_to_le16(dat.tmp);
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]device_desc->bcdDevice %x\n", device_desc->bcdDevice);
	device_desc->iManufacturer = *pbuf;
	strings[USB_GADGET_MANUFACTURER_IDX].id = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]device_desc->iManufacturer %x\n", device_desc->iManufacturer);
	pbuf++;
	device_desc->iProduct = *pbuf;
	strings[USB_GADGET_PRODUCT_IDX].id = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]device_desc->iProduct %x\n", device_desc->iProduct);
	pbuf++;
	device_desc->iSerialNumber = *pbuf;
	strings[USB_GADGET_SERIAL_IDX].id = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]device_desc->iSerialNumber %x\n", device_desc->iSerialNumber);
	pbuf++;
	device_desc->bNumConfigurations = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]device_desc->bNumConfigurations %x\n", device_desc->bNumConfigurations);
		
	return 0;

}

/************************************************************
֐Fset_config_desc
FRtBO[VfBXNv^ݒ
bLength,bDescriptorType,wTotalLength͂ŔfȂB
***************************************************************/
static int set_config_desc(struct printer_dev *dev, struct usb_configuration *cfg_driver, u8* pbuf)
{
	dat_u dat;
	int i =0;
	int ret = 0;
	pbuf = pbuf;
	/*bLength,bDescriptorType,wTotalLength̓XLbv*/
	for(i=0;i<4;i++)
	{
		pbuf++;
	}
	USBDEV_DPRINTK( KERN_DEBUG "=============SET CONFIG DESC=================\n");
	cfg_driver->next_interface_id = *pbuf; /*bNumInterfaces*/
	usb_interface_num = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]next_interface_id %x\n", cfg_driver->next_interface_id);
	pbuf++;
	cfg_driver->bConfigurationValue = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]bConfigurationValue %x\n", cfg_driver->bConfigurationValue);
	pbuf++;
	cfg_driver->iConfiguration = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]iConfiguration %x\n", cfg_driver->iConfiguration);
	pbuf++;
	cfg_driver->bmAttributes = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]bmAttributes %x\n", cfg_driver->bmAttributes);
	pbuf++;
	dat.string[0] = *pbuf;
	cfg_driver->MaxPower = cpu_to_le16(dat.tmp);
	return ret;
}
/************************************************************
֐Fset_inter_desc
FC^[tF[XfBXNv^ݒ
***************************************************************/
static int set_inter_desc(struct printer_dev *dev, struct usb_interface_descriptor *inter_desc, u8* pbuf, int count)
{
	int ret=0;
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]call set_inter_desc\n");
	USBDEV_DPRINTK( KERN_DEBUG "=============SET INTER DESC=================\n");
	inter_desc->bLength = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]inter_desc->bLength %x\n", inter_desc->bLength);
	pbuf++;
	inter_desc->bDescriptorType = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]inter_desc->bDescriptorType %x\n", inter_desc->bDescriptorType);
	pbuf++;
	inter_desc->bInterfaceNumber = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]inter_desc->bInterfaceNumber %x\n", inter_desc->bInterfaceNumber);
	pbuf++;
	inter_desc->bAlternateSetting = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]inter_desc->bAlternateSetting %x\n", inter_desc->bAlternateSetting);
	pbuf++;
	inter_desc->bNumEndpoints = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]inter_desc->bNumEndpoints %x\n", inter_desc->bNumEndpoints);
	pbuf++;
	inter_desc->bInterfaceClass = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]inter_desc->bInterfaceClass %x\n", inter_desc->bInterfaceClass);
	pbuf++;
	inter_desc->bInterfaceSubClass = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]inter_desc->bInterfaceSubClass %x\n", inter_desc->bInterfaceSubClass);
	pbuf++;
	inter_desc->bInterfaceProtocol = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]inter_desc->bInterfaceProtocol %x\n", inter_desc->bInterfaceProtocol);
	pbuf++;
	inter_desc->iInterface = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]inter_desc->iInterface %x\n", inter_desc->iInterface);
	
/**DEBUGp**/
#if 0
	if(inter_desc->bInterfaceNumber == 0x00 && inter_desc->bAlternateSetting == 0x00 &&
	inter_desc->bInterfaceProtocol ==0x02 ){
		USBDEV_DPRINTK( KERN_ALERT "[USB_DEV]inter_desc->iInterface %x\n", inter_desc->iInterface);
		inter_desc->iInterface = 0x04;
		USBDEV_DPRINTK( KERN_ALERT "[USB_DEV]inter_desc->iInterface %x\n", inter_desc->iInterface);
	}
#endif
/**DEBUGp**/
	
	return ret;
	
}
/************************************************************
֐Fset_end_desc
FGh|CgfBXNv^ݒ
***************************************************************/
static int set_end_desc(struct printer_dev *dev, struct usb_endpoint_descriptor *endpoint_desc, u8* pbuf)
{
	int ret=0;
	dat_u dat;
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]call set_end_desc\n");
	USBDEV_DPRINTK( KERN_DEBUG "=============SET END DESC=================\n");
	endpoint_desc->bLength = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]endpoint_desc->bLength %x\n", endpoint_desc->bLength);
	pbuf++;
	endpoint_desc->bDescriptorType = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]endpoint_desc->bDescriptorType %x\n", endpoint_desc->bDescriptorType);
	pbuf++;
	endpoint_desc->bEndpointAddress = *pbuf;
/*TMP*/
#if 0
	if(endpoint_desc->bEndpointAddress == 0x09)
	{
		endpoint_desc->bEndpointAddress = 0x0c;
	}
	if(endpoint_desc->bEndpointAddress == 0x82)
	{
		endpoint_desc->bEndpointAddress = 0x85;
	}
#endif
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]endpoint_desc->bEndpointAddress %x\n", endpoint_desc->bEndpointAddress);
	pbuf++;
	endpoint_desc->bmAttributes = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]endpoint_desc->bmAttributes %x\n", endpoint_desc->bmAttributes);
	pbuf++;
	dat.string[0] = *pbuf;
	pbuf++;
	dat.string[1] = *pbuf;
	pbuf++;
	endpoint_desc->wMaxPacketSize = cpu_to_le16(dat.tmp);
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]endpoint_desc->wMaxPacketSize %x\n", endpoint_desc->wMaxPacketSize);
	endpoint_desc->bInterval = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]endpoint_desc->bInterval %x\n", endpoint_desc->bInterval);
	//pbuf++;
	//endpoint_desc->bRefresh = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]endpoint_desc->bRefresh %x\n", endpoint_desc->bRefresh);
	//pbuf++;
	//endpoint_desc->bSynchAddress = *pbuf;
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]endpoint_desc->bSynchAddress %x\n", endpoint_desc->bSynchAddress);
	
	return ret;
}

/************************************************************
֐Fset_support_lang
F
***************************************************************/
static int set_support_lang(struct printer_dev *dev, uc_write_t* buf)
{
	int ret=0;
	u8 *pbuf = buf->cont;
	dat_u dat;
	/*3byteڂ4ByteڂۑČɐݒ肷*/
	pbuf++;
	pbuf++;
	dat.string[0] = *pbuf;
	pbuf++;
	dat.string[1] = *pbuf;
	stringtab_dev.language = cpu_to_le16(dat.tmp);
	return ret;
}

/************************************************************
writeFRg[] R}hUCS_STRDESCΉ
string descriptoro^
***************************************************************/
static int set_string_dec(struct printer_dev *dev, uc_write_t* buf, size_t len)
{
	int ret=0;
	//u8 *pbuf = buf->cont;
	int size = len - sizeof(uc_write_t)+1; 
	u8 index = buf->no;
	int i=0;
	int isExist = 0;
	
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]buf->no:%d\n",buf->no);

	if(dev->reboot != 1)
	{
		for(i=0;i<6;i++)
		{
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]strings[%d].id:%d\n",i,strings[i].id);
			if(strings[i].id == buf->no)
			{
				USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]before index:%d\n",index);
				index = i;
				isExist = 1;
				USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]change index:%d\n",index);			
				break;
			}
		}
			if (isExist){
					switch(index) {
						case USB_GADGET_MANUFACTURER_IDX:
							p_manufacture_string = kmalloc(size, GFP_ATOMIC);
							if(p_manufacture_string)
							{
								strlcpy(p_manufacture_string, buf->cont,size);
								strings[USB_GADGET_MANUFACTURER_IDX].s = p_manufacture_string;
								USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]string[USB_GADGET_MANUFACTURER_IDX]:%s\n",p_manufacture_string);
							}
						break;
						case USB_GADGET_PRODUCT_IDX:
							p_product_string = kmalloc(size, GFP_ATOMIC);
							if(p_product_string)
							{
								strlcpy(p_product_string, buf->cont,size);
								strings[USB_GADGET_PRODUCT_IDX].s = p_product_string;
								USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]string[USB_GADGET_PRODUCT_IDX]:%s\n",p_product_string);
							}
						break;
						case USB_GADGET_SERIAL_IDX:
							p_serial_string = kmalloc(size, GFP_ATOMIC);
							if(p_serial_string)
							{
								strlcpy(p_serial_string, buf->cont,size);
								strings[USB_GADGET_SERIAL_IDX].s = p_serial_string;
								//strings[USB_GADGET_SERIAL_IDX].s = "D223-000010";
								USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]string[USB_GADGET_SERIAL_IDX]:%s\n",p_serial_string);
							}
						break;

						case USB_STRDESC_PRN: /*UCO_STRDESC_PRN*/
							p_print_string = kmalloc(size, GFP_ATOMIC);
							if(p_print_string)
							{
								strlcpy(p_print_string, buf->cont,size);
								strings[USB_STRDESC_PRN].s = p_print_string;
								USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]string:%s\n",p_print_string);
							}
						break;
					
						case USB_STRDESC_SCN:/*UCO_STRDESC_SCN*/
							p_scan_string = kmalloc(size, GFP_ATOMIC);
							if(p_scan_string)
							{
								strlcpy(p_scan_string, buf->cont,size);
								strings[USB_STRDESC_SCN].s = p_scan_string;
								USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]string:%s\n",p_scan_string);
							}
						break;
						case USB_STRDESC_NUMee:/*UCO_STRDESC_SCN*/
							p_NUMee_string = kmalloc(size-1, GFP_ATOMIC);
							if(p_NUMee_string)
							{
								strlcpy(p_NUMee_string, buf->cont,size-1);
								strings[USB_STRDESC_NUMee].s = p_NUMee_string;
								USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]string:%s\n",p_NUMee_string);
							}
							break;
						default:
							break;
					}
			}
	}
	return ret;
}

/************************************************************
writeFRg[] R}hUCS_DEVQFRDESCΉ
device qualifier descriptoro^
***************************************************************/
static int set_qualifier_desc(struct printer_dev *dev, struct usb_qualifier_descriptor *qualifier_desc, uc_write_t* buf)
{
	u8 *pbuf = buf->cont;
	dat_u dat;
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]call set_device_desc\n");
	/*fBXNv^̃oɒlRs[Ă*/
	qualifier_desc->bLength =	*pbuf;
	pbuf++;
	qualifier_desc->bDescriptorType =	*pbuf;
	pbuf++;
	dat.string[0] = *pbuf;
	pbuf++;
	dat.string[1] = *pbuf;
	pbuf++;
	qualifier_desc->bcdUSB =		cpu_to_le16(dat.tmp);
	qualifier_desc->bDeviceClass =		*pbuf;
	pbuf++;
	qualifier_desc->bDeviceSubClass =	*pbuf;
	pbuf++;
	qualifier_desc->bDeviceProtocol =	*pbuf;
	pbuf++;
	qualifier_desc->bMaxPacketSize0 =	*pbuf;
	pbuf++;
	qualifier_desc->bNumConfigurations = *pbuf;
	pbuf++;
	qualifier_desc->bRESERVED = *pbuf;
	return 0;

}

/************************************************************
֐Fdevid_list_free
DEVICE IDtB[h̃Xg
***************************************************************/
static int devid_list_free(struct devid_list *listp)
{
	struct devid_list *p, *prev;
	p = listp;
	while(p != NULL){
		if(p->devid_data != NULL){
			kfree(p->devid_data);
		}
		prev = p;
		p = p->next;
		if(prev != NULL){
			kfree(prev);
		}
	}
	
	return 0;
}

/************************************************************
writeFRg[] R}hUCS_CLASSDESCΉ
DEVICE IDtB[hɕăXg쐬
***************************************************************/
static int devid_list_create(u8* pbuf, struct devid_list **listp)
{
	u8 *field_tail;
	int field_len;
	struct devid_list **p; 
	struct devid_list *newp = NULL;
	for( p = &(*listp); *pbuf!= '\0'; p = &(newp->next), pbuf = pbuf + field_len) {
		newp = kmalloc(sizeof(struct devid_list), GFP_ATOMIC);
		if(newp == NULL){
			devid_list_free(*listp);
			return -ENOMEM;
		}		
		field_tail = strchr(pbuf, ';');
		field_len = field_tail - pbuf + 1;
		USBDEV_DPRINTK( KERN_DEBUG "[USB]%s:field_len=%d\n",__func__,field_len);
		/*
		*  ';'ŏIĂȂꍇStrchrNULLł͂Ȃ + 1̃AhXԂB
		*   + 1̃AhX̎ɂclass_desc_create()'\0'ݒ肳ĂB
		*/
		if(*field_tail == '\0'){
			/* ̎_newp̎̈̓XgɌqĂȂ */
			kfree(newp);
			devid_list_free(*listp);
			return EINVAL;
		}

		newp->devid_len = field_len;
		newp->devid_data = kmalloc(field_len + 1, GFP_ATOMIC);
		if(newp->devid_data == NULL){
			/* ̎_newp̎̈̓XgɌqĂȂ */
			kfree(newp);
			devid_list_free(*listp);
			return ENOMEM;
		}
		/* ̍ŌɏI[t^ */
		(newp->devid_data)[field_len] = '\0';
		strncpy(newp->devid_data, pbuf, field_len);
		newp->next = NULL;
		*p = newp;
	}
	return 0;
}
/************************************************************
֐Fdevid_update
DEVICE IDtB[hɍXV
***************************************************************/
static int devid_update(struct printer_dev *dev, u8 *pbuf)
{
	struct devid_list *newlist;
	struct devid_list *p;
	u8 *field_tail, *key_tail, *tmp;
	int field_len, key_len, compare;
	u8 *old_data = NULL;
	u8 *p_current = &pnp_string[2];
	size_t			len = 0;
	int error = 0;
	u8 workbuf[USB_WORK_BUFF];
	u8 *work;
	struct devid_list *tmp_p;
	int ret = 0;
	unsigned long flags;
	unsigned long spin_flags;

	USBDEV_DPRINTK( KERN_DEBUG "[USB]%s:pbuf=%s\n",__func__,pbuf);
	
	/* DEVICE_IDXg쐬 */
	newlist = NULL;
	ret = devid_list_create(&pnp_string[2],&newlist);
	USBDEV_DPRINTK( KERN_DEBUG "[USB]ret=%d\n",ret);
	if(error){
		return (error);
	}
	/*
	* XVGET_DEVICE_IDNGXgs
	* DEVICE IDłȂ\邽߁AMׂł͂ȂB
	* XVGET_DEVICE_IDNGXgMȂ悤ɂ邽ߊ݋֎~ɂB
	*/
	spin_lock_irqsave(&printer_mutex, flags);
	dev->dev_listp = newlist;
	spin_unlock_irqrestore(&printer_mutex, flags);

	tmp_p = dev->dev_listp;

	/* L[̒o */
	compare = 0;
	key_tail = strchr(pbuf, ':');
	key_len = key_tail - pbuf + 1;
	if(*key_tail == '\0'){
		return EINVAL;
	}
	
	/* f[^̒o */
	field_tail = strchr(pbuf, ';');
	field_len = field_tail - pbuf + 1;
	if(*field_tail == '\0'){
		return EINVAL;
	}
	
	/*v镔u*/
	for( p = dev->dev_listp; p != NULL; p = p->next){
		compare = strncmp(pbuf, p->devid_data, key_len);
		if(compare == 0)
			break;
	}
	if(p == NULL){
		/* v */
		return -EINVAL;
	}

	USBDEV_DPRINTK( KERN_DEBUG "[USB]:field_len=%d\n",field_len);
	tmp = kmalloc(field_len + 1, GFP_ATOMIC);
	if(tmp == NULL){
		return -ENOMEM;
	}
	USBDEV_DPRINTK( KERN_DEBUG "[USB]:tmp=%x\n",tmp);
	memset(tmp, '\0', field_len);
	/* ̍ŌɏI[t^ */
	(tmp)[field_len] = '\0';
	strncpy(tmp, pbuf, field_len);
	//USBDEV_DPRINTK( KERN_ALERT "[USB]:tmp=%s\n",tmp);
	/*
	* XVGET_DEVICE_IDNGXgs
	* DEVICE IDłȂ\邽߁AMׂł͂ȂB
	* XVGET_DEVICE_IDNGXgMȂ悤ɂ邽ߊ݋֎~ɂB
	*/
	spin_lock_irqsave(&printer_mutex, spin_flags);
	p->devid_len = field_len;
	/* freepɑޔ */
	old_data = p->devid_data;
	p->devid_data = tmp;
	USBDEV_DPRINTK( KERN_DEBUG "[USB]:p->devid_data=%s\n",p->devid_data);
	spin_unlock_irqrestore(&printer_mutex, spin_flags);
	/* j */
	kfree(old_data);

	memset(workbuf, '\0', USB_WORK_BUFF);
	work = &workbuf[0];
	len = 0;
	/*tB[h̃Xg}[W*/
	for( p = dev->dev_listp; p != NULL; work = work + p->devid_len, p = p->next){
		len = len + p->devid_len;
		/* I[l +1 */
		if(USB_WORK_BUFF < len + 1){
			return -1;
		}
		memcpy(work, p->devid_data,p->devid_len);
	}
	len = strlen(workbuf)+2;
	strlcpy(&pnp_string[2],workbuf,len);
	pnp_string[len] = '\0';
	pnp_string[0] = (len >> 8) & 0xFF;
	pnp_string[1] = len & 0xFF;
	p_current=&pnp_string[2];

	/*pnp_stringɃRs[svȂ̂ō폜*/
	devid_list_free(newlist);

	//kfree(tmp);
	return 0;
}
/************************************************************
writeFRg[] R}hUCS_CLASSDESCΉ
class specific descriptor̓o^
***************************************************************/
static int set_class_desc(struct printer_dev *dev, u8 *pbuf, int total)
{
	size_t			len;
	u8 *p_current = NULL;
	
	/*z̏s*/
	memset(pnp_string,'\0',USB_STRINGS_SIZE);
	USBDEV_DPRINTK( KERN_DEBUG "[USB]%s:pbuf=%s\n",__func__,pbuf);
	len = strlen(pbuf)+2;
	//len = total;
	/*I[NULLݒ肷*/
	strlcpy(&pnp_string[2], pbuf, len);
	pnp_string[len] = '\0';
	p_current = &pnp_string[2];

	USBDEV_DPRINTK( KERN_DEBUG "[USB]%s:len=%d\n",__func__,len);
	USBDEV_DPRINTK( KERN_DEBUG "[USB]%s:pnp_string=%s\n",__func__,p_current);
	pnp_string[0] = (len >> 8) & 0xFF;
	pnp_string[1] = len & 0xFF;
#if 0
	/* DEVICE_IDXg쐬 */
	newlist = NULL;
	devid_list_create(&pnp_string[2],&newlist);
	if(error){
		return (error);
	}
	/*
	* XVGET_DEVICE_IDNGXgs
	* DEVICE IDłȂ\邽߁AMׂł͂ȂB
	* XVGET_DEVICE_IDNGXgMȂ悤ɂ邽ߊ݋֎~ɂB
	*/
	mutex_lock(&printer_mutex);
	oldlist = dev->dev_listp;
	dev->dev_listp = newlist;
	mutex_unlock(&printer_mutex);
	devid_list_free(oldlist);

	/*mFp(ۂ͔񓋍)*/
	for( p = dev->dev_listp; p != NULL; p = p->next){
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]list[%d]%s\n",i, p->devid_data);
		i++;
	}
#endif
	return 0;
}

/************************************************************
zXgɑM|[g̏ԂXV
*************************************************************/
static int set_usb_port_status(struct printer_dev *dev, uc_write_t* buf)
{	
	dev->printer_status = buf->cont[0];
	return 0;
}
/************************************************************
zXgɑM|[g̏ԂXV
*************************************************************/
static int set_usb_port_speed(struct printer_dev *dev, uc_write_t* buf)
{
	/*KWFbghCooChĂ邩*/
	//if(dev->gadget_status == USB_GADGET_ON)
	//{
	//	/* D+OFFɂ */
	//	if(!usb_gadget_disconnect(dev->gadget))
	//	{
	//	USBDEV_DPRINTK(KERN_INFO "[USB_DEV]usb_gadget_disconnect is fail\n");
	//	}
	//}
	/*x̐ݒ{*/
	if (buf->no == UCS_FS_FIXED)
	{
		printer_driver.max_speed = USB_SPEED_FULL;
	}
	else
	{
		printer_driver.max_speed = USB_SPEED_HIGH;
	}
	/*KWFbghCooChĂ邩*/
	//if(dev->gadget_status == USB_GADGET_ON)
	//{
	//	/* D+ONɂ */
	//	if(!usb_gadget_connect(dev->gadget)){
	//		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]usb_gadget_disconnect is fail\n");
	//	}
	//}
	return 0;
}
	
/************************************************************
writeFRg[] R}hUCS_DEVINFOΉ
device info descriptor̓o^
***************************************************************/
static int set_devinfo_desc(struct printer_dev *dev, u8* buf)
{

	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s\n",__func__);
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:data=%.10s\n",__func__,dev->dev_info_desc);
	
	memcpy(dev->dev_info_desc, buf, USB_SIZE_DEVINOFO_DESC);
	memcpy(printer_driver.dev_info_desc, buf, USB_SIZE_DEVINOFO_DESC);

	return 0;
}
	
/************************************************************
writeFRg[] R}hUCS_SETIF_CTLΉ
device info descriptor̓o^
***************************************************************/
static int set_ctrl_setif(struct printer_dev *dev, uc_write_t* buf)
{

	/* softc\̂ɕۑ */
	if( UCS_SETIF_RST == buf->no ) {
		dev->setif_ctl = buf->no;
	}
	else {
		/* sȒl UCS_SETIF_NORMAL ɂĂ */
		dev->setif_ctl = UCS_SETIF_NORMAL;
	}
	return 0;
}
	
/************************************************************
writeFRg[]
*************************************************************/
static int exe_control_write(struct printer_dev *dev, char* buf, size_t len, unsigned int index)
{
	int ret = 0;
	//int offset = 0;
	int current_total = 0;
	int current_inte = 0;
	int current_epin = 0;
	int current_epout = 0;
	u8 desc_size = 0;
	u8 desc_type = 0;
	int num_total = len - sizeof(uc_write_t);
	u8 *pbuf = NULL;
	uc_write_t *w_buf;
	int cnt_func_desc = 0;
	
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]exe_control_write\n");
	if(buf == NULL)
	{
		return -1;
	}
	w_buf = (uc_write_t*)buf;
	if (len < sizeof(uc_write_t)){
		USBDEV_DPRINTK_ALERT( KERN_ALERT "[USB_DEV]%s:(len < sizeof(uc_write_t))\n",__func__);
		return -EINVAL;
	}

	pbuf = w_buf->cont;
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:cmd[%d]\n",__func__,w_buf->cmd);
	switch(w_buf->cmd) {
		case UCS_NONCMD:
			cmd_ucs_noncmd(dev);
			break;
		case UCS_STDDESC_FS:
			dev->num_inter_fs = 0;
			set_device_desc(dev, &device_desc_fs, w_buf);
			break;
		case UCS_STDDESC_HS:
			dev->num_inter_hs = 0;
			set_device_desc(dev, &device_desc_hs, w_buf);
			break;
		case UCS_CONFDESC_FS:
		case UCS_CONFDESC_HS:
			set_config_desc(dev, &printer_cfg_driver, pbuf);
			break;
		case UCS_MCONFDESC_FS:
			USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:num_total=%d\n", __func__,num_total);
			/*RtBO[VfBXNv^擾*/
			set_config_desc(dev, &printer_cfg_driver, pbuf);
			//offset += USB_DT_CONFIG_SIZE;
			pbuf = pbuf + USB_DT_CONFIG_SIZE;
			current_total += USB_DT_CONFIG_SIZE;
			/*܂͍ŏ\*/
			while(current_total < num_total)
			{
				USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:current_total=%d\n", __func__,current_total);
				desc_size = *pbuf;
				desc_type = *(pbuf+1);
				switch(desc_type) {
					case USB_DT_INTERFACE:
						set_inter_desc(dev, &(dev->fs_comdesc[current_inte].inter_desc), pbuf,current_inte);
						fs_usb_function_ipp[cnt_func_desc] = (struct usb_descriptor_header *)&(dev->fs_comdesc[current_inte].inter_desc);
						current_inte++;
						dev->num_inter_fs=dev->num_inter_fs+1;
					break;
					case USB_DT_ENDPOINT:
						if ( (*(pbuf+2) >>7 ) == USB_DIR_OUT)
						{
							//set_end_desc(dev, array_fs_ep_out_desc[current_epout], pbuf);
							set_end_desc(dev, &(dev->fs_comdesc[current_epout].end_desc_out), pbuf);
							fs_usb_function_ipp[cnt_func_desc] = (struct usb_descriptor_header *)&(dev->fs_comdesc[current_epout].end_desc_out);
							current_epout++;
						}
						else
						{
							//set_end_desc(dev, array_fs_ep_in_desc[current_epin], pbuf);
							set_end_desc(dev, &(dev->fs_comdesc[current_epin].end_desc_in), pbuf);
							fs_usb_function_ipp[cnt_func_desc] = (struct usb_descriptor_header *)&(dev->fs_comdesc[current_epin].end_desc_in);
							current_epin++;
						}
					break;
					case 0x21: /*device info desc̒`0x21̂߂̒l𗘗p*/
					//T.B.D device info descriptoro^
						set_devinfo_desc(dev, pbuf);
						//fs_usb_function_ipp[cnt_func_desc] = (struct usb_descriptor_header *)&(dev->dev_info_desc);
						cnt_func_desc--;
					break;
					default:
						cnt_func_desc--;
					/*C^[tF[XfBXNv^̐݌v*/
					break;					
				}
				pbuf += desc_size;
				current_total += desc_size;
				cnt_func_desc++;
			}
			fs_usb_function_ipp[cnt_func_desc] = NULL;
			break;
		case UCS_STATE:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]This command not support:%d\n",w_buf->cmd);
			break;
		case UCS_MCONFDESC_HS:
			USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:num_total=%d\n", __func__,num_total);
			/*RtBO[VfBXNv^擾*/
			set_config_desc(dev, &printer_cfg_driver, pbuf);
			//offset += USB_DT_CONFIG_SIZE;
			pbuf = pbuf + USB_DT_CONFIG_SIZE;
			current_total += USB_DT_CONFIG_SIZE;
			/*܂͍ŏ\*/
			while(current_total < num_total)
			{
				USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:current_total=%d\n", __func__,current_total);
				desc_size = *pbuf;
				desc_type = *(pbuf+1);
				switch(desc_type) {
					case USB_DT_INTERFACE:
						set_inter_desc(dev, &(dev->hs_comdesc[current_inte].inter_desc), pbuf,current_inte);
						hs_usb_function_ipp[cnt_func_desc] = (struct usb_descriptor_header *)&(dev->hs_comdesc[current_inte].inter_desc);
						current_inte++;
						dev->num_inter_hs=dev->num_inter_hs+1;
					break;
					case USB_DT_ENDPOINT:
						if ( (*(pbuf+2) >>7 ) == USB_DIR_OUT)
						{
							USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]ep out\n");
							//set_end_desc(dev, array_hs_ep_out_desc[current_epout], pbuf);
							set_end_desc(dev, &(dev->hs_comdesc[current_epout].end_desc_out), pbuf);
							hs_usb_function_ipp[cnt_func_desc] = (struct usb_descriptor_header *)&(dev->hs_comdesc[current_epout].end_desc_out);
							current_epout++;
						}
						else
						{
							USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]ep in\n");
							//set_end_desc(dev, array_hs_ep_in_desc[current_epin], pbuf);
							set_end_desc(dev, &(dev->hs_comdesc[current_epin].end_desc_in), pbuf);
							hs_usb_function_ipp[cnt_func_desc] = (struct usb_descriptor_header *)&(dev->hs_comdesc[current_epin].end_desc_in);
							current_epin++;
						}
					break;
					case 0x21: /*device info desc̒`0x21̂߂̒l𗘗p*/
					//T.B.D device info descriptoro^
					set_devinfo_desc(dev, pbuf);
					cnt_func_desc--;
					//hs_usb_function_ipp[cnt_func_desc] = (struct usb_descriptor_header *)&(dev->dev_info_desc);
					break;
					default:
					cnt_func_desc--;
					/*C^[tF[XfBXNv^̐݌v*/
					break;					
				}
				pbuf += desc_size;
				current_total += desc_size;
				cnt_func_desc++;
			}
			hs_usb_function_ipp[cnt_func_desc] = NULL;
		break;
		case UCS_STRDESC:
			set_string_dec(dev, w_buf,len);
			break;
		case UCS_OSCDESC:
				/*T.B.D*/
			break;
		case UCS_DEVQFRDESC:
				set_qualifier_desc(dev, &dev_qualifier, w_buf);
			break;
		case UCS_CLASSDESC:
				pbuf[num_total] = '\0';
				set_class_desc(dev, pbuf,num_total);
			break;
		case UCS_CLASSDESCEXT:
		case UCS_CLASSDESCEXT2:
			pbuf[num_total] = '\0';
			devid_update(dev, pbuf);
			break;
		case UCS_PORT_STATUS:
			set_usb_port_status(dev, w_buf);
			break;
		case UCS_SUPPORTLANG:
			set_support_lang(dev, w_buf);
			break;
		case UCS_OSC_MDESC:
				/*T.B.D*/
			break;
		case UCS_CHGSPEED:
			set_usb_port_speed(dev, w_buf);
			break;
		case UCS_DESC_CLR:
			/*usbdŌĂяoȂ߁AT|[g*/
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]This command not support:%d\n",w_buf->cmd);
			break;
		case UCS_D_PLUS_ON:
			/*usbdŌĂяoȂ߁AT|[g*/
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]This command not support:%d\n",w_buf->cmd);
			break;
		case UCS_D_PLUS_OFF:
			/*usbdŌĂяoȂ߁AT|[g*/
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]This command not support:%d\n",w_buf->cmd);
			break;
		case UCS_RESET:
			/*usbdŌĂяoȂ߁AT|[g*/
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]This command not support:%d\n",w_buf->cmd);
			break;
		case UCS_ERR_TEST:
			/*usbdŌĂяoȂ߁AT|[g*/
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]This command not support:%d\n",w_buf->cmd);
		break;
		case UCS_DEVINFO:
			set_devinfo_desc(dev, pbuf);
			//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]This command not support:%d\n",w_buf->cmd);
		break;
		case UCS_SETIF_CTL:
			set_ctrl_setif(dev, w_buf);
		
		break;
		default:
			ret = -EINVAL;
			break;

	}
	
	//USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]%sret = %d\n",__FUNCTION__,ret);
	return ret;
}

/************************************************************
writeFoNAEg]
*************************************************************/
static int exe_bulkout_write(struct printer_dev *dev, void* buf, size_t len, unsigned int index)
{
	int ret=0;
	ubo_write_t *w_buf;
	struct usb_request		*req;

	USBDEV_DPRINTK(KERN_INFO "[USB_DEV]exe_bulkout_write\n");
	
	if(buf == NULL)
	{
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]exe_bulkout_write buf=NULL\n");
		return -1;
	}
	if (len < sizeof(ubo_write_t))
		return -EINVAL;
	
	w_buf = (ubo_write_t*)buf;
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]w_buf->cmd=%lu\n",w_buf->cmd);
	switch(w_buf->cmd) {
		//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]w_buf->cmd:%lu\n",w_buf->cmd);
		case UBO_NONE:/* ǂݍ݂ɗpĂobt@J*/
				USBDEV_DPRINTK(KERN_INFO "[USB_DEV]w_buf->cmd=UBO_NONE\n");
				USBDEV_DPRINTK(KERN_INFO "[USB_DEV]w_buf->size=%lu\n",w_buf->size);
				USBDEV_DPRINTK(KERN_INFO "[USB_DEV]dev->current_rx_bytes=%d\n",dev->current_rx_bytes[index]);
				req = dev->current_rx_req[index];
				req->actual = 0;
				list_add(&(dev->current_rx_req[index]->list), &dev->rx_reqs[index]);
				dev->current_rx_bytes[index] = 0;
				dev->current_rx_buf[index] = NULL;
				dev->current_rx_req[index] = NULL;
#if 1 /*ishihara*/
				if(dev->gadget_status == USB_GADGET_ON)
				{
					setup_rx_reqs(dev,index);
				}
#endif
				ret = len;
			break;
		case UBO_DMASTART:
				USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]UBS_DMA_ON[%d]\n",index);
				SET_BULKSTATE(dev->bulkout_state[index],UBS_DMA_ON);
#if 1 /*ishihara*/
				if(dev->gadget_status == USB_GADGET_ON)
				{
					setup_rx_reqs(dev,index);
				}
#endif
				ret = len;
			break;
		case UBO_DMASTOP:
				UNSET_BULKSTATE(dev->bulkout_state[index],UBS_DMA_ON);
				if(dev->out_ep[index] != NULL)
				{
				while(likely(!list_empty(&dev->rx_buffers[index]))){
					req = container_of(dev->rx_buffers[index].next,
							struct usb_request, list);
					usb_ep_dequeue(dev->out_ep[index], req);
					}
				}
				ret = len;
			break;
		case UBO_BUFFLUSH:
			/*YGh|Cg̃tbV{*/
			usb_ep_fifo_flush(dev->out_ep[index]);
			ret = len;
			break;
		case UBO_DMAHOLD:/*ps*/
			break;
		case UBO_DMARESTART:/*ps*/
			break;
		default:
			break;
	}
	return ret;
}
/************************************************************
writeFoNC]
*************************************************************/
static int exe_bulkin_write(struct printer_dev *dev, void* buf, size_t len, unsigned int f_flags, unsigned int index)
{
	int ret=sizeof(ubi_write_t);
	int tmp = 0;
	//int	tx_list_empty;
	//unsigned long		flags;
	ubi_write_t *w_buf;
	//size_t			size = 0;	/* Amount of data in a TX request. */
	struct usb_request	*req;
	size_t length;
	struct transfer_index *tx_index;
	//int error;
	
	/* `FbN */
	if(buf == NULL)
	{
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]buf == NULL\n");
		return -1;
	}
	if (len < sizeof(ubi_write_t))
	{
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]len < sizeof(ubi_write_t)d\n");
		return -EINVAL;
	}
	tx_index = &dev->tx_index[index];
	tx_index->index = index;
	w_buf = (ubi_write_t*)buf;
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]w_buf->cmd:%lu,index:%d\n",w_buf->cmd,index);
	switch(w_buf->cmd) {
		case UBI_STATUS:
			/*SIMVAłtx_completeŏ{̂ŁAőΉ͂Ȃ*/
			break;
		case UBI_DMASTART:
			/*DMÅJnONɂ*/
			SET_BULKSTATE(dev->bulkin_state[index],UBS_DMA_ON);
			break;
		case UBI_DMASTOP:
			
			/*DMA̓~*/
			UNSET_BULKSTATE(dev->bulkin_state[index],UBS_DMA_ON);
			if(dev->in_ep[index] != NULL)
			{
				while(likely(!list_empty(&dev->tx_reqs_active[index]))){
					req = container_of(dev->tx_reqs_active[index].next,
							struct usb_request, list);
					usb_ep_dequeue(dev->in_ep[index], req);
				}
			}		
			break;
		case UBI_FLUSH:
			/*YGh|Cg̃tbV{*/
			usb_ep_fifo_flush(dev->in_ep[index]);

			break;
		case UBI_IRP_START:
		case UBI_DATA_CONTINUE:
		case UBI_IRP_END:
			length = w_buf->size;
			dev->reset_printer = 0;
			USBDEV_DPRINTK(KERN_INFO "[USB_DEV]length=%lu\n",w_buf->size);
#if 0
			/* Check if there is any available write buffers */
			if (likely(list_empty(&dev->tx_reqs))) {
				/* Turn interrupts back on before sleeping. */
				spin_unlock_irqrestore(&dev->lock, flags);
				/* Sleep until a write buffer is available */
				wait_event_interruptible(dev->tx_wait,
						(likely(!list_empty(&dev->tx_reqs))));
				spin_lock_irqsave(&dev->lock, flags);
			}
#endif
			//while (likely(!list_empty(&dev->tx_reqs)) && length ) {
			//if(likely(!list_empty(&dev->tx_reqs))) {
			if(dev->current_tx_req[w_buf->start][index]) {
				req = dev->current_tx_req[w_buf->start][index];
				list_del_init(&req->list);
				req->complete = tx_complete;
				req->length = length;
				req->context = tx_index;
				USBDEV_DPRINTK(KERN_INFO "[USB_DEV]%s:req->buf=%x\n",__func__,req->buf);
				/*f[^]ÎƂreq->zeroLɂ*/
				if((w_buf->cmd == UBI_IRP_END))
				{
					USBDEV_DPRINTK(KERN_INFO "[USB_DEV]req->zero\n");
					req->zero = 1;
				}
				else
				{
					req->zero = 0;
				}
 
				if (dev->reset_printer) {
					list_add(&req->list, &dev->tx_reqs[index]);
					return -EAGAIN;
				}
				
				tmp = usb_ep_queue(dev->in_ep[index], req, GFP_ATOMIC);
				USBDEV_DPRINTK(KERN_INFO "[USB_DEV]%s:tmp=%x\n",__func__,tmp);
				/*f[^𑗐M邱Ƃusb gadgetɒʒm*/
				if (tmp) {
					list_add(&req->list, &dev->tx_reqs[index]);
					return -EAGAIN;
				}
				list_add(&req->list, &dev->tx_reqs_active[index]);
			}

		break;

		case UBI_DMAHOLD:
			/*ps*/
			break;
		case UBI_DMARESTART:
			/*ps*/
			break;
		default:
			break;

	}
		return ret;
}

/************************************************************
readFRg[]@ostate̎擾
*************************************************************/
static u_char exe_control_read_state(struct printer_dev *dev, void* buf, size_t len)
{
	struct usb_gadget *gadget;
	u_char state;
	uc_read_t *r_buf;

	gadget = dev->gadget;
	state = 0;
	r_buf = (uc_read_t*)buf;
	if(r_buf->cmd == UCG_STATE)
	{
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s gadget->state=%d\n",__func__,gadget->state);
		switch(gadget->state) {
			case USB_STATE_ATTACHED:
				state = UCST_ATTACHED;		/* Attached */
				break;
			case USB_STATE_POWERED:
				state = UCST_POWERED;		/* Attached+Powered */
				break;
			case USB_STATE_DEFAULT:
			case USB_STATE_ADDRESS:
			case USB_STATE_SUSPENDED:		/* T.B.D(USBhCoIFdlɒ`) */
				state = UCST_ADDRESS;		/* Address(DefaultԊ܂) */
				break;
			case USB_STATE_CONFIGURED:
				if( dev->call_attached == 0)
				{
					dev->call_attached = 1;
					dev->current_state = UCST_ATTACHED;
					state = UCST_ATTACHED;
				}
				else
				{
					dev->cnt_notify_usbd = dev->cnt_notify_usbd+1 /*ʒm񐔂JEg*/;
					state = UCST_CONFIGURED;	/* Configured */
				}
				break;
			case USB_STATE_NOTATTACHED:
			case USB_STATE_RECONNECTING:	/* T.B.D(USBhCoIFdlɒ`) */
			case USB_STATE_UNAUTHENTICATED:	/* T.B.D(USBhCoIFdlɒ`) */
			default:
				state = UCST_NOT_ATTACHED;	/* NotAttached */
				break;
		}
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s state=%d\n",__func__,state);
		_isDevicestate(dev);
	}
	else	/* UCG_CTLDATA */
	{
		state = Ctl_data.data_no;	/* NGXgʔ */
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s req_no=%d\n",__func__,state);
	}
	return state;
}
/************************************************************
readFRg[]@osub_state̎擾
*************************************************************/
static u_int32_t exe_control_read_sub_state(struct printer_dev *dev, void* buf, size_t len)
{
	u_int32_t sub_state;
	uc_read_t *r_buf;
	//struct usb_ctrlrequest *ctrl;

	sub_state = 0;
	r_buf = (uc_read_t*)buf;
	if(r_buf->cmd == UCG_STATE)
	{
		sub_state = 0;						/* T.B.D(gadget\̂ɃG[񂪖) */
	}
	else	/* UCG_CTLDATA */
	{
		//ctrl = (struct usb_ctrlrequest *)Ctl_data.setup_pkt;
		//sub_state = ctrl->wLength;	/* f[^pPbg */
		sub_state = Usb_setup_pkt.wLength;
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s sub_state=%d\n",__func__,sub_state);
	}
	return sub_state;
}
/************************************************************
readFRg[]@osub_info̎擾
*************************************************************/
static u_char exe_control_read_sub_info(struct printer_dev *dev, void* buf, size_t len, unsigned int index)
{
	struct usb_gadget *gadget;
	u_char sub_info;
	uc_read_t *r_buf;

	gadget = dev->gadget;
	sub_info = 0;
	r_buf = (uc_read_t*)buf;

	if(r_buf->cmd == UCG_STATE)
	{
		/* 4bit: USB][h */
		if(gadget->speed == USB_SPEED_HIGH)
		{
			sub_info |= GWUSB_HIGHSPEED;
		}
		else	/* USB_SPEED_FULL */
		{
			sub_info |= GWUSB_FULLSPEED;
		}
		
		/* 4bit: USB샂[h v^̐ݒŔfsB*/
		if(dev->current_alt == 0x01){
			USBDEV_DPRINTK( KERN_DEBUG "%s check\n",__func__);
			sub_info |= GWUSB_MODE_IPP;	/*IPPݒ*/
			//USB_STATE_FLAG = 0;
		}
		else{
			sub_info |= GWUSB_MODE_LEGACY;	/*ʏ*/
		}
		if(chk_num_setif()){
			sub_info |= GWUSB_CHANGE_IFINFO;	/*IFύXL*/
		}
	}
	else	/* UCG_CTLDATA */
	{
		//ctrl = (struct usb_ctrlrequest *)Ctl_data.setup_pkt;
		if(Usb_setup_pkt.wIndex == 0x0002)	/* MIBf[^M(0x0002) */
		{
			sub_info = UC_DIR_OUT;
		}
		else						/* MIBf[^M(0x0004) */
		{
			sub_info = UC_DIR_IN;
		}
	}
	return sub_info;
}

/************************************************************
readFRg[]
*************************************************************/
static int exe_control_read(struct printer_dev *dev, char __user *u_buf, void* buf, size_t len, unsigned int f_flags, unsigned int index)
{
	int ret=0;
	uc_read_t *r_buf;
	unsigned long		flags;
	int tmp = 0;
	
	DBG(dev, "%s\n", __func__);

	if(f_flags & (O_NONBLOCK|O_NDELAY)) {
		return -EAGAIN;
	}
	
	mutex_lock(&dev->lock_printer_io);
	spin_lock_irqsave(&dev->lock, flags);

	r_buf = (uc_read_t*)buf;
	
	/*f[ɒʒmR}hzXg̒ʒm̗LŔf*/
	if(Ctl_data.data_no == 0)
	{
		r_buf->cmd = UCG_STATE;
	}
	else
	{
		r_buf->cmd = UCG_CTLDATA;
	}
	switch(r_buf->cmd) {
		case UCG_STATE:
		case UCG_CTLDATA:
			r_buf->state     = exe_control_read_state(dev, buf, len);
			USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:r_buf->state=%d\n",__func__,r_buf->state);
			r_buf->sub_state = exe_control_read_sub_state(dev, buf, len);
			USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:r_buf->sub_state=%d\n",__func__,r_buf->sub_state);
			r_buf->sub_info  = exe_control_read_sub_info(dev, buf, len, index);
			USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:r_buf->sub_info=%x\n",__func__,r_buf->sub_info);
			//gif (r_buf->sub_info == 0x00 ) queue_work(ptr_usb_simva_wqueue, (work_struct_t*)&usb_work_struct);
			r_buf->cont[0]   = 0;	/* gp */
			ret = sizeof(uc_read_t);
			break;
		case UCG_NONCMD:
		default:
			ret = -EINVAL;
			break;
	}
	
	tmp = copy_to_user(u_buf, buf, len);
#if 0
	if(copy_to_user(u_buf, buf, len)<0)
	{
		return -EFAULT;
	}
#endif

	spin_unlock_irqrestore(&dev->lock, flags);
	mutex_unlock(&dev->lock_printer_io);
	return ret;
	
}

/************************************************************
readFoNAEg]@Xe[^X̎擾
*************************************************************/
static u_long exe_bulkout_read_status(struct printer_dev *dev, void* buf, size_t len, unsigned int index)
{
	u_long status;

	DBG(dev, "%s\n", __func__);
	status = dev->bulkout_state[index];			/* T.B.D */

	return status;
}

#if 0
static u_long exe_bulkout_read_offset(struct printer_dev *dev, void* buf, size_t len)
{
	u_long offset;
	//ubo_read_t *r_buf;

	DBG(dev, "%s\n", __func__);
	offset = (u_long)dev->current_rx_buf;	/* T.B.D */

	return offset;
}

static u_long exe_bulkout_read_size(struct printer_dev *dev, void* buf, size_t len)
{
	u_long size;

	DBG(dev, "%s\n", __func__);
	size = (u_long)dev->current_rx_bytes;	/* T.B.D */

	return size;
}
#endif
		
/************************************************************
readFoNAEg]
*************************************************************/
static int exe_bulkout_read(struct printer_dev *dev, char __user *u_buf, void* buf, size_t len, unsigned int f_flags, unsigned int index)
{
	int ret=0;
	ubo_read_t *r_buf;
	
	unsigned long		flags;
	size_t				size=0;
	struct usb_request		*req;
	/* This is a pointer to the current USB rx request. */
	struct usb_request		*current_rx_req;
	/* This is the number of bytes in the current rx buffer. */
	size_t				current_rx_bytes;
	/* This is a pointer to the current rx buffer. */
	u8				*current_rx_buf;
	int tmp = 0;
	
	DBG(dev, "%s\n", __func__);
	r_buf = (ubo_read_t*)buf;

	mutex_lock(&dev->lock_printer_io);
	spin_lock_irqsave(&dev->lock, flags);
	
	/*tO𗎂Ƃ*/
	dev->isSetIF_dev[index] = 0;
	
	/*tO̎wɌ`FbN*/
	if(f_flags & (O_NONBLOCK|O_NDELAY)) {
		r_buf->status = exe_bulkout_read_status(dev, buf, len,index);
		r_buf->offset = 0;
		r_buf->size   = 0;
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]f_flags & (O_NONBLOCK|O_NDELAY)\n");
		spin_unlock_irqrestore(&dev->lock, flags);
		mutex_unlock(&dev->lock_printer_io);
		return -EAGAIN;
	}
	
	dev->reset_printer = 0;
	
	current_rx_req = dev->current_rx_req[index];
	current_rx_bytes = dev->current_rx_bytes[index];
	current_rx_buf = dev->current_rx_buf[index];
	dev->current_rx_req[index] = NULL;
	dev->current_rx_bytes[index] = 0;
	dev->current_rx_buf[index] = NULL;

	/*rx_buffersobt@擾*/
	if(likely(!list_empty(&dev->rx_buffers[index]))){
		USBDEV_DPRINTK(KERN_INFO "[USB_DEV]likely(!list_empty(&dev->rx_buffers))\n");
		if (current_rx_bytes == 0) {
			USBDEV_DPRINTK(KERN_INFO "[USB_DEV](current_rx_bytes == 0)\n");
			req = container_of(dev->rx_buffers[index].next,
					struct usb_request, list);
			list_del_init(&req->list);
			if (req->actual && req->buf) {
				USBDEV_DPRINTK(KERN_INFO "[USB_DEV](req->actual && req->buf)\n");
				current_rx_req = req;
				current_rx_bytes = req->actual;
				current_rx_buf = req->buf;
			} else {
				USBDEV_DPRINTK(KERN_INFO "[USB_DEV]else_(req->actual && req->buf)\n");
				list_add(&req->list, &dev->rx_reqs[index]);
				//continue;
			}
		}

		/* Don't leave irqs off while doing memory copies */
		size = current_rx_bytes;
		
		if( (size == USB_EP_MAXPACKET(dev->gadget)) && likely(list_empty(&dev->rx_buffers[index])))
		{
			UNSET_BULKSTATE(dev->bulkout_state[index],UBS_IRP_START);
			UNSET_BULKSTATE(dev->bulkout_state[index],UBS_IN_TRANS);
			SET_BULKSTATE(dev->bulkout_state[index],UBS_IRP_END);
			USBDEV_DPRINTK(KERN_INFO "[USB_DEV]=max=UBS_IRP_END\n");
		}
		/**fBXNv^ʂƈȉ̃f[^TCŶƂIRPI**/
		else if(size < USB_EP_MAXPACKET(dev->gadget))
		{
			UNSET_BULKSTATE(dev->bulkout_state[index],UBS_IRP_START);
			UNSET_BULKSTATE(dev->bulkout_state[index],UBS_IN_TRANS);
			SET_BULKSTATE(dev->bulkout_state[index],UBS_IRP_END);
			USBDEV_DPRINTK(KERN_INFO "[USB_DEV]UBS_IRP_END\n");
		}
		else
		{
			SET_BULKSTATE(dev->bulkout_state[index],UBS_IN_TRANS);
		}
		
		r_buf->status = exe_bulkout_read_status(dev, buf, len, index);
		r_buf->offset = current_rx_buf - dev->out_buf[index];
		r_buf->size   = size;
		tmp = copy_to_user(u_buf, r_buf, len);

		/* We've disconnected or reset so return. */
		if (dev->reset_printer) {
			list_add(&current_rx_req->list, &dev->rx_reqs[index]);
			spin_unlock_irqrestore(&dev->lock, flags);
			mutex_unlock(&dev->lock_printer_io);
			return -EAGAIN;
		}

		ret = sizeof(ubo_read_t);

	}
	/*obt@̂Ƃǉ*/
	else{
		r_buf->status = dev->bulkout_state[index];
		r_buf->offset = 0;
		r_buf->size   = 0;
		tmp = copy_to_user(u_buf, r_buf, len);

		if(((dev->bulkout_state[index])&UBS_IF_CHANGE ) == UBS_IF_CHANGE)
		{
			UNSET_BULKSTATE(dev->bulkout_state[index],UBS_IF_CHANGE);
			SET_BULKSTATE(dev->bulkout_state[index],UBS_IF_CHANGED); 
		}
		else if(((dev->bulkout_state[index])&UBS_IF_CHANGED ) == UBS_IF_CHANGED)
		{
			UNSET_BULKSTATE(dev->bulkout_state[index],UBS_IF_CHANGED);
		}
		else{
		}
		USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]%s:state[%d]=%x\n",__func__,index,dev->bulkout_state[index]);
#if 0
		/*dataiKւ̈ȍ~ƃtO𗎂Ƃ*/
		if(dev->isSetIF_dev[index] ==1)
		{
			dev->isSetIF_dev[index] = 0;
			if(((dev->bulkout_state[index])&UBS_IF_CHANGE ) == UBS_IF_CHANGE)
			{
				UNSET_BULKSTATE(dev->bulkout_state[index],UBS_IF_CHANGE);
				SET_BULKSTATE(dev->bulkout_state[index],UBS_IF_CHANGED);
			}
			if(((dev->bulkout_state[index])&UBS_IF_CHANGED ) == UBS_IF_CHANGED)
			{
				UNSET_BULKSTATE(dev->bulkout_state[index],UBS_IF_CHANGED);
			}
			printk(KERN_ALERT "[USB_DEV]%s:state=%x\n",__func__,dev->bulkout_state[index]);
		}
#endif
	}
	dev->current_rx_req[index] = current_rx_req;
	dev->current_rx_bytes[index] = current_rx_bytes;
	dev->current_rx_buf[index] = current_rx_buf;

	spin_unlock_irqrestore(&dev->lock, flags);
	mutex_unlock(&dev->lock_printer_io);
	ret = sizeof(ubo_read_t);
	return ret;
}

/************************************************************
readFoNC]@Xe[^X̎擾
***************************************************************/
static u_long exe_bulkin_read_status(struct printer_dev *dev, void* buf, size_t len, unsigned int index)
{
	u_long status;

	DBG(dev, "%s\n", __func__);
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s: dev->bulkin_state=%x\n",__func__,dev->bulkin_state[index]);
	status = dev->bulkin_state[index];
	return status;
}
#if 0
static u_long exe_bulkin_read_start(struct printer_dev *dev, void* buf, size_t len)
{
	u_long start;

	DBG(dev, "%s\n", __func__);
	start = 0;							/* T.B.D */

	return start;
}

static u_long exe_bulkin_read_size(struct printer_dev *dev, void* buf, size_t len)
{
	u_long size;

	DBG(dev, "%s\n", __func__);
	size = 0;							/* T.B.D */

	return size;
}
#endif

/************************************************************
readFoNC]
***************************************************************/
static int exe_bulkin_read(struct printer_dev *dev, char __user *u_buf, void* buf, size_t len, unsigned int f_flags, unsigned int index)
{
	int ret=0;
	ubi_read_t *r_buf;
	unsigned long		flags;	
	size_t			size;	/* Amount of data in a TX request. */
	struct usb_request	*req;
	int tmp =0;

	DBG(dev, "%s\n", __func__);
	r_buf = (ubi_read_t*)buf;

	if (len < sizeof(ubi_read_t) )
		return -EINVAL;

	if (dev->gadget_status == USB_GADGET_OFF)
		return -ENODEV;

	
	mutex_lock(&dev->lock_printer_io);
	spin_lock_irqsave(&dev->lock, flags);

	dev->reset_printer = 0;
	
	/*󂫃obt@Ȃꍇ͏I*/
	/*KWFbgŋNꍇFstatus = DMA_OFF KWFbgNFDESC_FULL*/
	if (likely(list_empty(&dev->tx_reqs[index]))) {
		r_buf->status= exe_bulkin_read_status(dev, buf, len, index);
		r_buf->status= r_buf->status | UBS_DESC_FULL;
		r_buf->start = 0;
		r_buf->size  = 0;
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:status=%x\n",__func__,r_buf->status);
		tmp = copy_to_user(u_buf, r_buf, len);
		ret = sizeof(ubi_read_t);
		
		/***************fobOp*********************/
		/*Gh|Cg𖳌ɂăobt@ɂ*/
		//ret = usb_ep_disable(dev->in_ep[index]);
		//USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]%s:usb_ep_disable(dev->in_ep[%d])=%d\n",__func__,index,ret);
		
		
		spin_unlock_irqrestore(&dev->lock, flags);
		mutex_unlock(&dev->lock_printer_io);
		return ret;
	}

	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]exe_bulkin_read\n");
	/*݂̃JgusbNGXg\̂擾*/
    req =  container_of(dev->tx_reqs[index].next, struct usb_request,list);

	r_buf->status= exe_bulkin_read_status(dev, buf, len, index);
	r_buf->start = ((u8 *)req->buf - dev->in_buf[index])/USB_BUFSIZE;
	size = USB_BUFSIZE;
	//size = 64;
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:r_buf->status=%d\n",__func__,r_buf->status);
	r_buf->size  = size;
	dev->current_tx_req[r_buf->start][index] = req;

	tmp = copy_to_user(u_buf, r_buf, len);

	/* We've disconnected or reset so free the req and buffer */
	if (dev->reset_printer) {
		list_add(&req->list, &dev->tx_reqs[index]);
		spin_unlock_irqrestore(&dev->lock, flags);
		mutex_unlock(&dev->lock_printer_io);
		return -EAGAIN;
	}

	ret = sizeof(ubi_read_t);
	spin_unlock_irqrestore(&dev->lock, flags);
	mutex_unlock(&dev->lock_printer_io);
	return ret;

}
/************************************************************
ioctlFIOCGEPCONFɑΉ֐
***************************************************************/
static int get_ioctl_epconf(struct printer_dev *dev, unsigned long arg)
{
	usb_epconf_t epconf;
	int i =0;
	int count =0;
	int tmp = 0;
	struct usb_device_descriptor *pdevic_desc;
	dat_u value;

	/*pfoCXfBXNv^I*/
	if(printer_driver.max_speed == USB_SPEED_HIGH )
	{
		pdevic_desc = &device_desc_hs;
	}
	else
	{
		pdevic_desc = &device_desc_fs;
	}

	/*USBdl̃[Xԍ*/
	value.tmp = pdevic_desc->bcdUSB;
	epconf.bcdusb[0] = value.string[0];
	epconf.bcdusb[1] = value.string[1];
	/*foCXo[W̐ݒ*/
	epconf.ver = pdevic_desc->bcdDevice;
	/*ep0̐ݒ*/
	epconf.epinfo[0].epno = 0;
	epconf.epinfo[0].epattr = USB_TRANSTYPE_CONTROL;
	/*]͑oȂ̂ŉݒ肷̂*/
	
	/*oNC]EP*/
	for( i = 0; i < UCNEC2_MAX_IF_NUM; i++ ) {
		epconf.epinfo[count].epno = SIMVA_EP_IN_START + i;
		epconf.epinfo[count].epattr = USB_ENDPOINT_XFER_BULK;
		epconf.epinfo[count].epdir = USB_DIR_IN;
		count++;
	}
	/*oNAEg]EP*/
	for( i = 0; i < UCNEC2_MAX_IF_NUM; i++ ) {
		epconf.epinfo[count].epno = SIMVA_EP_OUT_START + i;
		epconf.epinfo[count].epattr = USB_ENDPOINT_XFER_BULK;
		epconf.epinfo[count].epdir = USB_DIR_OUT;
		count++;		
	}
	
	epconf.numep = count;
	
	/*[U[ԂɃRs[*/
	tmp = copy_to_user((void __user *) arg, (const void *)&epconf,sizeof(usb_epconf_t));
	
	return 0;
}
/************************************************************
ioctlFIOCSEPINFOɑΉ֐ LPUXڐA
***************************************************************/
static int set_ioctl_epinfo(struct printer_dev *dev, unsigned long arg)
{
	uc_interface_info_t if_inf;
	if_comp_s_t *if_comp;
	int i,j;
	int if_num = 0;
	int tmp=0;

	/*[U[Ԃ̏J[lԂɃRs[*/
	tmp = copy_from_user(&if_inf, (uc_interface_info_t*)arg, sizeof(uc_interface_info_t));
	
	if_inf.alt_setting_num = 1;
	USBDEV_DPRINTK(KERN_DEBUG "%x \n",if_inf.alt_setting_num );
	USBDEV_DPRINTK(KERN_DEBUG "%x \n",if_inf.interface_num );
	/* p[^`FbN */
	if(( UCNEC2_MAX_IF_NUM <= if_inf.interface_num ) ||
	   ( UCNEC2_MAX_IFALT_NUM <= if_inf.alt_setting_num )) {
		/* w肳ꂽC^tF[X( or )ԍ\͒l𒴂Ă */
	   	USBDEV_DPRINTK(KERN_DEBUG "set_ioctl_epinfo EINVAL \n" );
		return -EINVAL;
	}
	
	/* ΏۃC^tF[X̕ۑ̈փ|Cg */
	if_comp = &(usb_dev_comp.if_comp[if_inf.interface_num]);
	
		/* ݒ肳ꂽGh|Cg\ۑ */
		if_comp->is_set = 1; /* ݒԂ */
		//if_comp->alt_set = 0; /* ݂̑փC^tF[X0ɖ߂ */
		if_comp->alt_num = if_inf.alt_setting_num;
		for( i = 0; i < UCNEC2_MAX_IFALT_NUM; i++ ) {
			for( j = 0; j < UCNEC2_MAX_EP_NUM; j++ ) {
				if_comp->ep_comp[i][j] = if_inf.ep_info[i][j];
				if( 0x00 != if_comp->ep_comp[i][j] ) {
					set_endpoint_state(if_comp->ep_comp[i][j]);
					USBDEV_DPRINTK(KERN_DEBUG "ep_comp[%d][%d] -> %02x\n",
									i, j, if_comp->ep_comp[i][j] );
				}
			}
		}
	
	/* ݒσC^tF[XmFێĂlXV */
		for( i = 0; i < UCNEC2_MAX_IF_NUM; i++ ) {
			if( usb_dev_comp.if_comp[i].is_set ) {
				if_num++;
			}
		}
		usb_dev_comp.if_num = if_num;
		USBDEV_DPRINTK(KERN_DEBUG "%s: IOCSEPINFO setting total if_num=%d\n",
						__FUNCTION__,
						usb_dev_comp.if_num );
	return 0;
}
	
/**********************************************************************
ioctlFR}hIOCGIFINFOΉ
***********************************************************************/
static int get_ioctl_ifinfo(struct printer_dev *dev, unsigned long arg)
{
	uc_interface_getinfo_t if_getinfo;
	if_comp_s_t *if_comp;
	int i;
	int tmp=0;

	USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]%s\n",__func__);
	/*[U[Ԃ̏J[lԂɃRs[*/
	tmp = copy_from_user(&if_getinfo, (uc_interface_getinfo_t*)arg, sizeof(uc_interface_getinfo_t));
	
	/* փC^tF[X1x0xFFŏ */
	(void)memset( if_getinfo.alt_setting_now, 0xFF, UCNEC2_MAX_IF_NUM );
	/* ݂̑փC^tF[Xԍ擾(gpC^tF[X) */
	for(i=0;i<usb_interface_num;i++)
	{
		/* C^tF[X擾 */
		if_comp = &(usb_dev_comp.if_comp[i]);
		if_getinfo.alt_setting_now[i] = if_comp->alt_set;
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:dev->bulkout_state[%d]=%x\n",__func__,i,dev->bulkout_state[i]);
		/* Gh|Cg̕RtĂȂlԂ */
		//if( if_comp->is_set != 0 )
		//{
		//	if_getinfo.alt_setting_now[i] = if_comp->alt_set;
		//}
		
	}
	/*L[}~̑Ή͓Ȃ*/
	
	/*[U[ԂɃRs[*/
	if (copy_to_user((void __user *)arg, (const void *)&if_getinfo, sizeof(uc_interface_getinfo_t)))
	{
		USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]%s:fail copy_to_user[%d]\n",__func__,__LINE__);
		return -EFAULT;
	}
	
	return 0;
}
/**********************************************************************
ioctlFR}hIOCGEPSTATEΉ
***********************************************************************/
static int get_ioctl_epstate(struct printer_dev *dev, unsigned long arg)
{
	uc_ep_getstate_t if_epstate;
	int i;
	int tmp=0;

	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s\n",__func__);
	/*[U[Ԃ̏J[lԂɃRs[*/
	tmp = copy_from_user(&if_epstate, (uc_ep_getstate_t*)arg, sizeof(uc_ep_getstate_t));
	
	/* փC^tF[X1x0xFFŏ */
	(void)memset( if_epstate.ep_dma_state, 0xFF, UCNEC2_MAX_IF_NUM );
	/* ݂̑փC^tF[Xԍ擾(gpC^tF[X) */
	for(i=0;i<usb_interface_num;i++)
	{
		USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:dev->bulkout_state[%d]=%x\n",__func__,i,dev->bulkout_state[i]);
		if_epstate.ep_dma_state[i] = dev->bulkout_state[i];
	}

	/*[U[ԂɃRs[*/
	if (copy_to_user((void __user *)arg, (const void *)&if_epstate, sizeof(uc_ep_getstate_t)))
	{
		USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]%s:fail copy_to_user[%d]\n",__func__,__LINE__);
		return -EFAULT;
	}
	
	/*L[}~̑Ή͓Ȃ*/
	return 0;
}
/**********************************************************************
ioctlFR}hIOCSNOTIFYREQΉ
***********************************************************************/
static int set_ioctl_notifyreq(struct printer_dev *dev, unsigned long arg)
{
	uc_notify_req_t if_req;
	int idx = 0;
	int ret = 0;
	int i = 0;
	int tmp = 0;

	/*[U[Ԃ̏J[lԂɃRs[*/
	tmp = copy_from_user(&if_req, (uc_notify_req_t*)arg, sizeof(uc_notify_req_t));
	/*USBDEV_DPRINTK(KERN_ALERT" list[send] [%02x][%02x][%02x][%02x][%02x][%02x][%02x][%02x] chk_type=%d\n",
							if_req.setup_pkt[0],
							if_req.setup_pkt[1],
							if_req.setup_pkt[2],
							if_req.setup_pkt[3],
							if_req.setup_pkt[4],
							if_req.setup_pkt[5],
							if_req.setup_pkt[6],
							if_req.setup_pkt[7],
							if_req.len_check_type
							);
	*/
	ret = search_ioctl_notifyreq(dev, if_req.setup_pkt, &idx);
	//USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]search_ioctl_notifyreq = %d \n",ret);
	if( ret == 0 ) { /* Xgo^̃NGXg */
		/* o^ς݃NGXg`FbN */
		if( UC_MAX_NOTIFY_REQ <= Notify_list.Notify_cnt ) {
			/* o^I[o[ */
			USBDEV_DPRINTK_ALERT(KERN_ALERT
					"%s: Request list over (%d)\n",
					__FUNCTION__,
					Notify_list.Notify_cnt );
			return -EINVAL;
		}
		
		/* i[ꏊ󂯂 */
		for( i = Notify_list.Notify_cnt; idx <= i; i-- ) {
			if(i+1 < UC_MAX_NOTIFY_REQ)
			{
				Notify_list.Notify_req[i + 1] = Notify_list.Notify_req[i];
			}
			else
			{
				USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s: Notify_list.Notify_cnt is over\n",__func__);
			}
		}
		
		/* Xgo^CNg */
		Notify_list.Notify_cnt++;
	}
	
	/* Xgo^ */
	Notify_list.Notify_req[idx] = if_req;

	USBDEV_DPRINTK(KERN_DEBUG
					"%s: list set idx=%d total=%d\n",
					__FUNCTION__,
					idx, Notify_list.Notify_cnt);
#if 0
	for( i = 0; i < Notify_list.Notify_cnt; i++ ) {
	USBDEV_DPRINTK(KERN_DEBUG" list[%d] [%02x][%02x][%02x][%02x][%02x][%02x][%02x][%02x] chk_type=%d\n",
							i,
							Notify_list.Notify_req[i].setup_pkt[0],
							Notify_list.Notify_req[i].setup_pkt[1],
							Notify_list.Notify_req[i].setup_pkt[2],
							Notify_list.Notify_req[i].setup_pkt[3],
							Notify_list.Notify_req[i].setup_pkt[4],
							Notify_list.Notify_req[i].setup_pkt[5],
							Notify_list.Notify_req[i].setup_pkt[6],
							Notify_list.Notify_req[i].setup_pkt[7],
							Notify_list.Notify_req[i].len_check_type
							);
	}
#endif
	return ret;
}
/**********************************************************************
ioctlFR}hIOCDNOTIFYREQΉ
***********************************************************************/
static int del_ioctl_notifyreq(struct printer_dev *dev, unsigned long arg)
{
	uc_notify_req_t if_req;
	int ret = 0;
	int i = 0;
	int idx = 0;
	int tmp = 0;
	
	/*[U[Ԃ̏J[lԂɃRs[*/
	tmp = copy_from_user(&if_req, (uc_notify_req_t*)arg, sizeof(uc_notify_req_t));
	
	/* NGXgXg */
	ret = search_ioctl_notifyreq(dev, if_req.setup_pkt, &idx);
	if( ret == 0 ) {
		/* Xgɑ݂Ȃ */
			USBDEV_DPRINTK_ALERT(KERN_ALERT
					"%s: Request list over (%d)\n",
					__FUNCTION__,
					Notify_list.Notify_cnt );
			return -EINVAL;
	}
	
	/* Xgړƍ폜 */
	for( i = idx; i < ( Notify_list.Notify_cnt - 1 ); i++ ) {
		Notify_list.Notify_req[i] = Notify_list.Notify_req[i + 1];
	}
	(void)memset( &Notify_list.Notify_req[i + 1], 0, sizeof( uc_notify_req_t ));
	
	/* Xgo^fNg */
	Notify_list.Notify_cnt--;
	
	USBDEV_DPRINTK(KERN_DEBUG
					"%s: list set idx=%d total=%d\n",
					__FUNCTION__,
					idx, Notify_list.Notify_cnt);
#if 0
	for( i = 0; i < Notify_list.Notify_cnt; i++ ) {
	USBDEV_DPRINTK(KERN_DEBUG" list[%d] [%02x][%02x][%02x][%02x][%02x][%02x][%02x][%02x] chk_type=%d\n",
							i,
							Notify_list.Notify_req[i].setup_pkt[0],
							Notify_list.Notify_req[i].setup_pkt[1],
							Notify_list.Notify_req[i].setup_pkt[2],
							Notify_list.Notify_req[i].setup_pkt[3],
							Notify_list.Notify_req[i].setup_pkt[4],
							Notify_list.Notify_req[i].setup_pkt[5],
							Notify_list.Notify_req[i].setup_pkt[6],
							Notify_list.Notify_req[i].setup_pkt[7],
							Notify_list.Notify_req[i].len_check_type
							);
	}
#endif
	
	return ret;
}


/**********************************************************************
ioctlFR}hIOCGCTLDATAΉ
***********************************************************************/
static int get_ioctl_ctldata(struct printer_dev *dev, unsigned long arg)
{
	uc_ctl_data_t tmp_if_data;
	uc_ctl_data_t *p_if_data=(uc_ctl_data_t*)arg;
	int ret = 0;
	int tmp = 0;
	u_int8_t dir = 0;
	u_char *tmp_data = NULL;

	/*[U[Ԃ̏J[lԂɃRs[*/
	tmp=copy_from_user( &tmp_if_data, (uc_ctl_data_t*)arg, sizeof(uc_ctl_data_t));
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s\n",__func__);
	/* AvʒmNGXgʒmmF */
	if( NOTIFY_REQ_ON != Notify_list.ntf_stat ) {
		/* ʒmł͂Ȃ */
		USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]%s: Request is not notify\n",
				__FUNCTION__ );
		return -EINVAL;
	}

	/* NGXgʔԊmF */
	if( Ctl_data.data_no != Notify_list.ntf_cnt ) {
		/* vȂ */
		USBDEV_DPRINTK_ALERT(KERN_ALERT
				"[USB_DEV]%s: Request No is unmatch api(%d) dev(%d)\n",
				__FUNCTION__,
				Ctl_data.data_no,
				Notify_list.ntf_cnt );
		return -EINVAL;
	}
	
	/* f[^mF(ControlOUT̏ꍇ̂) */
	dir = REQ_DIR( Usb_setup_pkt.bmRequestType );
	if(( USB_DIR_OUT == dir ) && 
	   ( Ctl_data.data_len != Usb_setup_pkt.wLength )) {
		/* vȂ */
		USBDEV_DPRINTK_ALERT(KERN_ALERT
				"[USB_DEV]%s: Request size is unmatch api(%d) dev(%d)\n",
				__FUNCTION__,
				Ctl_data.data_len,
				Usb_setup_pkt.wLength );
		return -EINVAL;
	}
	//tmp=copy_from_user( tmp_if_data->, p_if_data->data_pkt, tmp_if_data->data_len);
	/* setuppPbgݒ */
	memcpy(tmp_if_data.setup_pkt, Ctl_data.setup_pkt, UC_SETUP_PTK_SIZE);
	tmp_if_data.data_len = Usb_setup_pkt.wLength;
	tmp_if_data.data_no = Ctl_data.data_no;
	if( USB_DIR_OUT == dir )
	{
		//if_data.data_pkt = Ctl_data.data_pkt;
		tmp_data = kmalloc(tmp_if_data.data_len,GFP_ATOMIC);
		tmp=copy_from_user( tmp_data, p_if_data->data_pkt, tmp_if_data.data_len);
		memcpy(tmp_data, (u_char *)&Ctl_pkt[0], tmp_if_data.data_len);
	}
	
	/* f[^擾(ϒ̓fohɂă[UԂɃRs[s) */
	USBDEV_DPRINTK(KERN_DEBUG " list data_no=%d [%02x][%02x][%02x][%02x][%02x][%02x][%02x][%02x] data_len=%d\n",
							tmp_if_data.data_no,
							tmp_if_data.setup_pkt[0],
							tmp_if_data.setup_pkt[1],
							tmp_if_data.setup_pkt[2],
							tmp_if_data.setup_pkt[3],
							tmp_if_data.setup_pkt[4],
							tmp_if_data.setup_pkt[5],
							tmp_if_data.setup_pkt[6],
							tmp_if_data.setup_pkt[7],
							tmp_if_data.data_len
							);

	if( ( USB_DIR_OUT == dir ) &&
		( 0 != Usb_setup_pkt.wLength ) &&
	   ( NULL != Ctl_data.data_pkt )) {
		if (copy_to_user((void __user *)arg, (const void *)&tmp_if_data, sizeof(uc_ctl_data_t)))
		{
			USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]%s:fail copy_to_user[%d]\n",__func__,__LINE__);
			kfree(tmp_data);
			ret =  -EFAULT;
			return ret;
		}
	   	/*f[^̃Rs[s*/
	   	if (copy_to_user(p_if_data->data_pkt, tmp_data, tmp_if_data.data_len))
		{
			USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]%s:fail copy_to_user[%d]\n",__func__,__LINE__);
			kfree(tmp_data);
			ret =  -EFAULT;
			return ret;
		}
	   	
   			Ctl_data.data_no = 0;
	   }
	else if( ( USB_DIR_IN == dir ) &&
		( 0 != Usb_setup_pkt.wLength )) {
		/*[U[ԂɃRs[*/
		if (copy_to_user((void __user *)arg, (const void *)&tmp_if_data, sizeof(uc_ctl_data_t)))
		{
			USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]%s:fail copy_to_user[%d]\n",__func__,__LINE__);
			ret =  -EFAULT;
			return ret;
		}
	   	
			Ctl_data.data_no = 0;
	}
	/*[U[Ԃւ̃Rs[{Ȃ*/
	else
	{
		USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]%s:missmatch dir[%d] length[%d]\n",__func__,dir,Usb_setup_pkt.wLength);
	}
	
	kfree(tmp_data);
	return ret;
}

				
/**********************************************************************
ioctlFR}hIOCSCTLDATAΉ
***********************************************************************/
static int set_ioctl_ctldata(struct printer_dev *dev, unsigned long arg)
{
	uc_ctl_data_t if_data;
	uc_ctl_data_t *tmp_data = (uc_ctl_data_t*)arg;
	int ret=0;
	int error;
	struct usb_composite_dev *cdev;
	struct usb_request *req;
	int tmp = 0;
	u8 *src_data = NULL;
	
	cdev = dev->function.config->cdev;
	req = cdev->req;

	/*[U[Ԃ̏J[lԂɃRs[*/
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s\n",__func__);
	tmp = copy_from_user(&if_data, (uc_ctl_data_t*)arg, sizeof(uc_ctl_data_t));
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]if_data.setup_pkt[0] = %d \n",if_data.setup_pkt[0]);
	
	switch(if_data.setup_pkt[0]) {
		case UC_SEND_NONE:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]UC_SEND_NONE\n");
			/* SET_MIB(Xe[^X)̃Xe[^XiK̑M */
			if(Usb_stop_status.flags == USB_STOP_ENABLE)
			{
				Usb_stop_status.flags = 0;
				req->length = 0;
				req->zero = 0;
				error = usb_ep_queue(cdev->gadget->ep0, req, GFP_ATOMIC);
				if (error < 0) {
				ERROR(dev, "%s:%d Error!\n", __func__, __LINE__);
				}
			}
		
			Notify_list.ntf_stat = NOTIFY_REQ_OFF;
			wake_up(&rx_wait_queue);
			break;
		case UC_SEND_DATA:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]UC_SEND_DATA\n");
			/*zXgւ̑Mf[^[U[ԂRs[{*/
		
		    src_data = kmalloc(if_data.data_len,GFP_ATOMIC);
			tmp=copy_from_user(src_data, tmp_data->data_pkt, if_data.data_len);
			if (tmp != 0)
			{
				USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]copy_from_user %d\n",tmp);
				//kfree(src_data);
				ret =  -EFAULT;
			}
		
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV] if_data.data_len = %d\n", if_data.data_len);
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV] Usb_setup_pkt.wLength = %d\n", Usb_setup_pkt.wLength);
			if_data.data_len = min(if_data.data_len,Usb_setup_pkt.wLength);
			
			memcpy(req->buf, src_data, if_data.data_len);
			req->length = if_data.data_len;
			req->zero = if_data.data_len < Usb_setup_pkt.wLength;
			error = usb_ep_queue(cdev->gadget->ep0, req, GFP_ATOMIC);
			if (error < 0) {
				ERROR(dev, "%s:%d Error!\n", __func__, __LINE__);
			}
			/* AvʒmԂ */
			Notify_list.ntf_stat = NOTIFY_REQ_OFF;
			wake_up(&rx_wait_queue);
			kfree(src_data);
		break;
		case UC_SEND_STALL:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:UC_SEND_STALL\n",__func__);
			/*STALL*/
			usb_ep_set_halt(cdev->gadget->ep0);
			/* AvʒmԂ */
			Notify_list.ntf_stat = NOTIFY_REQ_OFF;
			wake_up(&rx_wait_queue);
		break;
		default:
		ret = -EINVAL;
			break;
	}
	return ret;
}
#if 0 /*eXgp*/
static int test_ioctl_data(struct printer_dev *dev, unsigned long arg)
{
	int ret=0;
	int tmp = 0;
	int i =0;
	u_char *tmp_data1;
	u_char *tmp_data;

	uc_ctl_data_t if_data;
	uc_ctl_data_t tmp_if_data;
	uc_ctl_data_t *data = (uc_ctl_data_t *)arg;
	
	USBDEV_DPRINTK( KERN_ALERT "[USB_DEV]%s\n",__func__);
	
	/*[U[Ԃ̏J[lԂɃRs[*/
	tmp=copy_from_user( &tmp_if_data, (uc_ctl_data_t*)arg, sizeof(uc_ctl_data_t));
	if (tmp != 0)
	{
		USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]copy_from_user %d\n",tmp);
		//kfree(tmp_data);
		ret =  -EFAULT;
	}
	tmp_data1 = kmalloc(16,GFP_ATOMIC);
	tmp_data  = tmp_data1;
	tmp=copy_from_user( tmp_data1, data->data_pkt, 16);
	if (tmp != 0)
	{
		USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]copy_from_user %d\n",tmp);
		//kfree(tmp_data);
		ret =  -EFAULT;
	}
	for(i=0;i<16;i++)
	{
		//USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]tmp_data = %c\n",tmp_data1);
		USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]tmp_data = %d\n",*tmp_data1);
		tmp_data1++;
	}
	tmp_data1 = tmp_data;;
	
	
	for(i=0;i<16;i++)
	{
		//USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]tmp_data = %c\n",tmp_data1);
		*tmp_data1 = 0xff;
		USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]tmp_data = %d\n",*tmp_data1);
		tmp_data1++;
	}
	
	USBDEV_DPRINTK(KERN_ALERT "[USB_DEV](void __user *)data = %x\n",data);
	USBDEV_DPRINTK(KERN_ALERT "[USB_DEV](void __user *)data->data_pkt = %x\n",data->data_pkt);
	tmp_if_data.data_len = 100;
	tmp_if_data.data_no = 20;
	
	if (copy_to_user((void __user *)arg, (const void *)&tmp_if_data, sizeof(uc_ctl_data_t)))
	{
		USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]copy_to_user A\n");
		kfree(tmp_data1);
		ret =  -EFAULT;
	}
	//tmp = copy_to_user((void __user *)data->data_pkt, if_data.data_pkt, 16);
	tmp = copy_to_user(data->data_pkt, tmp_data, 16);
	if (tmp != 0)
	{
		USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]copy_to_user %d\n",tmp);
		kfree(tmp_data1);
		ret =  -EFAULT;
	}
	
	USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]ret %d\n",ret);
	return ret;
}
#endif
/************************************************************
֐Fexe_setup_status
FRg[]ɂdataiKŎ~߂Ă邢Ƃ̍ĊJ
***************************************************************/
static int exe_setup_status(struct printer_dev *dev)
{
	struct usb_composite_dev *cdev;
	struct usb_request	*req;
	cdev = dev->function.config->cdev;
	req = cdev->req;
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s\n",__func__);
	--cdev->delayed_status;
	req->length = 0;
	req->zero = 0;
	return usb_ep_queue(cdev->gadget->ep0, req, GFP_ATOMIC);
}
/************************************************************
֐Fexe_bulkout_thread
FbulkoutXbh𔲂鏈
***************************************************************/
static void exe_bulkout_thread(struct printer_dev *dev)
{
	int i=0;
	USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s\n",__func__);
	for(i=0;i<usb_interface_num;i++) 
	{
		/*tOǉ*/
		dev->isSetIF_dev[i] = 1;
		wake_up_interruptible(&dev->rx_wait[i]);
	}

}
/**********************************************************************
ioctlFR}hIOCSIFCHANGEΉ
***********************************************************************/
static int set_ioctl_ifchnage(struct printer_dev *dev, unsigned long arg)
{
	uc_interface_changeinfo_t change_info;
	int ret=0;
	int error;
	int tmp=0;
	
	/*[U[Ԃ̏J[lԂɃRs[*/
	//printk( KERN_DEBUG "[USB_DEV]%s\n",__func__);
	tmp = copy_from_user(&change_info, (uc_interface_changeinfo_t*)arg, sizeof(uc_interface_changeinfo_t));
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]if_data.setup_pkt[0] = %d \n",if_data.setup_pkt[0]);
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:%d\n",__func__,change_info.chnaginfo);
	switch(change_info.chnaginfo) {
		case UC_CHANGE_INFO_NONE:
			error = exe_setup_status(dev);
		break;
		case UC_CHANGE_INFO_START:
			rest_num_setif();
			exe_bulkout_thread(dev);
		break;
		case UC_CHANGE_INFO_FINISH:
			error = exe_setup_status(dev);
			exe_bulkout_thread(dev);
		break;
		default:
		break;
	}
	return ret;
}
/**********************************************************************
ioctlFRg[]
***********************************************************************/
static int exe_control_ioctl(struct printer_dev *dev, unsigned int code, unsigned long arg)
{
	int ret=0;
	switch(code) {
		case IOCGEPCONF:
		ret = get_ioctl_epconf(dev,arg);
			break;
		case IOCSEPINFO:
		ret = set_ioctl_epinfo(dev,arg);
			break;
		case IOCSNOTIFYREQ:
		ret = set_ioctl_notifyreq(dev,arg);
			break;
		case IOCDNOTIFYREQ:
		ret = del_ioctl_notifyreq(dev,arg);
			break;
		case IOCGCTLDATA:
		ret = get_ioctl_ctldata(dev,arg);
			break;
		case IOCSCTLDATA:
		ret = set_ioctl_ctldata(dev,arg);
			break;
		case IOCGIFINFO:
		ret = get_ioctl_ifinfo(dev,arg);
			break;
		case IOCSIFCHANGE:
		ret = set_ioctl_ifchnage(dev,arg);
			break;
		case IOCGEPSTATE:
		ret = get_ioctl_epstate(dev,arg);
			break;
#if 0
		/*eXgp*/
		case IOCTESTDATA:
		ret = test_ioctl_data(dev,arg);
			break;
#endif
		default:
		ret = -EINVAL;
			break;
	}
	return ret;
}
				
/**********************************************************************
R}hFIOCGBUFINFOɑ΂鏈
***********************************************************************/
static int get_ioctl_bufinfo(struct printer_dev *dev, unsigned int code, unsigned long arg,int index)
{
	int ret=0;
	usb_bufinfo_t bufinfo;
	int tmp = 0;
	
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]get_ioctl_bufinfo\n");
	bufinfo.bufsize = USB_BUFSIZE*NUM_USBREQ;
	bufinfo.descsize = USB_BUFSIZE;
	bufinfo.ndesc = NUM_USBREQ;
#if 0
	switch(index) {
	case USB_UBULKOUT:
		bufinfo.bufsize = USB_BUFSIZE*NUM_USBREQ;
		bufinfo.descsize = USB_BUFSIZE;
		bufinfo.ndesc = NUM_USBREQ;
		break;
	case USB_UBULKIN:
		bufinfo.bufsize = USB_BUFSIZE*NUM_USBREQ;
		bufinfo.descsize = USB_BUFSIZE;
		bufinfo.ndesc = NUM_USBREQ;
		break;
	default:
		break;
		
	}
#endif
	tmp = copy_to_user((void __user *) arg, (const void *)&bufinfo,sizeof(usb_bufinfo_t));
#if 0
	/*[U[ԂɃRs[*/
	if (copy_to_user((void __user *) arg, (const void *)&bufinfo,sizeof(usb_bufinfo_t))<0)
	{
		return -EFAULT;
	}
#endif 
	return ret;
}
		
/**********************************************************************
R}hFIOCGBULKINFOɑ΂鏈
***********************************************************************/
static int get_ioctl_bulkinfo(struct printer_dev *dev, unsigned long arg, unsigned int type, unsigned int index)
{
	int ret=0;
	usb_bulkinfo_t bulkinfo;
	int tmp = 0;

	switch(type) {
		case USB_UBULKOUT:
			if (dev->gadget_status == USB_GADGET_ON){
				bulkinfo.epaddr = dev->out_ep[index]->address;
			}
			else{
				bulkinfo.epaddr = dummy_out_addr[index];
			}
			break;
		case USB_UBULKIN:
			if (dev->gadget_status == USB_GADGET_ON){
				bulkinfo.epaddr = dev->in_ep[index]->address;
			}
			else {
				bulkinfo.epaddr =  dummy_in_addr[index];
			}
			break;
		default:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]TransferType:default\n");
			break;	
	}
	
	tmp = copy_to_user((void __user *) arg, (const void *)&bulkinfo,sizeof(usb_bulkinfo_t));

	return ret;
}

/**********************************************************************
ioctlFoN]
***********************************************************************/
static int exe_bulk_ioctl(struct printer_dev *dev, unsigned int code, unsigned long arg, unsigned int type, unsigned int index)
{
	int ret=-1;
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]exe_bulk_ioctl\n");
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]code=%u\n",code);
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]IOCGBUFINFO=%u\n",IOCGBUFINFO);
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]IOCGBULKINFO=%u\n",IOCGBULKINFO);
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]IOCGEPCONF=%u\n",IOCGEPCONF);
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]IOCSEPINFO=%u\n",IOCSEPINFO);
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]IOCSNOTIFYREQ=%u\n",IOCSNOTIFYREQ);
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]IOCDNOTIFYREQ=%u\n",IOCDNOTIFYREQ);
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]IOCGCTLDATA=%u\n",IOCGCTLDATA);
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]IOCSCTLDATA=%u\n",IOCSCTLDATA);
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]IOCGIFINFO=%u\n",IOCGIFINFO);
	switch(code) {
		case IOCGBUFINFO:
			//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]get_ioctl_bufinfo\n");
			ret = get_ioctl_bufinfo(dev,code,arg,type);
			//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]get_ioctl_bufinfo ret:%d\n",ret);
			break;
		case IOCGBULKINFO:
			ret = get_ioctl_bulkinfo(dev,arg,type,index);
			break;
		default:
			ret = -EINVAL;
			break;
	}
	//USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]exe_bulk_ioctl ret=%d\n",ret);
	return ret;
}

	
/**********************************************************************
VXeR[:open
***********************************************************************/
static int
printer_open(struct inode *inode, struct file *fd)
{
	struct printer_dev	*dev;
	unsigned long		flags;
	int			ret = -EBUSY;
	unsigned int minor,type,index;
	struct usb_composite_dev *cdev;
	unsigned long		spin_flags;
	//struct usb_composite_overwrite covr;
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]call printer_open\n");
	
	spin_lock_irqsave(&printer_mutex, spin_flags);
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]call mutex_lock\n");
	dev = container_of(inode->i_cdev, struct printer_dev, printer_cdev);
	
	if (dev == NULL)
	{
		spin_unlock_irqrestore(&printer_mutex, spin_flags);
		return -ENXIO;
	}
	
	if (dev->init_fail)
	{
		spin_unlock_irqrestore(&printer_mutex, spin_flags);
		return -ENODEV;
	}
		
	spin_lock_irqsave(&dev->lock, flags);
	cdev = dev->function.config->cdev;
	/*I[v[hO_RDWRO_NONBLOCKȊO-EACCESSԂ*/
	if ( ((fd->f_flags & O_ACCMODE) != O_RDWR ) && ((fd->f_flags & O_ACCMODE) != O_NONBLOCK ) )
	{
		spin_unlock_irqrestore(&dev->lock, flags);
		spin_unlock_irqrestore(&printer_mutex, spin_flags);
		return -EACCES;
	}
	
	/*}Ci[ԍ̎擾*/
	minor = iminor(inode);
	type = get_TransferType(minor);
	index = get_TransferIndex(minor);
	
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]call open minor_no:%d,type:%d\n",minor,type);
	switch(type) {
		case USB_UCONTROL:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]TransferType:USB_UCONTROL,name:%s pid:%i\n",current->comm, current->pid);
			if (!dev->printer_cdev_open) {
				dev->printer_cdev_open = 1;
				fd->private_data = dev;
				ret = 0;
				/* Change the printer status to show that it's on-line. */
				dev->printer_status |= PRINTER_SELECTED;
			}
			break;
		case USB_UBULKOUT:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]TransferType:USB_UBULKOUT:%d\n",index);
			if (!dev->bout_cdev_open[index]) {
				dev->bout_cdev_open[index] = 1;
				fd->private_data = dev;
				ret = 0;
			}
			break;
		case USB_UBULKIN:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]TransferType:USB_UBULKIN%d\n",index);
			if (!dev->bin_cdev_open[index]) {
				dev->bin_cdev_open[index] = 1;
				fd->private_data = dev;
				ret = 0;
			}
			break;
		default:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]TransferType:default\n");
			break;
	}
	
	spin_unlock_irqrestore(&dev->lock, flags);

	DBG(dev, "printer_open returned %x\n", ret);
	spin_unlock_irqrestore(&printer_mutex, spin_flags);
	return ret;
}
/**********************************************************************
VXeR[:close
***********************************************************************/
static int
printer_close(struct inode *inode, struct file *fd)
{
	struct printer_dev	*dev = fd->private_data;
	unsigned long		flags;
	int index = 0;

	unsigned int type = 0;
	unsigned int minor =0;
	int number = 0;
	int i=0;
	
	/*}Ci[ԍ̎擾*/
	minor = iminor(inode);
	type = get_TransferType(minor);
	index = get_TransferIndex(minor);
	number = get_TransferIndex_buf(minor);
	//USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]call printer_close:minor=%d\n",minor);
	switch(type) {
		case USB_UCONTROL:
			if(dev->printer_cdev_open != 0)
			{
#ifdef USBDEV_IPP_SWITHC
				if(dev->gadget_status == USB_GADGET_ON)
				{
					USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:gadget rest[%s:%d]\n",__func__,current->comm, current->pid);
					USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:gadget rest[%s:%d]\n",__func__,current->comm, current->pid);

					/*Gh|Cg̖*/
					for(i=0;i<usb_interface_num;i++)
					{
						printer_reset_interface(dev, i);
					}
					/*KWFbg̓o^*/
					usb_composite_unregister(&printer_driver);
					/*dmäJ*/
					for(i=0;i<usb_interface_num;i++)
					{
						dev->in_ep[i]->desc = NULL;
						dev->out_ep[i]->desc = NULL;
						kfree(dev->in_buf[i]);
						kfree(dev->out_buf[i]);
					}
					/*altݒ̏*/
					set_alt_val(0xFF);
					dev->gadget_status = USB_GADGET_OFF;
					dev->reboot = 1;
					exe_bulkout_thread(dev);
				}
#endif /*USBDEV_IPP_SWITHC*/
				USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:USB_UCONTROL\n",__func__);
				dev->printer_cdev_open = 0;
				/* Change printer status to show that the printer is off-line. */
				dev->printer_status &= ~PRINTER_SELECTED;
			}
			break;
		case USB_UBULKOUT:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:USB_UBULKOUT:index=%d,number=%d\n",__func__,index,number);
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:USB_UBULKOUT:%d\n",__func__,index);
			dev->bout_cdev_open[index] = 0;			
			if (dev->gadget_status == USB_GADGET_ON){
				printer_reset_interface(dev, number);
				USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]%s:usb_ep_disable(dev->out_ep[%d])=%d\n",__func__,index);
			}
			break;
		case USB_UBULKIN:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:USB_UBULKIN:%d\n",__func__,index);
			dev->bin_cdev_open[index] = 0;
			if (dev->gadget_status == USB_GADGET_ON){
				printer_reset_interface(dev, number);
				USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]%s:usb_ep_disable(dev->in_ep[%d])=%d\n",__func__,index);
			}
			break;
		default:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:default\n",__func__);
			break;
		
	}

	/*㏈*/
	spin_lock_irqsave(&dev->lock, flags);
	fd->private_data = NULL;
	spin_unlock_irqrestore(&dev->lock, flags);

	DBG(dev, "printer_close\n");

	return 0;
}

/**********************************************************************
VXeR[:read
***********************************************************************/
static ssize_t
printer_read(struct file *fd, char __user *buf, size_t len, loff_t *ptr)
{
	struct printer_dev		*dev = fd->private_data;
	unsigned int type = 0;
	unsigned int minor =0;
	unsigned int index =0;
	int ret = -1;
	struct inode *inode = fd->f_dentry->d_inode;
	char *r_buf;
	unsigned int f_flags = fd->f_flags;

//	mutex_lock(&dev->lock_printer_io);
//	spin_lock_irqsave(&dev->lock, flags);

	/*`FbN*/	
	DBG(dev, "%s\n", __func__);
	if((buf == NULL) || (len == 0))
	{
		ERROR(dev, "%s:%d Error!(%p,%d)\n", __func__, __LINE__, buf, len);
		return -EINVAL;
	}
	
	/*[U[Ԃ̃Rs[邽߂̗̈m*/	
	r_buf = kmalloc(len,GFP_ATOMIC);
	if(!r_buf)
	{
		return -EINVAL;	
	}
	//copy_from_user(r_buf, buf, len);
	
	/*}Ci[ԍ̎擾*/
	minor = iminor(inode);
	type = get_TransferType(minor);
	index = get_TransferIndex_buf(minor);
	
	//if(get_endpoint_state(minor) == 0)
	//{
	//	USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]%s:ep_state=%d\n",__func__,get_endpoint_state(minor));
	//	return -EINVAL;
	//}

	//USBDEV_DPRINTK(KERN_INFO "[USB_DEV]printer_read transtype:%d\n",type);	
	
	switch(type) {
		case USB_UCONTROL:
			ret = exe_control_read(dev,buf,r_buf,len,f_flags,index);
			break;
		case USB_UBULKOUT:
			ret = exe_bulkout_read(dev,buf,r_buf,len,f_flags,index);
			break;
		case USB_UBULKIN:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]printer_read exe_bulkin_read\n");
			ret = exe_bulkin_read(dev,buf,r_buf,len,f_flags,index);
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]printer_read exe_bulkin_read ret=%d \n",ret);
			break;
		default:
			ERROR(dev, "%s:%d Error!(%x)\n", __func__, __LINE__, type);
			break;
		
	}
	kfree(r_buf);
	
//	spin_unlock_irqrestore(&dev->lock, flags);
//	mutex_unlock(&dev->lock_printer_io);
	
	//USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]read ret:%d\n",ret);	
	return ret;
	
}
/**********************************************************************
VXeR[:write
***********************************************************************/
static ssize_t
printer_write(struct file *fd, const char __user *buf, size_t len, loff_t *ptr)
{
	struct printer_dev	*dev = fd->private_data;
	unsigned long		flags;
	//size_t			size;	/* Amount of data in a TX request. */
	//struct usb_request	*req;
	int ret = -1;
	unsigned int type = 0;
	unsigned int minor = 0;
	unsigned int index = 0;
	char *w_buf;
	struct inode *inode = fd->f_dentry->d_inode;
	unsigned int f_flags = fd->f_flags;

	/*`FbN*/	
	if (len == 0)
	{
		return -EINVAL;	
	}
	
	mutex_lock(&dev->lock_printer_io);
	spin_lock_irqsave(&dev->lock, flags);

	/*[U[Ԃ̃Rs[邽߂̗̈m*/
	w_buf = kmalloc(len+1,GFP_ATOMIC);
	if(!w_buf)
	{
		spin_unlock_irqrestore(&dev->lock, flags);
		mutex_unlock(&dev->lock_printer_io);
		return -EINVAL;	
	}
	/*[U[ԂRs[*/
	if(copy_from_user(w_buf, buf, len))
	{
		spin_unlock_irqrestore(&dev->lock, flags);
		mutex_unlock(&dev->lock_printer_io);
		kfree(w_buf);
		return -EINVAL;	
	}

	DBG(dev, "printer_write trying to send %d bytes\n", (int)len);

	/*}Ci[ԍ̎擾*/
	minor = iminor(inode);
	type = get_TransferType(minor);
	index = get_TransferIndex_buf(minor);
	//if(get_endpoint_state(minor) == 0)
	//{
	//	USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]%s:ep_state=%d\n",__func__,get_endpoint_state(minor));
	//	return -EINVAL;
	//}
	//USBDEV_DPRINTK(KERN_INFO "[USB_DEV]printer_write type%d\n",type);
	/*]ޖɏ{*/
	switch(type) {
		case USB_UCONTROL:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:USB_UCONTROL\n",__func__);
			/*usbstrl_write\̂̃o擾*/
			ret = exe_control_write(dev,w_buf,len,index);
			break;
		case USB_UBULKOUT:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:USB_UBULKOUT:%d\n",__func__,index);
			ret = exe_bulkout_write(dev,w_buf,len,index);
			break;
		case USB_UBULKIN:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:USB_UBULKIN:%d\n",__func__,index);
			ret = exe_bulkin_write(dev,w_buf,len,f_flags,index);
			break;
		default:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:default\n",__func__);
			break;
		
	}
	
	/*㏈*/
	kfree(w_buf);
	spin_unlock_irqrestore(&dev->lock, flags);
	mutex_unlock(&dev->lock_printer_io);

	return ret;
}

				
/*SIMVAł͖gp̊֐*/
static int
printer_fsync(struct file *fd, loff_t start, loff_t end, int datasync)
{
	struct printer_dev	*dev = fd->private_data;
	//struct inode *inode = file_inode(fd);
	unsigned long		flags;
	int			tx_list_empty;
	unsigned int minor = 0;
	unsigned int index = 0;
	struct inode *inode = fd->f_dentry->d_inode;

	minor = iminor(inode);
	index = get_TransferIndex_buf(minor);
	//if(get_endpoint_state(minor) == 0)
	//{
	//	USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]%s:ep_state=%d\n",__func__,get_endpoint_state(minor));
	//	return -EINVAL;
	//}
	
	mutex_lock(&inode->i_mutex);
	spin_lock_irqsave(&dev->lock, flags);
	tx_list_empty = (likely(list_empty(&dev->tx_reqs[index])));
	spin_unlock_irqrestore(&dev->lock, flags);

	if (!tx_list_empty) {
		/* Sleep until all data has been sent */
		wait_event_interruptible(dev->tx_flush_wait[index],
				(likely(list_empty(&dev->tx_reqs_active[index]))));
	}
	mutex_unlock(&inode->i_mutex);

	return 0;
}
	
/*foCX̏ԕωmF*/
static void _isDevicestate(struct printer_dev *dev)
{
	u_char state = 0;
	struct usb_gadget *gadget = NULL;

	if(dev->gadget != NULL)
	{
		USBDEV_DPRINTK_ALERT( KERN_ALERT "[USB_DEV]%s:(dev->gadget != NULL)\n",__func__);
		gadget = dev->gadget;
	}
	USBDEV_DPRINTK( KERN_ALERT "[USB_DEV]%s:gadget->state=%d\n",__func__,gadget->state);
	
	if(dev->gadget_status == USB_GADGET_OFF)
	{
		USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:(dev->gadget_status == USB_GADGET_OFF)\n",__func__);
		state = UCST_NOT_ATTACHED;
	}
	else
	{
		USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:else\n",__func__);
		state = gadget->state;
	}
	USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:current->%d gadget->%d\n",__func__,dev->current_state,state);

	/*ԂύXĂf[ւ̒ʒms߁AwakeupCxgĂ*/
	/*ACONFIGUREDԂ̂Ƃ2AŒʒmĂ*/
	if (dev->current_state != state)
	{
		//printk( KERN_DEBUG "[USB_DEV]%s:change %d -> %d\n",__func__,dev->current_state,state);
		USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:change %d -> %d\n",__func__,dev->current_state,state);
		dev->current_state = state;
		USB_STATE_FLAG = 1;
		wake_up_interruptible(&ctl_poll_queue_state);
	}
#if 0
	/*f[2configuedʒmΉ*/
	/*̒ʒmłȂlegasyłȂ*/
	else if ( dev->current_state == USB_STATE_CONFIGURED )
	{
		if (dev->cnt_notify_usbd < 2)
		{
			USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:change %d -> %d\n",__func__,dev->current_state,state);
			dev->current_state = state;
			USB_STATE_FLAG = 1;
			wake_up_interruptible(&ctl_poll_queue_state);
		}
	}
#endif
	else
	{
		USBDEV_DPRINTK( KERN_DEBUG "[USB_DEV]%s:not change %d -> %d\n",__func__,dev->current_state,state);
	}
}
	
/**********************************************************************
VXeR[:poll
***********************************************************************/
static unsigned int
printer_poll(struct file *fd, poll_table *wait)
{
	struct printer_dev	*dev = fd->private_data;
	unsigned long		flags;
	int			status = 0;
	
	unsigned int type = 0;
	unsigned int minor = 0;
	unsigned int index = 0;
	unsigned int state = 0;
	struct inode *inode = fd->f_dentry->d_inode;

	/*}Ci[ԍ̎擾*/
	minor = iminor(inode);
	type = get_TransferType(minor);
	index = get_TransferIndex_buf(minor);
	//if(get_endpoint_state(minor) == 0)
	//{
	//	USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]%s:ep_state=%d\n",__func__,get_endpoint_state(minor));
	//	return -EINVAL;
	//}
	
	/*]ɏ{*/
	switch(type) {
		case USB_UCONTROL:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]poll TransferType:USB_UCONTROL\n");
			spin_lock_irqsave(&dev->lock, flags);
		
			/*read*/
			if (wait->_key & (POLLIN | POLLRDNORM)) {
				USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]poll Twait->_key & (POLLIN | POLLRDNORM)\n");
				/* Ctl_data.data_no0Ȃf[^̓҂ */
				poll_wait(fd, &ctl_poll_queue, wait);
				poll_wait(fd, &ctl_poll_queue_state, wait);
				if (Ctl_data.data_no != 0) {
					status |= POLLIN | POLLRDNORM;
					spin_unlock_irqrestore(&dev->lock, flags);

					return status;
				}
				if (USB_STATE_FLAG != 0){
					status |= POLLIN | POLLRDNORM;
					USB_STATE_FLAG = 0;
				}
			}
			if(wait->_key & (POLLOUT | POLLWRNORM)) {
				USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]poll wait->_key & (POLLOUT | POLLWRNORM)\n");
				status |= POLLOUT | POLLWRNORM;
			}

			spin_unlock_irqrestore(&dev->lock, flags);
		
			break;
		case USB_UBULKOUT:
			state = get_endpoint_state(minor);
			USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]%s:minor=%d,USB_UBULKOUT=%d,index=%d,state=%d\n",__FUNCTION__,minor,type,index,state);
			
			if(state == 1)
			{
#if 0 /*ishihara*/
				/* KWFbgNĂȂɌĂԂƃJ[lpjbNȂ̂ŁAŊmF */
				if(dev->gadget_status == USB_GADGET_ON)
				{
					mutex_lock(&dev->lock_printer_io);
					spin_lock_irqsave(&dev->lock, flags);
					setup_rx_reqs(dev,index);
					spin_unlock_irqrestore(&dev->lock, flags);
					mutex_unlock(&dev->lock_printer_io);
					/*IɌĂ*/
					//mutex_lock(&dev->lock_printer_io);
					//spin_lock_irqsave(&dev->lock, flags);
					//setup_rx_reqs(dev,1);
					//spin_unlock_irqrestore(&dev->lock, flags);
					//mutex_unlock(&dev->lock_printer_io);
				}
#endif
				poll_wait(fd, &dev->rx_wait[index], wait);
			}
			spin_lock_irqsave(&dev->lock, flags);
			if (wait->_key & (POLLIN | POLLRDNORM)) {
				/*read̓f[^̗L`FbN*/
				if (likely(!list_empty(&dev->rx_buffers[index])) || (dev->isSetIF_dev[index] == 1))
					status |= POLLIN | POLLRDNORM;
			}
		
			/*write͏Ɏ{\ɂ*/
			if(wait->_key & (POLLOUT | POLLWRNORM)) {
				status |= POLLOUT | POLLWRNORM;
			}
			spin_unlock_irqrestore(&dev->lock, flags);

			break;
		case USB_UBULKIN:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:minor=%d,USB_UBULKIN=%d,index=%d\n",__FUNCTION__,minor,type,index);
			poll_wait(fd, &dev->tx_wait[index], wait);

			spin_lock_irqsave(&dev->lock, flags);
			if (wait->_key & (POLLIN | POLLRDNORM)) {
				USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:wait->_key & (POLLIN | POLLRDNORM)\n",__func__);

				/*zXg֑MȂƂȂf[^邩`FbN*/
				if (likely(!list_empty(&dev->tx_reqs[index])))
				{
					USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]%s:likely(!list_empty(&dev->tx_reqs[index]))\n",__func__);
				//if (dev->current_tx_req[index])
					status |= POLLIN | POLLRDNORM;
				}
			}
			/*write͏Ɏ{\ɂ*/
			if(wait->_key & (POLLOUT | POLLWRNORM)) {
				status |= POLLOUT | POLLWRNORM;
			}
		
			spin_unlock_irqrestore(&dev->lock, flags);

			break;
		default:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]TransferType:default\n");
			break;
		
	}

	return status;
}

/**********************************************************************
VXeR[:ioctl
***********************************************************************/
static long
printer_ioctl(struct file *fd, unsigned int code, unsigned long arg)
{
	struct printer_dev	*dev = fd->private_data;
	//unsigned long		flags;
	//int			status = 0;
	unsigned int type = 0;
	unsigned int minor = 0;
	unsigned int index =0;
	int ret = -1;
	struct inode *inode = fd->f_dentry->d_inode;
	DBG(dev, "printer_ioctl: cmd=0x%4.4x, arg=%lu\n", code, arg);

	/*}Ci[ԍ̎擾*/
	minor = iminor(inode);
	type = get_TransferType(minor);
	index = get_TransferIndex_buf(minor);
	switch(type) {
		case USB_UCONTROL:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]ioctl TransferType:USB_UCONTROL\n");
			ret = exe_control_ioctl(dev,code,arg);
			break;
		case USB_UBULKOUT:
		case USB_UBULKIN:
			//USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]TransferType:USB_UBULKOUT/IN\n");
			ret = exe_bulk_ioctl(dev,code,arg,type,index);
			//USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]TransferType:USB_UBULKOUT/IN ret:%d\n",ret);

			break;
		default:
			USBDEV_DPRINTK(KERN_DEBUG "[USB_DEV]TransferType:default\n");
			break;
	}
	return ret;

}
/**********************************************************************
oN]pmmap
***********************************************************************/
static void usb_vma_open(struct vm_area_struct *vma)
{
	USBDEV_DPRINTK(KERN_INFO "[USB_DEV]usb_vma_open virt %lx, phys %lx\n",vma->vm_start,vma->vm_pgoff << PAGE_SHIFT);
}
static void usb_vma_close(struct vm_area_struct *vma)
{
	USBDEV_DPRINTK(KERN_INFO "[USB_DEV]usb_vma_close \n");
}	
static int usb_vma_fault(struct vm_area_struct *vma, struct vm_fault *vmf)
{
	//unsigned long offset = vmf->pgoff << PAGE_SHIFT;
	//struct printer_dev *dev = vma->vm_private_data;
	
	USBDEV_DPRINTK(KERN_INFO "[USB_DEV]usb_vma_fault \n");
	return 0;
}
/**********************************************************************
vmãIy[V\
***********************************************************************/
static struct vm_operations_struct usb_remap_vm_ops = {
	.open = usb_vma_open,
	.close = usb_vma_close,
	.fault = usb_vma_fault,
};

/*ŋ߂̃J[lVM_RESERVED̒`Ȃ߂̑Ή*/
#ifndef VM_RESERVED
#define VM_RESERVED (VM_DONTEXPAND | VM_DONTDUMP)
#endif
/**********************************************************************
oN]pmmap
***********************************************************************/
static int
vma_bulkdata_mmap(struct printer_dev *dev, struct vm_area_struct *vma, int type, unsigned int index)
{
	
	//unsigned long off = vma->vm_pgoff << PAGE_SHIFT;
	unsigned long vsize = vma->vm_end - vma->vm_start;
	unsigned long psize = USB_BUFSIZE * NUM_USBREQ;
	unsigned long physical;
	
	vma->vm_ops = &usb_remap_vm_ops;
	vma->vm_flags |= VM_RESERVED;
	vma->vm_private_data = dev;
	usb_vma_open(vma);

	
	USBDEV_DPRINTK(KERN_WARNING "[USB_DEV]vma_bulkdata_mmap\n");
	//USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]vma_bulkdata_mmap:type=%d\n",type);
	/*AhX(y[Wt[ԍ)擾*/
	switch(type) {
		case USB_UBULKOUT:
		physical = __pa(dev->out_buf[index])>>PAGE_SHIFT;
		break;
		case USB_UBULKIN:
		physical = __pa(dev->in_buf[index])>>PAGE_SHIFT;
		break;
		default:
		USBDEV_DPRINTK(KERN_WARNING "[USB_DEV]mmap default\n");
			return -EINVAL;
		break;
		
	}
	/*veNVPROT_READȊO̓G[Ԃ*/
	if(!(vma->vm_page_prot & PROT_READ))
	{
		USBDEV_DPRINTK(KERN_WARNING "[USB_DEV]mmap invalid vm_page_prot = %d\n",vma->vm_page_prot);
		return -EINVAL;
	}
	/*tO̐ݒ肪0܂MAP_SHAREDȊO̓G[Ԃ*/
	
	if((vma->vm_flags == 0) || (vma->vm_flags == (MAP_SHARED | MAP_FILE)))
	{
		USBDEV_DPRINTK(KERN_WARNING "[USB_DEV]mmap invalid vm_flags = %lu\n",vma->vm_flags);
		return -EINVAL;
	}

	if(vsize > psize)
	{
		USBDEV_DPRINTK(KERN_WARNING "[USB_DEV]mmap vsize > psize\n");
		return -EINVAL;
	}
	/*[U[̃AhXԂւ̃}bsO*/
	if(remap_pfn_range(vma, vma->vm_start, physical, vsize, vma->vm_page_prot))
	{
		USBDEV_DPRINTK(KERN_WARNING "[USB_DEV]remap page range failed\n");
		//USBDEV_DPRINTK(KERN_WARNING "remap page range failed\n");
		return -1;
	}
	return 0;
}

/********************************************************************
mmap̏
********************************************************************/
static int
printer_mmap(struct file *fd, struct vm_area_struct *vma)
{
	unsigned int type = 0;
	unsigned int minor = 0;
	unsigned int index = 0;
	int ret;
	struct printer_dev		*dev = fd->private_data;
	
	/*}Ci[ԍ̎擾*/
	struct inode *inode = fd->f_dentry->d_inode;
	minor = iminor(inode);
	type = get_TransferType(minor);
	index = get_TransferIndex_buf(minor);
	//if(get_endpoint_state(minor) == 0)
	//{
	//	USBDEV_DPRINTK_ALERT(KERN_ALERT "[USB_DEV]%s:ep_state=%d\n",__func__,get_endpoint_state(minor));
	//	return -EINVAL;
	//}	
	USBDEV_DPRINTK(KERN_WARNING "[USB_DEV]map type:%d\n",type);
	USBDEV_DPRINTK(KERN_WARNING "[USB_DEV]map index:%d\n",index);
	switch(type) {
		case USB_UCONTROL:
			//USBDEV_DPRINTK(KERN_ALERT "[USB_DEV]mmap TransferType:USB_UCONTROL\n");
			//USBDEV_DPRINTK(KERN_ALERT "mmap invalid device number = %d\n",type);
			return -EINVAL;
			break;
		case USB_UBULKOUT:
		case USB_UBULKIN:
			USBDEV_DPRINTK(KERN_WARNING "[USB_DEV]map TransferType:USB_BULK\n");
			ret = vma_bulkdata_mmap(dev, vma, type, index);

			break;
		default:
			USBDEV_DPRINTK(KERN_INFO "[USB_DEV]TransferType:default\n");
			return -EINVAL;
			break;
		
	}
    return ret;	
}
	

/* used after endpoint configuration */
static const struct file_operations printer_io_operations = {
	.owner =	THIS_MODULE,
	.open =		printer_open,
	.read =		printer_read,
	.write =	printer_write,
	.fsync =	printer_fsync,
	.poll =		printer_poll,
	.unlocked_ioctl = printer_ioctl,
	.mmap = 	printer_mmap,
	.release =	printer_close,
	.llseek =	noop_llseek,
};

/*-------------------------------------------------------------------------*/

/*C^tF[XfBXNv^̏*/	
static void init_intf_descriptor(struct usb_interface_descriptor* argdesc){
	
	argdesc->bLength =		USB_DT_INTERFACE_SIZE;
	argdesc->bDescriptorType =	USB_DT_INTERFACE;
	argdesc->bNumEndpoints =	2;
	argdesc->bInterfaceClass =	USB_CLASS_PRINTER;
	argdesc->bInterfaceSubClass =	1;	/* Printer Sub-Class */
	argdesc->bInterfaceProtocol =	2;	/* Bi-Directional */
	argdesc->iInterface =		0;
}

/*Gh|CgfBXNv^̏*/
static void init_end_descriptor(struct usb_endpoint_descriptor *argdesc){
	argdesc->bLength =	USB_DT_ENDPOINT_SIZE;
	argdesc->bDescriptorType =	USB_DT_ENDPOINT;
	argdesc->bmAttributes =		USB_ENDPOINT_XFER_BULK;
	argdesc->wMaxPacketSize =	cpu_to_le16(512);
}

/*fBXNv^̏*/
static void init_comp_descriptor(struct compsoite_desc_st *argdesc){
	
	int i = 0;
	for(i=0;i<UCNEC2_MAX_IF_NUM;i++){
		init_intf_descriptor(&(argdesc->inter_desc));
		init_end_descriptor(&(argdesc->end_desc_out));
		init_end_descriptor(&(argdesc->end_desc_in));
		argdesc++;
	}
	
}
/*hCo[h̏*/
static int __init
init(void)
{
	int status;
	int i =0;
	struct printer_dev	*dev;
	int major_num=0;
	
	USBDEV_DPRINTK( KERN_INFO "__init\n" );
	usb_gadget_class = class_create(THIS_MODULE, "usb_gadget_driver");
	if (IS_ERR(usb_gadget_class)) {
		status = PTR_ERR(usb_gadget_class);
		pr_err("unable to create usb_gadget class %d\n", status);
		return status;
	}
	
	status = alloc_chrdev_region(&usb_gadget_devno, major_num,MINOR_COUNT,"USB_gadget_driver");
	major_num = MAJOR(usb_gadget_devno);
	//usb_gadget_devno = MKDEV(NUM_CHAR_MAJOR, 0);
	//status = register_chrdev_region(usb_gadget_devno,MINOR_COUNT,"USB_gadget_driver");
	if (status < 0) {
		pr_err("register_chrdev_region %d\n", status);
		class_destroy(usb_gadget_class);
		return status;
	}
	dev = &usb_printer_gadget;
	spin_lock_init(&dev->lock);
	mutex_init(&dev->lock_printer_io);
	//spin_lock_init(&simva_usb_lock);
	//spin_lock_irq(&simva_usb_lock);
	
	for(i=0;i<MINOR_COUNT;i++)
	{
		usb_gadget_devno = MKDEV(major_num, i+1);
		/* Setup the sysfs files for the printer gadget. */
		dev->pdev = device_create(usb_gadget_class, NULL, usb_gadget_devno,
					  NULL, device_file[i]);
		if (IS_ERR(dev->pdev)) {
			ERROR(dev, "Failed to create device: g_printer\n");
			status = PTR_ERR(dev->pdev);
			goto __init_fail;
		}

		/*
		 * Register a character device as an interface to a user mode
		 * program that handles the printer specific functionality.
		 */
		cdev_init(&dev->printer_cdev, &printer_io_operations);
		dev->printer_cdev.owner = THIS_MODULE;
		status = cdev_add(&dev->printer_cdev, usb_gadget_devno, MINOR_COUNT);
		if (status) {
			ERROR(dev, "Failed to open char device\n");
			goto __init_fail;
		}
	}
	for(i=0;i<USB_DIR_NUM;i++)
	{
		/*DMA~ɂĂ*/
		dev->bulkout_state[i] = UBS_DMA_OFF;
		dev->bulkin_state[i] = UBS_DMA_OFF;
		dev->bout_cdev_open[i] = 0;
		dev->bin_cdev_open[i] = 0;
		INIT_LIST_HEAD(&dev->tx_reqs[i]);
		INIT_LIST_HEAD(&dev->tx_reqs_active[i]);
		INIT_LIST_HEAD(&dev->rx_reqs[i]);
		INIT_LIST_HEAD(&dev->rx_reqs_active[i]);
		INIT_LIST_HEAD(&dev->rx_buffers[i]);
		init_waitqueue_head(&dev->rx_wait[i]);
		init_waitqueue_head(&dev->tx_wait[i]);
		init_waitqueue_head(&dev->tx_flush_wait[i]);
		dev->in_buf[i] = NULL;
		dev->out_buf[i] = NULL;
	}
	for(i=0;i<UCNEC2_MAX_IF_NUM;i++){
		dev->isSetIF_dev[i]=0;
	}
	//init_waitqueue_head(&rx_wait_queue);
	//pthread_mutex_init(&us_mutex, NULL);
	/*WFbghCooChĂȂ|ݒ*/
	dev->gadget_status = USB_GADGET_OFF;
	dev->current_state = 0;
	dev->call_attached = 0;
	USB_STATE_FLAG = 0;
	Notify_list.Notify_cnt = 0;
	dev->num_inter_hs = 0;
	dev->num_inter_fs = 0;
	dev->cnt_notify_usbd = 0;
	dev->dev_listp = NULL;
	dev->reboot = 0;
	
	strings[USB_STRDESC_PRN].id = 0x04;
	strings[USB_STRDESC_SCN].id = 0x05;
	strings[USB_STRDESC_NUMee].id = 0xee;
	
	ptr_usb_simva_wqueue = create_workqueue(USB_WQUEUE_NAME);
	if (!ptr_usb_simva_wqueue) {
		USBDEV_DPRINTK(KERN_WARNING "Can't create workqueue_struct! orz!!!\n");
		status = -1;
		goto __init_fail;
	}

	INIT_WORK((work_struct_t*)(&usb_work_struct_out), usb_work_wqueue_handler);
	INIT_WORK((work_struct_t*)(&usb_work_struct_in), usb_work_wqueue_handler);
	usb_work_struct_out.priv = &usb_printer_gadget;
	usb_work_struct_in.priv = &usb_printer_gadget;
	/*fBXNv^̏*/
	init_comp_descriptor(dev->hs_comdesc);
	init_comp_descriptor(dev->fs_comdesc);
	/*altݒ̏*/
	set_alt_val(0xFF);
	
	dev->init_fail = 0;
	dev->current_alt = 0x00;
	return status;
	
__init_fail:
	dev->init_fail = 1;
	class_destroy(usb_gadget_class);
	unregister_chrdev_region(usb_gadget_devno, 1);
	pr_err("usb_gadget_probe_driver %x\n", status);
	return status;
}
module_init(init);

/*hCoA[h̏I*/
static void __exit
cleanup(void)
{
	struct printer_dev	*dev;
	int i = 0;
	USBDEV_DPRINTK( KERN_INFO "__exit\n" );
	
	dev = &usb_printer_gadget;
	
	/**/
	for (i=0;i<usb_interface_num;i++)
	{
		vfree(dev->out_buf[i]);
		vfree(dev->in_buf[i]);
	}
	
	kfree(p_manufacture_string);
	kfree(p_product_string);
	kfree(p_serial_string);
	kfree(p_print_string);
	kfree(p_scan_string);
	kfree(p_NUMee_string);

	mutex_lock(&usb_printer_gadget.lock_printer_io);
	usb_composite_unregister(&printer_driver);
	unregister_chrdev_region(usb_gadget_devno, 1);
	class_destroy(usb_gadget_class);
	mutex_unlock(&usb_printer_gadget.lock_printer_io);
}
module_exit(cleanup);

MODULE_DESCRIPTION(DRIVER_DESC);
MODULE_AUTHOR("Ricoh");
MODULE_LICENSE("GPL");
