/*
**************************************************************************
This Source Code Form is subject to the terms of the Mozilla Public
License, v. 2.0. If a copy of the MPL was not distributed with this file,
You can obtain one at http://mozilla.org/MPL/2.0/.

Copyright (c) 2009-2014, Marvell International Ltd.

Alternatively, this software may be distributed under the terms of the GNU
General Public License Version 2, and any use shall comply with the terms and
conditions of the GPL.  A copy of the GPL is available at
http://www.gnu.org/licenses/old-licenses/gpl-2.0.html

THE FILE IS DISTRIBUTED AS-IS, WITHOUT WARRANTY OF ANY KIND, AND THE
IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE
ARE EXPRESSLY DISCLAIMED.  The GPL license provides additional details about
this warranty disclaimer.
******************************************************************************
*/



#ifndef XENA_H
#define XENA_H



// Global typedefs
typedef unsigned       int  UINT32;
typedef unsigned short int  UINT16;
typedef unsigned       char UINT8;
typedef signed         int  SINT32;
typedef signed   short int  SINT16;
typedef signed         char SINT8;



// Views from CPUs
#define SDTCM_BASE 0x04000000
#define REGBASE 0x08000000



// Views from Prefetch
#define IO_DTCM_OFFSET 0xe4000000
#define FM_DTCM_OFFSET 0xf4000000



// Internal Interrupt Map
#define INT_TIMER0        0x00000001
#define INT_TIMER1        0x00000002
#define INT_TIMER2        0x00000004
#define INT_TIMER3        0x00000008
#define INT_MAILBOX0      0x00000010
#define INT_MAILBOX1      0x00000020
#define INT_MAILBOX2      0x00000040
#define INT_MAILBOX3      0x00000080
#define INT_MAILBOX4      0x00000100
#define INT_MAILBOX5      0x00000200
#define INT_PHASE0        0x00000400
#define INT_PHASE1        0x00000800
#define INT_PHASE2        0x00001000
#define INT_PHASE3        0x00002000
#define INT_FIRE0         0x00004000
#define INT_FIRE1         0x00008000
#define INT_FIRE2         0x00010000
#define INT_FIRE3         0x00020000
#define INT_FIRE4         0x00040000
#define INT_FIRE5         0x00080000
#define INT_FIRE6         0x00100000
#define INT_FIRE7         0x00200000
#define INT_PREFETCH      0x00400000
#define INT_CLOCKGEN0     0x00800000
#define INT_CLOCKGEN1     0x01000000
#define INT_CLOCKGEN2     0x02000000
#define INT_CLOCKGEN3     0x04000000
#define INT_INPUT0        0x08000000
#define INT_INPUT1        0x10000000
#define INT_INPUT2        0x20000000
#define INT_INPUT3        0x40000000
#define INT_RESERVED0     0x80000000
#define INT1_FIFOLEVEL0   0x00000001
#define INT1_FIFOLEVEL1   0x00000002
#define INT1_FIFOLEVEL2   0x00000004
#define INT1_FIFOLEVEL3   0x00000008
#define INT1_FIFOLEVEL4   0x00000010
#define INT1_FIFOLEVEL5   0x00000020
#define INT1_FIFOLEVEL6   0x00000040
#define INT1_FIFOLEVEL7   0x00000080
#define INT1_CLOCKGEN4    0x00000100
#define INT1_CLOCKGEN5    0x00000200
#define INT1_CLOCKGEN6    0x00000400
#define INT1_CLOCKGEN7    0x00000800
#define INT1_RESERVED0    0x00001000
#define INT1_RESERVED1    0x00002000
#define INT1_RESERVED2    0x00004000
#define INT1_RESERVED3    0x00008000
#define INT1_FIFOOF0      0x00010000
#define INT1_FIFOOF1      0x00020000
#define INT1_FIFOOF2      0x00040000
#define INT1_FIFOOF3      0x00080000
#define INT1_FIFOOF4      0x00100000
#define INT1_FIFOOF5      0x00200000
#define INT1_FIFOOF6      0x00400000
#define INT1_FIFOOF7      0x00800000
#define INT1_FIFOUF0      0x01000000
#define INT1_FIFOUF1      0x02000000
#define INT1_FIFOUF2      0x04000000
#define INT1_FIFOUF3      0x08000000
#define INT1_FIFOUF4      0x10000000
#define INT1_FIFOUF5      0x20000000
#define INT1_FIFOUF6      0x40000000
#define INT1_FIFOUF7      0x80000000



// Useful macros
#define TRACE(x) *((volatile unsigned *)(0x4)) = x

#define NULL ((void *)(0x0))

#define DRAIN_WRBUF                                    \
  asm volatile ("mcr     p15,0,r0,c7,c10,4")

#define CPU_NOP                                        \
  asm volatile ("nop")

#define CPU_NOP2                                        \
  CPU_NOP;                                              \
  CPU_NOP

#define CPU_NOP5                                        \
  CPU_NOP;                                              \
  CPU_NOP;                                              \
  CPU_NOP;                                              \
  CPU_NOP;                                              \
  CPU_NOP

#define CPU_NOP10                                       \
  CPU_NOP5;                                             \
  CPU_NOP5

#define WAIT_FOR_INT                                   \
{                                                      \
  asm volatile ("mcr     p15,0,r0,c7,c0,4");           \
}

#define DISABLE_IRQ                                     \
{                                                       \
  UINT32 tmp;                                           \
  asm volatile ("mrs %0, cpsr" : "=r" (tmp) : );        \
  tmp |= 0x00000080;                                    \
  asm volatile ("msr cpsr, %0" : : "r" (tmp));          \
}

#define ENABLE_IRQ                                      \
{                                                       \
  UINT32 tmp;                                           \
  asm volatile ("mrs %0, cpsr" : "=r" (tmp) : );        \
  tmp &= 0xffffff7f;                                    \
  asm volatile ("msr cpsr, %0" : : "r" (tmp));          \
}

#define WAIT_FOR_INT_WHILE(x)                           \
{                                                       \
  asm volatile ("push    {r6-r7, fp}              \n    \
                 b       WAIT_FOR_INT_WHILE_label2\n    \
                 WAIT_FOR_INT_WHILE_label1:       \n    \
                 mrs     r7, cpsr                 \n    \
                 bic     r7, #192                 \n    \
                 msr     cpsr, r7                 \n    \
                 mcr     p15,0,r0,c7,c0,4         \n    \
                 WAIT_FOR_INT_WHILE_label2:       \n    \
                 mrs     r7, cpsr                 \n    \
                 orr     r7, #192                 \n    \
                 msr     cpsr, r7                 \n    \
                 ldr     r6, [%0]                 \n    \
                 cmp     r6, #0                   \n    \
                 bne     WAIT_FOR_INT_WHILE_label1\n    \
                 mrs     r7, cpsr                 \n    \
                 bic     r7, #192                 \n    \
                 msr     cpsr, r7                 \n    \
                 pop     {r6-r7, fp}"                   \
                 : : "r" (&x));                         \
}

#define CLEAR_COPO                                      \
  asm volatile ("cdp p0, 8, c15, c15, c15, 7");         \
  asm volatile ("cdp p0, 8, c14, c14, c14, 7");         \
  asm volatile ("cdp p0, 8, c13, c13, c13, 7");         \
  asm volatile ("cdp p0, 8, c12, c12, c12, 7");         \
  asm volatile ("cdp p0, 8, c11, c11, c11, 7");         \
  asm volatile ("cdp p0, 8, c10, c10, c10, 7");         \
  asm volatile ("cdp p0, 8, c9, c9, c9, 7");            \
  asm volatile ("cdp p0, 8, c8, c8, c8, 7");            \
  asm volatile ("cdp p0, 8, c7, c7, c7, 7");            \
  asm volatile ("cdp p0, 8, c6, c6, c6, 7");            \
  asm volatile ("cdp p0, 8, c5, c5, c5, 7");            \
  asm volatile ("cdp p0, 8, c4, c4, c4, 7");            \
  asm volatile ("cdp p0, 8, c3, c3, c3, 7");            \
  asm volatile ("cdp p0, 8, c2, c2, c2, 7");            \
  asm volatile ("cdp p0, 8, c1, c1, c1, 7");            \
  asm volatile ("cdp p0, 8, c0, c0, c0, 7");            \
  asm volatile ("cdp p0, 8, c15, c15, c15, 0");         \
  asm volatile ("cdp p0, 8, c14, c14, c14, 0");         \
  asm volatile ("cdp p0, 8, c13, c13, c13, 0");         \
  asm volatile ("cdp p0, 8, c12, c12, c12, 0");         \
  asm volatile ("cdp p0, 8, c11, c11, c11, 0");         \
  asm volatile ("cdp p0, 8, c10, c10, c10, 0");         \
  asm volatile ("cdp p0, 8, c9, c9, c9, 0");            \
  asm volatile ("cdp p0, 8, c8, c8, c8, 0");            \
  asm volatile ("cdp p0, 8, c7, c7, c7, 0");            \
  asm volatile ("cdp p0, 8, c6, c6, c6, 0");            \
  asm volatile ("cdp p0, 8, c5, c5, c5, 0");            \
  asm volatile ("cdp p0, 8, c4, c4, c4, 0");            \
  asm volatile ("cdp p0, 8, c3, c3, c3, 0");            \
  asm volatile ("cdp p0, 8, c2, c2, c2, 0");            \
  asm volatile ("cdp p0, 8, c1, c1, c1, 0");            \
  asm volatile ("cdp p0, 8, c0, c0, c0, 0")

#define SEMAPHORE_TEST_AND_SET(x,y)                     \
  asm volatile ("swp %0, %1, [%2]" : "=r" (y) : "0" (1), "r" (&x))

#define SEMAPHORE_TEST_AND_CLEAR(x,y)                   \
  asm volatile ("swp %0, %1, [%2]" : "=r" (y) : "0" (0), "r" (&x))

#define SEMAPHORE_TEST_AND_ASSIGN(x,y)                  \
  asm volatile ("swp %0, %1, [%2]" : "=r" (y) : "0" (y), "r" (&x))


#include "Xena_regheaders.h"

#endif
