/*----------------------------------------------------------------------------
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * The software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with the this software; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA.
 */
#ifndef _MV_MMP_PANEL_H_
#define _MV_MMP_PANEL_H_

#if 0
#define __MV_MMP_PANEL_DEBUG__
#endif

#ifdef __MV_MMP_PANEL_DEBUG__
#define MV_MMPPANELDBG(...) printf(__VA_ARGS__)
#else
#define MV_MMPPANELDBG(...)
#endif

#include <linux/types.h>
#include <video/display_timing.h>
/*
 * Search for and initialize the mv_mmp panel.
 * Returns 0 if successful; otherwise returns non-zero.
 */
int  mv_mmp_panel_init(void);

/*
 * Status codes to post to panel
 */
typedef enum {
	/* panel status messages */

	/* Clears the panel -- no arguments. */
	MV_MMP_PANEL_BLANK,
	MV_MMP_PANEL_DRAMTEST_START,
	MV_MMP_PANEL_DRAMTEST_DONE,
	MV_MMP_PANEL_DRAMTEST_FAIL,
	MV_MMP_PANEL_DRAMTEST_DIAG,
	/* (msg, int memsize_MiB, int cpu_speed_MHz) */
	MV_MMP_PANEL_MEMSIZE_CPUSPEED,
	MV_MMP_PANEL_SCROLLING_DOT,
	MV_MMP_PANEL_EARLY_MEMORY_TEST,

	/* panel error messages */
	MV_MMP_PANEL_ASIC1_FAIL,
	MV_MMP_PANEL_BAD_MBRSIZE,
	MV_MMP_PANEL_DECOMPRESS_ERROR,
	MV_MMP_PANEL_DECOMPRESS_FAIL,
	MV_MMP_PANEL_ECC_ERROR,
	MV_MMP_PANEL_ECC_FAIL,
	MV_MMP_PANEL_FLASH_ERROR,
	MV_MMP_PANEL_MEMORY_ERROR,
	MV_MMP_PANEL_NO_DRAM,
	MV_MMP_PANEL_NO_NVRAM,
	MV_MMP_PANEL_ROMCRC_ERROR,
	MV_MMP_PANEL_UNSUPPORTED_FIRMWARE, 
	MV_MMP_PANEL_EXCESSIVE_MEMORY_ERROR,
	MV_MMP_PANEL_WATCHDOG_ERROR,
	MV_MMP_PANEL_NO_MBR,
	MV_MMP_PANEL_UNSUPPORTED_FLASHCARD,
	MV_MMP_PANEL_ENGINELESS_STRING,
	MV_MMP_PANEL_FLS_STR,
	MV_MMP_PANEL_VERSIONS,
	MV_MMP_PANEL_AUTH_FAIL
} MV_MMP_PANEL_STATUS;

/*
 * Write the specified message to the panel.
 */
void mv_mmp_panel_status(int msg, ...);

/*
 * Get the current buttons value.
 */
unsigned long long mv_mmp_panel_get_buttons(void);

/*
 * Available panel types. The values need to match uboot-apps/cmdline.c,
 * so set the values explicitly.
 */
typedef enum {
	MV_MMP_PANEL_TYPE_SFP_SBCS_THINLCD	= 1,
	MV_MMP_PANEL_TYPE_MFP_SBCS_THINLCD	= 2,
	MV_MMP_PANEL_TYPE_SFP_DBCS_THINLCD	= 3,
	MV_MMP_PANEL_TYPE_MFP_DBCS_THINLCD	= 4,
	MV_MMP_PANEL_TYPE_SFP_THINLED	= 5,
	MV_MMP_PANEL_TYPE_160X64		= 6,
	MV_MMP_PANEL_TYPE_ATMEL_2LINE	= 7,
	MV_MMP_PANEL_TYPE_ATMEL_LED	= 8,
	MV_MMP_PANEL_TYPE_480X272		= 9,
	MV_MMP_PANEL_TYPE_800X480		= 10,
        MV_MMP_PANEL_TYPE_320X240		= 11,
	MV_MMP_PANEL_TYPE_800X480_SCALED	= 12,
	MV_MMP_PANEL_TYPE_480X272_FIXW	= 13,
	MV_MMP_PANEL_TYPE_800X480_FIXW	= 14,
	MV_MMP_PANEL_TYPE_480X272_PROTO	= 15,
	MV_MMP_PANEL_TYPE_480X272_NON_SEQ	= 16,
	MV_MMP_PANEL_TYPE_1024X600		= 17,
	MV_MMP_PANEL_TYPE_DYNAMIC		= 18,

	MV_MMP_PANEL_TYPE_INVALID = -1,
} MV_MMP_PANEL_TYPE;

typedef struct {
	MV_MMP_PANEL_TYPE		mv_mmp_type;
	const char		*name;
	struct display_timing	dt;
} mv_mmp_gen2_display_info_t;

/*
 * Get the panel type.
 * Returns -1 if unknown, otherwise, returns a valid panel type value from
 * the MV_MMP_PANEL_TYPE enum.
 */
int mv_mmp_panel_get_type(void);

/*
 * Get the panel subtype string.
 * Returns null pointer if not applicable.
 */
char *mv_mmp_panel_get_subtype(void);

/*
 * Check the external clock requirement
 * Enumeration is overkill for now, but may need more specific values with future hw.
 */
typedef enum {
	/* 
	 * verkill for now. but may need more values in future to specify behavior */
	MV_MMP_PANEL_EXT_CLK_UNUSED = 0,
	MV_MMP_PANEL_EXT_CLK_USED,
} mv_mmp_panel_ext_clk_requirement_t;

mv_mmp_panel_ext_clk_requirement_t mv_mmp_panel_clk_required(void);

typedef struct 
{
	int (*probe)(void);
	void (*status)(MV_MMP_PANEL_STATUS type, va_list ap); 
	unsigned long long (*buttons)(void);
	int (*type)(void);
	char *(*subtype)(void);
	mv_mmp_panel_ext_clk_requirement_t (*ext_clk_required)(void);
} mv_mmp_panel_ctl_t;

/*
 * LVDS bit-mapping options for RGB888 (24bpp)
 */
typedef enum {
	LVDS_UNKNOWN = 0,
	LVDS_BPP18,
	/* Option-1 or Format-1, two MSB of each color mapped to optional LVDS pair */
	LVDS_BPP24_OPTION_1,
	/* Option-2 or Format-2, two LSB of each color mapped to optional LVDS pair */
	LVDS_BPP24_OPTION_2,
	LVDS_UNUSED,
} __attribute__((packed)) lvds_bit_mapping_t;

/*
 * Get the size of the video buffer.
 */
unsigned int mv_mmp_vram_size(void);

/* Panel-specific prototypes */
int  mv_mmp_panel_2x16v0_probe(void);
void mv_mmp_panel_2x16v0_status(MV_MMP_PANEL_STATUS msg, va_list ap); 
unsigned long long mv_mmp_panel_2x16v0_buttons(void);
int mv_mmp_panel_2x16v0_type(void);

int  mv_mmp_panel_2x16v1_probe(void);
void mv_mmp_panel_2x16v1_status(MV_MMP_PANEL_STATUS msg, va_list ap); 
unsigned long long mv_mmp_panel_2x16v1_buttons(void);
int mv_mmp_panel_2x16v1_type(void);

int  mv_mmp_panel_160x64_probe(void);
void mv_mmp_panel_160x64_status(MV_MMP_PANEL_STATUS msg, va_list ap);
unsigned long long mv_mmp_panel_160x64_buttons(void);
int mv_mmp_panel_160x64_type(void);

int  mv_mmp_panel_vga_probe(void);
void mv_mmp_panel_vga_status(MV_MMP_PANEL_STATUS msg, va_list ap); 
unsigned long long mv_mmp_panel_vga_buttons(void);
int mv_mmp_panel_vga_type(void);
char *mv_mmp_panel_vga_subtype(void);
mv_mmp_panel_ext_clk_requirement_t mv_mmp_panel_vga_extclkreq(void);

int  mv_mmp_panel_vga_probe_gen2(void);
unsigned long long mv_mmp_panel_vga_buttons_gen2(void);
int mv_mmp_panel_vga_type_gen2(void);
char *mv_mmp_panel_vga_subtype_gen2(void);

int  mv_mmp_panel_lb_vga_probe(void);
unsigned long long mv_mmp_panel_lb_vga_buttons(void);
int mv_mmp_panel_lb_vga_type(void);
char *mv_mmp_panel_lb_vga_subtype(void);
mv_mmp_panel_ext_clk_requirement_t mv_mmp_panel_lb_vga_extclkreq(void);

int mv62xx_disp_ref_panel_probe( void );
void mv62xx_disp_ref_panel_status(MV_MMP_PANEL_STATUS type, va_list ap);
unsigned long long mv62xx_disp_ref_panel_buttons(void);
int mv62xx_disp_ref_panel_type(void);
char * mv62xx_disp_ref_panel_subtype(void);
mv_mmp_panel_ext_clk_requirement_t mv62xx_disp_ref_panel_extclkreq(void);

int mv_mmp_mv61fb_smart_panel_init(void *reg_base, void *buffer);
int mv_mmp_mv61fb_dumb_panel_init(void *reg_base, void *buffer);
#ifdef CONFIG_MV_MMP_PANEL_VGA_ARMADA
int mv_mmp_armada_dumb_panel_init(void *reg_base, void *buffer);
#endif

int lcd_pll_init(void *reg_base, uint32_t pixelclk_hz);
int lcd_lvds_init(void *reg_base, uint32_t pixelclk_hz, lvds_bit_mapping_t lvds_option);

#define NM_RETURN      (1 << 0)
#define NM_MENU        (1 << 1)
#define NM_HOME        NM_MENU
#define NM_STOP        (1 << 2)
#define NM_UP          (1 << 3)
#define NM_DOWN        (1 << 4)
#define NM_LEFT        (1 << 5)
#define NM_RIGHT       (1 << 6)
#define NM_SELECT      (1 << 7)
#define NM_1           (1 << 8)
#define NM_2           (1 << 9)
#define NM_3           (1 << 10)
#define NM_4           (1 << 11)
#define NM_5           (1 << 12)
#define NM_6           (1 << 13)
#define NM_7           (1 << 14)
#define NM_8           (1 << 15)
#define NM_9           (1 << 16)
#define NM_STAR        (1 << 17)
#define NM_0           (1 << 18)
#define NM_POUND       (1 << 19)
#define NM_UNUSED      (1 << 20)
#define NM_GO          (1 << 21)
#define NM_BACKSPACE   (1 << 22)
#define NM_PAUSE       (1 << 23)
#define NM_HELP        (1 << 24)
#define NM_CLEAR       (1 << 25)
#define NM_GO_MONO     (1 << 26)

#endif  /* _MV_MMP_PANEL_H_ */
