#define FCERT_MAGIC 0x15C7ABB4

#define FCERT_USE_FLAGS_PROD_KEY  0x01  /* production key */
#define FCERT_USE_FLAGS_SIGN_KEY  0x02  /* can sign signing keys */
#define FCERT_USE_FLAGS_SIGN_CODE 0x04  /* can sign code */
#define FCERT_USE_FLAGS_SIGN_PART 0x08  /* can sign devices */
struct fcert_head {
    uint32_t magic;    /* magic 0x15C7ABB4 "Fcert" in base64 */
    uint32_t length;   /* Certificate length including header */
    uint8_t version;   /* Certificate version */
    uint8_t ver_flags; /* Certificate ver specific flags */
    uint8_t use_flags; /* Key capability flags */
    uint8_t depth;     /* Distance certificate from root */
};

#define FCERT_V3_CODE_NAME_LEN 64
#define SHA256_DIGEST_LEN 32
struct fcert_v3_code {
    uint8_t  name[FCERT_V3_CODE_NAME_LEN]; /* name of code being signed */
    uint32_t len;                          /* size of data hashed */
    uint8_t  sha256[SHA256_DIGEST_LEN];    /* sha256 hash value */
};

#define FCERT_V3_RSA_KEY_MODULUS_LEN 256
#define FCERT_V3_RSA_KEY_EXPONENT_LEN 4

#define FCERT_V3_TRACKING_ID_LEN 64
#define FCERT_V3_SIGNATURE_LEN FCERT_V3_RSA_KEY_MODULUS_LEN
#define FCERT_V3_HSM_ESN_LEN 16
#define FCERT_V3_REQUEST_NAME_LEN 32
#define FCERT_V3_KEY_ID_LEN 32

struct fcert_v3 {
    struct   fcert_head head;              /* header */
    struct   fcert_v3_code code;           /* info of signed code */
    uint8_t  key_id[FCERT_V3_KEY_ID_LEN];  /* ID of signing key */
    uint8_t  requester[FCERT_V3_REQUEST_NAME_LEN]; /* ID requesting sig */
    uint8_t  web_version[2];               /* web service version */
    uint32_t sig_date;                     /* Time cert was signed */
    uint8_t  id[FCERT_V3_TRACKING_ID_LEN]; /* tracking ID */
    uint8_t  hsm[FCERT_V3_HSM_ESN_LEN];    /* ESN of signing HSM */
    uint8_t  fm_version[2];                /* FM version */
    uint8_t  sig[FCERT_V3_SIGNATURE_LEN];  /* signature */
} __attribute__((packed));
