#ifndef __EXPORTS_H__
#define __EXPORTS_H__

#ifndef __ASSEMBLY__

/* These are declarations of exported functions available in C code */
unsigned long get_version(void);
int  getc(void);
int  tstc(void);
void putc(const char);
void puts(const char*);
int printf(const char* fmt, ...);
void install_hdlr(int, void (*interrupt_handler_t)(void *), void*);
void free_hdlr(int);
void *malloc(size_t);
void free(void*);
void udelay(unsigned long);
unsigned long get_timer(unsigned long);
int vprintf(const char *, va_list);
unsigned long simple_strtoul(const char *cp,char **endp,unsigned int base);
int strict_strtoul(const char *cp, unsigned int base, unsigned long *res);
char *getenv (const char *name);
int setenv (const char *varname, const char *varvalue);
long simple_strtol(const char *cp,char **endp,unsigned int base);
int strcmp(const char * cs,const char * ct);
unsigned long ustrtoul(const char *cp, char **endp, unsigned int base);
unsigned long long ustrtoull(const char *cp, char **endp, unsigned int base);
#if 0
#if defined(CONFIG_CMD_I2C)
int i2c_write (uchar, uint, int , uchar* , int);
int i2c_read (uchar, uint, int , uchar* , int);
#endif
#endif

int i2c_write (unsigned char, unsigned int, int , unsigned char* , int);
int i2c_read (unsigned char, unsigned int, int , unsigned char* , int);
size_t strlen(const char * s);
char * strstr(const char *,const char *);
int	sprintf(char * buf, const char *fmt, ...)
		__attribute__ ((format (__printf__, 2, 3)));
void * memcpy(void *dest, const void *src, size_t count);
unsigned long long simple_strtoull(const char *cp, char **endp, unsigned int base);

void app_startup(char * const *);
void mv_mmp_panel_status(int, ...);
unsigned long long mv_mmp_panel_get_buttons(void);
int  run_command(const char *cmd, int flag);
int i2c_set_bus_num(unsigned int bus);
unsigned int i2c_get_bus_num(void);
void mmc_switch_sd0_pins(int use_sd);
void no_panel_beep_loop(void);
#ifdef CONFIG_MARVELL
#include <spi.h>
#endif

#endif    /* ifndef __ASSEMBLY__ */

enum {
#define EXPORT_FUNC(x) XF_ ## x ,
#include <_exports.h>
#undef EXPORT_FUNC

	XF_MAX
};

#define XF_VERSION	8

#if defined(CONFIG_X86)
extern gd_t *global_data;
#endif

#endif	/* __EXPORTS_H__ */
