#include <dovefbreg.h>
#include <common.h>
#include <div64.h>
#include <asm/io.h>
#include <lcd.h>
#include <mv_mmp_panel.h>
#include <lcd.h>
#include "mv_mmp_eeprom_info.h"
#include "mv_mmp_panel_common.h"

#define REF_RATE_HZ (64)

/* 
 * Adding these two stubs as they are called from arch/arm/cpu/arm1136/cpu.c since CONFIG_LCD is now turned on.
 */
void lcd_disable       (void) { printf("%s: stubbed\n", __func__); }
void lcd_panel_disable (void) { printf("%s: stubbed\n", __func__); }

/*
 * Period(pS) = (1x10^12)/Frequency(Hz)
 */
static uint32_t picoseconds_to_hz(uint32_t picoseconds)
{
	uint32_t hz;
	uint64_t div_result;

	div_result = 1000000000000ll;
	do_div(div_result, picoseconds);
	hz = (uint32_t)div_result;

	return hz;
}

static void lcd_lvds_pll_init(void *reg_base, vga_panel_data *vpd,
			uint32_t def_pixelclk_hz, lvds_bit_mapping_t lvds_option)
{
	/*
	 * Initialize vga clock PLL
	 * Note: pixelclock specified as period in pS for commonality with linux.
	 */
	uint32_t pixelclk_hz;
	char *lvds_type;

	if(vpd->dt->pixelclock.typ) {
		pixelclk_hz = picoseconds_to_hz(vpd->dt->pixelclock.typ);
#ifdef CONFIG_MV_MMP_PANEL_VGA_PEGMATITE
		if(vpd->hscalar > 0)
			pixelclk_hz *= vpd->hscalar;
#endif
	}
	else {
		/* def_pixelclk_hz has already been scaled if needed */
		pixelclk_hz = def_pixelclk_hz;
	}

	switch(lvds_option) {
		case LVDS_UNUSED:
			lvds_type = "UNUSED";
			break;
		case LVDS_BPP24_OPTION_1:
			lvds_type = "24bpp Option 1";
			break;
		default:
			lvds_type = "24bpp Option 2 or 18bpp";
			break;
	}
	printf("%s: Requesting dotclk=%dHz, lvds_option=%s\n", __func__,
			pixelclk_hz, lvds_type);
			
	lcd_lvds_init(reg_base, pixelclk_hz, lvds_option);
	lcd_pll_init(reg_base, pixelclk_hz);
}

static int gamma_lut_entry(void *reg_base, int index, uint32_t channel, uint32_t value) {
	uint32_t tmp;

	/* write gamma LUT entry */
	tmp = CFG_SRAM_INIT_WR_RD(SRAMID_INIT_WRITE) | CFG_SRAM_ADDR(index) |
			CFG_SRAM_ADDR_LCDID(channel);

	writel(value, reg_base + LCD_SPU_SRAM_WRDAT);
	udelay(20);

	writel(tmp, reg_base + LCD_SPU_SRAM_CTRL);
	udelay(20);

	/* verify gamma LUT entry */
	tmp = CFG_SRAM_INIT_WR_RD(SRAMID_INIT_READ) | CFG_SRAM_ADDR(index) |
			CFG_SRAM_ADDR_LCDID(channel);
	writel(tmp, reg_base + LCD_SPU_SRAM_CTRL);
	udelay(20);

	tmp = readl(reg_base + LCD_SPU_GAMMA_RDDAT) & CFG_GAMMA_RDDAT_MASK;
	if(tmp != value) {
		printf("%s: verify error at entry %d channel %d, "
				"expected 0x%02x, read 0x%02x\n",
				__func__, index, channel, value, tmp);
		return -1;
	}

	return 0;
}

int mv_mmp_armada_gamma_init(void *reg_base, vga_panel_data *vpd)
{
	int i;
	int rc;
	uint32_t tmp;
	gamma_table_t *gamma = vpd->gamma;

	if(!gamma)
		return 0;

	/* allow writing gamma sram even if gamma is disabled */
	tmp = readl(reg_base + LCD_SPU_SRAM_PARA1);
	tmp |= CFG_CSB_256x8(0x1);
	writel(tmp, (reg_base + LCD_SPU_SRAM_PARA1));
	udelay(20);

	for(i = 0; i < sizeof(gamma->red); i++) {
		rc = gamma_lut_entry(reg_base, i, SRAMID_gamma_yr, (uint32_t)gamma->red[i]);
		if(rc)
			return -1;

		rc = gamma_lut_entry(reg_base, i, SRAMID_gamma_ug, (uint32_t)gamma->green[i]);
		if(rc)
			return -1;

		rc = gamma_lut_entry(reg_base, i, SRAMID_gamma_vb, (uint32_t)gamma->blue[i]);
		if(rc)
			return -1;
	}

	/* enable gamma */
	tmp = readl(reg_base + LCD_SPU_DMA_CTRL0);
	tmp |= CFG_GAMMA_ENA(1);
	writel(tmp, reg_base + LCD_SPU_DMA_CTRL0);

	/* disable writing gamma sram unless gamma is enabled */
	tmp = readl(reg_base + LCD_SPU_SRAM_PARA1);
	tmp &= ~(CFG_CSB_256x8_MASK);
	writel(tmp, (reg_base + LCD_SPU_SRAM_PARA1));

	return 0;
}

int mv_mmp_armada_dumb_panel_init(void *reg_base, void *buffer)
{
        char string[32];
	vga_panel_info *vpi = NULL;
	vga_panel_data *vpd = NULL;
	unsigned tmp;
	unsigned bufsize;
#ifndef CONFIG_MV_MMP_PANEL_VGA_PEGMATITE
	unsigned int i;
#endif
	int bytes_per_pel = NBITS(panel_info.vl_bpix)/8;
	uint16_t xtotal, ytotal;

	vpd = (vga_panel_data *)panel_info.priv;

	if(!vpd) {
		printf("%s:%d: no panel data found\n", __func__, __LINE__);
		return -1;
	}

	vpi = (vga_panel_info *)&vpd->vpi;
		
	if(PANEL_FLAGS1_PIXEL_DEPTH(vpi->flags1) != PIXEL_DEPTH_16) {
		printf("%s:%d: unsupported color depth\n", __func__, __LINE__);
		return -1;
	}

	bufsize = panel_info.vl_row*panel_info.vl_col*bytes_per_pel;
	// TODO: compare panel_info dimensions to actual

	tmp = mv_mmp_vram_size();

	printf("vram buffer: %8p bufsize: %x tmp: %x \n", buffer, bufsize, tmp);

	if(bufsize > tmp) {
		printf("%s:%d: Error, display frame size 0x%08x exceeds frame buffer "
					"size 0x%08x\n", __func__, __LINE__, 
					bufsize, tmp);
		return -1;
	}	
	sprintf(string, "0x%08x@0x%p", tmp, buffer);
	setenv("vram",string);

#ifdef CONFIG_MV_MMP_PANEL_VGA_PEGMATITE
	/* 
	 * Enable 3x horizontal scaling to work around pll bug, requires ext hw. 
	 * Will be fixed in an asic ec. 
	 */
	{
		uint16_t dst_xres = vpd->xres;
		uint16_t dst_hfp = vpi->hfp;
		uint16_t dst_hpw = vpi->hpw;
		uint16_t dst_hbp = vpi->hbp;

		if(vpd->hscalar > 0) {
			printf("Adjusting display timing for PLL bug\n");
			/* scale horizontally to work around pll limitation */
			dst_xres *= vpd->hscalar;
			dst_hfp *= vpd->hscalar;
			dst_hpw *= vpd->hscalar;
			dst_hbp *= vpd->hscalar;
		}

		xtotal = dst_xres + dst_hfp + dst_hpw + dst_hbp;
		ytotal = vpd->yres + vpi->vfp + vpi->vpw + vpi->vbp;

		lcd_lvds_pll_init(reg_base, vpd, (xtotal * ytotal * REF_RATE_HZ), vpd->lvds);

		/*
		 * Configure visible display dimensions
		 */
		writel( (vpd->xres * bytes_per_pel), reg_base + LCD_CFG_GRA_PITCH); // 0fc
		writel( 0,   reg_base + LCD_SPU_GRA_OVSA_HPXL_VLN); // 100
		writel( ((vpd->yres << 16) | vpd->xres), reg_base + LCD_SPU_GRA_HPXL_VLN); // 104
		writel( ((vpd->yres << 16) | dst_xres), reg_base + LCD_SPU_GZM_HPXL_VLN); // 108
		/*
		 * Configure total screen dimensions
		 */
		writel( ((ytotal << 16) | xtotal),   reg_base + LCD_SPUT_V_H_TOTAL);         // 114
		writel( ((vpd->yres << 16) | dst_xres), reg_base + LCD_SPU_V_H_ACTIVE);  // 118

		/*
		 * Configure porch timing
		 */
		writel( ((dst_hbp << 16) | dst_hfp),   reg_base + LCD_SPU_H_PORCH); // 11c
		writel( ((vpi->vbp << 16) | vpi->vfp),   reg_base + LCD_SPU_V_PORCH); // 120
	}
#else
	xtotal = vpd->xres + vpi->hfp + vpi->hpw + vpi->hbp;
	ytotal = vpd->yres + vpi->vfp + vpi->vpw + vpi->vbp;

	lcd_lvds_pll_init(reg_base, vpd, (xtotal * ytotal * REF_RATE_HZ), vpd->lvds);

	/*
	 * Configure visible display dimensions
	 */
	writel( (vpd->xres * bytes_per_pel), reg_base + LCD_CFG_GRA_PITCH); // 0fc
	writel( 0,   reg_base + LCD_SPU_GRA_OVSA_HPXL_VLN); // 100
	writel( ((vpd->yres << 16) | vpd->xres), reg_base + LCD_SPU_GRA_HPXL_VLN); // 104
	writel( ((vpd->yres << 16) | vpd->xres), reg_base + LCD_SPU_GZM_HPXL_VLN); // 108
	/*
	 * Configure total screen dimensions
	 */
	xtotal = vpd->xres + vpi->hfp + vpi->hpw + vpi->hbp;
	ytotal = vpd->yres + vpi->vfp + vpi->vpw + vpi->vbp;

	writel( ((ytotal << 16) | xtotal),   reg_base + LCD_SPUT_V_H_TOTAL);         // 114
	writel( ((vpd->yres << 16) | vpd->xres), reg_base + LCD_SPU_V_H_ACTIVE);  // 118

	/*
	 * Configure porch timing
	 */
	writel( ((vpi->hbp << 16) | vpi->hfp),   reg_base + LCD_SPU_H_PORCH); // 11c
	writel( ((vpi->vbp << 16) | vpi->vfp),   reg_base + LCD_SPU_V_PORCH); // 120
#endif

	/*
	 * Write registers with values that the kernel driver ended up with.
	 */
	writel( 0x34801348, reg_base + LCD_SPU_ADV_REG);

	/*
	 * We are not using YUV color support.
	 */
	writel( 0x0, reg_base + LCD_SPU_DMA_START_ADDR_Y0);
	writel( 0x0, reg_base + LCD_SPU_DMA_START_ADDR_U0);
	writel( 0x0, reg_base + LCD_SPU_DMA_START_ADDR_V0);

	writel( 0x0, reg_base + LCD_CFG_DMA_START_ADDR_0);


	writel( 0x0, reg_base + LCD_SPU_DMA_START_ADDR_Y1);
	writel( 0x0, reg_base + LCD_SPU_DMA_START_ADDR_U1);
	writel( 0x0, reg_base + LCD_SPU_DMA_START_ADDR_V1);

	writel( 0x0, reg_base + LCD_CFG_DMA_START_ADDR_1);

	writel( 0x0, reg_base + LCD_SPU_DMA_PITCH_YC);
	writel( 0x0, reg_base + LCD_SPU_DMA_PITCH_UV);

	writel( 0x0, reg_base + LCD_SPUT_DMA_OVSA_HPXL_VLN);

	writel( 0x0, reg_base + LCD_SPU_DMA_HPXL_VLN);
	writel( 0x0, reg_base + LCD_SPU_DZM_HPXL_VLN);


	/*
	 * Set the graphics refresh buffer address.
	 */
	writel( (unsigned int) buffer, reg_base + LCD_CFG_GRA_START_ADDR0);
	writel( (unsigned int) buffer, reg_base + LCD_CFG_GRA_START_ADDR1);

	/*
	 * Cursor controls -- off.
	 */
	writel( 0,   reg_base + LCD_SPU_HWC_OVSA_HPXL_VLN);
	writel( 0,   reg_base + LCD_SPU_HWC_HPXL_VLN);   // 110

	/*
	 * black for blank data.
	 */
	writel( 0,   reg_base + LCD_SPU_BLANKCOLOR); // 124

	/*
	 * cursor colors -- not used.
	 */
	writel( 0,   reg_base +  LCD_SPU_ALPHA_COLOR1); // 128
	writel( 0,   reg_base +  LCD_SPU_ALPHA_COLOR2); // 12c

	writel( 0,   reg_base +   LCD_SPU_COLORKEY_Y);  // 130
	writel( 0,   reg_base +   LCD_SPU_COLORKEY_U);  // 134
	writel( 0,   reg_base +   LCD_SPU_COLORKEY_V);  // 138

#ifdef CONFIG_MV_MMP_PANEL_VGA_PEGMATITE
	/*
	 * VSYNC edge timing
	 */
	tmp = CFG_PN_V_SPXLCNT(1);
	tmp |= CFG_PN_V_EPXLCNT(xtotal);
	writel( tmp, reg_base + LCD_PN_SEPXLCNT);  // 13c
#else
	writel( 0x320,   reg_base +  LCD_CFG_RDREG4F);  // 13c
#endif


	/*
	 * SPU_DMA_CTRL0
	 */
	writel( 0x08005150, reg_base + LCD_SPU_DMA_CTRL0);  // 190
	writel( 0x28320081, reg_base + LCD_SPU_DMA_CTRL1);  // 194

	if(vpd->gamma) {
		mv_mmp_armada_gamma_init(reg_base, vpd);
	}
	else {
		/*
		 * SRAM control -- not in use.
		 */
		writel( 0,   reg_base + LCD_SPU_SRAM_CTRL);  // 198

#ifndef CONFIG_MV_MMP_PANEL_VGA_PEGMATITE
		/*
		 * SRAM power-down
		 */
		writel( 0x0000e000,   reg_base +  LCD_SPU_SRAM_PARA1);  // 1a4
#endif
	}

	writel( 0,   reg_base + LCD_SPU_CONTRAST);   // 1ac
	writel( 0,   reg_base + LCD_SPU_SATURATION); // 1b0
	writel( 0,   reg_base + LCD_SPU_CBSH_HUE);   // 1b4

	/*
	 * i/o pad control
	 */
	// select 24 bit output
#ifdef CONFIG_MV_MMP_PANEL_VGA_PEGMATITE
	writel( 0x00000000,   reg_base + SPU_IOPAD_CONTROL); // 1bc
#else
	writel( 0x000000c0,   reg_base + SPU_IOPAD_CONTROL); // 1bc
#endif

	/*
	 * dumb ctrl
	 */
	// select RGB888
	writel( 0x6030300d,   reg_base + LCD_SPU_DUMB_CTRL); // 1b8


	/*
	 * NOTE: register at offset 0x1cc is documented as needing to be set to 0x18, but dump of the
	 *       said register is reading 0 after the kernel is done initializing.
	 */

	/*
	 * Paint the refresh buffer.
	 */
	mv_mmp_armada_paint_buffer(buffer, bufsize); 	






	/*
	 * Debug code only.
	 */
	mdelay(10);
	
	/*
	 * Move backlight enable later.
	 */
	vpd->backlight_enable(1);


	/*
	 * Dump the registers for debug purposes.
	 */
	//mv_mmp_armada_dump_regs(reg_base);

	/*
	 * Delay to be able to see test pattern
	 */
#if 0
	printf("Delay to view test pattern\n");

	for (i=0; i<3; i++) {
	   mdelay(1000);
	}

	printf("Continue...\n");
#endif

	return 0;
}
