#include <common.h>
#include <stdarg.h>
#include <i2c.h>
#include <asm/io.h>
#include <lcd.h>
#include <mv_mmp_panel.h>
#include <stdio_dev.h>
#include <lcd.h>
#include <mv_mmp_panel.h>
#include <video_font.h>
#include "mv_mmp_eeprom_info.h"
#include "atmelpnl_switch.h"
#include "mv_mmp_panel_common.h"
#include "zforce.h"

/* See mv_mmp_vga_gen2_timing.c, 1024X600 native */
#define PIXELCLK	93370 /* 10.714MHz */
#define HACTIVE		480
#define VACTIVE		272
#define HFP			25
#define HPW			2
#define HBP			16
#define VFP			35
#define VPW			1
#define VBP			12

#define ENTRY_DEFAULT(entry, val) \
	.entry.min = val, \
	.entry.typ = val, \
	.entry.max = val

static struct display_timing dt =
{
	ENTRY_DEFAULT(pixelclock,	PIXELCLK),
	ENTRY_DEFAULT(hactive,		HACTIVE),
	ENTRY_DEFAULT(vactive,		VACTIVE),
	ENTRY_DEFAULT(hfront_porch,	HFP),
	ENTRY_DEFAULT(hsync_len,	HPW),
	ENTRY_DEFAULT(hback_porch,	HBP),
	ENTRY_DEFAULT(vfront_porch,	VFP),
	ENTRY_DEFAULT(vsync_len,	VPW),
	ENTRY_DEFAULT(vback_porch,	VBP),
};

static vga_panel_data vpd =
{
	.vpi = {.version_major = 0,
		.version_minor = 0,
		.keyscan_rows = 0,
		.keyscan_cols = 0,
		.xres_msb = 0,
		.xres_lsb = 0,
		.yres_msb = 0,
		.yres_lsb = 0,
		.hfp = HFP,	/* horizontal front porch, see dt for timing */
		.hpw = HPW,	/* horizontal pulse width, see dt for timing */
		.hbp = HBP,	/* horizontal back porch, see dt for timing */
		.vfp = VFP,	/* vertical front porch, see dt for timing */
		.vpw = VPW,	/* vertical pulse width, see dt for timing */
		.vbp = VBP,	/* vertical back porch, see dt for timing */
		.flags1 = PIXEL_DEPTH_24,		/* set to 16 bpp */
		.panel_type = PANEL_VGA_GENERIC,
		.xmin_msb = 0,
		.xmin_lsb = 0,
		.ymin_msb = 0,
		.ymin_lsb = 0,
		.zmin_msb = 0,
		.zmin_lsb = 0,
		.xmax_msb = 0,
		.xmax_lsb = 0,
		.ymax_msb = 0,
		.ymax_lsb = 0,
		.zmax_msb = 0,
		.zmax_lsb = 0,
		.xdrive = 0,
		.ydrive = 0,
		.zdrive = 0,
		/* .reserved = 0, */
		.mirror_size = 0,
		.lvds_type = 0,
		.flags2 = 0,
		.adc_mux = 0,
		.backlight_pwm_value = 0,
		.led_info_green = 0,
		.led_info_red = 0,
		.cavelight_bright = 0,
		.cavelight_dim = 0,
		.display_type = 0,		/* 0 - dumb*/
		.flags3 = 0,
		.flags4 = 0,
		.touch_smooth_x = 0,
		.touch_smooth_y = 0,
		.touch_smooth_z = 0,
		.fpga_rsthw_n = 0,		/* reset pin */
		.fpga_rstsw_n = 0,		/* reset pin */
		.fpga_strb = 0,
		.esd_flags = 0,
		.apa_type = 0,
		.apa_rr = 0,
		.apa_ev = 0,
		.check_msb = 0,
		.check_lsb = 0,
		},
	.dt = &dt,
	.vga_type = MV_MMP_PANEL_TYPE_480X272,
	.xres = HACTIVE,
	.yres = VACTIVE,
	.sequential = 0,
	.hscalar = 0,
	.vscalar = 0,
	.subtype = NULL,
	.backlight_enable = NULL,
	.lvds = LVDS_BPP24_OPTION_1,
};

static int backlightEnable(int enable)
{
	return 0;
}

/* Force-probed panel */
int mv62xx_disp_ref_panel_probe ( void )
{
	/* return 0 to pass probe. */
	panel_info.vl_row = vpd.yres;
	panel_info.vl_col = vpd.xres;

	panel_info.priv = &vpd;

	lcd_line_length = (panel_info.vl_col * NBITS (panel_info.vl_bpix)) / 8;

	vpd.backlight_enable = backlightEnable;

	return 0;
}

void mv62xx_disp_ref_panel_status(MV_MMP_PANEL_STATUS type, va_list ap)
{
	/* Do nothing */
}

unsigned long long mv62xx_disp_ref_panel_buttons(void)
{
	/* This looks like a parser for combo button press during init.
	 * Do nothing and return 0.
	 */
	return 0;
}

int mv62xx_disp_ref_panel_type(void)
{
	return vpd.vga_type;
}

char * mv62xx_disp_ref_panel_subtype(void)
{
	/* Return a string describing the panel part */
	return "HJ070NA-13A";
}

mv_mmp_panel_ext_clk_requirement_t mv62xx_disp_ref_panel_extclkreq(void)
{
	/* Return no external clock required. */
	return MV_MMP_PANEL_EXT_CLK_UNUSED;
}
