/*----------------------------------------------------------------------------
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * The software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with the this software; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA.
 */
#ifndef __MV61FB_H__
#define __MV61FB_H__

#if 0
#define __LXK_VGA_MV61FB_DEBUG__
#endif

/* the version in arch/arm/include/asm/io.h only uses "memory" */
#ifdef dmb
#undef dmb
#endif
#ifdef dsb
#undef dsb
#endif

#if 1
/* armv7 version from linux kernel */
#define dmb() __asm__ __volatile__ ("dmb" : : : "memory")
#define dsb() __asm__ __volatile__ ("dsb" : : : "memory")
#elif 1
/* armv6 version from linux kernel */
#define dmb() __asm__ __volatile__ ("mcr p15, 0, %0, c7, c10, 5" \
                                  : : "r" (0) : "memory")
#define dsb() __asm__ __volatile__ ("mcr p15, 0, %0, c7, c10, 4" \
                                  : : "r" (0) : "memory")
#else
/* weak version(s) from arch/arm/include/asm/io.h, compiler directive only */
#define dmb()		__asm__ __volatile__ ("" : : : "memory")
#define dsb()		dmb()
#endif

/* TODO: Use the versions in <asm/io.h> instead? */

/* 
 * These mimic the order of operations in io.h using the stronger version of dmb().
 * May still need to explicitly call dmb() for write-read sequence. All assume
 * register space is uncached, but it may still be buffered.
 */
static inline u32 readl(void * addr)
{
   volatile u32 *ptr = (u32 *)addr;
   u32 tmp = *ptr;
   dmb();
   return tmp;
}

static inline void writel(u32 val, void * dst)
{
   volatile u32 *ptr = (u32 *)dst;
   dmb();
   *ptr = val;
}

unsigned int lxk_mv61fb_get_clk_div(unsigned target_hz);
void lxk_mv61fb_gamma_kludge(void *reg_base);
void lxk_mv61fb_default_gamma(void *reg_base);
void lxk_mv61fb_dump_regs(void *reg_base);
void lxk_mv61fb_paint_buffer(void *buffer, unsigned int bufsize);

/* Misc definitions */
#define ALPHA_VIDEO_PATH		0
#define ALPHA_GRAPHIC_PATH		1
#define ALPHA_PANEL_PATH		2
#define ALPHA_DISABLED			3

#define VSYNC_MODE_SMART_VSYNC		0
#define VSYNC_MODE_DUMB_VSYNC		2
#define VSYNC_MODE_WRITE_TRIG		7

#define PXLCMD_OPAQUE_VALUE		0x81


/* LCD interface I/O type*/
#define PIN_MODE_DUMB_24		0
#define PIN_MODE_DUMB_18_GPIO		1
#define PIN_MODE_DUMB_16_GPIO		2
#define PIN_MODE_DUMB_12_GPIO		3
#define PIN_MODE_SMART_18_GPIO		4
#define PIN_MODE_SMART_16_GPIO		5
#define PIN_MODE_SMART_8_GPIO		6
#define PIN_MODE_DISABLED		7
#define PIN_MODE_DUMB_SEQ_8_RGB		8
#define PIN_MODE_DUMB_SEQ_8_RGBX	9
#define PIN_MODE_DUMB_SEQ_8_XRGB	10

/* Dumb interface pin allocation */
#define DUMB_MODE_RGB565		0
#define DUMB_MODE_RGB666		2
#define DUMB_MODE_RGB444		4
#define DUMB_MODE_RGB888		6
#define DUMB_MODE_BLANK			15

/* Smart interface color modes */
#define SMART_MODE_RGB888_3CYCLE	0
#define SMART_MODE_RGB666_3CYCLE	1
#define SMART_MODE_RGB565_2CYCLE	2
#define SMART_MODE_RGB888_1CYCLE	3
#define SMART_MODE_RGB666_1CYCLE	4
#define SMART_MODE_RGB565_1CYCLE	5

/*
 * Buffer pixel format
 */
#define PIX_FMT_RGB565		0
#define PIX_FMT_RGB1555		1
#define PIX_FMT_RGB888PACK	2
#define PIX_FMT_RGB888UNPACK	3
#define PIX_FMT_RGBA888		4
#define PIX_FMT_YUV422PACK	5
#define PIX_FMT_YUV422PLANAR	6
#define PIX_FMT_YUV420PLANAR	7
#define PIX_FMT_PSEUDOCOLOR4	9
#define PIX_FMT_PSEUDOCOLOR8	10
#define PIX_FMT_RGB888A		11

/* smartpanel interface encoding */
#define SMART_CMD_A0			(0x1 << 15)
#define SMART_CMD_WRITE			(0x1 << 8)
#define SMART_CMD_READ			(0x1 << 9)

#define SMART_CMD_READ_REG		(SMART_CMD_READ | SMART_CMD_A0)
#define SMART_CMD_READ_FRAME		(SMART_CMD_READ | SMART_CMD_A0)
#define SMART_CMD_WRITE_COMMAND		(SMART_CMD_WRITE)
#define SMART_CMD_WRITE_DATA		(SMART_CMD_WRITE | SMART_CMD_A0)
#define SMART_CMD_WRITE_FRAME		(SMART_CMD_WRITE | SMART_CMD_A0)

#define SMART_CMD(x)		(SMART_CMD_WRITE_COMMAND | ((x) & 0xff))
#define SMART_DAT(x)		(SMART_CMD_WRITE_DATA | ((x) & 0xff))

#if 1
#define SMART_NOP		(SMART_CMD_A0)
#else
#define SMART_NOP		(0)
#endif

#define SMART_DELAY_MASK	(0x0ff00)
#define SMART_DELAY(ms)		(SMART_DELAY_MASK | (ms & 0x0ff))

#define SMART_CMD_SHIFT		(16)
#define SMART_FIRST_SHIFT	(0)
#define SMART_SECOND_SHIFT	SMART_CMD_SHIFT


/* ------------< LCD register >------------ */
/* LCD Software Reset, added in LCD2 */
#define LCD_SOFT_RESET				0x009C
#define     CFG_SW_RESET(reset)		 	((reset) << 29)
/* Video Frame 0&1 start address registers */
#define	LCD_SPU_DMA_START_ADDR_Y0		0x00C0
#define	LCD_SPU_DMA_START_ADDR_U0		0x00C4
#define	LCD_SPU_DMA_START_ADDR_V0		0x00C8
#define LCD_CFG_DMA_START_ADDR_0		0x00CC /* Cmd address */
#define	LCD_SPU_DMA_START_ADDR_Y1		0x00D0
#define	LCD_SPU_DMA_START_ADDR_U1		0x00D4
#define	LCD_SPU_DMA_START_ADDR_V1		0x00D8
#define LCD_CFG_DMA_START_ADDR_1		0x00DC /* Cmd address */

/* YC & UV Pitch */
#define LCD_SPU_DMA_PITCH_YC			0x00E0
#define     SPU_DMA_PITCH_C(c)			((c) << 16)
#define     SPU_DMA_PITCH_Y(y)			(y)
#define LCD_SPU_DMA_PITCH_UV			0x00E4
#define     SPU_DMA_PITCH_V(v)			((v) << 16)
#define     SPU_DMA_PITCH_U(u)			(u)

/* Video Starting Point on Screen Register */
#define LCD_SPUT_DMA_OVSA_HPXL_VLN		0x00E8
#define     CFG_DMA_OVSA_VLN(y)			((y) << 16)	/* 0~0xfff */
#define     CFG_DMA_OVSA_HPXL(x)		(x)		/* 0~0xfff */
	/* bits added from LCD2 spec */
#define	    CFG_DMAFRM_FIX(enb)			((enb) << 31)		
#define	    CFG_DMAFRM_Y(frame)			((frame) << 15)		
#define	    CFG_DMAFRM_U(frame)			((frame) << 14)		
#define	    CFG_DMAFRM_V(frame)			((frame) << 13)		
#define	    CFG_DMAFRM_C(frame)			((frame) << 12)		
	
/* Video Size Register */
#define LCD_SPU_DMA_HPXL_VLN			0x00EC
#define     CFG_DMA_VLN(y)			((y) << 16)
#define     CFG_DMA_HPXL(x)			(x)

/* Video Size After zooming Register */
#define LCD_SPU_DZM_HPXL_VLN			0x00F0
#define     CFG_DZM_VLN(y)			((y) << 16)
#define     CFG_DZM_HPXL(x)			(x)

/* Graphic Frame 0&1 Starting Address Register */
#define LCD_CFG_GRA_START_ADDR0			0x00F4
#define LCD_CFG_GRA_START_ADDR1			0x00F8

/* Graphic Frame Pitch */
#define LCD_CFG_GRA_PITCH			0x00FC
	/* bits added from LCD2 spec */
#define    PN_DUTY_CYCLE_CTRL(duty)		((duty) << 28)	/* 0~0x0f */
#define    CFG_PN_BKLIGHTDIV(div)		((div) << 16)	/* 0~0x0fff */
#define    CFG_GRA_PITCH_MASK			0x0000FFFF	

/* Graphic Starting Point on Screen Register */
#define LCD_SPU_GRA_OVSA_HPXL_VLN		0x0100
#define     CFG_GRA_OVSA_VLN(y)			((y) << 16)
#define     CFG_GRA_OVSA_HPXL(x)		(x)
	/* bits added from LCD2 spec */
#define	    CFG_GRAFRM_FIX(enb)			((enb) << 31)		
#define	    CFG_GRAFRM_FIX_MASK			0x80000000		
#define	    CFG_GRAFRM_Y(frame)			((frame) << 12)		
#define	    CFG_GRAFRM_Y_MASK			0x00001000		
#define	    CFG_GRAFRM_Y_SHIFT			12		

/* Graphic Size Register */
#define LCD_SPU_GRA_HPXL_VLN			0x0104
#define     CFG_GRA_VLN(y)			((y) << 16)
#define     CFG_GRA_VLN_MASK			0x0FFF0000
#define     CFG_GRA_VLN_SHIFT			16
#define     CFG_GRA_HPXL(x)			(x)
#define     CFG_GRA_HPXL_MASK			0x00000FFF
#define     CFG_GRA_HPXL_SHIFT			0

/* Graphic Size after Zooming Register */
#define LCD_SPU_GZM_HPXL_VLN			0x0108
#define     CFG_GZM_VLN(y)			((y) << 16)
#define     CFG_GZM_HPXL(x)			(x)

/* Total Screen Size Register */
#define LCD_SPUT_V_H_TOTAL			0x0114
#define     CFG_V_TOTAL(y)			((y) << 16)
#define     CFG_H_TOTAL(x)			(x)

/* Total Screen Active Size Register */
#define LCD_SPU_V_H_ACTIVE			0x0118
#define     CFG_V_ACTIVE(y)			((y) << 16)
#define     CFG_H_ACTIVE(x)			(x)

/* Screen H&V Porch Register */
#define LCD_SPU_H_PORCH				0x011C
#define     CFG_H_BACK_PORCH(b)			((b) << 16)
#define     CFG_H_FRONT_PORCH(f)		(f)
#define LCD_SPU_V_PORCH				0x0120
#define     CFG_V_BACK_PORCH(b)			((b) << 16)
#define     CFG_V_FRONT_PORCH(f)		(f)

/* Screen Blank Color Register */
#define LCD_SPU_BLANKCOLOR			0x0124
#define     CFG_BLANKCOLOR_MASK			0x00FFFFFF
#define     CFG_BLANKCOLOR_R_MASK		0x000000FF
#define     CFG_BLANKCOLOR_G_MASK		0x0000FF00
#define     CFG_BLANKCOLOR_B_MASK		0x00FF0000

/* Video YUV Color Key Control */
#define LCD_SPU_COLORKEY_Y			0x0130
#define     CFG_CKEY_Y2(y2)			((y2) << 24)
#define     CFG_CKEY_Y2_MASK			0xFF000000
#define     CFG_CKEY_Y1(y1)			((y1) << 16)
#define     CFG_CKEY_Y1_MASK			0x00FF0000
#define     CFG_CKEY_Y(y)			((y) << 8)
#define     CFG_CKEY_Y_MASK			0x0000FF00
#define     CFG_ALPHA_Y(y)			(y)
#define     CFG_ALPHA_Y_MASK			0x000000FF
#define LCD_SPU_COLORKEY_U			0x0134
#define     CFG_CKEY_U2(u2)			((u2) << 24)
#define     CFG_CKEY_U2_MASK			0xFF000000
#define     CFG_CKEY_U1(u1)			((u1) << 16)
#define     CFG_CKEY_U1_MASK			0x00FF0000
#define     CFG_CKEY_U(u)			((u) << 8)
#define     CFG_CKEY_U_MASK			0x0000FF00
#define     CFG_ALPHA_U(u)			(u)
#define     CFG_ALPHA_U_MASK			0x000000FF
#define LCD_SPU_COLORKEY_V			0x0138
#define     CFG_CKEY_V2(v2)			((v2) << 24)
#define     CFG_CKEY_V2_MASK			0xFF000000
#define     CFG_CKEY_V1(v1)			((v1) << 16)
#define     CFG_CKEY_V1_MASK			0x00FF0000
#define     CFG_CKEY_V(v)			((v) << 8)
#define     CFG_CKEY_V_MASK			0x0000FF00
#define     CFG_ALPHA_V(v)			(v)
#define     CFG_ALPHA_V_MASK			0x000000FF

/* Panel VSYNC Pulse Pixel Edge Control Register (LCD2, removed from GPL MMP2) */
#define LCD_PN_SEPXLCNT				0x013c
	/* bits added from LCD2 spec */
#define	    CFG_DBG_RD_INDEX(index)		((index) << 28)		/* 0x0f */			
#define	    CFG_DBG_RD_INDEX_MASK		0xF0000000			
#define	    CFG_PN_V_EPXLCNT(offset)		((offset) << 16)	/* 0x0fff */			
#define	    CFG_PN_V_SPXLCNT(offset)		(offset)		/* 0x0fff */			

/* Smart Panel Read Data Register */
#define LCD_SPU_ISA_RSDATA			0x0144
#define     ISA_RXDATA_16BIT_1_DATA_MASK	0x000000FF	/* last read */
#define     ISA_RXDATA_16BIT_2_DATA_MASK	0x0000FF00	/* 2nd last read */
#define     ISA_RXDATA_16BIT_3_DATA_MASK	0x00FF0000	/* 3rd last read */
#define     ISA_RXDATA_16BIT_4_DATA_MASK	0xFF000000	/* 4th last read */
#define     ISA_RXDATA_32BIT_1_DATA_MASK	0x00FFFFFF	/* last read */

/* Panel Path Panel Interface I/O Pad Register (LCD2, removed from GPL MMP2) */
#define LCD_READ_IOPAD                   	(0x0148)	/* read only */

/* Panel Video Actual Line Length in Memory Registers (LCD2, removed from GPL MMP2) */
#define LCD_DMAVLD_YC                    	(0x014C)	/* read only */
	/* bits added from LCD2 spec */
#define     DMA_SA_YFLAG_MASK			(1 << 31)
#define     DMA_SA_UFLAG_MASK			(1 << 30)
#define     DMA_SA_VFLAG_MASK			(1 << 29)
#define     GRA_SA_YFLAG_MASK			(1 << 28)
#define     DMA_SA_CFLAG_MASK			(1 << 23)
#define     CFG_DMAVLD_HLEN_Y_MASK		0x0000FFFF

#define LCD_DMAVLD_UV                    	(0x0150)	/* read only */
	/* bits added from LCD2 spec */
#define	    CFG_DMAVLD_HLEN_V_MASK		0x000FFC00
#define	    CFG_DMAVLD_HLEN_U_MASK		0x000003FF

/* Graphic Actual Line Length (Pitch) in System Memory Register (LCD2, removed from GPL MMP2) */
#define LCD_TVGGRAVLD_HLEN               	(0x0154)	/* read only */
#define	    CFG_GRAVLD_HLEN_MASK		0x0000FFFF

/* Gamma Table SRAM Read Data Register */
#define LCD_SPU_GAMMA_RDDAT			0x015c	/* read only */
#define     CFG_GAMMA_RDDAT_MASK		0x000000FF

/* Palette Table SRAM Read Data Register */
#define LCD_SPU_PALETTE_RDDAT			0x0160	/* read only */
#define     CFG_PALETTE_RDDAT_MASK		0x00FFFFFF

/* Panel Slave Path Status and Debug Register (LCD2, removed from GPL MMP2) */
#define LCD_SLV_DBG				(0x0164)
	/* bits added from LCD2 spec */
#define	    SLV_SPACECNT_MASK			0x000FF000		
#define	    SLV_SPACECNT_SHIFT			(12)		
#define	    SLV_DATACNT_MASK			0x00000FF0		
#define	    SLV_DATACNT_SHIFT			(4)		
	/* graphics channel status */
#define	    GRA_AFF_EMPTY_MASK			0x04000000

#define     DBG_SLVTOP_SEL			(0)
#define     DBG_TXCTRL_SEL			(1)
#define     DBG_GRATOP_SEL			(3)
#define     DBG_MUXTOP_SEL			(4)
#define     DBG_ISA_SEL				(7)

#define LCD_SLV_FIFO_DEPTH			(32)		

/* Display Frame number Read Only register (LCD2, removed from GPL MMP2) */
#define LCD_FRAME_CNT				0x017C

#define     GRA_FRAME_CNT_MASK			0x0000000C  /* Graphic */
#define     DMA_FRAME_CNT_MASK			0x00000003  /* Video */

/*
 *  Smart Panel Bus Control Register.
 */
#define LCD_SPU_SMPN_CTRL			0x0188
#define     CFG_ISA_RXLOW(clks)			((clks) << 28)
#define     CFG_ISA_RXLOW_MASK			0xf0000000
#define     CFG_ISA_RXHIGH(clks)		((clks) << 24)
#define     CFG_ISA_RXHIGH_MASK			0x0f000000
#define     CFG_ISA_TXLOW(clks)			((clks) << 20)
#define     CFG_ISA_TXLOW_MASK			0x00f00000
#define     CFG_ISA_TXHIGH(clks)		((clks) << 16)
#define     CFG_ISA_TXHIGH_MASK			0x000f0000
#define     CFG_IORDY_MSK(iordy)		((iordy) << 13)
#define     CFG_IORDY_MSK_MASK			0x00002000
#define     CFG_SLV_ONLY(slv)			((slv) << 12)
#define     CFG_SLV_ONLY_MASK			0x00001000
#define     CFG_SMPNMODE(mode)			((mode) << 8)
#define     CFG_SMPNMODE_MASK			0x00000f00
#define     CFG_CMD32OR16B(cmd32)		((cmd32) << 7)
#define     CFG_CMD32OR16B_MASK			0x00000080
#define     CFG_SWAPBYTES(swap)			((swap) << 6)
#define     CFG_SWAPBYTES_MASK			0x00000040
#define     CFG_SMPN_SEL(sel)			((sel) << 5)
#define     CFG_SMPN_SEL_MASK			0x00000020
#define     CFG_SLV_ENA(enb)			((enb) << 4)
#define     CFG_SLV_ENA_MASK			0x00000010
#define     CFG_SMPN_RSTB(pin)			((pin) << 3)
#define     CFG_SMPN_RSTB_MASK			0x00000008
#define     CFG_68S80SB(m68)			((m68) << 2)
#define     CFG_68S80SB_MASK			0x00000004
#define     CFG_KEEPXFER(keep)			((keep) << 1)
#define     CFG_KEEPXFER_MASK			0x00000002
#define     CFG_SMPN_ENA(enb)			(enb)
#define     CFG_SMPN_ENA_MASK			0x00000001

#define	    CFG_ISA_TIME_MAX			(0x0f)
#define	    CFG_ISA_TIME_MIN			(0)
			
/*
 *  Smart Panel AHB Slave Path Write Data Port Register 
 *  (fields defined in include/video/mv61fb.h)
 */
#define LCD_SLV_PORT				0x018C

/* DMA Control 0 Register */
#define LCD_SPU_DMA_CTRL0			0x0190
#define     CFG_NOBLENDING(nb)			((nb) << 31)
#define     CFG_NOBLENDING_MASK			0x80000000
#define     CFG_GAMMA_ENA(gn)			((gn) << 30)
#define     CFG_GAMMA_ENA_MASK			0x40000000
#define     CFG_CBSH_ENA(cn)			((cn) << 29)
#define     CFG_CBSH_ENA_MASK			0x20000000
#define     CFG_PALETTE_ENA(pn)			((pn) << 28)
#define     CFG_PALETTE_ENA_MASK		0x10000000
#define     CFG_ARBFAST_ENA(an)			((an) << 27)
#define     CFG_ARBFAST_ENA_MASK		0x08000000
#define     CFG_HWC_1BITMOD(mode)		((mode) << 26)
#define     CFG_HWC_1BITMOD_MASK		0x04000000
#define     CFG_HWC_1BITENA(mn)			((mn) << 25)
#define     CFG_HWC_1BITENA_MASK		0x02000000
#define     CFG_HWC_ENA(cn)		        ((cn) << 24)
#define     CFG_HWC_ENA_MASK			0x01000000
#define     CFG_DMAFORMAT(dmaformat)		((dmaformat) << 20)
#define     CFG_DMAFORMAT_MASK			0x00F00000
#define     CFG_GRAFORMAT(graformat)		((graformat) << 16)
#define     CFG_GRAFORMAT_MASK			0x000F0000
#define     CFG_GRAFORMAT_SHIFT			16
/* for graphic part */
#define     CFG_GRA_FTOGGLE(toggle)		((toggle) << 15)
#define     CFG_GRA_FTOGGLE_MASK		0x00008000
#define     CFG_GRA_HSMOOTH(smooth)		((smooth) << 14)
#define     CFG_GRA_HSMOOTH_MASK		0x00004000
#define     CFG_GRA_TSTMODE(test)		((test) << 13)
#define     CFG_GRA_TSTMODE_MASK		0x00002000
#define     CFG_GRA_SWAPRB(swap)		((swap) << 12)
#define     CFG_GRA_SWAPRB_MASK			0x00001000
#define     CFG_GRA_SWAPUV(swap)		((swap) << 11)
#define     CFG_GRA_SWAPUV_MASK			0x00000800
#define     CFG_GRA_SWAPYU(swap)		((swap) << 10)
#define     CFG_GRA_SWAPYU_MASK			0x00000400
#define     CFG_YUV2RGB_GRA(cvrt)		((cvrt) << 9)
#define     CFG_YUV2RGB_GRA_MASK		0x00000200
#define     CFG_GRA_ENA(gra)			((gra) << 8)
#define     CFG_GRA_ENA_MASK			0x00000100
/* for video part */
#define     CFG_DMA_FTOGGLE(toggle)		((toggle) << 7)
#define     CFG_DMA_FTOGGLE_MASK		0x00000080
#define     CFG_DMA_HSMOOTH(smooth)		((smooth) << 6)
#define     CFG_DMA_HSMOOTH_MASK		0x00000040
#define     CFG_DMA_TSTMODE(test)		((test) << 5)
#define     CFG_DMA_TSTMODE_MASK		0x00000020
#define     CFG_DMA_SWAPRB(swap)		((swap) << 4)
#define     CFG_DMA_SWAPRB_MASK			0x00000010
#define     CFG_DMA_SWAPUV(swap)		((swap) << 3)
#define     CFG_DMA_SWAPUV_MASK			0x00000008
#define     CFG_DMA_SWAPYU(swap)		((swap) << 2)
#define     CFG_DMA_SWAPYU_MASK			0x00000004
#define     CFG_DMA_SWAP_MASK			0x0000001C
#define     CFG_YUV2RGB_DMA(cvrt)		((cvrt) << 1)
#define     CFG_YUV2RGB_DMA_MASK		0x00000002
#define     CFG_DMA_ENA(video)			(video)
#define     CFG_DMA_ENA_MASK			0x00000001

/* DMA Control 1 Register */
#define LCD_SPU_DMA_CTRL1			0x0194
#define     CFG_FRAME_TRIG(trig)		((trig) << 31)
#define     CFG_FRAME_TRIG_MASK			0x80000000
#define     CFG_VSYNC_TRIG(trig)		((trig) << 28)
#define     CFG_VSYNC_TRIG_MASK			0x70000000
#define     CFG_VSYNC_INV(inv)			((inv) << 27)
#define     CFG_VSYNC_INV_MASK			0x08000000
#define     CFG_COLOR_KEY_MODE(cmode)		((cmode) << 24)
#define     CFG_COLOR_KEY_MASK			0x07000000
#define     CFG_CARRY(carry)			((carry) << 23)
#define     CFG_CARRY_MASK			0x00800000

#define     CFG_DSCALE(dscale)			((dscale) << 18)
#define     CFG_DSCALE_MASK			0x000C0000
#define     CFG_PN_ALPHA_MODE(amode)		((amode) << 16)
#define     CFG_PN_ALPHA_MODE_MASK		0x00030000
#define     CFG_PN_ALPHA(alpha)			((alpha) << 8)
#define     CFG_PN_ALPHA_MASK			0x0000FF00
#define     CFG_PXLCMD(pxlcmd)			(pxlcmd)
#define     CFG_PXLCMD_MASK			0x000000FF

/* SRAM Control Register */
#define LCD_SPU_SRAM_CTRL			0x0198
#define     CFG_SRAM_INIT_WR_RD(mode)		((mode) << 14)
#define     CFG_SRAM_INIT_WR_RD_MASK		0x0000C000
#define     CFG_SRAM_ADDR_LCDID(id)		((id) << 8)
#define     CFG_SRAM_ADDR_LCDID_MASK		0x00000F00
#define     CFG_SRAM_ADDR(addr)			(addr)
#define     CFG_SRAM_ADDR_MASK			0x000000FF

/* SRAM Write Data Register */
#define LCD_SPU_SRAM_WRDAT			0x019C

/* SRAM Power Down Control Register */
#define LCD_SPU_SRAM_PARA1			0x01A4

#define     CFG_CSB_256x24(palette)		((palette) << 14)	/* Palette */
#define     CFG_CSB_256x24_MASK			0x00004000
#define     CFG_CSB_256x8(gamma)		((gamma) << 13)	/* Gamma */
#define     CFG_CSB_256x8_MASK			0x00002000

/* Smart or Dumb Panel Clock Divider */
#define LCD_CFG_SCLK_DIV			0x01A8
#define     CLK_INT_DIV(div)			(div)
#define     CLK_INT_DIV_MASK			0x000000FF

/* Video Contrast Register */
#define LCD_SPU_CONTRAST			0x01AC
#define     CFG_BRIGHTNESS(bright)		((bright) << 16)
#define     CFG_BRIGHTNESS_MASK			0xFFFF0000
#define     CFG_CONTRAST(contrast)		(contrast)
#define     CFG_CONTRAST_MASK			0x0000FFFF

/* Video Saturation Register */
#define LCD_SPU_SATURATION			0x01B0
#define     CFG_C_MULTS(mult)			((mult) << 16)
#define     CFG_C_MULTS_MASK			0xFFFF0000
#define     CFG_SATURATION(sat)			(sat)
#define     CFG_SATURATION_MASK			0x0000FFFF

/* Video Hue Adjust Register */
#define LCD_SPU_CBSH_HUE			0x01B4
#define     CFG_SIN0(sin0)			((sin0) << 16)
#define     CFG_SIN0_MASK			0xFFFF0000
#define     CFG_COS0(con0)			(con0)
#define     CFG_COS0_MASK			0x0000FFFF

/* Dump LCD Panel Control Register */
#define LCD_SPU_DUMB_CTRL			0x01B8
#define     CFG_DUMBMODE(mode)			((mode) << 28)
#define     CFG_DUMBMODE_MASK			0xF0000000
#define     CFG_LCDGPIO_O(data)			((data) << 20)
#define     CFG_LCDGPIO_O_MASK			0x0FF00000
#define     CFG_LCDGPIO_ENA(gpio)		((gpio) << 12)
#define     CFG_LCDGPIO_ENA_MASK		0x000FF000

	/* bits added from LCD2 spec */
#define	    CFG_GRA_PMBURST(delay)		((delay) << 11)
#define	    CFG_GRA_PMBURST_MASK		0x00000800
#define	    CFG_PN_NO_IOPAD(disable)		((disable) << 9)
#define	    CFG_PN_CFG_NO_IOPAD_MASK		0x00000200

#define     CFG_BIAS_OUT(bias)			((bias) << 8)
#define     CFG_BIAS_OUT_MASK			0x00000100
#define     CFG_REVERSE_RGB(rRGB)		((rRGB) << 7)
#define     CFG_REVERSE_RGB_MASK		0x00000080
#define     CFG_INV_COMPBLANK(blank)		((blank) << 6)
#define     CFG_INV_COMPBLANK_MASK		0x00000040
#define     CFG_INV_COMPSYNC(sync)		((sync) << 5)
#define     CFG_INV_COMPSYNC_MASK		0x00000020
#define     CFG_INV_HENA(hena)			((hena) << 4)
#define     CFG_INV_HENA_MASK			0x00000010
#define     CFG_INV_VSYNC(vsync)		((vsync) << 3)
#define     CFG_INV_VSYNC_MASK			0x00000008
#define     CFG_INV_HSYNC(hsync)		((hsync) << 2)
#define     CFG_INV_HSYNC_MASK			0x00000004
#define     CFG_INV_PCLK(pclk)			((pclk) << 1)
#define     CFG_INV_PCLK_MASK			0x00000002
#define     CFG_DUMB_ENA(dumb)			(dumb)
#define     CFG_DUMB_ENA_MASK			0x00000001

/* LCD I/O Pads Control Register */
#define SPU_IOPAD_CONTROL			0x01BC
#define     CFG_GRA_VM_ENA(vm)			((vm) << 15)        /* gfx */
#define     CFG_GRA_VM_ENA_MASK			0x00008000
#define     CFG_DMA_VM_ENA(vm)			((vm) << 13)	/* video */
#define     CFG_DMA_VM_ENA_MASK			0x00002000
#define     CFG_CMD_VM_ENA(vm)			((vm) << 13)
#define     CFG_CMD_VM_ENA_MASK			0x00000800
#define     CFG_CSC(csc)			((csc) << 8)	/* csc */
#define     CFG_CSC_MASK			0x00000300
#define     CFG_AXICTRL(axi)			((axi) << 4)
#define     CFG_AXICTRL_MASK			0x000000F0
#define     CFG_IOPADMODE(iopad)		(iopad)
#define     CFG_IOPADMODE_MASK			0x0000000F

/* LCD Interrupt Control Register */
#define SPU_IRQ_ENA				0x01C0
#define     DMA_FRAME_IRQ0_ENA(irq)		((irq) << 31)
#define     DMA_FRAME_IRQ0_ENA_MASK		0x80000000
#define     DMA_FRAME_IRQ1_ENA(irq)		((irq) << 30)
#define     DMA_FRAME_IRQ1_ENA_MASK		0x40000000
#define     DMA_FF_UNDERFLOW_ENA(ff)		((ff) << 29)
#define     DMA_FF_UNDERFLOW_ENA_MASK		0x20000000
#define     GRA_FRAME_IRQ0_ENA(irq)		((irq) << 27)
#define     GRA_FRAME_IRQ0_ENA_MASK		0x08000000
#define     GRA_FRAME_IRQ1_ENA(irq)		((irq) << 26)
#define     GRA_FRAME_IRQ1_ENA_MASK		0x04000000
#define     GRA_FF_UNDERFLOW_ENA(ff)		((ff) << 25)
#define     GRA_FF_UNDERFLOW_ENA_MASK		0x02000000
#define     VSYNC_IRQ_ENA(vsync_irq)		((vsync_irq) << 23)
#define     VSYNC_IRQ_ENA_MASK			0x00800000
#define     DUMB_FRAMEDONE_ENA(fdone)		((fdone) << 22)
#define     DUMB_FRAMEDONE_ENA_MASK		0x00400000
#define     TWC_FRAMEDONE_ENA(fdone)		((fdone) << 21)
#define     TWC_FRAMEDONE_ENA_MASK		0x00200000
#define     HWC_FRAMEDONE_ENA(fdone)		((fdone) << 20)
#define     HWC_FRAMEDONE_ENA_MASK		0x00100000
#define     SLV_IRQ_ENA(irq)			((irq) << 19)
#define     SLV_IRQ_ENA_MASK			0x00080000
#define     SPI_IRQ_ENA(irq)			((irq) << 18)
#define     SPI_IRQ_ENA_MASK			0x00040000
#define     PWRDN_IRQ_ENA(irq)			((irq) << 17)
#define     PWRDN_IRQ_ENA_MASK			0x00020000
#define     ERR_IRQ_ENA(irq)			((irq) << 16)
#define     ERR_IRQ_ENA_MASK			0x00010000
#define	    LCD_IRQ_ENA_ALL_MASK		0xFEE90000

/* LCD Interrupt Status Register */
#define SPU_IRQ_ISR				0x01C4
#define     DMA_FRAME_IRQ0(irq)			((irq) << 31)
#define     DMA_FRAME_IRQ0_MASK			0x80000000
#define     DMA_FRAME_IRQ1(irq)			((irq) << 30)
#define     DMA_FRAME_IRQ1_MASK			0x40000000
#define     DMA_FF_UNDERFLOW(ff)		((ff) << 29)
#define     DMA_FF_UNDERFLOW_MASK		0x20000000
#define     GRA_FRAME_IRQ0(irq)			((irq) << 27)
#define     GRA_FRAME_IRQ0_MASK			0x08000000
#define     GRA_FRAME_IRQ1(irq)			((irq) << 26)
#define     GRA_FRAME_IRQ1_MASK			0x04000000
#define     GRA_FF_UNDERFLOW(ff)		((ff) << 25)
#define     GRA_FF_UNDERFLOW_MASK		0x02000000
#define     VSYNC_IRQ(vsync_irq)		((vsync_irq) << 23)
#define     VSYNC_IRQ_MASK			0x00800000
#define     DUMB_FRAMEDONE(fdone)		((fdone) << 22)
#define     DUMB_FRAMEDONE_MASK			0x00400000
#define     TWC_FRAMEDONE(fdone)		((fdone) << 21)
#define     TWC_FRAMEDONE_MASK			0x00200000
#define     SLV_IRQ(irq)			((irq) << 19)
#define     SLV_IRQ_MASK			0x00080000
#define     ERR_IRQ(irq)			((irq) << 16)
#define     ERR_IRQ_MASK			0x00010000

/* read-only level interrupts (LCD2) */
#define     DMA_FRAME_CNT0_MASK			0x00000080
#define     GRA_FRAME_CNT0_MASK			0x00000040
#define     DMA_FF_EMPTY_MASK			0x00000008
#define     GRA_FF_EMPTY_MASK			0x00000004

/* LCD Interrupt Reset Status Register (LCD2, removed from GPL MMP2) */
#define SPU_IRQ_RSR				0x01C8

/* Panel Path Graphic Partial Display Horizontal Control Register (LCD2, removed from GPL MMP2) */
#define LCD_GRA_CUTHPXL				0x01CC

/* Panel Path Graphic Partial Display Vertical Control Register (LCD2, removed from GPL MMP2) */
#define LCD_GRA_CUTVLN				0x01D0

/* Global Control Register (LCD2, removed from GPL MMP2) */
#define LCD_TOP_CTRL				0x01DC

/* LCD Mixed Overlay Control Register (LCD2, removed from GPL MMP2) */
#define LCD_AFA_ALL2ONE				0x01E8

/* MISR Testability Control Register (LCD2, not used for normal operation) */
#define LCD_MISR_CONTROL			0x0200
#define     MISR_ENA(ena)			((ena) << 24)
#define     MISR_ENA_MASK			0x01000000
#define     MISR_NUM_FRAMES(num)		((num) << 16)
#define     MISR_NUM_FRAMES_MASK		0x00ff0000
#define     MISR_INITVAL(seed)			((seed) << 0)
#define     MISR_INITVAL_MASK			0x0000ffff

/* MISR Testability Status Register (LCD2, not used for normal operation) */
#define LCD_MISR_STATUS				0x0204
#define     MISR_CRC_VALID_MASK			0x00010000
#define     MISR_CRC_MASK			0x0000ffff

#endif /* __MV61FB_H__ */
