#include <common.h>
#include <lxk_panel.h>
#include "lxk_panel_common.h"

#define ENTRY_DEFAULT(entry, val) \
	.entry.min = val, \
	.entry.typ = val, \
	.entry.max = val
/*
 * The mode member corresponds to the kernel's struct fb_videomode
 * so the data should be directly comparable.
 * The lxk_type member is provided for legacy compatibility.
 *
 * TODO: Search by the name member and eliminate the enumerated types?
 */
const lxk_gen2_display_info_t lxk_display_info[] = {
	{
		.lxk_type = LXK_PANEL_TYPE_480X272_NON_SEQ,
		.name		= "480x272_type_1",
		.dt = {
			ENTRY_DEFAULT(pixelclock,	103853), /*  9.63mHz */
			ENTRY_DEFAULT(hactive,		480),
			ENTRY_DEFAULT(vactive,		272),
			ENTRY_DEFAULT(hfront_porch,	8),
			ENTRY_DEFAULT(hsync_len,	41),
			ENTRY_DEFAULT(hback_porch,	4),
			ENTRY_DEFAULT(vfront_porch,	4),
			ENTRY_DEFAULT(vsync_len,	10),
			ENTRY_DEFAULT(vback_porch,	2),
		},
	},

	{
		.lxk_type = LXK_PANEL_TYPE_800X480_SCALED,
		.name		= "800x480_type_1",
		.dt = {
			/* 800x480 to be upscaled */
			ENTRY_DEFAULT(pixelclock,	33216), /*  30.1mHz */
			ENTRY_DEFAULT(hactive,		800),
			ENTRY_DEFAULT(vactive,		480),
			ENTRY_DEFAULT(hfront_porch,	40),
			ENTRY_DEFAULT(hsync_len,	128),
			ENTRY_DEFAULT(hback_porch,	12),
			ENTRY_DEFAULT(vfront_porch,	12),
			ENTRY_DEFAULT(vsync_len,	2),
			ENTRY_DEFAULT(vback_porch,	18),
		},
	},

	{
		.lxk_type = LXK_PANEL_TYPE_800X480,
		.name		= "800x480_type_3",
		.dt = {
			/* 800x480 native */
			ENTRY_DEFAULT(pixelclock,	34211), /*  29.23mHz */
			ENTRY_DEFAULT(hactive,		800),
			ENTRY_DEFAULT(vactive,		480),
			ENTRY_DEFAULT(hfront_porch,	40),
			ENTRY_DEFAULT(hsync_len,	48),
			ENTRY_DEFAULT(hback_porch,	40),
			ENTRY_DEFAULT(vfront_porch,	13),
			ENTRY_DEFAULT(vsync_len,	3),
			ENTRY_DEFAULT(vback_porch,	29),
		},
	},

	{
		.lxk_type = LXK_PANEL_TYPE_1024X600,
		.name		= "1024x600_type_1",
		.dt = {
			/* 1024X600 native */
			ENTRY_DEFAULT(pixelclock,	19528), /*  51.2mHz */
			ENTRY_DEFAULT(hactive,		1024),
			ENTRY_DEFAULT(vactive,		600),
			ENTRY_DEFAULT(hfront_porch,	38),
			ENTRY_DEFAULT(hsync_len,	100), // 182
			ENTRY_DEFAULT(hback_porch,	(1344 - 1024 - 38 - 100)), // 182
			ENTRY_DEFAULT(vfront_porch,	8),
			ENTRY_DEFAULT(vsync_len,	4),
			ENTRY_DEFAULT(vback_porch,	(635 - 600 - 8 - 4)), // 23
		},
	},
};

/*
 * Because lxk_display_info is not explicitly sized in the declaration,
 * ARRAY_SIZE will only work within this file. Provide a global for the size
 * to avoid wasting the space for a full dummy entry as a delimiter.
 */
int lxk_display_info_count = ARRAY_SIZE(lxk_display_info);

int lxk_vga_translate(vga_panel_data *vpd, const lxk_gen2_display_info_t *display) {
	if(!vpd || !display)
		return -1;

	vpd->vga_type = display->lxk_type;
	vpd->sequential = 0;
	vpd->xres = display->dt.hactive.typ;
	vpd->yres = display->dt.vactive.typ;
	vpd->vpi.hfp = display->dt.hfront_porch.typ;
	vpd->vpi.hpw = display->dt.hsync_len.typ;
	vpd->vpi.hbp = display->dt.hback_porch.typ;
	vpd->vpi.vfp = display->dt.vfront_porch.typ;
	vpd->vpi.vpw = display->dt.vsync_len.typ;
	vpd->vpi.vbp = display->dt.vback_porch.typ;
        vpd->dt = &display->dt;

	return 0;
}
