#include <asm/arch/gpio.h>
#include "mv61fb.h"
#include <lcd.h>
#include <lxk_panel.h>
#include <lcd.h>
#include <lxk_panel.h>
#include "lxk_eeprom_info.h"
#include <asm/arch/board_priv.h>
#include "lxk_panel_common.h"

#define REF_RATE_HZ (60)

int lxk_mv61fb_dumb_panel_init(void *reg_base, void *buffer)
{
	char string[32];
	vga_panel_info *vpi = NULL;
	vga_panel_data *vpd = NULL;
	unsigned xtotal, ytotal;
	unsigned tmp;
	unsigned dumb_ctrl;
	int inv_sync;
	unsigned bufsize;

	vpd = (vga_panel_data *)panel_info.priv;
	if(!vpd) {
		LXKPANELDBG("%s:%d: no panel data found\n", __func__, __LINE__);
		return -1;
	}
	
	vpi = (vga_panel_info *)&vpd->vpi;
		
	if(PANEL_FLAGS1_PIXEL_DEPTH(vpi->flags1) != PIXEL_DEPTH_16) {
		LXKPANELDBG("%s:%d: unsupported color depth\n", __func__, __LINE__);
		return -1;
	}
	
	xtotal = vpd->xres + vpi->hfp + vpi->hpw + vpi->hbp;
	ytotal = vpd->yres + vpi->vfp + vpi->vpw + vpi->vbp;
	
	bufsize = panel_info.vl_row*panel_info.vl_col*(NBITS(panel_info.vl_bpix)/8);
	tmp = lxk_vram_size();
	if(bufsize > tmp) {
		printf("%s:%d: Error, display frame size 0x%08x exceeds frame buffer "
					"size 0x%08x\n", __func__, __LINE__, 
					bufsize, tmp);
		return -1;
	}	
	sprintf(string, "0x%08x@0x%p", tmp, buffer);
	setenv("vram",string);

	/*
	 * Hardware considers inverted syncs to be active low.
	 * Linux considers inverted syncs to be active high.
	 * The display data flag is consistent with linux.
	 */
	inv_sync = vpi->flags1 & PANEL_FLAGS1_INV_SYNC ? 0 : 1;

	/*
	 * Configure default register values.
	 */
	writel( 0x000000ff, reg_base + LCD_CFG_SCLK_DIV);
	writel( 0x00000000, reg_base + LCD_SPU_DMA_CTRL0);
	writel( 0x00000000, reg_base + LCD_SPU_DMA_CTRL1);
	writel( 0x00000000, reg_base + LCD_SPU_SMPN_CTRL);
	writel( 0x00000000, reg_base + LCD_SPU_DUMB_CTRL);
	writel( 0x00000000, reg_base + SPU_IOPAD_CONTROL);
	writel( 0x00000000, reg_base + SPU_IRQ_ENA);
	writel( 0x00000050, reg_base + LCD_TOP_CTRL);
	writel( 0x00000000, reg_base + SPU_IRQ_ISR);
	writel( 0x00000000, reg_base + LCD_SPU_BLANKCOLOR);
	writel( 0x00000000, reg_base + LCD_SPU_GRA_OVSA_HPXL_VLN);
	writel( 0x00000000, reg_base + LCD_SPU_SRAM_PARA1);

	writel( (unsigned int)buffer, reg_base + LCD_CFG_GRA_START_ADDR0);
	writel( (unsigned int)buffer, reg_base + LCD_CFG_GRA_START_ADDR1);

	//writel( 0x00010001, reg_base + LCD_PN_SEPXLCNT);
	//writel( 0x00000000, reg_base + LCD_SPU_DUMB_CTRL);
	
	
	/*
	 * configure the frame buffer to represent full-screen on the panel.
	 */
	tmp = vpd->yres << 16;
	tmp |= vpd->xres & 0x0ffff;
	writel(tmp, reg_base + LCD_SPU_V_H_ACTIVE);
	writel(tmp, reg_base + LCD_SPU_GRA_HPXL_VLN);
	writel(tmp, reg_base + LCD_SPU_GZM_HPXL_VLN);

	dmb();
	
	tmp = REF_RATE_HZ * xtotal * ytotal;
	if(vpd->sequential)	/* sequential mode transfers 1 color per clock */
		tmp *= 3;
	tmp = lxk_mv61fb_get_clk_div(tmp);
	writel(tmp, reg_base + LCD_CFG_SCLK_DIV);

	/* Reset the data path and state machines. */
	writel(0, (reg_base + LCD_SOFT_RESET));
	udelay(1);
	writel(CFG_SW_RESET(1), (reg_base + LCD_SOFT_RESET));
	udelay(1);
	writel(0, (reg_base + LCD_SOFT_RESET));
	udelay(1);

   	/* enable lvds serializer */
	gpio_direction(VIDEO_SIG, 1);
   	gpio_set(VIDEO_SIG, 1);
	
	tmp = CFG_DMAFORMAT(PIX_FMT_RGB565); /* format of src data in buffer */
	tmp |= CFG_ARBFAST_ENA(1);
	if(!(vpi->flags1 & PANEL_FLAGS1_RB_SWAP)) {
		/* sense of RB_SWAP is reversed for dumb vs smart panels */
		tmp |= CFG_GRA_SWAPRB(1);
	}
	tmp |= CFG_GRA_ENA(1);
	writel(tmp, reg_base + LCD_SPU_DMA_CTRL0);
	
	tmp = CFG_FRAME_TRIG(0);
	tmp |= CFG_VSYNC_TRIG(VSYNC_MODE_DUMB_VSYNC); /* dumb vsync triggers dma */
	tmp |= CFG_VSYNC_INV(inv_sync);               /* 1 = falling edge triggers dma, 0 = rising edge */
	tmp |= CFG_PN_ALPHA_MODE(ALPHA_DISABLED);     /* disable Alpha channel */
	tmp |= CFG_PN_ALPHA(0xff);                    /* no effect when disabled, but stay consistent with sim */
	tmp |= CFG_PXLCMD(PXLCMD_OPAQUE_VALUE);       /* per spec */
	writel(tmp, reg_base + LCD_SPU_DMA_CTRL1);
	
	lxk_mv61fb_default_gamma(reg_base);           /* Initialize gamma correction to 1:1 */

	tmp = vpd->xres * (NBITS(panel_info.vl_bpix)/8);
	writel( tmp, reg_base + LCD_CFG_GRA_PITCH);
	
	if(vpd->sequential)
		tmp = CFG_DUMBMODE(DUMB_MODE_RGB888); /* 24 bit output for sequential mode */		
	else
		tmp = CFG_DUMBMODE(DUMB_MODE_RGB565);

	tmp |= CFG_LCDGPIO_ENA(0x0ff);
	if(inv_sync) {
		tmp |= CFG_INV_VSYNC(1);
		tmp |= CFG_INV_HSYNC(1);
	}
	if(vpi->flags1 & PANEL_FLAGS1_INV_CLK)
		tmp |= CFG_INV_PCLK(1);
	dumb_ctrl = tmp;
	writel(dumb_ctrl, reg_base + LCD_SPU_DUMB_CTRL);

	if(vpd->sequential)
		tmp = CFG_IOPADMODE(PIN_MODE_DUMB_SEQ_8_RGB);
	else
		tmp = CFG_IOPADMODE(PIN_MODE_DUMB_16_GPIO);
	writel( tmp, reg_base + SPU_IOPAD_CONTROL);

	tmp = ytotal << 16;
	tmp |= xtotal;
	writel(tmp, reg_base + LCD_SPUT_V_H_TOTAL);
	
	tmp = CFG_PN_V_SPXLCNT(1);
	tmp |= CFG_PN_V_EPXLCNT(vpd->xres + vpi->hfp + vpi->hbp);
	writel( tmp, reg_base + LCD_PN_SEPXLCNT);
	
	tmp = ((unsigned)vpi->hbp & 0x0ff) << 16;
	tmp |= ((unsigned)vpi->hfp & 0x0ff);
	writel(tmp, reg_base + LCD_SPU_H_PORCH);

	tmp = ((unsigned)vpi->vbp & 0x0ff) << 16;
	tmp |= ((unsigned)vpi->vfp & 0x0ff);
	writel(tmp, reg_base + LCD_SPU_V_PORCH);

	lxk_mv61fb_paint_buffer(buffer, bufsize); 	
	
	dumb_ctrl |= CFG_DUMB_ENA(1);
	writel(dumb_ctrl, reg_base + LCD_SPU_DUMB_CTRL);

	//writel( 0xfee90000, reg_base + SPU_IRQ_ENA);
	
	dmb();
	
	mdelay(10);
	
	vpd->backlight_enable(1);
	
	lxk_mv61fb_dump_regs(reg_base);
	
	return 0;
}
