/*----------------------------------------------------------------------------
 *
 * This is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * The software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with the this software; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA.
 */

#ifndef _LCD_SMPN_INFO_H_
#define _LCD_SMPN_INFO_H_

/**
 * lcd_smpn_info - smart lcd controller information
 * 
 */

typedef struct	lcd_smpn_info {
	
	/* effective resolution after rotation (if applicable) */
	int			xres;
	int			yres;
	int			bpp;		/* bits per pel */
	int			bufsize;	/* full screen size in bytes */
	
	/* minimum active/hold/cycle time in nS */
	int 			rxlow;
	int 			rxhigh;
	int 			rxcycle;
	int 			txlow;
	int 			txhigh;
	int 			txcycle;

	/* control sequence data */
	const unsigned short	*power_on;
	int			power_on_size;
	const unsigned short	*power_off;
	int			power_off_size;
	const unsigned short	*panel_on;
	int			panel_on_size;
	const unsigned short	*panel_off;
	int			panel_off_size;
	const unsigned short	*frame_update;
	int			frame_update_size;
	const unsigned short	*rotate;
	int			rotate_size;
	const unsigned short	*vsync_on;
	int			vsync_on_size;
	
} lcd_smpn_info_t;
#endif
