
#if 0
#include <linux/module.h>
#include <linux/sched.h>
#include <linux/slab.h>
#endif
#include <common.h>
#include <errno.h>
#include <malloc.h>
#include <linux/types.h>
#include <linux/err.h>
#include <asm/atomic.h>
#include <linux/mtd/mtd.h>
#include <linux/mtd/partitions.h>
#include "../../board/obelisk/include/obelisk_bbt.h"

static int read_bbt(struct mtd_info *mtd, BadBlockTable_t **bbt,
		    unsigned int *num_entries)
{
	size_t retlen;
	int err;
	BootBlock_t boot_block;
	int i, bbt_offset, bbt_num_entries;
	size_t size;
	BadBlockTable_t *table=0;

	/* Get the boot block */
	err = mtd->read(mtd, 0, sizeof(boot_block), &retlen,
				(u_char*)&boot_block);
	if (err < 0) {
		printk("lxkshim: failed to read boot block %x\n", err);
		goto error;
	}

	if ((be32_to_cpu(boot_block.Magic) != BOOT_BLOCK_MAGIC) &&
	    (be32_to_cpu(boot_block.Magic) != BOOT_BLOCK_DATA_MAGIC)) {
		err = -ENXIO;
		printk("lxkshim: bad magic in boot block %x\n",
		       be32_to_cpu(boot_block.Magic));
		goto error;
	}

	/* Choose the number of entries in the table based on if the bad block
	 * table was moved. */
	if (boot_block.offsetBadBlockTable != -1)
		bbt_num_entries = be32_to_cpu(boot_block.numberBadBlocks);
	else
		bbt_num_entries = MAX_BAD_BLOCKS;

	size = bbt_num_entries * sizeof(BadBlockTable_t);
	table = (BadBlockTable_t *)kmalloc(size, GFP_KERNEL);
	if (!table) {
		err = -ENOMEM;
		printk("lxkshim: enomem?!\n");
		goto error;
	}

	/* The bad block table may have been moved, so if it has, read it from
	 * the new location. */
	if (boot_block.offsetBadBlockTable != -1) {
		bbt_offset = be32_to_cpu(boot_block.offsetBadBlockTable);

		err = mtd->read(mtd, bbt_offset, size, &retlen, (u_char*)table);
		if (err < 0) {
			printk("lxkshim: failed to read new bbt\n");
			goto error;
		}
	} else {
		memcpy(table, boot_block.BBT, size);
	}

	for (i=0; i<bbt_num_entries; i++) {
		table[i].Block = be16_to_cpu(table[i].Block);
		table[i].Remap = be16_to_cpu(table[i].Remap);
	}

	*num_entries = bbt_num_entries;
	*bbt = table;
	return 0;

error:
	if (table)
		kfree(table);
	return err;
}

static loff_t get_mapped_block(struct mtd_info *mtd, loff_t offset,
			       BadBlockTable_t *bbt, int num_entries)
{
	int i;
	short block;

#if 0
	/* We do a 32-bit cast so that we can do division. */
	BUG_ON((unsigned long long int)offset >
			(unsigned long long int) UINT_MAX);
#endif

	/* This is mostly for qemu-utils because we probably wouldn't have
	 * had a badblock table. */
	if (!bbt)
		return offset;

	block = (uint32_t)offset / mtd->erasesize;
	for (i=0; i<num_entries; i++) {
		if (bbt[i].Block == -1)
			break;

		if (bbt[i].Block == block){
			block = bbt[i].Remap;
		}
	}

	return (block * mtd->erasesize) + ((uint32_t)offset % mtd->erasesize);
}

static int parent_mtd = 0;
#if 0
module_param(parent_mtd, int, 0600);
MODULE_PARM_DESC(parent_mtd, "Index of the MTD below the shim");
#endif

static struct mtd_info *parent_mtd_info;
static BadBlockTable_t *bbt;
static unsigned num_bbt_entries;

#define ROUND_DOWN_BY_BLOCK(mtd, offset) 	((offset) & ~(((unsigned int)((mtd)->erasesize))-1))
#define BLOCK_OFFSET(mtd, offset) 		((offset) &  (((unsigned int)((mtd)->erasesize))-1))

static inline loff_t count_blocks(struct mtd_info *mtd, uint64_t len)
{
	uint64_t num_blocks = len;
	if (do_div(num_blocks, mtd->erasesize))
		num_blocks++;
	return num_blocks;
}

static int
lxkshim_read (struct mtd_info *mtd, loff_t from, size_t len,
	      size_t *retlen, u_char *buf)
{
	loff_t offset = BLOCK_OFFSET(mtd, from);
	int ret = 0;
	*retlen = 0;
	from = ROUND_DOWN_BY_BLOCK(mtd, from);

	while (len > 0) {
		int this_len = (len < (mtd->erasesize-offset)) ?
			len : (mtd->erasesize-offset);
		size_t bytes = 0;
		loff_t block;

		block = get_mapped_block(parent_mtd_info, from, bbt,
					 num_bbt_entries);

		ret = parent_mtd_info->read(parent_mtd_info, block+offset,
					    this_len, &bytes, buf);
		if (ret < 0 || (offset + bytes) < mtd->erasesize) {
			if (bytes > 0)
				*retlen += bytes;
			break;
		}

		BUG_ON(bytes > mtd->erasesize);

		*retlen += bytes;
		from += mtd->erasesize;
		buf += bytes;
		offset = 0;
		len -= bytes;
	}

	return ret;
}

static int
lxkshim_isbad(struct mtd_info *mtd, loff_t ofs)
{
	int ret;

	ofs = ROUND_DOWN_BY_BLOCK(mtd, ofs);
	ofs = get_mapped_block(parent_mtd_info, ofs, bbt, num_bbt_entries);

	ret = parent_mtd_info->block_isbad(parent_mtd_info, ofs);
	return ret;
}

static int
lxkshim_write (struct mtd_info *mtd, loff_t to, size_t len,
	       size_t *retlen, const u_char *buf)
{
	loff_t offset = BLOCK_OFFSET(mtd, to);
	int ret = 0;
	*retlen = 0;
	to = ROUND_DOWN_BY_BLOCK(mtd, to);

	while (len > 0) {
		int this_len = (len < (mtd->erasesize-offset)) ?
			len : (mtd->erasesize-offset);
		size_t bytes = 0;
		loff_t block;

		block = get_mapped_block(parent_mtd_info, to, bbt,
					 num_bbt_entries);

		ret = parent_mtd_info->write(parent_mtd_info, block+offset,
					    this_len, &bytes, buf);
		if (ret < 0 || (offset + bytes) < mtd->erasesize) {
			if (bytes > 0)
				*retlen += bytes;
			break;
		}

		BUG_ON(bytes > mtd->erasesize);

		*retlen += bytes;
		to += mtd->erasesize;
		buf += bytes;
		offset = 0;
		len -= bytes;
	}

	return ret;
}

struct lxkshim_einfo {
	struct erase_info einfo;
	struct erase_info *orig_einfo;
	atomic_t *counter;
};

static void
lxkshim_erase_cb (struct erase_info *einfo)
{
	struct lxkshim_einfo *shimfo = (struct lxkshim_einfo *)einfo;

	// XXX: need to handle failure CB

	// dec_and_test returns true if we decremented to zero
	if (atomic_dec_and_test(shimfo->counter)) {
		if (shimfo->orig_einfo->callback) {
			shimfo->orig_einfo->state = einfo->state;
			shimfo->orig_einfo->callback(shimfo->orig_einfo);
		}

		// if we get here that means all the initial erases
		// succeeded, therefore we are responsible for freeing
		// these
		kfree(shimfo->counter);
	}
	kfree(shimfo);
}

static int
lxkshim_erase (struct mtd_info *mtd, struct erase_info *einfo)
{
	atomic_t *counter = kmalloc(sizeof(atomic_t), GFP_KERNEL);
	int num_blocks = count_blocks(mtd, einfo->len);
	int i, ret = 0;

	atomic_set(counter, num_blocks);

	for (i=0; i<num_blocks; i++) {
		struct lxkshim_einfo *shimfo;
		unsigned block = ROUND_DOWN_BY_BLOCK(mtd, einfo->addr +
						     i*mtd->erasesize);

		/* Create new erase_info to erase one block */
		shimfo = kmalloc(sizeof(*shimfo), GFP_KERNEL);
		memcpy(&shimfo->einfo, einfo, sizeof(shimfo->einfo));
		shimfo->orig_einfo = einfo;
		shimfo->counter = counter;
		shimfo->einfo.addr = get_mapped_block(parent_mtd_info, block,
						      bbt, num_bbt_entries);
		shimfo->einfo.len = mtd->erasesize;
		shimfo->einfo.mtd = parent_mtd_info;
		shimfo->einfo.callback = lxkshim_erase_cb;

		ret = parent_mtd_info->erase(parent_mtd_info,
					     &shimfo->einfo);
		if (ret) {
			einfo->fail_addr = einfo->addr + i*mtd->erasesize;
			einfo->state = shimfo->einfo.state;
			// callback doesn't run when erase fails immediately
			kfree(shimfo);
			break;
		}
	}

	if (ret) {
		// wait until any other outstanding erases finish
		assert(atomic_read(counter) == num_blocks - i);
		kfree(counter);
	}

	return ret;
}

static int
lxkshim_read_oob (struct mtd_info *mtd, loff_t from,
		  struct mtd_oob_ops *ops)
{
	loff_t offset = BLOCK_OFFSET(mtd, from);
	int ret = 0;
	uint8_t *buf = ops->datbuf;
	ops->retlen = 0;
	ops->oobretlen = 0;
	from = ROUND_DOWN_BY_BLOCK(mtd, from);

	// Might be able to get away without implementing this; nanddump
	// can skip the shim
	BUG_ON(ops->ooblen > 0);

	while (ops->len > 0) {
		int this_len = (ops->len < (mtd->erasesize-offset)) ?
			ops->len : (mtd->erasesize-offset);
		struct mtd_oob_ops new_ops;
		loff_t block;

		block = get_mapped_block(parent_mtd_info, from, bbt,
					 num_bbt_entries);

		memset(&new_ops, 0, sizeof(new_ops));
		new_ops.len = this_len;
		new_ops.datbuf = buf;
		new_ops.retlen = 0;
		new_ops.ooblen = 0;
		new_ops.oobbuf = NULL;

		ret = parent_mtd_info->read_oob(parent_mtd_info, block+offset,
						&new_ops);
		if (ret < 0 || (new_ops.retlen + offset) < mtd->erasesize) {
			if (new_ops.retlen > 0)
				ops->retlen += new_ops.retlen;
			break;
		}

		BUG_ON(new_ops.retlen > mtd->erasesize);

		ops->retlen += new_ops.retlen;
		from += mtd->erasesize;
		buf += new_ops.retlen;
		offset = 0;
		ops->len -= new_ops.retlen;
	}

	return ret;
}

static int
lxkshim_write_oob (struct mtd_info *mtd, loff_t to,
		   struct mtd_oob_ops *ops)
{
	loff_t offset = BLOCK_OFFSET(mtd, to);
	int ret = 0;
	uint8_t *buf = ops->datbuf;
	ops->retlen = 0;
	ops->oobretlen = 0;
	to = ROUND_DOWN_BY_BLOCK(mtd, to);

	// Might be able to get away without implementing this; nanddump
	// can skip the shim
	BUG_ON(ops->oobbuf && ops->ooblen > 0);

	while (ops->len > 0) {
		int this_len = (ops->len < (mtd->erasesize-offset)) ?
			ops->len : (mtd->erasesize-offset);
		struct mtd_oob_ops new_ops;
		loff_t block;

		block = get_mapped_block(parent_mtd_info, to, bbt,
					 num_bbt_entries);

		memset(&new_ops, 0, sizeof(new_ops));
		new_ops.len = this_len;
		new_ops.datbuf = buf;
		new_ops.retlen = 0;
		new_ops.ooblen = 0;
		new_ops.oobbuf = NULL;

		ret = parent_mtd_info->write_oob(parent_mtd_info, block+offset,
						 &new_ops);
		if (ret < 0 || (new_ops.retlen + offset) < mtd->erasesize) {
			if (new_ops.retlen > 0)
				ops->retlen += new_ops.retlen;
			break;
		}

		BUG_ON(new_ops.retlen > mtd->erasesize);

		ops->retlen += new_ops.retlen;
		to += mtd->erasesize;
		buf += new_ops.retlen;
		offset = 0;
		ops->len -= new_ops.retlen;
	}

	return ret;
}

struct mtd_info lxkshim_mtd = {
	.name =		"lxkshim",
	.read = 	lxkshim_read,
	.block_isbad = 	lxkshim_isbad,
	.write = 	lxkshim_write,
	.erase = 	lxkshim_erase,
	.read_oob = 	lxkshim_read_oob,
	.write_oob =	lxkshim_write_oob,
};

extern int mtd_get_partition_info_ssp(struct mtd_info *mtd, struct mtd_partition **partition_table);

int lxkshim_init (struct mtd_info *mtd)
{
	parent_mtd_info = get_mtd_device(NULL, parent_mtd);
	if (!parent_mtd_info || IS_ERR(parent_mtd_info)) {
		printk(KERN_ERR "no such mtd %d\n", parent_mtd);
		return -ENODEV;
	}

	/* Clone properties from the parent */
	lxkshim_mtd.size = 	parent_mtd_info->size;
	lxkshim_mtd.erasesize = parent_mtd_info->erasesize;
	lxkshim_mtd.writesize = parent_mtd_info->writesize;
	lxkshim_mtd.oobsize = 	parent_mtd_info->oobsize;
	lxkshim_mtd.ecclayout = parent_mtd_info->ecclayout;
	lxkshim_mtd.type = 	parent_mtd_info->type;
	lxkshim_mtd.flags = 	parent_mtd_info->flags;

	add_mtd_device(&lxkshim_mtd);

	read_bbt(&lxkshim_mtd, &bbt, &num_bbt_entries);

#if 0
	ret = parse_mtd_partitions(&lxkshim_mtd, part_probes, &parts, 0);
	if (ret > 0)
		add_mtd_partitions(&lxkshim_mtd, parts, ret);
#else
	/*** Partitions ***/
	{
        int num_partitions;
        struct mtd_partition *partition_table;

        num_partitions = mtd_get_partition_info_ssp(&lxkshim_mtd, &partition_table);
        if (num_partitions > 0)
		add_mtd_partitions(&lxkshim_mtd, partition_table, num_partitions);
	}
#endif

	memcpy(mtd, &lxkshim_mtd, sizeof(*mtd));

	return 0;
}

#if 0
void lxkshim_exit (void)
{
	del_mtd_device(&lxkshim_mtd);
	put_mtd_device(parent_mtd_info);
}

module_init(lxkshim_init);
module_exit(lxkshim_exit);
MODULE_LICENSE("GPL");
#endif
