#include <common.h>
#include <asm/arch/gpio.h>
#include <asm/gpio.h>


 
/*  RICOH add
 *    set all pinconfigs.
 */
#define GPIO_233_MAIN_POW 156
#define GPIO_233_SUB_POW 13
#define GPIO_RESET_FCU_N 47
#define GPIO_PECLK_FCU_EN 115
#define GPIO_PRSNT_N 203
#define GPIO_TYPE_RECOG 138
#define GPIO_GROUP_NUM 6

typedef struct reg_setting {
	volatile unsigned long *reg_addr;
	unsigned long reg_val;
} reg_setting_t;

typedef struct gpio_setting {
	reg_setting_t set;
	reg_setting_t clr;
	reg_setting_t dir;
} gpio_setting_t;

static const reg_setting_t iopad_reg_setting_array_s1c_mfp[] = {
	{(volatile unsigned long*)0xd401e000, 0x00018041},/* USB3X0_VB_nOC_1P8 */
	{(volatile unsigned long*)0xd401e004, 0x00018041},/* USB2X1_VB_nOC_1P8 */
	{(volatile unsigned long*)0xd401e008, 0x0001c040},/* GPIOA[2] */
	{(volatile unsigned long*)0xd401e00c, 0x00018041},/* USB2X1_nPWR_EN */
	{(volatile unsigned long*)0xd401e010, 0x00018041},/* USB2H2_nOC */
	{(volatile unsigned long*)0xd401e014, 0x00018041},/* USB2H2_nPWR_EN */
	{(volatile unsigned long*)0xd401e018, 0x00018041},/* SER1_RXD */
	{(volatile unsigned long*)0xd401e01c, 0x00018041},/* SER1_TXD */
	{(volatile unsigned long*)0xd401e020, 0x00018041},/* I2C1_SCLK */
	{(volatile unsigned long*)0xd401e024, 0x00018041},/* I2C1_SDA */
	{(volatile unsigned long*)0xd401e028, 0x00018042},/* SPi1_CLK */
	{(volatile unsigned long*)0xd401e02c, 0x00018042},/* SPi1_MOSI */
	{(volatile unsigned long*)0xd401e030, 0x00018042},/* SPi1_MISO */
	{(volatile unsigned long*)0xd401e034, 0x00018040},/* GPIOA[13] */
	{(volatile unsigned long*)0xd401e038, 0x00018040},/* GPIOA[14] */
	{(volatile unsigned long*)0xd401e03c, 0x00018042},/* SPi1_nCS */
	{(volatile unsigned long*)0xd401e040, 0x00018042},/* I2C2_SDA */
	{(volatile unsigned long*)0xd401e044, 0x00018042},/* I2C2_SCLK */
	{(volatile unsigned long*)0xd401e048, 0x00018043},/* I2C5_SCLK */
	{(volatile unsigned long*)0xd401e04c, 0x00018043},/* I2C5_SDA */
	{(volatile unsigned long*)0xd401e050, 0x00018041},/* ENET_RX_CLK */
	{(volatile unsigned long*)0xd401e054, 0x00018041},/* ENET_RX_CTRL */
	{(volatile unsigned long*)0xd401e058, 0x00018041},/* ENET_RX_D0 */
	{(volatile unsigned long*)0xd401e05c, 0x00018041},/* ENET_RX_D1 */
	{(volatile unsigned long*)0xd401e060, 0x00018041},/* ENET_RX_D2 */
	{(volatile unsigned long*)0xd401e064, 0x00018041},/* ENET_RX_D3 */
	{(volatile unsigned long*)0xd401e068, 0x00018041},/* ENET_TX_D0 */
	{(volatile unsigned long*)0xd401e06c, 0x00018041},/* ENET_TX_D1 */
	{(volatile unsigned long*)0xd401e070, 0x00018041},/* ENET_TX_D2 */
	{(volatile unsigned long*)0xd401e074, 0x00018041},/* ENET_TX_D3 */
	{(volatile unsigned long*)0xd401e078, 0x00018041},/* ENET_TX_CTRL */
	{(volatile unsigned long*)0xd401e07c, 0x00018041},/* ENET_TX_CLK */
	{(volatile unsigned long*)0xd401e080, 0x00018041},/* ENET_MDC */
	{(volatile unsigned long*)0xd401e084, 0x00018041},/* ENET_MDIO */
	{(volatile unsigned long*)0xd401e088, 0x00018040},/* GPIOB[2] */
	{(volatile unsigned long*)0xd401e08c, 0x00018041},/* ENET_25MHz_CLK */
	{(volatile unsigned long*)0xd401e1e4, 0x00019842},/* SD_MMC1_CLK */
	{(volatile unsigned long*)0xd401e1e8, 0x00018042},/* SD_MMC1_CMD */
	{(volatile unsigned long*)0xd401e1f8, 0x00018042},/* SD_MMC1_DATA[0] */
	{(volatile unsigned long*)0xd401e1fc, 0x00018042},/* SD_MMC1_DATA[1] */
	{(volatile unsigned long*)0xd401e200, 0x00018042},/* SD_MMC1_DATA[2] */
	{(volatile unsigned long*)0xd401e204, 0x00018042},/* SD_MMC1_DATA[3] */
	{(volatile unsigned long*)0xd401e218, 0x00019841},/* SD_MMC0_CLK */
	{(volatile unsigned long*)0xd401e21c, 0x00018041},/* SD_MMC0_CMD */
	{(volatile unsigned long*)0xd401e220, 0x00018041},/* SD_MMC0_DATA[0] */
	{(volatile unsigned long*)0xd401e224, 0x00018041},/* SD_MMC0_DATA[1] */
	{(volatile unsigned long*)0xd401e228, 0x00018041},/* SD_MMC0_DATA[2] */
	{(volatile unsigned long*)0xd401e22c, 0x00018041},/* SD_MMC0_DATA[3] */
	{(volatile unsigned long*)0xd401e230, 0x00018041},/* SD_MMC0_DATA[4] */
	{(volatile unsigned long*)0xd401e234, 0x00018041},/* SD_MMC0_DATA[5] */
	{(volatile unsigned long*)0xd401e238, 0x00018041},/* SD_MMC0_DATA[6] */
	{(volatile unsigned long*)0xd401e23c, 0x00018041},/* SD_MMC0_DATA[7] */
	{(volatile unsigned long*)0xd401e240, 0x00018040},/* GPIOE[8] */
	{(volatile unsigned long*)0xd401e244, 0x00018040},/* GPIOE[9] */
	{(volatile unsigned long*)0xd401e248, 0x00018040},/* GPIOE[10] */
	{(volatile unsigned long*)0xd401e24c, 0x00018040},/* GPIOE[11] */
	{(volatile unsigned long*)0xd401e250, 0x00019841},/* SD_MMC2_CLK */
	{(volatile unsigned long*)0xd401e254, 0x00018041},/* SD_MMC2_CMD */
	{(volatile unsigned long*)0xd401e258, 0x00018041},/* SD_MMC2_DATA[0] */
	{(volatile unsigned long*)0xd401e25c, 0x00018041},/* SD_MMC2_DATA[1] */
	{(volatile unsigned long*)0xd401e260, 0x00018041},/* SD_MMC2_DATA[2] */
	{(volatile unsigned long*)0xd401e264, 0x00018041},/* SD_MMC2_DATA[3] */
	{(volatile unsigned long*)0xd401e268, 0x0001c040},/* GPIOE[18] */
	{(volatile unsigned long*)0xd401e26c, 0x00018040},/* GPIOE[19] */
	{(volatile unsigned long*)0xd401e270, 0x0001c040},/* GPIOE[20] */
	{(volatile unsigned long*)0xd401e274, 0x00018040},/* GPIOE[21] */
	{(volatile unsigned long*)0xd401e278, 0x00018040},/* GPIOE[22] */
	{(volatile unsigned long*)0xd401e27c, 0x00018040},/* GPIOE[23] */
	{(volatile unsigned long*)0xd401e280, 0x0001c040},/* GPIOE[24] */
	{(volatile unsigned long*)0xd401e284, 0x0001c040},/* GPIOE[25] */
	{(volatile unsigned long*)0xd401e288, 0x00018040},/* GPIOE[26] */
	{(volatile unsigned long*)0xd401e28c, 0x00018040},/* GPIOE[27] */
	{(volatile unsigned long*)0xd401e290, 0x00019840},/* GPIOE[28] */
	{(volatile unsigned long*)0xd401e34c, 0x00019843},/* I2S_MCLK */
	{(volatile unsigned long*)0xd401e3b4, 0x00019841},/* I2S_TXD */
	{(volatile unsigned long*)0xd401e3b8, 0x00019841},/* I2S_SCLK */
	{(volatile unsigned long*)0xd401e3bc, 0x00019841},/* I2S_WS */
	/* *********************************************************** */
	{(volatile unsigned long*)0xd401e0ec, 0x0002a040},/*GPIOB[27]  */
	{(volatile unsigned long*)0xd401e120, 0x0001b043},/*UPC_PEN[4] */
	{(volatile unsigned long*)0xd401e128, 0x0001b043},/*UPC_PEN[6] */
	{(volatile unsigned long*)0xd401e130, 0x0001a843},/*UPC_PEN[8] */
	{(volatile unsigned long*)0xd401e134, 0x0001a843},/*UPC_PEN[9] */
	{(volatile unsigned long*)0xd401e138, 0x0001a843},/*UPC_PEN[10]*/
	{(volatile unsigned long*)0xd401e144, 0x0001a843},/*UPC_PEN[13]*/
	{(volatile unsigned long*)0xd401e148, 0x0001a843},/*UPC_PEN[14]*/
	{(volatile unsigned long*)0xd401e14c, 0x0001a843},/*UPC_PEN[15]*/
	{(volatile unsigned long*)0xd401e158, 0x0001a843},/*UPC_PEN[18]*/
	{(volatile unsigned long*)0xd401e15c, 0x0001a843},/*UPC_PEN[19]*/
	{(volatile unsigned long*)0xd401e16c, 0x0002b043},/*UPC_PEN[23]*/
	{(volatile unsigned long*)0xd401e170, 0x0001b046},/*SCCP1_D[5] */
	{(volatile unsigned long*)0xd401e174, 0x0001b046},/*SCCP1_D[6] */
	{(volatile unsigned long*)0xd401e178, 0x0002b046},/*SCCP1_D[7] */
	{(volatile unsigned long*)0xd401e17c, 0x0001b046},/*SCCP1_D[8] */
	{(volatile unsigned long*)0xd401e180, 0x0002b043},/*UPC_PEN[28]*/
	{(volatile unsigned long*)0xd401e188, 0x0001a043},/*UPC_PEN[30]*/
	/* *********************************************************** */
	{(volatile unsigned long*)0xffffffff, 0xffffffff},/* ANCHOR */
};/* iopad_reg_setting_array_s1c_mfp[] */

static const reg_setting_t iopad_reg_setting_array_s1c_sfp[] = {
	{(volatile unsigned long*)0xd401e000, 0x00018041},/* USB3X0_VB_nOC_1P8 */
	{(volatile unsigned long*)0xd401e004, 0x00018041},/* USB2X1_VB_nOC_1P8 */
	{(volatile unsigned long*)0xd401e008, 0x0001c040},/* GPIOA[2] */
	{(volatile unsigned long*)0xd401e00c, 0x00018041},/* USB2X1_nPWR_EN */
	{(volatile unsigned long*)0xd401e010, 0x00018041},/* USB2H2_nOC */
	{(volatile unsigned long*)0xd401e014, 0x00018041},/* USB2H2_nPWR_EN */
	{(volatile unsigned long*)0xd401e018, 0x00018041},/* SER1_RXD */
	{(volatile unsigned long*)0xd401e01c, 0x00018041},/* SER1_TXD */
	{(volatile unsigned long*)0xd401e020, 0x00018041},/* I2C1_SCLK */
	{(volatile unsigned long*)0xd401e024, 0x00018041},/* I2C1_SDA */
	{(volatile unsigned long*)0xd401e028, 0x00018042},/* SPi1_CLK */
	{(volatile unsigned long*)0xd401e02c, 0x00018042},/* SPi1_MOSI */
	{(volatile unsigned long*)0xd401e030, 0x00018042},/* SPi1_MISO */
	{(volatile unsigned long*)0xd401e034, 0x00018040},/* GPIOA[13] */
	{(volatile unsigned long*)0xd401e038, 0x00018040},/* GPIOA[14] */
	{(volatile unsigned long*)0xd401e03c, 0x00018042},/* SPi1_nCS */
	{(volatile unsigned long*)0xd401e040, 0x00018042},/* I2C2_SDA */
	{(volatile unsigned long*)0xd401e044, 0x00018042},/* I2C2_SCLK */
	{(volatile unsigned long*)0xd401e048, 0x00018043},/* I2C5_SCLK */
	{(volatile unsigned long*)0xd401e04c, 0x00018043},/* I2C5_SDA */
	{(volatile unsigned long*)0xd401e050, 0x00018041},/* ENET_RX_CLK */
	{(volatile unsigned long*)0xd401e054, 0x00018041},/* ENET_RX_CTRL */
	{(volatile unsigned long*)0xd401e058, 0x00018041},/* ENET_RX_D0 */
	{(volatile unsigned long*)0xd401e05c, 0x00018041},/* ENET_RX_D1 */
	{(volatile unsigned long*)0xd401e060, 0x00018041},/* ENET_RX_D2 */
	{(volatile unsigned long*)0xd401e064, 0x00018041},/* ENET_RX_D3 */
	{(volatile unsigned long*)0xd401e068, 0x00018041},/* ENET_TX_D0 */
	{(volatile unsigned long*)0xd401e06c, 0x00018041},/* ENET_TX_D1 */
	{(volatile unsigned long*)0xd401e070, 0x00018041},/* ENET_TX_D2 */
	{(volatile unsigned long*)0xd401e074, 0x00018041},/* ENET_TX_D3 */
	{(volatile unsigned long*)0xd401e078, 0x00018041},/* ENET_TX_CTRL */
	{(volatile unsigned long*)0xd401e07c, 0x00018041},/* ENET_TX_CLK */
	{(volatile unsigned long*)0xd401e080, 0x00018041},/* ENET_MDC */
	{(volatile unsigned long*)0xd401e084, 0x00018041},/* ENET_MDIO */
	{(volatile unsigned long*)0xd401e088, 0x00018040},/* GPIOB[2] */
	{(volatile unsigned long*)0xd401e08c, 0x00018041},/* ENET_25MHz_CLK */
	{(volatile unsigned long*)0xd401e1e4, 0x00019842},/* SD_MMC1_CLK */
	{(volatile unsigned long*)0xd401e1e8, 0x00018042},/* SD_MMC1_CMD */
	{(volatile unsigned long*)0xd401e1f8, 0x00018042},/* SD_MMC1_DATA[0] */
	{(volatile unsigned long*)0xd401e1fc, 0x00018042},/* SD_MMC1_DATA[1] */
	{(volatile unsigned long*)0xd401e200, 0x00018042},/* SD_MMC1_DATA[2] */
	{(volatile unsigned long*)0xd401e204, 0x00018042},/* SD_MMC1_DATA[3] */
	{(volatile unsigned long*)0xd401e218, 0x00019841},/* SD_MMC0_CLK */
	{(volatile unsigned long*)0xd401e21c, 0x00018041},/* SD_MMC0_CMD */
	{(volatile unsigned long*)0xd401e220, 0x00018041},/* SD_MMC0_DATA[0] */
	{(volatile unsigned long*)0xd401e224, 0x00018041},/* SD_MMC0_DATA[1] */
	{(volatile unsigned long*)0xd401e228, 0x00018041},/* SD_MMC0_DATA[2] */
	{(volatile unsigned long*)0xd401e22c, 0x00018041},/* SD_MMC0_DATA[3] */
	{(volatile unsigned long*)0xd401e230, 0x00018041},/* SD_MMC0_DATA[4] */
	{(volatile unsigned long*)0xd401e234, 0x00018041},/* SD_MMC0_DATA[5] */
	{(volatile unsigned long*)0xd401e238, 0x00018041},/* SD_MMC0_DATA[6] */
	{(volatile unsigned long*)0xd401e23c, 0x00018041},/* SD_MMC0_DATA[7] */
	{(volatile unsigned long*)0xd401e240, 0x00018040},/* GPIOE[8] */
	{(volatile unsigned long*)0xd401e244, 0x00018040},/* GPIOE[9] */
	{(volatile unsigned long*)0xd401e248, 0x00018040},/* GPIOE[10] */
	{(volatile unsigned long*)0xd401e24c, 0x00018040},/* GPIOE[11] */
	{(volatile unsigned long*)0xd401e250, 0x00019841},/* SD_MMC2_CLK */
	{(volatile unsigned long*)0xd401e254, 0x00018041},/* SD_MMC2_CMD */
	{(volatile unsigned long*)0xd401e258, 0x00018041},/* SD_MMC2_DATA[0] */
	{(volatile unsigned long*)0xd401e25c, 0x00018041},/* SD_MMC2_DATA[1] */
	{(volatile unsigned long*)0xd401e260, 0x00018041},/* SD_MMC2_DATA[2] */
	{(volatile unsigned long*)0xd401e264, 0x00018041},/* SD_MMC2_DATA[3] */
	{(volatile unsigned long*)0xd401e268, 0x0001c040},/* GPIOE[18] */
	{(volatile unsigned long*)0xd401e26c, 0x00018040},/* GPIOE[19] */
	{(volatile unsigned long*)0xd401e270, 0x0001c040},/* GPIOE[20] */
	{(volatile unsigned long*)0xd401e274, 0x00018040},/* GPIOE[21] */
	{(volatile unsigned long*)0xd401e278, 0x00018040},/* GPIOE[22] */
	{(volatile unsigned long*)0xd401e27c, 0x00018040},/* GPIOE[23] */
	{(volatile unsigned long*)0xd401e280, 0x0001c040},/* GPIOE[24] */
	{(volatile unsigned long*)0xd401e284, 0x0001c040},/* GPIOE[25] */
	{(volatile unsigned long*)0xd401e288, 0x00018043},/* SER3_TXD */
	{(volatile unsigned long*)0xd401e28c, 0x00018043},/* SER3_RXD */
	{(volatile unsigned long*)0xd401e290, 0x00019840},/* GPIOE[28] */
	{(volatile unsigned long*)0xd401e34c, 0x00019843},/* I2S_MCLK */
	{(volatile unsigned long*)0xd401e3b4, 0x00019841},/* I2S_TXD */
	{(volatile unsigned long*)0xd401e3b8, 0x00019841},/* I2S_SCLK */
	{(volatile unsigned long*)0xd401e3bc, 0x00019841},/* I2S_WS */
	/* *********************************************************** */
	{(volatile unsigned long*)0xd401e0ec, 0x0002a040},/*GPIOB[27]  */
	{(volatile unsigned long*)0xd401e120, 0x0001b043},/*UPC_PEN[4] */
	{(volatile unsigned long*)0xd401e128, 0x0001b043},/*UPC_PEN[6] */
	{(volatile unsigned long*)0xd401e130, 0x0001a843},/*UPC_PEN[8] */
	{(volatile unsigned long*)0xd401e134, 0x0001a843},/*UPC_PEN[9] */
	{(volatile unsigned long*)0xd401e138, 0x0001a843},/*UPC_PEN[10]*/
	{(volatile unsigned long*)0xd401e144, 0x0001a843},/*UPC_PEN[13]*/
	{(volatile unsigned long*)0xd401e148, 0x0001a843},/*UPC_PEN[14]*/
	{(volatile unsigned long*)0xd401e14c, 0x0001a843},/*UPC_PEN[15]*/
	{(volatile unsigned long*)0xd401e158, 0x0001a843},/*UPC_PEN[18]*/
	{(volatile unsigned long*)0xd401e15c, 0x0001a843},/*UPC_PEN[19]*/
	{(volatile unsigned long*)0xd401e16c, 0x0002b043},/*UPC_PEN[23]*/
	{(volatile unsigned long*)0xd401e170, 0x0001b046},/*SCCP1_D[5] */
	{(volatile unsigned long*)0xd401e174, 0x0001b046},/*SCCP1_D[6] */
	{(volatile unsigned long*)0xd401e178, 0x0002b046},/*SCCP1_D[7] */
	{(volatile unsigned long*)0xd401e17c, 0x0001b046},/*SCCP1_D[8] */
	{(volatile unsigned long*)0xd401e180, 0x0002b043},/*UPC_PEN[28]*/
	{(volatile unsigned long*)0xd401e188, 0x0001a043},/*UPC_PEN[30]*/
	/* *********************************************************** */
	{(volatile unsigned long*)0xffffffff, 0xffffffff},/* ANCHOR */
};/* iopad_reg_setting_array_s1c_sfp[] */

static const reg_setting_t iopad_reg_setting_array_s1v_mfp[] = {
	{(volatile unsigned long*)0xd401e000, 0x00018041},/* USB3X0_VB_nOC_1P8 */
	{(volatile unsigned long*)0xd401e004, 0x00018041},/* USB2X1_VB_nOC_1P8 */
	{(volatile unsigned long*)0xd401e008, 0x0001c040},/* GPIOA[2] */
	{(volatile unsigned long*)0xd401e00c, 0x00018041},/* USB2X1_nPWR_EN */
	{(volatile unsigned long*)0xd401e010, 0x00018041},/* USB2H2_nOC */
	{(volatile unsigned long*)0xd401e014, 0x00018041},/* USB2H2_nPWR_EN */
	{(volatile unsigned long*)0xd401e018, 0x00018041},/* SER1_RXD */
	{(volatile unsigned long*)0xd401e01c, 0x00018041},/* SER1_TXD */
	{(volatile unsigned long*)0xd401e020, 0x00018041},/* I2C1_SCLK */
	{(volatile unsigned long*)0xd401e024, 0x00018041},/* I2C1_SDA */
	{(volatile unsigned long*)0xd401e028, 0x00018042},/* SPi1_CLK */
	{(volatile unsigned long*)0xd401e02c, 0x00018042},/* SPi1_MOSI */
	{(volatile unsigned long*)0xd401e030, 0x00018042},/* SPi1_MISO */
	{(volatile unsigned long*)0xd401e034, 0x00018040},/* GPIOA[13] */
	{(volatile unsigned long*)0xd401e038, 0x0001a040},/* GPIOA[14] */
	{(volatile unsigned long*)0xd401e03c, 0x00018042},/* SPi1_nCS */
	{(volatile unsigned long*)0xd401e040, 0x00018042},/* I2C2_SDA */
	{(volatile unsigned long*)0xd401e044, 0x00018042},/* I2C2_SCLK */
	{(volatile unsigned long*)0xd401e048, 0x00018043},/* I2C5_SCLK */
	{(volatile unsigned long*)0xd401e04c, 0x00018043},/* I2C5_SDA */
	{(volatile unsigned long*)0xd401e050, 0x00018041},/* ENET_RX_CLK */
	{(volatile unsigned long*)0xd401e054, 0x00018041},/* ENET_RX_CTRL */
	{(volatile unsigned long*)0xd401e058, 0x00018041},/* ENET_RX_D0 */
	{(volatile unsigned long*)0xd401e05c, 0x00018041},/* ENET_RX_D1 */
	{(volatile unsigned long*)0xd401e060, 0x00018041},/* ENET_RX_D2 */
	{(volatile unsigned long*)0xd401e064, 0x00018041},/* ENET_RX_D3 */
	{(volatile unsigned long*)0xd401e068, 0x00018041},/* ENET_TX_D0 */
	{(volatile unsigned long*)0xd401e06c, 0x00018041},/* ENET_TX_D1 */
	{(volatile unsigned long*)0xd401e070, 0x00018041},/* ENET_TX_D2 */
	{(volatile unsigned long*)0xd401e074, 0x00018041},/* ENET_TX_D3 */
	{(volatile unsigned long*)0xd401e078, 0x00018041},/* ENET_TX_CTRL */
	{(volatile unsigned long*)0xd401e07c, 0x00018041},/* ENET_TX_CLK */
	{(volatile unsigned long*)0xd401e080, 0x00018041},/* ENET_MDC */
	{(volatile unsigned long*)0xd401e084, 0x00018041},/* ENET_MDIO */
	{(volatile unsigned long*)0xd401e088, 0x00018040},/* GPIOB[2] */
	{(volatile unsigned long*)0xd401e08c, 0x00018041},/* ENET_25MHz_CLK */
	{(volatile unsigned long*)0xd401e090, 0x00018847},/* SCCP2_D[0] */
	{(volatile unsigned long*)0xd401e094, 0x00018847},/* SCCP2_D[1] */
	{(volatile unsigned long*)0xd401e098, 0x00018847},/* SCCP2_D[2] */
	{(volatile unsigned long*)0xd401e09c, 0x00018847},/* SCCP2_D[3] */
	{(volatile unsigned long*)0xd401e0a0, 0x00018043},/* SER4_RXD */
	{(volatile unsigned long*)0xd401e0a4, 0x00018043},/* SER4_TXD */
	{(volatile unsigned long*)0xd401e0a8, 0x00018040},/* GPIOB[10] */
	{(volatile unsigned long*)0xd401e0ac, 0x00018040},/* GPIOB[11] */
	{(volatile unsigned long*)0xd401e0b0, 0x00018040},/* GPIOB[12] */
	{(volatile unsigned long*)0xd401e0b4, 0x00018040},/* GPIOB[13] */
	{(volatile unsigned long*)0xd401e0b8, 0x0001a040},/* GPIOB[14] */
	{(volatile unsigned long*)0xd401e0bc, 0x0001a040},/* GPIOB[15] */
	{(volatile unsigned long*)0xd401e0c0, 0x0001a040},/* GPIOB[16] */
	{(volatile unsigned long*)0xd401e0c4, 0x0001a040},/* GPIOB[17] */
	{(volatile unsigned long*)0xd401e0c8, 0x0001a040},/* GPIOB[18] */
	{(volatile unsigned long*)0xd401e0cc, 0x0001a040},/* GPIOB[19] */
	{(volatile unsigned long*)0xd401e0d0, 0x0001a040},/* GPIOB[20] */
	{(volatile unsigned long*)0xd401e0d4, 0x00018040},/* GPIOB[21] */
	{(volatile unsigned long*)0xd401e0d8, 0x0001a040},/* GPIOB[22] */
	{(volatile unsigned long*)0xd401e0dc, 0x00018040},/* GPIOB[23] */
	{(volatile unsigned long*)0xd401e0e0, 0x00018040},/* GPIOB[24] */
	{(volatile unsigned long*)0xd401e0e4, 0x00018040},/* DPWM[25] */
	{(volatile unsigned long*)0xd401e0e8, 0x00018040},/* DPWM[26] */
	{(volatile unsigned long*)0xd401e0ec, 0x00018040},/* GPIOB[27] */
	{(volatile unsigned long*)0xd401e0f0, 0x0001a040},/* GPIOB[28] */
	{(volatile unsigned long*)0xd401e0f4, 0x0001a040},/* GPIOB[29] */
	{(volatile unsigned long*)0xd401e0f8, 0x0001a040},/* GPIOB[30] */
	{(volatile unsigned long*)0xd401e0fc, 0x0001a040},/* GPIOB[31] */
	{(volatile unsigned long*)0xd401e100, 0x0001a040},/* GPI_C[0] */
	{(volatile unsigned long*)0xd401e104, 0x0001a040},/* GPI_C[1] */
	{(volatile unsigned long*)0xd401e108, 0x0001a040},/* GPI_C[2] */
	{(volatile unsigned long*)0xd401e10c, 0x0001a040},/* GPI_C[3] */
	{(volatile unsigned long*)0xd401e128, 0x0001a040},/* GPIOC[10] */
	{(volatile unsigned long*)0xd401e12c, 0x0001a040},/* GPIOC[11] */
	{(volatile unsigned long*)0xd401e13c, 0x0001a040},/* GPIOC[15] */
	{(volatile unsigned long*)0xd401e140, 0x0001a040},/* GPIOC[16] */
	{(volatile unsigned long*)0xd401e150, 0x0001a040},/* GPIOC[20] */
	{(volatile unsigned long*)0xd401e154, 0x0001a040},/* GPIOC[21] */
	{(volatile unsigned long*)0xd401e164, 0x0001a040},/* GPIOC[25] */
	{(volatile unsigned long*)0xd401e170, 0x0001a040},/* GPIOC[28] */
	{(volatile unsigned long*)0xd401e178, 0x0001a040},/* GPIOC[30] */
	{(volatile unsigned long*)0xd401e190, 0x0001a040},/* GPIOD[4] */
	{(volatile unsigned long*)0xd401e194, 0x0001a040},/* GPIOD[5] */
	{(volatile unsigned long*)0xd401e198, 0x0001a040},/* GPIOD[6] */
	{(volatile unsigned long*)0xd401e19c, 0x0001a040},/* GPIOD[7] */
	{(volatile unsigned long*)0xd401e1d8, 0x00018040},/* GPIOD[14] */
	{(volatile unsigned long*)0xd401e1dc, 0x0001a040},/* GPIOD[15] */
	{(volatile unsigned long*)0xd401e1e0, 0x00018040},/* GPIOD[16] */
	{(volatile unsigned long*)0xd401e1e4, 0x00019042},/* SD_MMC1_CLK */
	{(volatile unsigned long*)0xd401e1e8, 0x00018042},/* SD_MMC1_CMD */
	{(volatile unsigned long*)0xd401e1ec, 0x0001a040},/* GPIOD[19] */
	{(volatile unsigned long*)0xd401e1f0, 0x0001a040},/* GPIOD[20] */
	{(volatile unsigned long*)0xd401e1f4, 0x0001a040},/* GPIOD[21] */
	{(volatile unsigned long*)0xd401e1f8, 0x00018042},/* SD_MMC1_DATA[0] */
	{(volatile unsigned long*)0xd401e1fc, 0x00018042},/* SD_MMC1_DATA[1] */
	{(volatile unsigned long*)0xd401e200, 0x00018042},/* SD_MMC1_DATA[2] */
	{(volatile unsigned long*)0xd401e204, 0x00018042},/* SD_MMC1_DATA[3] */
	{(volatile unsigned long*)0xd401e208, 0x0001a040},/* GPIOD[26] */
	{(volatile unsigned long*)0xd401e20c, 0x0001a040},/* GPIOD[27] */
	{(volatile unsigned long*)0xd401e210, 0x0001a040},/* GPIOD[28] */
	{(volatile unsigned long*)0xd401e214, 0x0001a040},/* GPIOD[29] */
	{(volatile unsigned long*)0xd401e218, 0x00019841},/* SD_MMC0_CLK */
	{(volatile unsigned long*)0xd401e21c, 0x00018041},/* SD_MMC0_CMD */
	{(volatile unsigned long*)0xd401e220, 0x00018041},/* SD_MMC0_DATA[0] */
	{(volatile unsigned long*)0xd401e224, 0x00018041},/* SD_MMC0_DATA[1] */
	{(volatile unsigned long*)0xd401e228, 0x00018041},/* SD_MMC0_DATA[2] */
	{(volatile unsigned long*)0xd401e22c, 0x00018041},/* SD_MMC0_DATA[3] */
	{(volatile unsigned long*)0xd401e230, 0x00018041},/* SD_MMC0_DATA[4] */
	{(volatile unsigned long*)0xd401e234, 0x00018041},/* SD_MMC0_DATA[5] */
	{(volatile unsigned long*)0xd401e238, 0x00018041},/* SD_MMC0_DATA[6] */
	{(volatile unsigned long*)0xd401e23c, 0x00018041},/* SD_MMC0_DATA[7] */
	{(volatile unsigned long*)0xd401e240, 0x00018040},/* GPIOE[8] */
	{(volatile unsigned long*)0xd401e244, 0x00018040},/* GPIOE[9] */
	{(volatile unsigned long*)0xd401e248, 0x00018040},/* GPIOE[10] */
	{(volatile unsigned long*)0xd401e24c, 0x00018040},/* GPIOE[11] */
	{(volatile unsigned long*)0xd401e250, 0x00019041},/* SD_MMC2_CLK */
	{(volatile unsigned long*)0xd401e254, 0x00018041},/* SD_MMC2_CMD */
	{(volatile unsigned long*)0xd401e258, 0x00018041},/* SD_MMC2_DATA[0] */
	{(volatile unsigned long*)0xd401e25c, 0x00018041},/* SD_MMC2_DATA[1] */
	{(volatile unsigned long*)0xd401e260, 0x00018041},/* SD_MMC2_DATA[2] */
	{(volatile unsigned long*)0xd401e264, 0x00018041},/* SD_MMC2_DATA[3] */
	{(volatile unsigned long*)0xd401e268, 0x0001c040},/* GPIOE[18] */
	{(volatile unsigned long*)0xd401e26c, 0x00018040},/* GPIOE[19] */
	{(volatile unsigned long*)0xd401e270, 0x0001c040},/* GPIOE[20] */
	{(volatile unsigned long*)0xd401e274, 0x00018040},/* GPIOE[21] */
	{(volatile unsigned long*)0xd401e278, 0x00018040},/* GPIOE[22] */
	{(volatile unsigned long*)0xd401e27c, 0x00018040},/* GPIOE[23] */
	{(volatile unsigned long*)0xd401e280, 0x0001c040},/* GPIOE[24] */
	{(volatile unsigned long*)0xd401e284, 0x0001c040},/* GPIOE[25] */
	{(volatile unsigned long*)0xd401e288, 0x00018040},/* GPIOE[26] */
	{(volatile unsigned long*)0xd401e28c, 0x00018040},/* GPIOE[27] */
	{(volatile unsigned long*)0xd401e290, 0x00018840},/* GPIOE[28] */
	{(volatile unsigned long*)0xd401e294, 0x0001a040},/* GPIOE[29] */
	{(volatile unsigned long*)0xd401e298, 0x0001a040},/* GPIOE[30] */
	{(volatile unsigned long*)0xd401e29c, 0x0001a040},/* GPIOE[31] */
	{(volatile unsigned long*)0xd401e2a0, 0x0001a040},/* GPIOF[0] */
	{(volatile unsigned long*)0xd401e33c, 0x0001a040},/* GPIOG[1] */
	{(volatile unsigned long*)0xd401e340, 0x0001a040},/* GPIOG[2] */
	{(volatile unsigned long*)0xd401e34c, 0x00019843},/* I2S_MCLK */
	{(volatile unsigned long*)0xd401e350, 0x0001a040},/* GPIOG[6] */
	{(volatile unsigned long*)0xd401e354, 0x00018040},/* GPIOG[7] */
	{(volatile unsigned long*)0xd401e35c, 0x0001a040},/* GPIOG[9] */
	{(volatile unsigned long*)0xd401e360, 0x0001c040},/* GPIOG[10] */
	{(volatile unsigned long*)0xd401e364, 0x0001c040},/* GPIOG[11] */
	{(volatile unsigned long*)0xd401e36c, 0x0001a040},/* GPIOG[13] */
	{(volatile unsigned long*)0xd401e3a0, 0x0001a040},/* GPIOG[26] */
	{(volatile unsigned long*)0xd401e3a4, 0x0001a040},/* GPIOG[27] */
	{(volatile unsigned long*)0xd401e3ac, 0x0001a040},/* GPIOG[29] */
	{(volatile unsigned long*)0xd401e3b4, 0x00019841},/* I2S_TXD */
	{(volatile unsigned long*)0xd401e3b8, 0x00019841},/* I2S_SCLK */
	{(volatile unsigned long*)0xd401e3bc, 0x00019841},/* I2S_WS */
	/* *********************************************************** */
	{(volatile unsigned long*)0xd401e110, 0x0001a843},/*UPC_PEN[0] */
	{(volatile unsigned long*)0xd401e114, 0x0001b043},/*UPC_PEN[1] */
	{(volatile unsigned long*)0xd401e118, 0x0001a843},/*UPC_PEN[2] */
	{(volatile unsigned long*)0xd401e11c, 0x0001a843},/*UPC_PEN[3] */
	{(volatile unsigned long*)0xd401e120, 0x0001a843},/*UPC_PEN[4] */
	{(volatile unsigned long*)0xd401e124, 0x0001a843},/*UPC_PEN[5] */
	{(volatile unsigned long*)0xd401e130, 0x0001a843},/*UPC_PEN[8] */
	{(volatile unsigned long*)0xd401e134, 0x0001a843},/*UPC_PEN[9] */
	{(volatile unsigned long*)0xd401e138, 0x0001a843},/*UPC_PEN[10]*/
	{(volatile unsigned long*)0xd401e144, 0x0001a843},/*UPC_PEN[13]*/
	{(volatile unsigned long*)0xd401e148, 0x0001a843},/*UPC_PEN[14]*/
	{(volatile unsigned long*)0xd401e14c, 0x0001a843},/*UPC_PEN[15]*/
	{(volatile unsigned long*)0xd401e158, 0x0001a843},/*UPC_PEN[18]*/
	{(volatile unsigned long*)0xd401e15c, 0x0001a843},/*UPC_PEN[19]*/
	{(volatile unsigned long*)0xd401e160, 0x0001a843},/*UPC_PEN[20]*/
	{(volatile unsigned long*)0xd401e168, 0x0001a843},/*UPC_PEN[22]*/
	{(volatile unsigned long*)0xd401e16c, 0x0001a843},/*UPC_PEN[23]*/
	{(volatile unsigned long*)0xd401e174, 0x0001a043},/*UPC_PEN[25]*/
	{(volatile unsigned long*)0xd401e17c, 0x0002b043},/*UPC_PEN[27]*/
	{(volatile unsigned long*)0xd401e180, 0x0002b043},/*UPC_PEN[28]*/
	{(volatile unsigned long*)0xd401e184, 0x0002b043},/*UPC_PEN[29]*/
	{(volatile unsigned long*)0xd401e188, 0x0002b043},/*UPC_PEN[30]*/
	{(volatile unsigned long*)0xd401e18c, 0x0002b043},/*UPC_PEN[31]*/
	/* *********************************************************** */
	{(volatile unsigned long*)0xffffffff, 0xffffffff},/* ANCHOR */
};/* iopad_reg_setting_array_s1v_mfp[] */

static const reg_setting_t iopad_reg_setting_array_s1v_sfp[] = {
	{(volatile unsigned long*)0xd401e000, 0x00018041},/* USB3X0_VB_nOC_1P8 */
	{(volatile unsigned long*)0xd401e004, 0x00018041},/* USB2X1_VB_nOC_1P8 */
	{(volatile unsigned long*)0xd401e008, 0x0001c040},/* GPIOA[2] */
	{(volatile unsigned long*)0xd401e00c, 0x00018041},/* USB2X1_nPWR_EN */
	{(volatile unsigned long*)0xd401e010, 0x00018041},/* USB2H2_nOC */
	{(volatile unsigned long*)0xd401e014, 0x00018041},/* USB2H2_nPWR_EN */
	{(volatile unsigned long*)0xd401e018, 0x00018041},/* SER1_RXD */
	{(volatile unsigned long*)0xd401e01c, 0x00018041},/* SER1_TXD */
	{(volatile unsigned long*)0xd401e020, 0x00018041},/* I2C1_SCLK */
	{(volatile unsigned long*)0xd401e024, 0x00018041},/* I2C1_SDA */
	{(volatile unsigned long*)0xd401e028, 0x00018042},/* SPi1_CLK */
	{(volatile unsigned long*)0xd401e02c, 0x00018042},/* SPi1_MOSI */
	{(volatile unsigned long*)0xd401e030, 0x00018042},/* SPi1_MISO */
	{(volatile unsigned long*)0xd401e034, 0x00018040},/* GPIOA[13] */
	{(volatile unsigned long*)0xd401e038, 0x0001a040},/* GPIOA[14] */
	{(volatile unsigned long*)0xd401e03c, 0x00018042},/* SPi1_nCS */
	{(volatile unsigned long*)0xd401e040, 0x00018042},/* I2C2_SDA */
	{(volatile unsigned long*)0xd401e044, 0x00018042},/* I2C2_SCLK */
	{(volatile unsigned long*)0xd401e048, 0x00018043},/* I2C5_SCLK */
	{(volatile unsigned long*)0xd401e04c, 0x00018043},/* I2C5_SDA */
	{(volatile unsigned long*)0xd401e050, 0x00018041},/* ENET_RX_CLK */
	{(volatile unsigned long*)0xd401e054, 0x00018041},/* ENET_RX_CTRL */
	{(volatile unsigned long*)0xd401e058, 0x00018041},/* ENET_RX_D0 */
	{(volatile unsigned long*)0xd401e05c, 0x00018041},/* ENET_RX_D1 */
	{(volatile unsigned long*)0xd401e060, 0x00018041},/* ENET_RX_D2 */
	{(volatile unsigned long*)0xd401e064, 0x00018041},/* ENET_RX_D3 */
	{(volatile unsigned long*)0xd401e068, 0x00018041},/* ENET_TX_D0 */
	{(volatile unsigned long*)0xd401e06c, 0x00018041},/* ENET_TX_D1 */
	{(volatile unsigned long*)0xd401e070, 0x00018041},/* ENET_TX_D2 */
	{(volatile unsigned long*)0xd401e074, 0x00018041},/* ENET_TX_D3 */
	{(volatile unsigned long*)0xd401e078, 0x00018041},/* ENET_TX_CTRL */
	{(volatile unsigned long*)0xd401e07c, 0x00018041},/* ENET_TX_CLK */
	{(volatile unsigned long*)0xd401e080, 0x00018041},/* ENET_MDC */
	{(volatile unsigned long*)0xd401e084, 0x00018041},/* ENET_MDIO */
	{(volatile unsigned long*)0xd401e088, 0x00018040},/* GPIOB[2] */
	{(volatile unsigned long*)0xd401e08c, 0x00018041},/* ENET_25MHz_CLK */
	{(volatile unsigned long*)0xd401e090, 0x00018847},/* SCCP2_D[0] */
	{(volatile unsigned long*)0xd401e094, 0x00018847},/* SCCP2_D[1] */
	{(volatile unsigned long*)0xd401e098, 0x00018847},/* SCCP2_D[2] */
	{(volatile unsigned long*)0xd401e09c, 0x00018847},/* SCCP2_D[3] */
	{(volatile unsigned long*)0xd401e0a0, 0x00018043},/* SER4_RXD */
	{(volatile unsigned long*)0xd401e0a4, 0x00018043},/* SER4_TXD */
	{(volatile unsigned long*)0xd401e0a8, 0x00018040},/* GPIOB[10] */
	{(volatile unsigned long*)0xd401e0ac, 0x00018040},/* GPIOB[11] */
	{(volatile unsigned long*)0xd401e0b0, 0x00018040},/* GPIOB[12] */
	{(volatile unsigned long*)0xd401e0b4, 0x00018040},/* GPIOB[13] */
	{(volatile unsigned long*)0xd401e0b8, 0x0001a040},/* GPIOB[14] */
	{(volatile unsigned long*)0xd401e0bc, 0x0001a040},/* GPIOB[15] */
	{(volatile unsigned long*)0xd401e0c0, 0x0001a040},/* GPIOB[16] */
	{(volatile unsigned long*)0xd401e0c4, 0x0001a040},/* GPIOB[17] */
	{(volatile unsigned long*)0xd401e0c8, 0x0001a040},/* GPIOB[18] */
	{(volatile unsigned long*)0xd401e0cc, 0x0001a040},/* GPIOB[19] */
	{(volatile unsigned long*)0xd401e0d0, 0x0001a040},/* GPIOB[20] */
	{(volatile unsigned long*)0xd401e0d4, 0x00018040},/* GPIOB[21] */
	{(volatile unsigned long*)0xd401e0d8, 0x0001a040},/* GPIOB[22] */
	{(volatile unsigned long*)0xd401e0dc, 0x00018040},/* GPIOB[23] */
	{(volatile unsigned long*)0xd401e0e0, 0x00018040},/* GPIOB[24] */
	{(volatile unsigned long*)0xd401e0e4, 0x00018040},/* DPWM[25] */
	{(volatile unsigned long*)0xd401e0e8, 0x00018040},/* DPWM[26] */
	{(volatile unsigned long*)0xd401e0ec, 0x0001a040},/* GPIOB[27] */
	{(volatile unsigned long*)0xd401e0f0, 0x0001a040},/* GPIOB[28] */
	{(volatile unsigned long*)0xd401e0f4, 0x0001a040},/* GPIOB[29] */
	{(volatile unsigned long*)0xd401e0f8, 0x0001a040},/* GPIOB[30] */
	{(volatile unsigned long*)0xd401e0fc, 0x0001a040},/* GPIOB[31] */
	{(volatile unsigned long*)0xd401e100, 0x0001a040},/* GPI_C[0] */
	{(volatile unsigned long*)0xd401e104, 0x0001a040},/* GPI_C[1] */
	{(volatile unsigned long*)0xd401e108, 0x0001a040},/* GPI_C[2] */
	{(volatile unsigned long*)0xd401e10c, 0x0001a040},/* GPI_C[3] */
	{(volatile unsigned long*)0xd401e128, 0x0001a040},/* GPIOC[10] */
	{(volatile unsigned long*)0xd401e12c, 0x0001a040},/* GPIOC[11] */
	{(volatile unsigned long*)0xd401e13c, 0x0001a040},/* GPIOC[15] */
	{(volatile unsigned long*)0xd401e140, 0x0001a040},/* GPIOC[16] */
	{(volatile unsigned long*)0xd401e150, 0x0001a040},/* GPIOC[20] */
	{(volatile unsigned long*)0xd401e154, 0x0001a040},/* GPIOC[21] */
	{(volatile unsigned long*)0xd401e164, 0x0001a040},/* GPIOC[25] */
	{(volatile unsigned long*)0xd401e170, 0x0001a040},/* GPIOC[28] */
	{(volatile unsigned long*)0xd401e178, 0x0001a040},/* GPIOC[30] */
	{(volatile unsigned long*)0xd401e190, 0x0001a040},/* GPIOD[4] */
	{(volatile unsigned long*)0xd401e194, 0x0001a040},/* GPIOD[5] */
	{(volatile unsigned long*)0xd401e198, 0x0001a040},/* GPIOD[6] */
	{(volatile unsigned long*)0xd401e19c, 0x0001a040},/* GPIOD[7] */
	{(volatile unsigned long*)0xd401e1d8, 0x00018040},/* GPIOD[14] */
	{(volatile unsigned long*)0xd401e1dc, 0x0001a040},/* GPIOD[15] */
	{(volatile unsigned long*)0xd401e1e0, 0x00018040},/* GPIOD[16] */
	{(volatile unsigned long*)0xd401e1e4, 0x00019042},/* SD_MMC1_CLK */
	{(volatile unsigned long*)0xd401e1e8, 0x00018042},/* SD_MMC1_CMD */
	{(volatile unsigned long*)0xd401e1ec, 0x0001a040},/* GPIOD[19] */
	{(volatile unsigned long*)0xd401e1f0, 0x0001a040},/* GPIOD[20] */
	{(volatile unsigned long*)0xd401e1f4, 0x0001a040},/* GPIOD[21] */
	{(volatile unsigned long*)0xd401e1f8, 0x00018042},/* SD_MMC1_DATA[0] */
	{(volatile unsigned long*)0xd401e1fc, 0x00018042},/* SD_MMC1_DATA[1] */
	{(volatile unsigned long*)0xd401e200, 0x00018042},/* SD_MMC1_DATA[2] */
	{(volatile unsigned long*)0xd401e204, 0x00018042},/* SD_MMC1_DATA[3] */
	{(volatile unsigned long*)0xd401e208, 0x0001a040},/* GPIOD[26] */
	{(volatile unsigned long*)0xd401e20c, 0x0001a040},/* GPIOD[27] */
	{(volatile unsigned long*)0xd401e210, 0x0001a040},/* GPIOD[28] */
	{(volatile unsigned long*)0xd401e214, 0x0001a040},/* GPIOD[29] */
	{(volatile unsigned long*)0xd401e218, 0x00019841},/* SD_MMC0_CLK */
	{(volatile unsigned long*)0xd401e21c, 0x00018041},/* SD_MMC0_CMD */
	{(volatile unsigned long*)0xd401e220, 0x00018041},/* SD_MMC0_DATA[0] */
	{(volatile unsigned long*)0xd401e224, 0x00018041},/* SD_MMC0_DATA[1] */
	{(volatile unsigned long*)0xd401e228, 0x00018041},/* SD_MMC0_DATA[2] */
	{(volatile unsigned long*)0xd401e22c, 0x00018041},/* SD_MMC0_DATA[3] */
	{(volatile unsigned long*)0xd401e230, 0x00018041},/* SD_MMC0_DATA[4] */
	{(volatile unsigned long*)0xd401e234, 0x00018041},/* SD_MMC0_DATA[5] */
	{(volatile unsigned long*)0xd401e238, 0x00018041},/* SD_MMC0_DATA[6] */
	{(volatile unsigned long*)0xd401e23c, 0x00018041},/* SD_MMC0_DATA[7] */
	{(volatile unsigned long*)0xd401e240, 0x00018040},/* GPIOE[8] */
	{(volatile unsigned long*)0xd401e244, 0x00018040},/* GPIOE[9] */
	{(volatile unsigned long*)0xd401e248, 0x00018040},/* GPIOE[10] */
	{(volatile unsigned long*)0xd401e24c, 0x00018040},/* GPIOE[11] */
	{(volatile unsigned long*)0xd401e250, 0x00019041},/* SD_MMC2_CLK */
	{(volatile unsigned long*)0xd401e254, 0x00018041},/* SD_MMC2_CMD */
	{(volatile unsigned long*)0xd401e258, 0x00018041},/* SD_MMC2_DATA[0] */
	{(volatile unsigned long*)0xd401e25c, 0x00018041},/* SD_MMC2_DATA[1] */
	{(volatile unsigned long*)0xd401e260, 0x00018041},/* SD_MMC2_DATA[2] */
	{(volatile unsigned long*)0xd401e264, 0x00018041},/* SD_MMC2_DATA[3] */
	{(volatile unsigned long*)0xd401e268, 0x0001c040},/* GPIOE[18] */
	{(volatile unsigned long*)0xd401e26c, 0x00018040},/* GPIOE[19] */
	{(volatile unsigned long*)0xd401e270, 0x0001c040},/* GPIOE[20] */
	{(volatile unsigned long*)0xd401e274, 0x00018040},/* GPIOE[21] */
	{(volatile unsigned long*)0xd401e278, 0x00018040},/* GPIOE[22] */
	{(volatile unsigned long*)0xd401e27c, 0x00018040},/* GPIOE[23] */
	{(volatile unsigned long*)0xd401e280, 0x0001c040},/* GPIOE[24] */
	{(volatile unsigned long*)0xd401e284, 0x0001c040},/* GPIOE[25] */
	{(volatile unsigned long*)0xd401e288, 0x00018043},/* SER3_TXD */
	{(volatile unsigned long*)0xd401e28c, 0x00018043},/* SER3_RXD */
	{(volatile unsigned long*)0xd401e290, 0x00018840},/* GPIOE[28] */
	{(volatile unsigned long*)0xd401e294, 0x0001a040},/* GPIOE[29] */
	{(volatile unsigned long*)0xd401e298, 0x0001a040},/* GPIOE[30] */
	{(volatile unsigned long*)0xd401e29c, 0x0001a040},/* GPIOE[31] */
	{(volatile unsigned long*)0xd401e2a0, 0x0001a040},/* GPIOF[0] */
	{(volatile unsigned long*)0xd401e33c, 0x0001a040},/* GPIOG[1] */
	{(volatile unsigned long*)0xd401e340, 0x0001a040},/* GPIOG[2] */
	{(volatile unsigned long*)0xd401e34c, 0x00019843},/* I2S_MCLK */
	{(volatile unsigned long*)0xd401e350, 0x0001a040},/* GPIOG[6] */
	{(volatile unsigned long*)0xd401e354, 0x00018040},/* GPIOG[7] */
	{(volatile unsigned long*)0xd401e35c, 0x0001a040},/* GPIOG[9] */
	{(volatile unsigned long*)0xd401e360, 0x0001c040},/* GPIOG[10] */
	{(volatile unsigned long*)0xd401e364, 0x0001c040},/* GPIOG[11] */
	{(volatile unsigned long*)0xd401e36c, 0x0001a040},/* GPIOG[13] */
	{(volatile unsigned long*)0xd401e3a0, 0x0001a040},/* GPIOG[26] */
	{(volatile unsigned long*)0xd401e3a4, 0x0001a040},/* GPIOG[27] */
	{(volatile unsigned long*)0xd401e3ac, 0x0001a040},/* GPIOG[29] */
	{(volatile unsigned long*)0xd401e3b4, 0x00019841},/* I2S_TXD */
	{(volatile unsigned long*)0xd401e3b8, 0x00019841},/* I2S_SCLK */
	{(volatile unsigned long*)0xd401e3bc, 0x00019841},/* I2S_WS */
	/* *********************************************************** */
	{(volatile unsigned long*)0xd401e110, 0x0001a843},/*UPC_PEN[0] */
	{(volatile unsigned long*)0xd401e114, 0x0001b043},/*UPC_PEN[1] */
	{(volatile unsigned long*)0xd401e118, 0x0001a843},/*UPC_PEN[2] */
	{(volatile unsigned long*)0xd401e11c, 0x0001a843},/*UPC_PEN[3] */
	{(volatile unsigned long*)0xd401e120, 0x0001a843},/*UPC_PEN[4] */
	{(volatile unsigned long*)0xd401e124, 0x0001a843},/*UPC_PEN[5] */
	{(volatile unsigned long*)0xd401e130, 0x0001a843},/*UPC_PEN[8] */
	{(volatile unsigned long*)0xd401e134, 0x0001a843},/*UPC_PEN[9] */
	{(volatile unsigned long*)0xd401e138, 0x0001a843},/*UPC_PEN[10]*/
	{(volatile unsigned long*)0xd401e144, 0x0001a843},/*UPC_PEN[13]*/
	{(volatile unsigned long*)0xd401e148, 0x0001a843},/*UPC_PEN[14]*/
	{(volatile unsigned long*)0xd401e14c, 0x0001a843},/*UPC_PEN[15]*/
	{(volatile unsigned long*)0xd401e158, 0x0001a843},/*UPC_PEN[18]*/
	{(volatile unsigned long*)0xd401e15c, 0x0001a843},/*UPC_PEN[19]*/
	{(volatile unsigned long*)0xd401e160, 0x0001a843},/*UPC_PEN[20]*/
	{(volatile unsigned long*)0xd401e168, 0x0001a843},/*UPC_PEN[22]*/
	{(volatile unsigned long*)0xd401e16c, 0x0001a843},/*UPC_PEN[23]*/
	{(volatile unsigned long*)0xd401e174, 0x0001b043},/*UPC_PEN[25]*/
	{(volatile unsigned long*)0xd401e17c, 0x0002b043},/*UPC_PEN[27]*/
	{(volatile unsigned long*)0xd401e180, 0x0002b043},/*UPC_PEN[28]*/
	{(volatile unsigned long*)0xd401e184, 0x0002b043},/*UPC_PEN[29]*/
	{(volatile unsigned long*)0xd401e188, 0x0002b043},/*UPC_PEN[30]*/
	{(volatile unsigned long*)0xd401e18c, 0x0002b043},/*UPC_PEN[31]*/
	/* *********************************************************** */
	{(volatile unsigned long*)0xffffffff, 0xffffffff},/* ANCHOR */
};/* iopad_reg_setting_array_s1v_sfp[] */

static const reg_setting_t iopad_reg_setting_array_sh1c_mfp[] = {
	{(volatile unsigned long*)0xd401e000, 0x00018041},/* USB3X0_VB_nOC_1P8 */
	{(volatile unsigned long*)0xd401e004, 0x00018041},/* USB2X1_VB_nOC_1P8 */
	{(volatile unsigned long*)0xd401e008, 0x0001c040},/* GPIOA[2] */
	{(volatile unsigned long*)0xd401e00c, 0x00018041},/* USB2X1_nPWR_EN */
	{(volatile unsigned long*)0xd401e010, 0x00018041},/* USB2H2_nOC */
	{(volatile unsigned long*)0xd401e014, 0x00018041},/* USB2H2_nPWR_EN */
	{(volatile unsigned long*)0xd401e018, 0x00018041},/* SER1_RXD */
	{(volatile unsigned long*)0xd401e01c, 0x00018041},/* SER1_TXD */
	{(volatile unsigned long*)0xd401e020, 0x00018041},/* I2C1_SCLK */
	{(volatile unsigned long*)0xd401e024, 0x00018041},/* I2C1_SDA */
	{(volatile unsigned long*)0xd401e028, 0x00018042},/* SPi1_CLK */
	{(volatile unsigned long*)0xd401e02c, 0x00018042},/* SPi1_MOSI */
	{(volatile unsigned long*)0xd401e030, 0x00018042},/* SPi1_MISO */
	{(volatile unsigned long*)0xd401e034, 0x00018040},/* GPIOA[13] */
	{(volatile unsigned long*)0xd401e038, 0x00018040},/* GPIOA[14] */
	{(volatile unsigned long*)0xd401e03c, 0x00018042},/* SPi1_nCS */
	{(volatile unsigned long*)0xd401e040, 0x00018042},/* I2C2_SDA */
	{(volatile unsigned long*)0xd401e044, 0x00018042},/* I2C2_SCLK */
	{(volatile unsigned long*)0xd401e048, 0x00018040},/* SATA_ST_ACTIVE_LED or GPIOA[18] */
	{(volatile unsigned long*)0xd401e04c, 0x00018040},/* SATA_PHY_READY_LED or GPIOA[19] */
	{(volatile unsigned long*)0xd401e050, 0x00018041},/* ENET_RX_CLK */
	{(volatile unsigned long*)0xd401e054, 0x00018041},/* ENET_RX_CTRL */
	{(volatile unsigned long*)0xd401e058, 0x00018041},/* ENET_RX_D0 */
	{(volatile unsigned long*)0xd401e05c, 0x00018041},/* ENET_RX_D1 */
	{(volatile unsigned long*)0xd401e060, 0x00018041},/* ENET_RX_D2 */
	{(volatile unsigned long*)0xd401e064, 0x00018041},/* ENET_RX_D3 */
	{(volatile unsigned long*)0xd401e068, 0x00018041},/* ENET_TX_D0 */
	{(volatile unsigned long*)0xd401e06c, 0x00018041},/* ENET_TX_D1 */
	{(volatile unsigned long*)0xd401e070, 0x00018041},/* ENET_TX_D2 */
	{(volatile unsigned long*)0xd401e074, 0x00018041},/* ENET_TX_D3 */
	{(volatile unsigned long*)0xd401e078, 0x00018041},/* ENET_TX_CTRL */
	{(volatile unsigned long*)0xd401e07c, 0x00018041},/* ENET_TX_CLK */
	{(volatile unsigned long*)0xd401e080, 0x00018041},/* ENET_MDC */
	{(volatile unsigned long*)0xd401e084, 0x00018041},/* ENET_MDIO */
	{(volatile unsigned long*)0xd401e08c, 0x00018041},/* ENET_25MHz_CLK */
	{(volatile unsigned long*)0xd401e090, 0x0001a047},/* SCCP2_D[0] */
	{(volatile unsigned long*)0xd401e094, 0x0001a047},/* SCCP2_D[1] */
	{(volatile unsigned long*)0xd401e098, 0x0001a047},/* SCCP2_D[2] */
	{(volatile unsigned long*)0xd401e09c, 0x0001a847},/* SCCP2_D[3] */
	{(volatile unsigned long*)0xd401e0ec, 0x0002a040},/* OROCHI_PFGATE0_N */
	{(volatile unsigned long*)0xd401e110, 0x0001a843},/* UPC_PEN[0] */
	{(volatile unsigned long*)0xd401e120, 0x0001b043},/* UPC_PEN[4] */
	{(volatile unsigned long*)0xd401e128, 0x0001b043},/* UPC_PEN[6] */
	{(volatile unsigned long*)0xd401e130, 0x0001a843},/* UPC_PEN[8] */
	{(volatile unsigned long*)0xd401e134, 0x0001a843},/* UPC_PEN[9] */
	{(volatile unsigned long*)0xd401e138, 0x0001a843},/* UPC_PEN[10] */
	{(volatile unsigned long*)0xd401e144, 0x0001a843},/* UPC_PEN[13] */
	{(volatile unsigned long*)0xd401e148, 0x0001a843},/* UPC_PEN[14] */
	{(volatile unsigned long*)0xd401e14c, 0x0001a843},/* UPC_PEN[15] */
	{(volatile unsigned long*)0xd401e158, 0x0001a843},/* UPC_PEN[18] */
	{(volatile unsigned long*)0xd401e15c, 0x0001a843},/* UPC_PEN[19] */
	{(volatile unsigned long*)0xd401e16c, 0x0002b043},/* UPC_PEN[23] */
	{(volatile unsigned long*)0xd401e170, 0x0001b046},/* SCCP1_D[5] */
	{(volatile unsigned long*)0xd401e174, 0x0001b046},/* SCCP1_D[6] */
	{(volatile unsigned long*)0xd401e178, 0x0001b046},/* SCCP1_D[7] */
	{(volatile unsigned long*)0xd401e17c, 0x0001b046},/* SCCP1_D[8] */
	{(volatile unsigned long*)0xd401e180, 0x0002b043},/* UPC_PEN[28] */
	{(volatile unsigned long*)0xd401e184, 0x00029044},/* SPi3_CLK */
	{(volatile unsigned long*)0xd401e188, 0x0002b044},/* SPi3_nCS */
	{(volatile unsigned long*)0xd401e18c, 0x00029044},/* SPi3_MOSI */
	{(volatile unsigned long*)0xd401e190, 0x0001a044},/* SPi3_MISO */
	{(volatile unsigned long*)0xd401e1b4, 0x0001a040},/* GPIOD[13] */
	{(volatile unsigned long*)0xd401e1d8, 0x00018040},/* GPIOD[14] */
	{(volatile unsigned long*)0xd401e1e0, 0x00018040},/* GPIOD[16] */
	{(volatile unsigned long*)0xd401e1e4, 0x00019042},/* SD_MMC1_CLK */
	{(volatile unsigned long*)0xd401e1e8, 0x00018042},/* SD_MMC1_CMD */
	{(volatile unsigned long*)0xd401e1f8, 0x00018042},/* SD_MMC1_DATA[0] */
	{(volatile unsigned long*)0xd401e1fc, 0x00018042},/* SD_MMC1_DATA[1] */
	{(volatile unsigned long*)0xd401e200, 0x00018042},/* SD_MMC1_DATA[2] */
	{(volatile unsigned long*)0xd401e204, 0x00018042},/* SD_MMC1_DATA[3] */
	{(volatile unsigned long*)0xd401e218, 0x00019841},/* SD_MMC0_CLK */
	{(volatile unsigned long*)0xd401e21c, 0x00018041},/* SD_MMC0_CMD */
	{(volatile unsigned long*)0xd401e220, 0x00018041},/* SD_MMC0_DATA[0] */
	{(volatile unsigned long*)0xd401e224, 0x00018041},/* SD_MMC0_DATA[1] */
	{(volatile unsigned long*)0xd401e228, 0x00018041},/* SD_MMC0_DATA[2] */
	{(volatile unsigned long*)0xd401e22c, 0x00018041},/* SD_MMC0_DATA[3] */
	{(volatile unsigned long*)0xd401e230, 0x00018041},/* SD_MMC0_DATA[4] */
	{(volatile unsigned long*)0xd401e234, 0x00018041},/* SD_MMC0_DATA[5] */
	{(volatile unsigned long*)0xd401e238, 0x00018041},/* SD_MMC0_DATA[6] */
	{(volatile unsigned long*)0xd401e23c, 0x00018041},/* SD_MMC0_DATA[7] */
	{(volatile unsigned long*)0xd401e240, 0x00018040},/* GPIOE[8] */
	{(volatile unsigned long*)0xd401e244, 0x00018040},/* GPIOE[9] */
	{(volatile unsigned long*)0xd401e248, 0x00018040},/* GPIOE[10] */
	{(volatile unsigned long*)0xd401e24c, 0x00018040},/* GPIOE[11] */
	{(volatile unsigned long*)0xd401e250, 0x00019041},/* SD_MMC2_CLK */
	{(volatile unsigned long*)0xd401e254, 0x00018041},/* SD_MMC2_CMD */
	{(volatile unsigned long*)0xd401e258, 0x00018041},/* SD_MMC2_DATA[0] */
	{(volatile unsigned long*)0xd401e25c, 0x00018041},/* SD_MMC2_DATA[1] */
	{(volatile unsigned long*)0xd401e260, 0x00018041},/* SD_MMC2_DATA[2] */
	{(volatile unsigned long*)0xd401e264, 0x00018041},/* SD_MMC2_DATA[3] */
	{(volatile unsigned long*)0xd401e268, 0x0001c040},/* GPIOE[18] */
	{(volatile unsigned long*)0xd401e26c, 0x00018040},/* GPIOE[19] */
	{(volatile unsigned long*)0xd401e270, 0x0001c040},/* GPIOE[20] */
	{(volatile unsigned long*)0xd401e274, 0x00018040},/* GPIOE[21] */
	{(volatile unsigned long*)0xd401e278, 0x00018040},/* GPIOE[22] */
	{(volatile unsigned long*)0xd401e27c, 0x00018040},/* GPIOE[23] */
	{(volatile unsigned long*)0xd401e280, 0x0001c040},/* GPIOE[24] */
	{(volatile unsigned long*)0xd401e284, 0x0001c040},/* GPIOE[25] */
	{(volatile unsigned long*)0xd401e288, 0x00018040},/* GPIOE[26] */
	{(volatile unsigned long*)0xd401e28c, 0x00018040},/* GPIOE[27] */
	{(volatile unsigned long*)0xd401e290, 0x00019840},/* GPIOE[28] */
	{(volatile unsigned long*)0xd401e294, 0x0001c040},/* GPIOE[29] */
	{(volatile unsigned long*)0xd401e298, 0x0013c040},/* GPIOE[30] */
	{(volatile unsigned long*)0xd401e29c, 0x0001c040},/* GPIOE[31] */
	{(volatile unsigned long*)0xd401e2a4, 0x00019040},/* GPIOF[1] */
	{(volatile unsigned long*)0xd401e34c, 0x0001d840},/* GPIOG[5] */
	{(volatile unsigned long*)0xd401e354, 0x00018040},/* GPIOG[7] */
	{(volatile unsigned long*)0xd401e360, 0x0001c040},/* GPIOG[10] */
	{(volatile unsigned long*)0xd401e364, 0x0001c040},/* GPIOG[11] */
	{(volatile unsigned long*)0xd401e3b8, 0x0001b840},/* GPIOH[0] */
	{(volatile unsigned long*)0xd401e3bc, 0x0001d840},/* GPIOH[1] */
	/* *********************************************************** */
	{(volatile unsigned long*)0xffffffff, 0xffffffff},/* ANCHOR */
};/* iopad_reg_setting_array_sh1c_mfp[] */

static const reg_setting_t iopad_reg_setting_array_sh1v_mfp[] = {
	/* ******************************************************************* */
	{(volatile unsigned long*)0xd401e000, 0x00018041},/* USB3X0_VB_nOC_1P8 */
	{(volatile unsigned long*)0xd401e004, 0x00018041},/* USB2X1_VB_nOC_1P8 */
	{(volatile unsigned long*)0xd401e008, 0x0001c040},/* GPIOA[2]          */
	{(volatile unsigned long*)0xd401e00c, 0x00018041},/* USB2X1_nPWR_EN    */
	{(volatile unsigned long*)0xd401e010, 0x00018041},/* USB2H2_nOC        */
	{(volatile unsigned long*)0xd401e014, 0x00018041},/* USB2H2_nPWR_EN    */
	{(volatile unsigned long*)0xd401e018, 0x00018041},/* SER1_RXD          */
	{(volatile unsigned long*)0xd401e01c, 0x00018041},/* SER1_TXD          */
	{(volatile unsigned long*)0xd401e020, 0x00018041},/* I2C1_SCLK         */
	{(volatile unsigned long*)0xd401e024, 0x00018041},/* I2C1_SDA          */
	{(volatile unsigned long*)0xd401e028, 0x00018042},/* SPi1_CLK          */
	{(volatile unsigned long*)0xd401e02c, 0x00018042},/* SPi1_MOSI         */
	{(volatile unsigned long*)0xd401e030, 0x00018042},/* SPi1_MISO         */
	{(volatile unsigned long*)0xd401e034, 0x00018040},/* GPIOA[13]         */
	{(volatile unsigned long*)0xd401e03c, 0x00018042},/* SPi1_nCS          */
	{(volatile unsigned long*)0xd401e040, 0x00018042},/* I2C2_SDA          */
	{(volatile unsigned long*)0xd401e044, 0x00018042},/* I2C2_SCLK         */
	{(volatile unsigned long*)0xd401e048, 0x001f8040},/* GPIOA[18]         */
	{(volatile unsigned long*)0xd401e04c, 0x00018040},/* GPIOA[19]         */
	{(volatile unsigned long*)0xd401e050, 0x00018041},/* ENET_RX_CLK       */
	{(volatile unsigned long*)0xd401e054, 0x00018041},/* ENET_RX_CTRL      */
	{(volatile unsigned long*)0xd401e058, 0x00018041},/* ENET_RX_D0        */
	{(volatile unsigned long*)0xd401e05c, 0x00018041},/* ENET_RX_D1        */
	{(volatile unsigned long*)0xd401e060, 0x00018041},/* ENET_RX_D2        */
	{(volatile unsigned long*)0xd401e064, 0x00018041},/* ENET_RX_D3        */
	{(volatile unsigned long*)0xd401e068, 0x00018041},/* ENET_TX_D0        */
	{(volatile unsigned long*)0xd401e06c, 0x00018041},/* ENET_TX_D1        */
	{(volatile unsigned long*)0xd401e070, 0x00018041},/* ENET_TX_D2        */
	{(volatile unsigned long*)0xd401e074, 0x00018041},/* ENET_TX_D3        */
	{(volatile unsigned long*)0xd401e078, 0x00018041},/* ENET_TX_CTRL      */
	{(volatile unsigned long*)0xd401e07c, 0x00018041},/* ENET_TX_CLK       */
	{(volatile unsigned long*)0xd401e080, 0x00018041},/* ENET_MDC          */
	{(volatile unsigned long*)0xd401e084, 0x00018041},/* ENET_MDIO         */
	{(volatile unsigned long*)0xd401e088, 0x00018040},/* GPIOB[2]          */
	{(volatile unsigned long*)0xd401e08c, 0x00018041},/* ENET_25MHz_CLK    */
	{(volatile unsigned long*)0xd401e0a0, 0x00018043},/* SER4_RXD          */
	{(volatile unsigned long*)0xd401e0a4, 0x00018043},/* SER4_TXD          */
	{(volatile unsigned long*)0xd401e0a8, 0x00018040},/* GPIOB[10]         */
	{(volatile unsigned long*)0xd401e0ac, 0x00018040},/* GPIOB[11]         */
	{(volatile unsigned long*)0xd401e0b0, 0x00018040},/* GPIOB[12]         */
	{(volatile unsigned long*)0xd401e0b4, 0x00018040},/* GPIOB[13]         */
	{(volatile unsigned long*)0xd401e0b8, 0x0001a040},/* GPIOB[14]         */
	{(volatile unsigned long*)0xd401e0bc, 0x0001a040},/* GPIOB[15]         */
	{(volatile unsigned long*)0xd401e0c0, 0x0001a040},/* GPIOB[16]         */
	{(volatile unsigned long*)0xd401e0c4, 0x0001a040},/* GPIOB[17]         */
	{(volatile unsigned long*)0xd401e0c8, 0x0013a040},/* GPIOB[18]         */
	{(volatile unsigned long*)0xd401e0cc, 0x0013a040},/* GPIOB[19]         */
	{(volatile unsigned long*)0xd401e0d0, 0x0001a040},/* GPIOB[20]         */
	{(volatile unsigned long*)0xd401e0d4, 0x00018040},/* GPIOB[21]         */
	{(volatile unsigned long*)0xd401e0d8, 0x0001a040},/* GPIOB[22]         */
	{(volatile unsigned long*)0xd401e0dc, 0x00018040},/* GPIOB[23]         */
	{(volatile unsigned long*)0xd401e0e0, 0x00018040},/* GPIOB[24]         */
	{(volatile unsigned long*)0xd401e0e4, 0x00018040},/* GPIOB[25]         */
	{(volatile unsigned long*)0xd401e0e8, 0x00018040},/* GPIOB[26]         */
	{(volatile unsigned long*)0xd401e0ec, 0x0001a040},/* GPIOB[27]         */
	{(volatile unsigned long*)0xd401e0f0, 0x0001a040},/* GPIOB[28]         */
	{(volatile unsigned long*)0xd401e0f4, 0x0001a040},/* GPIOB[29]         */
	{(volatile unsigned long*)0xd401e0f8, 0x0001a040},/* GPIOB[30]         */
	{(volatile unsigned long*)0xd401e110, 0x0001a043},/* UPC_PEN[0]        */
	{(volatile unsigned long*)0xd401e114, 0x0001b043},/* UPC_PEN[1]        */
	{(volatile unsigned long*)0xd401e118, 0x0001a043},/* UPC_PEN[2]        */
	{(volatile unsigned long*)0xd401e11c, 0x0001a043},/* UPC_PEN[3]        */
	{(volatile unsigned long*)0xd401e120, 0x0001a043},/* UPC_PEN[4]        */
	{(volatile unsigned long*)0xd401e124, 0x0001a043},/* UPC_PEN[5]        */
	{(volatile unsigned long*)0xd401e130, 0x0001a043},/* UPC_PEN[8]        */
	{(volatile unsigned long*)0xd401e134, 0x0001a043},/* UPC_PEN[9]        */
	{(volatile unsigned long*)0xd401e138, 0x0001a043},/* UPC_PEN[10]       */
	{(volatile unsigned long*)0xd401e144, 0x0001a043},/* UPC_PEN[13]       */
	{(volatile unsigned long*)0xd401e148, 0x0001a043},/* UPC_PEN[14]       */
	{(volatile unsigned long*)0xd401e14c, 0x0001a043},/* UPC_PEN[15]       */
	{(volatile unsigned long*)0xd401e158, 0x0001a043},/* UPC_PEN[18]       */
	{(volatile unsigned long*)0xd401e15c, 0x0001a043},/* UPC_PEN[19]       */
	{(volatile unsigned long*)0xd401e160, 0x0001a043},/* UPC_PEN[20]       */
	{(volatile unsigned long*)0xd401e168, 0x0001a043},/* UPC_PEN[22]       */
	{(volatile unsigned long*)0xd401e16c, 0x0001a043},/* UPC_PEN[23]       */
	{(volatile unsigned long*)0xd401e174, 0x0001a843},/* UPC_PEN[25]       */
	{(volatile unsigned long*)0xd401e17c, 0x0002b043},/* UPC_PEN[27]       */
	{(volatile unsigned long*)0xd401e180, 0x0002b043},/* UPC_PEN[28]       */
	{(volatile unsigned long*)0xd401e184, 0x0002b043},/* UPC_PEN[29]       */
	{(volatile unsigned long*)0xd401e188, 0x0002b043},/* UPC_PEN[30]       */
	{(volatile unsigned long*)0xd401e18c, 0x0002b043},/* UPC_PEN[31]       */
	{(volatile unsigned long*)0xd401e1e4, 0x00019042},/* SD_MMC1_CLK       */
	{(volatile unsigned long*)0xd401e1e8, 0x00018042},/* SD_MMC1_CMD       */
	{(volatile unsigned long*)0xd401e1f8, 0x00018042},/* SD_MMC1_DATA[0]   */
	{(volatile unsigned long*)0xd401e1fc, 0x00018042},/* SD_MMC1_DATA[1]   */
	{(volatile unsigned long*)0xd401e200, 0x00018042},/* SD_MMC1_DATA[2]   */
	{(volatile unsigned long*)0xd401e204, 0x00018042},/* SD_MMC1_DATA[3]   */
	{(volatile unsigned long*)0xd401e218, 0x00019841},/* SD_MMC0_CLK       */
	{(volatile unsigned long*)0xd401e21c, 0x00018041},/* SD_MMC0_CMD       */
	{(volatile unsigned long*)0xd401e220, 0x00018041},/* SD_MMC0_DATA[0]   */
	{(volatile unsigned long*)0xd401e224, 0x00018041},/* SD_MMC0_DATA[1]   */
	{(volatile unsigned long*)0xd401e228, 0x00018041},/* SD_MMC0_DATA[2]   */
	{(volatile unsigned long*)0xd401e22c, 0x00018041},/* SD_MMC0_DATA[3]   */
	{(volatile unsigned long*)0xd401e230, 0x00018041},/* SD_MMC0_DATA[4]   */
	{(volatile unsigned long*)0xd401e234, 0x00018041},/* SD_MMC0_DATA[5]   */
	{(volatile unsigned long*)0xd401e238, 0x00018041},/* SD_MMC0_DATA[6]   */
	{(volatile unsigned long*)0xd401e23c, 0x00018041},/* SD_MMC0_DATA[7]   */
	{(volatile unsigned long*)0xd401e240, 0x00018040},/* GPIOE[8]          */
	{(volatile unsigned long*)0xd401e244, 0x00018040},/* GPIOE[9]          */
	{(volatile unsigned long*)0xd401e248, 0x00018040},/* GPIOE[10]         */
	{(volatile unsigned long*)0xd401e24c, 0x00018040},/* GPIOE[11]         */
	{(volatile unsigned long*)0xd401e250, 0x00019841},/* SD_MMC2_CLK       */
	{(volatile unsigned long*)0xd401e254, 0x00018041},/* SD_MMC2_CMD       */
	{(volatile unsigned long*)0xd401e258, 0x00018041},/* SD_MMC2_DATA[0]   */
	{(volatile unsigned long*)0xd401e25c, 0x00018041},/* SD_MMC2_DATA[1]   */
	{(volatile unsigned long*)0xd401e260, 0x00018041},/* SD_MMC2_DATA[2]   */
	{(volatile unsigned long*)0xd401e264, 0x00018041},/* SD_MMC2_DATA[3]   */
	{(volatile unsigned long*)0xd401e268, 0x0001c040},/* GPIOE[18]         */
	{(volatile unsigned long*)0xd401e26c, 0x00018040},/* GPIOE[19]         */
	{(volatile unsigned long*)0xd401e270, 0x0001c040},/* GPIOE[20]         */
	{(volatile unsigned long*)0xd401e274, 0x00018040},/* GPIOE[21]         */
	{(volatile unsigned long*)0xd401e278, 0x00018040},/* GPIOE[22]         */
	{(volatile unsigned long*)0xd401e27c, 0x00018040},/* GPIOE[23]         */
	{(volatile unsigned long*)0xd401e280, 0x0001c040},/* GPIOE[24]         */
	{(volatile unsigned long*)0xd401e284, 0x0001c040},/* GPIOE[25]         */
	{(volatile unsigned long*)0xd401e288, 0x00018040},/* GPIOE[26]         */
	{(volatile unsigned long*)0xd401e28c, 0x00018040},/* GPIOE[27]         */
	{(volatile unsigned long*)0xd401e290, 0x00019840},/* GPIOE[28]         */
	{(volatile unsigned long*)0xd401e294, 0x0001c040},/* GPIOE[29]         */
	{(volatile unsigned long*)0xd401e298, 0x0001c040},/* GPIOE[30]         */
	{(volatile unsigned long*)0xd401e29c, 0x0001c040},/* GPIOE[31]         */
	{(volatile unsigned long*)0xd401e34c, 0x00019840},/* GPIOG[5]          */
	{(volatile unsigned long*)0xd401e3b4, 0x00019841},/* I2S_TXD           */
	{(volatile unsigned long*)0xd401e3b8, 0x0001d840},/* GPIOH[0]          */
	{(volatile unsigned long*)0xd401e3bc, 0x0001d840},/* GPIOH[1]          */
	/* ******************************************************************* */
	{(volatile unsigned long*)0xffffffff, 0xffffffff},/* ANCHOR            */
};/* iopad_reg_setting_array_sh1v_mfp[] */

static const gpio_setting_t gpio_reg_setting_array_s1c_mfp[GPIO_GROUP_NUM] = {
	{/* GPIO-A */
		{(volatile unsigned long *)0xd4019008, 0x00002004},/* set */
		{(volatile unsigned long *)0xd401900c, 0x00004000},/* clear */
		{(volatile unsigned long *)0xd4019004, 0x00006004},/* dir */
	},
	{/* GPIO-B */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	},
	{/* GPIO-D */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	},
	{/* GPIO-E */
		{(volatile unsigned long *)0xd4019408, 0x15380000},/* set */
		{(volatile unsigned long *)0xd401940c, 0x00440000},/* clear */
		{(volatile unsigned long *)0xd4019404, 0x157C0000},/* dir */
	},
	{/* GPIO-G */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	},
	{/* GPIO-H */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	}
};

static const gpio_setting_t gpio_reg_setting_array_s1c_sfp[GPIO_GROUP_NUM] = {
	{/* GPIO-A */
		{(volatile unsigned long *)0xd4019008, 0x00002004},/* set */
		{(volatile unsigned long *)0xd401900c, 0x00004000},/* clear */
		{(volatile unsigned long *)0xd4019004, 0x00006004},/* dir */
	},
	{/* GPIO-B */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	},
	{/* GPIO-D */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	},
	{/* GPIO-E */
		{(volatile unsigned long *)0xd4019408, 0x01380000},/* set */
		{(volatile unsigned long *)0xd401940c, 0x00440000},/* clear */
		{(volatile unsigned long *)0xd4019404, 0x017C0000},/* dir */
	},
	{/* GPIO-G */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	},
	{/* GPIO-H */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	}
};

static const gpio_setting_t gpio_reg_setting_array_s1v_mfp[GPIO_GROUP_NUM] = {
	{/* GPIO-A */
		{(volatile unsigned long *)0xd4019008, 0x00002004},/* set */
		{(volatile unsigned long *)0xd401900c, 0x00000000},/* clear */
		{(volatile unsigned long *)0xd4019004, 0x00002004},/* dir */
	},
	{/* GPIO-B */
		{(volatile unsigned long *)0xd4019108, 0x0e800000},/* set */
		{(volatile unsigned long *)0xd401910c, 0x00003404},/* clear */
		{(volatile unsigned long *)0xd4019104, 0x0e803404},/* dir */
	},
	{/* GPIO-D */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	},
	{/* GPIO-E */
		{(volatile unsigned long *)0xd4019408, 0x15380000},/* set */
		{(volatile unsigned long *)0xd401940c, 0x00440000},/* clear */
		{(volatile unsigned long *)0xd4019404, 0x157c0000},/* dir */
	},
	{/* GPIO-G */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	},
	{/* GPIO-H */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	}
};

static const gpio_setting_t gpio_reg_setting_array_s1v_sfp[GPIO_GROUP_NUM] = {
	{/* GPIO-A */
		{(volatile unsigned long *)0xd4019008, 0x00002004},/* set */
		{(volatile unsigned long *)0xd401900c, 0x00000000},/* clear */
		{(volatile unsigned long *)0xd4019004, 0x00082004},/* dir */
	},
	{/* GPIO-B */
		{(volatile unsigned long *)0xd4019108, 0x00800000},/* set */
		{(volatile unsigned long *)0xd401910c, 0x00003404},/* clear */
		{(volatile unsigned long *)0xd4019104, 0x0e803404},/* dir */
	},
	{/* GPIO-D */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	},
	{/* GPIO-E */
		{(volatile unsigned long *)0xd4019408, 0x15380000},/* set */
		{(volatile unsigned long *)0xd401940c, 0x00440000},/* clear */
		{(volatile unsigned long *)0xd4019404, 0x157c0000},/* dir */
	},
	{/* GPIO-G */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	},
	{/* GPIO-H */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	}
};

static const gpio_setting_t gpio_reg_setting_array_sh1c_mfp[GPIO_GROUP_NUM] = {
	{/* GPIO-A */
		{(volatile unsigned long *)0xd4019008, 0x00082004},/* set */
		{(volatile unsigned long *)0xd401900c, 0x00004000},/* clear */
		{(volatile unsigned long *)0xd4019004, 0x00086004},/* dir */
	},
	{/* GPIO-B */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	},
	{/* GPIO-D */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	},
	{/* GPIO-E */
		{(volatile unsigned long *)0xd4019408, 0x15380000},/* set */
		{(volatile unsigned long *)0xd401940c, 0x20440400},/* clear */
		{(volatile unsigned long *)0xd4019404, 0x357C0400},/* dir */
	},
	{/* GPIO-G */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* set */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* clear */
		{(volatile unsigned long *)0xffffffff, 0xffffffff},/* dir */
	},
	{/* GPIO-H */
		{(volatile unsigned long *)0xd4019708, 0x00000000},/* set */
		{(volatile unsigned long *)0xd401970c, 0x00000000},/* clear */
		{(volatile unsigned long *)0xd4019704, 0x00000000},/* dir */
	}
};

static const gpio_setting_t gpio_reg_setting_array_sh1v_mfp[GPIO_GROUP_NUM] = {
	{/* GPIO-A */
		{(volatile unsigned long *)0xd4019008, 0x00002004},/* set   */
		{(volatile unsigned long *)0xd401900c, 0x00000000},/* clear */
		{(volatile unsigned long *)0xd4019004, 0x00002004},/* dir   */
	},
	{/* GPIO-B */
		{(volatile unsigned long *)0xd4019108, 0x4E828000},/* set   */
		{(volatile unsigned long *)0xd401910c, 0x00013404},/* clear */
		{(volatile unsigned long *)0xd4019104, 0x4E83B404},/* dir   */
	},
	{/* GPIO-D */
		{(volatile unsigned long *)0xd4019308, 0x00001F80},/* set   */
		{(volatile unsigned long *)0xd401930c, 0x00004000},/* clear */
		{(volatile unsigned long *)0xd4019304, 0x00005F80},/* dir   */
	},
	{/* GPIO-E */
		{(volatile unsigned long *)0xd4019408, 0xF5380000},/* set   */
		{(volatile unsigned long *)0xd401940c, 0x00440000},/* clear */
		{(volatile unsigned long *)0xd4019404, 0xF57C0000},/* dir   */
	},
	{/* GPIO-G */
		{(volatile unsigned long *)0xd4019608, 0x00000000},/* set   */
		{(volatile unsigned long *)0xd401960c, 0x00000080},/* clear */
		{(volatile unsigned long *)0xd4019604, 0x00000080},/* dir   */
	},
	{/* GPIO-H */
		{(volatile unsigned long *)0xd4019708, 0x00000001},/* set   */
		{(volatile unsigned long *)0xd401970c, 0x00000000},/* clear */
		{(volatile unsigned long *)0xd4019704, 0x00000001},/* dir   */
	}
};


static const reg_setting_t iopad_reg_setting_array_konjiki_sfp[] = {
	/* ******************************************************************** */
	{(volatile unsigned long*)0xd401e000, 0x00018041},/* USB3X0_VB_nOC_1P8  */
	{(volatile unsigned long*)0xd401e004, 0x00018041},/* USB2X1_VB_nOC_1P8  */
	{(volatile unsigned long*)0xd401e008, 0x00012040},/* GPIOA[2]           */
	{(volatile unsigned long*)0xd401e00c, 0x00018041},/* USB2X1_nPWR_EN     */
	{(volatile unsigned long*)0xd401e010, 0x00018041},/* USB2H2_nOC         */
	{(volatile unsigned long*)0xd401e014, 0x00018041},/* USB2H2_nPWR_EN     */
	{(volatile unsigned long*)0xd401e018, 0x00018041},/* SER1_RXD           */
	{(volatile unsigned long*)0xd401e01c, 0x00018041},/* SER1_TXD           */
	{(volatile unsigned long*)0xd401e020, 0x00018041},/* I2C1_SCLK          */
	{(volatile unsigned long*)0xd401e024, 0x00018041},/* I2C1_SDA           */
	{(volatile unsigned long*)0xd401e028, 0x00018042},/* SPi1_CLK           */
	{(volatile unsigned long*)0xd401e02c, 0x00018042},/* SPi1_MOSI          */
	{(volatile unsigned long*)0xd401e030, 0x00018042},/* SPi1_MISO          */
	{(volatile unsigned long*)0xd401e034, 0x00018040},/* GPIOA[13]          */
	{(volatile unsigned long*)0xd401e038, 0x0001a040},/*                    */
	{(volatile unsigned long*)0xd401e03c, 0x00018042},/* SPi1_nCS           */
	{(volatile unsigned long*)0xd401e040, 0x00018042},/* I2C2_SDA           */
	{(volatile unsigned long*)0xd401e044, 0x00018042},/* I2C2_SCLK          */
	{(volatile unsigned long*)0xd401e048, 0x00012040},/* GPIOA[18]          */
	{(volatile unsigned long*)0xd401e04c, 0x00012040},/* GPIOA[19]          */
	{(volatile unsigned long*)0xd401e050, 0x00018041},/* ENET_RX_CLK        */
	{(volatile unsigned long*)0xd401e054, 0x00018041},/* ENET_RX_CTRL       */
	{(volatile unsigned long*)0xd401e058, 0x00018041},/* ENET_RX_D0         */
	{(volatile unsigned long*)0xd401e05c, 0x00018041},/* ENET_RX_D1         */
	{(volatile unsigned long*)0xd401e060, 0x00018041},/* ENET_RX_D2         */
	{(volatile unsigned long*)0xd401e064, 0x00018041},/* ENET_RX_D3         */
	{(volatile unsigned long*)0xd401e068, 0x00018041},/* ENET_TX_D0         */
	{(volatile unsigned long*)0xd401e06c, 0x00018041},/* ENET_TX_D1         */
	{(volatile unsigned long*)0xd401e070, 0x00018041},/* ENET_TX_D2         */
	{(volatile unsigned long*)0xd401e074, 0x00018041},/* ENET_TX_D3         */
	{(volatile unsigned long*)0xd401e078, 0x00018041},/* ENET_TX_CTRL       */
	{(volatile unsigned long*)0xd401e07c, 0x00018041},/* ENET_TX_CLK        */
	{(volatile unsigned long*)0xd401e080, 0x00018041},/* ENET_MDC           */
	{(volatile unsigned long*)0xd401e084, 0x00018041},/* ENET_MDIO          */
	{(volatile unsigned long*)0xd401e088, 0x00018040},/* GPIOB[2]           */
	{(volatile unsigned long*)0xd401e08c, 0x00018041},/* ENET_25MHz_CLK     */
//	{(volatile unsigned long*)0xd401e08c, 0x00012040},/* GPIOB[4]           */
//	{(volatile unsigned long*)0xd401e08c, 0x00012040},/* GPIOB[5]           */
//	{(volatile unsigned long*)0xd401e08c, 0x00012040},/* GPIOB[6]           */
//	{(volatile unsigned long*)0xd401e08c, 0x00012040},/* GPIOB[7]           */
	{(volatile unsigned long*)0xd401e0a0, 0x00018043},/* SER4_RXD           */
	{(volatile unsigned long*)0xd401e0a4, 0x00018043},/* SER4_TXD           */
	{(volatile unsigned long*)0xd401e0a8, 0x00018040},/* GPIOB[10]          */
	{(volatile unsigned long*)0xd401e0ac, 0x00018040},/* GPIOB[11]          */
	{(volatile unsigned long*)0xd401e0b0, 0x00018040},/* GPIOB[12]          */
	{(volatile unsigned long*)0xd401e0b4, 0x00018040},/* GPIOB[13]          */
	{(volatile unsigned long*)0xd401e0b8, 0x0001a040},/* GPIOB[14]          */
	{(volatile unsigned long*)0xd401e0bc, 0x0001a040},/* GPIOB[15]          */
	{(volatile unsigned long*)0xd401e0c0, 0x0001a040},/* GPIOB[16]          */
	{(volatile unsigned long*)0xd401e0c4, 0x0001a040},/* GPIOB[17]          */
	{(volatile unsigned long*)0xd401e0c8, 0x0001a040},/* GPIOB[18]          */
	{(volatile unsigned long*)0xd401e0cc, 0x00012040},/* GPIOB[19]          */
	{(volatile unsigned long*)0xd401e0d0, 0x00012040},/* GPIOB[20]          */
	{(volatile unsigned long*)0xd401e0d4, 0x00018040},/* GPIOB[21]          */
	{(volatile unsigned long*)0xd401e0d8, 0x0001a040},/* GPIOB[22]          */
	{(volatile unsigned long*)0xd401e0dc, 0x00012040},/* GPIOB[23]          */
	{(volatile unsigned long*)0xd401e0e0, 0x00012040},/* GPIOB[24]          */
	{(volatile unsigned long*)0xd401e0e4, 0x00018040},/* GPIOB[25]          */
	{(volatile unsigned long*)0xd401e0e8, 0x00018040},/* GPIOB[26]          */
	{(volatile unsigned long*)0xd401e0ec, 0x00012040},/* GPIOB[27]          */
	{(volatile unsigned long*)0xd401e0f0, 0x00012040},/* GPIOB[28]          */
	{(volatile unsigned long*)0xd401e0f4, 0x00012040},/* GPIOB[29]          */
	{(volatile unsigned long*)0xd401e0f8, 0x00012040},/* GPIOB[30]          */
	{(volatile unsigned long*)0xd401e0fc, 0x00012040},/* GPIOB[31]          */
//	{(volatile unsigned long*)0xd401e100, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e104, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e108, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e10c, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e128, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e12c, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e13c, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e140, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e150, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e154, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e164, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e170, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e178, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e190, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e194, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e198, 0x0001a040},/*                    */
//	{(volatile unsigned long*)0xd401e19c, 0x00012040},/* GPIOD[13]          */
//	{(volatile unsigned long*)0xd401e1d8, 0x00012040},/* GPIOD[14]          */
//	{(volatile unsigned long*)0xd401e1dc, 0x0001a040},/* GPIOD[15]          */
//	{(volatile unsigned long*)0xd401e1e0, 0x00012040},/* GPIOD[16]          */
//	{(volatile unsigned long*)0xd401e1e4, 0x00012040},/* GPIOD[17]          */
//	{(volatile unsigned long*)0xd401e1e8, 0x00012040},/* GPIOD[18]          */
//	{(volatile unsigned long*)0xd401e1ec, 0x0001a040},/* GPIOD[19]          */
//	{(volatile unsigned long*)0xd401e1f0, 0x0001a040},/* GPIOD[20]          */
//	{(volatile unsigned long*)0xd401e1f4, 0x0001a040},/* GPIOD[21]          */
//	{(volatile unsigned long*)0xd401e1f8, 0x00012040},/* GPIOD[22]          */
//	{(volatile unsigned long*)0xd401e1fc, 0x00012040},/* GPIOD[23]          */
//	{(volatile unsigned long*)0xd401e200, 0x00012040},/* GPIOD[24]          */
//	{(volatile unsigned long*)0xd401e204, 0x00012040},/* GPIOD[25]          */
//	{(volatile unsigned long*)0xd401e208, 0x0001a040},/* GPIOD[26]          */
//	{(volatile unsigned long*)0xd401e20c, 0x0001a040},/* GPIOD[27]          */
//	{(volatile unsigned long*)0xd401e210, 0x0001a040},/* GPIOD[28]          */
//	{(volatile unsigned long*)0xd401e214, 0x0001a040},/* GPIOD[29]          */
	{(volatile unsigned long*)0xd401e218, 0x00019841},/* SD_MMC0_CLK        */
	{(volatile unsigned long*)0xd401e21c, 0x00018041},/* SD_MMC0_CMD        */
	{(volatile unsigned long*)0xd401e220, 0x00018041},/* SD_MMC0_DATA[0]    */
	{(volatile unsigned long*)0xd401e224, 0x00018041},/* SD_MMC0_DATA[1]    */
	{(volatile unsigned long*)0xd401e228, 0x00018041},/* SD_MMC0_DATA[2]    */
	{(volatile unsigned long*)0xd401e22c, 0x00018041},/* SD_MMC0_DATA[3]    */
	{(volatile unsigned long*)0xd401e230, 0x00018041},/* SD_MMC0_DATA[4]    */
	{(volatile unsigned long*)0xd401e234, 0x00018041},/* SD_MMC0_DATA[5]    */
	{(volatile unsigned long*)0xd401e238, 0x00018041},/* SD_MMC0_DATA[6]    */
	{(volatile unsigned long*)0xd401e23c, 0x00018041},/* SD_MMC0_DATA[7]    */
	{(volatile unsigned long*)0xd401e240, 0x00018040},/* GPIOE[8]           */
	{(volatile unsigned long*)0xd401e244, 0x00018040},/* GPIOE[9]           */
	{(volatile unsigned long*)0xd401e248, 0x00018040},/* GPIOE[10]          */
	{(volatile unsigned long*)0xd401e24c, 0x00018040},/* GPIOE[11]          */
	{(volatile unsigned long*)0xd401e250, 0x00019841},/* SD_MMC2_CLK        */
	{(volatile unsigned long*)0xd401e254, 0x00018041},/* SD_MMC2_CMD        */
	{(volatile unsigned long*)0xd401e258, 0x00018041},/* SD_MMC2_DATA[0]    */
	{(volatile unsigned long*)0xd401e25c, 0x00018041},/* SD_MMC2_DATA[1]    */
	{(volatile unsigned long*)0xd401e260, 0x00018041},/* SD_MMC2_DATA[2]    */
	{(volatile unsigned long*)0xd401e264, 0x00018041},/* SD_MMC2_DATA[3]    */
	{(volatile unsigned long*)0xd401e268, 0x0001c040},/* GPIOE[18]          */
//	{(volatile unsigned long*)0xd401e26c, 0x00012040},/* GPIOE[19]          */
	{(volatile unsigned long*)0xd401e270, 0x0001c040},/* GPIOE[20]          */
	{(volatile unsigned long*)0xd401e274, 0x00018040},/* GPIOE[21]          */
//	{(volatile unsigned long*)0xd401e278, 0x00012040},/* GPIOE[22]          */
	{(volatile unsigned long*)0xd401e27c, 0x00018040},/* GPIOE[23]          */
	{(volatile unsigned long*)0xd401e280, 0x0001c040},/* GPIOE[24]          */
	{(volatile unsigned long*)0xd401e284, 0x0001c040},/* GPIOE[25]          */
	{(volatile unsigned long*)0xd401e288, 0x00018040},/* GPIOE[26]          */
	{(volatile unsigned long*)0xd401e28c, 0x00018040},/* GPIOE[27]          */
	{(volatile unsigned long*)0xd401e290, 0x00019840},/* GPIOE[28]          */
//	{(volatile unsigned long*)0xd401e294, 0x00012040},/* GPIOE[29]          */
//	{(volatile unsigned long*)0xd401e298, 0x00012040},/* GPIOE[30]          */
//	{(volatile unsigned long*)0xd401e29c, 0x00012040},/* GPIOE[31]          */
//	{(volatile unsigned long*)0xd401e2a0, 0x0001a040},/* GPIOF[0]           */
//	{(volatile unsigned long*)0xd401e33c, 0x00012040},/* GPIOG[1]           */
//	{(volatile unsigned long*)0xd401e340, 0x00012040},/* GPIOG[2]           */
	{(volatile unsigned long*)0xd401e34c, 0x00012040},/* GPIOG[5]           */
//	{(volatile unsigned long*)0xd401e350, 0x00012040},/* GPIOG[6]           */
//	{(volatile unsigned long*)0xd401e354, 0x00012040},/* GPIOG[7]           */
	{(volatile unsigned long*)0xd401e358, 0x00018040},/* GPIOG[8]           */
//	{(volatile unsigned long*)0xd401e35c, 0x00012040},/* GPIOG[9]           */
//	{(volatile unsigned long*)0xd401e360, 0x00012040},/* GPIOG[10]          */
	{(volatile unsigned long*)0xd401e364, 0x0001c040},/* GPIOG[11]          */
//	{(volatile unsigned long*)0xd401e36c, 0x00012040},/* GPIOG[13]          */
//	{(volatile unsigned long*)0xd401e3a0, 0x00012040},/* GPIOG[26]          */
//	{(volatile unsigned long*)0xd401e3a4, 0x00012040},/* GPIOG[27]          */
//	{(volatile unsigned long*)0xd401e3ac, 0x00012040},/* GPIOG[29]          */
//	{(volatile unsigned long*)0xd401e3b4, 0x00012040},/* GPIOG[31]          */
	{(volatile unsigned long*)0xd401e3b8, 0x00012040},/* GPIOH[0]           */
	{(volatile unsigned long*)0xd401e3bc, 0x00012040},/* GPIOH[1]           */
	/* ******************************************************************** */
	{(volatile unsigned long*)0xffffffff, 0xffffffff},/* ANCHOR             */
};/* iopad_reg_setting_array_konjiki_sfp[] */

static const gpio_setting_t gpio_reg_setting_array_konjiki_sfp[GPIO_GROUP_NUM] = {
    {/* GPIO-A */
		{(volatile unsigned long *)0xd4019008, 0x00002000},/* set */
		{(volatile unsigned long *)0xd401900c, 0x000C0000},/* clear */
		{(volatile unsigned long *)0xd4019004, 0x000C2000},/* dir */
	},
	{/* GPIO-B */
		{(volatile unsigned long *)0xd4019108, 0x06028000},/* set */   /* 0x06028000 */
		{(volatile unsigned long *)0xd401910c, 0xF0013404},/* clear */ /* 0xF0013404 */
		{(volatile unsigned long *)0xd4019104, 0xF603B404},/* dir */
	},
	{/* GPIO-D */
		{(volatile unsigned long *)0xd4019308, 0x00001F80},/* set */
		{(volatile unsigned long *)0xd401930c, 0x00000000},/* clear */
		{(volatile unsigned long *)0xd4019304, 0x00001F80},/* dir */
	},
	{/* GPIO-E */
		{(volatile unsigned long *)0xd4019408, 0x15300000},/* set */
		{(volatile unsigned long *)0xd401940c, 0x00040000},/* clear */
		{(volatile unsigned long *)0xd4019404, 0x15340000},/* dir */
	},
	{/* GPIO-G */
		{(volatile unsigned long *)0xd4019608, 0x00000000},/* set   */
		{(volatile unsigned long *)0xd401960c, 0x00000000},/* clear */
		{(volatile unsigned long *)0xd4019604, 0x00000000},/* dir   */
	},
	{/* GPIO-H */
		{(volatile unsigned long *)0xd4019708, 0x00000000},/* set   */
		{(volatile unsigned long *)0xd401970c, 0x00000000},/* clear */
		{(volatile unsigned long *)0xd4019704, 0x00000000},/* dir   */
	}
};



enum board_type {
	TYPE_INVALID = -1,
	TYPE_CHI_MFP = 0,
	TYPE_CHI_SFP = 1,
	TYPE_VES_MFP = 2,
	TYPE_VES_SFP = 3,
	TYPE_CHI_MFP_S = 4,
	TYPE_VES_MFP_S = 5,
	TYPE_KONJIKI_SFP = 6,
};

static const reg_setting_t *iopad_reg_setting_array[7] = {
	iopad_reg_setting_array_s1c_mfp,
	iopad_reg_setting_array_s1c_sfp,
	iopad_reg_setting_array_s1v_mfp,
	iopad_reg_setting_array_s1v_sfp,
	iopad_reg_setting_array_sh1c_mfp,
	iopad_reg_setting_array_sh1v_mfp,
	iopad_reg_setting_array_konjiki_sfp,
};

static const gpio_setting_t *gpio_reg_setting_array[7] = {
	gpio_reg_setting_array_s1c_mfp,
	gpio_reg_setting_array_s1c_sfp,
	gpio_reg_setting_array_s1v_mfp,
	gpio_reg_setting_array_s1v_sfp,
	gpio_reg_setting_array_sh1c_mfp,
	gpio_reg_setting_array_sh1v_mfp,
	gpio_reg_setting_array_konjiki_sfp,
};

extern unsigned int board_get_core_freq_hz(void);

int get_board_suffix(void)
{
	static int suffix = -1;
	volatile unsigned long *iopad_013 = (unsigned long *)0xd401e034;
	volatile unsigned long *iopad_138 = (unsigned long *)0xd401e248;
	volatile unsigned long *iopad_156 = (unsigned long *)0xd401e290;
	volatile unsigned long *gpio_pdra = (unsigned long *)0xd4019004;
	volatile unsigned long *gpio_plra = (unsigned long *)0xd4019000;
	volatile unsigned long *gpio_pdre = (unsigned long *)0xd4019404;
	volatile unsigned long *gpio_plre = (unsigned long *)0xd4019400;
	int bit2 = 0,  bit1 = 0, bit0 = 0, type_id = 0;
	unsigned int core_freq = 0;

	if (suffix >= 0) {
		goto EXIT_FUNC;
	}

	core_freq = ((board_get_core_freq_hz()) / 1000000);

	*iopad_013 = *iopad_138 = *iopad_156 = 0x00018040;
	*gpio_pdra = *gpio_pdre = 0x00000000;

	bit2 = ((*gpio_plra) & 0x00002000) ? 1 : 0;
	bit1 = ((*gpio_plre) & 0x10000000) ? 1 : 0;
	bit0 = ((*gpio_plre) & 0x00000400) ? 1 : 0;

	type_id = (bit2 << 2) | (bit1 << 1) | (bit0);

	switch (type_id) {
	case 7:/* CUI 1024MB */
		printf("Invalid type ID(7)...\n");
		break;
	case 6:/* CUI 512MB */
		suffix = (core_freq == 800) ? TYPE_CHI_SFP : TYPE_VES_SFP;
		printf("Board : %s\n", (suffix == TYPE_CHI_SFP) ? "Type-S1c(SFP)" : "Type-S1v(SFP)");
		break;
	case 3:/* Andro 2048MB */
		suffix = (core_freq == 800) ? TYPE_CHI_MFP_S : TYPE_VES_MFP_S;
		printf("Board : %s\n", (suffix == TYPE_CHI_MFP_S) ? "Type-SH1c" : "Type-SH1v");
		break;
	case 2:/* Andro 1024MB */
		printf("Invalid type ID(2)...\n");
		suffix = -1;
		break;
	case 1:/* GUI 2048MB */
		printf("Board : Type-Konjiki\n");
		suffix = TYPE_KONJIKI_SFP;
		break;
	case 0:/* GUI 1024MB */
		suffix = (core_freq == 800) ? TYPE_CHI_MFP : TYPE_VES_MFP;
		printf("Board : %s\n", (suffix == TYPE_CHI_MFP) ? "Type-S1c(MFP)" : "Type-S1v(MFP)");
		break;
	default:
		printf("Invalid type ID(%d)...\n", type_id);
		suffix = -1;
		break;
	}

 EXIT_FUNC:
	return suffix;
}

void setup_pinconfig(void)
{ 
	/* RICOH add */
	int suffix = 0;
	int cnt = 0;
	const reg_setting_t *ptr_iopad_setting = NULL;
	const gpio_setting_t *ptr_gpio_setting = NULL;

	suffix = get_board_suffix();
	for (ptr_iopad_setting = iopad_reg_setting_array[suffix]; ; ptr_iopad_setting++) {
		if ((ptr_iopad_setting->reg_addr == 0xffffffff) || (ptr_iopad_setting->reg_val == 0xffffffff)) {
			break;
		}
		/* Configure IOPad register */
		*(ptr_iopad_setting->reg_addr) = ptr_iopad_setting->reg_val;
	}
	/* Setup GPIO Set/Clear/Direction Registers... */
	for (ptr_gpio_setting = gpio_reg_setting_array[suffix]; cnt < GPIO_GROUP_NUM; cnt++, ptr_gpio_setting++) {
		if (ptr_gpio_setting->set.reg_addr != (unsigned long*)0xffffffff) {
			*(ptr_gpio_setting->set.reg_addr) = ptr_gpio_setting->set.reg_val;
		}
		if (ptr_gpio_setting->clr.reg_addr != (unsigned long*)0xffffffff) {
			*(ptr_gpio_setting->clr.reg_addr) = ptr_gpio_setting->clr.reg_val;
		}
		if (ptr_gpio_setting->dir.reg_addr != (unsigned long*)0xffffffff) {
			*(ptr_gpio_setting->dir.reg_addr) = ptr_gpio_setting->dir.reg_val;
		}
	}
	puts(" -> finished pin-config\n");
	
	
	if(TYPE_KONJIKI_SFP == suffix)
	{
		volatile unsigned long *gpio_psr = (unsigned long *)0xd4019008;
		volatile unsigned long *gpio_pcr = (unsigned long *)0xd401900C;
		volatile unsigned long *gpio_pdr = (unsigned long *)0xd4019004;
		volatile unsigned long *gpioe_psr = (unsigned long *)0xd4019408;
		volatile unsigned long *gpioe_pcr = (unsigned long *)0xd401940C;
		unsigned long psr_data, pcr_data, pdr_data;
		unsigned int lcd_wait_time = 30; /* ms */
	
		printf("[u-boot] Reset for PCIe(PCIE_CLK_ENB)\n");
		psr_data = *gpio_psr;
		pcr_data = *gpio_pcr;
		pdr_data = *gpio_pdr;
		
		psr_data |= (0x00000001 << 19);
		*gpio_psr = psr_data;
	
		pcr_data &= ~(0x00000001 << 19);
		*gpio_pcr = pcr_data;
		
		pdr_data |= (0x00000001 << 19);
		*gpio_pdr = pdr_data;
			
		mdelay(2);
		
		psr_data = *gpio_psr;
		pcr_data = *gpio_pcr;
		pdr_data = *gpio_pdr;
		
		psr_data |= (0x00000001 << 18);
		*gpio_psr = psr_data;
		
		pcr_data &= ~(0x00000001 << 18);
		*gpio_pcr = pcr_data;
		
		pdr_data |= (0x00000001 << 18);
		*gpio_pdr = pdr_data;

		/* Konjiki-P1 Jackal암 */
		/* JackalL[}CR̎dOn1x삷DGLOCKɂlcd䂪݂B(LPUX̏QΉ) */
		/* ̏̂sGWł͕Kvȏł͖AdOnɓ삹ȀȃGlAɓ삵ă^C~O炵ĕʂȖ𔭐̂ŁA
		DGLOCKOFF_ONJackal̊Y𓮍삳B */
		printf("wait lcd on %dms\n", lcd_wait_time);
		mdelay(lcd_wait_time);
		pcr_data = *gpioe_pcr;
		pcr_data |= (0x00000001 << 28);
		*gpioe_pcr = pcr_data;
		printf("[u-boot]%p:%08x\n", gpioe_pcr, pcr_data);

		printf("wait lcd off %dms\n", lcd_wait_time);
		mdelay(lcd_wait_time);

		psr_data = *gpioe_psr;
		psr_data |= (0x00000001 << 28);
		*gpioe_psr = psr_data;
		printf("[u-boot]%p:%08x\n", gpioe_psr, psr_data);
	}
	
}
