 /*
 **************************************************************************************
 *
 * (c) Copyright 2013 Marvell International Ltd.
 *
 *               Marvell Confidential
 **************************************************************************************
 *
 * Marvell Commercial License Option
 *
 * If you received this File from Marvell as part of a proprietary software release,
 * the File is considered Marvell Proprietary and Confidential Information, and is
 * licensed to you under the terms of the applicable Commercial License.
 *
 **************************************************************************************
 *
 * Marvell GPL License Option
 *
 * If you received this File from Marvell as part of a Linux distribution, this File
 * is licensed to you in accordance with the terms and conditions of the General Public
 * License Version 2, June 1991 (the "GPL License").  You can redistribute it and/or
 * modify it under the terms of the GPL License; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GPL License for more details.
 *
 * You should have received a copy of the GNU General Public License along with this
 * program.  If not, see http://www.gnu.org/licenses/.
 *
 **************************************************************************************
 *
 * \file MC_regstructs.h
 * Generated using RegBuild 1.6.3
 *
 **************************************************************************************
 */

#ifndef _MC_REGSTRUCTS_H_
#define _MC_REGSTRUCTS_H_

//#include <stdint.h>

//====================================================================
//
//Register File: MC (MC)
/** \brief This defines the registers for the Memory Controller (MC).*/
//
//====================================================================

typedef struct MC_REGS_s
{
  volatile uint32_t MC_ID;  ///< 0x0 [R/W]: Memory Controller ID and Revision Register
  volatile uint32_t MC_STATUS;  ///< 0x4 [R/W]: Memory Controller Status Register
  volatile uint32_t DRAM_STATUS;  ///< 0x8 [R/W]: DRAM Status Register
  volatile uint32_t DRAM_MODE;  ///< 0xc [R/W]: DRAM Mode Register
  volatile uint32_t MC_WP_STAT;  ///< 0x10 [R/W]: MC Write Path Status
  volatile uint32_t MC_RP_STAT;  ///< 0x14 [R/W]: MC Read Path Status
  volatile uint32_t reserved0[2];
  volatile uint32_t USER_COMMAND_0;  ///< 0x20 [R/W]: User Initiated Command Register 0
  volatile uint32_t USER_COMMAND_1;  ///< 0x24 [R/W]: User Initiated Command Register 1
  volatile uint32_t reserved1[6];
  volatile uint32_t SRAM_control;  ///< 0x40 [R/W]: Internal SRAM Control Register
  volatile uint32_t MC_Control_0;  ///< 0x44 [R/W]: MC Control Register 0
  volatile uint32_t Exclusive_Monitor;  ///< 0x48 [R/W]: Exclusive Monitor Control Register
  volatile uint32_t Coherency;  ///< 0x4c [R/W]: Data Coherency Check Control Register
  volatile uint32_t RZ_access_ctl;  ///< 0x50 [R/W]: Restrict Zone Access Control Register
  volatile uint32_t PHY_pwr_ctl;  ///< 0x54 [R/W]: PHY Power Control Register
  volatile uint32_t WCB_Control;  ///< 0x58 [R/W]: Write Command Buffer (WCB) Control Register
  volatile uint32_t BQ_Control;  ///< 0x5c [R/W]: Bank Queue Control Register
  volatile uint32_t ROB_Control;  ///< 0x60 [R/W]: ROB Control Register
  volatile uint32_t reserved2[7];
  volatile uint32_t Port_Weight;  ///< 0x80 [R/W]: Port RRB Weight Register
  volatile uint32_t Port_priority;  ///< 0x84 [R/W]: Port Priority Control Register
  volatile uint32_t RRB_Starvation_0;  ///< 0x88 [R/W]: RRB Starvation Prevention Register 0
  volatile uint32_t RRB_Starvation_1;  ///< 0x8c [R/W]: RRB Starvation Prevention Register 1
  volatile uint32_t reserved3[12];
  volatile uint32_t RegTable_Control;  ///< 0xc0 [R/W]: Register Table Control Register
  volatile uint32_t RegTable_Data_0;  ///< 0xc4 [R/W]: Register Table Data Register 0
  volatile uint32_t RegTable_Data_1;  ///< 0xc8 [R/W]: Register Table Data Register 1
  volatile uint32_t reserved4[13];
  volatile uint32_t PC_config0;  ///< 0x100 [R/W]: Performance Counter Configuration Register 0
  volatile uint32_t PC_config1;  ///< 0x104 [R/W]: Performance Counter Configuration Register 1
  volatile uint32_t PC_status;  ///< 0x108 [R/W]: Performance Counter Status Register
  volatile uint32_t PC_Control;  ///< 0x10c [R/W]: Performance Counter Control Register
  volatile uint32_t PC0;  ///< 0x110 [R/W]: Performance Counter Register
  volatile uint32_t PC1;  ///< 0x114 [R/W]: Performance Counter Register
  volatile uint32_t PC2;  ///< 0x118 [R/W]: Performance Counter Register
  volatile uint32_t PC3;  ///< 0x11c [R/W]: Performance Counter Register
  volatile uint32_t PC4;  ///< 0x120 [R/W]: Performance Counter Register
  volatile uint32_t PC5;  ///< 0x124 [R/W]: Performance Counter Register
  volatile uint32_t PC6;  ///< 0x128 [R/W]: Performance Counter Register
  volatile uint32_t PC7;  ///< 0x12c [R/W]: Performance Counter Register
  volatile uint32_t reserved5[4];
  volatile uint32_t ISR;  ///< 0x140 [R/W]: Interrupt Status Register
  volatile uint32_t IER;  ///< 0x144 [R/W]: Interrupt Enable Register
  volatile uint32_t reserved6[2];
  volatile uint32_t ADC_ERR_ID;  ///< 0x150 [R/W]: Address Decode Error Master ID Register
  volatile uint32_t ADC_ERR_ADR_L;  ///< 0x154 [R/W]: Address Decode Error Lower Address Register
  volatile uint32_t ADC_ERR_ADR_H;  ///< 0x158 [R/W]: Address Decode Error Higher Address Register
  volatile uint32_t reserved7;
  volatile uint32_t AM_PERIOD;  ///< 0x160 [R/W]: Activity Monitor Check Period Register
  volatile uint32_t AM_TH;  ///< 0x164 [R/W]: Activity Monitor Threshold Register
  volatile uint32_t reserved8[2];
  volatile uint32_t TZ_ERR_ID;  ///< 0x170 [R/W]: TrustZone Error Master ID Register
  volatile uint32_t TZ_ERR_ADR_L;  ///< 0x174 [R/W]: TrustZone Error Lower Address Register
  volatile uint32_t TZ_ERR_ADR_H;  ///< 0x178 [R/W]: TrustZone Error Higher Address Register
  volatile uint32_t reserved9[18];
  volatile uint32_t Test_Control_0;  ///< 0x1c4 [R/W]: Test Mode Register 0
  volatile uint32_t Test_Control_1;  ///< 0x1c8 [R/W]: Test Mode Register 1
  volatile uint32_t reserved10[13];
  volatile uint32_t CH0_MMAP0;  ///< 0x200 [R/W]: Memory Address Map Register Channel 0
  volatile uint32_t CH0_MMAP1;  ///< 0x204 [R/W]: Memory Address Map Register Channel 0
  volatile uint32_t CH0_MMAP2;  ///< 0x208 [R/W]: Memory Address Map Register Channel 0
  volatile uint32_t reserved11;
  volatile uint32_t CH0_PMAP0;  ///< 0x210 [R/W]: Memory Controller Physical Address Map Register
  volatile uint32_t CH0_PMAP1;  ///< 0x214 [R/W]: Memory Controller Physical Address Map Register
  volatile uint32_t CH0_PMAP2;  ///< 0x218 [R/W]: Memory Controller Physical Address Map Register
  volatile uint32_t reserved12[41];
  volatile uint32_t CH0_MC_Control_1;  ///< 0x2c0 [R/W]: MC Control Register 1
  volatile uint32_t CH0_MC_Control_2;  ///< 0x2c4 [R/W]: Memory Controller Control Register 2
  volatile uint32_t CH0_MC_Control_3;  ///< 0x2c8 [R/W]: Memory Controller Control Register 3
  volatile uint32_t CH0_MC_Control_4;  ///< 0x2cc [R/W]: Memory Controller Control Register 4
  volatile uint32_t reserved13[12];
  volatile uint32_t CH0_DRAM_Config_1;  ///< 0x300 [R/W]: DRAM Configuration Register 1
  volatile uint32_t CH0_DRAM_Config_2;  ///< 0x304 [R/W]: DRAM Configuration Register 2
  volatile uint32_t CH0_DRAM_Config_3;  ///< 0x308 [R/W]: DRAM Configuration Register 3
  volatile uint32_t reserved14;
  volatile uint32_t CH0_DRAM_Config_5_CS0;  ///< 0x310 [R/W]: DRAM Configuration Register 5
  volatile uint32_t CH0_DRAM_Config_5_CS1;  ///< 0x314 [R/W]: DRAM Configuration Register 5
  volatile uint32_t CH0_DRAM_Config_5_CS2;  ///< 0x318 [R/W]: DRAM Configuration Register 5
  volatile uint32_t reserved15[9];
  volatile uint32_t CH0_DRAM_Control_1;  ///< 0x340 [R/W]: DRAM Control Register 1
  volatile uint32_t CH0_DRAM_Control_2;  ///< 0x344 [R/W]: DRAM Control Register 2
  volatile uint32_t CH0_DRAM_Control_3;  ///< 0x348 [R/W]: DRAM Control Register 3
  volatile uint32_t reserved16[9];
  volatile uint32_t CH0_MRR_Data;  ///< 0x370 [R/W]: Mode Register Read Data Register
  volatile uint32_t CH0_MPR_Data0;  ///< 0x374 [R/W]: Multi-Purpose Register Read Data0 Register
  volatile uint32_t CH0_MPR_Data1;  ///< 0x378 [R/W]: Multi-Purpose Register Read Data1 Register
  volatile uint32_t reserved17;
  volatile uint32_t CH0_DDR_init_timing_control_0;  ///< 0x380 [R/W]: DRAM Initialization Timing Control Register 0
  volatile uint32_t CH0_DDR_init_timing_control_1;  ///< 0x384 [R/W]: DRAM Initialization Timing Control Register 1
  volatile uint32_t CH0_ZQC_Timing_0;  ///< 0x388 [R/W]: DRAM ZQC Timing Register 0
  volatile uint32_t CH0_ZQC_Timing_1;  ///< 0x38c [R/W]: DRAM ZQC Timing Register 1
  volatile uint32_t CH0_Refresh_timing;  ///< 0x390 [R/W]: DRAM Refresh Timing Register
  volatile uint32_t CH0_SelfRefresh_timing;  ///< 0x394 [R/W]: DRAM Self-refresh Timing Register
  volatile uint32_t CH0_PowerDown_timing;  ///< 0x398 [R/W]: DRAM Power-down Timing Register
  volatile uint32_t CH0_MRS_timing;  ///< 0x39c [R/W]: DRAM MRS Timing Register
  volatile uint32_t CH0_ACT_timing;  ///< 0x3a0 [R/W]: DRAM Activate Timing Register
  volatile uint32_t CH0_PreCharge_Timing;  ///< 0x3a4 [R/W]: DRAM Precharge Timing Register
  volatile uint32_t CH0_CAS_RAS_timing;  ///< 0x3a8 [R/W]: DRAM CAS/RAS Timing Register
  volatile uint32_t CH0_Off_spec_timing;  ///< 0x3ac [R/W]: DRAM Off-spec timing Register
  volatile uint32_t CH0_dram_read_timing;  ///< 0x3b0 [R/W]: DRAM read timing  control register
  volatile uint32_t CH0_dram_ca_train_timing;  ///< 0x3b4 [R/W]: DRAM CA Train timing Register
  volatile uint32_t reserved18;
  volatile uint32_t CH0_dram_mpd_timing;  ///< 0x3bc [R/W]: DRAM Maximum Power-Down timing Register
  volatile uint32_t reserved19[16];
  volatile uint32_t CH0_PHY_Control_1;  ///< 0x400 [R/W]: PHY Control Register 1
  volatile uint32_t CH0_PHY_Control_2;  ///< 0x404 [R/W]: PHY Control Register 2
  volatile uint32_t CH0_PHY_Control_3;  ///< 0x408 [R/W]: PHY Control Register 3
  volatile uint32_t CH0_PHY_Control_4;  ///< 0x40c [R/W]: PHY Control Register 4
  volatile uint32_t CH0_PHY_Control_5;  ///< 0x410 [R/W]: PHY Control Register 5
  volatile uint32_t CH0_PHY_Control_6;  ///< 0x414 [R/W]: PHY Control Register 6
  volatile uint32_t reserved20;
  volatile uint32_t CH0_PHY_Control_8;  ///< 0x41c [R/W]: PHY Control Register 8
  volatile uint32_t CH0_PHY_Control_9;  ///< 0x420 [R/W]: PHY Control Register 9
  volatile uint32_t CH0_PHY_Control_10;  ///< 0x424 [R/W]: PHY Control Register 10
  volatile uint32_t CH0_PHY_Control_11;  ///< 0x428 [R/W]: PHY Control Register 11
  volatile uint32_t CH0_PHY_Control_12;  ///< 0x42c [R/W]: PHY Control Register 12
  volatile uint32_t CH0_PHY_Control_13;  ///< 0x430 [R/W]: PHY Control Register 13
  volatile uint32_t CH0_PHY_Control_14;  ///< 0x434 [R/W]: PHY Control Register 14
  volatile uint32_t CH0_PHY_Control_15;  ///< 0x438 [R/W]: PHY Control Register 15
  volatile uint32_t CH0_PHY_Control_16;  ///< 0x43c [R/W]: PHY Control Register 16
  volatile uint32_t CH0_PHY_Control_17;  ///< 0x440 [R/W]: PHY Control Register 17
  volatile uint32_t reserved21[47];
  volatile uint32_t CH0_PHY_DLL_control_B0;  ///< 0x500 [R/W]: PHY DLL Control Register
  volatile uint32_t CH0_PHY_DLL_control_B1;  ///< 0x504 [R/W]: PHY DLL Control Register
  volatile uint32_t CH0_PHY_DLL_control_B2;  ///< 0x508 [R/W]: PHY DLL Control Register
  volatile uint32_t CH0_PHY_DLL_control_B3;  ///< 0x50c [R/W]: PHY DLL Control Register
  volatile uint32_t reserved22[6];
  volatile uint32_t CH0_PHY_DLL_BYTE_SELECT;  ///< 0x528 [R/W]: PHY DLL Byte Select Register
  volatile uint32_t CH0_PHY_DLL_DLY;  ///< 0x52c [R/W]: PHY BYTE DLL Delay Register
  volatile uint32_t reserved23[4];
  volatile uint32_t CH0_PHY_Data_Byte_Control_B0;  ///< 0x540 [R/W]: PHY Data Byte Control Register
  volatile uint32_t CH0_PHY_Data_Byte_Control_B1;  ///< 0x544 [R/W]: PHY Data Byte Control Register
  volatile uint32_t CH0_PHY_Data_Byte_Control_B2;  ///< 0x548 [R/W]: PHY Data Byte Control Register
  volatile uint32_t CH0_PHY_Data_Byte_Control_B3;  ///< 0x54c [R/W]: PHY Data Byte Control Register
  volatile uint32_t reserved24[8];
  volatile uint32_t CH0_PHY_WL_RL_Control;  ///< 0x570 [R/W]: PHY WL RL Control Register
  volatile uint32_t reserved25[3];
  volatile uint32_t CH0_PHY_WL_DATA_Control_CS0_B0;  ///< 0x580 [R/W]: PHY WL Data Control Register
  volatile uint32_t CH0_PHY_WL_DATA_Control_CS0_B1;  ///< 0x584 [R/W]: PHY WL Data Control Register
  volatile uint32_t CH0_PHY_WL_DATA_Control_CS0_B2;  ///< 0x588 [R/W]: PHY WL Data Control Register
  volatile uint32_t CH0_PHY_WL_DATA_Control_CS0_B3;  ///< 0x58c [R/W]: PHY WL Data Control Register
  volatile uint32_t reserved26[4];
  volatile uint32_t CH0_PHY_WL_DATA_Control_CS1_B0;  ///< 0x5a0 [R/W]: PHY WL Data Control Register
  volatile uint32_t CH0_PHY_WL_DATA_Control_CS1_B1;  ///< 0x5a4 [R/W]: PHY WL Data Control Register
  volatile uint32_t CH0_PHY_WL_DATA_Control_CS1_B2;  ///< 0x5a8 [R/W]: PHY WL Data Control Register
  volatile uint32_t CH0_PHY_WL_DATA_Control_CS1_B3;  ///< 0x5ac [R/W]: PHY WL Data Control Register
  volatile uint32_t reserved27[4];
  volatile uint32_t CH0_PHY_WL_DATA_Control_CS2_B0;  ///< 0x5c0 [R/W]: PHY WL Data Control Register
  volatile uint32_t CH0_PHY_WL_DATA_Control_CS2_B1;  ///< 0x5c4 [R/W]: PHY WL Data Control Register
  volatile uint32_t CH0_PHY_WL_DATA_Control_CS2_B2;  ///< 0x5c8 [R/W]: PHY WL Data Control Register
  volatile uint32_t CH0_PHY_WL_DATA_Control_CS2_B3;  ///< 0x5cc [R/W]: PHY WL Data Control Register
  volatile uint32_t reserved28[16];
  volatile uint32_t CH0_PHY_WL_CLK_Control_CS0;  ///< 0x610 [R/W]: PHY WL CLK Control Register
  volatile uint32_t CH0_PHY_WL_CLK_Control_CS1;  ///< 0x614 [R/W]: PHY WL CLK Control Register
  volatile uint32_t CH0_PHY_WL_CLK_Control_CS2;  ///< 0x618 [R/W]: PHY WL CLK Control Register
  volatile uint32_t reserved29;
  volatile uint32_t CH0_PHY_WL_AC_Control_0;  ///< 0x620 [R/W]: PHY WL AC Control Register
  volatile uint32_t CH0_PHY_WL_AC_Control_1;  ///< 0x624 [R/W]: PHY WL AC Control Register
  volatile uint32_t CH0_PHY_WL_AC_Control_2;  ///< 0x628 [R/W]: PHY WL AC Control Register
  volatile uint32_t reserved30[5];
  volatile uint32_t CH0_PHY_RL_Control_CS0_B0;  ///< 0x640 [R/W]: PHY RL Control Register
  volatile uint32_t CH0_PHY_RL_Control_CS0_B1;  ///< 0x644 [R/W]: PHY RL Control Register
  volatile uint32_t CH0_PHY_RL_Control_CS0_B2;  ///< 0x648 [R/W]: PHY RL Control Register
  volatile uint32_t CH0_PHY_RL_Control_CS0_B3;  ///< 0x64c [R/W]: PHY RL Control Register
  volatile uint32_t reserved31[4];
  volatile uint32_t CH0_PHY_RL_Control_CS1_B0;  ///< 0x660 [R/W]: PHY RL Control Register
  volatile uint32_t CH0_PHY_RL_Control_CS1_B1;  ///< 0x664 [R/W]: PHY RL Control Register
  volatile uint32_t CH0_PHY_RL_Control_CS1_B2;  ///< 0x668 [R/W]: PHY RL Control Register
  volatile uint32_t CH0_PHY_RL_Control_CS1_B3;  ///< 0x66c [R/W]: PHY RL Control Register
  volatile uint32_t reserved32[4];
  volatile uint32_t CH0_PHY_RL_Control_CS2_B0;  ///< 0x680 [R/W]: PHY RL Control Register
  volatile uint32_t CH0_PHY_RL_Control_CS2_B1;  ///< 0x684 [R/W]: PHY RL Control Register
  volatile uint32_t CH0_PHY_RL_Control_CS2_B2;  ///< 0x688 [R/W]: PHY RL Control Register
  volatile uint32_t CH0_PHY_RL_Control_CS2_B3;  ///< 0x68c [R/W]: PHY RL Control Register
  volatile uint32_t reserved33[28];
  volatile uint32_t CH0_PHY_CA_Delay0;  ///< 0x700 [R/W]: PHY CA Delay Register 0
  volatile uint32_t CH0_PHY_CA_Delay1;  ///< 0x704 [R/W]: PHY CA Delay Register 1
  volatile uint32_t CH0_PHY_CA_Delay2;  ///< 0x708 [R/W]: PHY CA Delay Register 2
  volatile uint32_t reserved34[13];
  volatile uint32_t CH0_PHY_CA_Train_Result;  ///< 0x740 [R/W]: PHY CA Train Result
  volatile uint32_t reserved35[7];
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_B0;  ///< 0x760 [R/W]: PHY PRBS Status and Mask Register
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_B1;  ///< 0x764 [R/W]: PHY PRBS Status and Mask Register
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_B2;  ///< 0x768 [R/W]: PHY PRBS Status and Mask Register
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_B3;  ///< 0x76c [R/W]: PHY PRBS Status and Mask Register
  volatile uint32_t reserved36[5];
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_C0;  ///< 0x784 [R/W]: PHY PRBS Status and Mask Register
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_C1;  ///< 0x788 [R/W]: PHY PRBS Status and Mask Register
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_C2;  ///< 0x78c [R/W]: PHY PRBS Status and Mask Register
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_C3;  ///< 0x790 [R/W]: PHY PRBS Status and Mask Register
  volatile uint32_t CH0_PHY_PRBS_Stat_Mask_C4;  ///< 0x794 [R/W]: PHY PRBS Status and Mask Register
  volatile uint32_t CH0_PHY_PRBS_Subphy_Stat;  ///< 0x798 [R/W]: PHY PRBS Subphy Status Register
  volatile uint32_t CH0_PHY_PRBS_User_Pattern;  ///< 0x79c [R/W]: PHY PRBS User Pattern Register
  volatile uint32_t CH0_PHY_PRBS_Control0;  ///< 0x7a0 [R/W]: PHY PRBS Control0 Register
  volatile uint32_t CH0_PHY_PRBS_Control1;  ///< 0x7a4 [R/W]: PHY PRBS Control1 Register
  volatile uint32_t reserved37[22];
  volatile uint32_t TZ_Range0_Low;  ///< 0x800 [R/W]: MC Trustzone Range 0 Low Register
  volatile uint32_t TZ_Range0_High;  ///< 0x804 [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range1_Low;  ///< 0x808 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range1_High;  ///< 0x80c [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range2_Low;  ///< 0x810 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range2_High;  ///< 0x814 [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range3_Low;  ///< 0x818 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range3_High;  ///< 0x81c [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range4_Low;  ///< 0x820 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range4_High;  ///< 0x824 [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range5_Low;  ///< 0x828 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range5_High;  ///< 0x82c [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range6_Low;  ///< 0x830 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range6_High;  ///< 0x834 [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range7_Low;  ///< 0x838 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range7_High;  ///< 0x83c [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range8_Low;  ///< 0x840 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range8_High;  ///< 0x844 [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range9_Low;  ///< 0x848 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range9_High;  ///< 0x84c [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range10_Low;  ///< 0x850 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range10_High;  ///< 0x854 [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range11_Low;  ///< 0x858 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range11_High;  ///< 0x85c [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range12_Low;  ///< 0x860 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range12_High;  ///< 0x864 [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range13_Low;  ///< 0x868 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range13_High;  ///< 0x86c [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range14_Low;  ///< 0x870 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range14_High;  ///< 0x874 [R/W]: MC Trustzone Range High Register
  volatile uint32_t TZ_Range15_Low;  ///< 0x878 [R/W]: MC Trustzone Range Low Register
  volatile uint32_t TZ_Range15_High;  ///< 0x87c [R/W]: MC Trustzone Range High Register
  volatile uint32_t reserved38[204];
  volatile uint32_t CH1_dram_read_timing;  ///< 0xbb0 [R/W]: DRAM read timing  control register
} MC_REGS_t;

#endif // MC
