/*
 * (C) Copyright 2011
 * Marvell Semiconductor <www.marvell.com>
 * Written-by: Lei Wen <leiwen@marvell.com>
 * Based of arch/arm/include/asm/arch-armada620/cpu.h
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301 USA
 */

#ifndef _PEGMATITE_CPU_H
#define _PEGMATITE_CPU_H

#include <asm/io.h>
#include <asm/system.h>

/*
 * Timer registers
 * Refer 6.2.9 in Datasheet
 */
struct pegmatitetimer_registers {
	u32 clk_ctrl;	/* Timer clk control reg */
	u32 match[9];	/* Timer match registers */
	u32 count[3];	/* Timer count registers */
	u32 status[3];
	u32 ie[3];
	u32 preload[3];	/* Timer preload value */
	u32 preload_ctrl[3];
	u32 wdt_match_en;
	u32 wdt_match_r;
	u32 wdt_val;
	u32 wdt_sts;
	u32 icr[3];
	u32 wdt_icr;
	u32 cer;	/* Timer count enable reg */
	u32 cmr;
	u32 ilr[3];
	u32 wcr;
	u32 wfar;
	u32 wsar;
	u32 cvwr[3];
};

/*
 * Functions
 */
int mv_sdh_init(u32 regbase, u32 max_clk, u32 min_clk, u32 quirks);

/* Special mmc tuning register */
#define SD_FIFO_PARAM		0x104
#define  CLK_GATE_ON		(1 << 9)
#define  CLK_GATE_CTL		(1 << 8)
#define  WTC_DEF		0x1
#define  WTC(x)			((x & 0x3) << 2)
#define  RTC_DEF		0x1
#define  RTC(x)			(x & 0x3)

#define SD_CLOCK_AND_BURST_SIZE_SETUP  0x10a
#define  SDCLK_DELAY(x)		((x & 0x1f) << 9)
#define  SDCLK_SEL		(1 << 8)
#define  WR_ENDIAN		(1 << 7)
#define  RD_ENDIAN		(1 << 6)
#define  DMA_FIFO_128		1
#define  DMA_SIZE(x)		((x & 0x3) << 2)
#define  BURST_64		1
#define  BURST_SIZE(x)		(x & 0x3)

#endif /* _PEGMATITE_CPU_H */
