/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <common.h>
#include <asm/arch/regAddrs.h>
#include <asm/arch/TIMERS_regmasks.h>
#include <asm/arch/TIMERS_regstructs.h>

/* The timer increments once per microsecond */
#define TIMER_FREQ (1000000)

int timer_init(void) {
    struct TIMERS_REGS_s *ts = (struct TIMERS_REGS_s *)APB_TMR_BASE;

    ts->TTCR1 = 0xffffffff;
    ts->TCR1  = TIMERS_TCR1_CONTMODE_MASK | (0 << TIMERS_TCR1_TIMEBASESEL_SHIFT);

    reset_timer( );

    return 0;
}

void reset_timer(void) {
    struct TIMERS_REGS_s *ts = (struct TIMERS_REGS_s *)APB_TMR_BASE;

    ts->TCR1 = TIMERS_TCR1_ENABLE_REPLACE_VAL(ts->TCR1, 0);
    ts->TCR1 = TIMERS_TCR1_ENABLE_REPLACE_VAL(ts->TCR1, 1);
}

ulong get_timer(ulong base) {
    struct TIMERS_REGS_s *ts = (struct TIMERS_REGS_s *)APB_TMR_BASE;

    return (((ulong)ts->TSR1 * (ulong)CONFIG_SYS_HZ / (ulong)TIMER_FREQ) - base);
}

void __udelay (unsigned long usec) {
    struct TIMERS_REGS_s *ts = (struct TIMERS_REGS_s *)APB_TMR_BASE;
    uint32_t start = ts->TSR1;
    uint32_t end = start + usec;

    /* Handle timer wraparound */
    if (end < start) {
        reset_timer( );
        end = usec;
    }

    while (ts->TSR1 < end);
}
