/*
 * cpu.c - Errata workarounds
 */

#include <config.h>
#include <asm/system.h>

#define SPECULATIVE_MODE_BIT (1 << 7)
#define PLDNOP_BIT           (1 << 25)
#define STREAMING_DEV_WRITES_BIT (1 << 29)
#define LDM_SINGLE_WORD_BIT  (1 << 12)

/* functions need the .type set so the linker knows that its alright to change bl to blx.
 * Using the macro below keeps us from typing the function name 3 times.
 */
#define LEAF(x) \
.globl x; \
.type x, %function; \
x:

#define END(x) \
.size x,.-x

.file "cpu.S"

LEAF(disable_speculative_mode)
    mrc p15, 1, r0, c15, c2, 0
    orr r0, r0, #SPECULATIVE_MODE_BIT
    mcr p15, 1, r0, c15, c2, 0
    mov pc, lr
END(disable_speculative_mode)

LEAF(disable_pld_instruction)
    mrc p15, 1, r0, c15, c1, 1
    orr r0, r0, #PLDNOP_BIT
    mcr p15, 1, r0, c15, c1, 1
    mov pc, lr
END( disable_pld_instruction)

LEAF(disable_streaming_device_writes)
    mrc p15, 1, r0, c15, c1, 2
    orr r0, r0, #STREAMING_DEV_WRITES_BIT
    mcr p15, 1, r0, c15, c1, 2
    dsb
    isb
    mov pc, lr
END(disable_streaming_device_writes)

LEAF(ldm_single_word)
    mrc p15, 1, r0, c15, c1, 0
    orr r0, r0, #LDM_SINGLE_WORD_BIT
    mcr p15, 1, r0, c15, c1, 0
    mov pc, lr
END(ldm_single_word)
