#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/input.h>
#include <linux/i2c.h>
#include <linux/gpio.h>
#include <linux/errno.h>
#include <linux/delay.h>
#include <linux/interrupt.h>
#include <linux/module.h>
#include <linux/device.h>
#include <linux/cdev.h>
#include <linux/fs.h>
#include <linux/poll.h>
#include <linux/timer.h>
#include <linux/platform_device.h>
#include <linux/syscalls.h>
#include <linux/clk.h>
#include <linux/slab.h>
#include <linux/workqueue.h>
#include <linux/kthread.h>
#include <asm/gpio.h>

#include "svinput.h"
#include "sv_led.h"

extern int i2c_master_sendrecv(const struct i2c_client *client, const char *sndbuf, int sndcount, char *rcvbuf, int rcvcount);
extern int i2c_master_recvsend(const struct i2c_client *client, char *rcvbuf, int rcvcount, const char *sndbuf, int sndcount);
extern int is_cheetah_ret;
extern unsigned char calc_sum(unsigned char *buf, int sum_pos);

static int s_led_is_opened = SVINPUT_FALSE;
static struct i2c_client *s_client = NULL;
static led_info_t s_led_info;

static struct timeval tv = {
	.tv_sec = 0,
	.tv_usec = 0,
};

int led_open(struct inode *inode, struct file *file)
{
	int rc = 0;
	s_led_is_opened = SVINPUT_TRUE;
	return rc;
}

int led_release(struct inode *inode, struct file *file)
{
	int rc = 0;
	s_led_is_opened = SVINPUT_FALSE;
	return rc;
}

void led_probe(struct i2c_client *client, const struct i2c_device_id *idp)
{
	int raw = 0;
	int col = 0;

	s_client = client;

	for (raw = 0; raw < MFPOPE_LED_SCAN_MAX; raw++) {
		for (col = 0; col < MFPOPE_LED_DATA_MAX; col++) {
			s_led_info.state[col][raw] = s_led_info.bt[col][raw] = s_led_info.que[col][raw] = s_led_info.sw[col][raw] = ST_OFF;
		}
	}

	return;
}

long led_ioctl(struct file *file, unsigned int cmd, unsigned long arg)
{
	int led_stat = 0;
	int col = 0;
	int raw = 0;
	int eco_led = 0;
	long rc = 0xffffffff;
	char recv_buf[I2C_RECV_BUF_SIZE] = {0};
	led_args_t led_args;
	svinput_mas_allled_cmd_t allled_onoff = {
		.hdr = ST1,
		.len = 0,
		/* cmd, sum */
	};
	svinput_mas_led_cmd_t led_onoff = {
		.hdr = ST1,
		.len = 2,
		/* cmd, led0, sum */
	};
	svinput_mas_allled_blink_stop_cmd_t allled_bl_stop = {
		.hdr = ST1,
		.cmd = 0x14,
		.len = 0,
		.sum = 0x14,
	};
	svinput_mas_allled_blink_start_cmd_t allled_bl_start = {
		.hdr = ST1,
		.cmd = 0x15,
		.len = 1,
		.sum = 0x16,
		/* bt, sum */
	};
	svinput_mas_led_blink_stop_cmd_t led_bl_stop = {
		.hdr = ST1,
		.cmd = 0x14,
		.len = 2,
		.sum = 0x16,
		/* que, bt, raw, col, sum */
	};
	svinput_mas_led_blink_stop_cmd_t led_bl_stop_for_jackal = {
		.hdr = ST1,
		.cmd = 0x14,
		.len = 3,
		.sum = 0x17,
		/* que, bt, raw, col, sum */
	};
	svinput_mas_led_blink_start_cmd_t led_bl_start = {
		.hdr = ST1,
		.cmd = 0x15,
		.len = 2,
		.sum = 0x17,
		/* que, bt, raw, col, sum */
	};
	svinput_mas_led_blink_start_cmd_t led_bl_start_for_jackal = {
		.hdr = ST1,
		.cmd = 0x15,
		.len = 4,
		.sum = 0x19,
		/* que, bt, raw, col, sum */
	};
#if 0
	svinput_mas_resv_led_cmd_t resv_led = {
		.hdr = ST1,
		.cmd = 0x16,
		.len = 1,
		/* sw, sum */
	};
#endif
	svinput_mas_pwm_led_cmd_t led_pwm_start_for_jackal = {
		.hdr = ST1,
		.cmd = 0x17,
		.len = 9,
		/* flg, tb, br, tdly, tl, th, brl, brh, led_no, sum */
	};
	

	FUNC_START;
	do_gettimeofday(&tv);
	
	if (!s_client) {
		rc = -1;
		goto EXIT_FUNC;
	}

	if ((cmd != LD_IOC_GET_LEDS_INFO) && (cmd != LD_IOC_ALL_LEDS_OFF) && (cmd != LD_IOC_ALL_LEDS_ON) &&
		(cmd != LD_IOC_ALL_LEDS_BLNK_STOP)) {
		rc = copy_from_user(&led_args, (void __user *)arg, sizeof(int));
		if (rc != 0) {
			rc = -1;
			goto EXIT_FUNC;
		}
	}

	switch (cmd) {
	/* 全LEDを消灯 or 点灯 */
	case LD_IOC_ALL_LEDS_OFF:
	case LD_IOC_ALL_LEDS_ON:
		DPRINTK("(%ld.%06ld)%s\n", tv.tv_sec, tv.tv_usec, (cmd == LD_IOC_ALL_LEDS_OFF) ? "LD_IOC_ALL_LEDS_OFF" : "LD_IOC_ALL_LEDS_ON");
		allled_onoff.cmd = (cmd == LD_IOC_ALL_LEDS_OFF) ? 0x10 : 0x11;
		allled_onoff.sum = ((allled_onoff.cmd + allled_onoff.len) & 0x00ff);
		rc = i2c_master_sendrecv(s_client, (char*)(&allled_onoff), sizeof(allled_onoff), recv_buf, sizeof(recv_buf));
		if (rc == -1) {
			FORCE_DPRINTK(KERN_NOTICE "Can't send backlight command (-_-;\n");
		}
		if (recv_buf[0] != PAK) {
			FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
		}
		if (rc == 0) {
			led_stat = (cmd == LD_IOC_ALL_LEDS_OFF) ? 0 : ST_ON;
			for (col = 0; col < MFPOPE_LED_DATA_MAX; col++) {
				for (raw = 0; raw < MFPOPE_LED_SCAN_MAX; raw++) {
					s_led_info.state[col][raw] = led_stat;
					s_led_info.bt[col][raw] = s_led_info.que[col][raw] = s_led_info.sw[col][raw] = 0;
				}
			}
		}
		break;
	/* 個別に指定したいLEDを消灯 or 点灯(DYNAMIC LED用) */
	case LD_IOC_DYNAMIC_LED_OFF:
	case LD_IOC_DYNAMIC_LED_ON:
		DPRINTK("(%ld.%06ld)%s\n", tv.tv_sec, tv.tv_usec, (cmd == LD_IOC_DYNAMIC_LED_OFF) ? "LD_IOC_DYNAMIC_LED_OFF" : "LD_IOC_DYNAMIC_LED_ON");
		if ((led_args.ledDataNo < 0) || (led_args.ledDataNo >= MFPOPE_LED_DATA_MAX)) {
			rc = -1;
			goto EXIT_FUNC;
		}
		if ((led_args.ledScanNo < 0) || (led_args.ledScanNo >= MFPOPE_LED_SCAN_MAX)) {
			rc = -1;
			goto EXIT_FUNC;
		}
		if (led_args.echo != (int)NULL) {
			eco_led = (int)(led_args.echo);
		}
		
		DPRINTK("LD_IOC_DYNAMIC_LED ledScanNo(0x%x), ledDataNo(0x%x) \n", led_args.ledScanNo, led_args.ledDataNo);
		if ( (cmd == LD_IOC_DYNAMIC_LED_ON) && (eco_led == ECO_LED_ON) && (led_args.ledScanNo == 5) && (led_args.ledDataNo == 4) )
		{
			int eco_led_flg	= ECO_LED_FLG;		/* FLG設定 */
			int eco_led_tdly= ECO_LED_TDLY;		/* 開始輝度からの変化待ち時間 (1/10ms) */
			int eco_led_tb	= ECO_LED_TB;		/* 輝度変化する間隔           (1/10ms) */
			int eco_led_br	= ECO_LED_BR;		/* 輝度変化量(1%-100%) */
			int eco_led_tl	= ECO_LED_TL;		/* 最小輝度時のタイマ時間     (1/10ms) */
			int eco_led_th	= ECO_LED_TH;		/* 最大輝度時のタイマ時間     (1/10ms) */
			int eco_led_brl	= ECO_LED_BRL;		/* 最小輝度値(1%-100%) */
			int eco_led_brh	= ECO_LED_BRH;		/* 最大輝度値(1%-100%) */
			
			DPRINTK("eco_led_flg  = 0x%x\n", eco_led_flg);
			DPRINTK("eco_led_tdly = %d\n", eco_led_tdly);
			DPRINTK("eco_led_tb   = %d\n", eco_led_tb);
			DPRINTK("eco_led_br   = %d\n", eco_led_br);
			DPRINTK("eco_led_tl   = %d\n", eco_led_tl);
			DPRINTK("eco_led_th   = %d\n", eco_led_th);
			DPRINTK("eco_led_brl  = %d\n", eco_led_brl);
			DPRINTK("eco_led_brh  = %d\n", eco_led_brh);
			
			led_pwm_start_for_jackal.cmd    = 0x17;
			led_pwm_start_for_jackal.len    = 9;
			led_pwm_start_for_jackal.flg    = eco_led_flg;
			led_pwm_start_for_jackal.tb     = eco_led_tb;
			led_pwm_start_for_jackal.br     = eco_led_br;
			led_pwm_start_for_jackal.tdly   = eco_led_tdly;
			led_pwm_start_for_jackal.tl     = eco_led_tl;
			led_pwm_start_for_jackal.th     = eco_led_th;
			led_pwm_start_for_jackal.brl    = eco_led_brl;
			led_pwm_start_for_jackal.brh    = eco_led_brh;
			led_pwm_start_for_jackal.led_no = LED_NO_ECHO;
			led_pwm_start_for_jackal.sum    = calc_sum((char*)(&led_pwm_start_for_jackal), sizeof(led_pwm_start_for_jackal) - 1);
			
			rc = i2c_master_sendrecv(s_client, (char*)(&led_pwm_start_for_jackal), sizeof(led_pwm_start_for_jackal), recv_buf, sizeof(recv_buf));
			if (rc == -1) {
				FORCE_DPRINTK(KERN_NOTICE "Can't send pwm led start command (-_-;\n");
			}
			if (recv_buf[0] != PAK) {
				FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
			}
			if (rc == 0) {
				s_led_info.state[led_args.ledScanNo][led_args.ledDataNo] = ST_ECHO;
			}
			s_led_info.bt[led_args.ledScanNo][led_args.ledDataNo]  = 0;
			s_led_info.que[led_args.ledScanNo][led_args.ledDataNo] = 0;
			s_led_info.sw[led_args.ledScanNo][led_args.ledDataNo]  = 0;
		}
		else
		{
			led_onoff.cmd = (cmd == LD_IOC_DYNAMIC_LED_OFF) ? 0x10 : 0x11;
			led_onoff.raw = led_args.ledDataNo;
			led_onoff.col = led_args.ledScanNo;
			led_onoff.sum = ((led_onoff.cmd + led_onoff.len + led_onoff.raw + led_onoff.col) & 0x00ff);
			rc = i2c_master_sendrecv(s_client, (char*)(&led_onoff), sizeof(led_onoff), recv_buf, sizeof(recv_buf));
			if (rc == -1) {
				FORCE_DPRINTK(KERN_NOTICE "Can't send backlight command (-_-;\n");
			}
			if (recv_buf[0] != PAK) {
				FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
			}
			if (rc == 0) {
				led_stat = (cmd == LD_IOC_DYNAMIC_LED_OFF) ? ST_OFF : ST_ON;
				s_led_info.state[led_args.ledScanNo][led_args.ledDataNo] = led_stat;
			}
		}
		break;
	/* 全LEDの点滅を停止 */
	case LD_IOC_ALL_LEDS_BLNK_STOP:
		DPRINTK("(%ld.%06ld)LD_IOC_ALL_LEDS_BLNK_STOP\n", tv.tv_sec, tv.tv_usec);
		rc = i2c_master_sendrecv(s_client, (char*)(&allled_bl_stop), sizeof(allled_bl_stop), recv_buf, sizeof(recv_buf));
		if (rc == -1) {
			FORCE_DPRINTK(KERN_NOTICE "Can't send backlight command (-_-;\n");
		}
		if (recv_buf[0] != PAK) {
			FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
		}
		if (rc == 0) {
			for (col = 0; col < MFPOPE_LED_DATA_MAX; col++) {
				for (raw = 0; raw < MFPOPE_LED_SCAN_MAX; raw++) {
					s_led_info.bt[col][raw] = 0;
					s_led_info.state[col][raw] = s_led_info.que[col][raw] = s_led_info.sw[col][raw] = 0;
				}
			}
		}
		break;
	/* 全LEDの点滅を開始 */
	case LD_IOC_ALL_LEDS_BLNK_START:
		DPRINTK("(%ld.%06ld)LD_IOC_ALL_LEDS_BLNK_START\n", tv.tv_sec, tv.tv_usec);
		allled_bl_start.bt = led_args.bt;
		allled_bl_start.sum = ((allled_bl_start.sum + allled_bl_start.bt) & 0x00ff);
		rc = i2c_master_sendrecv(s_client, (char*)(&allled_bl_start), sizeof(allled_bl_start), recv_buf, sizeof(recv_buf));
		if (rc == -1) {
			FORCE_DPRINTK(KERN_NOTICE "Can't send backlight command (-_-;\n");
		}
		if (recv_buf[0] != PAK) {
			FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
		}
		if (rc == 0) {
			for (col = 0; col < MFPOPE_LED_DATA_MAX; col++) {
				for (raw = 0; raw < MFPOPE_LED_SCAN_MAX; raw++) {
					s_led_info.state[col][raw] = ST_BLNK;
					s_led_info.bt[col][raw] = led_args.bt;
					s_led_info.que[col][raw] = s_led_info.sw[col][raw] = 0;
				}
			}
		}
		break;
	/* 個別に指定したLEDの点滅を停止/点滅 (DYNAMIC LED用) */
	case LD_IOC_DYNAMIC_LED_BLNK_STOP:
		DPRINTK("(%ld.%06ld)LD_IOC_DYNAMIC_LED_BLNK_STOP\n", tv.tv_sec, tv.tv_usec);
		if ((led_args.ledDataNo < 0) || (led_args.ledDataNo >= MFPOPE_LED_DATA_MAX)) {
			rc = -1;
			goto EXIT_FUNC;
		}
		if ((led_args.ledScanNo < 0) || (led_args.ledScanNo >= MFPOPE_LED_SCAN_MAX)) {
			rc = -1;
			goto EXIT_FUNC;
		}
		/* Cheetah用処理 */
		if (is_cheetah_ret == CHEETAH) {
			led_bl_stop.que = 0;/* 暫定でqueue無効 文句を言われたら考える */
			led_bl_stop.raw = led_args.ledDataNo;
			led_bl_stop.col = led_args.ledScanNo;
			led_bl_stop.sum = ((led_bl_stop.sum + led_bl_stop.raw + led_bl_stop.col) & 0x00ff);
			rc = i2c_master_sendrecv(s_client, (char*)(&led_bl_stop), sizeof(led_bl_stop), recv_buf, sizeof(recv_buf));
		}
		/* Jackal用処理 */
		else if (is_cheetah_ret == JACKAL) {
			led_bl_stop_for_jackal.que = 0;/* 暫定でqueue無効 文句を言われたら考える */
			led_bl_stop_for_jackal.raw = led_args.ledDataNo;
			led_bl_stop_for_jackal.col = led_args.ledScanNo;
			led_bl_stop_for_jackal.sum = ((led_bl_stop_for_jackal.sum + led_bl_stop_for_jackal.raw + led_bl_stop_for_jackal.col) & 0x00ff);
			rc = i2c_master_sendrecv(s_client, (char*)(&led_bl_stop_for_jackal), sizeof(led_bl_stop_for_jackal), recv_buf, sizeof(recv_buf));
		}
		if (rc == -1) {
			FORCE_DPRINTK(KERN_NOTICE "Can't send backlight command (-_-;\n");
		}
		if (recv_buf[0] != PAK) {
			FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
		}
		if (rc == 0) {
			s_led_info.state[led_args.ledScanNo][led_args.ledDataNo] = ST_OFF;
			s_led_info.bt[led_args.ledScanNo][led_args.ledDataNo] = 0;
		}
		break;
	case LD_IOC_DYNAMIC_LED_BLNK_START:
		DPRINTK("(%ld.%06ld)LD_IOC_DYNAMIC_LED_BLNK_START\n", tv.tv_sec, tv.tv_usec);
		if ((led_args.ledDataNo < 0) || (led_args.ledDataNo >= MFPOPE_LED_DATA_MAX)) {
			rc = -1;
			goto EXIT_FUNC;
		}
		if ((led_args.ledScanNo < 0) || (led_args.ledScanNo >= MFPOPE_LED_SCAN_MAX)) {
			rc = -1;
			goto EXIT_FUNC;
		}
		if (is_cheetah_ret == CHEETAH) {
			led_bl_start.que = 0;/* 暫定でqueue無効 文句を言われたら考える */
			led_bl_start.bt = led_args.bt;
			led_bl_start.raw = led_args.ledDataNo;
			led_bl_start.col = led_args.ledScanNo;
			led_bl_start.sum = ((led_bl_start.sum + led_bl_start.bt + led_bl_start.raw + led_bl_start.col) & 0x00ff);
			rc = i2c_master_sendrecv(s_client, (char*)(&led_bl_start), sizeof(led_bl_start), recv_buf, sizeof(recv_buf));
		}
		else if (is_cheetah_ret == JACKAL) {
			led_bl_start_for_jackal.que = 0;/* 暫定でqueue無効 文句を言われたら考える */
			led_bl_start_for_jackal.bt = led_args.bt;
			led_bl_start_for_jackal.raw = led_args.ledDataNo;
			led_bl_start_for_jackal.col = led_args.ledScanNo;
			led_bl_start_for_jackal.sum = ((led_bl_start_for_jackal.sum + led_bl_start_for_jackal.bt + led_bl_start_for_jackal.raw + led_bl_start_for_jackal.col) & 0x00ff);
			rc = i2c_master_sendrecv(s_client, (char*)(&led_bl_start_for_jackal), sizeof(led_bl_start_for_jackal), recv_buf, sizeof(recv_buf));
		}
		if (rc == -1) {
			FORCE_DPRINTK(KERN_NOTICE "Can't send backlight command (-_-;\n");
		}
		if (recv_buf[0] != PAK) {
			FORCE_DPRINTK(KERN_NOTICE "Can't recv slave ack(-_-;\n");
		}
		if (rc == 0) {
			s_led_info.state[led_args.ledScanNo][led_args.ledDataNo] = ST_BLNK;
			s_led_info.bt[led_args.ledScanNo][led_args.ledDataNo] = led_args.bt;
		}
		break;
	/* 各LEDの状態取得 */
	case LD_IOC_GET_LEDS_INFO:
		DPRINTK("(%ld.%06ld)LD_IOC_GET_LEDS_INFO\n", tv.tv_sec, tv.tv_usec);
		rc = copy_to_user((void __user *)arg, &s_led_info, sizeof(led_info_t));
		if (rc != 0) {
			rc = -1;
		}
		break;
	default:
		DPRINTK("Unknown command => 0x%02x\n", cmd);
		break;
	}

 EXIT_FUNC:
	FUNC_END;
	return rc;
}
