#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <poll.h>

typedef unsigned short uint16_t;
typedef unsigned int uint32_t;
#include "ctlope_inputevent.h"

#define SV_EV_KEY 1
#define SV_EV_TOUCH 2

static const char *evt_name[] = {
	"KEY_RELEASE",
	"KEY_PUSH",
	"KEY_REPEAT",
	"KEY_SPKEY",
};

typedef struct sv_tpanel_info {
	unsigned short pos_x;
	unsigned short pos_y;
	unsigned short press;
	unsigned short info;
} sv_tpanel_info_t;

int main(int argc, char** argv)
{
	int rc = 0;
	int key_fd = 0;
	int tpd_fd = 0;
	int cnt = 0;
	
	int max_fd = 0;
	fd_set fds, fds_base;

	sv_tpanel_info_t tpd_info;
	ope_input_event_t key_info;

	key_fd = open("/dev/opeinputevent", O_RDWR);
	if (key_fd < 0) {
		rc = key_fd;
		goto EXIT_FUNC;
	} else {
		printf("open(\"/dev/opeinputevent\", O_RDWR) = %d\n", key_fd);
	}

	tpd_fd = open("/dev/svtouch", O_RDWR);
	if (tpd_fd < 0) {
		rc = tpd_fd;
		goto EXIT_FUNC;
	} else {
		printf("open(\"/dev/svtouch\", O_RDWR) = %d\n", tpd_fd);
	}
	
	if (key_fd > tpd_fd) {
		max_fd = key_fd;
	} else {
		max_fd = tpd_fd;
	}
	
	FD_ZERO(&fds_base);
	FD_SET(key_fd, &fds_base);
	FD_SET(tpd_fd, &fds_base);
	
	for ( ; ; ) {
		printf("monitor start \n");
		
		memcpy(&fds, &fds_base, sizeof(fd_set));
		rc = select(max_fd+1, &fds, NULL, NULL, NULL);
		
		if (rc == -1) {
			/* error */
		} else if (rc) {
			if(FD_ISSET(tpd_fd, &fds))
			{
				rc = read(tpd_fd, &tpd_info, sizeof(tpd_info));
				if (rc == sizeof(tpd_info)) {
					printf("succeed to read axys!\n");
					printf("  pos_x = %u\n", tpd_info.pos_x);
					printf("  pos_y = %u\n", tpd_info.pos_y);
					printf("  press = %u\n", tpd_info.press);
				} else {
					printf("failed to read axis with rc = %d\n", rc);
				}
			}
			if(FD_ISSET(key_fd, &fds))
			{
				rc = read(key_fd, &key_info, sizeof(key_info));
				if (rc == sizeof(key_info)) {
					printf("succeed to read keyboard!\n");
					printf("  time.tv_sec=%d, time_tv_usec=%d\n", key_info.time.tv_sec, key_info.time.tv_usec);
					printf("  type=%s\n", (key_info.type == SV_EV_KEY) ? "SV_EV_KEY" : "SV_EV_TOUCH");
					printf("  key.code=0x%04x, key.status=%s\n", key_info.param.key.code, evt_name[key_info.param.key.status]);
				} else {
					printf("failed to read key event with rc=%d\n", rc);
				}
			}
		} else {
			/* time out */
		}
		

		
		

	}

	close(key_fd);
	close(tpd_fd);

 EXIT_FUNC:
	return rc;
}
